<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/perf.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/perf.plugin/metadata.yaml"
sidebar_label: "CPU performance"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# CPU performance


<img src="https://netdata.cloud/img/bolt.svg" width="150"/>


Plugin: perf.plugin
Module: perf.plugin

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors CPU performance metrics about cycles, instructions, migrations, cache operations and more.

It uses syscall (2) to open a file descriptior to monitor the perf events.

This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

It needs setuid to use necessary syscall to collect perf events. Netada sets the permission during installation time.

### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per CPU performance instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| perf.cpu_cycles | cpu, ref_cpu | cycles/s |
| perf.instructions | instructions | instructions/s |
| perf.instructions_per_cycle | ipc | instructions/cycle |
| perf.branch_instructions | instructions, misses | instructions/s |
| perf.cache | references, misses | operations/s |
| perf.bus_cycles | bus | cycles/s |
| perf.stalled_cycles | frontend, backend | cycles/s |
| perf.migrations | migrations | migrations |
| perf.alignment_faults | faults | faults |
| perf.emulation_faults | faults | faults |
| perf.l1d_cache | read_access, read_misses, write_access, write_misses | events/s |
| perf.l1d_cache_prefetch | prefetches | prefetches/s |
| perf.l1i_cache | read_access, read_misses | events/s |
| perf.ll_cache | read_access, read_misses, write_access, write_misses | events/s |
| perf.dtlb_cache | read_access, read_misses, write_access, write_misses | events/s |
| perf.itlb_cache | read_access, read_misses | events/s |
| perf.pbu_cache | read_access | events/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Install perf plugin

If you are [using our official native DEB/RPM packages](https://github.com/netdata/netdata/blob/master/packaging/installer/UPDATE.md#determine-which-installation-method-you-used), make sure the `netdata-plugin-perf` package is installed.


#### Enable the pref plugin

The plugin is disabled by default because the number of PMUs is usually quite limited and it is not desired to allow Netdata to struggle silently for PMUs, interfering with other performance monitoring software.

To enable it, use `edit-config` from the Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md), which is typically at `/etc/netdata`, to edit the `netdata.conf` file.

```bash
cd /etc/netdata   # Replace this path with your Netdata config directory, if different
sudo ./edit-config netdata.conf
```

Change the value of the `perf` setting to `yes` in the `[plugins]` section. Save the file and restart the Netdata Agent with `sudo systemctl restart netdata`, or the [appropriate method](https://github.com/netdata/netdata/blob/master/docs/configure/start-stop-restart.md) for your system.



### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:perf]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options

You can get the available options running:

```bash
/usr/libexec/netdata/plugins.d/perf.plugin  --help
````


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update every | Data collection frequency. | 1 | no |
| command options | Command options that specify charts shown by plugin. `cycles`, `instructions`, `branch`, `cache`, `bus`, `stalled`, `migrations`, `alignment`, `emulation`, `L1D`, `L1D-prefetch`, `L1I`, `LL`, `DTLB`, `ITLB`, `PBU`. | 1 | yes |

</details>

#### Examples

##### All metrics

Monitor all metrics available.

```yaml
[plugin:perf]
    command options = all

```
##### CPU cycles

Monitor CPU cycles.

<details><summary>Config</summary>

```yaml
[plugin:perf]
    command options = cycles

```
</details>



## Troubleshooting

### Debug Mode




