#line 5 "test_get.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 7
/*********************************************************************
 *   Copyright 1996, UCAR/Unidata
 *   See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *   $Id: test_get.m4,v 1.16 2005/03/08 03:04:19 ed Exp $
 *********************************************************************/

#line 31

#include "tests.h"

#line 116

void
#line 117
test_nc_get_var1_text(void)
#line 117
{
#line 117
    int ncid;
#line 117
    int i;
#line 117
    int j;
#line 117
    int err;
#line 117
    int nok = 0;      /* count of valid comparisons */
#line 117
    size_t index[MAX_RANK];
#line 117
    double expect;
#line 117
    int canConvert;     /* Both text or both numeric */
#line 117
    text value;
#line 117

#line 117
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 117
    IF (err)
#line 117
	error("nc_open: %s", nc_strerror(err));
#line 117
    for (i = 0; i < NVARS; i++) {
#line 117
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 117
	for (j = 0; j < var_rank[i]; j++)
#line 117
	    index[j] = 0;
#line 117
        err = nc_get_var1_text(BAD_ID, i, index, &value);
#line 117
        IF (err != NC_EBADID)
#line 117
	    error("bad ncid: status = %d", err);
#line 117
        err = nc_get_var1_text(ncid, BAD_VARID, index, &value);
#line 117
        IF (err != NC_ENOTVAR)
#line 117
	    error("bad var id: status = %d", err);
#line 117
	for (j = 0; j < var_rank[i]; j++) {
#line 117
	    index[j] = var_shape[i][j];
#line 117
	    err = nc_get_var1_text(ncid, i, index, &value);
#line 117
	    if(!canConvert) {
#line 117
		IF(err != NC_ECHAR)
#line 117
			error("conversion: status = %d", err);
#line 117
	    } else IF (err != NC_EINVALCOORDS)
#line 117
		error("bad index: status = %d", err);
#line 117
	    index[j] = 0;
#line 117
	}
#line 117
	for (j = 0; j < var_nels[i]; j++) {
#line 117
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 117
	    IF (err)
#line 117
		error("error in toMixedBase 1");
#line 117
	    expect = hash4( var_type[i], var_rank[i], index, NCT_TEXT );
#line 117
	    if (var_rank[i] == 0 && i%2 )
#line 117
		err = nc_get_var1_text(ncid, i, NULL, &value);
#line 117
	    else
#line 117
		err = nc_get_var1_text(ncid, i, index, &value);
#line 117
            if (canConvert) {
#line 117
		if (inRange3(expect,var_type[i], NCT_TEXT)) {
#line 117
		    if (expect >= text_min && expect <= text_max) {
#line 117
			IF (err) {
#line 117
			    error("%s", nc_strerror(err));
#line 117
			} else {
#line 117
			    IF (!equal(value,expect,var_type[i],NCT_TEXT)) {
#line 117
				error("expected: %G, got: %G", expect,
#line 117
				    (double) value);
#line 117
			    } else {
#line 117
				nok++;
#line 117
			    }
#line 117
			}
#line 117
		    } else {
#line 117
			IF (err != NC_ERANGE)
#line 117
			    error("Range error: status = %d", err);
#line 117
		    }
#line 117
                } else {
#line 117
                    IF (err != 0 && err != NC_ERANGE)
#line 117
                        error("OK or Range error: status = %d", err);
#line 117
		}
#line 117
	    } else {
#line 117
		IF (err != NC_ECHAR)
#line 117
		    error("wrong type: status = %d", err);
#line 117
	    }
#line 117
	}
#line 117
    }
#line 117
    err = nc_close(ncid);
#line 117
    IF (err)
#line 117
	error("nc_close: %s", nc_strerror(err));
#line 117
    print_nok(nok);
#line 117
}
#line 117

void
#line 118
test_nc_get_var1_uchar(void)
#line 118
{
#line 118
    int ncid;
#line 118
    int i;
#line 118
    int j;
#line 118
    int err;
#line 118
    int nok = 0;      /* count of valid comparisons */
#line 118
    size_t index[MAX_RANK];
#line 118
    double expect;
#line 118
    int canConvert;     /* Both text or both numeric */
#line 118
    uchar value;
#line 118

#line 118
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 118
    IF (err)
#line 118
	error("nc_open: %s", nc_strerror(err));
#line 118
    for (i = 0; i < NVARS; i++) {
#line 118
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 118
	for (j = 0; j < var_rank[i]; j++)
#line 118
	    index[j] = 0;
#line 118
        err = nc_get_var1_uchar(BAD_ID, i, index, &value);
#line 118
        IF (err != NC_EBADID)
#line 118
	    error("bad ncid: status = %d", err);
#line 118
        err = nc_get_var1_uchar(ncid, BAD_VARID, index, &value);
#line 118
        IF (err != NC_ENOTVAR)
#line 118
	    error("bad var id: status = %d", err);
#line 118
	for (j = 0; j < var_rank[i]; j++) {
#line 118
	    index[j] = var_shape[i][j];
#line 118
	    err = nc_get_var1_uchar(ncid, i, index, &value);
#line 118
	    if(!canConvert) {
#line 118
		IF(err != NC_ECHAR)
#line 118
			error("conversion: status = %d", err);
#line 118
	    } else IF (err != NC_EINVALCOORDS)
#line 118
		error("bad index: status = %d", err);
#line 118
	    index[j] = 0;
#line 118
	}
#line 118
	for (j = 0; j < var_nels[i]; j++) {
#line 118
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 118
	    IF (err)
#line 118
		error("error in toMixedBase 1");
#line 118
	    expect = hash4( var_type[i], var_rank[i], index, NCT_UCHAR );
#line 118
	    if (var_rank[i] == 0 && i%2 )
#line 118
		err = nc_get_var1_uchar(ncid, i, NULL, &value);
#line 118
	    else
#line 118
		err = nc_get_var1_uchar(ncid, i, index, &value);
#line 118
            if (canConvert) {
#line 118
		if (inRange3(expect,var_type[i], NCT_UCHAR)) {
#line 118
		    if (expect >= uchar_min && expect <= uchar_max) {
#line 118
			IF (err) {
#line 118
			    error("%s", nc_strerror(err));
#line 118
			} else {
#line 118
			    IF (!equal(value,expect,var_type[i],NCT_UCHAR)) {
#line 118
				error("expected: %G, got: %G", expect,
#line 118
				    (double) value);
#line 118
			    } else {
#line 118
				nok++;
#line 118
			    }
#line 118
			}
#line 118
		    } else {
#line 118
			IF (err != NC_ERANGE)
#line 118
			    error("Range error: status = %d", err);
#line 118
		    }
#line 118
                } else {
#line 118
                    IF (err != 0 && err != NC_ERANGE)
#line 118
                        error("OK or Range error: status = %d", err);
#line 118
		}
#line 118
	    } else {
#line 118
		IF (err != NC_ECHAR)
#line 118
		    error("wrong type: status = %d", err);
#line 118
	    }
#line 118
	}
#line 118
    }
#line 118
    err = nc_close(ncid);
#line 118
    IF (err)
#line 118
	error("nc_close: %s", nc_strerror(err));
#line 118
    print_nok(nok);
#line 118
}
#line 118

void
#line 119
test_nc_get_var1_schar(void)
#line 119
{
#line 119
    int ncid;
#line 119
    int i;
#line 119
    int j;
#line 119
    int err;
#line 119
    int nok = 0;      /* count of valid comparisons */
#line 119
    size_t index[MAX_RANK];
#line 119
    double expect;
#line 119
    int canConvert;     /* Both text or both numeric */
#line 119
    schar value;
#line 119

#line 119
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 119
    IF (err)
#line 119
	error("nc_open: %s", nc_strerror(err));
#line 119
    for (i = 0; i < NVARS; i++) {
#line 119
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 119
	for (j = 0; j < var_rank[i]; j++)
#line 119
	    index[j] = 0;
#line 119
        err = nc_get_var1_schar(BAD_ID, i, index, &value);
#line 119
        IF (err != NC_EBADID)
#line 119
	    error("bad ncid: status = %d", err);
#line 119
        err = nc_get_var1_schar(ncid, BAD_VARID, index, &value);
#line 119
        IF (err != NC_ENOTVAR)
#line 119
	    error("bad var id: status = %d", err);
#line 119
	for (j = 0; j < var_rank[i]; j++) {
#line 119
	    index[j] = var_shape[i][j];
#line 119
	    err = nc_get_var1_schar(ncid, i, index, &value);
#line 119
	    if(!canConvert) {
#line 119
		IF(err != NC_ECHAR)
#line 119
			error("conversion: status = %d", err);
#line 119
	    } else IF (err != NC_EINVALCOORDS)
#line 119
		error("bad index: status = %d", err);
#line 119
	    index[j] = 0;
#line 119
	}
#line 119
	for (j = 0; j < var_nels[i]; j++) {
#line 119
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 119
	    IF (err)
#line 119
		error("error in toMixedBase 1");
#line 119
	    expect = hash4( var_type[i], var_rank[i], index, NCT_SCHAR );
#line 119
	    if (var_rank[i] == 0 && i%2 )
#line 119
		err = nc_get_var1_schar(ncid, i, NULL, &value);
#line 119
	    else
#line 119
		err = nc_get_var1_schar(ncid, i, index, &value);
#line 119
            if (canConvert) {
#line 119
		if (inRange3(expect,var_type[i], NCT_SCHAR)) {
#line 119
		    if (expect >= schar_min && expect <= schar_max) {
#line 119
			IF (err) {
#line 119
			    error("%s", nc_strerror(err));
#line 119
			} else {
#line 119
			    IF (!equal(value,expect,var_type[i],NCT_SCHAR)) {
#line 119
				error("expected: %G, got: %G", expect,
#line 119
				    (double) value);
#line 119
			    } else {
#line 119
				nok++;
#line 119
			    }
#line 119
			}
#line 119
		    } else {
#line 119
			IF (err != NC_ERANGE)
#line 119
			    error("Range error: status = %d", err);
#line 119
		    }
#line 119
                } else {
#line 119
                    IF (err != 0 && err != NC_ERANGE)
#line 119
                        error("OK or Range error: status = %d", err);
#line 119
		}
#line 119
	    } else {
#line 119
		IF (err != NC_ECHAR)
#line 119
		    error("wrong type: status = %d", err);
#line 119
	    }
#line 119
	}
#line 119
    }
#line 119
    err = nc_close(ncid);
#line 119
    IF (err)
#line 119
	error("nc_close: %s", nc_strerror(err));
#line 119
    print_nok(nok);
#line 119
}
#line 119

void
#line 120
test_nc_get_var1_short(void)
#line 120
{
#line 120
    int ncid;
#line 120
    int i;
#line 120
    int j;
#line 120
    int err;
#line 120
    int nok = 0;      /* count of valid comparisons */
#line 120
    size_t index[MAX_RANK];
#line 120
    double expect;
#line 120
    int canConvert;     /* Both text or both numeric */
#line 120
    short value;
#line 120

#line 120
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 120
    IF (err)
#line 120
	error("nc_open: %s", nc_strerror(err));
#line 120
    for (i = 0; i < NVARS; i++) {
#line 120
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 120
	for (j = 0; j < var_rank[i]; j++)
#line 120
	    index[j] = 0;
#line 120
        err = nc_get_var1_short(BAD_ID, i, index, &value);
#line 120
        IF (err != NC_EBADID)
#line 120
	    error("bad ncid: status = %d", err);
#line 120
        err = nc_get_var1_short(ncid, BAD_VARID, index, &value);
#line 120
        IF (err != NC_ENOTVAR)
#line 120
	    error("bad var id: status = %d", err);
#line 120
	for (j = 0; j < var_rank[i]; j++) {
#line 120
	    index[j] = var_shape[i][j];
#line 120
	    err = nc_get_var1_short(ncid, i, index, &value);
#line 120
	    if(!canConvert) {
#line 120
		IF(err != NC_ECHAR)
#line 120
			error("conversion: status = %d", err);
#line 120
	    } else IF (err != NC_EINVALCOORDS)
#line 120
		error("bad index: status = %d", err);
#line 120
	    index[j] = 0;
#line 120
	}
#line 120
	for (j = 0; j < var_nels[i]; j++) {
#line 120
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 120
	    IF (err)
#line 120
		error("error in toMixedBase 1");
#line 120
	    expect = hash4( var_type[i], var_rank[i], index, NCT_SHORT );
#line 120
	    if (var_rank[i] == 0 && i%2 )
#line 120
		err = nc_get_var1_short(ncid, i, NULL, &value);
#line 120
	    else
#line 120
		err = nc_get_var1_short(ncid, i, index, &value);
#line 120
            if (canConvert) {
#line 120
		if (inRange3(expect,var_type[i], NCT_SHORT)) {
#line 120
		    if (expect >= short_min && expect <= short_max) {
#line 120
			IF (err) {
#line 120
			    error("%s", nc_strerror(err));
#line 120
			} else {
#line 120
			    IF (!equal(value,expect,var_type[i],NCT_SHORT)) {
#line 120
				error("expected: %G, got: %G", expect,
#line 120
				    (double) value);
#line 120
			    } else {
#line 120
				nok++;
#line 120
			    }
#line 120
			}
#line 120
		    } else {
#line 120
			IF (err != NC_ERANGE)
#line 120
			    error("Range error: status = %d", err);
#line 120
		    }
#line 120
                } else {
#line 120
                    IF (err != 0 && err != NC_ERANGE)
#line 120
                        error("OK or Range error: status = %d", err);
#line 120
		}
#line 120
	    } else {
#line 120
		IF (err != NC_ECHAR)
#line 120
		    error("wrong type: status = %d", err);
#line 120
	    }
#line 120
	}
#line 120
    }
#line 120
    err = nc_close(ncid);
#line 120
    IF (err)
#line 120
	error("nc_close: %s", nc_strerror(err));
#line 120
    print_nok(nok);
#line 120
}
#line 120

void
#line 121
test_nc_get_var1_int(void)
#line 121
{
#line 121
    int ncid;
#line 121
    int i;
#line 121
    int j;
#line 121
    int err;
#line 121
    int nok = 0;      /* count of valid comparisons */
#line 121
    size_t index[MAX_RANK];
#line 121
    double expect;
#line 121
    int canConvert;     /* Both text or both numeric */
#line 121
    int value;
#line 121

#line 121
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 121
    IF (err)
#line 121
	error("nc_open: %s", nc_strerror(err));
#line 121
    for (i = 0; i < NVARS; i++) {
#line 121
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 121
	for (j = 0; j < var_rank[i]; j++)
#line 121
	    index[j] = 0;
#line 121
        err = nc_get_var1_int(BAD_ID, i, index, &value);
#line 121
        IF (err != NC_EBADID)
#line 121
	    error("bad ncid: status = %d", err);
#line 121
        err = nc_get_var1_int(ncid, BAD_VARID, index, &value);
#line 121
        IF (err != NC_ENOTVAR)
#line 121
	    error("bad var id: status = %d", err);
#line 121
	for (j = 0; j < var_rank[i]; j++) {
#line 121
	    index[j] = var_shape[i][j];
#line 121
	    err = nc_get_var1_int(ncid, i, index, &value);
#line 121
	    if(!canConvert) {
#line 121
		IF(err != NC_ECHAR)
#line 121
			error("conversion: status = %d", err);
#line 121
	    } else IF (err != NC_EINVALCOORDS)
#line 121
		error("bad index: status = %d", err);
#line 121
	    index[j] = 0;
#line 121
	}
#line 121
	for (j = 0; j < var_nels[i]; j++) {
#line 121
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 121
	    IF (err)
#line 121
		error("error in toMixedBase 1");
#line 121
	    expect = hash4( var_type[i], var_rank[i], index, NCT_INT );
#line 121
	    if (var_rank[i] == 0 && i%2 )
#line 121
		err = nc_get_var1_int(ncid, i, NULL, &value);
#line 121
	    else
#line 121
		err = nc_get_var1_int(ncid, i, index, &value);
#line 121
            if (canConvert) {
#line 121
		if (inRange3(expect,var_type[i], NCT_INT)) {
#line 121
		    if (expect >= int_min && expect <= int_max) {
#line 121
			IF (err) {
#line 121
			    error("%s", nc_strerror(err));
#line 121
			} else {
#line 121
			    IF (!equal(value,expect,var_type[i],NCT_INT)) {
#line 121
				error("expected: %G, got: %G", expect,
#line 121
				    (double) value);
#line 121
			    } else {
#line 121
				nok++;
#line 121
			    }
#line 121
			}
#line 121
		    } else {
#line 121
			IF (err != NC_ERANGE)
#line 121
			    error("Range error: status = %d", err);
#line 121
		    }
#line 121
                } else {
#line 121
                    IF (err != 0 && err != NC_ERANGE)
#line 121
                        error("OK or Range error: status = %d", err);
#line 121
		}
#line 121
	    } else {
#line 121
		IF (err != NC_ECHAR)
#line 121
		    error("wrong type: status = %d", err);
#line 121
	    }
#line 121
	}
#line 121
    }
#line 121
    err = nc_close(ncid);
#line 121
    IF (err)
#line 121
	error("nc_close: %s", nc_strerror(err));
#line 121
    print_nok(nok);
#line 121
}
#line 121

void
#line 122
test_nc_get_var1_long(void)
#line 122
{
#line 122
    int ncid;
#line 122
    int i;
#line 122
    int j;
#line 122
    int err;
#line 122
    int nok = 0;      /* count of valid comparisons */
#line 122
    size_t index[MAX_RANK];
#line 122
    double expect;
#line 122
    int canConvert;     /* Both text or both numeric */
#line 122
    long value;
#line 122

#line 122
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 122
    IF (err)
#line 122
	error("nc_open: %s", nc_strerror(err));
#line 122
    for (i = 0; i < NVARS; i++) {
#line 122
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 122
	for (j = 0; j < var_rank[i]; j++)
#line 122
	    index[j] = 0;
#line 122
        err = nc_get_var1_long(BAD_ID, i, index, &value);
#line 122
        IF (err != NC_EBADID)
#line 122
	    error("bad ncid: status = %d", err);
#line 122
        err = nc_get_var1_long(ncid, BAD_VARID, index, &value);
#line 122
        IF (err != NC_ENOTVAR)
#line 122
	    error("bad var id: status = %d", err);
#line 122
	for (j = 0; j < var_rank[i]; j++) {
#line 122
	    index[j] = var_shape[i][j];
#line 122
	    err = nc_get_var1_long(ncid, i, index, &value);
#line 122
	    if(!canConvert) {
#line 122
		IF(err != NC_ECHAR)
#line 122
			error("conversion: status = %d", err);
#line 122
	    } else IF (err != NC_EINVALCOORDS)
#line 122
		error("bad index: status = %d", err);
#line 122
	    index[j] = 0;
#line 122
	}
#line 122
	for (j = 0; j < var_nels[i]; j++) {
#line 122
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 122
	    IF (err)
#line 122
		error("error in toMixedBase 1");
#line 122
	    expect = hash4( var_type[i], var_rank[i], index, NCT_LONG );
#line 122
	    if (var_rank[i] == 0 && i%2 )
#line 122
		err = nc_get_var1_long(ncid, i, NULL, &value);
#line 122
	    else
#line 122
		err = nc_get_var1_long(ncid, i, index, &value);
#line 122
            if (canConvert) {
#line 122
		if (inRange3(expect,var_type[i], NCT_LONG)) {
#line 122
		    if (expect >= long_min && expect <= long_max) {
#line 122
			IF (err) {
#line 122
			    error("%s", nc_strerror(err));
#line 122
			} else {
#line 122
			    IF (!equal(value,expect,var_type[i],NCT_LONG)) {
#line 122
				error("expected: %G, got: %G", expect,
#line 122
				    (double) value);
#line 122
			    } else {
#line 122
				nok++;
#line 122
			    }
#line 122
			}
#line 122
		    } else {
#line 122
			IF (err != NC_ERANGE)
#line 122
			    error("Range error: status = %d", err);
#line 122
		    }
#line 122
                } else {
#line 122
                    IF (err != 0 && err != NC_ERANGE)
#line 122
                        error("OK or Range error: status = %d", err);
#line 122
		}
#line 122
	    } else {
#line 122
		IF (err != NC_ECHAR)
#line 122
		    error("wrong type: status = %d", err);
#line 122
	    }
#line 122
	}
#line 122
    }
#line 122
    err = nc_close(ncid);
#line 122
    IF (err)
#line 122
	error("nc_close: %s", nc_strerror(err));
#line 122
    print_nok(nok);
#line 122
}
#line 122

void
#line 123
test_nc_get_var1_float(void)
#line 123
{
#line 123
    int ncid;
#line 123
    int i;
#line 123
    int j;
#line 123
    int err;
#line 123
    int nok = 0;      /* count of valid comparisons */
#line 123
    size_t index[MAX_RANK];
#line 123
    double expect;
#line 123
    int canConvert;     /* Both text or both numeric */
#line 123
    float value;
#line 123

#line 123
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 123
    IF (err)
#line 123
	error("nc_open: %s", nc_strerror(err));
#line 123
    for (i = 0; i < NVARS; i++) {
#line 123
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 123
	for (j = 0; j < var_rank[i]; j++)
#line 123
	    index[j] = 0;
#line 123
        err = nc_get_var1_float(BAD_ID, i, index, &value);
#line 123
        IF (err != NC_EBADID)
#line 123
	    error("bad ncid: status = %d", err);
#line 123
        err = nc_get_var1_float(ncid, BAD_VARID, index, &value);
#line 123
        IF (err != NC_ENOTVAR)
#line 123
	    error("bad var id: status = %d", err);
#line 123
	for (j = 0; j < var_rank[i]; j++) {
#line 123
	    index[j] = var_shape[i][j];
#line 123
	    err = nc_get_var1_float(ncid, i, index, &value);
#line 123
	    if(!canConvert) {
#line 123
		IF(err != NC_ECHAR)
#line 123
			error("conversion: status = %d", err);
#line 123
	    } else IF (err != NC_EINVALCOORDS)
#line 123
		error("bad index: status = %d", err);
#line 123
	    index[j] = 0;
#line 123
	}
#line 123
	for (j = 0; j < var_nels[i]; j++) {
#line 123
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 123
	    IF (err)
#line 123
		error("error in toMixedBase 1");
#line 123
	    expect = hash4( var_type[i], var_rank[i], index, NCT_FLOAT );
#line 123
	    if (var_rank[i] == 0 && i%2 )
#line 123
		err = nc_get_var1_float(ncid, i, NULL, &value);
#line 123
	    else
#line 123
		err = nc_get_var1_float(ncid, i, index, &value);
#line 123
            if (canConvert) {
#line 123
		if (inRange3(expect,var_type[i], NCT_FLOAT)) {
#line 123
		    if (expect >= float_min && expect <= float_max) {
#line 123
			IF (err) {
#line 123
			    error("%s", nc_strerror(err));
#line 123
			} else {
#line 123
			    IF (!equal(value,expect,var_type[i],NCT_FLOAT)) {
#line 123
				error("expected: %G, got: %G", expect,
#line 123
				    (double) value);
#line 123
			    } else {
#line 123
				nok++;
#line 123
			    }
#line 123
			}
#line 123
		    } else {
#line 123
			IF (err != NC_ERANGE)
#line 123
			    error("Range error: status = %d", err);
#line 123
		    }
#line 123
                } else {
#line 123
                    IF (err != 0 && err != NC_ERANGE)
#line 123
                        error("OK or Range error: status = %d", err);
#line 123
		}
#line 123
	    } else {
#line 123
		IF (err != NC_ECHAR)
#line 123
		    error("wrong type: status = %d", err);
#line 123
	    }
#line 123
	}
#line 123
    }
#line 123
    err = nc_close(ncid);
#line 123
    IF (err)
#line 123
	error("nc_close: %s", nc_strerror(err));
#line 123
    print_nok(nok);
#line 123
}
#line 123

void
#line 124
test_nc_get_var1_double(void)
#line 124
{
#line 124
    int ncid;
#line 124
    int i;
#line 124
    int j;
#line 124
    int err;
#line 124
    int nok = 0;      /* count of valid comparisons */
#line 124
    size_t index[MAX_RANK];
#line 124
    double expect;
#line 124
    int canConvert;     /* Both text or both numeric */
#line 124
    double value;
#line 124

#line 124
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 124
    IF (err)
#line 124
	error("nc_open: %s", nc_strerror(err));
#line 124
    for (i = 0; i < NVARS; i++) {
#line 124
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 124
	for (j = 0; j < var_rank[i]; j++)
#line 124
	    index[j] = 0;
#line 124
        err = nc_get_var1_double(BAD_ID, i, index, &value);
#line 124
        IF (err != NC_EBADID)
#line 124
	    error("bad ncid: status = %d", err);
#line 124
        err = nc_get_var1_double(ncid, BAD_VARID, index, &value);
#line 124
        IF (err != NC_ENOTVAR)
#line 124
	    error("bad var id: status = %d", err);
#line 124
	for (j = 0; j < var_rank[i]; j++) {
#line 124
	    index[j] = var_shape[i][j];
#line 124
	    err = nc_get_var1_double(ncid, i, index, &value);
#line 124
	    if(!canConvert) {
#line 124
		IF(err != NC_ECHAR)
#line 124
			error("conversion: status = %d", err);
#line 124
	    } else IF (err != NC_EINVALCOORDS)
#line 124
		error("bad index: status = %d", err);
#line 124
	    index[j] = 0;
#line 124
	}
#line 124
	for (j = 0; j < var_nels[i]; j++) {
#line 124
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 124
	    IF (err)
#line 124
		error("error in toMixedBase 1");
#line 124
	    expect = hash4( var_type[i], var_rank[i], index, NCT_DOUBLE );
#line 124
	    if (var_rank[i] == 0 && i%2 )
#line 124
		err = nc_get_var1_double(ncid, i, NULL, &value);
#line 124
	    else
#line 124
		err = nc_get_var1_double(ncid, i, index, &value);
#line 124
            if (canConvert) {
#line 124
		if (inRange3(expect,var_type[i], NCT_DOUBLE)) {
#line 124
		    if (expect >= double_min && expect <= double_max) {
#line 124
			IF (err) {
#line 124
			    error("%s", nc_strerror(err));
#line 124
			} else {
#line 124
			    IF (!equal(value,expect,var_type[i],NCT_DOUBLE)) {
#line 124
				error("expected: %G, got: %G", expect,
#line 124
				    (double) value);
#line 124
			    } else {
#line 124
				nok++;
#line 124
			    }
#line 124
			}
#line 124
		    } else {
#line 124
			IF (err != NC_ERANGE)
#line 124
			    error("Range error: status = %d", err);
#line 124
		    }
#line 124
                } else {
#line 124
                    IF (err != 0 && err != NC_ERANGE)
#line 124
                        error("OK or Range error: status = %d", err);
#line 124
		}
#line 124
	    } else {
#line 124
		IF (err != NC_ECHAR)
#line 124
		    error("wrong type: status = %d", err);
#line 124
	    }
#line 124
	}
#line 124
    }
#line 124
    err = nc_close(ncid);
#line 124
    IF (err)
#line 124
	error("nc_close: %s", nc_strerror(err));
#line 124
    print_nok(nok);
#line 124
}
#line 124



#line 221

void
#line 222
test_nc_get_var_text(void)
#line 222
{
#line 222
    int ncid;
#line 222
    int i;
#line 222
    int j;
#line 222
    int err;
#line 222
    int allInExtRange;	/* all values within external range? */
#line 222
    int allInIntRange;	/* all values within internal range? */
#line 222
    int nels;
#line 222
    int nok = 0;      /* count of valid comparisons */
#line 222
    size_t index[MAX_RANK];
#line 222
    int canConvert;     /* Both text or both numeric */
#line 222
    text value[MAX_NELS];
#line 222
    double expect[MAX_NELS];
#line 222

#line 222
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 222
    IF (err)
#line 222
	error("nc_open: %s", nc_strerror(err));
#line 222
    for (i = 0; i < NVARS; i++) {
#line 222
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 222
        assert(var_rank[i] <= MAX_RANK);
#line 222
        assert(var_nels[i] <= MAX_NELS);
#line 222
        err = nc_get_var_text(BAD_ID, i, value);
#line 222
        IF (err != NC_EBADID)
#line 222
	    error("bad ncid: status = %d", err);
#line 222
        err = nc_get_var_text(ncid, BAD_VARID, value);
#line 222
        IF (err != NC_ENOTVAR)
#line 222
	    error("bad var id: status = %d", err);
#line 222

#line 222
	nels = 1;
#line 222
	for (j = 0; j < var_rank[i]; j++) {
#line 222
	    nels *= var_shape[i][j];
#line 222
	}
#line 222
	allInExtRange = allInIntRange = 1;
#line 222
	for (j = 0; j < nels; j++) {
#line 222
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 222
	    IF (err)
#line 222
		error("error in toMixedBase 1");
#line 222
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_TEXT);
#line 222
	    if (inRange3(expect[j],var_type[i], NCT_TEXT)) {
#line 222
		allInIntRange = allInIntRange && expect[j] >= text_min
#line 222
			    && expect[j] <= text_max;
#line 222
	    } else {
#line 222
		allInExtRange = 0;
#line 222
	    }
#line 222
	}
#line 222
	err = nc_get_var_text(ncid, i, value);
#line 222
	if (canConvert) {
#line 222
	    if (allInExtRange) {
#line 222
		if (allInIntRange) {
#line 222
		    IF (err)
#line 222
			error("%s", nc_strerror(err));
#line 222
		} else {
#line 222
		    IF (err != NC_ERANGE)
#line 222
			error("Range error: status = %d", err);
#line 222
		}
#line 222
	    } else {
#line 222
		IF (err != 0 && err != NC_ERANGE)
#line 222
		    error("OK or Range error: status = %d", err);
#line 222
	    }
#line 222
	    for (j = 0; j < nels; j++) {
#line 222
		if (inRange3(expect[j],var_type[i],NCT_TEXT)
#line 222
			&& expect[j] >= text_min && expect[j] <= text_max) {
#line 222
		    IF (!equal(value[j],expect[j],var_type[i],NCT_TEXT)){
#line 222
			error("value read not that expected");
#line 222
			if (verbose) {
#line 222
			    error("\n");
#line 222
			    error("varid: %d, ", i);
#line 222
			    error("var_name: %s, ", var_name[i]);
#line 222
			    error("element number: %d ", j);
#line 222
			    error("expect: %g", expect[j]);
#line 222
			    error("got: %g", (double) value[j]);
#line 222
			}
#line 222
		    } else {
#line 222
			nok++;
#line 222
		    }
#line 222
		}
#line 222
	    }
#line 222
	} else {
#line 222
	    IF (nels > 0 && err != NC_ECHAR)
#line 222
		error("wrong type: status = %d", err);
#line 222
	}
#line 222
    }
#line 222
    err = nc_close(ncid);
#line 222
    IF (err)
#line 222
	error("nc_close: %s", nc_strerror(err));
#line 222
    print_nok(nok);
#line 222
}
#line 222

void
#line 223
test_nc_get_var_uchar(void)
#line 223
{
#line 223
    int ncid;
#line 223
    int i;
#line 223
    int j;
#line 223
    int err;
#line 223
    int allInExtRange;	/* all values within external range? */
#line 223
    int allInIntRange;	/* all values within internal range? */
#line 223
    int nels;
#line 223
    int nok = 0;      /* count of valid comparisons */
#line 223
    size_t index[MAX_RANK];
#line 223
    int canConvert;     /* Both text or both numeric */
#line 223
    uchar value[MAX_NELS];
#line 223
    double expect[MAX_NELS];
#line 223

#line 223
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 223
    IF (err)
#line 223
	error("nc_open: %s", nc_strerror(err));
#line 223
    for (i = 0; i < NVARS; i++) {
#line 223
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 223
        assert(var_rank[i] <= MAX_RANK);
#line 223
        assert(var_nels[i] <= MAX_NELS);
#line 223
        err = nc_get_var_uchar(BAD_ID, i, value);
#line 223
        IF (err != NC_EBADID)
#line 223
	    error("bad ncid: status = %d", err);
#line 223
        err = nc_get_var_uchar(ncid, BAD_VARID, value);
#line 223
        IF (err != NC_ENOTVAR)
#line 223
	    error("bad var id: status = %d", err);
#line 223

#line 223
	nels = 1;
#line 223
	for (j = 0; j < var_rank[i]; j++) {
#line 223
	    nels *= var_shape[i][j];
#line 223
	}
#line 223
	allInExtRange = allInIntRange = 1;
#line 223
	for (j = 0; j < nels; j++) {
#line 223
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 223
	    IF (err)
#line 223
		error("error in toMixedBase 1");
#line 223
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_UCHAR);
#line 223
	    if (inRange3(expect[j],var_type[i], NCT_UCHAR)) {
#line 223
		allInIntRange = allInIntRange && expect[j] >= uchar_min
#line 223
			    && expect[j] <= uchar_max;
#line 223
	    } else {
#line 223
		allInExtRange = 0;
#line 223
	    }
#line 223
	}
#line 223
	err = nc_get_var_uchar(ncid, i, value);
#line 223
	if (canConvert) {
#line 223
	    if (allInExtRange) {
#line 223
		if (allInIntRange) {
#line 223
		    IF (err)
#line 223
			error("%s", nc_strerror(err));
#line 223
		} else {
#line 223
		    IF (err != NC_ERANGE)
#line 223
			error("Range error: status = %d", err);
#line 223
		}
#line 223
	    } else {
#line 223
		IF (err != 0 && err != NC_ERANGE)
#line 223
		    error("OK or Range error: status = %d", err);
#line 223
	    }
#line 223
	    for (j = 0; j < nels; j++) {
#line 223
		if (inRange3(expect[j],var_type[i],NCT_UCHAR)
#line 223
			&& expect[j] >= uchar_min && expect[j] <= uchar_max) {
#line 223
		    IF (!equal(value[j],expect[j],var_type[i],NCT_UCHAR)){
#line 223
			error("value read not that expected");
#line 223
			if (verbose) {
#line 223
			    error("\n");
#line 223
			    error("varid: %d, ", i);
#line 223
			    error("var_name: %s, ", var_name[i]);
#line 223
			    error("element number: %d ", j);
#line 223
			    error("expect: %g", expect[j]);
#line 223
			    error("got: %g", (double) value[j]);
#line 223
			}
#line 223
		    } else {
#line 223
			nok++;
#line 223
		    }
#line 223
		}
#line 223
	    }
#line 223
	} else {
#line 223
	    IF (nels > 0 && err != NC_ECHAR)
#line 223
		error("wrong type: status = %d", err);
#line 223
	}
#line 223
    }
#line 223
    err = nc_close(ncid);
#line 223
    IF (err)
#line 223
	error("nc_close: %s", nc_strerror(err));
#line 223
    print_nok(nok);
#line 223
}
#line 223

void
#line 224
test_nc_get_var_schar(void)
#line 224
{
#line 224
    int ncid;
#line 224
    int i;
#line 224
    int j;
#line 224
    int err;
#line 224
    int allInExtRange;	/* all values within external range? */
#line 224
    int allInIntRange;	/* all values within internal range? */
#line 224
    int nels;
#line 224
    int nok = 0;      /* count of valid comparisons */
#line 224
    size_t index[MAX_RANK];
#line 224
    int canConvert;     /* Both text or both numeric */
#line 224
    schar value[MAX_NELS];
#line 224
    double expect[MAX_NELS];
#line 224

#line 224
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 224
    IF (err)
#line 224
	error("nc_open: %s", nc_strerror(err));
#line 224
    for (i = 0; i < NVARS; i++) {
#line 224
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 224
        assert(var_rank[i] <= MAX_RANK);
#line 224
        assert(var_nels[i] <= MAX_NELS);
#line 224
        err = nc_get_var_schar(BAD_ID, i, value);
#line 224
        IF (err != NC_EBADID)
#line 224
	    error("bad ncid: status = %d", err);
#line 224
        err = nc_get_var_schar(ncid, BAD_VARID, value);
#line 224
        IF (err != NC_ENOTVAR)
#line 224
	    error("bad var id: status = %d", err);
#line 224

#line 224
	nels = 1;
#line 224
	for (j = 0; j < var_rank[i]; j++) {
#line 224
	    nels *= var_shape[i][j];
#line 224
	}
#line 224
	allInExtRange = allInIntRange = 1;
#line 224
	for (j = 0; j < nels; j++) {
#line 224
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 224
	    IF (err)
#line 224
		error("error in toMixedBase 1");
#line 224
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_SCHAR);
#line 224
	    if (inRange3(expect[j],var_type[i], NCT_SCHAR)) {
#line 224
		allInIntRange = allInIntRange && expect[j] >= schar_min
#line 224
			    && expect[j] <= schar_max;
#line 224
	    } else {
#line 224
		allInExtRange = 0;
#line 224
	    }
#line 224
	}
#line 224
	err = nc_get_var_schar(ncid, i, value);
#line 224
	if (canConvert) {
#line 224
	    if (allInExtRange) {
#line 224
		if (allInIntRange) {
#line 224
		    IF (err)
#line 224
			error("%s", nc_strerror(err));
#line 224
		} else {
#line 224
		    IF (err != NC_ERANGE)
#line 224
			error("Range error: status = %d", err);
#line 224
		}
#line 224
	    } else {
#line 224
		IF (err != 0 && err != NC_ERANGE)
#line 224
		    error("OK or Range error: status = %d", err);
#line 224
	    }
#line 224
	    for (j = 0; j < nels; j++) {
#line 224
		if (inRange3(expect[j],var_type[i],NCT_SCHAR)
#line 224
			&& expect[j] >= schar_min && expect[j] <= schar_max) {
#line 224
		    IF (!equal(value[j],expect[j],var_type[i],NCT_SCHAR)){
#line 224
			error("value read not that expected");
#line 224
			if (verbose) {
#line 224
			    error("\n");
#line 224
			    error("varid: %d, ", i);
#line 224
			    error("var_name: %s, ", var_name[i]);
#line 224
			    error("element number: %d ", j);
#line 224
			    error("expect: %g", expect[j]);
#line 224
			    error("got: %g", (double) value[j]);
#line 224
			}
#line 224
		    } else {
#line 224
			nok++;
#line 224
		    }
#line 224
		}
#line 224
	    }
#line 224
	} else {
#line 224
	    IF (nels > 0 && err != NC_ECHAR)
#line 224
		error("wrong type: status = %d", err);
#line 224
	}
#line 224
    }
#line 224
    err = nc_close(ncid);
#line 224
    IF (err)
#line 224
	error("nc_close: %s", nc_strerror(err));
#line 224
    print_nok(nok);
#line 224
}
#line 224

void
#line 225
test_nc_get_var_short(void)
#line 225
{
#line 225
    int ncid;
#line 225
    int i;
#line 225
    int j;
#line 225
    int err;
#line 225
    int allInExtRange;	/* all values within external range? */
#line 225
    int allInIntRange;	/* all values within internal range? */
#line 225
    int nels;
#line 225
    int nok = 0;      /* count of valid comparisons */
#line 225
    size_t index[MAX_RANK];
#line 225
    int canConvert;     /* Both text or both numeric */
#line 225
    short value[MAX_NELS];
#line 225
    double expect[MAX_NELS];
#line 225

#line 225
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 225
    IF (err)
#line 225
	error("nc_open: %s", nc_strerror(err));
#line 225
    for (i = 0; i < NVARS; i++) {
#line 225
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 225
        assert(var_rank[i] <= MAX_RANK);
#line 225
        assert(var_nels[i] <= MAX_NELS);
#line 225
        err = nc_get_var_short(BAD_ID, i, value);
#line 225
        IF (err != NC_EBADID)
#line 225
	    error("bad ncid: status = %d", err);
#line 225
        err = nc_get_var_short(ncid, BAD_VARID, value);
#line 225
        IF (err != NC_ENOTVAR)
#line 225
	    error("bad var id: status = %d", err);
#line 225

#line 225
	nels = 1;
#line 225
	for (j = 0; j < var_rank[i]; j++) {
#line 225
	    nels *= var_shape[i][j];
#line 225
	}
#line 225
	allInExtRange = allInIntRange = 1;
#line 225
	for (j = 0; j < nels; j++) {
#line 225
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 225
	    IF (err)
#line 225
		error("error in toMixedBase 1");
#line 225
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_SHORT);
#line 225
	    if (inRange3(expect[j],var_type[i], NCT_SHORT)) {
#line 225
		allInIntRange = allInIntRange && expect[j] >= short_min
#line 225
			    && expect[j] <= short_max;
#line 225
	    } else {
#line 225
		allInExtRange = 0;
#line 225
	    }
#line 225
	}
#line 225
	err = nc_get_var_short(ncid, i, value);
#line 225
	if (canConvert) {
#line 225
	    if (allInExtRange) {
#line 225
		if (allInIntRange) {
#line 225
		    IF (err)
#line 225
			error("%s", nc_strerror(err));
#line 225
		} else {
#line 225
		    IF (err != NC_ERANGE)
#line 225
			error("Range error: status = %d", err);
#line 225
		}
#line 225
	    } else {
#line 225
		IF (err != 0 && err != NC_ERANGE)
#line 225
		    error("OK or Range error: status = %d", err);
#line 225
	    }
#line 225
	    for (j = 0; j < nels; j++) {
#line 225
		if (inRange3(expect[j],var_type[i],NCT_SHORT)
#line 225
			&& expect[j] >= short_min && expect[j] <= short_max) {
#line 225
		    IF (!equal(value[j],expect[j],var_type[i],NCT_SHORT)){
#line 225
			error("value read not that expected");
#line 225
			if (verbose) {
#line 225
			    error("\n");
#line 225
			    error("varid: %d, ", i);
#line 225
			    error("var_name: %s, ", var_name[i]);
#line 225
			    error("element number: %d ", j);
#line 225
			    error("expect: %g", expect[j]);
#line 225
			    error("got: %g", (double) value[j]);
#line 225
			}
#line 225
		    } else {
#line 225
			nok++;
#line 225
		    }
#line 225
		}
#line 225
	    }
#line 225
	} else {
#line 225
	    IF (nels > 0 && err != NC_ECHAR)
#line 225
		error("wrong type: status = %d", err);
#line 225
	}
#line 225
    }
#line 225
    err = nc_close(ncid);
#line 225
    IF (err)
#line 225
	error("nc_close: %s", nc_strerror(err));
#line 225
    print_nok(nok);
#line 225
}
#line 225

void
#line 226
test_nc_get_var_int(void)
#line 226
{
#line 226
    int ncid;
#line 226
    int i;
#line 226
    int j;
#line 226
    int err;
#line 226
    int allInExtRange;	/* all values within external range? */
#line 226
    int allInIntRange;	/* all values within internal range? */
#line 226
    int nels;
#line 226
    int nok = 0;      /* count of valid comparisons */
#line 226
    size_t index[MAX_RANK];
#line 226
    int canConvert;     /* Both text or both numeric */
#line 226
    int value[MAX_NELS];
#line 226
    double expect[MAX_NELS];
#line 226

#line 226
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 226
    IF (err)
#line 226
	error("nc_open: %s", nc_strerror(err));
#line 226
    for (i = 0; i < NVARS; i++) {
#line 226
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 226
        assert(var_rank[i] <= MAX_RANK);
#line 226
        assert(var_nels[i] <= MAX_NELS);
#line 226
        err = nc_get_var_int(BAD_ID, i, value);
#line 226
        IF (err != NC_EBADID)
#line 226
	    error("bad ncid: status = %d", err);
#line 226
        err = nc_get_var_int(ncid, BAD_VARID, value);
#line 226
        IF (err != NC_ENOTVAR)
#line 226
	    error("bad var id: status = %d", err);
#line 226

#line 226
	nels = 1;
#line 226
	for (j = 0; j < var_rank[i]; j++) {
#line 226
	    nels *= var_shape[i][j];
#line 226
	}
#line 226
	allInExtRange = allInIntRange = 1;
#line 226
	for (j = 0; j < nels; j++) {
#line 226
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 226
	    IF (err)
#line 226
		error("error in toMixedBase 1");
#line 226
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_INT);
#line 226
	    if (inRange3(expect[j],var_type[i], NCT_INT)) {
#line 226
		allInIntRange = allInIntRange && expect[j] >= int_min
#line 226
			    && expect[j] <= int_max;
#line 226
	    } else {
#line 226
		allInExtRange = 0;
#line 226
	    }
#line 226
	}
#line 226
	err = nc_get_var_int(ncid, i, value);
#line 226
	if (canConvert) {
#line 226
	    if (allInExtRange) {
#line 226
		if (allInIntRange) {
#line 226
		    IF (err)
#line 226
			error("%s", nc_strerror(err));
#line 226
		} else {
#line 226
		    IF (err != NC_ERANGE)
#line 226
			error("Range error: status = %d", err);
#line 226
		}
#line 226
	    } else {
#line 226
		IF (err != 0 && err != NC_ERANGE)
#line 226
		    error("OK or Range error: status = %d", err);
#line 226
	    }
#line 226
	    for (j = 0; j < nels; j++) {
#line 226
		if (inRange3(expect[j],var_type[i],NCT_INT)
#line 226
			&& expect[j] >= int_min && expect[j] <= int_max) {
#line 226
		    IF (!equal(value[j],expect[j],var_type[i],NCT_INT)){
#line 226
			error("value read not that expected");
#line 226
			if (verbose) {
#line 226
			    error("\n");
#line 226
			    error("varid: %d, ", i);
#line 226
			    error("var_name: %s, ", var_name[i]);
#line 226
			    error("element number: %d ", j);
#line 226
			    error("expect: %g", expect[j]);
#line 226
			    error("got: %g", (double) value[j]);
#line 226
			}
#line 226
		    } else {
#line 226
			nok++;
#line 226
		    }
#line 226
		}
#line 226
	    }
#line 226
	} else {
#line 226
	    IF (nels > 0 && err != NC_ECHAR)
#line 226
		error("wrong type: status = %d", err);
#line 226
	}
#line 226
    }
#line 226
    err = nc_close(ncid);
#line 226
    IF (err)
#line 226
	error("nc_close: %s", nc_strerror(err));
#line 226
    print_nok(nok);
#line 226
}
#line 226

void
#line 227
test_nc_get_var_long(void)
#line 227
{
#line 227
    int ncid;
#line 227
    int i;
#line 227
    int j;
#line 227
    int err;
#line 227
    int allInExtRange;	/* all values within external range? */
#line 227
    int allInIntRange;	/* all values within internal range? */
#line 227
    int nels;
#line 227
    int nok = 0;      /* count of valid comparisons */
#line 227
    size_t index[MAX_RANK];
#line 227
    int canConvert;     /* Both text or both numeric */
#line 227
    long value[MAX_NELS];
#line 227
    double expect[MAX_NELS];
#line 227

#line 227
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 227
    IF (err)
#line 227
	error("nc_open: %s", nc_strerror(err));
#line 227
    for (i = 0; i < NVARS; i++) {
#line 227
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 227
        assert(var_rank[i] <= MAX_RANK);
#line 227
        assert(var_nels[i] <= MAX_NELS);
#line 227
        err = nc_get_var_long(BAD_ID, i, value);
#line 227
        IF (err != NC_EBADID)
#line 227
	    error("bad ncid: status = %d", err);
#line 227
        err = nc_get_var_long(ncid, BAD_VARID, value);
#line 227
        IF (err != NC_ENOTVAR)
#line 227
	    error("bad var id: status = %d", err);
#line 227

#line 227
	nels = 1;
#line 227
	for (j = 0; j < var_rank[i]; j++) {
#line 227
	    nels *= var_shape[i][j];
#line 227
	}
#line 227
	allInExtRange = allInIntRange = 1;
#line 227
	for (j = 0; j < nels; j++) {
#line 227
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 227
	    IF (err)
#line 227
		error("error in toMixedBase 1");
#line 227
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_LONG);
#line 227
	    if (inRange3(expect[j],var_type[i], NCT_LONG)) {
#line 227
		allInIntRange = allInIntRange && expect[j] >= long_min
#line 227
			    && expect[j] <= long_max;
#line 227
	    } else {
#line 227
		allInExtRange = 0;
#line 227
	    }
#line 227
	}
#line 227
	err = nc_get_var_long(ncid, i, value);
#line 227
	if (canConvert) {
#line 227
	    if (allInExtRange) {
#line 227
		if (allInIntRange) {
#line 227
		    IF (err)
#line 227
			error("%s", nc_strerror(err));
#line 227
		} else {
#line 227
		    IF (err != NC_ERANGE)
#line 227
			error("Range error: status = %d", err);
#line 227
		}
#line 227
	    } else {
#line 227
		IF (err != 0 && err != NC_ERANGE)
#line 227
		    error("OK or Range error: status = %d", err);
#line 227
	    }
#line 227
	    for (j = 0; j < nels; j++) {
#line 227
		if (inRange3(expect[j],var_type[i],NCT_LONG)
#line 227
			&& expect[j] >= long_min && expect[j] <= long_max) {
#line 227
		    IF (!equal(value[j],expect[j],var_type[i],NCT_LONG)){
#line 227
			error("value read not that expected");
#line 227
			if (verbose) {
#line 227
			    error("\n");
#line 227
			    error("varid: %d, ", i);
#line 227
			    error("var_name: %s, ", var_name[i]);
#line 227
			    error("element number: %d ", j);
#line 227
			    error("expect: %g", expect[j]);
#line 227
			    error("got: %g", (double) value[j]);
#line 227
			}
#line 227
		    } else {
#line 227
			nok++;
#line 227
		    }
#line 227
		}
#line 227
	    }
#line 227
	} else {
#line 227
	    IF (nels > 0 && err != NC_ECHAR)
#line 227
		error("wrong type: status = %d", err);
#line 227
	}
#line 227
    }
#line 227
    err = nc_close(ncid);
#line 227
    IF (err)
#line 227
	error("nc_close: %s", nc_strerror(err));
#line 227
    print_nok(nok);
#line 227
}
#line 227

void
#line 228
test_nc_get_var_float(void)
#line 228
{
#line 228
    int ncid;
#line 228
    int i;
#line 228
    int j;
#line 228
    int err;
#line 228
    int allInExtRange;	/* all values within external range? */
#line 228
    int allInIntRange;	/* all values within internal range? */
#line 228
    int nels;
#line 228
    int nok = 0;      /* count of valid comparisons */
#line 228
    size_t index[MAX_RANK];
#line 228
    int canConvert;     /* Both text or both numeric */
#line 228
    float value[MAX_NELS];
#line 228
    double expect[MAX_NELS];
#line 228

#line 228
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 228
    IF (err)
#line 228
	error("nc_open: %s", nc_strerror(err));
#line 228
    for (i = 0; i < NVARS; i++) {
#line 228
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 228
        assert(var_rank[i] <= MAX_RANK);
#line 228
        assert(var_nels[i] <= MAX_NELS);
#line 228
        err = nc_get_var_float(BAD_ID, i, value);
#line 228
        IF (err != NC_EBADID)
#line 228
	    error("bad ncid: status = %d", err);
#line 228
        err = nc_get_var_float(ncid, BAD_VARID, value);
#line 228
        IF (err != NC_ENOTVAR)
#line 228
	    error("bad var id: status = %d", err);
#line 228

#line 228
	nels = 1;
#line 228
	for (j = 0; j < var_rank[i]; j++) {
#line 228
	    nels *= var_shape[i][j];
#line 228
	}
#line 228
	allInExtRange = allInIntRange = 1;
#line 228
	for (j = 0; j < nels; j++) {
#line 228
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 228
	    IF (err)
#line 228
		error("error in toMixedBase 1");
#line 228
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_FLOAT);
#line 228
	    if (inRange3(expect[j],var_type[i], NCT_FLOAT)) {
#line 228
		allInIntRange = allInIntRange && expect[j] >= float_min
#line 228
			    && expect[j] <= float_max;
#line 228
	    } else {
#line 228
		allInExtRange = 0;
#line 228
	    }
#line 228
	}
#line 228
	err = nc_get_var_float(ncid, i, value);
#line 228
	if (canConvert) {
#line 228
	    if (allInExtRange) {
#line 228
		if (allInIntRange) {
#line 228
		    IF (err)
#line 228
			error("%s", nc_strerror(err));
#line 228
		} else {
#line 228
		    IF (err != NC_ERANGE)
#line 228
			error("Range error: status = %d", err);
#line 228
		}
#line 228
	    } else {
#line 228
		IF (err != 0 && err != NC_ERANGE)
#line 228
		    error("OK or Range error: status = %d", err);
#line 228
	    }
#line 228
	    for (j = 0; j < nels; j++) {
#line 228
		if (inRange3(expect[j],var_type[i],NCT_FLOAT)
#line 228
			&& expect[j] >= float_min && expect[j] <= float_max) {
#line 228
		    IF (!equal(value[j],expect[j],var_type[i],NCT_FLOAT)){
#line 228
			error("value read not that expected");
#line 228
			if (verbose) {
#line 228
			    error("\n");
#line 228
			    error("varid: %d, ", i);
#line 228
			    error("var_name: %s, ", var_name[i]);
#line 228
			    error("element number: %d ", j);
#line 228
			    error("expect: %g", expect[j]);
#line 228
			    error("got: %g", (double) value[j]);
#line 228
			}
#line 228
		    } else {
#line 228
			nok++;
#line 228
		    }
#line 228
		}
#line 228
	    }
#line 228
	} else {
#line 228
	    IF (nels > 0 && err != NC_ECHAR)
#line 228
		error("wrong type: status = %d", err);
#line 228
	}
#line 228
    }
#line 228
    err = nc_close(ncid);
#line 228
    IF (err)
#line 228
	error("nc_close: %s", nc_strerror(err));
#line 228
    print_nok(nok);
#line 228
}
#line 228

void
#line 229
test_nc_get_var_double(void)
#line 229
{
#line 229
    int ncid;
#line 229
    int i;
#line 229
    int j;
#line 229
    int err;
#line 229
    int allInExtRange;	/* all values within external range? */
#line 229
    int allInIntRange;	/* all values within internal range? */
#line 229
    int nels;
#line 229
    int nok = 0;      /* count of valid comparisons */
#line 229
    size_t index[MAX_RANK];
#line 229
    int canConvert;     /* Both text or both numeric */
#line 229
    double value[MAX_NELS];
#line 229
    double expect[MAX_NELS];
#line 229

#line 229
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 229
    IF (err)
#line 229
	error("nc_open: %s", nc_strerror(err));
#line 229
    for (i = 0; i < NVARS; i++) {
#line 229
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 229
        assert(var_rank[i] <= MAX_RANK);
#line 229
        assert(var_nels[i] <= MAX_NELS);
#line 229
        err = nc_get_var_double(BAD_ID, i, value);
#line 229
        IF (err != NC_EBADID)
#line 229
	    error("bad ncid: status = %d", err);
#line 229
        err = nc_get_var_double(ncid, BAD_VARID, value);
#line 229
        IF (err != NC_ENOTVAR)
#line 229
	    error("bad var id: status = %d", err);
#line 229

#line 229
	nels = 1;
#line 229
	for (j = 0; j < var_rank[i]; j++) {
#line 229
	    nels *= var_shape[i][j];
#line 229
	}
#line 229
	allInExtRange = allInIntRange = 1;
#line 229
	for (j = 0; j < nels; j++) {
#line 229
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 229
	    IF (err)
#line 229
		error("error in toMixedBase 1");
#line 229
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 229
	    if (inRange3(expect[j],var_type[i], NCT_DOUBLE)) {
#line 229
		allInIntRange = allInIntRange && expect[j] >= double_min
#line 229
			    && expect[j] <= double_max;
#line 229
	    } else {
#line 229
		allInExtRange = 0;
#line 229
	    }
#line 229
	}
#line 229
	err = nc_get_var_double(ncid, i, value);
#line 229
	if (canConvert) {
#line 229
	    if (allInExtRange) {
#line 229
		if (allInIntRange) {
#line 229
		    IF (err)
#line 229
			error("%s", nc_strerror(err));
#line 229
		} else {
#line 229
		    IF (err != NC_ERANGE)
#line 229
			error("Range error: status = %d", err);
#line 229
		}
#line 229
	    } else {
#line 229
		IF (err != 0 && err != NC_ERANGE)
#line 229
		    error("OK or Range error: status = %d", err);
#line 229
	    }
#line 229
	    for (j = 0; j < nels; j++) {
#line 229
		if (inRange3(expect[j],var_type[i],NCT_DOUBLE)
#line 229
			&& expect[j] >= double_min && expect[j] <= double_max) {
#line 229
		    IF (!equal(value[j],expect[j],var_type[i],NCT_DOUBLE)){
#line 229
			error("value read not that expected");
#line 229
			if (verbose) {
#line 229
			    error("\n");
#line 229
			    error("varid: %d, ", i);
#line 229
			    error("var_name: %s, ", var_name[i]);
#line 229
			    error("element number: %d ", j);
#line 229
			    error("expect: %g", expect[j]);
#line 229
			    error("got: %g", (double) value[j]);
#line 229
			}
#line 229
		    } else {
#line 229
			nok++;
#line 229
		    }
#line 229
		}
#line 229
	    }
#line 229
	} else {
#line 229
	    IF (nels > 0 && err != NC_ECHAR)
#line 229
		error("wrong type: status = %d", err);
#line 229
	}
#line 229
    }
#line 229
    err = nc_close(ncid);
#line 229
    IF (err)
#line 229
	error("nc_close: %s", nc_strerror(err));
#line 229
    print_nok(nok);
#line 229
}
#line 229



#line 401

void
#line 402
test_nc_get_vara_text(void)
#line 402
{
#line 402
    int ncid;
#line 402
    int d;
#line 402
    int i;
#line 402
    int j;
#line 402
    int k;
#line 402
    int err;
#line 402
    int allInExtRange;	/* all values within external range? */
#line 402
    int allInIntRange;	/* all values within internal range? */
#line 402
    int nels;
#line 402
    int nslabs;
#line 402
    int nok = 0;      /* count of valid comparisons */
#line 402
    size_t start[MAX_RANK];
#line 402
    size_t edge[MAX_RANK];
#line 402
    size_t index[MAX_RANK];
#line 402
    size_t mid[MAX_RANK];
#line 402
    int canConvert;     /* Both text or both numeric */
#line 402
    text value[MAX_NELS];
#line 402
    double expect[MAX_NELS];
#line 402

#line 402
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 402
    IF (err)
#line 402
	error("nc_open: %s", nc_strerror(err));
#line 402
    for (i = 0; i < NVARS; i++) {
#line 402
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 402
        assert(var_rank[i] <= MAX_RANK);
#line 402
        assert(var_nels[i] <= MAX_NELS);
#line 402
	for (j = 0; j < var_rank[i]; j++) {
#line 402
	    start[j] = 0;
#line 402
	    edge[j] = 1;
#line 402
	}
#line 402
        err = nc_get_vara_text(BAD_ID, i, start, edge, value);
#line 402
        IF (err != NC_EBADID)
#line 402
	    error("bad ncid: status = %d", err);
#line 402
        err = nc_get_vara_text(ncid, BAD_VARID, start, edge, value);
#line 402
        IF (err != NC_ENOTVAR)
#line 402
	    error("bad var id: status = %d", err);
#line 402
	for (j = 0; j < var_rank[i]; j++) {
#line 402
	    start[j] = var_shape[i][j];
#line 402
	    err = nc_get_vara_text(ncid, i, start, edge, value);
#line 402
            IF (canConvert && err != NC_EINVALCOORDS)
#line 402
                error("bad index: status = %d", err);
#line 402
	    start[j] = 0;
#line 402
	    edge[j] = var_shape[i][j] + 1;
#line 402
	    err = nc_get_vara_text(ncid, i, start, edge, value);
#line 402
            IF (canConvert && err != NC_EEDGE)
#line 402
		error("bad edge: status = %d", err);
#line 402
	    edge[j] = 1;
#line 402
	}
#line 402
            /* Check non-scalars for correct error returned even when */
#line 402
            /* there is nothing to get (edge[j]==0) */
#line 402
	if(var_rank[i] > 0) {
#line 402
	    for (j = 0; j < var_rank[i]; j++) {
#line 402
		edge[j] = 0;
#line 402
	    }
#line 402
	    err = nc_get_vara_text(BAD_ID, i, start, edge, value);
#line 402
	    IF (err != NC_EBADID) 
#line 402
		error("bad ncid: status = %d", err);
#line 402
	    err = nc_get_vara_text(ncid, BAD_VARID, start, edge, value);
#line 402
	    IF (err != NC_ENOTVAR) 
#line 402
		error("bad var id: status = %d", err);
#line 402
	    for (j = 0; j < var_rank[i]; j++) {
#line 402
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 402
		    start[j] = var_shape[i][j];
#line 402
		    err = nc_get_vara_text(ncid, i, start, edge, value);
#line 402
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 402
			error("bad start: status = %d", err);
#line 402
		    start[j] = 0;
#line 402
		}
#line 402
	    }
#line 402
	    err = nc_get_vara_text(ncid, i, start, edge, value);
#line 402
	    if (canConvert) {
#line 402
		IF (err) 
#line 402
		    error("%s", nc_strerror(err));
#line 402
	    } else {
#line 402
		IF (err != NC_ECHAR)
#line 402
		    error("wrong type: status = %d", err);
#line 402
	    }
#line 402
	    for (j = 0; j < var_rank[i]; j++) {
#line 402
		edge[j] = 1;
#line 402
	    }
#line 402
	}            /* Choose a random point dividing each dim into 2 parts */
#line 402
            /* get 2^rank (nslabs) slabs so defined */
#line 402
        nslabs = 1;
#line 402
        for (j = 0; j < var_rank[i]; j++) {
#line 402
            mid[j] = roll( var_shape[i][j] );
#line 402
            nslabs *= 2;
#line 402
        }
#line 402
            /* bits of k determine whether to get lower or upper part of dim */
#line 402
        for (k = 0; k < nslabs; k++) {
#line 402
            nels = 1;
#line 402
            for (j = 0; j < var_rank[i]; j++) {
#line 402
                if ((k >> j) & 1) {
#line 402
                    start[j] = 0;
#line 402
                    edge[j] = mid[j];
#line 402
                }else{
#line 402
                    start[j] = mid[j];
#line 402
                    edge[j] = var_shape[i][j] - mid[j];
#line 402
                }
#line 402
                nels *= edge[j];
#line 402
            }
#line 402
	    allInExtRange = allInIntRange = 1;
#line 402
            for (j = 0; j < nels; j++) {
#line 402
                err = toMixedBase(j, var_rank[i], edge, index);
#line 402
                IF (err)
#line 402
                    error("error in toMixedBase 1");
#line 402
                for (d = 0; d < var_rank[i]; d++)
#line 402
                    index[d] += start[d];
#line 402
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_TEXT);
#line 402
		if (inRange3(expect[j],var_type[i], NCT_TEXT)) {
#line 402
		    allInIntRange = allInIntRange && expect[j] >= text_min
#line 402
				&& expect[j] <= text_max;
#line 402
		} else {
#line 402
		    allInExtRange = 0;
#line 402
		}
#line 402
	    }
#line 402
            if (var_rank[i] == 0 && i%2)
#line 402
		err = nc_get_vara_text(ncid, i, NULL, NULL, value);
#line 402
	    else
#line 402
		err = nc_get_vara_text(ncid, i, start, edge, value);
#line 402
            if (canConvert) {
#line 402
		if (allInExtRange) {
#line 402
		    if (allInIntRange) {
#line 402
			IF (err)
#line 402
			    error("%s", nc_strerror(err));
#line 402
		    } else {
#line 402
			IF (err != NC_ERANGE)
#line 402
			    error("Range error: status = %d", err);
#line 402
		    }
#line 402
		} else {
#line 402
		    IF (err != 0 && err != NC_ERANGE)
#line 402
			error("OK or Range error: status = %d", err);
#line 402
		}
#line 402
		for (j = 0; j < nels; j++) {
#line 402
		    if (inRange3(expect[j],var_type[i],NCT_TEXT)
#line 402
			    && expect[j] >= text_min && expect[j] <= text_max) {
#line 402
			IF (!equal(value[j],expect[j],var_type[i],NCT_TEXT)){
#line 402
			    error("value read not that expected");
#line 402
			    if (verbose) {
#line 402
				error("\n");
#line 402
				error("varid: %d, ", i);
#line 402
				error("var_name: %s, ", var_name[i]);
#line 402
				error("element number: %d ", j);
#line 402
				error("expect: %g", expect[j]);
#line 402
				error("got: %g", (double) value[j]);
#line 402
			    }
#line 402
			} else {
#line 402
			    nok++;
#line 402
			}
#line 402
		    }
#line 402
		}
#line 402
            } else {
#line 402
                IF (nels > 0 && err != NC_ECHAR)
#line 402
                    error("wrong type: status = %d", err);
#line 402
            }
#line 402
        }
#line 402
    }
#line 402
    err = nc_close(ncid);
#line 402
    IF (err)
#line 402
	error("nc_close: %s", nc_strerror(err));
#line 402
    print_nok(nok);
#line 402
}
#line 402

void
#line 403
test_nc_get_vara_uchar(void)
#line 403
{
#line 403
    int ncid;
#line 403
    int d;
#line 403
    int i;
#line 403
    int j;
#line 403
    int k;
#line 403
    int err;
#line 403
    int allInExtRange;	/* all values within external range? */
#line 403
    int allInIntRange;	/* all values within internal range? */
#line 403
    int nels;
#line 403
    int nslabs;
#line 403
    int nok = 0;      /* count of valid comparisons */
#line 403
    size_t start[MAX_RANK];
#line 403
    size_t edge[MAX_RANK];
#line 403
    size_t index[MAX_RANK];
#line 403
    size_t mid[MAX_RANK];
#line 403
    int canConvert;     /* Both text or both numeric */
#line 403
    uchar value[MAX_NELS];
#line 403
    double expect[MAX_NELS];
#line 403

#line 403
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 403
    IF (err)
#line 403
	error("nc_open: %s", nc_strerror(err));
#line 403
    for (i = 0; i < NVARS; i++) {
#line 403
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 403
        assert(var_rank[i] <= MAX_RANK);
#line 403
        assert(var_nels[i] <= MAX_NELS);
#line 403
	for (j = 0; j < var_rank[i]; j++) {
#line 403
	    start[j] = 0;
#line 403
	    edge[j] = 1;
#line 403
	}
#line 403
        err = nc_get_vara_uchar(BAD_ID, i, start, edge, value);
#line 403
        IF (err != NC_EBADID)
#line 403
	    error("bad ncid: status = %d", err);
#line 403
        err = nc_get_vara_uchar(ncid, BAD_VARID, start, edge, value);
#line 403
        IF (err != NC_ENOTVAR)
#line 403
	    error("bad var id: status = %d", err);
#line 403
	for (j = 0; j < var_rank[i]; j++) {
#line 403
	    start[j] = var_shape[i][j];
#line 403
	    err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 403
            IF (canConvert && err != NC_EINVALCOORDS)
#line 403
                error("bad index: status = %d", err);
#line 403
	    start[j] = 0;
#line 403
	    edge[j] = var_shape[i][j] + 1;
#line 403
	    err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 403
            IF (canConvert && err != NC_EEDGE)
#line 403
		error("bad edge: status = %d", err);
#line 403
	    edge[j] = 1;
#line 403
	}
#line 403
            /* Check non-scalars for correct error returned even when */
#line 403
            /* there is nothing to get (edge[j]==0) */
#line 403
	if(var_rank[i] > 0) {
#line 403
	    for (j = 0; j < var_rank[i]; j++) {
#line 403
		edge[j] = 0;
#line 403
	    }
#line 403
	    err = nc_get_vara_uchar(BAD_ID, i, start, edge, value);
#line 403
	    IF (err != NC_EBADID) 
#line 403
		error("bad ncid: status = %d", err);
#line 403
	    err = nc_get_vara_uchar(ncid, BAD_VARID, start, edge, value);
#line 403
	    IF (err != NC_ENOTVAR) 
#line 403
		error("bad var id: status = %d", err);
#line 403
	    for (j = 0; j < var_rank[i]; j++) {
#line 403
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 403
		    start[j] = var_shape[i][j];
#line 403
		    err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 403
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 403
			error("bad start: status = %d", err);
#line 403
		    start[j] = 0;
#line 403
		}
#line 403
	    }
#line 403
	    err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 403
	    if (canConvert) {
#line 403
		IF (err) 
#line 403
		    error("%s", nc_strerror(err));
#line 403
	    } else {
#line 403
		IF (err != NC_ECHAR)
#line 403
		    error("wrong type: status = %d", err);
#line 403
	    }
#line 403
	    for (j = 0; j < var_rank[i]; j++) {
#line 403
		edge[j] = 1;
#line 403
	    }
#line 403
	}            /* Choose a random point dividing each dim into 2 parts */
#line 403
            /* get 2^rank (nslabs) slabs so defined */
#line 403
        nslabs = 1;
#line 403
        for (j = 0; j < var_rank[i]; j++) {
#line 403
            mid[j] = roll( var_shape[i][j] );
#line 403
            nslabs *= 2;
#line 403
        }
#line 403
            /* bits of k determine whether to get lower or upper part of dim */
#line 403
        for (k = 0; k < nslabs; k++) {
#line 403
            nels = 1;
#line 403
            for (j = 0; j < var_rank[i]; j++) {
#line 403
                if ((k >> j) & 1) {
#line 403
                    start[j] = 0;
#line 403
                    edge[j] = mid[j];
#line 403
                }else{
#line 403
                    start[j] = mid[j];
#line 403
                    edge[j] = var_shape[i][j] - mid[j];
#line 403
                }
#line 403
                nels *= edge[j];
#line 403
            }
#line 403
	    allInExtRange = allInIntRange = 1;
#line 403
            for (j = 0; j < nels; j++) {
#line 403
                err = toMixedBase(j, var_rank[i], edge, index);
#line 403
                IF (err)
#line 403
                    error("error in toMixedBase 1");
#line 403
                for (d = 0; d < var_rank[i]; d++)
#line 403
                    index[d] += start[d];
#line 403
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_UCHAR);
#line 403
		if (inRange3(expect[j],var_type[i], NCT_UCHAR)) {
#line 403
		    allInIntRange = allInIntRange && expect[j] >= uchar_min
#line 403
				&& expect[j] <= uchar_max;
#line 403
		} else {
#line 403
		    allInExtRange = 0;
#line 403
		}
#line 403
	    }
#line 403
            if (var_rank[i] == 0 && i%2)
#line 403
		err = nc_get_vara_uchar(ncid, i, NULL, NULL, value);
#line 403
	    else
#line 403
		err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 403
            if (canConvert) {
#line 403
		if (allInExtRange) {
#line 403
		    if (allInIntRange) {
#line 403
			IF (err)
#line 403
			    error("%s", nc_strerror(err));
#line 403
		    } else {
#line 403
			IF (err != NC_ERANGE)
#line 403
			    error("Range error: status = %d", err);
#line 403
		    }
#line 403
		} else {
#line 403
		    IF (err != 0 && err != NC_ERANGE)
#line 403
			error("OK or Range error: status = %d", err);
#line 403
		}
#line 403
		for (j = 0; j < nels; j++) {
#line 403
		    if (inRange3(expect[j],var_type[i],NCT_UCHAR)
#line 403
			    && expect[j] >= uchar_min && expect[j] <= uchar_max) {
#line 403
			IF (!equal(value[j],expect[j],var_type[i],NCT_UCHAR)){
#line 403
			    error("value read not that expected");
#line 403
			    if (verbose) {
#line 403
				error("\n");
#line 403
				error("varid: %d, ", i);
#line 403
				error("var_name: %s, ", var_name[i]);
#line 403
				error("element number: %d ", j);
#line 403
				error("expect: %g", expect[j]);
#line 403
				error("got: %g", (double) value[j]);
#line 403
			    }
#line 403
			} else {
#line 403
			    nok++;
#line 403
			}
#line 403
		    }
#line 403
		}
#line 403
            } else {
#line 403
                IF (nels > 0 && err != NC_ECHAR)
#line 403
                    error("wrong type: status = %d", err);
#line 403
            }
#line 403
        }
#line 403
    }
#line 403
    err = nc_close(ncid);
#line 403
    IF (err)
#line 403
	error("nc_close: %s", nc_strerror(err));
#line 403
    print_nok(nok);
#line 403
}
#line 403

void
#line 404
test_nc_get_vara_schar(void)
#line 404
{
#line 404
    int ncid;
#line 404
    int d;
#line 404
    int i;
#line 404
    int j;
#line 404
    int k;
#line 404
    int err;
#line 404
    int allInExtRange;	/* all values within external range? */
#line 404
    int allInIntRange;	/* all values within internal range? */
#line 404
    int nels;
#line 404
    int nslabs;
#line 404
    int nok = 0;      /* count of valid comparisons */
#line 404
    size_t start[MAX_RANK];
#line 404
    size_t edge[MAX_RANK];
#line 404
    size_t index[MAX_RANK];
#line 404
    size_t mid[MAX_RANK];
#line 404
    int canConvert;     /* Both text or both numeric */
#line 404
    schar value[MAX_NELS];
#line 404
    double expect[MAX_NELS];
#line 404

#line 404
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 404
    IF (err)
#line 404
	error("nc_open: %s", nc_strerror(err));
#line 404
    for (i = 0; i < NVARS; i++) {
#line 404
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 404
        assert(var_rank[i] <= MAX_RANK);
#line 404
        assert(var_nels[i] <= MAX_NELS);
#line 404
	for (j = 0; j < var_rank[i]; j++) {
#line 404
	    start[j] = 0;
#line 404
	    edge[j] = 1;
#line 404
	}
#line 404
        err = nc_get_vara_schar(BAD_ID, i, start, edge, value);
#line 404
        IF (err != NC_EBADID)
#line 404
	    error("bad ncid: status = %d", err);
#line 404
        err = nc_get_vara_schar(ncid, BAD_VARID, start, edge, value);
#line 404
        IF (err != NC_ENOTVAR)
#line 404
	    error("bad var id: status = %d", err);
#line 404
	for (j = 0; j < var_rank[i]; j++) {
#line 404
	    start[j] = var_shape[i][j];
#line 404
	    err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 404
            IF (canConvert && err != NC_EINVALCOORDS)
#line 404
                error("bad index: status = %d", err);
#line 404
	    start[j] = 0;
#line 404
	    edge[j] = var_shape[i][j] + 1;
#line 404
	    err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 404
            IF (canConvert && err != NC_EEDGE)
#line 404
		error("bad edge: status = %d", err);
#line 404
	    edge[j] = 1;
#line 404
	}
#line 404
            /* Check non-scalars for correct error returned even when */
#line 404
            /* there is nothing to get (edge[j]==0) */
#line 404
	if(var_rank[i] > 0) {
#line 404
	    for (j = 0; j < var_rank[i]; j++) {
#line 404
		edge[j] = 0;
#line 404
	    }
#line 404
	    err = nc_get_vara_schar(BAD_ID, i, start, edge, value);
#line 404
	    IF (err != NC_EBADID) 
#line 404
		error("bad ncid: status = %d", err);
#line 404
	    err = nc_get_vara_schar(ncid, BAD_VARID, start, edge, value);
#line 404
	    IF (err != NC_ENOTVAR) 
#line 404
		error("bad var id: status = %d", err);
#line 404
	    for (j = 0; j < var_rank[i]; j++) {
#line 404
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 404
		    start[j] = var_shape[i][j];
#line 404
		    err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 404
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 404
			error("bad start: status = %d", err);
#line 404
		    start[j] = 0;
#line 404
		}
#line 404
	    }
#line 404
	    err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 404
	    if (canConvert) {
#line 404
		IF (err) 
#line 404
		    error("%s", nc_strerror(err));
#line 404
	    } else {
#line 404
		IF (err != NC_ECHAR)
#line 404
		    error("wrong type: status = %d", err);
#line 404
	    }
#line 404
	    for (j = 0; j < var_rank[i]; j++) {
#line 404
		edge[j] = 1;
#line 404
	    }
#line 404
	}            /* Choose a random point dividing each dim into 2 parts */
#line 404
            /* get 2^rank (nslabs) slabs so defined */
#line 404
        nslabs = 1;
#line 404
        for (j = 0; j < var_rank[i]; j++) {
#line 404
            mid[j] = roll( var_shape[i][j] );
#line 404
            nslabs *= 2;
#line 404
        }
#line 404
            /* bits of k determine whether to get lower or upper part of dim */
#line 404
        for (k = 0; k < nslabs; k++) {
#line 404
            nels = 1;
#line 404
            for (j = 0; j < var_rank[i]; j++) {
#line 404
                if ((k >> j) & 1) {
#line 404
                    start[j] = 0;
#line 404
                    edge[j] = mid[j];
#line 404
                }else{
#line 404
                    start[j] = mid[j];
#line 404
                    edge[j] = var_shape[i][j] - mid[j];
#line 404
                }
#line 404
                nels *= edge[j];
#line 404
            }
#line 404
	    allInExtRange = allInIntRange = 1;
#line 404
            for (j = 0; j < nels; j++) {
#line 404
                err = toMixedBase(j, var_rank[i], edge, index);
#line 404
                IF (err)
#line 404
                    error("error in toMixedBase 1");
#line 404
                for (d = 0; d < var_rank[i]; d++)
#line 404
                    index[d] += start[d];
#line 404
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_SCHAR);
#line 404
		if (inRange3(expect[j],var_type[i], NCT_SCHAR)) {
#line 404
		    allInIntRange = allInIntRange && expect[j] >= schar_min
#line 404
				&& expect[j] <= schar_max;
#line 404
		} else {
#line 404
		    allInExtRange = 0;
#line 404
		}
#line 404
	    }
#line 404
            if (var_rank[i] == 0 && i%2)
#line 404
		err = nc_get_vara_schar(ncid, i, NULL, NULL, value);
#line 404
	    else
#line 404
		err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 404
            if (canConvert) {
#line 404
		if (allInExtRange) {
#line 404
		    if (allInIntRange) {
#line 404
			IF (err)
#line 404
			    error("%s", nc_strerror(err));
#line 404
		    } else {
#line 404
			IF (err != NC_ERANGE)
#line 404
			    error("Range error: status = %d", err);
#line 404
		    }
#line 404
		} else {
#line 404
		    IF (err != 0 && err != NC_ERANGE)
#line 404
			error("OK or Range error: status = %d", err);
#line 404
		}
#line 404
		for (j = 0; j < nels; j++) {
#line 404
		    if (inRange3(expect[j],var_type[i],NCT_SCHAR)
#line 404
			    && expect[j] >= schar_min && expect[j] <= schar_max) {
#line 404
			IF (!equal(value[j],expect[j],var_type[i],NCT_SCHAR)){
#line 404
			    error("value read not that expected");
#line 404
			    if (verbose) {
#line 404
				error("\n");
#line 404
				error("varid: %d, ", i);
#line 404
				error("var_name: %s, ", var_name[i]);
#line 404
				error("element number: %d ", j);
#line 404
				error("expect: %g", expect[j]);
#line 404
				error("got: %g", (double) value[j]);
#line 404
			    }
#line 404
			} else {
#line 404
			    nok++;
#line 404
			}
#line 404
		    }
#line 404
		}
#line 404
            } else {
#line 404
                IF (nels > 0 && err != NC_ECHAR)
#line 404
                    error("wrong type: status = %d", err);
#line 404
            }
#line 404
        }
#line 404
    }
#line 404
    err = nc_close(ncid);
#line 404
    IF (err)
#line 404
	error("nc_close: %s", nc_strerror(err));
#line 404
    print_nok(nok);
#line 404
}
#line 404

void
#line 405
test_nc_get_vara_short(void)
#line 405
{
#line 405
    int ncid;
#line 405
    int d;
#line 405
    int i;
#line 405
    int j;
#line 405
    int k;
#line 405
    int err;
#line 405
    int allInExtRange;	/* all values within external range? */
#line 405
    int allInIntRange;	/* all values within internal range? */
#line 405
    int nels;
#line 405
    int nslabs;
#line 405
    int nok = 0;      /* count of valid comparisons */
#line 405
    size_t start[MAX_RANK];
#line 405
    size_t edge[MAX_RANK];
#line 405
    size_t index[MAX_RANK];
#line 405
    size_t mid[MAX_RANK];
#line 405
    int canConvert;     /* Both text or both numeric */
#line 405
    short value[MAX_NELS];
#line 405
    double expect[MAX_NELS];
#line 405

#line 405
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 405
    IF (err)
#line 405
	error("nc_open: %s", nc_strerror(err));
#line 405
    for (i = 0; i < NVARS; i++) {
#line 405
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 405
        assert(var_rank[i] <= MAX_RANK);
#line 405
        assert(var_nels[i] <= MAX_NELS);
#line 405
	for (j = 0; j < var_rank[i]; j++) {
#line 405
	    start[j] = 0;
#line 405
	    edge[j] = 1;
#line 405
	}
#line 405
        err = nc_get_vara_short(BAD_ID, i, start, edge, value);
#line 405
        IF (err != NC_EBADID)
#line 405
	    error("bad ncid: status = %d", err);
#line 405
        err = nc_get_vara_short(ncid, BAD_VARID, start, edge, value);
#line 405
        IF (err != NC_ENOTVAR)
#line 405
	    error("bad var id: status = %d", err);
#line 405
	for (j = 0; j < var_rank[i]; j++) {
#line 405
	    start[j] = var_shape[i][j];
#line 405
	    err = nc_get_vara_short(ncid, i, start, edge, value);
#line 405
            IF (canConvert && err != NC_EINVALCOORDS)
#line 405
                error("bad index: status = %d", err);
#line 405
	    start[j] = 0;
#line 405
	    edge[j] = var_shape[i][j] + 1;
#line 405
	    err = nc_get_vara_short(ncid, i, start, edge, value);
#line 405
            IF (canConvert && err != NC_EEDGE)
#line 405
		error("bad edge: status = %d", err);
#line 405
	    edge[j] = 1;
#line 405
	}
#line 405
            /* Check non-scalars for correct error returned even when */
#line 405
            /* there is nothing to get (edge[j]==0) */
#line 405
	if(var_rank[i] > 0) {
#line 405
	    for (j = 0; j < var_rank[i]; j++) {
#line 405
		edge[j] = 0;
#line 405
	    }
#line 405
	    err = nc_get_vara_short(BAD_ID, i, start, edge, value);
#line 405
	    IF (err != NC_EBADID) 
#line 405
		error("bad ncid: status = %d", err);
#line 405
	    err = nc_get_vara_short(ncid, BAD_VARID, start, edge, value);
#line 405
	    IF (err != NC_ENOTVAR) 
#line 405
		error("bad var id: status = %d", err);
#line 405
	    for (j = 0; j < var_rank[i]; j++) {
#line 405
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 405
		    start[j] = var_shape[i][j];
#line 405
		    err = nc_get_vara_short(ncid, i, start, edge, value);
#line 405
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 405
			error("bad start: status = %d", err);
#line 405
		    start[j] = 0;
#line 405
		}
#line 405
	    }
#line 405
	    err = nc_get_vara_short(ncid, i, start, edge, value);
#line 405
	    if (canConvert) {
#line 405
		IF (err) 
#line 405
		    error("%s", nc_strerror(err));
#line 405
	    } else {
#line 405
		IF (err != NC_ECHAR)
#line 405
		    error("wrong type: status = %d", err);
#line 405
	    }
#line 405
	    for (j = 0; j < var_rank[i]; j++) {
#line 405
		edge[j] = 1;
#line 405
	    }
#line 405
	}            /* Choose a random point dividing each dim into 2 parts */
#line 405
            /* get 2^rank (nslabs) slabs so defined */
#line 405
        nslabs = 1;
#line 405
        for (j = 0; j < var_rank[i]; j++) {
#line 405
            mid[j] = roll( var_shape[i][j] );
#line 405
            nslabs *= 2;
#line 405
        }
#line 405
            /* bits of k determine whether to get lower or upper part of dim */
#line 405
        for (k = 0; k < nslabs; k++) {
#line 405
            nels = 1;
#line 405
            for (j = 0; j < var_rank[i]; j++) {
#line 405
                if ((k >> j) & 1) {
#line 405
                    start[j] = 0;
#line 405
                    edge[j] = mid[j];
#line 405
                }else{
#line 405
                    start[j] = mid[j];
#line 405
                    edge[j] = var_shape[i][j] - mid[j];
#line 405
                }
#line 405
                nels *= edge[j];
#line 405
            }
#line 405
	    allInExtRange = allInIntRange = 1;
#line 405
            for (j = 0; j < nels; j++) {
#line 405
                err = toMixedBase(j, var_rank[i], edge, index);
#line 405
                IF (err)
#line 405
                    error("error in toMixedBase 1");
#line 405
                for (d = 0; d < var_rank[i]; d++)
#line 405
                    index[d] += start[d];
#line 405
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_SHORT);
#line 405
		if (inRange3(expect[j],var_type[i], NCT_SHORT)) {
#line 405
		    allInIntRange = allInIntRange && expect[j] >= short_min
#line 405
				&& expect[j] <= short_max;
#line 405
		} else {
#line 405
		    allInExtRange = 0;
#line 405
		}
#line 405
	    }
#line 405
            if (var_rank[i] == 0 && i%2)
#line 405
		err = nc_get_vara_short(ncid, i, NULL, NULL, value);
#line 405
	    else
#line 405
		err = nc_get_vara_short(ncid, i, start, edge, value);
#line 405
            if (canConvert) {
#line 405
		if (allInExtRange) {
#line 405
		    if (allInIntRange) {
#line 405
			IF (err)
#line 405
			    error("%s", nc_strerror(err));
#line 405
		    } else {
#line 405
			IF (err != NC_ERANGE)
#line 405
			    error("Range error: status = %d", err);
#line 405
		    }
#line 405
		} else {
#line 405
		    IF (err != 0 && err != NC_ERANGE)
#line 405
			error("OK or Range error: status = %d", err);
#line 405
		}
#line 405
		for (j = 0; j < nels; j++) {
#line 405
		    if (inRange3(expect[j],var_type[i],NCT_SHORT)
#line 405
			    && expect[j] >= short_min && expect[j] <= short_max) {
#line 405
			IF (!equal(value[j],expect[j],var_type[i],NCT_SHORT)){
#line 405
			    error("value read not that expected");
#line 405
			    if (verbose) {
#line 405
				error("\n");
#line 405
				error("varid: %d, ", i);
#line 405
				error("var_name: %s, ", var_name[i]);
#line 405
				error("element number: %d ", j);
#line 405
				error("expect: %g", expect[j]);
#line 405
				error("got: %g", (double) value[j]);
#line 405
			    }
#line 405
			} else {
#line 405
			    nok++;
#line 405
			}
#line 405
		    }
#line 405
		}
#line 405
            } else {
#line 405
                IF (nels > 0 && err != NC_ECHAR)
#line 405
                    error("wrong type: status = %d", err);
#line 405
            }
#line 405
        }
#line 405
    }
#line 405
    err = nc_close(ncid);
#line 405
    IF (err)
#line 405
	error("nc_close: %s", nc_strerror(err));
#line 405
    print_nok(nok);
#line 405
}
#line 405

void
#line 406
test_nc_get_vara_int(void)
#line 406
{
#line 406
    int ncid;
#line 406
    int d;
#line 406
    int i;
#line 406
    int j;
#line 406
    int k;
#line 406
    int err;
#line 406
    int allInExtRange;	/* all values within external range? */
#line 406
    int allInIntRange;	/* all values within internal range? */
#line 406
    int nels;
#line 406
    int nslabs;
#line 406
    int nok = 0;      /* count of valid comparisons */
#line 406
    size_t start[MAX_RANK];
#line 406
    size_t edge[MAX_RANK];
#line 406
    size_t index[MAX_RANK];
#line 406
    size_t mid[MAX_RANK];
#line 406
    int canConvert;     /* Both text or both numeric */
#line 406
    int value[MAX_NELS];
#line 406
    double expect[MAX_NELS];
#line 406

#line 406
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 406
    IF (err)
#line 406
	error("nc_open: %s", nc_strerror(err));
#line 406
    for (i = 0; i < NVARS; i++) {
#line 406
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 406
        assert(var_rank[i] <= MAX_RANK);
#line 406
        assert(var_nels[i] <= MAX_NELS);
#line 406
	for (j = 0; j < var_rank[i]; j++) {
#line 406
	    start[j] = 0;
#line 406
	    edge[j] = 1;
#line 406
	}
#line 406
        err = nc_get_vara_int(BAD_ID, i, start, edge, value);
#line 406
        IF (err != NC_EBADID)
#line 406
	    error("bad ncid: status = %d", err);
#line 406
        err = nc_get_vara_int(ncid, BAD_VARID, start, edge, value);
#line 406
        IF (err != NC_ENOTVAR)
#line 406
	    error("bad var id: status = %d", err);
#line 406
	for (j = 0; j < var_rank[i]; j++) {
#line 406
	    start[j] = var_shape[i][j];
#line 406
	    err = nc_get_vara_int(ncid, i, start, edge, value);
#line 406
            IF (canConvert && err != NC_EINVALCOORDS)
#line 406
                error("bad index: status = %d", err);
#line 406
	    start[j] = 0;
#line 406
	    edge[j] = var_shape[i][j] + 1;
#line 406
	    err = nc_get_vara_int(ncid, i, start, edge, value);
#line 406
            IF (canConvert && err != NC_EEDGE)
#line 406
		error("bad edge: status = %d", err);
#line 406
	    edge[j] = 1;
#line 406
	}
#line 406
            /* Check non-scalars for correct error returned even when */
#line 406
            /* there is nothing to get (edge[j]==0) */
#line 406
	if(var_rank[i] > 0) {
#line 406
	    for (j = 0; j < var_rank[i]; j++) {
#line 406
		edge[j] = 0;
#line 406
	    }
#line 406
	    err = nc_get_vara_int(BAD_ID, i, start, edge, value);
#line 406
	    IF (err != NC_EBADID) 
#line 406
		error("bad ncid: status = %d", err);
#line 406
	    err = nc_get_vara_int(ncid, BAD_VARID, start, edge, value);
#line 406
	    IF (err != NC_ENOTVAR) 
#line 406
		error("bad var id: status = %d", err);
#line 406
	    for (j = 0; j < var_rank[i]; j++) {
#line 406
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 406
		    start[j] = var_shape[i][j];
#line 406
		    err = nc_get_vara_int(ncid, i, start, edge, value);
#line 406
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 406
			error("bad start: status = %d", err);
#line 406
		    start[j] = 0;
#line 406
		}
#line 406
	    }
#line 406
	    err = nc_get_vara_int(ncid, i, start, edge, value);
#line 406
	    if (canConvert) {
#line 406
		IF (err) 
#line 406
		    error("%s", nc_strerror(err));
#line 406
	    } else {
#line 406
		IF (err != NC_ECHAR)
#line 406
		    error("wrong type: status = %d", err);
#line 406
	    }
#line 406
	    for (j = 0; j < var_rank[i]; j++) {
#line 406
		edge[j] = 1;
#line 406
	    }
#line 406
	}            /* Choose a random point dividing each dim into 2 parts */
#line 406
            /* get 2^rank (nslabs) slabs so defined */
#line 406
        nslabs = 1;
#line 406
        for (j = 0; j < var_rank[i]; j++) {
#line 406
            mid[j] = roll( var_shape[i][j] );
#line 406
            nslabs *= 2;
#line 406
        }
#line 406
            /* bits of k determine whether to get lower or upper part of dim */
#line 406
        for (k = 0; k < nslabs; k++) {
#line 406
            nels = 1;
#line 406
            for (j = 0; j < var_rank[i]; j++) {
#line 406
                if ((k >> j) & 1) {
#line 406
                    start[j] = 0;
#line 406
                    edge[j] = mid[j];
#line 406
                }else{
#line 406
                    start[j] = mid[j];
#line 406
                    edge[j] = var_shape[i][j] - mid[j];
#line 406
                }
#line 406
                nels *= edge[j];
#line 406
            }
#line 406
	    allInExtRange = allInIntRange = 1;
#line 406
            for (j = 0; j < nels; j++) {
#line 406
                err = toMixedBase(j, var_rank[i], edge, index);
#line 406
                IF (err)
#line 406
                    error("error in toMixedBase 1");
#line 406
                for (d = 0; d < var_rank[i]; d++)
#line 406
                    index[d] += start[d];
#line 406
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_INT);
#line 406
		if (inRange3(expect[j],var_type[i], NCT_INT)) {
#line 406
		    allInIntRange = allInIntRange && expect[j] >= int_min
#line 406
				&& expect[j] <= int_max;
#line 406
		} else {
#line 406
		    allInExtRange = 0;
#line 406
		}
#line 406
	    }
#line 406
            if (var_rank[i] == 0 && i%2)
#line 406
		err = nc_get_vara_int(ncid, i, NULL, NULL, value);
#line 406
	    else
#line 406
		err = nc_get_vara_int(ncid, i, start, edge, value);
#line 406
            if (canConvert) {
#line 406
		if (allInExtRange) {
#line 406
		    if (allInIntRange) {
#line 406
			IF (err)
#line 406
			    error("%s", nc_strerror(err));
#line 406
		    } else {
#line 406
			IF (err != NC_ERANGE)
#line 406
			    error("Range error: status = %d", err);
#line 406
		    }
#line 406
		} else {
#line 406
		    IF (err != 0 && err != NC_ERANGE)
#line 406
			error("OK or Range error: status = %d", err);
#line 406
		}
#line 406
		for (j = 0; j < nels; j++) {
#line 406
		    if (inRange3(expect[j],var_type[i],NCT_INT)
#line 406
			    && expect[j] >= int_min && expect[j] <= int_max) {
#line 406
			IF (!equal(value[j],expect[j],var_type[i],NCT_INT)){
#line 406
			    error("value read not that expected");
#line 406
			    if (verbose) {
#line 406
				error("\n");
#line 406
				error("varid: %d, ", i);
#line 406
				error("var_name: %s, ", var_name[i]);
#line 406
				error("element number: %d ", j);
#line 406
				error("expect: %g", expect[j]);
#line 406
				error("got: %g", (double) value[j]);
#line 406
			    }
#line 406
			} else {
#line 406
			    nok++;
#line 406
			}
#line 406
		    }
#line 406
		}
#line 406
            } else {
#line 406
                IF (nels > 0 && err != NC_ECHAR)
#line 406
                    error("wrong type: status = %d", err);
#line 406
            }
#line 406
        }
#line 406
    }
#line 406
    err = nc_close(ncid);
#line 406
    IF (err)
#line 406
	error("nc_close: %s", nc_strerror(err));
#line 406
    print_nok(nok);
#line 406
}
#line 406

void
#line 407
test_nc_get_vara_long(void)
#line 407
{
#line 407
    int ncid;
#line 407
    int d;
#line 407
    int i;
#line 407
    int j;
#line 407
    int k;
#line 407
    int err;
#line 407
    int allInExtRange;	/* all values within external range? */
#line 407
    int allInIntRange;	/* all values within internal range? */
#line 407
    int nels;
#line 407
    int nslabs;
#line 407
    int nok = 0;      /* count of valid comparisons */
#line 407
    size_t start[MAX_RANK];
#line 407
    size_t edge[MAX_RANK];
#line 407
    size_t index[MAX_RANK];
#line 407
    size_t mid[MAX_RANK];
#line 407
    int canConvert;     /* Both text or both numeric */
#line 407
    long value[MAX_NELS];
#line 407
    double expect[MAX_NELS];
#line 407

#line 407
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 407
    IF (err)
#line 407
	error("nc_open: %s", nc_strerror(err));
#line 407
    for (i = 0; i < NVARS; i++) {
#line 407
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 407
        assert(var_rank[i] <= MAX_RANK);
#line 407
        assert(var_nels[i] <= MAX_NELS);
#line 407
	for (j = 0; j < var_rank[i]; j++) {
#line 407
	    start[j] = 0;
#line 407
	    edge[j] = 1;
#line 407
	}
#line 407
        err = nc_get_vara_long(BAD_ID, i, start, edge, value);
#line 407
        IF (err != NC_EBADID)
#line 407
	    error("bad ncid: status = %d", err);
#line 407
        err = nc_get_vara_long(ncid, BAD_VARID, start, edge, value);
#line 407
        IF (err != NC_ENOTVAR)
#line 407
	    error("bad var id: status = %d", err);
#line 407
	for (j = 0; j < var_rank[i]; j++) {
#line 407
	    start[j] = var_shape[i][j];
#line 407
	    err = nc_get_vara_long(ncid, i, start, edge, value);
#line 407
            IF (canConvert && err != NC_EINVALCOORDS)
#line 407
                error("bad index: status = %d", err);
#line 407
	    start[j] = 0;
#line 407
	    edge[j] = var_shape[i][j] + 1;
#line 407
	    err = nc_get_vara_long(ncid, i, start, edge, value);
#line 407
            IF (canConvert && err != NC_EEDGE)
#line 407
		error("bad edge: status = %d", err);
#line 407
	    edge[j] = 1;
#line 407
	}
#line 407
            /* Check non-scalars for correct error returned even when */
#line 407
            /* there is nothing to get (edge[j]==0) */
#line 407
	if(var_rank[i] > 0) {
#line 407
	    for (j = 0; j < var_rank[i]; j++) {
#line 407
		edge[j] = 0;
#line 407
	    }
#line 407
	    err = nc_get_vara_long(BAD_ID, i, start, edge, value);
#line 407
	    IF (err != NC_EBADID) 
#line 407
		error("bad ncid: status = %d", err);
#line 407
	    err = nc_get_vara_long(ncid, BAD_VARID, start, edge, value);
#line 407
	    IF (err != NC_ENOTVAR) 
#line 407
		error("bad var id: status = %d", err);
#line 407
	    for (j = 0; j < var_rank[i]; j++) {
#line 407
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 407
		    start[j] = var_shape[i][j];
#line 407
		    err = nc_get_vara_long(ncid, i, start, edge, value);
#line 407
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 407
			error("bad start: status = %d", err);
#line 407
		    start[j] = 0;
#line 407
		}
#line 407
	    }
#line 407
	    err = nc_get_vara_long(ncid, i, start, edge, value);
#line 407
	    if (canConvert) {
#line 407
		IF (err) 
#line 407
		    error("%s", nc_strerror(err));
#line 407
	    } else {
#line 407
		IF (err != NC_ECHAR)
#line 407
		    error("wrong type: status = %d", err);
#line 407
	    }
#line 407
	    for (j = 0; j < var_rank[i]; j++) {
#line 407
		edge[j] = 1;
#line 407
	    }
#line 407
	}            /* Choose a random point dividing each dim into 2 parts */
#line 407
            /* get 2^rank (nslabs) slabs so defined */
#line 407
        nslabs = 1;
#line 407
        for (j = 0; j < var_rank[i]; j++) {
#line 407
            mid[j] = roll( var_shape[i][j] );
#line 407
            nslabs *= 2;
#line 407
        }
#line 407
            /* bits of k determine whether to get lower or upper part of dim */
#line 407
        for (k = 0; k < nslabs; k++) {
#line 407
            nels = 1;
#line 407
            for (j = 0; j < var_rank[i]; j++) {
#line 407
                if ((k >> j) & 1) {
#line 407
                    start[j] = 0;
#line 407
                    edge[j] = mid[j];
#line 407
                }else{
#line 407
                    start[j] = mid[j];
#line 407
                    edge[j] = var_shape[i][j] - mid[j];
#line 407
                }
#line 407
                nels *= edge[j];
#line 407
            }
#line 407
	    allInExtRange = allInIntRange = 1;
#line 407
            for (j = 0; j < nels; j++) {
#line 407
                err = toMixedBase(j, var_rank[i], edge, index);
#line 407
                IF (err)
#line 407
                    error("error in toMixedBase 1");
#line 407
                for (d = 0; d < var_rank[i]; d++)
#line 407
                    index[d] += start[d];
#line 407
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_LONG);
#line 407
		if (inRange3(expect[j],var_type[i], NCT_LONG)) {
#line 407
		    allInIntRange = allInIntRange && expect[j] >= long_min
#line 407
				&& expect[j] <= long_max;
#line 407
		} else {
#line 407
		    allInExtRange = 0;
#line 407
		}
#line 407
	    }
#line 407
            if (var_rank[i] == 0 && i%2)
#line 407
		err = nc_get_vara_long(ncid, i, NULL, NULL, value);
#line 407
	    else
#line 407
		err = nc_get_vara_long(ncid, i, start, edge, value);
#line 407
            if (canConvert) {
#line 407
		if (allInExtRange) {
#line 407
		    if (allInIntRange) {
#line 407
			IF (err)
#line 407
			    error("%s", nc_strerror(err));
#line 407
		    } else {
#line 407
			IF (err != NC_ERANGE)
#line 407
			    error("Range error: status = %d", err);
#line 407
		    }
#line 407
		} else {
#line 407
		    IF (err != 0 && err != NC_ERANGE)
#line 407
			error("OK or Range error: status = %d", err);
#line 407
		}
#line 407
		for (j = 0; j < nels; j++) {
#line 407
		    if (inRange3(expect[j],var_type[i],NCT_LONG)
#line 407
			    && expect[j] >= long_min && expect[j] <= long_max) {
#line 407
			IF (!equal(value[j],expect[j],var_type[i],NCT_LONG)){
#line 407
			    error("value read not that expected");
#line 407
			    if (verbose) {
#line 407
				error("\n");
#line 407
				error("varid: %d, ", i);
#line 407
				error("var_name: %s, ", var_name[i]);
#line 407
				error("element number: %d ", j);
#line 407
				error("expect: %g", expect[j]);
#line 407
				error("got: %g", (double) value[j]);
#line 407
			    }
#line 407
			} else {
#line 407
			    nok++;
#line 407
			}
#line 407
		    }
#line 407
		}
#line 407
            } else {
#line 407
                IF (nels > 0 && err != NC_ECHAR)
#line 407
                    error("wrong type: status = %d", err);
#line 407
            }
#line 407
        }
#line 407
    }
#line 407
    err = nc_close(ncid);
#line 407
    IF (err)
#line 407
	error("nc_close: %s", nc_strerror(err));
#line 407
    print_nok(nok);
#line 407
}
#line 407

void
#line 408
test_nc_get_vara_float(void)
#line 408
{
#line 408
    int ncid;
#line 408
    int d;
#line 408
    int i;
#line 408
    int j;
#line 408
    int k;
#line 408
    int err;
#line 408
    int allInExtRange;	/* all values within external range? */
#line 408
    int allInIntRange;	/* all values within internal range? */
#line 408
    int nels;
#line 408
    int nslabs;
#line 408
    int nok = 0;      /* count of valid comparisons */
#line 408
    size_t start[MAX_RANK];
#line 408
    size_t edge[MAX_RANK];
#line 408
    size_t index[MAX_RANK];
#line 408
    size_t mid[MAX_RANK];
#line 408
    int canConvert;     /* Both text or both numeric */
#line 408
    float value[MAX_NELS];
#line 408
    double expect[MAX_NELS];
#line 408

#line 408
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 408
    IF (err)
#line 408
	error("nc_open: %s", nc_strerror(err));
#line 408
    for (i = 0; i < NVARS; i++) {
#line 408
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 408
        assert(var_rank[i] <= MAX_RANK);
#line 408
        assert(var_nels[i] <= MAX_NELS);
#line 408
	for (j = 0; j < var_rank[i]; j++) {
#line 408
	    start[j] = 0;
#line 408
	    edge[j] = 1;
#line 408
	}
#line 408
        err = nc_get_vara_float(BAD_ID, i, start, edge, value);
#line 408
        IF (err != NC_EBADID)
#line 408
	    error("bad ncid: status = %d", err);
#line 408
        err = nc_get_vara_float(ncid, BAD_VARID, start, edge, value);
#line 408
        IF (err != NC_ENOTVAR)
#line 408
	    error("bad var id: status = %d", err);
#line 408
	for (j = 0; j < var_rank[i]; j++) {
#line 408
	    start[j] = var_shape[i][j];
#line 408
	    err = nc_get_vara_float(ncid, i, start, edge, value);
#line 408
            IF (canConvert && err != NC_EINVALCOORDS)
#line 408
                error("bad index: status = %d", err);
#line 408
	    start[j] = 0;
#line 408
	    edge[j] = var_shape[i][j] + 1;
#line 408
	    err = nc_get_vara_float(ncid, i, start, edge, value);
#line 408
            IF (canConvert && err != NC_EEDGE)
#line 408
		error("bad edge: status = %d", err);
#line 408
	    edge[j] = 1;
#line 408
	}
#line 408
            /* Check non-scalars for correct error returned even when */
#line 408
            /* there is nothing to get (edge[j]==0) */
#line 408
	if(var_rank[i] > 0) {
#line 408
	    for (j = 0; j < var_rank[i]; j++) {
#line 408
		edge[j] = 0;
#line 408
	    }
#line 408
	    err = nc_get_vara_float(BAD_ID, i, start, edge, value);
#line 408
	    IF (err != NC_EBADID) 
#line 408
		error("bad ncid: status = %d", err);
#line 408
	    err = nc_get_vara_float(ncid, BAD_VARID, start, edge, value);
#line 408
	    IF (err != NC_ENOTVAR) 
#line 408
		error("bad var id: status = %d", err);
#line 408
	    for (j = 0; j < var_rank[i]; j++) {
#line 408
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 408
		    start[j] = var_shape[i][j];
#line 408
		    err = nc_get_vara_float(ncid, i, start, edge, value);
#line 408
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 408
			error("bad start: status = %d", err);
#line 408
		    start[j] = 0;
#line 408
		}
#line 408
	    }
#line 408
	    err = nc_get_vara_float(ncid, i, start, edge, value);
#line 408
	    if (canConvert) {
#line 408
		IF (err) 
#line 408
		    error("%s", nc_strerror(err));
#line 408
	    } else {
#line 408
		IF (err != NC_ECHAR)
#line 408
		    error("wrong type: status = %d", err);
#line 408
	    }
#line 408
	    for (j = 0; j < var_rank[i]; j++) {
#line 408
		edge[j] = 1;
#line 408
	    }
#line 408
	}            /* Choose a random point dividing each dim into 2 parts */
#line 408
            /* get 2^rank (nslabs) slabs so defined */
#line 408
        nslabs = 1;
#line 408
        for (j = 0; j < var_rank[i]; j++) {
#line 408
            mid[j] = roll( var_shape[i][j] );
#line 408
            nslabs *= 2;
#line 408
        }
#line 408
            /* bits of k determine whether to get lower or upper part of dim */
#line 408
        for (k = 0; k < nslabs; k++) {
#line 408
            nels = 1;
#line 408
            for (j = 0; j < var_rank[i]; j++) {
#line 408
                if ((k >> j) & 1) {
#line 408
                    start[j] = 0;
#line 408
                    edge[j] = mid[j];
#line 408
                }else{
#line 408
                    start[j] = mid[j];
#line 408
                    edge[j] = var_shape[i][j] - mid[j];
#line 408
                }
#line 408
                nels *= edge[j];
#line 408
            }
#line 408
	    allInExtRange = allInIntRange = 1;
#line 408
            for (j = 0; j < nels; j++) {
#line 408
                err = toMixedBase(j, var_rank[i], edge, index);
#line 408
                IF (err)
#line 408
                    error("error in toMixedBase 1");
#line 408
                for (d = 0; d < var_rank[i]; d++)
#line 408
                    index[d] += start[d];
#line 408
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_FLOAT);
#line 408
		if (inRange3(expect[j],var_type[i], NCT_FLOAT)) {
#line 408
		    allInIntRange = allInIntRange && expect[j] >= float_min
#line 408
				&& expect[j] <= float_max;
#line 408
		} else {
#line 408
		    allInExtRange = 0;
#line 408
		}
#line 408
	    }
#line 408
            if (var_rank[i] == 0 && i%2)
#line 408
		err = nc_get_vara_float(ncid, i, NULL, NULL, value);
#line 408
	    else
#line 408
		err = nc_get_vara_float(ncid, i, start, edge, value);
#line 408
            if (canConvert) {
#line 408
		if (allInExtRange) {
#line 408
		    if (allInIntRange) {
#line 408
			IF (err)
#line 408
			    error("%s", nc_strerror(err));
#line 408
		    } else {
#line 408
			IF (err != NC_ERANGE)
#line 408
			    error("Range error: status = %d", err);
#line 408
		    }
#line 408
		} else {
#line 408
		    IF (err != 0 && err != NC_ERANGE)
#line 408
			error("OK or Range error: status = %d", err);
#line 408
		}
#line 408
		for (j = 0; j < nels; j++) {
#line 408
		    if (inRange3(expect[j],var_type[i],NCT_FLOAT)
#line 408
			    && expect[j] >= float_min && expect[j] <= float_max) {
#line 408
			IF (!equal(value[j],expect[j],var_type[i],NCT_FLOAT)){
#line 408
			    error("value read not that expected");
#line 408
			    if (verbose) {
#line 408
				error("\n");
#line 408
				error("varid: %d, ", i);
#line 408
				error("var_name: %s, ", var_name[i]);
#line 408
				error("element number: %d ", j);
#line 408
				error("expect: %g", expect[j]);
#line 408
				error("got: %g", (double) value[j]);
#line 408
			    }
#line 408
			} else {
#line 408
			    nok++;
#line 408
			}
#line 408
		    }
#line 408
		}
#line 408
            } else {
#line 408
                IF (nels > 0 && err != NC_ECHAR)
#line 408
                    error("wrong type: status = %d", err);
#line 408
            }
#line 408
        }
#line 408
    }
#line 408
    err = nc_close(ncid);
#line 408
    IF (err)
#line 408
	error("nc_close: %s", nc_strerror(err));
#line 408
    print_nok(nok);
#line 408
}
#line 408

void
#line 409
test_nc_get_vara_double(void)
#line 409
{
#line 409
    int ncid;
#line 409
    int d;
#line 409
    int i;
#line 409
    int j;
#line 409
    int k;
#line 409
    int err;
#line 409
    int allInExtRange;	/* all values within external range? */
#line 409
    int allInIntRange;	/* all values within internal range? */
#line 409
    int nels;
#line 409
    int nslabs;
#line 409
    int nok = 0;      /* count of valid comparisons */
#line 409
    size_t start[MAX_RANK];
#line 409
    size_t edge[MAX_RANK];
#line 409
    size_t index[MAX_RANK];
#line 409
    size_t mid[MAX_RANK];
#line 409
    int canConvert;     /* Both text or both numeric */
#line 409
    double value[MAX_NELS];
#line 409
    double expect[MAX_NELS];
#line 409

#line 409
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 409
    IF (err)
#line 409
	error("nc_open: %s", nc_strerror(err));
#line 409
    for (i = 0; i < NVARS; i++) {
#line 409
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 409
        assert(var_rank[i] <= MAX_RANK);
#line 409
        assert(var_nels[i] <= MAX_NELS);
#line 409
	for (j = 0; j < var_rank[i]; j++) {
#line 409
	    start[j] = 0;
#line 409
	    edge[j] = 1;
#line 409
	}
#line 409
        err = nc_get_vara_double(BAD_ID, i, start, edge, value);
#line 409
        IF (err != NC_EBADID)
#line 409
	    error("bad ncid: status = %d", err);
#line 409
        err = nc_get_vara_double(ncid, BAD_VARID, start, edge, value);
#line 409
        IF (err != NC_ENOTVAR)
#line 409
	    error("bad var id: status = %d", err);
#line 409
	for (j = 0; j < var_rank[i]; j++) {
#line 409
	    start[j] = var_shape[i][j];
#line 409
	    err = nc_get_vara_double(ncid, i, start, edge, value);
#line 409
            IF (canConvert && err != NC_EINVALCOORDS)
#line 409
                error("bad index: status = %d", err);
#line 409
	    start[j] = 0;
#line 409
	    edge[j] = var_shape[i][j] + 1;
#line 409
	    err = nc_get_vara_double(ncid, i, start, edge, value);
#line 409
            IF (canConvert && err != NC_EEDGE)
#line 409
		error("bad edge: status = %d", err);
#line 409
	    edge[j] = 1;
#line 409
	}
#line 409
            /* Check non-scalars for correct error returned even when */
#line 409
            /* there is nothing to get (edge[j]==0) */
#line 409
	if(var_rank[i] > 0) {
#line 409
	    for (j = 0; j < var_rank[i]; j++) {
#line 409
		edge[j] = 0;
#line 409
	    }
#line 409
	    err = nc_get_vara_double(BAD_ID, i, start, edge, value);
#line 409
	    IF (err != NC_EBADID) 
#line 409
		error("bad ncid: status = %d", err);
#line 409
	    err = nc_get_vara_double(ncid, BAD_VARID, start, edge, value);
#line 409
	    IF (err != NC_ENOTVAR) 
#line 409
		error("bad var id: status = %d", err);
#line 409
	    for (j = 0; j < var_rank[i]; j++) {
#line 409
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 409
		    start[j] = var_shape[i][j];
#line 409
		    err = nc_get_vara_double(ncid, i, start, edge, value);
#line 409
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 409
			error("bad start: status = %d", err);
#line 409
		    start[j] = 0;
#line 409
		}
#line 409
	    }
#line 409
	    err = nc_get_vara_double(ncid, i, start, edge, value);
#line 409
	    if (canConvert) {
#line 409
		IF (err) 
#line 409
		    error("%s", nc_strerror(err));
#line 409
	    } else {
#line 409
		IF (err != NC_ECHAR)
#line 409
		    error("wrong type: status = %d", err);
#line 409
	    }
#line 409
	    for (j = 0; j < var_rank[i]; j++) {
#line 409
		edge[j] = 1;
#line 409
	    }
#line 409
	}            /* Choose a random point dividing each dim into 2 parts */
#line 409
            /* get 2^rank (nslabs) slabs so defined */
#line 409
        nslabs = 1;
#line 409
        for (j = 0; j < var_rank[i]; j++) {
#line 409
            mid[j] = roll( var_shape[i][j] );
#line 409
            nslabs *= 2;
#line 409
        }
#line 409
            /* bits of k determine whether to get lower or upper part of dim */
#line 409
        for (k = 0; k < nslabs; k++) {
#line 409
            nels = 1;
#line 409
            for (j = 0; j < var_rank[i]; j++) {
#line 409
                if ((k >> j) & 1) {
#line 409
                    start[j] = 0;
#line 409
                    edge[j] = mid[j];
#line 409
                }else{
#line 409
                    start[j] = mid[j];
#line 409
                    edge[j] = var_shape[i][j] - mid[j];
#line 409
                }
#line 409
                nels *= edge[j];
#line 409
            }
#line 409
	    allInExtRange = allInIntRange = 1;
#line 409
            for (j = 0; j < nels; j++) {
#line 409
                err = toMixedBase(j, var_rank[i], edge, index);
#line 409
                IF (err)
#line 409
                    error("error in toMixedBase 1");
#line 409
                for (d = 0; d < var_rank[i]; d++)
#line 409
                    index[d] += start[d];
#line 409
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 409
		if (inRange3(expect[j],var_type[i], NCT_DOUBLE)) {
#line 409
		    allInIntRange = allInIntRange && expect[j] >= double_min
#line 409
				&& expect[j] <= double_max;
#line 409
		} else {
#line 409
		    allInExtRange = 0;
#line 409
		}
#line 409
	    }
#line 409
            if (var_rank[i] == 0 && i%2)
#line 409
		err = nc_get_vara_double(ncid, i, NULL, NULL, value);
#line 409
	    else
#line 409
		err = nc_get_vara_double(ncid, i, start, edge, value);
#line 409
            if (canConvert) {
#line 409
		if (allInExtRange) {
#line 409
		    if (allInIntRange) {
#line 409
			IF (err)
#line 409
			    error("%s", nc_strerror(err));
#line 409
		    } else {
#line 409
			IF (err != NC_ERANGE)
#line 409
			    error("Range error: status = %d", err);
#line 409
		    }
#line 409
		} else {
#line 409
		    IF (err != 0 && err != NC_ERANGE)
#line 409
			error("OK or Range error: status = %d", err);
#line 409
		}
#line 409
		for (j = 0; j < nels; j++) {
#line 409
		    if (inRange3(expect[j],var_type[i],NCT_DOUBLE)
#line 409
			    && expect[j] >= double_min && expect[j] <= double_max) {
#line 409
			IF (!equal(value[j],expect[j],var_type[i],NCT_DOUBLE)){
#line 409
			    error("value read not that expected");
#line 409
			    if (verbose) {
#line 409
				error("\n");
#line 409
				error("varid: %d, ", i);
#line 409
				error("var_name: %s, ", var_name[i]);
#line 409
				error("element number: %d ", j);
#line 409
				error("expect: %g", expect[j]);
#line 409
				error("got: %g", (double) value[j]);
#line 409
			    }
#line 409
			} else {
#line 409
			    nok++;
#line 409
			}
#line 409
		    }
#line 409
		}
#line 409
            } else {
#line 409
                IF (nels > 0 && err != NC_ECHAR)
#line 409
                    error("wrong type: status = %d", err);
#line 409
            }
#line 409
        }
#line 409
    }
#line 409
    err = nc_close(ncid);
#line 409
    IF (err)
#line 409
	error("nc_close: %s", nc_strerror(err));
#line 409
    print_nok(nok);
#line 409
}
#line 409



#line 590

void
#line 591
test_nc_get_vars_text(void)
#line 591
{
#line 591
    int ncid;
#line 591
    int d;
#line 591
    int i;
#line 591
    int j;
#line 591
    int k;
#line 591
    int m;
#line 591
    int err;
#line 591
    int allInExtRange;	/* all values within external range? */
#line 591
    int allInIntRange;	/* all values within internal range? */
#line 591
    int nels;
#line 591
    int nslabs;
#line 591
    int nstarts;        /* number of different starts */
#line 591
    int nok = 0;      /* count of valid comparisons */
#line 591
    size_t start[MAX_RANK];
#line 591
    size_t edge[MAX_RANK];
#line 591
    size_t index[MAX_RANK];
#line 591
    size_t index2[MAX_RANK];
#line 591
    size_t mid[MAX_RANK];
#line 591
    size_t count[MAX_RANK];
#line 591
    size_t sstride[MAX_RANK];
#line 591
    ptrdiff_t stride[MAX_RANK];
#line 591
    int canConvert;     /* Both text or both numeric */
#line 591
    text value[MAX_NELS];
#line 591
    double expect[MAX_NELS];
#line 591

#line 591
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 591
    IF (err)
#line 591
        error("nc_open: %s", nc_strerror(err));
#line 591
    for (i = 0; i < NVARS; i++) {
#line 591
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 591
        assert(var_rank[i] <= MAX_RANK);
#line 591
        assert(var_nels[i] <= MAX_NELS);
#line 591
        for (j = 0; j < var_rank[i]; j++) {
#line 591
            start[j] = 0;
#line 591
            edge[j] = 1;
#line 591
            stride[j] = 1;
#line 591
        }
#line 591
        err = nc_get_vars_text(BAD_ID, i, start, edge, stride, value);
#line 591
        IF (err != NC_EBADID)
#line 591
            error("bad ncid: status = %d", err);
#line 591
        err = nc_get_vars_text(ncid, BAD_VARID, start, edge, stride, value);
#line 591
        IF (err != NC_ENOTVAR)
#line 591
            error("bad var id: status = %d", err);
#line 591
        for (j = 0; j < var_rank[i]; j++) {
#line 591
            start[j] = var_shape[i][j];
#line 591
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
#line 591
	  if(!canConvert) {
#line 591
		IF (err != NC_ECHAR)
#line 591
               	    error("conversion: status = %d", err);
#line 591
	  } else {
#line 591
            IF (err != NC_EINVALCOORDS)
#line 591
                error("bad index: status = %d", err);
#line 591
            start[j] = 0;
#line 591
            edge[j] = var_shape[i][j] + 1;
#line 591
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
#line 591
            IF (err != NC_EEDGE)
#line 591
                error("bad edge: status = %d", err);
#line 591
            edge[j] = 1;
#line 591
            stride[j] = 0;
#line 591
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
#line 591
            IF (err != NC_ESTRIDE)
#line 591
                error("bad stride: status = %d", err);
#line 591
            stride[j] = 1;
#line 591
	  }
#line 591
        }
#line 591
            /* Choose a random point dividing each dim into 2 parts */
#line 591
            /* get 2^rank (nslabs) slabs so defined */
#line 591
        nslabs = 1;
#line 591
        for (j = 0; j < var_rank[i]; j++) {
#line 591
            mid[j] = roll( var_shape[i][j] );
#line 591
            nslabs *= 2;
#line 591
        }
#line 591
            /* bits of k determine whether to get lower or upper part of dim */
#line 591
            /* choose random stride from 1 to edge */
#line 591
        for (k = 0; k < nslabs; k++) {
#line 591
            nstarts = 1;
#line 591
            for (j = 0; j < var_rank[i]; j++) {
#line 591
                if ((k >> j) & 1) {
#line 591
                    start[j] = 0;
#line 591
                    edge[j] = mid[j];
#line 591
                }else{
#line 591
                    start[j] = mid[j];
#line 591
                    edge[j] = var_shape[i][j] - mid[j];
#line 591
                }
#line 591
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 591
                nstarts *= stride[j];
#line 591
            }
#line 591
            for (m = 0; m < nstarts; m++) {
#line 591
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 591
                IF (err)
#line 591
                    error("error in toMixedBase");
#line 591
                nels = 1;
#line 591
                for (j = 0; j < var_rank[i]; j++) {
#line 591
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 591
                    nels *= count[j];
#line 591
                    index[j] += start[j];
#line 591
                }
#line 591
                        /* Random choice of forward or backward */
#line 591
/* TODO
#line 591
                if ( roll(2) ) {
#line 591
                    for (j = 0; j < var_rank[i]; j++) {
#line 591
                        index[j] += (count[j] - 1) * stride[j];
#line 591
                        stride[j] = -stride[j];
#line 591
                    }
#line 591
                }
#line 591
*/
#line 591
		allInExtRange = allInIntRange = 1;
#line 591
		for (j = 0; j < nels; j++) {
#line 591
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 591
		    IF (err)
#line 591
			error("error in toMixedBase 1");
#line 591
		    for (d = 0; d < var_rank[i]; d++)
#line 591
			index2[d] = index[d] + index2[d] * stride[d];
#line 591
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 591
			NCT_TEXT);
#line 591
		    if (inRange3(expect[j],var_type[i],NCT_TEXT)) {
#line 591
			allInIntRange = allInIntRange && expect[j] >= text_min
#line 591
			    && expect[j] <= text_max;
#line 591
		    } else {
#line 591
			allInExtRange = 0;
#line 591
		    }
#line 591
		}
#line 591
                if (var_rank[i] == 0 && i%2 )
#line 591
                    err = nc_get_vars_text(ncid, i, NULL, NULL, NULL, value);
#line 591
                else
#line 591
                    err = nc_get_vars_text(ncid, i, index, count, stride, value);
#line 591
		if (canConvert) {
#line 591
		    if (allInExtRange) {
#line 591
			if (allInIntRange) {
#line 591
			    IF (err)
#line 591
				error("%s", nc_strerror(err));
#line 591
			} else {
#line 591
			    IF (err != NC_ERANGE)
#line 591
				error("Range error: status = %d", err);
#line 591
			}
#line 591
		    } else {
#line 591
			IF (err != 0 && err != NC_ERANGE)
#line 591
			    error("OK or Range error: status = %d", err);
#line 591
		    }
#line 591
		    for (j = 0; j < nels; j++) {
#line 591
			if (inRange3(expect[j],var_type[i],NCT_TEXT)
#line 591
				&& expect[j] >= text_min && expect[j] <= text_max) {
#line 591
			    IF (!equal(value[j],expect[j],var_type[i], NCT_TEXT)){
#line 591
				error("value read not that expected");
#line 591
				if (verbose) {
#line 591
				    error("\n");
#line 591
				    error("varid: %d, ", i);
#line 591
				    error("var_name: %s, ", var_name[i]);
#line 591
				    error("element number: %d ", j);
#line 591
                                    error("expect: %g, ", expect[j]);
#line 591
				    error("got: %g", (double) value[j]);
#line 591
				}
#line 591
			    } else {
#line 591
				nok++;
#line 591
			    }
#line 591
			}
#line 591
		    }
#line 591
		} else {
#line 591
		    IF (nels > 0 && err != NC_ECHAR)
#line 591
			error("wrong type: status = %d", err);
#line 591
		}
#line 591
	    }
#line 591
	}
#line 591

#line 591
    }
#line 591
    err = nc_close(ncid);
#line 591
    IF (err)
#line 591
        error("nc_close: %s", nc_strerror(err));
#line 591
    print_nok(nok);
#line 591
}
#line 591

void
#line 592
test_nc_get_vars_uchar(void)
#line 592
{
#line 592
    int ncid;
#line 592
    int d;
#line 592
    int i;
#line 592
    int j;
#line 592
    int k;
#line 592
    int m;
#line 592
    int err;
#line 592
    int allInExtRange;	/* all values within external range? */
#line 592
    int allInIntRange;	/* all values within internal range? */
#line 592
    int nels;
#line 592
    int nslabs;
#line 592
    int nstarts;        /* number of different starts */
#line 592
    int nok = 0;      /* count of valid comparisons */
#line 592
    size_t start[MAX_RANK];
#line 592
    size_t edge[MAX_RANK];
#line 592
    size_t index[MAX_RANK];
#line 592
    size_t index2[MAX_RANK];
#line 592
    size_t mid[MAX_RANK];
#line 592
    size_t count[MAX_RANK];
#line 592
    size_t sstride[MAX_RANK];
#line 592
    ptrdiff_t stride[MAX_RANK];
#line 592
    int canConvert;     /* Both text or both numeric */
#line 592
    uchar value[MAX_NELS];
#line 592
    double expect[MAX_NELS];
#line 592

#line 592
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 592
    IF (err)
#line 592
        error("nc_open: %s", nc_strerror(err));
#line 592
    for (i = 0; i < NVARS; i++) {
#line 592
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 592
        assert(var_rank[i] <= MAX_RANK);
#line 592
        assert(var_nels[i] <= MAX_NELS);
#line 592
        for (j = 0; j < var_rank[i]; j++) {
#line 592
            start[j] = 0;
#line 592
            edge[j] = 1;
#line 592
            stride[j] = 1;
#line 592
        }
#line 592
        err = nc_get_vars_uchar(BAD_ID, i, start, edge, stride, value);
#line 592
        IF (err != NC_EBADID)
#line 592
            error("bad ncid: status = %d", err);
#line 592
        err = nc_get_vars_uchar(ncid, BAD_VARID, start, edge, stride, value);
#line 592
        IF (err != NC_ENOTVAR)
#line 592
            error("bad var id: status = %d", err);
#line 592
        for (j = 0; j < var_rank[i]; j++) {
#line 592
            start[j] = var_shape[i][j];
#line 592
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
#line 592
	  if(!canConvert) {
#line 592
		IF (err != NC_ECHAR)
#line 592
               	    error("conversion: status = %d", err);
#line 592
	  } else {
#line 592
            IF (err != NC_EINVALCOORDS)
#line 592
                error("bad index: status = %d", err);
#line 592
            start[j] = 0;
#line 592
            edge[j] = var_shape[i][j] + 1;
#line 592
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
#line 592
            IF (err != NC_EEDGE)
#line 592
                error("bad edge: status = %d", err);
#line 592
            edge[j] = 1;
#line 592
            stride[j] = 0;
#line 592
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
#line 592
            IF (err != NC_ESTRIDE)
#line 592
                error("bad stride: status = %d", err);
#line 592
            stride[j] = 1;
#line 592
	  }
#line 592
        }
#line 592
            /* Choose a random point dividing each dim into 2 parts */
#line 592
            /* get 2^rank (nslabs) slabs so defined */
#line 592
        nslabs = 1;
#line 592
        for (j = 0; j < var_rank[i]; j++) {
#line 592
            mid[j] = roll( var_shape[i][j] );
#line 592
            nslabs *= 2;
#line 592
        }
#line 592
            /* bits of k determine whether to get lower or upper part of dim */
#line 592
            /* choose random stride from 1 to edge */
#line 592
        for (k = 0; k < nslabs; k++) {
#line 592
            nstarts = 1;
#line 592
            for (j = 0; j < var_rank[i]; j++) {
#line 592
                if ((k >> j) & 1) {
#line 592
                    start[j] = 0;
#line 592
                    edge[j] = mid[j];
#line 592
                }else{
#line 592
                    start[j] = mid[j];
#line 592
                    edge[j] = var_shape[i][j] - mid[j];
#line 592
                }
#line 592
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 592
                nstarts *= stride[j];
#line 592
            }
#line 592
            for (m = 0; m < nstarts; m++) {
#line 592
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 592
                IF (err)
#line 592
                    error("error in toMixedBase");
#line 592
                nels = 1;
#line 592
                for (j = 0; j < var_rank[i]; j++) {
#line 592
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 592
                    nels *= count[j];
#line 592
                    index[j] += start[j];
#line 592
                }
#line 592
                        /* Random choice of forward or backward */
#line 592
/* TODO
#line 592
                if ( roll(2) ) {
#line 592
                    for (j = 0; j < var_rank[i]; j++) {
#line 592
                        index[j] += (count[j] - 1) * stride[j];
#line 592
                        stride[j] = -stride[j];
#line 592
                    }
#line 592
                }
#line 592
*/
#line 592
		allInExtRange = allInIntRange = 1;
#line 592
		for (j = 0; j < nels; j++) {
#line 592
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 592
		    IF (err)
#line 592
			error("error in toMixedBase 1");
#line 592
		    for (d = 0; d < var_rank[i]; d++)
#line 592
			index2[d] = index[d] + index2[d] * stride[d];
#line 592
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 592
			NCT_UCHAR);
#line 592
		    if (inRange3(expect[j],var_type[i],NCT_UCHAR)) {
#line 592
			allInIntRange = allInIntRange && expect[j] >= uchar_min
#line 592
			    && expect[j] <= uchar_max;
#line 592
		    } else {
#line 592
			allInExtRange = 0;
#line 592
		    }
#line 592
		}
#line 592
                if (var_rank[i] == 0 && i%2 )
#line 592
                    err = nc_get_vars_uchar(ncid, i, NULL, NULL, NULL, value);
#line 592
                else
#line 592
                    err = nc_get_vars_uchar(ncid, i, index, count, stride, value);
#line 592
		if (canConvert) {
#line 592
		    if (allInExtRange) {
#line 592
			if (allInIntRange) {
#line 592
			    IF (err)
#line 592
				error("%s", nc_strerror(err));
#line 592
			} else {
#line 592
			    IF (err != NC_ERANGE)
#line 592
				error("Range error: status = %d", err);
#line 592
			}
#line 592
		    } else {
#line 592
			IF (err != 0 && err != NC_ERANGE)
#line 592
			    error("OK or Range error: status = %d", err);
#line 592
		    }
#line 592
		    for (j = 0; j < nels; j++) {
#line 592
			if (inRange3(expect[j],var_type[i],NCT_UCHAR)
#line 592
				&& expect[j] >= uchar_min && expect[j] <= uchar_max) {
#line 592
			    IF (!equal(value[j],expect[j],var_type[i], NCT_UCHAR)){
#line 592
				error("value read not that expected");
#line 592
				if (verbose) {
#line 592
				    error("\n");
#line 592
				    error("varid: %d, ", i);
#line 592
				    error("var_name: %s, ", var_name[i]);
#line 592
				    error("element number: %d ", j);
#line 592
                                    error("expect: %g, ", expect[j]);
#line 592
				    error("got: %g", (double) value[j]);
#line 592
				}
#line 592
			    } else {
#line 592
				nok++;
#line 592
			    }
#line 592
			}
#line 592
		    }
#line 592
		} else {
#line 592
		    IF (nels > 0 && err != NC_ECHAR)
#line 592
			error("wrong type: status = %d", err);
#line 592
		}
#line 592
	    }
#line 592
	}
#line 592

#line 592
    }
#line 592
    err = nc_close(ncid);
#line 592
    IF (err)
#line 592
        error("nc_close: %s", nc_strerror(err));
#line 592
    print_nok(nok);
#line 592
}
#line 592

void
#line 593
test_nc_get_vars_schar(void)
#line 593
{
#line 593
    int ncid;
#line 593
    int d;
#line 593
    int i;
#line 593
    int j;
#line 593
    int k;
#line 593
    int m;
#line 593
    int err;
#line 593
    int allInExtRange;	/* all values within external range? */
#line 593
    int allInIntRange;	/* all values within internal range? */
#line 593
    int nels;
#line 593
    int nslabs;
#line 593
    int nstarts;        /* number of different starts */
#line 593
    int nok = 0;      /* count of valid comparisons */
#line 593
    size_t start[MAX_RANK];
#line 593
    size_t edge[MAX_RANK];
#line 593
    size_t index[MAX_RANK];
#line 593
    size_t index2[MAX_RANK];
#line 593
    size_t mid[MAX_RANK];
#line 593
    size_t count[MAX_RANK];
#line 593
    size_t sstride[MAX_RANK];
#line 593
    ptrdiff_t stride[MAX_RANK];
#line 593
    int canConvert;     /* Both text or both numeric */
#line 593
    schar value[MAX_NELS];
#line 593
    double expect[MAX_NELS];
#line 593

#line 593
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 593
    IF (err)
#line 593
        error("nc_open: %s", nc_strerror(err));
#line 593
    for (i = 0; i < NVARS; i++) {
#line 593
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 593
        assert(var_rank[i] <= MAX_RANK);
#line 593
        assert(var_nels[i] <= MAX_NELS);
#line 593
        for (j = 0; j < var_rank[i]; j++) {
#line 593
            start[j] = 0;
#line 593
            edge[j] = 1;
#line 593
            stride[j] = 1;
#line 593
        }
#line 593
        err = nc_get_vars_schar(BAD_ID, i, start, edge, stride, value);
#line 593
        IF (err != NC_EBADID)
#line 593
            error("bad ncid: status = %d", err);
#line 593
        err = nc_get_vars_schar(ncid, BAD_VARID, start, edge, stride, value);
#line 593
        IF (err != NC_ENOTVAR)
#line 593
            error("bad var id: status = %d", err);
#line 593
        for (j = 0; j < var_rank[i]; j++) {
#line 593
            start[j] = var_shape[i][j];
#line 593
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
#line 593
	  if(!canConvert) {
#line 593
		IF (err != NC_ECHAR)
#line 593
               	    error("conversion: status = %d", err);
#line 593
	  } else {
#line 593
            IF (err != NC_EINVALCOORDS)
#line 593
                error("bad index: status = %d", err);
#line 593
            start[j] = 0;
#line 593
            edge[j] = var_shape[i][j] + 1;
#line 593
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
#line 593
            IF (err != NC_EEDGE)
#line 593
                error("bad edge: status = %d", err);
#line 593
            edge[j] = 1;
#line 593
            stride[j] = 0;
#line 593
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
#line 593
            IF (err != NC_ESTRIDE)
#line 593
                error("bad stride: status = %d", err);
#line 593
            stride[j] = 1;
#line 593
	  }
#line 593
        }
#line 593
            /* Choose a random point dividing each dim into 2 parts */
#line 593
            /* get 2^rank (nslabs) slabs so defined */
#line 593
        nslabs = 1;
#line 593
        for (j = 0; j < var_rank[i]; j++) {
#line 593
            mid[j] = roll( var_shape[i][j] );
#line 593
            nslabs *= 2;
#line 593
        }
#line 593
            /* bits of k determine whether to get lower or upper part of dim */
#line 593
            /* choose random stride from 1 to edge */
#line 593
        for (k = 0; k < nslabs; k++) {
#line 593
            nstarts = 1;
#line 593
            for (j = 0; j < var_rank[i]; j++) {
#line 593
                if ((k >> j) & 1) {
#line 593
                    start[j] = 0;
#line 593
                    edge[j] = mid[j];
#line 593
                }else{
#line 593
                    start[j] = mid[j];
#line 593
                    edge[j] = var_shape[i][j] - mid[j];
#line 593
                }
#line 593
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 593
                nstarts *= stride[j];
#line 593
            }
#line 593
            for (m = 0; m < nstarts; m++) {
#line 593
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 593
                IF (err)
#line 593
                    error("error in toMixedBase");
#line 593
                nels = 1;
#line 593
                for (j = 0; j < var_rank[i]; j++) {
#line 593
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 593
                    nels *= count[j];
#line 593
                    index[j] += start[j];
#line 593
                }
#line 593
                        /* Random choice of forward or backward */
#line 593
/* TODO
#line 593
                if ( roll(2) ) {
#line 593
                    for (j = 0; j < var_rank[i]; j++) {
#line 593
                        index[j] += (count[j] - 1) * stride[j];
#line 593
                        stride[j] = -stride[j];
#line 593
                    }
#line 593
                }
#line 593
*/
#line 593
		allInExtRange = allInIntRange = 1;
#line 593
		for (j = 0; j < nels; j++) {
#line 593
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 593
		    IF (err)
#line 593
			error("error in toMixedBase 1");
#line 593
		    for (d = 0; d < var_rank[i]; d++)
#line 593
			index2[d] = index[d] + index2[d] * stride[d];
#line 593
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 593
			NCT_SCHAR);
#line 593
		    if (inRange3(expect[j],var_type[i],NCT_SCHAR)) {
#line 593
			allInIntRange = allInIntRange && expect[j] >= schar_min
#line 593
			    && expect[j] <= schar_max;
#line 593
		    } else {
#line 593
			allInExtRange = 0;
#line 593
		    }
#line 593
		}
#line 593
                if (var_rank[i] == 0 && i%2 )
#line 593
                    err = nc_get_vars_schar(ncid, i, NULL, NULL, NULL, value);
#line 593
                else
#line 593
                    err = nc_get_vars_schar(ncid, i, index, count, stride, value);
#line 593
		if (canConvert) {
#line 593
		    if (allInExtRange) {
#line 593
			if (allInIntRange) {
#line 593
			    IF (err)
#line 593
				error("%s", nc_strerror(err));
#line 593
			} else {
#line 593
			    IF (err != NC_ERANGE)
#line 593
				error("Range error: status = %d", err);
#line 593
			}
#line 593
		    } else {
#line 593
			IF (err != 0 && err != NC_ERANGE)
#line 593
			    error("OK or Range error: status = %d", err);
#line 593
		    }
#line 593
		    for (j = 0; j < nels; j++) {
#line 593
			if (inRange3(expect[j],var_type[i],NCT_SCHAR)
#line 593
				&& expect[j] >= schar_min && expect[j] <= schar_max) {
#line 593
			    IF (!equal(value[j],expect[j],var_type[i], NCT_SCHAR)){
#line 593
				error("value read not that expected");
#line 593
				if (verbose) {
#line 593
				    error("\n");
#line 593
				    error("varid: %d, ", i);
#line 593
				    error("var_name: %s, ", var_name[i]);
#line 593
				    error("element number: %d ", j);
#line 593
                                    error("expect: %g, ", expect[j]);
#line 593
				    error("got: %g", (double) value[j]);
#line 593
				}
#line 593
			    } else {
#line 593
				nok++;
#line 593
			    }
#line 593
			}
#line 593
		    }
#line 593
		} else {
#line 593
		    IF (nels > 0 && err != NC_ECHAR)
#line 593
			error("wrong type: status = %d", err);
#line 593
		}
#line 593
	    }
#line 593
	}
#line 593

#line 593
    }
#line 593
    err = nc_close(ncid);
#line 593
    IF (err)
#line 593
        error("nc_close: %s", nc_strerror(err));
#line 593
    print_nok(nok);
#line 593
}
#line 593

void
#line 594
test_nc_get_vars_short(void)
#line 594
{
#line 594
    int ncid;
#line 594
    int d;
#line 594
    int i;
#line 594
    int j;
#line 594
    int k;
#line 594
    int m;
#line 594
    int err;
#line 594
    int allInExtRange;	/* all values within external range? */
#line 594
    int allInIntRange;	/* all values within internal range? */
#line 594
    int nels;
#line 594
    int nslabs;
#line 594
    int nstarts;        /* number of different starts */
#line 594
    int nok = 0;      /* count of valid comparisons */
#line 594
    size_t start[MAX_RANK];
#line 594
    size_t edge[MAX_RANK];
#line 594
    size_t index[MAX_RANK];
#line 594
    size_t index2[MAX_RANK];
#line 594
    size_t mid[MAX_RANK];
#line 594
    size_t count[MAX_RANK];
#line 594
    size_t sstride[MAX_RANK];
#line 594
    ptrdiff_t stride[MAX_RANK];
#line 594
    int canConvert;     /* Both text or both numeric */
#line 594
    short value[MAX_NELS];
#line 594
    double expect[MAX_NELS];
#line 594

#line 594
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 594
    IF (err)
#line 594
        error("nc_open: %s", nc_strerror(err));
#line 594
    for (i = 0; i < NVARS; i++) {
#line 594
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 594
        assert(var_rank[i] <= MAX_RANK);
#line 594
        assert(var_nels[i] <= MAX_NELS);
#line 594
        for (j = 0; j < var_rank[i]; j++) {
#line 594
            start[j] = 0;
#line 594
            edge[j] = 1;
#line 594
            stride[j] = 1;
#line 594
        }
#line 594
        err = nc_get_vars_short(BAD_ID, i, start, edge, stride, value);
#line 594
        IF (err != NC_EBADID)
#line 594
            error("bad ncid: status = %d", err);
#line 594
        err = nc_get_vars_short(ncid, BAD_VARID, start, edge, stride, value);
#line 594
        IF (err != NC_ENOTVAR)
#line 594
            error("bad var id: status = %d", err);
#line 594
        for (j = 0; j < var_rank[i]; j++) {
#line 594
            start[j] = var_shape[i][j];
#line 594
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
#line 594
	  if(!canConvert) {
#line 594
		IF (err != NC_ECHAR)
#line 594
               	    error("conversion: status = %d", err);
#line 594
	  } else {
#line 594
            IF (err != NC_EINVALCOORDS)
#line 594
                error("bad index: status = %d", err);
#line 594
            start[j] = 0;
#line 594
            edge[j] = var_shape[i][j] + 1;
#line 594
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
#line 594
            IF (err != NC_EEDGE)
#line 594
                error("bad edge: status = %d", err);
#line 594
            edge[j] = 1;
#line 594
            stride[j] = 0;
#line 594
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
#line 594
            IF (err != NC_ESTRIDE)
#line 594
                error("bad stride: status = %d", err);
#line 594
            stride[j] = 1;
#line 594
	  }
#line 594
        }
#line 594
            /* Choose a random point dividing each dim into 2 parts */
#line 594
            /* get 2^rank (nslabs) slabs so defined */
#line 594
        nslabs = 1;
#line 594
        for (j = 0; j < var_rank[i]; j++) {
#line 594
            mid[j] = roll( var_shape[i][j] );
#line 594
            nslabs *= 2;
#line 594
        }
#line 594
            /* bits of k determine whether to get lower or upper part of dim */
#line 594
            /* choose random stride from 1 to edge */
#line 594
        for (k = 0; k < nslabs; k++) {
#line 594
            nstarts = 1;
#line 594
            for (j = 0; j < var_rank[i]; j++) {
#line 594
                if ((k >> j) & 1) {
#line 594
                    start[j] = 0;
#line 594
                    edge[j] = mid[j];
#line 594
                }else{
#line 594
                    start[j] = mid[j];
#line 594
                    edge[j] = var_shape[i][j] - mid[j];
#line 594
                }
#line 594
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 594
                nstarts *= stride[j];
#line 594
            }
#line 594
            for (m = 0; m < nstarts; m++) {
#line 594
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 594
                IF (err)
#line 594
                    error("error in toMixedBase");
#line 594
                nels = 1;
#line 594
                for (j = 0; j < var_rank[i]; j++) {
#line 594
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 594
                    nels *= count[j];
#line 594
                    index[j] += start[j];
#line 594
                }
#line 594
                        /* Random choice of forward or backward */
#line 594
/* TODO
#line 594
                if ( roll(2) ) {
#line 594
                    for (j = 0; j < var_rank[i]; j++) {
#line 594
                        index[j] += (count[j] - 1) * stride[j];
#line 594
                        stride[j] = -stride[j];
#line 594
                    }
#line 594
                }
#line 594
*/
#line 594
		allInExtRange = allInIntRange = 1;
#line 594
		for (j = 0; j < nels; j++) {
#line 594
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 594
		    IF (err)
#line 594
			error("error in toMixedBase 1");
#line 594
		    for (d = 0; d < var_rank[i]; d++)
#line 594
			index2[d] = index[d] + index2[d] * stride[d];
#line 594
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 594
			NCT_SHORT);
#line 594
		    if (inRange3(expect[j],var_type[i],NCT_SHORT)) {
#line 594
			allInIntRange = allInIntRange && expect[j] >= short_min
#line 594
			    && expect[j] <= short_max;
#line 594
		    } else {
#line 594
			allInExtRange = 0;
#line 594
		    }
#line 594
		}
#line 594
                if (var_rank[i] == 0 && i%2 )
#line 594
                    err = nc_get_vars_short(ncid, i, NULL, NULL, NULL, value);
#line 594
                else
#line 594
                    err = nc_get_vars_short(ncid, i, index, count, stride, value);
#line 594
		if (canConvert) {
#line 594
		    if (allInExtRange) {
#line 594
			if (allInIntRange) {
#line 594
			    IF (err)
#line 594
				error("%s", nc_strerror(err));
#line 594
			} else {
#line 594
			    IF (err != NC_ERANGE)
#line 594
				error("Range error: status = %d", err);
#line 594
			}
#line 594
		    } else {
#line 594
			IF (err != 0 && err != NC_ERANGE)
#line 594
			    error("OK or Range error: status = %d", err);
#line 594
		    }
#line 594
		    for (j = 0; j < nels; j++) {
#line 594
			if (inRange3(expect[j],var_type[i],NCT_SHORT)
#line 594
				&& expect[j] >= short_min && expect[j] <= short_max) {
#line 594
			    IF (!equal(value[j],expect[j],var_type[i], NCT_SHORT)){
#line 594
				error("value read not that expected");
#line 594
				if (verbose) {
#line 594
				    error("\n");
#line 594
				    error("varid: %d, ", i);
#line 594
				    error("var_name: %s, ", var_name[i]);
#line 594
				    error("element number: %d ", j);
#line 594
                                    error("expect: %g, ", expect[j]);
#line 594
				    error("got: %g", (double) value[j]);
#line 594
				}
#line 594
			    } else {
#line 594
				nok++;
#line 594
			    }
#line 594
			}
#line 594
		    }
#line 594
		} else {
#line 594
		    IF (nels > 0 && err != NC_ECHAR)
#line 594
			error("wrong type: status = %d", err);
#line 594
		}
#line 594
	    }
#line 594
	}
#line 594

#line 594
    }
#line 594
    err = nc_close(ncid);
#line 594
    IF (err)
#line 594
        error("nc_close: %s", nc_strerror(err));
#line 594
    print_nok(nok);
#line 594
}
#line 594

void
#line 595
test_nc_get_vars_int(void)
#line 595
{
#line 595
    int ncid;
#line 595
    int d;
#line 595
    int i;
#line 595
    int j;
#line 595
    int k;
#line 595
    int m;
#line 595
    int err;
#line 595
    int allInExtRange;	/* all values within external range? */
#line 595
    int allInIntRange;	/* all values within internal range? */
#line 595
    int nels;
#line 595
    int nslabs;
#line 595
    int nstarts;        /* number of different starts */
#line 595
    int nok = 0;      /* count of valid comparisons */
#line 595
    size_t start[MAX_RANK];
#line 595
    size_t edge[MAX_RANK];
#line 595
    size_t index[MAX_RANK];
#line 595
    size_t index2[MAX_RANK];
#line 595
    size_t mid[MAX_RANK];
#line 595
    size_t count[MAX_RANK];
#line 595
    size_t sstride[MAX_RANK];
#line 595
    ptrdiff_t stride[MAX_RANK];
#line 595
    int canConvert;     /* Both text or both numeric */
#line 595
    int value[MAX_NELS];
#line 595
    double expect[MAX_NELS];
#line 595

#line 595
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 595
    IF (err)
#line 595
        error("nc_open: %s", nc_strerror(err));
#line 595
    for (i = 0; i < NVARS; i++) {
#line 595
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 595
        assert(var_rank[i] <= MAX_RANK);
#line 595
        assert(var_nels[i] <= MAX_NELS);
#line 595
        for (j = 0; j < var_rank[i]; j++) {
#line 595
            start[j] = 0;
#line 595
            edge[j] = 1;
#line 595
            stride[j] = 1;
#line 595
        }
#line 595
        err = nc_get_vars_int(BAD_ID, i, start, edge, stride, value);
#line 595
        IF (err != NC_EBADID)
#line 595
            error("bad ncid: status = %d", err);
#line 595
        err = nc_get_vars_int(ncid, BAD_VARID, start, edge, stride, value);
#line 595
        IF (err != NC_ENOTVAR)
#line 595
            error("bad var id: status = %d", err);
#line 595
        for (j = 0; j < var_rank[i]; j++) {
#line 595
            start[j] = var_shape[i][j];
#line 595
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
#line 595
	  if(!canConvert) {
#line 595
		IF (err != NC_ECHAR)
#line 595
               	    error("conversion: status = %d", err);
#line 595
	  } else {
#line 595
            IF (err != NC_EINVALCOORDS)
#line 595
                error("bad index: status = %d", err);
#line 595
            start[j] = 0;
#line 595
            edge[j] = var_shape[i][j] + 1;
#line 595
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
#line 595
            IF (err != NC_EEDGE)
#line 595
                error("bad edge: status = %d", err);
#line 595
            edge[j] = 1;
#line 595
            stride[j] = 0;
#line 595
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
#line 595
            IF (err != NC_ESTRIDE)
#line 595
                error("bad stride: status = %d", err);
#line 595
            stride[j] = 1;
#line 595
	  }
#line 595
        }
#line 595
            /* Choose a random point dividing each dim into 2 parts */
#line 595
            /* get 2^rank (nslabs) slabs so defined */
#line 595
        nslabs = 1;
#line 595
        for (j = 0; j < var_rank[i]; j++) {
#line 595
            mid[j] = roll( var_shape[i][j] );
#line 595
            nslabs *= 2;
#line 595
        }
#line 595
            /* bits of k determine whether to get lower or upper part of dim */
#line 595
            /* choose random stride from 1 to edge */
#line 595
        for (k = 0; k < nslabs; k++) {
#line 595
            nstarts = 1;
#line 595
            for (j = 0; j < var_rank[i]; j++) {
#line 595
                if ((k >> j) & 1) {
#line 595
                    start[j] = 0;
#line 595
                    edge[j] = mid[j];
#line 595
                }else{
#line 595
                    start[j] = mid[j];
#line 595
                    edge[j] = var_shape[i][j] - mid[j];
#line 595
                }
#line 595
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 595
                nstarts *= stride[j];
#line 595
            }
#line 595
            for (m = 0; m < nstarts; m++) {
#line 595
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 595
                IF (err)
#line 595
                    error("error in toMixedBase");
#line 595
                nels = 1;
#line 595
                for (j = 0; j < var_rank[i]; j++) {
#line 595
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 595
                    nels *= count[j];
#line 595
                    index[j] += start[j];
#line 595
                }
#line 595
                        /* Random choice of forward or backward */
#line 595
/* TODO
#line 595
                if ( roll(2) ) {
#line 595
                    for (j = 0; j < var_rank[i]; j++) {
#line 595
                        index[j] += (count[j] - 1) * stride[j];
#line 595
                        stride[j] = -stride[j];
#line 595
                    }
#line 595
                }
#line 595
*/
#line 595
		allInExtRange = allInIntRange = 1;
#line 595
		for (j = 0; j < nels; j++) {
#line 595
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 595
		    IF (err)
#line 595
			error("error in toMixedBase 1");
#line 595
		    for (d = 0; d < var_rank[i]; d++)
#line 595
			index2[d] = index[d] + index2[d] * stride[d];
#line 595
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 595
			NCT_INT);
#line 595
		    if (inRange3(expect[j],var_type[i],NCT_INT)) {
#line 595
			allInIntRange = allInIntRange && expect[j] >= int_min
#line 595
			    && expect[j] <= int_max;
#line 595
		    } else {
#line 595
			allInExtRange = 0;
#line 595
		    }
#line 595
		}
#line 595
                if (var_rank[i] == 0 && i%2 )
#line 595
                    err = nc_get_vars_int(ncid, i, NULL, NULL, NULL, value);
#line 595
                else
#line 595
                    err = nc_get_vars_int(ncid, i, index, count, stride, value);
#line 595
		if (canConvert) {
#line 595
		    if (allInExtRange) {
#line 595
			if (allInIntRange) {
#line 595
			    IF (err)
#line 595
				error("%s", nc_strerror(err));
#line 595
			} else {
#line 595
			    IF (err != NC_ERANGE)
#line 595
				error("Range error: status = %d", err);
#line 595
			}
#line 595
		    } else {
#line 595
			IF (err != 0 && err != NC_ERANGE)
#line 595
			    error("OK or Range error: status = %d", err);
#line 595
		    }
#line 595
		    for (j = 0; j < nels; j++) {
#line 595
			if (inRange3(expect[j],var_type[i],NCT_INT)
#line 595
				&& expect[j] >= int_min && expect[j] <= int_max) {
#line 595
			    IF (!equal(value[j],expect[j],var_type[i], NCT_INT)){
#line 595
				error("value read not that expected");
#line 595
				if (verbose) {
#line 595
				    error("\n");
#line 595
				    error("varid: %d, ", i);
#line 595
				    error("var_name: %s, ", var_name[i]);
#line 595
				    error("element number: %d ", j);
#line 595
                                    error("expect: %g, ", expect[j]);
#line 595
				    error("got: %g", (double) value[j]);
#line 595
				}
#line 595
			    } else {
#line 595
				nok++;
#line 595
			    }
#line 595
			}
#line 595
		    }
#line 595
		} else {
#line 595
		    IF (nels > 0 && err != NC_ECHAR)
#line 595
			error("wrong type: status = %d", err);
#line 595
		}
#line 595
	    }
#line 595
	}
#line 595

#line 595
    }
#line 595
    err = nc_close(ncid);
#line 595
    IF (err)
#line 595
        error("nc_close: %s", nc_strerror(err));
#line 595
    print_nok(nok);
#line 595
}
#line 595

void
#line 596
test_nc_get_vars_long(void)
#line 596
{
#line 596
    int ncid;
#line 596
    int d;
#line 596
    int i;
#line 596
    int j;
#line 596
    int k;
#line 596
    int m;
#line 596
    int err;
#line 596
    int allInExtRange;	/* all values within external range? */
#line 596
    int allInIntRange;	/* all values within internal range? */
#line 596
    int nels;
#line 596
    int nslabs;
#line 596
    int nstarts;        /* number of different starts */
#line 596
    int nok = 0;      /* count of valid comparisons */
#line 596
    size_t start[MAX_RANK];
#line 596
    size_t edge[MAX_RANK];
#line 596
    size_t index[MAX_RANK];
#line 596
    size_t index2[MAX_RANK];
#line 596
    size_t mid[MAX_RANK];
#line 596
    size_t count[MAX_RANK];
#line 596
    size_t sstride[MAX_RANK];
#line 596
    ptrdiff_t stride[MAX_RANK];
#line 596
    int canConvert;     /* Both text or both numeric */
#line 596
    long value[MAX_NELS];
#line 596
    double expect[MAX_NELS];
#line 596

#line 596
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 596
    IF (err)
#line 596
        error("nc_open: %s", nc_strerror(err));
#line 596
    for (i = 0; i < NVARS; i++) {
#line 596
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 596
        assert(var_rank[i] <= MAX_RANK);
#line 596
        assert(var_nels[i] <= MAX_NELS);
#line 596
        for (j = 0; j < var_rank[i]; j++) {
#line 596
            start[j] = 0;
#line 596
            edge[j] = 1;
#line 596
            stride[j] = 1;
#line 596
        }
#line 596
        err = nc_get_vars_long(BAD_ID, i, start, edge, stride, value);
#line 596
        IF (err != NC_EBADID)
#line 596
            error("bad ncid: status = %d", err);
#line 596
        err = nc_get_vars_long(ncid, BAD_VARID, start, edge, stride, value);
#line 596
        IF (err != NC_ENOTVAR)
#line 596
            error("bad var id: status = %d", err);
#line 596
        for (j = 0; j < var_rank[i]; j++) {
#line 596
            start[j] = var_shape[i][j];
#line 596
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
#line 596
	  if(!canConvert) {
#line 596
		IF (err != NC_ECHAR)
#line 596
               	    error("conversion: status = %d", err);
#line 596
	  } else {
#line 596
            IF (err != NC_EINVALCOORDS)
#line 596
                error("bad index: status = %d", err);
#line 596
            start[j] = 0;
#line 596
            edge[j] = var_shape[i][j] + 1;
#line 596
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
#line 596
            IF (err != NC_EEDGE)
#line 596
                error("bad edge: status = %d", err);
#line 596
            edge[j] = 1;
#line 596
            stride[j] = 0;
#line 596
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
#line 596
            IF (err != NC_ESTRIDE)
#line 596
                error("bad stride: status = %d", err);
#line 596
            stride[j] = 1;
#line 596
	  }
#line 596
        }
#line 596
            /* Choose a random point dividing each dim into 2 parts */
#line 596
            /* get 2^rank (nslabs) slabs so defined */
#line 596
        nslabs = 1;
#line 596
        for (j = 0; j < var_rank[i]; j++) {
#line 596
            mid[j] = roll( var_shape[i][j] );
#line 596
            nslabs *= 2;
#line 596
        }
#line 596
            /* bits of k determine whether to get lower or upper part of dim */
#line 596
            /* choose random stride from 1 to edge */
#line 596
        for (k = 0; k < nslabs; k++) {
#line 596
            nstarts = 1;
#line 596
            for (j = 0; j < var_rank[i]; j++) {
#line 596
                if ((k >> j) & 1) {
#line 596
                    start[j] = 0;
#line 596
                    edge[j] = mid[j];
#line 596
                }else{
#line 596
                    start[j] = mid[j];
#line 596
                    edge[j] = var_shape[i][j] - mid[j];
#line 596
                }
#line 596
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 596
                nstarts *= stride[j];
#line 596
            }
#line 596
            for (m = 0; m < nstarts; m++) {
#line 596
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 596
                IF (err)
#line 596
                    error("error in toMixedBase");
#line 596
                nels = 1;
#line 596
                for (j = 0; j < var_rank[i]; j++) {
#line 596
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 596
                    nels *= count[j];
#line 596
                    index[j] += start[j];
#line 596
                }
#line 596
                        /* Random choice of forward or backward */
#line 596
/* TODO
#line 596
                if ( roll(2) ) {
#line 596
                    for (j = 0; j < var_rank[i]; j++) {
#line 596
                        index[j] += (count[j] - 1) * stride[j];
#line 596
                        stride[j] = -stride[j];
#line 596
                    }
#line 596
                }
#line 596
*/
#line 596
		allInExtRange = allInIntRange = 1;
#line 596
		for (j = 0; j < nels; j++) {
#line 596
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 596
		    IF (err)
#line 596
			error("error in toMixedBase 1");
#line 596
		    for (d = 0; d < var_rank[i]; d++)
#line 596
			index2[d] = index[d] + index2[d] * stride[d];
#line 596
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 596
			NCT_LONG);
#line 596
		    if (inRange3(expect[j],var_type[i],NCT_LONG)) {
#line 596
			allInIntRange = allInIntRange && expect[j] >= long_min
#line 596
			    && expect[j] <= long_max;
#line 596
		    } else {
#line 596
			allInExtRange = 0;
#line 596
		    }
#line 596
		}
#line 596
                if (var_rank[i] == 0 && i%2 )
#line 596
                    err = nc_get_vars_long(ncid, i, NULL, NULL, NULL, value);
#line 596
                else
#line 596
                    err = nc_get_vars_long(ncid, i, index, count, stride, value);
#line 596
		if (canConvert) {
#line 596
		    if (allInExtRange) {
#line 596
			if (allInIntRange) {
#line 596
			    IF (err)
#line 596
				error("%s", nc_strerror(err));
#line 596
			} else {
#line 596
			    IF (err != NC_ERANGE)
#line 596
				error("Range error: status = %d", err);
#line 596
			}
#line 596
		    } else {
#line 596
			IF (err != 0 && err != NC_ERANGE)
#line 596
			    error("OK or Range error: status = %d", err);
#line 596
		    }
#line 596
		    for (j = 0; j < nels; j++) {
#line 596
			if (inRange3(expect[j],var_type[i],NCT_LONG)
#line 596
				&& expect[j] >= long_min && expect[j] <= long_max) {
#line 596
			    IF (!equal(value[j],expect[j],var_type[i], NCT_LONG)){
#line 596
				error("value read not that expected");
#line 596
				if (verbose) {
#line 596
				    error("\n");
#line 596
				    error("varid: %d, ", i);
#line 596
				    error("var_name: %s, ", var_name[i]);
#line 596
				    error("element number: %d ", j);
#line 596
                                    error("expect: %g, ", expect[j]);
#line 596
				    error("got: %g", (double) value[j]);
#line 596
				}
#line 596
			    } else {
#line 596
				nok++;
#line 596
			    }
#line 596
			}
#line 596
		    }
#line 596
		} else {
#line 596
		    IF (nels > 0 && err != NC_ECHAR)
#line 596
			error("wrong type: status = %d", err);
#line 596
		}
#line 596
	    }
#line 596
	}
#line 596

#line 596
    }
#line 596
    err = nc_close(ncid);
#line 596
    IF (err)
#line 596
        error("nc_close: %s", nc_strerror(err));
#line 596
    print_nok(nok);
#line 596
}
#line 596

void
#line 597
test_nc_get_vars_float(void)
#line 597
{
#line 597
    int ncid;
#line 597
    int d;
#line 597
    int i;
#line 597
    int j;
#line 597
    int k;
#line 597
    int m;
#line 597
    int err;
#line 597
    int allInExtRange;	/* all values within external range? */
#line 597
    int allInIntRange;	/* all values within internal range? */
#line 597
    int nels;
#line 597
    int nslabs;
#line 597
    int nstarts;        /* number of different starts */
#line 597
    int nok = 0;      /* count of valid comparisons */
#line 597
    size_t start[MAX_RANK];
#line 597
    size_t edge[MAX_RANK];
#line 597
    size_t index[MAX_RANK];
#line 597
    size_t index2[MAX_RANK];
#line 597
    size_t mid[MAX_RANK];
#line 597
    size_t count[MAX_RANK];
#line 597
    size_t sstride[MAX_RANK];
#line 597
    ptrdiff_t stride[MAX_RANK];
#line 597
    int canConvert;     /* Both text or both numeric */
#line 597
    float value[MAX_NELS];
#line 597
    double expect[MAX_NELS];
#line 597

#line 597
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 597
    IF (err)
#line 597
        error("nc_open: %s", nc_strerror(err));
#line 597
    for (i = 0; i < NVARS; i++) {
#line 597
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 597
        assert(var_rank[i] <= MAX_RANK);
#line 597
        assert(var_nels[i] <= MAX_NELS);
#line 597
        for (j = 0; j < var_rank[i]; j++) {
#line 597
            start[j] = 0;
#line 597
            edge[j] = 1;
#line 597
            stride[j] = 1;
#line 597
        }
#line 597
        err = nc_get_vars_float(BAD_ID, i, start, edge, stride, value);
#line 597
        IF (err != NC_EBADID)
#line 597
            error("bad ncid: status = %d", err);
#line 597
        err = nc_get_vars_float(ncid, BAD_VARID, start, edge, stride, value);
#line 597
        IF (err != NC_ENOTVAR)
#line 597
            error("bad var id: status = %d", err);
#line 597
        for (j = 0; j < var_rank[i]; j++) {
#line 597
            start[j] = var_shape[i][j];
#line 597
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
#line 597
	  if(!canConvert) {
#line 597
		IF (err != NC_ECHAR)
#line 597
               	    error("conversion: status = %d", err);
#line 597
	  } else {
#line 597
            IF (err != NC_EINVALCOORDS)
#line 597
                error("bad index: status = %d", err);
#line 597
            start[j] = 0;
#line 597
            edge[j] = var_shape[i][j] + 1;
#line 597
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
#line 597
            IF (err != NC_EEDGE)
#line 597
                error("bad edge: status = %d", err);
#line 597
            edge[j] = 1;
#line 597
            stride[j] = 0;
#line 597
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
#line 597
            IF (err != NC_ESTRIDE)
#line 597
                error("bad stride: status = %d", err);
#line 597
            stride[j] = 1;
#line 597
	  }
#line 597
        }
#line 597
            /* Choose a random point dividing each dim into 2 parts */
#line 597
            /* get 2^rank (nslabs) slabs so defined */
#line 597
        nslabs = 1;
#line 597
        for (j = 0; j < var_rank[i]; j++) {
#line 597
            mid[j] = roll( var_shape[i][j] );
#line 597
            nslabs *= 2;
#line 597
        }
#line 597
            /* bits of k determine whether to get lower or upper part of dim */
#line 597
            /* choose random stride from 1 to edge */
#line 597
        for (k = 0; k < nslabs; k++) {
#line 597
            nstarts = 1;
#line 597
            for (j = 0; j < var_rank[i]; j++) {
#line 597
                if ((k >> j) & 1) {
#line 597
                    start[j] = 0;
#line 597
                    edge[j] = mid[j];
#line 597
                }else{
#line 597
                    start[j] = mid[j];
#line 597
                    edge[j] = var_shape[i][j] - mid[j];
#line 597
                }
#line 597
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 597
                nstarts *= stride[j];
#line 597
            }
#line 597
            for (m = 0; m < nstarts; m++) {
#line 597
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 597
                IF (err)
#line 597
                    error("error in toMixedBase");
#line 597
                nels = 1;
#line 597
                for (j = 0; j < var_rank[i]; j++) {
#line 597
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 597
                    nels *= count[j];
#line 597
                    index[j] += start[j];
#line 597
                }
#line 597
                        /* Random choice of forward or backward */
#line 597
/* TODO
#line 597
                if ( roll(2) ) {
#line 597
                    for (j = 0; j < var_rank[i]; j++) {
#line 597
                        index[j] += (count[j] - 1) * stride[j];
#line 597
                        stride[j] = -stride[j];
#line 597
                    }
#line 597
                }
#line 597
*/
#line 597
		allInExtRange = allInIntRange = 1;
#line 597
		for (j = 0; j < nels; j++) {
#line 597
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 597
		    IF (err)
#line 597
			error("error in toMixedBase 1");
#line 597
		    for (d = 0; d < var_rank[i]; d++)
#line 597
			index2[d] = index[d] + index2[d] * stride[d];
#line 597
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 597
			NCT_FLOAT);
#line 597
		    if (inRange3(expect[j],var_type[i],NCT_FLOAT)) {
#line 597
			allInIntRange = allInIntRange && expect[j] >= float_min
#line 597
			    && expect[j] <= float_max;
#line 597
		    } else {
#line 597
			allInExtRange = 0;
#line 597
		    }
#line 597
		}
#line 597
                if (var_rank[i] == 0 && i%2 )
#line 597
                    err = nc_get_vars_float(ncid, i, NULL, NULL, NULL, value);
#line 597
                else
#line 597
                    err = nc_get_vars_float(ncid, i, index, count, stride, value);
#line 597
		if (canConvert) {
#line 597
		    if (allInExtRange) {
#line 597
			if (allInIntRange) {
#line 597
			    IF (err)
#line 597
				error("%s", nc_strerror(err));
#line 597
			} else {
#line 597
			    IF (err != NC_ERANGE)
#line 597
				error("Range error: status = %d", err);
#line 597
			}
#line 597
		    } else {
#line 597
			IF (err != 0 && err != NC_ERANGE)
#line 597
			    error("OK or Range error: status = %d", err);
#line 597
		    }
#line 597
		    for (j = 0; j < nels; j++) {
#line 597
			if (inRange3(expect[j],var_type[i],NCT_FLOAT)
#line 597
				&& expect[j] >= float_min && expect[j] <= float_max) {
#line 597
			    IF (!equal(value[j],expect[j],var_type[i], NCT_FLOAT)){
#line 597
				error("value read not that expected");
#line 597
				if (verbose) {
#line 597
				    error("\n");
#line 597
				    error("varid: %d, ", i);
#line 597
				    error("var_name: %s, ", var_name[i]);
#line 597
				    error("element number: %d ", j);
#line 597
                                    error("expect: %g, ", expect[j]);
#line 597
				    error("got: %g", (double) value[j]);
#line 597
				}
#line 597
			    } else {
#line 597
				nok++;
#line 597
			    }
#line 597
			}
#line 597
		    }
#line 597
		} else {
#line 597
		    IF (nels > 0 && err != NC_ECHAR)
#line 597
			error("wrong type: status = %d", err);
#line 597
		}
#line 597
	    }
#line 597
	}
#line 597

#line 597
    }
#line 597
    err = nc_close(ncid);
#line 597
    IF (err)
#line 597
        error("nc_close: %s", nc_strerror(err));
#line 597
    print_nok(nok);
#line 597
}
#line 597

void
#line 598
test_nc_get_vars_double(void)
#line 598
{
#line 598
    int ncid;
#line 598
    int d;
#line 598
    int i;
#line 598
    int j;
#line 598
    int k;
#line 598
    int m;
#line 598
    int err;
#line 598
    int allInExtRange;	/* all values within external range? */
#line 598
    int allInIntRange;	/* all values within internal range? */
#line 598
    int nels;
#line 598
    int nslabs;
#line 598
    int nstarts;        /* number of different starts */
#line 598
    int nok = 0;      /* count of valid comparisons */
#line 598
    size_t start[MAX_RANK];
#line 598
    size_t edge[MAX_RANK];
#line 598
    size_t index[MAX_RANK];
#line 598
    size_t index2[MAX_RANK];
#line 598
    size_t mid[MAX_RANK];
#line 598
    size_t count[MAX_RANK];
#line 598
    size_t sstride[MAX_RANK];
#line 598
    ptrdiff_t stride[MAX_RANK];
#line 598
    int canConvert;     /* Both text or both numeric */
#line 598
    double value[MAX_NELS];
#line 598
    double expect[MAX_NELS];
#line 598

#line 598
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 598
    IF (err)
#line 598
        error("nc_open: %s", nc_strerror(err));
#line 598
    for (i = 0; i < NVARS; i++) {
#line 598
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 598
        assert(var_rank[i] <= MAX_RANK);
#line 598
        assert(var_nels[i] <= MAX_NELS);
#line 598
        for (j = 0; j < var_rank[i]; j++) {
#line 598
            start[j] = 0;
#line 598
            edge[j] = 1;
#line 598
            stride[j] = 1;
#line 598
        }
#line 598
        err = nc_get_vars_double(BAD_ID, i, start, edge, stride, value);
#line 598
        IF (err != NC_EBADID)
#line 598
            error("bad ncid: status = %d", err);
#line 598
        err = nc_get_vars_double(ncid, BAD_VARID, start, edge, stride, value);
#line 598
        IF (err != NC_ENOTVAR)
#line 598
            error("bad var id: status = %d", err);
#line 598
        for (j = 0; j < var_rank[i]; j++) {
#line 598
            start[j] = var_shape[i][j];
#line 598
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
#line 598
	  if(!canConvert) {
#line 598
		IF (err != NC_ECHAR)
#line 598
               	    error("conversion: status = %d", err);
#line 598
	  } else {
#line 598
            IF (err != NC_EINVALCOORDS)
#line 598
                error("bad index: status = %d", err);
#line 598
            start[j] = 0;
#line 598
            edge[j] = var_shape[i][j] + 1;
#line 598
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
#line 598
            IF (err != NC_EEDGE)
#line 598
                error("bad edge: status = %d", err);
#line 598
            edge[j] = 1;
#line 598
            stride[j] = 0;
#line 598
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
#line 598
            IF (err != NC_ESTRIDE)
#line 598
                error("bad stride: status = %d", err);
#line 598
            stride[j] = 1;
#line 598
	  }
#line 598
        }
#line 598
            /* Choose a random point dividing each dim into 2 parts */
#line 598
            /* get 2^rank (nslabs) slabs so defined */
#line 598
        nslabs = 1;
#line 598
        for (j = 0; j < var_rank[i]; j++) {
#line 598
            mid[j] = roll( var_shape[i][j] );
#line 598
            nslabs *= 2;
#line 598
        }
#line 598
            /* bits of k determine whether to get lower or upper part of dim */
#line 598
            /* choose random stride from 1 to edge */
#line 598
        for (k = 0; k < nslabs; k++) {
#line 598
            nstarts = 1;
#line 598
            for (j = 0; j < var_rank[i]; j++) {
#line 598
                if ((k >> j) & 1) {
#line 598
                    start[j] = 0;
#line 598
                    edge[j] = mid[j];
#line 598
                }else{
#line 598
                    start[j] = mid[j];
#line 598
                    edge[j] = var_shape[i][j] - mid[j];
#line 598
                }
#line 598
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 598
                nstarts *= stride[j];
#line 598
            }
#line 598
            for (m = 0; m < nstarts; m++) {
#line 598
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 598
                IF (err)
#line 598
                    error("error in toMixedBase");
#line 598
                nels = 1;
#line 598
                for (j = 0; j < var_rank[i]; j++) {
#line 598
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 598
                    nels *= count[j];
#line 598
                    index[j] += start[j];
#line 598
                }
#line 598
                        /* Random choice of forward or backward */
#line 598
/* TODO
#line 598
                if ( roll(2) ) {
#line 598
                    for (j = 0; j < var_rank[i]; j++) {
#line 598
                        index[j] += (count[j] - 1) * stride[j];
#line 598
                        stride[j] = -stride[j];
#line 598
                    }
#line 598
                }
#line 598
*/
#line 598
		allInExtRange = allInIntRange = 1;
#line 598
		for (j = 0; j < nels; j++) {
#line 598
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 598
		    IF (err)
#line 598
			error("error in toMixedBase 1");
#line 598
		    for (d = 0; d < var_rank[i]; d++)
#line 598
			index2[d] = index[d] + index2[d] * stride[d];
#line 598
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 598
			NCT_DOUBLE);
#line 598
		    if (inRange3(expect[j],var_type[i],NCT_DOUBLE)) {
#line 598
			allInIntRange = allInIntRange && expect[j] >= double_min
#line 598
			    && expect[j] <= double_max;
#line 598
		    } else {
#line 598
			allInExtRange = 0;
#line 598
		    }
#line 598
		}
#line 598
                if (var_rank[i] == 0 && i%2 )
#line 598
                    err = nc_get_vars_double(ncid, i, NULL, NULL, NULL, value);
#line 598
                else
#line 598
                    err = nc_get_vars_double(ncid, i, index, count, stride, value);
#line 598
		if (canConvert) {
#line 598
		    if (allInExtRange) {
#line 598
			if (allInIntRange) {
#line 598
			    IF (err)
#line 598
				error("%s", nc_strerror(err));
#line 598
			} else {
#line 598
			    IF (err != NC_ERANGE)
#line 598
				error("Range error: status = %d", err);
#line 598
			}
#line 598
		    } else {
#line 598
			IF (err != 0 && err != NC_ERANGE)
#line 598
			    error("OK or Range error: status = %d", err);
#line 598
		    }
#line 598
		    for (j = 0; j < nels; j++) {
#line 598
			if (inRange3(expect[j],var_type[i],NCT_DOUBLE)
#line 598
				&& expect[j] >= double_min && expect[j] <= double_max) {
#line 598
			    IF (!equal(value[j],expect[j],var_type[i], NCT_DOUBLE)){
#line 598
				error("value read not that expected");
#line 598
				if (verbose) {
#line 598
				    error("\n");
#line 598
				    error("varid: %d, ", i);
#line 598
				    error("var_name: %s, ", var_name[i]);
#line 598
				    error("element number: %d ", j);
#line 598
                                    error("expect: %g, ", expect[j]);
#line 598
				    error("got: %g", (double) value[j]);
#line 598
				}
#line 598
			    } else {
#line 598
				nok++;
#line 598
			    }
#line 598
			}
#line 598
		    }
#line 598
		} else {
#line 598
		    IF (nels > 0 && err != NC_ECHAR)
#line 598
			error("wrong type: status = %d", err);
#line 598
		}
#line 598
	    }
#line 598
	}
#line 598

#line 598
    }
#line 598
    err = nc_close(ncid);
#line 598
    IF (err)
#line 598
        error("nc_close: %s", nc_strerror(err));
#line 598
    print_nok(nok);
#line 598
}
#line 598



#line 787

void
#line 788
test_nc_get_varm_text(void)
#line 788
{
#line 788
    int ncid;
#line 788
    int d;
#line 788
    int i;
#line 788
    int j;
#line 788
    int k;
#line 788
    int m;
#line 788
    int err;
#line 788
    int allInExtRange;	/* all values within external range? */
#line 788
    int allInIntRange;	/* all values within internal range? */
#line 788
    int nels;
#line 788
    int nslabs;
#line 788
    int nstarts;        /* number of different starts */
#line 788
    int nok = 0;      /* count of valid comparisons */
#line 788
    size_t start[MAX_RANK];
#line 788
    size_t edge[MAX_RANK];
#line 788
    size_t index[MAX_RANK];
#line 788
    size_t index2[MAX_RANK];
#line 788
    size_t mid[MAX_RANK];
#line 788
    size_t count[MAX_RANK];
#line 788
    size_t sstride[MAX_RANK];
#line 788
    ptrdiff_t stride[MAX_RANK];
#line 788
    ptrdiff_t imap[MAX_RANK];
#line 788
    int canConvert;     /* Both text or both numeric */
#line 788
    text value[MAX_NELS];
#line 788
    double expect[MAX_NELS];
#line 788

#line 788
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 788
    IF (err)
#line 788
        error("nc_open: %s", nc_strerror(err));
#line 788
    for (i = 0; i < NVARS; i++) {
#line 788
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 788
        assert(var_rank[i] <= MAX_RANK);
#line 788
        assert(var_nels[i] <= MAX_NELS);
#line 788
        for (j = 0; j < var_rank[i]; j++) {
#line 788
            start[j] = 0;
#line 788
            edge[j] = 1;
#line 788
            stride[j] = 1;
#line 788
            imap[j] = 1;
#line 788
        }
#line 788
        err = nc_get_varm_text(BAD_ID, i, start, edge, stride, imap, value);
#line 788
        IF (err != NC_EBADID)
#line 788
            error("bad ncid: status = %d", err);
#line 788
        err = nc_get_varm_text(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 788
        IF (err != NC_ENOTVAR)
#line 788
            error("bad var id: status = %d", err);
#line 788
        for (j = 0; j < var_rank[i]; j++) {
#line 788
            start[j] = var_shape[i][j];
#line 788
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
#line 788
	  if(!canConvert) {
#line 788
		IF (err != NC_ECHAR)
#line 788
               	    error("conversion: status = %d", err);
#line 788
	  } else {
#line 788
	    IF (err != NC_EINVALCOORDS)
#line 788
                error("bad index: status = %d", err);
#line 788
            start[j] = 0;
#line 788
            edge[j] = var_shape[i][j] + 1;
#line 788
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
#line 788
            IF (err != NC_EEDGE)
#line 788
                error("bad edge: status = %d", err);
#line 788
            edge[j] = 1;
#line 788
            stride[j] = 0;
#line 788
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
#line 788
            IF (err != NC_ESTRIDE)
#line 788
                error("bad stride: status = %d", err);
#line 788
            stride[j] = 1;
#line 788
           }
#line 788
        }
#line 788
            /* Choose a random point dividing each dim into 2 parts */
#line 788
            /* get 2^rank (nslabs) slabs so defined */
#line 788
        nslabs = 1;
#line 788
        for (j = 0; j < var_rank[i]; j++) {
#line 788
            mid[j] = roll( var_shape[i][j] );
#line 788
            nslabs *= 2;
#line 788
        }
#line 788
            /* bits of k determine whether to get lower or upper part of dim */
#line 788
            /* choose random stride from 1 to edge */
#line 788
        for (k = 0; k < nslabs; k++) {
#line 788
            nstarts = 1;
#line 788
            for (j = 0; j < var_rank[i]; j++) {
#line 788
                if ((k >> j) & 1) {
#line 788
                    start[j] = 0;
#line 788
                    edge[j] = mid[j];
#line 788
                }else{
#line 788
                    start[j] = mid[j];
#line 788
                    edge[j] = var_shape[i][j] - mid[j];
#line 788
                }
#line 788
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 788
                nstarts *= stride[j];
#line 788
            }
#line 788
            for (m = 0; m < nstarts; m++) {
#line 788
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 788
                IF (err)
#line 788
                    error("error in toMixedBase");
#line 788
                nels = 1;
#line 788
                for (j = 0; j < var_rank[i]; j++) {
#line 788
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 788
                    nels *= count[j];
#line 788
                    index[j] += start[j];
#line 788
                }
#line 788
		    /* Random choice of forward or backward */
#line 788
/* TODO
#line 788
		if ( roll(2) ) {
#line 788
		    for (j = 0; j < var_rank[i]; j++) {
#line 788
			index[j] += (count[j] - 1) * stride[j];
#line 788
			stride[j] = -stride[j];
#line 788
		    }
#line 788
		}
#line 788
 */
#line 788
		if (var_rank[i] > 0) {
#line 788
		    j = var_rank[i] - 1;
#line 788
		    imap[j] = 1;
#line 788
		    for (; j > 0; j--)
#line 788
			imap[j-1] = imap[j] * count[j];
#line 788
		}
#line 788
                allInExtRange = allInIntRange = 1;
#line 788
                for (j = 0; j < nels; j++) {
#line 788
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 788
                    IF (err)
#line 788
                        error("error in toMixedBase 1");
#line 788
                    for (d = 0; d < var_rank[i]; d++)
#line 788
                        index2[d] = index[d] + index2[d] * stride[d];
#line 788
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 788
                        NCT_TEXT);
#line 788
                    if (inRange3(expect[j],var_type[i],NCT_TEXT)) {
#line 788
                        allInIntRange = allInIntRange && expect[j] >= text_min
#line 788
                            && expect[j] <= text_max;
#line 788
                    } else {
#line 788
                        allInExtRange = 0;
#line 788
                    }
#line 788
                }
#line 788
                if (var_rank[i] == 0 && i%2 )
#line 788
                    err = nc_get_varm_text(ncid,i,NULL,NULL,NULL,NULL,value);
#line 788
                else
#line 788
                    err = nc_get_varm_text(ncid,i,index,count,stride,imap,value);
#line 788
                if (canConvert) {
#line 788
                    if (allInExtRange) {
#line 788
                        if (allInIntRange) {
#line 788
                            IF (err)
#line 788
                                error("%s", nc_strerror(err));
#line 788
                        } else {
#line 788
                            IF (err != NC_ERANGE)
#line 788
                                error("Range error: status = %d", err);
#line 788
                        }
#line 788
                    } else {
#line 788
                        IF (err != 0 && err != NC_ERANGE)
#line 788
                            error("OK or Range error: status = %d", err);
#line 788
                    }
#line 788
                    for (j = 0; j < nels; j++) {
#line 788
                        if (inRange3(expect[j],var_type[i],NCT_TEXT)
#line 788
                                && expect[j] >= text_min 
#line 788
				&& expect[j] <= text_max) {
#line 788
			    IF (!equal(value[j],expect[j],var_type[i], NCT_TEXT)){
#line 788
                                error("value read not that expected");
#line 788
                                if (verbose) {
#line 788
                                    error("\n");
#line 788
                                    error("varid: %d, ", i);
#line 788
                                    error("var_name: %s, ", var_name[i]);
#line 788
                                    error("element number: %d ", j);
#line 788
                                    error("expect: %g, ", expect[j]);
#line 788
                                    error("got: %g", (double) value[j]);
#line 788
                                }
#line 788
                            } else {
#line 788
                                nok++;
#line 788
                            }
#line 788
                        }
#line 788
                    }
#line 788
                } else {
#line 788
                    IF (nels > 0 && err != NC_ECHAR)
#line 788
                        error("wrong type: status = %d", err);
#line 788
                }
#line 788
            }
#line 788
        }
#line 788
    }
#line 788
    err = nc_close(ncid);
#line 788
    IF (err)
#line 788
        error("nc_close: %s", nc_strerror(err));
#line 788
    print_nok(nok);
#line 788
}
#line 788

void
#line 789
test_nc_get_varm_uchar(void)
#line 789
{
#line 789
    int ncid;
#line 789
    int d;
#line 789
    int i;
#line 789
    int j;
#line 789
    int k;
#line 789
    int m;
#line 789
    int err;
#line 789
    int allInExtRange;	/* all values within external range? */
#line 789
    int allInIntRange;	/* all values within internal range? */
#line 789
    int nels;
#line 789
    int nslabs;
#line 789
    int nstarts;        /* number of different starts */
#line 789
    int nok = 0;      /* count of valid comparisons */
#line 789
    size_t start[MAX_RANK];
#line 789
    size_t edge[MAX_RANK];
#line 789
    size_t index[MAX_RANK];
#line 789
    size_t index2[MAX_RANK];
#line 789
    size_t mid[MAX_RANK];
#line 789
    size_t count[MAX_RANK];
#line 789
    size_t sstride[MAX_RANK];
#line 789
    ptrdiff_t stride[MAX_RANK];
#line 789
    ptrdiff_t imap[MAX_RANK];
#line 789
    int canConvert;     /* Both text or both numeric */
#line 789
    uchar value[MAX_NELS];
#line 789
    double expect[MAX_NELS];
#line 789

#line 789
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 789
    IF (err)
#line 789
        error("nc_open: %s", nc_strerror(err));
#line 789
    for (i = 0; i < NVARS; i++) {
#line 789
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 789
        assert(var_rank[i] <= MAX_RANK);
#line 789
        assert(var_nels[i] <= MAX_NELS);
#line 789
        for (j = 0; j < var_rank[i]; j++) {
#line 789
            start[j] = 0;
#line 789
            edge[j] = 1;
#line 789
            stride[j] = 1;
#line 789
            imap[j] = 1;
#line 789
        }
#line 789
        err = nc_get_varm_uchar(BAD_ID, i, start, edge, stride, imap, value);
#line 789
        IF (err != NC_EBADID)
#line 789
            error("bad ncid: status = %d", err);
#line 789
        err = nc_get_varm_uchar(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 789
        IF (err != NC_ENOTVAR)
#line 789
            error("bad var id: status = %d", err);
#line 789
        for (j = 0; j < var_rank[i]; j++) {
#line 789
            start[j] = var_shape[i][j];
#line 789
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 789
	  if(!canConvert) {
#line 789
		IF (err != NC_ECHAR)
#line 789
               	    error("conversion: status = %d", err);
#line 789
	  } else {
#line 789
	    IF (err != NC_EINVALCOORDS)
#line 789
                error("bad index: status = %d", err);
#line 789
            start[j] = 0;
#line 789
            edge[j] = var_shape[i][j] + 1;
#line 789
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 789
            IF (err != NC_EEDGE)
#line 789
                error("bad edge: status = %d", err);
#line 789
            edge[j] = 1;
#line 789
            stride[j] = 0;
#line 789
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 789
            IF (err != NC_ESTRIDE)
#line 789
                error("bad stride: status = %d", err);
#line 789
            stride[j] = 1;
#line 789
           }
#line 789
        }
#line 789
            /* Choose a random point dividing each dim into 2 parts */
#line 789
            /* get 2^rank (nslabs) slabs so defined */
#line 789
        nslabs = 1;
#line 789
        for (j = 0; j < var_rank[i]; j++) {
#line 789
            mid[j] = roll( var_shape[i][j] );
#line 789
            nslabs *= 2;
#line 789
        }
#line 789
            /* bits of k determine whether to get lower or upper part of dim */
#line 789
            /* choose random stride from 1 to edge */
#line 789
        for (k = 0; k < nslabs; k++) {
#line 789
            nstarts = 1;
#line 789
            for (j = 0; j < var_rank[i]; j++) {
#line 789
                if ((k >> j) & 1) {
#line 789
                    start[j] = 0;
#line 789
                    edge[j] = mid[j];
#line 789
                }else{
#line 789
                    start[j] = mid[j];
#line 789
                    edge[j] = var_shape[i][j] - mid[j];
#line 789
                }
#line 789
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 789
                nstarts *= stride[j];
#line 789
            }
#line 789
            for (m = 0; m < nstarts; m++) {
#line 789
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 789
                IF (err)
#line 789
                    error("error in toMixedBase");
#line 789
                nels = 1;
#line 789
                for (j = 0; j < var_rank[i]; j++) {
#line 789
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 789
                    nels *= count[j];
#line 789
                    index[j] += start[j];
#line 789
                }
#line 789
		    /* Random choice of forward or backward */
#line 789
/* TODO
#line 789
		if ( roll(2) ) {
#line 789
		    for (j = 0; j < var_rank[i]; j++) {
#line 789
			index[j] += (count[j] - 1) * stride[j];
#line 789
			stride[j] = -stride[j];
#line 789
		    }
#line 789
		}
#line 789
 */
#line 789
		if (var_rank[i] > 0) {
#line 789
		    j = var_rank[i] - 1;
#line 789
		    imap[j] = 1;
#line 789
		    for (; j > 0; j--)
#line 789
			imap[j-1] = imap[j] * count[j];
#line 789
		}
#line 789
                allInExtRange = allInIntRange = 1;
#line 789
                for (j = 0; j < nels; j++) {
#line 789
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 789
                    IF (err)
#line 789
                        error("error in toMixedBase 1");
#line 789
                    for (d = 0; d < var_rank[i]; d++)
#line 789
                        index2[d] = index[d] + index2[d] * stride[d];
#line 789
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 789
                        NCT_UCHAR);
#line 789
                    if (inRange3(expect[j],var_type[i],NCT_UCHAR)) {
#line 789
                        allInIntRange = allInIntRange && expect[j] >= uchar_min
#line 789
                            && expect[j] <= uchar_max;
#line 789
                    } else {
#line 789
                        allInExtRange = 0;
#line 789
                    }
#line 789
                }
#line 789
                if (var_rank[i] == 0 && i%2 )
#line 789
                    err = nc_get_varm_uchar(ncid,i,NULL,NULL,NULL,NULL,value);
#line 789
                else
#line 789
                    err = nc_get_varm_uchar(ncid,i,index,count,stride,imap,value);
#line 789
                if (canConvert) {
#line 789
                    if (allInExtRange) {
#line 789
                        if (allInIntRange) {
#line 789
                            IF (err)
#line 789
                                error("%s", nc_strerror(err));
#line 789
                        } else {
#line 789
                            IF (err != NC_ERANGE)
#line 789
                                error("Range error: status = %d", err);
#line 789
                        }
#line 789
                    } else {
#line 789
                        IF (err != 0 && err != NC_ERANGE)
#line 789
                            error("OK or Range error: status = %d", err);
#line 789
                    }
#line 789
                    for (j = 0; j < nels; j++) {
#line 789
                        if (inRange3(expect[j],var_type[i],NCT_UCHAR)
#line 789
                                && expect[j] >= uchar_min 
#line 789
				&& expect[j] <= uchar_max) {
#line 789
			    IF (!equal(value[j],expect[j],var_type[i], NCT_UCHAR)){
#line 789
                                error("value read not that expected");
#line 789
                                if (verbose) {
#line 789
                                    error("\n");
#line 789
                                    error("varid: %d, ", i);
#line 789
                                    error("var_name: %s, ", var_name[i]);
#line 789
                                    error("element number: %d ", j);
#line 789
                                    error("expect: %g, ", expect[j]);
#line 789
                                    error("got: %g", (double) value[j]);
#line 789
                                }
#line 789
                            } else {
#line 789
                                nok++;
#line 789
                            }
#line 789
                        }
#line 789
                    }
#line 789
                } else {
#line 789
                    IF (nels > 0 && err != NC_ECHAR)
#line 789
                        error("wrong type: status = %d", err);
#line 789
                }
#line 789
            }
#line 789
        }
#line 789
    }
#line 789
    err = nc_close(ncid);
#line 789
    IF (err)
#line 789
        error("nc_close: %s", nc_strerror(err));
#line 789
    print_nok(nok);
#line 789
}
#line 789

void
#line 790
test_nc_get_varm_schar(void)
#line 790
{
#line 790
    int ncid;
#line 790
    int d;
#line 790
    int i;
#line 790
    int j;
#line 790
    int k;
#line 790
    int m;
#line 790
    int err;
#line 790
    int allInExtRange;	/* all values within external range? */
#line 790
    int allInIntRange;	/* all values within internal range? */
#line 790
    int nels;
#line 790
    int nslabs;
#line 790
    int nstarts;        /* number of different starts */
#line 790
    int nok = 0;      /* count of valid comparisons */
#line 790
    size_t start[MAX_RANK];
#line 790
    size_t edge[MAX_RANK];
#line 790
    size_t index[MAX_RANK];
#line 790
    size_t index2[MAX_RANK];
#line 790
    size_t mid[MAX_RANK];
#line 790
    size_t count[MAX_RANK];
#line 790
    size_t sstride[MAX_RANK];
#line 790
    ptrdiff_t stride[MAX_RANK];
#line 790
    ptrdiff_t imap[MAX_RANK];
#line 790
    int canConvert;     /* Both text or both numeric */
#line 790
    schar value[MAX_NELS];
#line 790
    double expect[MAX_NELS];
#line 790

#line 790
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 790
    IF (err)
#line 790
        error("nc_open: %s", nc_strerror(err));
#line 790
    for (i = 0; i < NVARS; i++) {
#line 790
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 790
        assert(var_rank[i] <= MAX_RANK);
#line 790
        assert(var_nels[i] <= MAX_NELS);
#line 790
        for (j = 0; j < var_rank[i]; j++) {
#line 790
            start[j] = 0;
#line 790
            edge[j] = 1;
#line 790
            stride[j] = 1;
#line 790
            imap[j] = 1;
#line 790
        }
#line 790
        err = nc_get_varm_schar(BAD_ID, i, start, edge, stride, imap, value);
#line 790
        IF (err != NC_EBADID)
#line 790
            error("bad ncid: status = %d", err);
#line 790
        err = nc_get_varm_schar(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 790
        IF (err != NC_ENOTVAR)
#line 790
            error("bad var id: status = %d", err);
#line 790
        for (j = 0; j < var_rank[i]; j++) {
#line 790
            start[j] = var_shape[i][j];
#line 790
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 790
	  if(!canConvert) {
#line 790
		IF (err != NC_ECHAR)
#line 790
               	    error("conversion: status = %d", err);
#line 790
	  } else {
#line 790
	    IF (err != NC_EINVALCOORDS)
#line 790
                error("bad index: status = %d", err);
#line 790
            start[j] = 0;
#line 790
            edge[j] = var_shape[i][j] + 1;
#line 790
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 790
            IF (err != NC_EEDGE)
#line 790
                error("bad edge: status = %d", err);
#line 790
            edge[j] = 1;
#line 790
            stride[j] = 0;
#line 790
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 790
            IF (err != NC_ESTRIDE)
#line 790
                error("bad stride: status = %d", err);
#line 790
            stride[j] = 1;
#line 790
           }
#line 790
        }
#line 790
            /* Choose a random point dividing each dim into 2 parts */
#line 790
            /* get 2^rank (nslabs) slabs so defined */
#line 790
        nslabs = 1;
#line 790
        for (j = 0; j < var_rank[i]; j++) {
#line 790
            mid[j] = roll( var_shape[i][j] );
#line 790
            nslabs *= 2;
#line 790
        }
#line 790
            /* bits of k determine whether to get lower or upper part of dim */
#line 790
            /* choose random stride from 1 to edge */
#line 790
        for (k = 0; k < nslabs; k++) {
#line 790
            nstarts = 1;
#line 790
            for (j = 0; j < var_rank[i]; j++) {
#line 790
                if ((k >> j) & 1) {
#line 790
                    start[j] = 0;
#line 790
                    edge[j] = mid[j];
#line 790
                }else{
#line 790
                    start[j] = mid[j];
#line 790
                    edge[j] = var_shape[i][j] - mid[j];
#line 790
                }
#line 790
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 790
                nstarts *= stride[j];
#line 790
            }
#line 790
            for (m = 0; m < nstarts; m++) {
#line 790
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 790
                IF (err)
#line 790
                    error("error in toMixedBase");
#line 790
                nels = 1;
#line 790
                for (j = 0; j < var_rank[i]; j++) {
#line 790
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 790
                    nels *= count[j];
#line 790
                    index[j] += start[j];
#line 790
                }
#line 790
		    /* Random choice of forward or backward */
#line 790
/* TODO
#line 790
		if ( roll(2) ) {
#line 790
		    for (j = 0; j < var_rank[i]; j++) {
#line 790
			index[j] += (count[j] - 1) * stride[j];
#line 790
			stride[j] = -stride[j];
#line 790
		    }
#line 790
		}
#line 790
 */
#line 790
		if (var_rank[i] > 0) {
#line 790
		    j = var_rank[i] - 1;
#line 790
		    imap[j] = 1;
#line 790
		    for (; j > 0; j--)
#line 790
			imap[j-1] = imap[j] * count[j];
#line 790
		}
#line 790
                allInExtRange = allInIntRange = 1;
#line 790
                for (j = 0; j < nels; j++) {
#line 790
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 790
                    IF (err)
#line 790
                        error("error in toMixedBase 1");
#line 790
                    for (d = 0; d < var_rank[i]; d++)
#line 790
                        index2[d] = index[d] + index2[d] * stride[d];
#line 790
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 790
                        NCT_SCHAR);
#line 790
                    if (inRange3(expect[j],var_type[i],NCT_SCHAR)) {
#line 790
                        allInIntRange = allInIntRange && expect[j] >= schar_min
#line 790
                            && expect[j] <= schar_max;
#line 790
                    } else {
#line 790
                        allInExtRange = 0;
#line 790
                    }
#line 790
                }
#line 790
                if (var_rank[i] == 0 && i%2 )
#line 790
                    err = nc_get_varm_schar(ncid,i,NULL,NULL,NULL,NULL,value);
#line 790
                else
#line 790
                    err = nc_get_varm_schar(ncid,i,index,count,stride,imap,value);
#line 790
                if (canConvert) {
#line 790
                    if (allInExtRange) {
#line 790
                        if (allInIntRange) {
#line 790
                            IF (err)
#line 790
                                error("%s", nc_strerror(err));
#line 790
                        } else {
#line 790
                            IF (err != NC_ERANGE)
#line 790
                                error("Range error: status = %d", err);
#line 790
                        }
#line 790
                    } else {
#line 790
                        IF (err != 0 && err != NC_ERANGE)
#line 790
                            error("OK or Range error: status = %d", err);
#line 790
                    }
#line 790
                    for (j = 0; j < nels; j++) {
#line 790
                        if (inRange3(expect[j],var_type[i],NCT_SCHAR)
#line 790
                                && expect[j] >= schar_min 
#line 790
				&& expect[j] <= schar_max) {
#line 790
			    IF (!equal(value[j],expect[j],var_type[i], NCT_SCHAR)){
#line 790
                                error("value read not that expected");
#line 790
                                if (verbose) {
#line 790
                                    error("\n");
#line 790
                                    error("varid: %d, ", i);
#line 790
                                    error("var_name: %s, ", var_name[i]);
#line 790
                                    error("element number: %d ", j);
#line 790
                                    error("expect: %g, ", expect[j]);
#line 790
                                    error("got: %g", (double) value[j]);
#line 790
                                }
#line 790
                            } else {
#line 790
                                nok++;
#line 790
                            }
#line 790
                        }
#line 790
                    }
#line 790
                } else {
#line 790
                    IF (nels > 0 && err != NC_ECHAR)
#line 790
                        error("wrong type: status = %d", err);
#line 790
                }
#line 790
            }
#line 790
        }
#line 790
    }
#line 790
    err = nc_close(ncid);
#line 790
    IF (err)
#line 790
        error("nc_close: %s", nc_strerror(err));
#line 790
    print_nok(nok);
#line 790
}
#line 790

void
#line 791
test_nc_get_varm_short(void)
#line 791
{
#line 791
    int ncid;
#line 791
    int d;
#line 791
    int i;
#line 791
    int j;
#line 791
    int k;
#line 791
    int m;
#line 791
    int err;
#line 791
    int allInExtRange;	/* all values within external range? */
#line 791
    int allInIntRange;	/* all values within internal range? */
#line 791
    int nels;
#line 791
    int nslabs;
#line 791
    int nstarts;        /* number of different starts */
#line 791
    int nok = 0;      /* count of valid comparisons */
#line 791
    size_t start[MAX_RANK];
#line 791
    size_t edge[MAX_RANK];
#line 791
    size_t index[MAX_RANK];
#line 791
    size_t index2[MAX_RANK];
#line 791
    size_t mid[MAX_RANK];
#line 791
    size_t count[MAX_RANK];
#line 791
    size_t sstride[MAX_RANK];
#line 791
    ptrdiff_t stride[MAX_RANK];
#line 791
    ptrdiff_t imap[MAX_RANK];
#line 791
    int canConvert;     /* Both text or both numeric */
#line 791
    short value[MAX_NELS];
#line 791
    double expect[MAX_NELS];
#line 791

#line 791
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 791
    IF (err)
#line 791
        error("nc_open: %s", nc_strerror(err));
#line 791
    for (i = 0; i < NVARS; i++) {
#line 791
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 791
        assert(var_rank[i] <= MAX_RANK);
#line 791
        assert(var_nels[i] <= MAX_NELS);
#line 791
        for (j = 0; j < var_rank[i]; j++) {
#line 791
            start[j] = 0;
#line 791
            edge[j] = 1;
#line 791
            stride[j] = 1;
#line 791
            imap[j] = 1;
#line 791
        }
#line 791
        err = nc_get_varm_short(BAD_ID, i, start, edge, stride, imap, value);
#line 791
        IF (err != NC_EBADID)
#line 791
            error("bad ncid: status = %d", err);
#line 791
        err = nc_get_varm_short(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 791
        IF (err != NC_ENOTVAR)
#line 791
            error("bad var id: status = %d", err);
#line 791
        for (j = 0; j < var_rank[i]; j++) {
#line 791
            start[j] = var_shape[i][j];
#line 791
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
#line 791
	  if(!canConvert) {
#line 791
		IF (err != NC_ECHAR)
#line 791
               	    error("conversion: status = %d", err);
#line 791
	  } else {
#line 791
	    IF (err != NC_EINVALCOORDS)
#line 791
                error("bad index: status = %d", err);
#line 791
            start[j] = 0;
#line 791
            edge[j] = var_shape[i][j] + 1;
#line 791
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
#line 791
            IF (err != NC_EEDGE)
#line 791
                error("bad edge: status = %d", err);
#line 791
            edge[j] = 1;
#line 791
            stride[j] = 0;
#line 791
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
#line 791
            IF (err != NC_ESTRIDE)
#line 791
                error("bad stride: status = %d", err);
#line 791
            stride[j] = 1;
#line 791
           }
#line 791
        }
#line 791
            /* Choose a random point dividing each dim into 2 parts */
#line 791
            /* get 2^rank (nslabs) slabs so defined */
#line 791
        nslabs = 1;
#line 791
        for (j = 0; j < var_rank[i]; j++) {
#line 791
            mid[j] = roll( var_shape[i][j] );
#line 791
            nslabs *= 2;
#line 791
        }
#line 791
            /* bits of k determine whether to get lower or upper part of dim */
#line 791
            /* choose random stride from 1 to edge */
#line 791
        for (k = 0; k < nslabs; k++) {
#line 791
            nstarts = 1;
#line 791
            for (j = 0; j < var_rank[i]; j++) {
#line 791
                if ((k >> j) & 1) {
#line 791
                    start[j] = 0;
#line 791
                    edge[j] = mid[j];
#line 791
                }else{
#line 791
                    start[j] = mid[j];
#line 791
                    edge[j] = var_shape[i][j] - mid[j];
#line 791
                }
#line 791
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 791
                nstarts *= stride[j];
#line 791
            }
#line 791
            for (m = 0; m < nstarts; m++) {
#line 791
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 791
                IF (err)
#line 791
                    error("error in toMixedBase");
#line 791
                nels = 1;
#line 791
                for (j = 0; j < var_rank[i]; j++) {
#line 791
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 791
                    nels *= count[j];
#line 791
                    index[j] += start[j];
#line 791
                }
#line 791
		    /* Random choice of forward or backward */
#line 791
/* TODO
#line 791
		if ( roll(2) ) {
#line 791
		    for (j = 0; j < var_rank[i]; j++) {
#line 791
			index[j] += (count[j] - 1) * stride[j];
#line 791
			stride[j] = -stride[j];
#line 791
		    }
#line 791
		}
#line 791
 */
#line 791
		if (var_rank[i] > 0) {
#line 791
		    j = var_rank[i] - 1;
#line 791
		    imap[j] = 1;
#line 791
		    for (; j > 0; j--)
#line 791
			imap[j-1] = imap[j] * count[j];
#line 791
		}
#line 791
                allInExtRange = allInIntRange = 1;
#line 791
                for (j = 0; j < nels; j++) {
#line 791
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 791
                    IF (err)
#line 791
                        error("error in toMixedBase 1");
#line 791
                    for (d = 0; d < var_rank[i]; d++)
#line 791
                        index2[d] = index[d] + index2[d] * stride[d];
#line 791
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 791
                        NCT_SHORT);
#line 791
                    if (inRange3(expect[j],var_type[i],NCT_SHORT)) {
#line 791
                        allInIntRange = allInIntRange && expect[j] >= short_min
#line 791
                            && expect[j] <= short_max;
#line 791
                    } else {
#line 791
                        allInExtRange = 0;
#line 791
                    }
#line 791
                }
#line 791
                if (var_rank[i] == 0 && i%2 )
#line 791
                    err = nc_get_varm_short(ncid,i,NULL,NULL,NULL,NULL,value);
#line 791
                else
#line 791
                    err = nc_get_varm_short(ncid,i,index,count,stride,imap,value);
#line 791
                if (canConvert) {
#line 791
                    if (allInExtRange) {
#line 791
                        if (allInIntRange) {
#line 791
                            IF (err)
#line 791
                                error("%s", nc_strerror(err));
#line 791
                        } else {
#line 791
                            IF (err != NC_ERANGE)
#line 791
                                error("Range error: status = %d", err);
#line 791
                        }
#line 791
                    } else {
#line 791
                        IF (err != 0 && err != NC_ERANGE)
#line 791
                            error("OK or Range error: status = %d", err);
#line 791
                    }
#line 791
                    for (j = 0; j < nels; j++) {
#line 791
                        if (inRange3(expect[j],var_type[i],NCT_SHORT)
#line 791
                                && expect[j] >= short_min 
#line 791
				&& expect[j] <= short_max) {
#line 791
			    IF (!equal(value[j],expect[j],var_type[i], NCT_SHORT)){
#line 791
                                error("value read not that expected");
#line 791
                                if (verbose) {
#line 791
                                    error("\n");
#line 791
                                    error("varid: %d, ", i);
#line 791
                                    error("var_name: %s, ", var_name[i]);
#line 791
                                    error("element number: %d ", j);
#line 791
                                    error("expect: %g, ", expect[j]);
#line 791
                                    error("got: %g", (double) value[j]);
#line 791
                                }
#line 791
                            } else {
#line 791
                                nok++;
#line 791
                            }
#line 791
                        }
#line 791
                    }
#line 791
                } else {
#line 791
                    IF (nels > 0 && err != NC_ECHAR)
#line 791
                        error("wrong type: status = %d", err);
#line 791
                }
#line 791
            }
#line 791
        }
#line 791
    }
#line 791
    err = nc_close(ncid);
#line 791
    IF (err)
#line 791
        error("nc_close: %s", nc_strerror(err));
#line 791
    print_nok(nok);
#line 791
}
#line 791

void
#line 792
test_nc_get_varm_int(void)
#line 792
{
#line 792
    int ncid;
#line 792
    int d;
#line 792
    int i;
#line 792
    int j;
#line 792
    int k;
#line 792
    int m;
#line 792
    int err;
#line 792
    int allInExtRange;	/* all values within external range? */
#line 792
    int allInIntRange;	/* all values within internal range? */
#line 792
    int nels;
#line 792
    int nslabs;
#line 792
    int nstarts;        /* number of different starts */
#line 792
    int nok = 0;      /* count of valid comparisons */
#line 792
    size_t start[MAX_RANK];
#line 792
    size_t edge[MAX_RANK];
#line 792
    size_t index[MAX_RANK];
#line 792
    size_t index2[MAX_RANK];
#line 792
    size_t mid[MAX_RANK];
#line 792
    size_t count[MAX_RANK];
#line 792
    size_t sstride[MAX_RANK];
#line 792
    ptrdiff_t stride[MAX_RANK];
#line 792
    ptrdiff_t imap[MAX_RANK];
#line 792
    int canConvert;     /* Both text or both numeric */
#line 792
    int value[MAX_NELS];
#line 792
    double expect[MAX_NELS];
#line 792

#line 792
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 792
    IF (err)
#line 792
        error("nc_open: %s", nc_strerror(err));
#line 792
    for (i = 0; i < NVARS; i++) {
#line 792
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 792
        assert(var_rank[i] <= MAX_RANK);
#line 792
        assert(var_nels[i] <= MAX_NELS);
#line 792
        for (j = 0; j < var_rank[i]; j++) {
#line 792
            start[j] = 0;
#line 792
            edge[j] = 1;
#line 792
            stride[j] = 1;
#line 792
            imap[j] = 1;
#line 792
        }
#line 792
        err = nc_get_varm_int(BAD_ID, i, start, edge, stride, imap, value);
#line 792
        IF (err != NC_EBADID)
#line 792
            error("bad ncid: status = %d", err);
#line 792
        err = nc_get_varm_int(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 792
        IF (err != NC_ENOTVAR)
#line 792
            error("bad var id: status = %d", err);
#line 792
        for (j = 0; j < var_rank[i]; j++) {
#line 792
            start[j] = var_shape[i][j];
#line 792
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
#line 792
	  if(!canConvert) {
#line 792
		IF (err != NC_ECHAR)
#line 792
               	    error("conversion: status = %d", err);
#line 792
	  } else {
#line 792
	    IF (err != NC_EINVALCOORDS)
#line 792
                error("bad index: status = %d", err);
#line 792
            start[j] = 0;
#line 792
            edge[j] = var_shape[i][j] + 1;
#line 792
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
#line 792
            IF (err != NC_EEDGE)
#line 792
                error("bad edge: status = %d", err);
#line 792
            edge[j] = 1;
#line 792
            stride[j] = 0;
#line 792
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
#line 792
            IF (err != NC_ESTRIDE)
#line 792
                error("bad stride: status = %d", err);
#line 792
            stride[j] = 1;
#line 792
           }
#line 792
        }
#line 792
            /* Choose a random point dividing each dim into 2 parts */
#line 792
            /* get 2^rank (nslabs) slabs so defined */
#line 792
        nslabs = 1;
#line 792
        for (j = 0; j < var_rank[i]; j++) {
#line 792
            mid[j] = roll( var_shape[i][j] );
#line 792
            nslabs *= 2;
#line 792
        }
#line 792
            /* bits of k determine whether to get lower or upper part of dim */
#line 792
            /* choose random stride from 1 to edge */
#line 792
        for (k = 0; k < nslabs; k++) {
#line 792
            nstarts = 1;
#line 792
            for (j = 0; j < var_rank[i]; j++) {
#line 792
                if ((k >> j) & 1) {
#line 792
                    start[j] = 0;
#line 792
                    edge[j] = mid[j];
#line 792
                }else{
#line 792
                    start[j] = mid[j];
#line 792
                    edge[j] = var_shape[i][j] - mid[j];
#line 792
                }
#line 792
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 792
                nstarts *= stride[j];
#line 792
            }
#line 792
            for (m = 0; m < nstarts; m++) {
#line 792
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 792
                IF (err)
#line 792
                    error("error in toMixedBase");
#line 792
                nels = 1;
#line 792
                for (j = 0; j < var_rank[i]; j++) {
#line 792
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 792
                    nels *= count[j];
#line 792
                    index[j] += start[j];
#line 792
                }
#line 792
		    /* Random choice of forward or backward */
#line 792
/* TODO
#line 792
		if ( roll(2) ) {
#line 792
		    for (j = 0; j < var_rank[i]; j++) {
#line 792
			index[j] += (count[j] - 1) * stride[j];
#line 792
			stride[j] = -stride[j];
#line 792
		    }
#line 792
		}
#line 792
 */
#line 792
		if (var_rank[i] > 0) {
#line 792
		    j = var_rank[i] - 1;
#line 792
		    imap[j] = 1;
#line 792
		    for (; j > 0; j--)
#line 792
			imap[j-1] = imap[j] * count[j];
#line 792
		}
#line 792
                allInExtRange = allInIntRange = 1;
#line 792
                for (j = 0; j < nels; j++) {
#line 792
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 792
                    IF (err)
#line 792
                        error("error in toMixedBase 1");
#line 792
                    for (d = 0; d < var_rank[i]; d++)
#line 792
                        index2[d] = index[d] + index2[d] * stride[d];
#line 792
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 792
                        NCT_INT);
#line 792
                    if (inRange3(expect[j],var_type[i],NCT_INT)) {
#line 792
                        allInIntRange = allInIntRange && expect[j] >= int_min
#line 792
                            && expect[j] <= int_max;
#line 792
                    } else {
#line 792
                        allInExtRange = 0;
#line 792
                    }
#line 792
                }
#line 792
                if (var_rank[i] == 0 && i%2 )
#line 792
                    err = nc_get_varm_int(ncid,i,NULL,NULL,NULL,NULL,value);
#line 792
                else
#line 792
                    err = nc_get_varm_int(ncid,i,index,count,stride,imap,value);
#line 792
                if (canConvert) {
#line 792
                    if (allInExtRange) {
#line 792
                        if (allInIntRange) {
#line 792
                            IF (err)
#line 792
                                error("%s", nc_strerror(err));
#line 792
                        } else {
#line 792
                            IF (err != NC_ERANGE)
#line 792
                                error("Range error: status = %d", err);
#line 792
                        }
#line 792
                    } else {
#line 792
                        IF (err != 0 && err != NC_ERANGE)
#line 792
                            error("OK or Range error: status = %d", err);
#line 792
                    }
#line 792
                    for (j = 0; j < nels; j++) {
#line 792
                        if (inRange3(expect[j],var_type[i],NCT_INT)
#line 792
                                && expect[j] >= int_min 
#line 792
				&& expect[j] <= int_max) {
#line 792
			    IF (!equal(value[j],expect[j],var_type[i], NCT_INT)){
#line 792
                                error("value read not that expected");
#line 792
                                if (verbose) {
#line 792
                                    error("\n");
#line 792
                                    error("varid: %d, ", i);
#line 792
                                    error("var_name: %s, ", var_name[i]);
#line 792
                                    error("element number: %d ", j);
#line 792
                                    error("expect: %g, ", expect[j]);
#line 792
                                    error("got: %g", (double) value[j]);
#line 792
                                }
#line 792
                            } else {
#line 792
                                nok++;
#line 792
                            }
#line 792
                        }
#line 792
                    }
#line 792
                } else {
#line 792
                    IF (nels > 0 && err != NC_ECHAR)
#line 792
                        error("wrong type: status = %d", err);
#line 792
                }
#line 792
            }
#line 792
        }
#line 792
    }
#line 792
    err = nc_close(ncid);
#line 792
    IF (err)
#line 792
        error("nc_close: %s", nc_strerror(err));
#line 792
    print_nok(nok);
#line 792
}
#line 792

void
#line 793
test_nc_get_varm_long(void)
#line 793
{
#line 793
    int ncid;
#line 793
    int d;
#line 793
    int i;
#line 793
    int j;
#line 793
    int k;
#line 793
    int m;
#line 793
    int err;
#line 793
    int allInExtRange;	/* all values within external range? */
#line 793
    int allInIntRange;	/* all values within internal range? */
#line 793
    int nels;
#line 793
    int nslabs;
#line 793
    int nstarts;        /* number of different starts */
#line 793
    int nok = 0;      /* count of valid comparisons */
#line 793
    size_t start[MAX_RANK];
#line 793
    size_t edge[MAX_RANK];
#line 793
    size_t index[MAX_RANK];
#line 793
    size_t index2[MAX_RANK];
#line 793
    size_t mid[MAX_RANK];
#line 793
    size_t count[MAX_RANK];
#line 793
    size_t sstride[MAX_RANK];
#line 793
    ptrdiff_t stride[MAX_RANK];
#line 793
    ptrdiff_t imap[MAX_RANK];
#line 793
    int canConvert;     /* Both text or both numeric */
#line 793
    long value[MAX_NELS];
#line 793
    double expect[MAX_NELS];
#line 793

#line 793
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 793
    IF (err)
#line 793
        error("nc_open: %s", nc_strerror(err));
#line 793
    for (i = 0; i < NVARS; i++) {
#line 793
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 793
        assert(var_rank[i] <= MAX_RANK);
#line 793
        assert(var_nels[i] <= MAX_NELS);
#line 793
        for (j = 0; j < var_rank[i]; j++) {
#line 793
            start[j] = 0;
#line 793
            edge[j] = 1;
#line 793
            stride[j] = 1;
#line 793
            imap[j] = 1;
#line 793
        }
#line 793
        err = nc_get_varm_long(BAD_ID, i, start, edge, stride, imap, value);
#line 793
        IF (err != NC_EBADID)
#line 793
            error("bad ncid: status = %d", err);
#line 793
        err = nc_get_varm_long(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 793
        IF (err != NC_ENOTVAR)
#line 793
            error("bad var id: status = %d", err);
#line 793
        for (j = 0; j < var_rank[i]; j++) {
#line 793
            start[j] = var_shape[i][j];
#line 793
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
#line 793
	  if(!canConvert) {
#line 793
		IF (err != NC_ECHAR)
#line 793
               	    error("conversion: status = %d", err);
#line 793
	  } else {
#line 793
	    IF (err != NC_EINVALCOORDS)
#line 793
                error("bad index: status = %d", err);
#line 793
            start[j] = 0;
#line 793
            edge[j] = var_shape[i][j] + 1;
#line 793
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
#line 793
            IF (err != NC_EEDGE)
#line 793
                error("bad edge: status = %d", err);
#line 793
            edge[j] = 1;
#line 793
            stride[j] = 0;
#line 793
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
#line 793
            IF (err != NC_ESTRIDE)
#line 793
                error("bad stride: status = %d", err);
#line 793
            stride[j] = 1;
#line 793
           }
#line 793
        }
#line 793
            /* Choose a random point dividing each dim into 2 parts */
#line 793
            /* get 2^rank (nslabs) slabs so defined */
#line 793
        nslabs = 1;
#line 793
        for (j = 0; j < var_rank[i]; j++) {
#line 793
            mid[j] = roll( var_shape[i][j] );
#line 793
            nslabs *= 2;
#line 793
        }
#line 793
            /* bits of k determine whether to get lower or upper part of dim */
#line 793
            /* choose random stride from 1 to edge */
#line 793
        for (k = 0; k < nslabs; k++) {
#line 793
            nstarts = 1;
#line 793
            for (j = 0; j < var_rank[i]; j++) {
#line 793
                if ((k >> j) & 1) {
#line 793
                    start[j] = 0;
#line 793
                    edge[j] = mid[j];
#line 793
                }else{
#line 793
                    start[j] = mid[j];
#line 793
                    edge[j] = var_shape[i][j] - mid[j];
#line 793
                }
#line 793
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 793
                nstarts *= stride[j];
#line 793
            }
#line 793
            for (m = 0; m < nstarts; m++) {
#line 793
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 793
                IF (err)
#line 793
                    error("error in toMixedBase");
#line 793
                nels = 1;
#line 793
                for (j = 0; j < var_rank[i]; j++) {
#line 793
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 793
                    nels *= count[j];
#line 793
                    index[j] += start[j];
#line 793
                }
#line 793
		    /* Random choice of forward or backward */
#line 793
/* TODO
#line 793
		if ( roll(2) ) {
#line 793
		    for (j = 0; j < var_rank[i]; j++) {
#line 793
			index[j] += (count[j] - 1) * stride[j];
#line 793
			stride[j] = -stride[j];
#line 793
		    }
#line 793
		}
#line 793
 */
#line 793
		if (var_rank[i] > 0) {
#line 793
		    j = var_rank[i] - 1;
#line 793
		    imap[j] = 1;
#line 793
		    for (; j > 0; j--)
#line 793
			imap[j-1] = imap[j] * count[j];
#line 793
		}
#line 793
                allInExtRange = allInIntRange = 1;
#line 793
                for (j = 0; j < nels; j++) {
#line 793
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 793
                    IF (err)
#line 793
                        error("error in toMixedBase 1");
#line 793
                    for (d = 0; d < var_rank[i]; d++)
#line 793
                        index2[d] = index[d] + index2[d] * stride[d];
#line 793
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 793
                        NCT_LONG);
#line 793
                    if (inRange3(expect[j],var_type[i],NCT_LONG)) {
#line 793
                        allInIntRange = allInIntRange && expect[j] >= long_min
#line 793
                            && expect[j] <= long_max;
#line 793
                    } else {
#line 793
                        allInExtRange = 0;
#line 793
                    }
#line 793
                }
#line 793
                if (var_rank[i] == 0 && i%2 )
#line 793
                    err = nc_get_varm_long(ncid,i,NULL,NULL,NULL,NULL,value);
#line 793
                else
#line 793
                    err = nc_get_varm_long(ncid,i,index,count,stride,imap,value);
#line 793
                if (canConvert) {
#line 793
                    if (allInExtRange) {
#line 793
                        if (allInIntRange) {
#line 793
                            IF (err)
#line 793
                                error("%s", nc_strerror(err));
#line 793
                        } else {
#line 793
                            IF (err != NC_ERANGE)
#line 793
                                error("Range error: status = %d", err);
#line 793
                        }
#line 793
                    } else {
#line 793
                        IF (err != 0 && err != NC_ERANGE)
#line 793
                            error("OK or Range error: status = %d", err);
#line 793
                    }
#line 793
                    for (j = 0; j < nels; j++) {
#line 793
                        if (inRange3(expect[j],var_type[i],NCT_LONG)
#line 793
                                && expect[j] >= long_min 
#line 793
				&& expect[j] <= long_max) {
#line 793
			    IF (!equal(value[j],expect[j],var_type[i], NCT_LONG)){
#line 793
                                error("value read not that expected");
#line 793
                                if (verbose) {
#line 793
                                    error("\n");
#line 793
                                    error("varid: %d, ", i);
#line 793
                                    error("var_name: %s, ", var_name[i]);
#line 793
                                    error("element number: %d ", j);
#line 793
                                    error("expect: %g, ", expect[j]);
#line 793
                                    error("got: %g", (double) value[j]);
#line 793
                                }
#line 793
                            } else {
#line 793
                                nok++;
#line 793
                            }
#line 793
                        }
#line 793
                    }
#line 793
                } else {
#line 793
                    IF (nels > 0 && err != NC_ECHAR)
#line 793
                        error("wrong type: status = %d", err);
#line 793
                }
#line 793
            }
#line 793
        }
#line 793
    }
#line 793
    err = nc_close(ncid);
#line 793
    IF (err)
#line 793
        error("nc_close: %s", nc_strerror(err));
#line 793
    print_nok(nok);
#line 793
}
#line 793

void
#line 794
test_nc_get_varm_float(void)
#line 794
{
#line 794
    int ncid;
#line 794
    int d;
#line 794
    int i;
#line 794
    int j;
#line 794
    int k;
#line 794
    int m;
#line 794
    int err;
#line 794
    int allInExtRange;	/* all values within external range? */
#line 794
    int allInIntRange;	/* all values within internal range? */
#line 794
    int nels;
#line 794
    int nslabs;
#line 794
    int nstarts;        /* number of different starts */
#line 794
    int nok = 0;      /* count of valid comparisons */
#line 794
    size_t start[MAX_RANK];
#line 794
    size_t edge[MAX_RANK];
#line 794
    size_t index[MAX_RANK];
#line 794
    size_t index2[MAX_RANK];
#line 794
    size_t mid[MAX_RANK];
#line 794
    size_t count[MAX_RANK];
#line 794
    size_t sstride[MAX_RANK];
#line 794
    ptrdiff_t stride[MAX_RANK];
#line 794
    ptrdiff_t imap[MAX_RANK];
#line 794
    int canConvert;     /* Both text or both numeric */
#line 794
    float value[MAX_NELS];
#line 794
    double expect[MAX_NELS];
#line 794

#line 794
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 794
    IF (err)
#line 794
        error("nc_open: %s", nc_strerror(err));
#line 794
    for (i = 0; i < NVARS; i++) {
#line 794
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 794
        assert(var_rank[i] <= MAX_RANK);
#line 794
        assert(var_nels[i] <= MAX_NELS);
#line 794
        for (j = 0; j < var_rank[i]; j++) {
#line 794
            start[j] = 0;
#line 794
            edge[j] = 1;
#line 794
            stride[j] = 1;
#line 794
            imap[j] = 1;
#line 794
        }
#line 794
        err = nc_get_varm_float(BAD_ID, i, start, edge, stride, imap, value);
#line 794
        IF (err != NC_EBADID)
#line 794
            error("bad ncid: status = %d", err);
#line 794
        err = nc_get_varm_float(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 794
        IF (err != NC_ENOTVAR)
#line 794
            error("bad var id: status = %d", err);
#line 794
        for (j = 0; j < var_rank[i]; j++) {
#line 794
            start[j] = var_shape[i][j];
#line 794
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
#line 794
	  if(!canConvert) {
#line 794
		IF (err != NC_ECHAR)
#line 794
               	    error("conversion: status = %d", err);
#line 794
	  } else {
#line 794
	    IF (err != NC_EINVALCOORDS)
#line 794
                error("bad index: status = %d", err);
#line 794
            start[j] = 0;
#line 794
            edge[j] = var_shape[i][j] + 1;
#line 794
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
#line 794
            IF (err != NC_EEDGE)
#line 794
                error("bad edge: status = %d", err);
#line 794
            edge[j] = 1;
#line 794
            stride[j] = 0;
#line 794
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
#line 794
            IF (err != NC_ESTRIDE)
#line 794
                error("bad stride: status = %d", err);
#line 794
            stride[j] = 1;
#line 794
           }
#line 794
        }
#line 794
            /* Choose a random point dividing each dim into 2 parts */
#line 794
            /* get 2^rank (nslabs) slabs so defined */
#line 794
        nslabs = 1;
#line 794
        for (j = 0; j < var_rank[i]; j++) {
#line 794
            mid[j] = roll( var_shape[i][j] );
#line 794
            nslabs *= 2;
#line 794
        }
#line 794
            /* bits of k determine whether to get lower or upper part of dim */
#line 794
            /* choose random stride from 1 to edge */
#line 794
        for (k = 0; k < nslabs; k++) {
#line 794
            nstarts = 1;
#line 794
            for (j = 0; j < var_rank[i]; j++) {
#line 794
                if ((k >> j) & 1) {
#line 794
                    start[j] = 0;
#line 794
                    edge[j] = mid[j];
#line 794
                }else{
#line 794
                    start[j] = mid[j];
#line 794
                    edge[j] = var_shape[i][j] - mid[j];
#line 794
                }
#line 794
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 794
                nstarts *= stride[j];
#line 794
            }
#line 794
            for (m = 0; m < nstarts; m++) {
#line 794
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 794
                IF (err)
#line 794
                    error("error in toMixedBase");
#line 794
                nels = 1;
#line 794
                for (j = 0; j < var_rank[i]; j++) {
#line 794
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 794
                    nels *= count[j];
#line 794
                    index[j] += start[j];
#line 794
                }
#line 794
		    /* Random choice of forward or backward */
#line 794
/* TODO
#line 794
		if ( roll(2) ) {
#line 794
		    for (j = 0; j < var_rank[i]; j++) {
#line 794
			index[j] += (count[j] - 1) * stride[j];
#line 794
			stride[j] = -stride[j];
#line 794
		    }
#line 794
		}
#line 794
 */
#line 794
		if (var_rank[i] > 0) {
#line 794
		    j = var_rank[i] - 1;
#line 794
		    imap[j] = 1;
#line 794
		    for (; j > 0; j--)
#line 794
			imap[j-1] = imap[j] * count[j];
#line 794
		}
#line 794
                allInExtRange = allInIntRange = 1;
#line 794
                for (j = 0; j < nels; j++) {
#line 794
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 794
                    IF (err)
#line 794
                        error("error in toMixedBase 1");
#line 794
                    for (d = 0; d < var_rank[i]; d++)
#line 794
                        index2[d] = index[d] + index2[d] * stride[d];
#line 794
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 794
                        NCT_FLOAT);
#line 794
                    if (inRange3(expect[j],var_type[i],NCT_FLOAT)) {
#line 794
                        allInIntRange = allInIntRange && expect[j] >= float_min
#line 794
                            && expect[j] <= float_max;
#line 794
                    } else {
#line 794
                        allInExtRange = 0;
#line 794
                    }
#line 794
                }
#line 794
                if (var_rank[i] == 0 && i%2 )
#line 794
                    err = nc_get_varm_float(ncid,i,NULL,NULL,NULL,NULL,value);
#line 794
                else
#line 794
                    err = nc_get_varm_float(ncid,i,index,count,stride,imap,value);
#line 794
                if (canConvert) {
#line 794
                    if (allInExtRange) {
#line 794
                        if (allInIntRange) {
#line 794
                            IF (err)
#line 794
                                error("%s", nc_strerror(err));
#line 794
                        } else {
#line 794
                            IF (err != NC_ERANGE)
#line 794
                                error("Range error: status = %d", err);
#line 794
                        }
#line 794
                    } else {
#line 794
                        IF (err != 0 && err != NC_ERANGE)
#line 794
                            error("OK or Range error: status = %d", err);
#line 794
                    }
#line 794
                    for (j = 0; j < nels; j++) {
#line 794
                        if (inRange3(expect[j],var_type[i],NCT_FLOAT)
#line 794
                                && expect[j] >= float_min 
#line 794
				&& expect[j] <= float_max) {
#line 794
			    IF (!equal(value[j],expect[j],var_type[i], NCT_FLOAT)){
#line 794
                                error("value read not that expected");
#line 794
                                if (verbose) {
#line 794
                                    error("\n");
#line 794
                                    error("varid: %d, ", i);
#line 794
                                    error("var_name: %s, ", var_name[i]);
#line 794
                                    error("element number: %d ", j);
#line 794
                                    error("expect: %g, ", expect[j]);
#line 794
                                    error("got: %g", (double) value[j]);
#line 794
                                }
#line 794
                            } else {
#line 794
                                nok++;
#line 794
                            }
#line 794
                        }
#line 794
                    }
#line 794
                } else {
#line 794
                    IF (nels > 0 && err != NC_ECHAR)
#line 794
                        error("wrong type: status = %d", err);
#line 794
                }
#line 794
            }
#line 794
        }
#line 794
    }
#line 794
    err = nc_close(ncid);
#line 794
    IF (err)
#line 794
        error("nc_close: %s", nc_strerror(err));
#line 794
    print_nok(nok);
#line 794
}
#line 794

void
#line 795
test_nc_get_varm_double(void)
#line 795
{
#line 795
    int ncid;
#line 795
    int d;
#line 795
    int i;
#line 795
    int j;
#line 795
    int k;
#line 795
    int m;
#line 795
    int err;
#line 795
    int allInExtRange;	/* all values within external range? */
#line 795
    int allInIntRange;	/* all values within internal range? */
#line 795
    int nels;
#line 795
    int nslabs;
#line 795
    int nstarts;        /* number of different starts */
#line 795
    int nok = 0;      /* count of valid comparisons */
#line 795
    size_t start[MAX_RANK];
#line 795
    size_t edge[MAX_RANK];
#line 795
    size_t index[MAX_RANK];
#line 795
    size_t index2[MAX_RANK];
#line 795
    size_t mid[MAX_RANK];
#line 795
    size_t count[MAX_RANK];
#line 795
    size_t sstride[MAX_RANK];
#line 795
    ptrdiff_t stride[MAX_RANK];
#line 795
    ptrdiff_t imap[MAX_RANK];
#line 795
    int canConvert;     /* Both text or both numeric */
#line 795
    double value[MAX_NELS];
#line 795
    double expect[MAX_NELS];
#line 795

#line 795
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 795
    IF (err)
#line 795
        error("nc_open: %s", nc_strerror(err));
#line 795
    for (i = 0; i < NVARS; i++) {
#line 795
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 795
        assert(var_rank[i] <= MAX_RANK);
#line 795
        assert(var_nels[i] <= MAX_NELS);
#line 795
        for (j = 0; j < var_rank[i]; j++) {
#line 795
            start[j] = 0;
#line 795
            edge[j] = 1;
#line 795
            stride[j] = 1;
#line 795
            imap[j] = 1;
#line 795
        }
#line 795
        err = nc_get_varm_double(BAD_ID, i, start, edge, stride, imap, value);
#line 795
        IF (err != NC_EBADID)
#line 795
            error("bad ncid: status = %d", err);
#line 795
        err = nc_get_varm_double(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 795
        IF (err != NC_ENOTVAR)
#line 795
            error("bad var id: status = %d", err);
#line 795
        for (j = 0; j < var_rank[i]; j++) {
#line 795
            start[j] = var_shape[i][j];
#line 795
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
#line 795
	  if(!canConvert) {
#line 795
		IF (err != NC_ECHAR)
#line 795
               	    error("conversion: status = %d", err);
#line 795
	  } else {
#line 795
	    IF (err != NC_EINVALCOORDS)
#line 795
                error("bad index: status = %d", err);
#line 795
            start[j] = 0;
#line 795
            edge[j] = var_shape[i][j] + 1;
#line 795
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
#line 795
            IF (err != NC_EEDGE)
#line 795
                error("bad edge: status = %d", err);
#line 795
            edge[j] = 1;
#line 795
            stride[j] = 0;
#line 795
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
#line 795
            IF (err != NC_ESTRIDE)
#line 795
                error("bad stride: status = %d", err);
#line 795
            stride[j] = 1;
#line 795
           }
#line 795
        }
#line 795
            /* Choose a random point dividing each dim into 2 parts */
#line 795
            /* get 2^rank (nslabs) slabs so defined */
#line 795
        nslabs = 1;
#line 795
        for (j = 0; j < var_rank[i]; j++) {
#line 795
            mid[j] = roll( var_shape[i][j] );
#line 795
            nslabs *= 2;
#line 795
        }
#line 795
            /* bits of k determine whether to get lower or upper part of dim */
#line 795
            /* choose random stride from 1 to edge */
#line 795
        for (k = 0; k < nslabs; k++) {
#line 795
            nstarts = 1;
#line 795
            for (j = 0; j < var_rank[i]; j++) {
#line 795
                if ((k >> j) & 1) {
#line 795
                    start[j] = 0;
#line 795
                    edge[j] = mid[j];
#line 795
                }else{
#line 795
                    start[j] = mid[j];
#line 795
                    edge[j] = var_shape[i][j] - mid[j];
#line 795
                }
#line 795
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 795
                nstarts *= stride[j];
#line 795
            }
#line 795
            for (m = 0; m < nstarts; m++) {
#line 795
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 795
                IF (err)
#line 795
                    error("error in toMixedBase");
#line 795
                nels = 1;
#line 795
                for (j = 0; j < var_rank[i]; j++) {
#line 795
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 795
                    nels *= count[j];
#line 795
                    index[j] += start[j];
#line 795
                }
#line 795
		    /* Random choice of forward or backward */
#line 795
/* TODO
#line 795
		if ( roll(2) ) {
#line 795
		    for (j = 0; j < var_rank[i]; j++) {
#line 795
			index[j] += (count[j] - 1) * stride[j];
#line 795
			stride[j] = -stride[j];
#line 795
		    }
#line 795
		}
#line 795
 */
#line 795
		if (var_rank[i] > 0) {
#line 795
		    j = var_rank[i] - 1;
#line 795
		    imap[j] = 1;
#line 795
		    for (; j > 0; j--)
#line 795
			imap[j-1] = imap[j] * count[j];
#line 795
		}
#line 795
                allInExtRange = allInIntRange = 1;
#line 795
                for (j = 0; j < nels; j++) {
#line 795
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 795
                    IF (err)
#line 795
                        error("error in toMixedBase 1");
#line 795
                    for (d = 0; d < var_rank[i]; d++)
#line 795
                        index2[d] = index[d] + index2[d] * stride[d];
#line 795
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 795
                        NCT_DOUBLE);
#line 795
                    if (inRange3(expect[j],var_type[i],NCT_DOUBLE)) {
#line 795
                        allInIntRange = allInIntRange && expect[j] >= double_min
#line 795
                            && expect[j] <= double_max;
#line 795
                    } else {
#line 795
                        allInExtRange = 0;
#line 795
                    }
#line 795
                }
#line 795
                if (var_rank[i] == 0 && i%2 )
#line 795
                    err = nc_get_varm_double(ncid,i,NULL,NULL,NULL,NULL,value);
#line 795
                else
#line 795
                    err = nc_get_varm_double(ncid,i,index,count,stride,imap,value);
#line 795
                if (canConvert) {
#line 795
                    if (allInExtRange) {
#line 795
                        if (allInIntRange) {
#line 795
                            IF (err)
#line 795
                                error("%s", nc_strerror(err));
#line 795
                        } else {
#line 795
                            IF (err != NC_ERANGE)
#line 795
                                error("Range error: status = %d", err);
#line 795
                        }
#line 795
                    } else {
#line 795
                        IF (err != 0 && err != NC_ERANGE)
#line 795
                            error("OK or Range error: status = %d", err);
#line 795
                    }
#line 795
                    for (j = 0; j < nels; j++) {
#line 795
                        if (inRange3(expect[j],var_type[i],NCT_DOUBLE)
#line 795
                                && expect[j] >= double_min 
#line 795
				&& expect[j] <= double_max) {
#line 795
			    IF (!equal(value[j],expect[j],var_type[i], NCT_DOUBLE)){
#line 795
                                error("value read not that expected");
#line 795
                                if (verbose) {
#line 795
                                    error("\n");
#line 795
                                    error("varid: %d, ", i);
#line 795
                                    error("var_name: %s, ", var_name[i]);
#line 795
                                    error("element number: %d ", j);
#line 795
                                    error("expect: %g, ", expect[j]);
#line 795
                                    error("got: %g", (double) value[j]);
#line 795
                                }
#line 795
                            } else {
#line 795
                                nok++;
#line 795
                            }
#line 795
                        }
#line 795
                    }
#line 795
                } else {
#line 795
                    IF (nels > 0 && err != NC_ECHAR)
#line 795
                        error("wrong type: status = %d", err);
#line 795
                }
#line 795
            }
#line 795
        }
#line 795
    }
#line 795
    err = nc_close(ncid);
#line 795
    IF (err)
#line 795
        error("nc_close: %s", nc_strerror(err));
#line 795
    print_nok(nok);
#line 795
}
#line 795



#line 888

void
#line 889
test_nc_get_att_text(void)
#line 889
{
#line 889
    int ncid;
#line 889
    int i;
#line 889
    int j;
#line 889
    size_t k;
#line 889
    int err;
#line 889
    int allInExtRange;
#line 889
    int allInIntRange;
#line 889
    int canConvert;     /* Both text or both numeric */
#line 889
    text value[MAX_NELS];
#line 889
    double expect[MAX_NELS];
#line 889
    int nok = 0;      /* count of valid comparisons */
#line 889

#line 889
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 889
    IF (err) 
#line 889
	error("nc_open: %s", nc_strerror(err));
#line 889

#line 889
    for (i = -1; i < NVARS; i++) {
#line 889
        for (j = 0; j < NATTS(i); j++) {
#line 889
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 889
	    err = nc_get_att_text(BAD_ID, i, ATT_NAME(i,j), value);
#line 889
	    IF (err != NC_EBADID) 
#line 889
		error("bad ncid: status = %d", err);
#line 889
	    err = nc_get_att_text(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 889
	    IF (err != NC_ENOTVAR) 
#line 889
		error("bad var id: status = %d", err);
#line 889
	    err = nc_get_att_text(ncid, i, "noSuch", value);
#line 889
	    IF (err != NC_ENOTATT) 
#line 889
		error("Bad attribute name: status = %d", err);
#line 889
	    allInExtRange = allInIntRange = 1;
#line 889
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 889
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_TEXT);
#line 889
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_TEXT)) {
#line 889
                    allInIntRange = allInIntRange && expect[k] >= text_min
#line 889
                                && expect[k] <= text_max;
#line 889
                } else {
#line 889
                    allInExtRange = 0;
#line 889
                }
#line 889
	    }
#line 889
	    err = nc_get_att_text(ncid, i, ATT_NAME(i,j), value);
#line 889
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 889
                if (allInExtRange) {
#line 889
                    if (allInIntRange) {
#line 889
                        IF (err)
#line 889
                            error("%s", nc_strerror(err));
#line 889
                    } else {
#line 889
                        IF (err != NC_ERANGE)
#line 889
                            error("Range error: status = %d", err);
#line 889
                    }
#line 889
                } else {
#line 889
                    IF (err != 0 && err != NC_ERANGE)
#line 889
                        error("OK or Range error: status = %d", err);
#line 889
                }
#line 889
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 889
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_TEXT)
#line 889
                            && expect[k] >= text_min && expect[k] <= text_max) {
#line 889
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j), NCT_TEXT)){
#line 889
			    error("value read not that expected");
#line 889
                            if (verbose) {
#line 889
                                error("\n");
#line 889
                                error("varid: %d, ", i);
#line 889
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 889
                                error("element number: %d ", k);
#line 889
                                error("expect: %g", expect[k]);
#line 889
                                error("got: %g", (double) value[k]);
#line 889
                            }
#line 889
			} else {
#line 889
			    nok++;
#line 889
                        }
#line 889
		    }
#line 889
		}
#line 889
	    } else {
#line 889
		IF (err != NC_ECHAR)
#line 889
		    error("wrong type: status = %d", err);
#line 889
	    }
#line 889
	}
#line 889
    }
#line 889

#line 889
    err = nc_close(ncid);
#line 889
    IF (err)
#line 889
	error("nc_close: %s", nc_strerror(err));
#line 889
    print_nok(nok);
#line 889
}
#line 889

void
#line 890
test_nc_get_att_uchar(void)
#line 890
{
#line 890
    int ncid;
#line 890
    int i;
#line 890
    int j;
#line 890
    size_t k;
#line 890
    int err;
#line 890
    int allInExtRange;
#line 890
    int allInIntRange;
#line 890
    int canConvert;     /* Both text or both numeric */
#line 890
    uchar value[MAX_NELS];
#line 890
    double expect[MAX_NELS];
#line 890
    int nok = 0;      /* count of valid comparisons */
#line 890

#line 890
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 890
    IF (err) 
#line 890
	error("nc_open: %s", nc_strerror(err));
#line 890

#line 890
    for (i = -1; i < NVARS; i++) {
#line 890
        for (j = 0; j < NATTS(i); j++) {
#line 890
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 890
	    err = nc_get_att_uchar(BAD_ID, i, ATT_NAME(i,j), value);
#line 890
	    IF (err != NC_EBADID) 
#line 890
		error("bad ncid: status = %d", err);
#line 890
	    err = nc_get_att_uchar(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 890
	    IF (err != NC_ENOTVAR) 
#line 890
		error("bad var id: status = %d", err);
#line 890
	    err = nc_get_att_uchar(ncid, i, "noSuch", value);
#line 890
	    IF (err != NC_ENOTATT) 
#line 890
		error("Bad attribute name: status = %d", err);
#line 890
	    allInExtRange = allInIntRange = 1;
#line 890
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 890
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_UCHAR);
#line 890
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_UCHAR)) {
#line 890
                    allInIntRange = allInIntRange && expect[k] >= uchar_min
#line 890
                                && expect[k] <= uchar_max;
#line 890
                } else {
#line 890
                    allInExtRange = 0;
#line 890
                }
#line 890
	    }
#line 890
	    err = nc_get_att_uchar(ncid, i, ATT_NAME(i,j), value);
#line 890
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 890
                if (allInExtRange) {
#line 890
                    if (allInIntRange) {
#line 890
                        IF (err)
#line 890
                            error("%s", nc_strerror(err));
#line 890
                    } else {
#line 890
                        IF (err != NC_ERANGE)
#line 890
                            error("Range error: status = %d", err);
#line 890
                    }
#line 890
                } else {
#line 890
                    IF (err != 0 && err != NC_ERANGE)
#line 890
                        error("OK or Range error: status = %d", err);
#line 890
                }
#line 890
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 890
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_UCHAR)
#line 890
                            && expect[k] >= uchar_min && expect[k] <= uchar_max) {
#line 890
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j), NCT_UCHAR)){
#line 890
			    error("value read not that expected");
#line 890
                            if (verbose) {
#line 890
                                error("\n");
#line 890
                                error("varid: %d, ", i);
#line 890
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 890
                                error("element number: %d ", k);
#line 890
                                error("expect: %g", expect[k]);
#line 890
                                error("got: %g", (double) value[k]);
#line 890
                            }
#line 890
			} else {
#line 890
			    nok++;
#line 890
                        }
#line 890
		    }
#line 890
		}
#line 890
	    } else {
#line 890
		IF (err != NC_ECHAR)
#line 890
		    error("wrong type: status = %d", err);
#line 890
	    }
#line 890
	}
#line 890
    }
#line 890

#line 890
    err = nc_close(ncid);
#line 890
    IF (err)
#line 890
	error("nc_close: %s", nc_strerror(err));
#line 890
    print_nok(nok);
#line 890
}
#line 890

void
#line 891
test_nc_get_att_schar(void)
#line 891
{
#line 891
    int ncid;
#line 891
    int i;
#line 891
    int j;
#line 891
    size_t k;
#line 891
    int err;
#line 891
    int allInExtRange;
#line 891
    int allInIntRange;
#line 891
    int canConvert;     /* Both text or both numeric */
#line 891
    schar value[MAX_NELS];
#line 891
    double expect[MAX_NELS];
#line 891
    int nok = 0;      /* count of valid comparisons */
#line 891

#line 891
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 891
    IF (err) 
#line 891
	error("nc_open: %s", nc_strerror(err));
#line 891

#line 891
    for (i = -1; i < NVARS; i++) {
#line 891
        for (j = 0; j < NATTS(i); j++) {
#line 891
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 891
	    err = nc_get_att_schar(BAD_ID, i, ATT_NAME(i,j), value);
#line 891
	    IF (err != NC_EBADID) 
#line 891
		error("bad ncid: status = %d", err);
#line 891
	    err = nc_get_att_schar(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 891
	    IF (err != NC_ENOTVAR) 
#line 891
		error("bad var id: status = %d", err);
#line 891
	    err = nc_get_att_schar(ncid, i, "noSuch", value);
#line 891
	    IF (err != NC_ENOTATT) 
#line 891
		error("Bad attribute name: status = %d", err);
#line 891
	    allInExtRange = allInIntRange = 1;
#line 891
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 891
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_SCHAR);
#line 891
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_SCHAR)) {
#line 891
                    allInIntRange = allInIntRange && expect[k] >= schar_min
#line 891
                                && expect[k] <= schar_max;
#line 891
                } else {
#line 891
                    allInExtRange = 0;
#line 891
                }
#line 891
	    }
#line 891
	    err = nc_get_att_schar(ncid, i, ATT_NAME(i,j), value);
#line 891
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 891
                if (allInExtRange) {
#line 891
                    if (allInIntRange) {
#line 891
                        IF (err)
#line 891
                            error("%s", nc_strerror(err));
#line 891
                    } else {
#line 891
                        IF (err != NC_ERANGE)
#line 891
                            error("Range error: status = %d", err);
#line 891
                    }
#line 891
                } else {
#line 891
                    IF (err != 0 && err != NC_ERANGE)
#line 891
                        error("OK or Range error: status = %d", err);
#line 891
                }
#line 891
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 891
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_SCHAR)
#line 891
                            && expect[k] >= schar_min && expect[k] <= schar_max) {
#line 891
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j), NCT_SCHAR)){
#line 891
			    error("value read not that expected");
#line 891
                            if (verbose) {
#line 891
                                error("\n");
#line 891
                                error("varid: %d, ", i);
#line 891
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 891
                                error("element number: %d ", k);
#line 891
                                error("expect: %g", expect[k]);
#line 891
                                error("got: %g", (double) value[k]);
#line 891
                            }
#line 891
			} else {
#line 891
			    nok++;
#line 891
                        }
#line 891
		    }
#line 891
		}
#line 891
	    } else {
#line 891
		IF (err != NC_ECHAR)
#line 891
		    error("wrong type: status = %d", err);
#line 891
	    }
#line 891
	}
#line 891
    }
#line 891

#line 891
    err = nc_close(ncid);
#line 891
    IF (err)
#line 891
	error("nc_close: %s", nc_strerror(err));
#line 891
    print_nok(nok);
#line 891
}
#line 891

void
#line 892
test_nc_get_att_short(void)
#line 892
{
#line 892
    int ncid;
#line 892
    int i;
#line 892
    int j;
#line 892
    size_t k;
#line 892
    int err;
#line 892
    int allInExtRange;
#line 892
    int allInIntRange;
#line 892
    int canConvert;     /* Both text or both numeric */
#line 892
    short value[MAX_NELS];
#line 892
    double expect[MAX_NELS];
#line 892
    int nok = 0;      /* count of valid comparisons */
#line 892

#line 892
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 892
    IF (err) 
#line 892
	error("nc_open: %s", nc_strerror(err));
#line 892

#line 892
    for (i = -1; i < NVARS; i++) {
#line 892
        for (j = 0; j < NATTS(i); j++) {
#line 892
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 892
	    err = nc_get_att_short(BAD_ID, i, ATT_NAME(i,j), value);
#line 892
	    IF (err != NC_EBADID) 
#line 892
		error("bad ncid: status = %d", err);
#line 892
	    err = nc_get_att_short(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 892
	    IF (err != NC_ENOTVAR) 
#line 892
		error("bad var id: status = %d", err);
#line 892
	    err = nc_get_att_short(ncid, i, "noSuch", value);
#line 892
	    IF (err != NC_ENOTATT) 
#line 892
		error("Bad attribute name: status = %d", err);
#line 892
	    allInExtRange = allInIntRange = 1;
#line 892
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 892
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_SHORT);
#line 892
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_SHORT)) {
#line 892
                    allInIntRange = allInIntRange && expect[k] >= short_min
#line 892
                                && expect[k] <= short_max;
#line 892
                } else {
#line 892
                    allInExtRange = 0;
#line 892
                }
#line 892
	    }
#line 892
	    err = nc_get_att_short(ncid, i, ATT_NAME(i,j), value);
#line 892
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 892
                if (allInExtRange) {
#line 892
                    if (allInIntRange) {
#line 892
                        IF (err)
#line 892
                            error("%s", nc_strerror(err));
#line 892
                    } else {
#line 892
                        IF (err != NC_ERANGE)
#line 892
                            error("Range error: status = %d", err);
#line 892
                    }
#line 892
                } else {
#line 892
                    IF (err != 0 && err != NC_ERANGE)
#line 892
                        error("OK or Range error: status = %d", err);
#line 892
                }
#line 892
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 892
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_SHORT)
#line 892
                            && expect[k] >= short_min && expect[k] <= short_max) {
#line 892
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j), NCT_SHORT)){
#line 892
			    error("value read not that expected");
#line 892
                            if (verbose) {
#line 892
                                error("\n");
#line 892
                                error("varid: %d, ", i);
#line 892
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 892
                                error("element number: %d ", k);
#line 892
                                error("expect: %g", expect[k]);
#line 892
                                error("got: %g", (double) value[k]);
#line 892
                            }
#line 892
			} else {
#line 892
			    nok++;
#line 892
                        }
#line 892
		    }
#line 892
		}
#line 892
	    } else {
#line 892
		IF (err != NC_ECHAR)
#line 892
		    error("wrong type: status = %d", err);
#line 892
	    }
#line 892
	}
#line 892
    }
#line 892

#line 892
    err = nc_close(ncid);
#line 892
    IF (err)
#line 892
	error("nc_close: %s", nc_strerror(err));
#line 892
    print_nok(nok);
#line 892
}
#line 892

void
#line 893
test_nc_get_att_int(void)
#line 893
{
#line 893
    int ncid;
#line 893
    int i;
#line 893
    int j;
#line 893
    size_t k;
#line 893
    int err;
#line 893
    int allInExtRange;
#line 893
    int allInIntRange;
#line 893
    int canConvert;     /* Both text or both numeric */
#line 893
    int value[MAX_NELS];
#line 893
    double expect[MAX_NELS];
#line 893
    int nok = 0;      /* count of valid comparisons */
#line 893

#line 893
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 893
    IF (err) 
#line 893
	error("nc_open: %s", nc_strerror(err));
#line 893

#line 893
    for (i = -1; i < NVARS; i++) {
#line 893
        for (j = 0; j < NATTS(i); j++) {
#line 893
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 893
	    err = nc_get_att_int(BAD_ID, i, ATT_NAME(i,j), value);
#line 893
	    IF (err != NC_EBADID) 
#line 893
		error("bad ncid: status = %d", err);
#line 893
	    err = nc_get_att_int(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 893
	    IF (err != NC_ENOTVAR) 
#line 893
		error("bad var id: status = %d", err);
#line 893
	    err = nc_get_att_int(ncid, i, "noSuch", value);
#line 893
	    IF (err != NC_ENOTATT) 
#line 893
		error("Bad attribute name: status = %d", err);
#line 893
	    allInExtRange = allInIntRange = 1;
#line 893
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 893
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_INT);
#line 893
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_INT)) {
#line 893
                    allInIntRange = allInIntRange && expect[k] >= int_min
#line 893
                                && expect[k] <= int_max;
#line 893
                } else {
#line 893
                    allInExtRange = 0;
#line 893
                }
#line 893
	    }
#line 893
	    err = nc_get_att_int(ncid, i, ATT_NAME(i,j), value);
#line 893
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 893
                if (allInExtRange) {
#line 893
                    if (allInIntRange) {
#line 893
                        IF (err)
#line 893
                            error("%s", nc_strerror(err));
#line 893
                    } else {
#line 893
                        IF (err != NC_ERANGE)
#line 893
                            error("Range error: status = %d", err);
#line 893
                    }
#line 893
                } else {
#line 893
                    IF (err != 0 && err != NC_ERANGE)
#line 893
                        error("OK or Range error: status = %d", err);
#line 893
                }
#line 893
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 893
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_INT)
#line 893
                            && expect[k] >= int_min && expect[k] <= int_max) {
#line 893
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j), NCT_INT)){
#line 893
			    error("value read not that expected");
#line 893
                            if (verbose) {
#line 893
                                error("\n");
#line 893
                                error("varid: %d, ", i);
#line 893
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 893
                                error("element number: %d ", k);
#line 893
                                error("expect: %g", expect[k]);
#line 893
                                error("got: %g", (double) value[k]);
#line 893
                            }
#line 893
			} else {
#line 893
			    nok++;
#line 893
                        }
#line 893
		    }
#line 893
		}
#line 893
	    } else {
#line 893
		IF (err != NC_ECHAR)
#line 893
		    error("wrong type: status = %d", err);
#line 893
	    }
#line 893
	}
#line 893
    }
#line 893

#line 893
    err = nc_close(ncid);
#line 893
    IF (err)
#line 893
	error("nc_close: %s", nc_strerror(err));
#line 893
    print_nok(nok);
#line 893
}
#line 893

void
#line 894
test_nc_get_att_long(void)
#line 894
{
#line 894
    int ncid;
#line 894
    int i;
#line 894
    int j;
#line 894
    size_t k;
#line 894
    int err;
#line 894
    int allInExtRange;
#line 894
    int allInIntRange;
#line 894
    int canConvert;     /* Both text or both numeric */
#line 894
    long value[MAX_NELS];
#line 894
    double expect[MAX_NELS];
#line 894
    int nok = 0;      /* count of valid comparisons */
#line 894

#line 894
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 894
    IF (err) 
#line 894
	error("nc_open: %s", nc_strerror(err));
#line 894

#line 894
    for (i = -1; i < NVARS; i++) {
#line 894
        for (j = 0; j < NATTS(i); j++) {
#line 894
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 894
	    err = nc_get_att_long(BAD_ID, i, ATT_NAME(i,j), value);
#line 894
	    IF (err != NC_EBADID) 
#line 894
		error("bad ncid: status = %d", err);
#line 894
	    err = nc_get_att_long(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 894
	    IF (err != NC_ENOTVAR) 
#line 894
		error("bad var id: status = %d", err);
#line 894
	    err = nc_get_att_long(ncid, i, "noSuch", value);
#line 894
	    IF (err != NC_ENOTATT) 
#line 894
		error("Bad attribute name: status = %d", err);
#line 894
	    allInExtRange = allInIntRange = 1;
#line 894
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 894
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_LONG);
#line 894
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_LONG)) {
#line 894
                    allInIntRange = allInIntRange && expect[k] >= long_min
#line 894
                                && expect[k] <= long_max;
#line 894
                } else {
#line 894
                    allInExtRange = 0;
#line 894
                }
#line 894
	    }
#line 894
	    err = nc_get_att_long(ncid, i, ATT_NAME(i,j), value);
#line 894
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 894
                if (allInExtRange) {
#line 894
                    if (allInIntRange) {
#line 894
                        IF (err)
#line 894
                            error("%s", nc_strerror(err));
#line 894
                    } else {
#line 894
                        IF (err != NC_ERANGE)
#line 894
                            error("Range error: status = %d", err);
#line 894
                    }
#line 894
                } else {
#line 894
                    IF (err != 0 && err != NC_ERANGE)
#line 894
                        error("OK or Range error: status = %d", err);
#line 894
                }
#line 894
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 894
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_LONG)
#line 894
                            && expect[k] >= long_min && expect[k] <= long_max) {
#line 894
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j), NCT_LONG)){
#line 894
			    error("value read not that expected");
#line 894
                            if (verbose) {
#line 894
                                error("\n");
#line 894
                                error("varid: %d, ", i);
#line 894
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 894
                                error("element number: %d ", k);
#line 894
                                error("expect: %g", expect[k]);
#line 894
                                error("got: %g", (double) value[k]);
#line 894
                            }
#line 894
			} else {
#line 894
			    nok++;
#line 894
                        }
#line 894
		    }
#line 894
		}
#line 894
	    } else {
#line 894
		IF (err != NC_ECHAR)
#line 894
		    error("wrong type: status = %d", err);
#line 894
	    }
#line 894
	}
#line 894
    }
#line 894

#line 894
    err = nc_close(ncid);
#line 894
    IF (err)
#line 894
	error("nc_close: %s", nc_strerror(err));
#line 894
    print_nok(nok);
#line 894
}
#line 894

void
#line 895
test_nc_get_att_float(void)
#line 895
{
#line 895
    int ncid;
#line 895
    int i;
#line 895
    int j;
#line 895
    size_t k;
#line 895
    int err;
#line 895
    int allInExtRange;
#line 895
    int allInIntRange;
#line 895
    int canConvert;     /* Both text or both numeric */
#line 895
    float value[MAX_NELS];
#line 895
    double expect[MAX_NELS];
#line 895
    int nok = 0;      /* count of valid comparisons */
#line 895

#line 895
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 895
    IF (err) 
#line 895
	error("nc_open: %s", nc_strerror(err));
#line 895

#line 895
    for (i = -1; i < NVARS; i++) {
#line 895
        for (j = 0; j < NATTS(i); j++) {
#line 895
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 895
	    err = nc_get_att_float(BAD_ID, i, ATT_NAME(i,j), value);
#line 895
	    IF (err != NC_EBADID) 
#line 895
		error("bad ncid: status = %d", err);
#line 895
	    err = nc_get_att_float(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 895
	    IF (err != NC_ENOTVAR) 
#line 895
		error("bad var id: status = %d", err);
#line 895
	    err = nc_get_att_float(ncid, i, "noSuch", value);
#line 895
	    IF (err != NC_ENOTATT) 
#line 895
		error("Bad attribute name: status = %d", err);
#line 895
	    allInExtRange = allInIntRange = 1;
#line 895
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 895
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_FLOAT);
#line 895
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_FLOAT)) {
#line 895
                    allInIntRange = allInIntRange && expect[k] >= float_min
#line 895
                                && expect[k] <= float_max;
#line 895
                } else {
#line 895
                    allInExtRange = 0;
#line 895
                }
#line 895
	    }
#line 895
	    err = nc_get_att_float(ncid, i, ATT_NAME(i,j), value);
#line 895
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 895
                if (allInExtRange) {
#line 895
                    if (allInIntRange) {
#line 895
                        IF (err)
#line 895
                            error("%s", nc_strerror(err));
#line 895
                    } else {
#line 895
                        IF (err != NC_ERANGE)
#line 895
                            error("Range error: status = %d", err);
#line 895
                    }
#line 895
                } else {
#line 895
                    IF (err != 0 && err != NC_ERANGE)
#line 895
                        error("OK or Range error: status = %d", err);
#line 895
                }
#line 895
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 895
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_FLOAT)
#line 895
                            && expect[k] >= float_min && expect[k] <= float_max) {
#line 895
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j), NCT_FLOAT)){
#line 895
			    error("value read not that expected");
#line 895
                            if (verbose) {
#line 895
                                error("\n");
#line 895
                                error("varid: %d, ", i);
#line 895
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 895
                                error("element number: %d ", k);
#line 895
                                error("expect: %g", expect[k]);
#line 895
                                error("got: %g", (double) value[k]);
#line 895
                            }
#line 895
			} else {
#line 895
			    nok++;
#line 895
                        }
#line 895
		    }
#line 895
		}
#line 895
	    } else {
#line 895
		IF (err != NC_ECHAR)
#line 895
		    error("wrong type: status = %d", err);
#line 895
	    }
#line 895
	}
#line 895
    }
#line 895

#line 895
    err = nc_close(ncid);
#line 895
    IF (err)
#line 895
	error("nc_close: %s", nc_strerror(err));
#line 895
    print_nok(nok);
#line 895
}
#line 895

void
#line 896
test_nc_get_att_double(void)
#line 896
{
#line 896
    int ncid;
#line 896
    int i;
#line 896
    int j;
#line 896
    size_t k;
#line 896
    int err;
#line 896
    int allInExtRange;
#line 896
    int allInIntRange;
#line 896
    int canConvert;     /* Both text or both numeric */
#line 896
    double value[MAX_NELS];
#line 896
    double expect[MAX_NELS];
#line 896
    int nok = 0;      /* count of valid comparisons */
#line 896

#line 896
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 896
    IF (err) 
#line 896
	error("nc_open: %s", nc_strerror(err));
#line 896

#line 896
    for (i = -1; i < NVARS; i++) {
#line 896
        for (j = 0; j < NATTS(i); j++) {
#line 896
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 896
	    err = nc_get_att_double(BAD_ID, i, ATT_NAME(i,j), value);
#line 896
	    IF (err != NC_EBADID) 
#line 896
		error("bad ncid: status = %d", err);
#line 896
	    err = nc_get_att_double(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 896
	    IF (err != NC_ENOTVAR) 
#line 896
		error("bad var id: status = %d", err);
#line 896
	    err = nc_get_att_double(ncid, i, "noSuch", value);
#line 896
	    IF (err != NC_ENOTATT) 
#line 896
		error("Bad attribute name: status = %d", err);
#line 896
	    allInExtRange = allInIntRange = 1;
#line 896
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 896
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_DOUBLE);
#line 896
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_DOUBLE)) {
#line 896
                    allInIntRange = allInIntRange && expect[k] >= double_min
#line 896
                                && expect[k] <= double_max;
#line 896
                } else {
#line 896
                    allInExtRange = 0;
#line 896
                }
#line 896
	    }
#line 896
	    err = nc_get_att_double(ncid, i, ATT_NAME(i,j), value);
#line 896
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 896
                if (allInExtRange) {
#line 896
                    if (allInIntRange) {
#line 896
                        IF (err)
#line 896
                            error("%s", nc_strerror(err));
#line 896
                    } else {
#line 896
                        IF (err != NC_ERANGE)
#line 896
                            error("Range error: status = %d", err);
#line 896
                    }
#line 896
                } else {
#line 896
                    IF (err != 0 && err != NC_ERANGE)
#line 896
                        error("OK or Range error: status = %d", err);
#line 896
                }
#line 896
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 896
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_DOUBLE)
#line 896
                            && expect[k] >= double_min && expect[k] <= double_max) {
#line 896
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j), NCT_DOUBLE)){
#line 896
			    error("value read not that expected");
#line 896
                            if (verbose) {
#line 896
                                error("\n");
#line 896
                                error("varid: %d, ", i);
#line 896
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 896
                                error("element number: %d ", k);
#line 896
                                error("expect: %g", expect[k]);
#line 896
                                error("got: %g", (double) value[k]);
#line 896
                            }
#line 896
			} else {
#line 896
			    nok++;
#line 896
                        }
#line 896
		    }
#line 896
		}
#line 896
	    } else {
#line 896
		IF (err != NC_ECHAR)
#line 896
		    error("wrong type: status = %d", err);
#line 896
	    }
#line 896
	}
#line 896
    }
#line 896

#line 896
    err = nc_close(ncid);
#line 896
    IF (err)
#line 896
	error("nc_close: %s", nc_strerror(err));
#line 896
    print_nok(nok);
#line 896
}
#line 896


