#line 11 "ncx.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 13
/*
 *	Copyright 1996, University Corporation for Atmospheric Research
 *	See netcdf/COPYRIGHT file for copying and redistribution conditions.
 * 	
 * 	This file contains some routines derived from code
 *	which is copyrighted by Sun Microsystems, Inc.
 *	The "#ifdef vax" versions of
 *		 ncx_put_float_float()
 *		 ncx_get_float_float()
 *		 ncx_put_double_double()
 *		 ncx_get_double_double()
 *		 ncx_putn_float_float()
 *		 ncx_getn_float_float()
 *		 ncx_putn_double_double()
 *		 ncx_getn_double_double()
 * 	are derived from xdr_float() and xdr_double() routines
 *	in the freely available, copyrighted Sun RPCSRC 3.9
 *	distribution, xdr_float.c.
 * 	Our "value added" is that these are always memory to memory,
 *	they handle IEEE subnormals properly, and their "n" versions
 *	operate speedily on arrays.
 */
/* $Id: ncx.m4,v 2.58 2010/05/26 18:11:08 dmh Exp $ */

/*
 * An external data representation interface.
 */

#include "ncx.h"
#include "nc3dispatch.h"
#include <string.h>
#include <limits.h>

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if _SX /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIGENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressivly.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
		(((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
		(((a) <<  8) & 0x00ff0000) | \
		(((a) >>  8) & 0x0000ff00) | \
		(((a) >> 24) & 0x000000ff) )


static void
swapn2b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *
 *	while(nn-- != 0)
 *	{
 *		*op++ = *(++ip);
 *		*op++ = *(ip++ -1);
 *	}                                       
 */
	while(nn > 3)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		nn -= 4;
	}
	while(nn-- != 0)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
	}
}

# ifndef vax
static void
swap4b(void *dst, const void *src)
{
	char *op = dst;
	const char *ip = src;
	op[0] = ip[3];
	op[1] = ip[2];
	op[2] = ip[1];
	op[3] = ip[0];
}
# endif /* !vax */

static void
swapn4b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while(nn-- != 0)
 *	{
 *		op[0] = ip[3];
 *		op[1] = ip[2];
 *		op[2] = ip[1];
 *		op[3] = ip[0];
 *		op += 4;
 *		ip += 4;
 *	}
 */
	while(nn > 3)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op[8] = ip[11];
		op[9] = ip[10];
		op[10] = ip[9];
		op[11] = ip[8];
		op[12] = ip[15];
		op[13] = ip[14];
		op[14] = ip[13];
		op[15] = ip[12];
		op += 16;
		ip += 16;
		nn -= 4;
	}
	while(nn-- != 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op += 4;
		ip += 4;
	}
}

# ifndef vax
static void
swap8b(void *dst, const void *src)
{
	char *op = dst;
	const char *ip = src;
#  ifndef FLOAT_WORDS_BIGENDIAN
	op[0] = ip[7];
	op[1] = ip[6];
	op[2] = ip[5];
	op[3] = ip[4];
	op[4] = ip[3];
	op[5] = ip[2];
	op[6] = ip[1];
	op[7] = ip[0];
#  else
	op[0] = ip[3];
	op[1] = ip[2];
	op[2] = ip[1];
	op[3] = ip[0];
	op[4] = ip[7];
	op[5] = ip[6];
	op[6] = ip[5];
	op[7] = ip[4];
#  endif
}
# endif /* !vax */

# ifndef vax
static void
swapn8b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while(nn-- != 0)
 *	{
 *		op[0] = ip[7];
 *		op[1] = ip[6];
 *		op[2] = ip[5];
 *		op[3] = ip[4];
 *		op[4] = ip[3];
 *		op[5] = ip[2];
 *		op[6] = ip[1];
 *		op[7] = ip[0];
 *		op += 8;
 *		ip += 8;
 *	}
 */
#  ifndef FLOAT_WORDS_BIGENDIAN
	while(nn > 1)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op[8] = ip[15];
		op[9] = ip[14];
		op[10] = ip[13];
		op[11] = ip[12];
		op[12] = ip[11];
		op[13] = ip[10];
		op[14] = ip[9];
		op[15] = ip[8];
		op += 16;
		ip += 16;
		nn -= 2;
	}
	while(nn-- != 0)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op += 8;
		ip += 8;
	}
#  else
	while(nn-- != 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op += 8;
		ip += 8;
	}
#  endif
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */


/*
 * Primitive numeric conversion functions.
 */

/* x_schar */

/* We don't implement any x_schar primitives. */


/* x_short */

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG_LONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = *cp++ << 8;
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if(*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= *cp; 
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (*ip) >> 8;
	*cp = (*ip) & 0xff;
}


int
ncx_get_short_schar(const void *xp, schar *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
	if(xx > SCHAR_MAX || xx < SCHAR_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_short_uchar(const void *xp, uchar *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
	if(xx > UCHAR_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_short_short(const void *xp, short *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
	get_ix_short(xp, (ix_short *)ip);
	return ENOERR;
#else
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
#   if IX_SHORT_MAX > SHORT_MAX
	if(xx > SHORT_MAX || xx < SHORT_MIN)
		return NC_ERANGE;
#   endif
	return ENOERR;
#endif
}

int
ncx_get_short_int(const void *xp, int *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
	get_ix_short(xp, (ix_short *)ip);
	return ENOERR;
#else
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
#   if IX_SHORT_MAX > INT_MAX
	if(xx > INT_MAX || xx < INT_MIN)
		return NC_ERANGE;
#   endif
	return ENOERR;
#endif
}

int
ncx_get_short_uint(const void *xp, unsigned int *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
	get_ix_short(xp, (ix_short *)ip);
	return ENOERR;
#else
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
#   if IX_SHORT_MAX > INT_MAX
	if(xx > UINT_MAX || xx < 0)
		return NC_ERANGE;
#   endif
	return ENOERR;
#endif
}

int
ncx_get_short_longlong(const void *xp, long long *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_LONG_LONG && IX_SHORT_MAX == LONG_LONG_MAX
	get_ix_short(xp, (ix_short *)ip);
	return ENOERR;
#else
	/* assert(LONG_LONG_MAX >= X_SHORT_MAX); */
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
	return ENOERR;
#endif
}

int
ncx_get_short_ulonglong(const void *xp, unsigned long long *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
	get_ix_short(xp, (ix_short *)ip);
	return ENOERR;
#else
	/* assert(LONG_LONG_MAX >= X_SHORT_MAX); */
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
	if(xx < 0)
		return NC_ERANGE;
	return ENOERR;
#endif
}

int
ncx_get_short_float(const void *xp, float *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
#if 0	/* TODO: determine when necessary */
	if(xx > FLT_MAX || xx < (-FLT_MAX))
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_get_short_double(const void *xp, double *ip)
{
	/* assert(DBL_MAX >= X_SHORT_MAX); */
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = xx;
	return ENOERR;
}

int
ncx_put_short_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	if(*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
	return ENOERR;
}

int
ncx_put_short_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return ENOERR;
}

int
ncx_put_short_short(void *xp, const short *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && X_SHORT_MAX == SHORT_MAX
	put_ix_short(xp, (const ix_short *)ip);
	return ENOERR;
#else
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
# if X_SHORT_MAX < SHORT_MAX
	if(*ip > X_SHORT_MAX || *ip < X_SHORT_MIN)
		return NC_ERANGE;
# endif
	return ENOERR;
#endif
}

int
ncx_put_short_int(void *xp, const int *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_INT && X_SHORT_MAX == INT_MAX
	put_ix_short(xp, (const ix_short *)ip);
	return ENOERR;
#else
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
# if X_SHORT_MAX < INT_MAX
	if(*ip > X_SHORT_MAX || *ip < X_SHORT_MIN)
		return NC_ERANGE;
# endif
	return ENOERR;
#endif
}

int
ncx_put_short_uint(void *xp, const unsigned int *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_INT && X_SHORT_MAX == INT_MAX
	put_ix_short(xp, (const ix_short *)ip);
	return ENOERR;
#else
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
# if X_SHORT_MAX < INT_MAX
	if(*ip > X_SHORT_MAX)
		return NC_ERANGE;
# endif
	return ENOERR;
#endif
}

int
ncx_put_short_longlong(void *xp, const long long *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_LONG_LONG && X_SHORT_MAX == LONG_LONG_MAX
	put_ix_short(xp, (const ix_short *)ip);
	return ENOERR;
#else
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
# if X_SHORT_MAX < LONG_LONG_MAX
	if(*ip > X_SHORT_MAX || *ip < X_SHORT_MIN)
		return NC_ERANGE;
# endif
	return ENOERR;
#endif
}

int
ncx_put_short_ulonglong(void *xp, const unsigned long long *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_LONG_LONG && X_SHORT_MAX == LONG_LONG_MAX
	put_ix_short(xp, (const ix_short *)ip);
	return ENOERR;
#else
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
# if X_SHORT_MAX < LONG_LONG_MAX
	if(*ip > X_SHORT_MAX)
		return NC_ERANGE;
# endif
	return ENOERR;
#endif
}

int
ncx_put_short_float(void *xp, const float *ip)
{
	ix_short xx = *ip;
	put_ix_short(xp, &xx);
	if(*ip > X_SHORT_MAX || *ip < X_SHORT_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_put_short_double(void *xp, const double *ip)
{
	ix_short xx = *ip;
	put_ix_short(xp, &xx);
	if(*ip > X_SHORT_MAX || *ip < X_SHORT_MIN)
		return NC_ERANGE;
	return ENOERR;
}

/* x_int */

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = *cp++ << 24;
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if(*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp; 
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (*ip) >> 24;
	*cp++ = ((*ip) & 0x00ff0000) >> 16;
	*cp++ = ((*ip) & 0x0000ff00) >>  8;
	*cp   = ((*ip) & 0x000000ff);
}


int
ncx_get_int_schar(const void *xp, schar *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
	if(xx > SCHAR_MAX || xx < SCHAR_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_int_uchar(const void *xp, uchar *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
	if(xx > UCHAR_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_int_short(const void *xp, short *ip)
{
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
	get_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
#  if IX_INT_MAX > SHORT_MAX
	if(xx > SHORT_MAX || xx < SHORT_MIN)
		return NC_ERANGE;
#  endif
	return ENOERR;
#endif
}

int
ncx_get_int_int(const void *xp, int *ip)
{
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
	get_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
#  if IX_INT_MAX > INT_MAX
	if(xx > INT_MAX || xx < INT_MIN)
		return NC_ERANGE;
#  endif
	return ENOERR;
#endif
}

int
ncx_get_int_uint(const void *xp, unsigned int *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
	if(xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_int_longlong(const void *xp, long long *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
	return ENOERR;
}

int
ncx_get_int_ulonglong(const void *xp, unsigned long long *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
	if(xx < 0)
	      return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_int_float(const void *xp, float *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
#if 0	/* TODO: determine when necessary */
	if(xx > FLT_MAX || xx < (-FLT_MAX))
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_get_int_double(const void *xp, double *ip)
{
	/* assert((DBL_MAX >= X_INT_MAX); */
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = xx;
	return ENOERR;
}

int
ncx_put_int_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	if(*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)*ip;
	return ENOERR;
}

int
ncx_put_int_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return ENOERR;
}

int
ncx_put_int_short(void *xp, const short *ip)
{
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
	put_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx = (ix_int)(*ip);
	put_ix_int(xp, &xx);
#   if IX_INT_MAX < SHORT_MAX
	if(*ip > X_INT_MAX || *ip < X_INT_MIN)
		return NC_ERANGE;
#   endif
	return ENOERR;
#endif
}

int
ncx_put_int_int(void *xp, const int *ip)
{
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
	put_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx = (ix_int)(*ip);
	put_ix_int(xp, &xx);
#   if IX_INT_MAX < INT_MAX
	if(*ip > X_INT_MAX || *ip < X_INT_MIN)
		return NC_ERANGE;
#   endif
	return ENOERR;
#endif
}

int
ncx_put_int_uint(void *xp, const unsigned int *ip)
{
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
	put_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx = (ix_int)(*ip);
	put_ix_int(xp, &xx);
	if(*ip > X_UINT_MAX)
		return NC_ERANGE;
	return ENOERR;
#endif
}

int
ncx_put_int_longlong(void *xp, const longlong *ip)
{
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
	put_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx = (ix_int)(*ip);
	put_ix_int(xp, &xx);
#   if IX_INT_MAX < LONG_LONG_MAX
	if(*ip > X_INT_MAX || *ip < X_INT_MIN)
		return NC_ERANGE;
#   endif
	return ENOERR;
#endif
}

int
ncx_put_int_ulonglong(void *xp, const unsigned long long *ip)
{
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
	put_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx = (ix_int)(*ip);
	put_ix_int(xp, &xx);
#   if IX_INT_MAX < LONG_MAX
	if(*ip > X_INT_MAX)
		return NC_ERANGE;
#   endif
	return ENOERR;
#endif
}

int
ncx_put_int_float(void *xp, const float *ip)
{
	ix_int xx = (ix_int)(*ip);
	put_ix_int(xp, &xx);
	if(*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_put_int_double(void *xp, const double *ip)
{
	ix_int xx = (ix_int)(*ip);
	put_ix_int(xp, &xx);
	if(*ip > X_INT_MAX || *ip < X_INT_MIN)
		return NC_ERANGE;
	return ENOERR;
}
 

/* x_float */

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, sizeof(float));
#else
	swap4b(ip, xp);
#endif
}

static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif vax

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

#line 1057
static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 1060
		const struct ieee_single *const isp =
#line 1060
			 (const struct ieee_single *) xp;
#line 1060
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 1060

#line 1060
		switch(exp) {
#line 1060
		case 0 :
#line 1060
			/* ieee subnormal */
#line 1060
			if(isp->mant_hi == min.ieee.mant_hi
#line 1060
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 1060
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 1060
			{
#line 1060
				*vsp = min.s;
#line 1060
			}
#line 1060
			else
#line 1060
			{
#line 1060
				unsigned mantissa = (isp->mant_hi << 16)
#line 1060
					 | isp->mant_lo_hi << 8
#line 1060
					 | isp->mant_lo_lo;
#line 1060
				unsigned tmp = mantissa >> 20;
#line 1060
				if(tmp >= 4) {
#line 1060
					vsp->exp = 2;
#line 1060
				} else if (tmp >= 2) {
#line 1060
					vsp->exp = 1;
#line 1060
				} else {
#line 1060
					*vsp = min.s;
#line 1060
					break;
#line 1060
				} /* else */
#line 1060
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 1060
				tmp <<= 3 - vsp->exp;
#line 1060
				vsp->mantissa2 = tmp;
#line 1060
				vsp->mantissa1 = (tmp >> 16);
#line 1060
			}
#line 1060
			break;
#line 1060
		case 0xfe :
#line 1060
		case 0xff :
#line 1060
			*vsp = max.s;
#line 1060
			break;
#line 1060
		default :
#line 1060
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 1060
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 1060
			vsp->mantissa1 = isp->mant_hi;
#line 1060
		}
#line 1060

#line 1060
		vsp->sign = isp->sign;
#line 1060

}

#line 1114

static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
#line 1118
			 (const struct vax_single *)ip;
#line 1118
		struct ieee_single *const isp = (struct ieee_single *) xp;
#line 1118

#line 1118
		switch(vsp->exp){
#line 1118
		case 0 :
#line 1118
			/* all vax float with zero exponent map to zero */
#line 1118
			*isp = min.ieee;
#line 1118
			break;
#line 1118
		case 2 :
#line 1118
		case 1 :
#line 1118
		{
#line 1118
			/* These will map to subnormals */
#line 1118
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 1118
					 | vsp->mantissa2;
#line 1118
			mantissa >>= 3 - vsp->exp;
#line 1118
			mantissa += (1 << (20 + vsp->exp));
#line 1118
			isp->mant_lo_lo = mantissa;
#line 1118
			isp->mant_lo_hi = mantissa >> 8;
#line 1118
			isp->mant_hi = mantissa >> 16;
#line 1118
			isp->exp_lo = 0;
#line 1118
			isp->exp_hi = 0;
#line 1118
		}
#line 1118
			break;
#line 1118
		case 0xff : /* max.s.exp */
#line 1118
			if( vsp->mantissa2 == max.s.mantissa2
#line 1118
				&& vsp->mantissa1 == max.s.mantissa1)
#line 1118
			{
#line 1118
				/* map largest vax float to ieee infinity */
#line 1118
				*isp = max.ieee;
#line 1118
				break;
#line 1118
			} /* else, fall thru */
#line 1118
		default :
#line 1118
		{
#line 1118
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 1118
			isp->exp_hi = exp >> 1;
#line 1118
			isp->exp_lo = exp;
#line 1118
			isp->mant_lo_lo = vsp->mantissa2;
#line 1118
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 1118
			isp->mant_hi = vsp->mantissa1;
#line 1118
		}
#line 1118
		}
#line 1118

#line 1118
		isp->sign = vsp->sign;
#line 1118

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very wierd YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;

#line 1253

static void
get_ix_float(const void *xp, float *ip)
{

	if(word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1261

#line 1261
		if(isp->exp == 0)
#line 1261
		{
#line 1261
			/* ieee subnormal */
#line 1261
			*ip = (double)isp->mant;
#line 1261
			if(isp->mant != 0)
#line 1261
			{
#line 1261
				csp->exp -= (ieee_single_bias + 22);
#line 1261
			}
#line 1261
		}
#line 1261
		else
#line 1261
		{
#line 1261
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1261
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1261
			csp->mant |= (1 << (48 - 1));
#line 1261
		}
#line 1261
		csp->sign = isp->sign;
#line 1261

#line 1261

	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1266

#line 1266
		if(isp->exp == 0)
#line 1266
		{
#line 1266
			/* ieee subnormal */
#line 1266
			*ip = (double)isp->mant;
#line 1266
			if(isp->mant != 0)
#line 1266
			{
#line 1266
				csp->exp -= (ieee_single_bias + 22);
#line 1266
			}
#line 1266
		}
#line 1266
		else
#line 1266
		{
#line 1266
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1266
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1266
			csp->mant |= (1 << (48 - 1));
#line 1266
		}
#line 1266
		csp->sign = isp->sign;
#line 1266

#line 1266

	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if(word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1276
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1276

#line 1276
	isp->sign = csp->sign;
#line 1276

#line 1276
	if(ieee_exp >= 0xff)
#line 1276
	{
#line 1276
		/* NC_ERANGE => ieee Inf */
#line 1276
		isp->exp = 0xff;
#line 1276
		isp->mant = 0x0;
#line 1276
	}
#line 1276
	else if(ieee_exp > 0)
#line 1276
	{
#line 1276
		/* normal ieee representation */
#line 1276
		isp->exp  = ieee_exp;
#line 1276
		/* assumes cray rep is in normal form */
#line 1276
		assert(csp->mant & 0x800000000000);
#line 1276
		isp->mant = (((csp->mant << 1) &
#line 1276
				0xffffffffffff) >> (48 - 23));
#line 1276
	}
#line 1276
	else if(ieee_exp > -23)
#line 1276
	{
#line 1276
		/* ieee subnormal, right shift */
#line 1276
		const int rshift = (48 - 23 - ieee_exp);
#line 1276

#line 1276
		isp->mant = csp->mant >> rshift;
#line 1276

#line 1276
#if 0
#line 1276
		if(csp->mant & (1 << (rshift -1)))
#line 1276
		{
#line 1276
			/* round up */
#line 1276
			isp->mant++;
#line 1276
		}
#line 1276
#endif
#line 1276

#line 1276
		isp->exp  = 0;
#line 1276
	}
#line 1276
	else
#line 1276
	{
#line 1276
		/* smaller than ieee can represent */
#line 1276
		isp->exp = 0;
#line 1276
		isp->mant = 0;
#line 1276
	}
#line 1276

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1281
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1281

#line 1281
	isp->sign = csp->sign;
#line 1281

#line 1281
	if(ieee_exp >= 0xff)
#line 1281
	{
#line 1281
		/* NC_ERANGE => ieee Inf */
#line 1281
		isp->exp = 0xff;
#line 1281
		isp->mant = 0x0;
#line 1281
	}
#line 1281
	else if(ieee_exp > 0)
#line 1281
	{
#line 1281
		/* normal ieee representation */
#line 1281
		isp->exp  = ieee_exp;
#line 1281
		/* assumes cray rep is in normal form */
#line 1281
		assert(csp->mant & 0x800000000000);
#line 1281
		isp->mant = (((csp->mant << 1) &
#line 1281
				0xffffffffffff) >> (48 - 23));
#line 1281
	}
#line 1281
	else if(ieee_exp > -23)
#line 1281
	{
#line 1281
		/* ieee subnormal, right shift */
#line 1281
		const int rshift = (48 - 23 - ieee_exp);
#line 1281

#line 1281
		isp->mant = csp->mant >> rshift;
#line 1281

#line 1281
#if 0
#line 1281
		if(csp->mant & (1 << (rshift -1)))
#line 1281
		{
#line 1281
			/* round up */
#line 1281
			isp->mant++;
#line 1281
		}
#line 1281
#endif
#line 1281

#line 1281
		isp->exp  = 0;
#line 1281
	}
#line 1281
	else
#line 1281
	{
#line 1281
		/* smaller than ieee can represent */
#line 1281
		isp->exp = 0;
#line 1281
		isp->mant = 0;
#line 1281
	}
#line 1281

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if(word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if(isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if(isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if(word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if(idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if(idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif


int
ncx_get_float_schar(const void *xp, schar *ip)
{
	float xx;
	get_ix_float(xp, &xx);
	*ip = (schar) xx;
	if(xx > SCHAR_MAX || xx < SCHAR_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_float_uchar(const void *xp, uchar *ip)
{
	float xx;
	get_ix_float(xp, &xx);
	*ip = (uchar) xx;
	if(xx > UCHAR_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_float_short(const void *xp, short *ip)
{
	float xx;
	get_ix_float(xp, &xx);
	*ip = (short) xx;
	if(xx > SHORT_MAX || xx < SHORT_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_float_int(const void *xp, int *ip)
{
	float xx;
	get_ix_float(xp, &xx);
	*ip = (int) xx;
	if(xx > (double)INT_MAX || xx < (double)INT_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_float_uint(const void *xp, unsigned int *ip)
{
	float xx;
	get_ix_float(xp, &xx);
	*ip = (unsigned int) xx;
	if(xx > (double)UINT_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_float_longlong(const void *xp, longlong *ip)
{
	float xx;
	get_ix_float(xp, &xx);
	*ip = (longlong) xx;
	if(xx > (double)LONG_LONG_MAX || xx < (double)LONG_LONG_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_float_ulonglong(const void *xp, unsigned long long *ip)
{
	float xx;
	get_ix_float(xp, &xx);
	*ip = (longlong) xx;
	if(xx > (double)ULONG_LONG_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_float_float(const void *xp, float *ip)
{
	/* TODO */
	get_ix_float(xp, ip);
	return ENOERR;
}

int
ncx_get_float_double(const void *xp, double *ip)
{
	/* TODO */
	float xx;
	get_ix_float(xp, &xx);
	*ip = xx;
	return ENOERR;
}


int
ncx_put_float_schar(void *xp, const schar *ip)
{
	float xx = (float) *ip;
	put_ix_float(xp, &xx);
	return ENOERR;
}

int
ncx_put_float_uchar(void *xp, const uchar *ip)
{
	float xx = (float) *ip;
	put_ix_float(xp, &xx);
	return ENOERR;
}

int
ncx_put_float_short(void *xp, const short *ip)
{
	float xx = (float) *ip;
	put_ix_float(xp, &xx);
#if 0	/* TODO: figure this out */
	if((float)(*ip) > X_FLOAT_MAX || (float)(*ip) < X_FLOAT_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_float_int(void *xp, const int *ip)
{
	float xx = (float) *ip;
	put_ix_float(xp, &xx);
#if 1	/* TODO: figure this out */
	if((float)(*ip) > X_FLOAT_MAX || (float)(*ip) < X_FLOAT_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_float_uint(void *xp, const unsigned int *ip)
{
	float xx = (float) *ip;
	put_ix_float(xp, &xx);
#if 1	/* TODO: figure this out */
	if((float)(*ip) > X_FLOAT_MAX)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_float_longlong(void *xp, const longlong *ip)
{
	float xx = (float) *ip;
	put_ix_float(xp, &xx);
#if 1	/* TODO: figure this out */
	if((float)(*ip) > X_FLOAT_MAX || (float)(*ip) < X_FLOAT_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_float_ulonglong(void *xp, const unsigned long long *ip)
{
	float xx = (float) *ip;
	put_ix_float(xp, &xx);
#if 1	/* TODO: figure this out */
	if((float)(*ip) > X_FLOAT_MAX)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_float_float(void *xp, const float *ip)
{
	put_ix_float(xp, ip);
#ifdef NO_IEEE_FLOAT
	if(*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_float_double(void *xp, const double *ip)
{
	float xx = (float) *ip;
	put_ix_float(xp, &xx);
	if(*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN)
		return NC_ERANGE;
	return ENOERR;
}

/* x_double */

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, sizeof(double));
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif vax

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


#line 1661
static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
#line 1664
			 (struct vax_double *)ip;
#line 1664
	const struct ieee_double *const idp =
#line 1664
			 (const struct ieee_double *) xp;
#line 1664
	{
#line 1664
		const struct dbl_limits *lim;
#line 1664
		int ii;
#line 1664
		for (ii = 0, lim = dbl_limits;
#line 1664
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 1664
			ii++, lim++)
#line 1664
		{
#line 1664
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 1664
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 1664
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 1664
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 1664
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 1664
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 1664
				)
#line 1664
			{
#line 1664
				*vdp = lim->d;
#line 1664
				goto doneit;
#line 1664
			}
#line 1664
		}
#line 1664
	}
#line 1664
	{
#line 1664
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 1664
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 1664
	}
#line 1664
	{
#line 1664
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 1664
				 | (idp->mant_5 << 8)
#line 1664
				 | idp->mant_4);
#line 1664
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 1664
		vdp->mantissa1 = (mant_hi >> 13);
#line 1664
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 1664
				| (mant_lo >> 29);
#line 1664
		vdp->mantissa3 = (mant_lo >> 13);
#line 1664
		vdp->mantissa4 = (mant_lo << 3);
#line 1664
	}
#line 1664
	doneit:
#line 1664
		vdp->sign = idp->sign;
#line 1664

}


#line 1734
static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp = 
#line 1737
			(const struct vax_double *)ip;
#line 1737
	struct ieee_double *const idp =
#line 1737
			 (struct ieee_double *) xp;
#line 1737

#line 1737
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 1737
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 1737
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 1737
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 1737
		(vdp->exp == dbl_limits[0].d.exp))
#line 1737
	{
#line 1737
		*idp = dbl_limits[0].ieee;
#line 1737
		goto shipit;
#line 1737
	}
#line 1737
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 1737
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 1737
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 1737
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 1737
		(vdp->exp == dbl_limits[1].d.exp))
#line 1737
	{
#line 1737
		*idp = dbl_limits[1].ieee;
#line 1737
		goto shipit;
#line 1737
	}
#line 1737

#line 1737
	{
#line 1737
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 1737

#line 1737
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 1737
			(vdp->mantissa3 << 13) |
#line 1737
			((vdp->mantissa4 >> 3) & MASK(13));
#line 1737

#line 1737
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 1737
				 | (vdp->mantissa2 >> 3);
#line 1737

#line 1737
		if((vdp->mantissa4 & 7) > 4)
#line 1737
		{
#line 1737
			/* round up */
#line 1737
			mant_lo++;
#line 1737
			if(mant_lo == 0)
#line 1737
			{
#line 1737
				mant_hi++;
#line 1737
				if(mant_hi > 0xffffff)
#line 1737
				{
#line 1737
					mant_hi = 0;
#line 1737
					exp++;
#line 1737
				}
#line 1737
			}
#line 1737
		}
#line 1737

#line 1737
		idp->mant_lo = SWAP4(mant_lo);
#line 1737
		idp->mant_6 = mant_hi >> 16;
#line 1737
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 1737
		idp->mant_4 = mant_hi;
#line 1737
		idp->exp_hi = exp >> 4;
#line 1737
		idp->exp_lo = exp;
#line 1737
	}
#line 1737
		
#line 1737
	shipit:
#line 1737
		idp->sign = vdp->sign;
#line 1737

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if(idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if(idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if(ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if(ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if(ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if(ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if(csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

int
ncx_get_double_schar(const void *xp, schar *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (schar) xx;
	if(xx > SCHAR_MAX || xx < SCHAR_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_double_uchar(const void *xp, uchar *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (uchar) xx;
	if(xx > UCHAR_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_double_short(const void *xp, short *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (short) xx;
	if(xx > SHORT_MAX || xx < SHORT_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_double_int(const void *xp, int *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (int) xx;
	if(xx > INT_MAX || xx < INT_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_double_uint(const void *xp, unsigned int *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (unsigned int) xx;
	if(xx > UINT_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_double_longlong(const void *xp, longlong *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (longlong) xx;
	if(xx > LONG_LONG_MAX || xx < LONG_LONG_MIN)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_double_ulonglong(const void *xp, unsigned long long *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (unsigned longlong) xx;
	if(xx > ULONG_LONG_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

int
ncx_get_double_float(const void *xp, float *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	if(xx > FLT_MAX)
	{
		*ip = FLT_MAX;
		return NC_ERANGE;
	}
	if(xx < (-FLT_MAX))
	{
		*ip = (-FLT_MAX);
		return NC_ERANGE;
	}
	*ip = (float) xx;
	return ENOERR;
}

int
ncx_get_double_double(const void *xp, double *ip)
{
	/* TODO */
	get_ix_double(xp, ip);
	return ENOERR;
}


int
ncx_put_double_schar(void *xp, const schar *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
	return ENOERR;
}

int
ncx_put_double_uchar(void *xp, const uchar *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
	return ENOERR;
}

int
ncx_put_double_short(void *xp, const short *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
#if 0	/* TODO: figure this out */
	if((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_double_int(void *xp, const int *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
#if 0	/* TODO: figure this out */
	if((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_double_uint(void *xp, const unsigned int *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
#if 0	/* TODO: figure this out */
	if((double)(*ip) > X_DOUBLE_MAX)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_double_longlong(void *xp, const longlong *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
#if 1	/* TODO: figure this out */
	if((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_double_ulonglong(void *xp, const unsigned long long *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
#if 1	/* TODO: figure this out */
	if((double)(*ip) > X_DOUBLE_MAX)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_double_float(void *xp, const float *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
#if 1	/* TODO: figure this out */
	if((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

int
ncx_put_double_double(void *xp, const double *ip)
{
	put_ix_double(xp, ip);
#ifdef NO_IEEE_FLOAT
	if(*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}


/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return ENOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp = (unsigned)(*cp++ << 24);
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp; 

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return ENOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
		/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return ERANGE;
	}
	  
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000ULL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000ULL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000ULL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000ULL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000ULL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00ULL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffULL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return ENOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp; 
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return ENOERR;
}


/*
 * Aggregate numeric conversion functions.
 */
#line 2625


#line 2632

/* schar */

#line 2636
int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
#line 2639
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2639
	return ENOERR;
#line 2639

}
#line 2642
int
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
#line 2645
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2645
	return ENOERR;
#line 2645

}
int
#line 2647
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2647
{
#line 2647
	schar *xp = (schar *)(*xpp);
#line 2647

#line 2647
	while(nelems-- != 0)
#line 2647
	{
#line 2647
		*tp++ = *xp++;
#line 2647
	}
#line 2647

#line 2647
	*xpp = (const void *)xp;
#line 2647
	return ENOERR;
#line 2647
}
#line 2647

int
#line 2648
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2648
{
#line 2648
	schar *xp = (schar *)(*xpp);
#line 2648

#line 2648
	while(nelems-- != 0)
#line 2648
	{
#line 2648
		*tp++ = *xp++;
#line 2648
	}
#line 2648

#line 2648
	*xpp = (const void *)xp;
#line 2648
	return ENOERR;
#line 2648
}
#line 2648

int
#line 2649
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2649
{
#line 2649
	schar *xp = (schar *)(*xpp);
#line 2649

#line 2649
	while(nelems-- != 0)
#line 2649
	{
#line 2649
		*tp++ = *xp++;
#line 2649
	}
#line 2649

#line 2649
	*xpp = (const void *)xp;
#line 2649
	return ENOERR;
#line 2649
}
#line 2649

int
#line 2650
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2650
{
#line 2650
	schar *xp = (schar *)(*xpp);
#line 2650

#line 2650
	while(nelems-- != 0)
#line 2650
	{
#line 2650
		*tp++ = *xp++;
#line 2650
	}
#line 2650

#line 2650
	*xpp = (const void *)xp;
#line 2650
	return ENOERR;
#line 2650
}
#line 2650

int
#line 2651
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2651
{
#line 2651
	schar *xp = (schar *)(*xpp);
#line 2651

#line 2651
	while(nelems-- != 0)
#line 2651
	{
#line 2651
		*tp++ = *xp++;
#line 2651
	}
#line 2651

#line 2651
	*xpp = (const void *)xp;
#line 2651
	return ENOERR;
#line 2651
}
#line 2651

int
#line 2652
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2652
{
#line 2652
	schar *xp = (schar *)(*xpp);
#line 2652

#line 2652
	while(nelems-- != 0)
#line 2652
	{
#line 2652
		*tp++ = *xp++;
#line 2652
	}
#line 2652

#line 2652
	*xpp = (const void *)xp;
#line 2652
	return ENOERR;
#line 2652
}
#line 2652

int
#line 2653
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2653
{
#line 2653
	schar *xp = (schar *)(*xpp);
#line 2653

#line 2653
	while(nelems-- != 0)
#line 2653
	{
#line 2653
		*tp++ = *xp++;
#line 2653
	}
#line 2653

#line 2653
	*xpp = (const void *)xp;
#line 2653
	return ENOERR;
#line 2653
}
#line 2653


#line 2656
int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2659

#line 2659
	if(rndup)
#line 2659
		rndup = X_ALIGN - rndup;
#line 2659

#line 2659
	(void) memcpy(tp, *xpp, nelems);
#line 2659
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2659

#line 2659
	return ENOERR;
#line 2659

}
#line 2662
int
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2665

#line 2665
	if(rndup)
#line 2665
		rndup = X_ALIGN - rndup;
#line 2665

#line 2665
	(void) memcpy(tp, *xpp, nelems);
#line 2665
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2665

#line 2665
	return ENOERR;
#line 2665

}
int
#line 2667
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2667
{
#line 2667
	size_t rndup = nelems % X_ALIGN;
#line 2667
	schar *xp = (schar *) *xpp;
#line 2667

#line 2667
	if(rndup)
#line 2667
		rndup = X_ALIGN - rndup;
#line 2667

#line 2667
	while(nelems-- != 0)
#line 2667
	{
#line 2667
		*tp++ = *xp++;
#line 2667
	}
#line 2667

#line 2667
	*xpp = (void *)(xp + rndup);
#line 2667
	return ENOERR;
#line 2667
}
#line 2667

int
#line 2668
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2668
{
#line 2668
	size_t rndup = nelems % X_ALIGN;
#line 2668
	schar *xp = (schar *) *xpp;
#line 2668

#line 2668
	if(rndup)
#line 2668
		rndup = X_ALIGN - rndup;
#line 2668

#line 2668
	while(nelems-- != 0)
#line 2668
	{
#line 2668
		*tp++ = *xp++;
#line 2668
	}
#line 2668

#line 2668
	*xpp = (void *)(xp + rndup);
#line 2668
	return ENOERR;
#line 2668
}
#line 2668

int
#line 2669
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2669
{
#line 2669
	size_t rndup = nelems % X_ALIGN;
#line 2669
	schar *xp = (schar *) *xpp;
#line 2669

#line 2669
	if(rndup)
#line 2669
		rndup = X_ALIGN - rndup;
#line 2669

#line 2669
	while(nelems-- != 0)
#line 2669
	{
#line 2669
		*tp++ = *xp++;
#line 2669
	}
#line 2669

#line 2669
	*xpp = (void *)(xp + rndup);
#line 2669
	return ENOERR;
#line 2669
}
#line 2669

int
#line 2670
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2670
{
#line 2670
	size_t rndup = nelems % X_ALIGN;
#line 2670
	schar *xp = (schar *) *xpp;
#line 2670

#line 2670
	if(rndup)
#line 2670
		rndup = X_ALIGN - rndup;
#line 2670

#line 2670
	while(nelems-- != 0)
#line 2670
	{
#line 2670
		*tp++ = *xp++;
#line 2670
	}
#line 2670

#line 2670
	*xpp = (void *)(xp + rndup);
#line 2670
	return ENOERR;
#line 2670
}
#line 2670

int
#line 2671
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2671
{
#line 2671
	size_t rndup = nelems % X_ALIGN;
#line 2671
	schar *xp = (schar *) *xpp;
#line 2671

#line 2671
	if(rndup)
#line 2671
		rndup = X_ALIGN - rndup;
#line 2671

#line 2671
	while(nelems-- != 0)
#line 2671
	{
#line 2671
		*tp++ = *xp++;
#line 2671
	}
#line 2671

#line 2671
	*xpp = (void *)(xp + rndup);
#line 2671
	return ENOERR;
#line 2671
}
#line 2671

int
#line 2672
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2672
{
#line 2672
	size_t rndup = nelems % X_ALIGN;
#line 2672
	schar *xp = (schar *) *xpp;
#line 2672

#line 2672
	if(rndup)
#line 2672
		rndup = X_ALIGN - rndup;
#line 2672

#line 2672
	while(nelems-- != 0)
#line 2672
	{
#line 2672
		*tp++ = *xp++;
#line 2672
	}
#line 2672

#line 2672
	*xpp = (void *)(xp + rndup);
#line 2672
	return ENOERR;
#line 2672
}
#line 2672

int
#line 2673
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2673
{
#line 2673
	size_t rndup = nelems % X_ALIGN;
#line 2673
	schar *xp = (schar *) *xpp;
#line 2673

#line 2673
	if(rndup)
#line 2673
		rndup = X_ALIGN - rndup;
#line 2673

#line 2673
	while(nelems-- != 0)
#line 2673
	{
#line 2673
		*tp++ = *xp++;
#line 2673
	}
#line 2673

#line 2673
	*xpp = (void *)(xp + rndup);
#line 2673
	return ENOERR;
#line 2673
}
#line 2673


#line 2676
int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
#line 2679
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2679

#line 2679
	return ENOERR;
#line 2679

}
#line 2682
int
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
#line 2685
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2685

#line 2685
	return ENOERR;
#line 2685

}
int
#line 2687
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp)
#line 2687
{
#line 2687
	int status = ENOERR;
#line 2687
	schar *xp = (schar *) *xpp;
#line 2687

#line 2687
	while(nelems-- != 0)
#line 2687
	{
#line 2687
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2687
			status = NC_ERANGE;
#line 2687
		*xp++ = (schar) *tp++;
#line 2687
	}
#line 2687

#line 2687
	*xpp = (void *)xp;
#line 2687
	return status;
#line 2687
}
#line 2687

int
#line 2688
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp)
#line 2688
{
#line 2688
	int status = ENOERR;
#line 2688
	schar *xp = (schar *) *xpp;
#line 2688

#line 2688
	while(nelems-- != 0)
#line 2688
	{
#line 2688
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2688
			status = NC_ERANGE;
#line 2688
		*xp++ = (schar) *tp++;
#line 2688
	}
#line 2688

#line 2688
	*xpp = (void *)xp;
#line 2688
	return status;
#line 2688
}
#line 2688

int
#line 2689
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp)
#line 2689
{
#line 2689
	int status = ENOERR;
#line 2689
	schar *xp = (schar *) *xpp;
#line 2689

#line 2689
	while(nelems-- != 0)
#line 2689
	{
#line 2689
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2689
			status = NC_ERANGE;
#line 2689
		*xp++ = (schar) *tp++;
#line 2689
	}
#line 2689

#line 2689
	*xpp = (void *)xp;
#line 2689
	return status;
#line 2689
}
#line 2689

int
#line 2690
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp)
#line 2690
{
#line 2690
	int status = ENOERR;
#line 2690
	schar *xp = (schar *) *xpp;
#line 2690

#line 2690
	while(nelems-- != 0)
#line 2690
	{
#line 2690
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2690
			status = NC_ERANGE;
#line 2690
		*xp++ = (schar) *tp++;
#line 2690
	}
#line 2690

#line 2690
	*xpp = (void *)xp;
#line 2690
	return status;
#line 2690
}
#line 2690

int
#line 2691
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp)
#line 2691
{
#line 2691
	int status = ENOERR;
#line 2691
	schar *xp = (schar *) *xpp;
#line 2691

#line 2691
	while(nelems-- != 0)
#line 2691
	{
#line 2691
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2691
			status = NC_ERANGE;
#line 2691
		*xp++ = (schar) *tp++;
#line 2691
	}
#line 2691

#line 2691
	*xpp = (void *)xp;
#line 2691
	return status;
#line 2691
}
#line 2691

int
#line 2692
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2692
{
#line 2692
	int status = ENOERR;
#line 2692
	schar *xp = (schar *) *xpp;
#line 2692

#line 2692
	while(nelems-- != 0)
#line 2692
	{
#line 2692
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2692
			status = NC_ERANGE;
#line 2692
		*xp++ = (schar) *tp++;
#line 2692
	}
#line 2692

#line 2692
	*xpp = (void *)xp;
#line 2692
	return status;
#line 2692
}
#line 2692

int
#line 2693
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2693
{
#line 2693
	int status = ENOERR;
#line 2693
	schar *xp = (schar *) *xpp;
#line 2693

#line 2693
	while(nelems-- != 0)
#line 2693
	{
#line 2693
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2693
			status = NC_ERANGE;
#line 2693
		*xp++ = (schar) *tp++;
#line 2693
	}
#line 2693

#line 2693
	*xpp = (void *)xp;
#line 2693
	return status;
#line 2693
}
#line 2693


#line 2696
int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2699

#line 2699
	if(rndup)
#line 2699
		rndup = X_ALIGN - rndup;
#line 2699

#line 2699
	(void) memcpy(*xpp, tp, nelems);
#line 2699
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2699

#line 2699
	if(rndup)
#line 2699
	{
#line 2699
		(void) memcpy(*xpp, nada, rndup);
#line 2699
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2699
	}
#line 2699
	
#line 2699
	return ENOERR;
#line 2699

}
#line 2702
int
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2705

#line 2705
	if(rndup)
#line 2705
		rndup = X_ALIGN - rndup;
#line 2705

#line 2705
	(void) memcpy(*xpp, tp, nelems);
#line 2705
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2705

#line 2705
	if(rndup)
#line 2705
	{
#line 2705
		(void) memcpy(*xpp, nada, rndup);
#line 2705
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2705
	}
#line 2705
	
#line 2705
	return ENOERR;
#line 2705

}
int
#line 2707
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp)
#line 2707
{
#line 2707
	int status = ENOERR;
#line 2707
	size_t rndup = nelems % X_ALIGN;
#line 2707
	schar *xp = (schar *) *xpp;
#line 2707

#line 2707
	if(rndup)
#line 2707
		rndup = X_ALIGN - rndup;
#line 2707

#line 2707
	while(nelems-- != 0)
#line 2707
	{
#line 2707
		/* N.B. schar as signed */
#line 2707
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2707
			status = NC_ERANGE;
#line 2707
		*xp++ = (schar) *tp++;
#line 2707
	}
#line 2707

#line 2707

#line 2707
	if(rndup)
#line 2707
	{
#line 2707
		(void) memcpy(xp, nada, rndup);
#line 2707
		xp += rndup;
#line 2707
	}
#line 2707

#line 2707
	*xpp = (void *)xp;
#line 2707
	return status;
#line 2707
}
#line 2707

int
#line 2708
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp)
#line 2708
{
#line 2708
	int status = ENOERR;
#line 2708
	size_t rndup = nelems % X_ALIGN;
#line 2708
	schar *xp = (schar *) *xpp;
#line 2708

#line 2708
	if(rndup)
#line 2708
		rndup = X_ALIGN - rndup;
#line 2708

#line 2708
	while(nelems-- != 0)
#line 2708
	{
#line 2708
		/* N.B. schar as signed */
#line 2708
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2708
			status = NC_ERANGE;
#line 2708
		*xp++ = (schar) *tp++;
#line 2708
	}
#line 2708

#line 2708

#line 2708
	if(rndup)
#line 2708
	{
#line 2708
		(void) memcpy(xp, nada, rndup);
#line 2708
		xp += rndup;
#line 2708
	}
#line 2708

#line 2708
	*xpp = (void *)xp;
#line 2708
	return status;
#line 2708
}
#line 2708

int
#line 2709
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp)
#line 2709
{
#line 2709
	int status = ENOERR;
#line 2709
	size_t rndup = nelems % X_ALIGN;
#line 2709
	schar *xp = (schar *) *xpp;
#line 2709

#line 2709
	if(rndup)
#line 2709
		rndup = X_ALIGN - rndup;
#line 2709

#line 2709
	while(nelems-- != 0)
#line 2709
	{
#line 2709
		/* N.B. schar as signed */
#line 2709
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2709
			status = NC_ERANGE;
#line 2709
		*xp++ = (schar) *tp++;
#line 2709
	}
#line 2709

#line 2709

#line 2709
	if(rndup)
#line 2709
	{
#line 2709
		(void) memcpy(xp, nada, rndup);
#line 2709
		xp += rndup;
#line 2709
	}
#line 2709

#line 2709
	*xpp = (void *)xp;
#line 2709
	return status;
#line 2709
}
#line 2709

int
#line 2710
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp)
#line 2710
{
#line 2710
	int status = ENOERR;
#line 2710
	size_t rndup = nelems % X_ALIGN;
#line 2710
	schar *xp = (schar *) *xpp;
#line 2710

#line 2710
	if(rndup)
#line 2710
		rndup = X_ALIGN - rndup;
#line 2710

#line 2710
	while(nelems-- != 0)
#line 2710
	{
#line 2710
		/* N.B. schar as signed */
#line 2710
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2710
			status = NC_ERANGE;
#line 2710
		*xp++ = (schar) *tp++;
#line 2710
	}
#line 2710

#line 2710

#line 2710
	if(rndup)
#line 2710
	{
#line 2710
		(void) memcpy(xp, nada, rndup);
#line 2710
		xp += rndup;
#line 2710
	}
#line 2710

#line 2710
	*xpp = (void *)xp;
#line 2710
	return status;
#line 2710
}
#line 2710

int
#line 2711
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp)
#line 2711
{
#line 2711
	int status = ENOERR;
#line 2711
	size_t rndup = nelems % X_ALIGN;
#line 2711
	schar *xp = (schar *) *xpp;
#line 2711

#line 2711
	if(rndup)
#line 2711
		rndup = X_ALIGN - rndup;
#line 2711

#line 2711
	while(nelems-- != 0)
#line 2711
	{
#line 2711
		/* N.B. schar as signed */
#line 2711
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2711
			status = NC_ERANGE;
#line 2711
		*xp++ = (schar) *tp++;
#line 2711
	}
#line 2711

#line 2711

#line 2711
	if(rndup)
#line 2711
	{
#line 2711
		(void) memcpy(xp, nada, rndup);
#line 2711
		xp += rndup;
#line 2711
	}
#line 2711

#line 2711
	*xpp = (void *)xp;
#line 2711
	return status;
#line 2711
}
#line 2711

int
#line 2712
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2712
{
#line 2712
	int status = ENOERR;
#line 2712
	size_t rndup = nelems % X_ALIGN;
#line 2712
	schar *xp = (schar *) *xpp;
#line 2712

#line 2712
	if(rndup)
#line 2712
		rndup = X_ALIGN - rndup;
#line 2712

#line 2712
	while(nelems-- != 0)
#line 2712
	{
#line 2712
		/* N.B. schar as signed */
#line 2712
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2712
			status = NC_ERANGE;
#line 2712
		*xp++ = (schar) *tp++;
#line 2712
	}
#line 2712

#line 2712

#line 2712
	if(rndup)
#line 2712
	{
#line 2712
		(void) memcpy(xp, nada, rndup);
#line 2712
		xp += rndup;
#line 2712
	}
#line 2712

#line 2712
	*xpp = (void *)xp;
#line 2712
	return status;
#line 2712
}
#line 2712

int
#line 2713
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2713
{
#line 2713
	int status = ENOERR;
#line 2713
	size_t rndup = nelems % X_ALIGN;
#line 2713
	schar *xp = (schar *) *xpp;
#line 2713

#line 2713
	if(rndup)
#line 2713
		rndup = X_ALIGN - rndup;
#line 2713

#line 2713
	while(nelems-- != 0)
#line 2713
	{
#line 2713
		/* N.B. schar as signed */
#line 2713
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2713
			status = NC_ERANGE;
#line 2713
		*xp++ = (schar) *tp++;
#line 2713
	}
#line 2713

#line 2713

#line 2713
	if(rndup)
#line 2713
	{
#line 2713
		(void) memcpy(xp, nada, rndup);
#line 2713
		xp += rndup;
#line 2713
	}
#line 2713

#line 2713
	*xpp = (void *)xp;
#line 2713
	return status;
#line 2713
}
#line 2713



/* short */

int
#line 2718
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 2718
{
#line 2718
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2718

#line 2718
 /* basic algorithm is:
#line 2718
  *   - ensure sane alignment of input data
#line 2718
  *   - copy (conversion happens automatically) input data
#line 2718
  *     to output
#line 2718
  *   - update xpp to point at next unconverted input, and tp to point
#line 2718
  *     at next location for converted output
#line 2718
  */
#line 2718
  long i, j, ni;
#line 2718
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2718
  short *xp;
#line 2718
  int nrange = 0;         /* number of range errors */
#line 2718
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2718
  long cxp = (long) *((char**)xpp);
#line 2718

#line 2718
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2718
  /* sjl: manually stripmine so we can limit amount of
#line 2718
   * vector work space reserved to LOOPCNT elements. Also
#line 2718
   * makes vectorisation easy */
#line 2718
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2718
    ni=Min(nelems-j,LOOPCNT);
#line 2718
    if (realign) {
#line 2718
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2718
      xp = tmp;
#line 2718
    } else {
#line 2718
      xp = (short *) *xpp;
#line 2718
    }
#line 2718
   /* copy the next block */
#line 2718
#pragma cdir loopcnt=LOOPCNT
#line 2718
#pragma cdir shortloop
#line 2718
    for (i=0; i<ni; i++) {
#line 2718
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2718
     /* test for range errors (not always needed but do it anyway) */
#line 2718
      nrange += xp[i] < SCHAR_MIN || xp[i] > SCHAR_MAX;
#line 2718
    }
#line 2718
   /* update xpp and tp */
#line 2718
    if (realign) xp = (short *) *xpp;
#line 2718
    xp += ni;
#line 2718
    tp += ni;
#line 2718
    *xpp = (void*)xp;
#line 2718
  }
#line 2718
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2718

#line 2718
#else   /* not SX */
#line 2718
	const char *xp = (const char *) *xpp;
#line 2718
	int status = ENOERR;
#line 2718

#line 2718
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2718
	{
#line 2718
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 2718
		if(lstatus != ENOERR)
#line 2718
			status = lstatus;
#line 2718
	}
#line 2718

#line 2718
	*xpp = (const void *)xp;
#line 2718
	return status;
#line 2718
#  endif
#line 2718
}
#line 2718

int
#line 2719
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2719
{
#line 2719
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2719

#line 2719
 /* basic algorithm is:
#line 2719
  *   - ensure sane alignment of input data
#line 2719
  *   - copy (conversion happens automatically) input data
#line 2719
  *     to output
#line 2719
  *   - update xpp to point at next unconverted input, and tp to point
#line 2719
  *     at next location for converted output
#line 2719
  */
#line 2719
  long i, j, ni;
#line 2719
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2719
  short *xp;
#line 2719
  int nrange = 0;         /* number of range errors */
#line 2719
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2719
  long cxp = (long) *((char**)xpp);
#line 2719

#line 2719
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2719
  /* sjl: manually stripmine so we can limit amount of
#line 2719
   * vector work space reserved to LOOPCNT elements. Also
#line 2719
   * makes vectorisation easy */
#line 2719
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2719
    ni=Min(nelems-j,LOOPCNT);
#line 2719
    if (realign) {
#line 2719
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2719
      xp = tmp;
#line 2719
    } else {
#line 2719
      xp = (short *) *xpp;
#line 2719
    }
#line 2719
   /* copy the next block */
#line 2719
#pragma cdir loopcnt=LOOPCNT
#line 2719
#pragma cdir shortloop
#line 2719
    for (i=0; i<ni; i++) {
#line 2719
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2719
     /* test for range errors (not always needed but do it anyway) */
#line 2719
      nrange += xp[i] < UCHAR_MIN || xp[i] > UCHAR_MAX;
#line 2719
    }
#line 2719
   /* update xpp and tp */
#line 2719
    if (realign) xp = (short *) *xpp;
#line 2719
    xp += ni;
#line 2719
    tp += ni;
#line 2719
    *xpp = (void*)xp;
#line 2719
  }
#line 2719
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2719

#line 2719
#else   /* not SX */
#line 2719
	const char *xp = (const char *) *xpp;
#line 2719
	int status = ENOERR;
#line 2719

#line 2719
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2719
	{
#line 2719
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 2719
		if(lstatus != ENOERR)
#line 2719
			status = lstatus;
#line 2719
	}
#line 2719

#line 2719
	*xpp = (const void *)xp;
#line 2719
	return status;
#line 2719
#  endif
#line 2719
}
#line 2719

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(short));
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return ENOERR;
}
#else
int
#line 2734
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 2734
{
#line 2734
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2734

#line 2734
 /* basic algorithm is:
#line 2734
  *   - ensure sane alignment of input data
#line 2734
  *   - copy (conversion happens automatically) input data
#line 2734
  *     to output
#line 2734
  *   - update xpp to point at next unconverted input, and tp to point
#line 2734
  *     at next location for converted output
#line 2734
  */
#line 2734
  long i, j, ni;
#line 2734
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2734
  short *xp;
#line 2734
  int nrange = 0;         /* number of range errors */
#line 2734
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2734
  long cxp = (long) *((char**)xpp);
#line 2734

#line 2734
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2734
  /* sjl: manually stripmine so we can limit amount of
#line 2734
   * vector work space reserved to LOOPCNT elements. Also
#line 2734
   * makes vectorisation easy */
#line 2734
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2734
    ni=Min(nelems-j,LOOPCNT);
#line 2734
    if (realign) {
#line 2734
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2734
      xp = tmp;
#line 2734
    } else {
#line 2734
      xp = (short *) *xpp;
#line 2734
    }
#line 2734
   /* copy the next block */
#line 2734
#pragma cdir loopcnt=LOOPCNT
#line 2734
#pragma cdir shortloop
#line 2734
    for (i=0; i<ni; i++) {
#line 2734
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2734
     /* test for range errors (not always needed but do it anyway) */
#line 2734
      nrange += xp[i] < SHORT_MIN || xp[i] > SHORT_MAX;
#line 2734
    }
#line 2734
   /* update xpp and tp */
#line 2734
    if (realign) xp = (short *) *xpp;
#line 2734
    xp += ni;
#line 2734
    tp += ni;
#line 2734
    *xpp = (void*)xp;
#line 2734
  }
#line 2734
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2734

#line 2734
#else   /* not SX */
#line 2734
	const char *xp = (const char *) *xpp;
#line 2734
	int status = ENOERR;
#line 2734

#line 2734
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2734
	{
#line 2734
		const int lstatus = ncx_get_short_short(xp, tp);
#line 2734
		if(lstatus != ENOERR)
#line 2734
			status = lstatus;
#line 2734
	}
#line 2734

#line 2734
	*xpp = (const void *)xp;
#line 2734
	return status;
#line 2734
#  endif
#line 2734
}
#line 2734

#endif
int
#line 2736
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 2736
{
#line 2736
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2736

#line 2736
 /* basic algorithm is:
#line 2736
  *   - ensure sane alignment of input data
#line 2736
  *   - copy (conversion happens automatically) input data
#line 2736
  *     to output
#line 2736
  *   - update xpp to point at next unconverted input, and tp to point
#line 2736
  *     at next location for converted output
#line 2736
  */
#line 2736
  long i, j, ni;
#line 2736
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2736
  short *xp;
#line 2736
  int nrange = 0;         /* number of range errors */
#line 2736
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2736
  long cxp = (long) *((char**)xpp);
#line 2736

#line 2736
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2736
  /* sjl: manually stripmine so we can limit amount of
#line 2736
   * vector work space reserved to LOOPCNT elements. Also
#line 2736
   * makes vectorisation easy */
#line 2736
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2736
    ni=Min(nelems-j,LOOPCNT);
#line 2736
    if (realign) {
#line 2736
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2736
      xp = tmp;
#line 2736
    } else {
#line 2736
      xp = (short *) *xpp;
#line 2736
    }
#line 2736
   /* copy the next block */
#line 2736
#pragma cdir loopcnt=LOOPCNT
#line 2736
#pragma cdir shortloop
#line 2736
    for (i=0; i<ni; i++) {
#line 2736
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2736
     /* test for range errors (not always needed but do it anyway) */
#line 2736
      nrange += xp[i] < INT_MIN || xp[i] > INT_MAX;
#line 2736
    }
#line 2736
   /* update xpp and tp */
#line 2736
    if (realign) xp = (short *) *xpp;
#line 2736
    xp += ni;
#line 2736
    tp += ni;
#line 2736
    *xpp = (void*)xp;
#line 2736
  }
#line 2736
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2736

#line 2736
#else   /* not SX */
#line 2736
	const char *xp = (const char *) *xpp;
#line 2736
	int status = ENOERR;
#line 2736

#line 2736
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2736
	{
#line 2736
		const int lstatus = ncx_get_short_int(xp, tp);
#line 2736
		if(lstatus != ENOERR)
#line 2736
			status = lstatus;
#line 2736
	}
#line 2736

#line 2736
	*xpp = (const void *)xp;
#line 2736
	return status;
#line 2736
#  endif
#line 2736
}
#line 2736

int
#line 2737
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 2737
{
#line 2737
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2737

#line 2737
 /* basic algorithm is:
#line 2737
  *   - ensure sane alignment of input data
#line 2737
  *   - copy (conversion happens automatically) input data
#line 2737
  *     to output
#line 2737
  *   - update xpp to point at next unconverted input, and tp to point
#line 2737
  *     at next location for converted output
#line 2737
  */
#line 2737
  long i, j, ni;
#line 2737
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2737
  short *xp;
#line 2737
  int nrange = 0;         /* number of range errors */
#line 2737
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2737
  long cxp = (long) *((char**)xpp);
#line 2737

#line 2737
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2737
  /* sjl: manually stripmine so we can limit amount of
#line 2737
   * vector work space reserved to LOOPCNT elements. Also
#line 2737
   * makes vectorisation easy */
#line 2737
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2737
    ni=Min(nelems-j,LOOPCNT);
#line 2737
    if (realign) {
#line 2737
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2737
      xp = tmp;
#line 2737
    } else {
#line 2737
      xp = (short *) *xpp;
#line 2737
    }
#line 2737
   /* copy the next block */
#line 2737
#pragma cdir loopcnt=LOOPCNT
#line 2737
#pragma cdir shortloop
#line 2737
    for (i=0; i<ni; i++) {
#line 2737
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2737
     /* test for range errors (not always needed but do it anyway) */
#line 2737
      nrange += xp[i] < FLOAT_MIN || xp[i] > FLOAT_MAX;
#line 2737
    }
#line 2737
   /* update xpp and tp */
#line 2737
    if (realign) xp = (short *) *xpp;
#line 2737
    xp += ni;
#line 2737
    tp += ni;
#line 2737
    *xpp = (void*)xp;
#line 2737
  }
#line 2737
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2737

#line 2737
#else   /* not SX */
#line 2737
	const char *xp = (const char *) *xpp;
#line 2737
	int status = ENOERR;
#line 2737

#line 2737
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2737
	{
#line 2737
		const int lstatus = ncx_get_short_float(xp, tp);
#line 2737
		if(lstatus != ENOERR)
#line 2737
			status = lstatus;
#line 2737
	}
#line 2737

#line 2737
	*xpp = (const void *)xp;
#line 2737
	return status;
#line 2737
#  endif
#line 2737
}
#line 2737

int
#line 2738
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 2738
{
#line 2738
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2738

#line 2738
 /* basic algorithm is:
#line 2738
  *   - ensure sane alignment of input data
#line 2738
  *   - copy (conversion happens automatically) input data
#line 2738
  *     to output
#line 2738
  *   - update xpp to point at next unconverted input, and tp to point
#line 2738
  *     at next location for converted output
#line 2738
  */
#line 2738
  long i, j, ni;
#line 2738
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2738
  short *xp;
#line 2738
  int nrange = 0;         /* number of range errors */
#line 2738
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2738
  long cxp = (long) *((char**)xpp);
#line 2738

#line 2738
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2738
  /* sjl: manually stripmine so we can limit amount of
#line 2738
   * vector work space reserved to LOOPCNT elements. Also
#line 2738
   * makes vectorisation easy */
#line 2738
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2738
    ni=Min(nelems-j,LOOPCNT);
#line 2738
    if (realign) {
#line 2738
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2738
      xp = tmp;
#line 2738
    } else {
#line 2738
      xp = (short *) *xpp;
#line 2738
    }
#line 2738
   /* copy the next block */
#line 2738
#pragma cdir loopcnt=LOOPCNT
#line 2738
#pragma cdir shortloop
#line 2738
    for (i=0; i<ni; i++) {
#line 2738
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2738
     /* test for range errors (not always needed but do it anyway) */
#line 2738
      nrange += xp[i] < DOUBLE_MIN || xp[i] > DOUBLE_MAX;
#line 2738
    }
#line 2738
   /* update xpp and tp */
#line 2738
    if (realign) xp = (short *) *xpp;
#line 2738
    xp += ni;
#line 2738
    tp += ni;
#line 2738
    *xpp = (void*)xp;
#line 2738
  }
#line 2738
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2738

#line 2738
#else   /* not SX */
#line 2738
	const char *xp = (const char *) *xpp;
#line 2738
	int status = ENOERR;
#line 2738

#line 2738
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2738
	{
#line 2738
		const int lstatus = ncx_get_short_double(xp, tp);
#line 2738
		if(lstatus != ENOERR)
#line 2738
			status = lstatus;
#line 2738
	}
#line 2738

#line 2738
	*xpp = (const void *)xp;
#line 2738
	return status;
#line 2738
#  endif
#line 2738
}
#line 2738

int
#line 2739
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 2739
{
#line 2739
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2739

#line 2739
 /* basic algorithm is:
#line 2739
  *   - ensure sane alignment of input data
#line 2739
  *   - copy (conversion happens automatically) input data
#line 2739
  *     to output
#line 2739
  *   - update xpp to point at next unconverted input, and tp to point
#line 2739
  *     at next location for converted output
#line 2739
  */
#line 2739
  long i, j, ni;
#line 2739
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2739
  short *xp;
#line 2739
  int nrange = 0;         /* number of range errors */
#line 2739
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2739
  long cxp = (long) *((char**)xpp);
#line 2739

#line 2739
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2739
  /* sjl: manually stripmine so we can limit amount of
#line 2739
   * vector work space reserved to LOOPCNT elements. Also
#line 2739
   * makes vectorisation easy */
#line 2739
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2739
    ni=Min(nelems-j,LOOPCNT);
#line 2739
    if (realign) {
#line 2739
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2739
      xp = tmp;
#line 2739
    } else {
#line 2739
      xp = (short *) *xpp;
#line 2739
    }
#line 2739
   /* copy the next block */
#line 2739
#pragma cdir loopcnt=LOOPCNT
#line 2739
#pragma cdir shortloop
#line 2739
    for (i=0; i<ni; i++) {
#line 2739
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2739
     /* test for range errors (not always needed but do it anyway) */
#line 2739
      nrange += xp[i] < UINT_MIN || xp[i] > UINT_MAX;
#line 2739
    }
#line 2739
   /* update xpp and tp */
#line 2739
    if (realign) xp = (short *) *xpp;
#line 2739
    xp += ni;
#line 2739
    tp += ni;
#line 2739
    *xpp = (void*)xp;
#line 2739
  }
#line 2739
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2739

#line 2739
#else   /* not SX */
#line 2739
	const char *xp = (const char *) *xpp;
#line 2739
	int status = ENOERR;
#line 2739

#line 2739
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2739
	{
#line 2739
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 2739
		if(lstatus != ENOERR)
#line 2739
			status = lstatus;
#line 2739
	}
#line 2739

#line 2739
	*xpp = (const void *)xp;
#line 2739
	return status;
#line 2739
#  endif
#line 2739
}
#line 2739

int
#line 2740
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2740
{
#line 2740
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2740

#line 2740
 /* basic algorithm is:
#line 2740
  *   - ensure sane alignment of input data
#line 2740
  *   - copy (conversion happens automatically) input data
#line 2740
  *     to output
#line 2740
  *   - update xpp to point at next unconverted input, and tp to point
#line 2740
  *     at next location for converted output
#line 2740
  */
#line 2740
  long i, j, ni;
#line 2740
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2740
  short *xp;
#line 2740
  int nrange = 0;         /* number of range errors */
#line 2740
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2740
  long cxp = (long) *((char**)xpp);
#line 2740

#line 2740
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2740
  /* sjl: manually stripmine so we can limit amount of
#line 2740
   * vector work space reserved to LOOPCNT elements. Also
#line 2740
   * makes vectorisation easy */
#line 2740
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2740
    ni=Min(nelems-j,LOOPCNT);
#line 2740
    if (realign) {
#line 2740
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2740
      xp = tmp;
#line 2740
    } else {
#line 2740
      xp = (short *) *xpp;
#line 2740
    }
#line 2740
   /* copy the next block */
#line 2740
#pragma cdir loopcnt=LOOPCNT
#line 2740
#pragma cdir shortloop
#line 2740
    for (i=0; i<ni; i++) {
#line 2740
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2740
     /* test for range errors (not always needed but do it anyway) */
#line 2740
      nrange += xp[i] < LONGLONG_MIN || xp[i] > LONGLONG_MAX;
#line 2740
    }
#line 2740
   /* update xpp and tp */
#line 2740
    if (realign) xp = (short *) *xpp;
#line 2740
    xp += ni;
#line 2740
    tp += ni;
#line 2740
    *xpp = (void*)xp;
#line 2740
  }
#line 2740
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2740

#line 2740
#else   /* not SX */
#line 2740
	const char *xp = (const char *) *xpp;
#line 2740
	int status = ENOERR;
#line 2740

#line 2740
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2740
	{
#line 2740
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 2740
		if(lstatus != ENOERR)
#line 2740
			status = lstatus;
#line 2740
	}
#line 2740

#line 2740
	*xpp = (const void *)xp;
#line 2740
	return status;
#line 2740
#  endif
#line 2740
}
#line 2740

int
#line 2741
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2741
{
#line 2741
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2741

#line 2741
 /* basic algorithm is:
#line 2741
  *   - ensure sane alignment of input data
#line 2741
  *   - copy (conversion happens automatically) input data
#line 2741
  *     to output
#line 2741
  *   - update xpp to point at next unconverted input, and tp to point
#line 2741
  *     at next location for converted output
#line 2741
  */
#line 2741
  long i, j, ni;
#line 2741
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2741
  short *xp;
#line 2741
  int nrange = 0;         /* number of range errors */
#line 2741
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2741
  long cxp = (long) *((char**)xpp);
#line 2741

#line 2741
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2741
  /* sjl: manually stripmine so we can limit amount of
#line 2741
   * vector work space reserved to LOOPCNT elements. Also
#line 2741
   * makes vectorisation easy */
#line 2741
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2741
    ni=Min(nelems-j,LOOPCNT);
#line 2741
    if (realign) {
#line 2741
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2741
      xp = tmp;
#line 2741
    } else {
#line 2741
      xp = (short *) *xpp;
#line 2741
    }
#line 2741
   /* copy the next block */
#line 2741
#pragma cdir loopcnt=LOOPCNT
#line 2741
#pragma cdir shortloop
#line 2741
    for (i=0; i<ni; i++) {
#line 2741
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2741
     /* test for range errors (not always needed but do it anyway) */
#line 2741
      nrange += xp[i] < ULONGLONG_MIN || xp[i] > ULONGLONG_MAX;
#line 2741
    }
#line 2741
   /* update xpp and tp */
#line 2741
    if (realign) xp = (short *) *xpp;
#line 2741
    xp += ni;
#line 2741
    tp += ni;
#line 2741
    *xpp = (void*)xp;
#line 2741
  }
#line 2741
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2741

#line 2741
#else   /* not SX */
#line 2741
	const char *xp = (const char *) *xpp;
#line 2741
	int status = ENOERR;
#line 2741

#line 2741
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2741
	{
#line 2741
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 2741
		if(lstatus != ENOERR)
#line 2741
			status = lstatus;
#line 2741
	}
#line 2741

#line 2741
	*xpp = (const void *)xp;
#line 2741
	return status;
#line 2741
#  endif
#line 2741
}
#line 2741


int
#line 2743
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 2743
{
#line 2743
	const size_t rndup = nelems % 2;
#line 2743

#line 2743
	const char *xp = (const char *) *xpp;
#line 2743
	int status = ENOERR;
#line 2743

#line 2743
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2743
	{
#line 2743
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 2743
		if(lstatus != ENOERR)
#line 2743
			status = lstatus;
#line 2743
	}
#line 2743

#line 2743
	if(rndup != 0)
#line 2743
		xp += X_SIZEOF_SHORT;
#line 2743
		
#line 2743
	*xpp = (void *)xp;
#line 2743
	return status;
#line 2743
}
#line 2743

int
#line 2744
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2744
{
#line 2744
	const size_t rndup = nelems % 2;
#line 2744

#line 2744
	const char *xp = (const char *) *xpp;
#line 2744
	int status = ENOERR;
#line 2744

#line 2744
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2744
	{
#line 2744
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 2744
		if(lstatus != ENOERR)
#line 2744
			status = lstatus;
#line 2744
	}
#line 2744

#line 2744
	if(rndup != 0)
#line 2744
		xp += X_SIZEOF_SHORT;
#line 2744
		
#line 2744
	*xpp = (void *)xp;
#line 2744
	return status;
#line 2744
}
#line 2744

int
#line 2745
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 2745
{
#line 2745
	const size_t rndup = nelems % 2;
#line 2745

#line 2745
	const char *xp = (const char *) *xpp;
#line 2745
	int status = ENOERR;
#line 2745

#line 2745
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2745
	{
#line 2745
		const int lstatus = ncx_get_short_short(xp, tp);
#line 2745
		if(lstatus != ENOERR)
#line 2745
			status = lstatus;
#line 2745
	}
#line 2745

#line 2745
	if(rndup != 0)
#line 2745
		xp += X_SIZEOF_SHORT;
#line 2745
		
#line 2745
	*xpp = (void *)xp;
#line 2745
	return status;
#line 2745
}
#line 2745

int
#line 2746
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 2746
{
#line 2746
	const size_t rndup = nelems % 2;
#line 2746

#line 2746
	const char *xp = (const char *) *xpp;
#line 2746
	int status = ENOERR;
#line 2746

#line 2746
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2746
	{
#line 2746
		const int lstatus = ncx_get_short_int(xp, tp);
#line 2746
		if(lstatus != ENOERR)
#line 2746
			status = lstatus;
#line 2746
	}
#line 2746

#line 2746
	if(rndup != 0)
#line 2746
		xp += X_SIZEOF_SHORT;
#line 2746
		
#line 2746
	*xpp = (void *)xp;
#line 2746
	return status;
#line 2746
}
#line 2746

int
#line 2747
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 2747
{
#line 2747
	const size_t rndup = nelems % 2;
#line 2747

#line 2747
	const char *xp = (const char *) *xpp;
#line 2747
	int status = ENOERR;
#line 2747

#line 2747
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2747
	{
#line 2747
		const int lstatus = ncx_get_short_float(xp, tp);
#line 2747
		if(lstatus != ENOERR)
#line 2747
			status = lstatus;
#line 2747
	}
#line 2747

#line 2747
	if(rndup != 0)
#line 2747
		xp += X_SIZEOF_SHORT;
#line 2747
		
#line 2747
	*xpp = (void *)xp;
#line 2747
	return status;
#line 2747
}
#line 2747

int
#line 2748
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 2748
{
#line 2748
	const size_t rndup = nelems % 2;
#line 2748

#line 2748
	const char *xp = (const char *) *xpp;
#line 2748
	int status = ENOERR;
#line 2748

#line 2748
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2748
	{
#line 2748
		const int lstatus = ncx_get_short_double(xp, tp);
#line 2748
		if(lstatus != ENOERR)
#line 2748
			status = lstatus;
#line 2748
	}
#line 2748

#line 2748
	if(rndup != 0)
#line 2748
		xp += X_SIZEOF_SHORT;
#line 2748
		
#line 2748
	*xpp = (void *)xp;
#line 2748
	return status;
#line 2748
}
#line 2748

int
#line 2749
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 2749
{
#line 2749
	const size_t rndup = nelems % 2;
#line 2749

#line 2749
	const char *xp = (const char *) *xpp;
#line 2749
	int status = ENOERR;
#line 2749

#line 2749
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2749
	{
#line 2749
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 2749
		if(lstatus != ENOERR)
#line 2749
			status = lstatus;
#line 2749
	}
#line 2749

#line 2749
	if(rndup != 0)
#line 2749
		xp += X_SIZEOF_SHORT;
#line 2749
		
#line 2749
	*xpp = (void *)xp;
#line 2749
	return status;
#line 2749
}
#line 2749

int
#line 2750
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2750
{
#line 2750
	const size_t rndup = nelems % 2;
#line 2750

#line 2750
	const char *xp = (const char *) *xpp;
#line 2750
	int status = ENOERR;
#line 2750

#line 2750
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2750
	{
#line 2750
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 2750
		if(lstatus != ENOERR)
#line 2750
			status = lstatus;
#line 2750
	}
#line 2750

#line 2750
	if(rndup != 0)
#line 2750
		xp += X_SIZEOF_SHORT;
#line 2750
		
#line 2750
	*xpp = (void *)xp;
#line 2750
	return status;
#line 2750
}
#line 2750

int
#line 2751
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2751
{
#line 2751
	const size_t rndup = nelems % 2;
#line 2751

#line 2751
	const char *xp = (const char *) *xpp;
#line 2751
	int status = ENOERR;
#line 2751

#line 2751
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2751
	{
#line 2751
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 2751
		if(lstatus != ENOERR)
#line 2751
			status = lstatus;
#line 2751
	}
#line 2751

#line 2751
	if(rndup != 0)
#line 2751
		xp += X_SIZEOF_SHORT;
#line 2751
		
#line 2751
	*xpp = (void *)xp;
#line 2751
	return status;
#line 2751
}
#line 2751


int
#line 2753
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp)
#line 2753
{
#line 2753
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2753

#line 2753
 /* basic algorithm is:
#line 2753
  *   - ensure sane alignment of output data
#line 2753
  *   - copy (conversion happens automatically) input data
#line 2753
  *     to output
#line 2753
  *   - update tp to point at next unconverted input, and xpp to point
#line 2753
  *     at next location for converted output
#line 2753
  */
#line 2753
  long i, j, ni;
#line 2753
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2753
  short *xp;
#line 2753
  int nrange = 0;         /* number of range errors */
#line 2753
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2753
  long cxp = (long) *((char**)xpp);
#line 2753

#line 2753
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2753
  /* sjl: manually stripmine so we can limit amount of
#line 2753
   * vector work space reserved to LOOPCNT elements. Also
#line 2753
   * makes vectorisation easy */
#line 2753
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2753
    ni=Min(nelems-j,LOOPCNT);
#line 2753
    if (realign) {
#line 2753
      xp = tmp;
#line 2753
    } else {
#line 2753
      xp = (short *) *xpp;
#line 2753
    }
#line 2753
   /* copy the next block */
#line 2753
#pragma cdir loopcnt=LOOPCNT
#line 2753
#pragma cdir shortloop
#line 2753
    for (i=0; i<ni; i++) {
#line 2753
      /* the normal case: */
#line 2753
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2753
     /* test for range errors (not always needed but do it anyway) */
#line 2753
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2753
    }
#line 2753
   /* copy workspace back if necessary */ 
#line 2753
    if (realign) {
#line 2753
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2753
      xp = (short *) *xpp;
#line 2753
    }
#line 2753
   /* update xpp and tp */
#line 2753
    xp += ni;
#line 2753
    tp += ni;
#line 2753
    *xpp = (void*)xp;
#line 2753
  }
#line 2753
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2753

#line 2753
#else   /* not SX */
#line 2753

#line 2753
	char *xp = (char *) *xpp;
#line 2753
	int status = ENOERR;
#line 2753

#line 2753
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2753
	{
#line 2753
		int lstatus = ncx_put_short_schar(xp, tp);
#line 2753
		if(lstatus != ENOERR)
#line 2753
			status = lstatus;
#line 2753
	}
#line 2753

#line 2753
	*xpp = (void *)xp;
#line 2753
	return status;
#line 2753
#endif
#line 2753
}
#line 2753

int
#line 2754
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2754
{
#line 2754
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2754

#line 2754
 /* basic algorithm is:
#line 2754
  *   - ensure sane alignment of output data
#line 2754
  *   - copy (conversion happens automatically) input data
#line 2754
  *     to output
#line 2754
  *   - update tp to point at next unconverted input, and xpp to point
#line 2754
  *     at next location for converted output
#line 2754
  */
#line 2754
  long i, j, ni;
#line 2754
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2754
  short *xp;
#line 2754
  int nrange = 0;         /* number of range errors */
#line 2754
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2754
  long cxp = (long) *((char**)xpp);
#line 2754

#line 2754
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2754
  /* sjl: manually stripmine so we can limit amount of
#line 2754
   * vector work space reserved to LOOPCNT elements. Also
#line 2754
   * makes vectorisation easy */
#line 2754
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2754
    ni=Min(nelems-j,LOOPCNT);
#line 2754
    if (realign) {
#line 2754
      xp = tmp;
#line 2754
    } else {
#line 2754
      xp = (short *) *xpp;
#line 2754
    }
#line 2754
   /* copy the next block */
#line 2754
#pragma cdir loopcnt=LOOPCNT
#line 2754
#pragma cdir shortloop
#line 2754
    for (i=0; i<ni; i++) {
#line 2754
      /* the normal case: */
#line 2754
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2754
     /* test for range errors (not always needed but do it anyway) */
#line 2754
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2754
    }
#line 2754
   /* copy workspace back if necessary */ 
#line 2754
    if (realign) {
#line 2754
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2754
      xp = (short *) *xpp;
#line 2754
    }
#line 2754
   /* update xpp and tp */
#line 2754
    xp += ni;
#line 2754
    tp += ni;
#line 2754
    *xpp = (void*)xp;
#line 2754
  }
#line 2754
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2754

#line 2754
#else   /* not SX */
#line 2754

#line 2754
	char *xp = (char *) *xpp;
#line 2754
	int status = ENOERR;
#line 2754

#line 2754
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2754
	{
#line 2754
		int lstatus = ncx_put_short_uchar(xp, tp);
#line 2754
		if(lstatus != ENOERR)
#line 2754
			status = lstatus;
#line 2754
	}
#line 2754

#line 2754
	*xpp = (void *)xp;
#line 2754
	return status;
#line 2754
#endif
#line 2754
}
#line 2754

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return ENOERR;
}
#else
int
#line 2769
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp)
#line 2769
{
#line 2769
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2769

#line 2769
 /* basic algorithm is:
#line 2769
  *   - ensure sane alignment of output data
#line 2769
  *   - copy (conversion happens automatically) input data
#line 2769
  *     to output
#line 2769
  *   - update tp to point at next unconverted input, and xpp to point
#line 2769
  *     at next location for converted output
#line 2769
  */
#line 2769
  long i, j, ni;
#line 2769
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2769
  short *xp;
#line 2769
  int nrange = 0;         /* number of range errors */
#line 2769
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2769
  long cxp = (long) *((char**)xpp);
#line 2769

#line 2769
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2769
  /* sjl: manually stripmine so we can limit amount of
#line 2769
   * vector work space reserved to LOOPCNT elements. Also
#line 2769
   * makes vectorisation easy */
#line 2769
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2769
    ni=Min(nelems-j,LOOPCNT);
#line 2769
    if (realign) {
#line 2769
      xp = tmp;
#line 2769
    } else {
#line 2769
      xp = (short *) *xpp;
#line 2769
    }
#line 2769
   /* copy the next block */
#line 2769
#pragma cdir loopcnt=LOOPCNT
#line 2769
#pragma cdir shortloop
#line 2769
    for (i=0; i<ni; i++) {
#line 2769
      /* the normal case: */
#line 2769
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2769
     /* test for range errors (not always needed but do it anyway) */
#line 2769
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2769
    }
#line 2769
   /* copy workspace back if necessary */ 
#line 2769
    if (realign) {
#line 2769
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2769
      xp = (short *) *xpp;
#line 2769
    }
#line 2769
   /* update xpp and tp */
#line 2769
    xp += ni;
#line 2769
    tp += ni;
#line 2769
    *xpp = (void*)xp;
#line 2769
  }
#line 2769
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2769

#line 2769
#else   /* not SX */
#line 2769

#line 2769
	char *xp = (char *) *xpp;
#line 2769
	int status = ENOERR;
#line 2769

#line 2769
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2769
	{
#line 2769
		int lstatus = ncx_put_short_short(xp, tp);
#line 2769
		if(lstatus != ENOERR)
#line 2769
			status = lstatus;
#line 2769
	}
#line 2769

#line 2769
	*xpp = (void *)xp;
#line 2769
	return status;
#line 2769
#endif
#line 2769
}
#line 2769

#endif
int
#line 2771
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp)
#line 2771
{
#line 2771
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2771

#line 2771
 /* basic algorithm is:
#line 2771
  *   - ensure sane alignment of output data
#line 2771
  *   - copy (conversion happens automatically) input data
#line 2771
  *     to output
#line 2771
  *   - update tp to point at next unconverted input, and xpp to point
#line 2771
  *     at next location for converted output
#line 2771
  */
#line 2771
  long i, j, ni;
#line 2771
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2771
  short *xp;
#line 2771
  int nrange = 0;         /* number of range errors */
#line 2771
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2771
  long cxp = (long) *((char**)xpp);
#line 2771

#line 2771
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2771
  /* sjl: manually stripmine so we can limit amount of
#line 2771
   * vector work space reserved to LOOPCNT elements. Also
#line 2771
   * makes vectorisation easy */
#line 2771
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2771
    ni=Min(nelems-j,LOOPCNT);
#line 2771
    if (realign) {
#line 2771
      xp = tmp;
#line 2771
    } else {
#line 2771
      xp = (short *) *xpp;
#line 2771
    }
#line 2771
   /* copy the next block */
#line 2771
#pragma cdir loopcnt=LOOPCNT
#line 2771
#pragma cdir shortloop
#line 2771
    for (i=0; i<ni; i++) {
#line 2771
      /* the normal case: */
#line 2771
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2771
     /* test for range errors (not always needed but do it anyway) */
#line 2771
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2771
    }
#line 2771
   /* copy workspace back if necessary */ 
#line 2771
    if (realign) {
#line 2771
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2771
      xp = (short *) *xpp;
#line 2771
    }
#line 2771
   /* update xpp and tp */
#line 2771
    xp += ni;
#line 2771
    tp += ni;
#line 2771
    *xpp = (void*)xp;
#line 2771
  }
#line 2771
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2771

#line 2771
#else   /* not SX */
#line 2771

#line 2771
	char *xp = (char *) *xpp;
#line 2771
	int status = ENOERR;
#line 2771

#line 2771
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2771
	{
#line 2771
		int lstatus = ncx_put_short_int(xp, tp);
#line 2771
		if(lstatus != ENOERR)
#line 2771
			status = lstatus;
#line 2771
	}
#line 2771

#line 2771
	*xpp = (void *)xp;
#line 2771
	return status;
#line 2771
#endif
#line 2771
}
#line 2771

int
#line 2772
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp)
#line 2772
{
#line 2772
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2772

#line 2772
 /* basic algorithm is:
#line 2772
  *   - ensure sane alignment of output data
#line 2772
  *   - copy (conversion happens automatically) input data
#line 2772
  *     to output
#line 2772
  *   - update tp to point at next unconverted input, and xpp to point
#line 2772
  *     at next location for converted output
#line 2772
  */
#line 2772
  long i, j, ni;
#line 2772
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2772
  short *xp;
#line 2772
  int nrange = 0;         /* number of range errors */
#line 2772
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2772
  long cxp = (long) *((char**)xpp);
#line 2772

#line 2772
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2772
  /* sjl: manually stripmine so we can limit amount of
#line 2772
   * vector work space reserved to LOOPCNT elements. Also
#line 2772
   * makes vectorisation easy */
#line 2772
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2772
    ni=Min(nelems-j,LOOPCNT);
#line 2772
    if (realign) {
#line 2772
      xp = tmp;
#line 2772
    } else {
#line 2772
      xp = (short *) *xpp;
#line 2772
    }
#line 2772
   /* copy the next block */
#line 2772
#pragma cdir loopcnt=LOOPCNT
#line 2772
#pragma cdir shortloop
#line 2772
    for (i=0; i<ni; i++) {
#line 2772
      /* the normal case: */
#line 2772
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2772
     /* test for range errors (not always needed but do it anyway) */
#line 2772
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2772
    }
#line 2772
   /* copy workspace back if necessary */ 
#line 2772
    if (realign) {
#line 2772
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2772
      xp = (short *) *xpp;
#line 2772
    }
#line 2772
   /* update xpp and tp */
#line 2772
    xp += ni;
#line 2772
    tp += ni;
#line 2772
    *xpp = (void*)xp;
#line 2772
  }
#line 2772
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2772

#line 2772
#else   /* not SX */
#line 2772

#line 2772
	char *xp = (char *) *xpp;
#line 2772
	int status = ENOERR;
#line 2772

#line 2772
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2772
	{
#line 2772
		int lstatus = ncx_put_short_float(xp, tp);
#line 2772
		if(lstatus != ENOERR)
#line 2772
			status = lstatus;
#line 2772
	}
#line 2772

#line 2772
	*xpp = (void *)xp;
#line 2772
	return status;
#line 2772
#endif
#line 2772
}
#line 2772

int
#line 2773
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp)
#line 2773
{
#line 2773
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2773

#line 2773
 /* basic algorithm is:
#line 2773
  *   - ensure sane alignment of output data
#line 2773
  *   - copy (conversion happens automatically) input data
#line 2773
  *     to output
#line 2773
  *   - update tp to point at next unconverted input, and xpp to point
#line 2773
  *     at next location for converted output
#line 2773
  */
#line 2773
  long i, j, ni;
#line 2773
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2773
  short *xp;
#line 2773
  int nrange = 0;         /* number of range errors */
#line 2773
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2773
  long cxp = (long) *((char**)xpp);
#line 2773

#line 2773
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2773
  /* sjl: manually stripmine so we can limit amount of
#line 2773
   * vector work space reserved to LOOPCNT elements. Also
#line 2773
   * makes vectorisation easy */
#line 2773
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2773
    ni=Min(nelems-j,LOOPCNT);
#line 2773
    if (realign) {
#line 2773
      xp = tmp;
#line 2773
    } else {
#line 2773
      xp = (short *) *xpp;
#line 2773
    }
#line 2773
   /* copy the next block */
#line 2773
#pragma cdir loopcnt=LOOPCNT
#line 2773
#pragma cdir shortloop
#line 2773
    for (i=0; i<ni; i++) {
#line 2773
      /* the normal case: */
#line 2773
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2773
     /* test for range errors (not always needed but do it anyway) */
#line 2773
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2773
    }
#line 2773
   /* copy workspace back if necessary */ 
#line 2773
    if (realign) {
#line 2773
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2773
      xp = (short *) *xpp;
#line 2773
    }
#line 2773
   /* update xpp and tp */
#line 2773
    xp += ni;
#line 2773
    tp += ni;
#line 2773
    *xpp = (void*)xp;
#line 2773
  }
#line 2773
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2773

#line 2773
#else   /* not SX */
#line 2773

#line 2773
	char *xp = (char *) *xpp;
#line 2773
	int status = ENOERR;
#line 2773

#line 2773
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2773
	{
#line 2773
		int lstatus = ncx_put_short_double(xp, tp);
#line 2773
		if(lstatus != ENOERR)
#line 2773
			status = lstatus;
#line 2773
	}
#line 2773

#line 2773
	*xpp = (void *)xp;
#line 2773
	return status;
#line 2773
#endif
#line 2773
}
#line 2773

int
#line 2774
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp)
#line 2774
{
#line 2774
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2774

#line 2774
 /* basic algorithm is:
#line 2774
  *   - ensure sane alignment of output data
#line 2774
  *   - copy (conversion happens automatically) input data
#line 2774
  *     to output
#line 2774
  *   - update tp to point at next unconverted input, and xpp to point
#line 2774
  *     at next location for converted output
#line 2774
  */
#line 2774
  long i, j, ni;
#line 2774
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2774
  short *xp;
#line 2774
  int nrange = 0;         /* number of range errors */
#line 2774
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2774
  long cxp = (long) *((char**)xpp);
#line 2774

#line 2774
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2774
  /* sjl: manually stripmine so we can limit amount of
#line 2774
   * vector work space reserved to LOOPCNT elements. Also
#line 2774
   * makes vectorisation easy */
#line 2774
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2774
    ni=Min(nelems-j,LOOPCNT);
#line 2774
    if (realign) {
#line 2774
      xp = tmp;
#line 2774
    } else {
#line 2774
      xp = (short *) *xpp;
#line 2774
    }
#line 2774
   /* copy the next block */
#line 2774
#pragma cdir loopcnt=LOOPCNT
#line 2774
#pragma cdir shortloop
#line 2774
    for (i=0; i<ni; i++) {
#line 2774
      /* the normal case: */
#line 2774
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2774
     /* test for range errors (not always needed but do it anyway) */
#line 2774
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2774
    }
#line 2774
   /* copy workspace back if necessary */ 
#line 2774
    if (realign) {
#line 2774
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2774
      xp = (short *) *xpp;
#line 2774
    }
#line 2774
   /* update xpp and tp */
#line 2774
    xp += ni;
#line 2774
    tp += ni;
#line 2774
    *xpp = (void*)xp;
#line 2774
  }
#line 2774
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2774

#line 2774
#else   /* not SX */
#line 2774

#line 2774
	char *xp = (char *) *xpp;
#line 2774
	int status = ENOERR;
#line 2774

#line 2774
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2774
	{
#line 2774
		int lstatus = ncx_put_short_uint(xp, tp);
#line 2774
		if(lstatus != ENOERR)
#line 2774
			status = lstatus;
#line 2774
	}
#line 2774

#line 2774
	*xpp = (void *)xp;
#line 2774
	return status;
#line 2774
#endif
#line 2774
}
#line 2774

int
#line 2775
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2775
{
#line 2775
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2775

#line 2775
 /* basic algorithm is:
#line 2775
  *   - ensure sane alignment of output data
#line 2775
  *   - copy (conversion happens automatically) input data
#line 2775
  *     to output
#line 2775
  *   - update tp to point at next unconverted input, and xpp to point
#line 2775
  *     at next location for converted output
#line 2775
  */
#line 2775
  long i, j, ni;
#line 2775
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2775
  short *xp;
#line 2775
  int nrange = 0;         /* number of range errors */
#line 2775
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2775
  long cxp = (long) *((char**)xpp);
#line 2775

#line 2775
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2775
  /* sjl: manually stripmine so we can limit amount of
#line 2775
   * vector work space reserved to LOOPCNT elements. Also
#line 2775
   * makes vectorisation easy */
#line 2775
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2775
    ni=Min(nelems-j,LOOPCNT);
#line 2775
    if (realign) {
#line 2775
      xp = tmp;
#line 2775
    } else {
#line 2775
      xp = (short *) *xpp;
#line 2775
    }
#line 2775
   /* copy the next block */
#line 2775
#pragma cdir loopcnt=LOOPCNT
#line 2775
#pragma cdir shortloop
#line 2775
    for (i=0; i<ni; i++) {
#line 2775
      /* the normal case: */
#line 2775
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2775
     /* test for range errors (not always needed but do it anyway) */
#line 2775
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2775
    }
#line 2775
   /* copy workspace back if necessary */ 
#line 2775
    if (realign) {
#line 2775
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2775
      xp = (short *) *xpp;
#line 2775
    }
#line 2775
   /* update xpp and tp */
#line 2775
    xp += ni;
#line 2775
    tp += ni;
#line 2775
    *xpp = (void*)xp;
#line 2775
  }
#line 2775
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2775

#line 2775
#else   /* not SX */
#line 2775

#line 2775
	char *xp = (char *) *xpp;
#line 2775
	int status = ENOERR;
#line 2775

#line 2775
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2775
	{
#line 2775
		int lstatus = ncx_put_short_longlong(xp, tp);
#line 2775
		if(lstatus != ENOERR)
#line 2775
			status = lstatus;
#line 2775
	}
#line 2775

#line 2775
	*xpp = (void *)xp;
#line 2775
	return status;
#line 2775
#endif
#line 2775
}
#line 2775

int
#line 2776
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2776
{
#line 2776
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2776

#line 2776
 /* basic algorithm is:
#line 2776
  *   - ensure sane alignment of output data
#line 2776
  *   - copy (conversion happens automatically) input data
#line 2776
  *     to output
#line 2776
  *   - update tp to point at next unconverted input, and xpp to point
#line 2776
  *     at next location for converted output
#line 2776
  */
#line 2776
  long i, j, ni;
#line 2776
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2776
  short *xp;
#line 2776
  int nrange = 0;         /* number of range errors */
#line 2776
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2776
  long cxp = (long) *((char**)xpp);
#line 2776

#line 2776
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2776
  /* sjl: manually stripmine so we can limit amount of
#line 2776
   * vector work space reserved to LOOPCNT elements. Also
#line 2776
   * makes vectorisation easy */
#line 2776
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2776
    ni=Min(nelems-j,LOOPCNT);
#line 2776
    if (realign) {
#line 2776
      xp = tmp;
#line 2776
    } else {
#line 2776
      xp = (short *) *xpp;
#line 2776
    }
#line 2776
   /* copy the next block */
#line 2776
#pragma cdir loopcnt=LOOPCNT
#line 2776
#pragma cdir shortloop
#line 2776
    for (i=0; i<ni; i++) {
#line 2776
      /* the normal case: */
#line 2776
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2776
     /* test for range errors (not always needed but do it anyway) */
#line 2776
      nrange += tp[i] < X_SHORT_MIN || tp[i] > X_SHORT_MAX;
#line 2776
    }
#line 2776
   /* copy workspace back if necessary */ 
#line 2776
    if (realign) {
#line 2776
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2776
      xp = (short *) *xpp;
#line 2776
    }
#line 2776
   /* update xpp and tp */
#line 2776
    xp += ni;
#line 2776
    tp += ni;
#line 2776
    *xpp = (void*)xp;
#line 2776
  }
#line 2776
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2776

#line 2776
#else   /* not SX */
#line 2776

#line 2776
	char *xp = (char *) *xpp;
#line 2776
	int status = ENOERR;
#line 2776

#line 2776
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2776
	{
#line 2776
		int lstatus = ncx_put_short_ulonglong(xp, tp);
#line 2776
		if(lstatus != ENOERR)
#line 2776
			status = lstatus;
#line 2776
	}
#line 2776

#line 2776
	*xpp = (void *)xp;
#line 2776
	return status;
#line 2776
#endif
#line 2776
}
#line 2776


int
#line 2778
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp)
#line 2778
{
#line 2778
	const size_t rndup = nelems % 2;
#line 2778

#line 2778
	char *xp = (char *) *xpp;
#line 2778
	int status = ENOERR;
#line 2778

#line 2778
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2778
	{
#line 2778
		int lstatus = ncx_put_short_schar(xp, tp);
#line 2778
		if(lstatus != ENOERR)
#line 2778
			status = lstatus;
#line 2778
	}
#line 2778

#line 2778
	if(rndup != 0)
#line 2778
	{
#line 2778
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2778
		xp += X_SIZEOF_SHORT;	
#line 2778
	}
#line 2778
		
#line 2778
	*xpp = (void *)xp;
#line 2778
	return status;
#line 2778
}
#line 2778

int
#line 2779
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2779
{
#line 2779
	const size_t rndup = nelems % 2;
#line 2779

#line 2779
	char *xp = (char *) *xpp;
#line 2779
	int status = ENOERR;
#line 2779

#line 2779
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2779
	{
#line 2779
		int lstatus = ncx_put_short_uchar(xp, tp);
#line 2779
		if(lstatus != ENOERR)
#line 2779
			status = lstatus;
#line 2779
	}
#line 2779

#line 2779
	if(rndup != 0)
#line 2779
	{
#line 2779
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2779
		xp += X_SIZEOF_SHORT;	
#line 2779
	}
#line 2779
		
#line 2779
	*xpp = (void *)xp;
#line 2779
	return status;
#line 2779
}
#line 2779

int
#line 2780
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp)
#line 2780
{
#line 2780
	const size_t rndup = nelems % 2;
#line 2780

#line 2780
	char *xp = (char *) *xpp;
#line 2780
	int status = ENOERR;
#line 2780

#line 2780
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2780
	{
#line 2780
		int lstatus = ncx_put_short_short(xp, tp);
#line 2780
		if(lstatus != ENOERR)
#line 2780
			status = lstatus;
#line 2780
	}
#line 2780

#line 2780
	if(rndup != 0)
#line 2780
	{
#line 2780
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2780
		xp += X_SIZEOF_SHORT;	
#line 2780
	}
#line 2780
		
#line 2780
	*xpp = (void *)xp;
#line 2780
	return status;
#line 2780
}
#line 2780

int
#line 2781
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp)
#line 2781
{
#line 2781
	const size_t rndup = nelems % 2;
#line 2781

#line 2781
	char *xp = (char *) *xpp;
#line 2781
	int status = ENOERR;
#line 2781

#line 2781
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2781
	{
#line 2781
		int lstatus = ncx_put_short_int(xp, tp);
#line 2781
		if(lstatus != ENOERR)
#line 2781
			status = lstatus;
#line 2781
	}
#line 2781

#line 2781
	if(rndup != 0)
#line 2781
	{
#line 2781
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2781
		xp += X_SIZEOF_SHORT;	
#line 2781
	}
#line 2781
		
#line 2781
	*xpp = (void *)xp;
#line 2781
	return status;
#line 2781
}
#line 2781

int
#line 2782
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp)
#line 2782
{
#line 2782
	const size_t rndup = nelems % 2;
#line 2782

#line 2782
	char *xp = (char *) *xpp;
#line 2782
	int status = ENOERR;
#line 2782

#line 2782
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2782
	{
#line 2782
		int lstatus = ncx_put_short_float(xp, tp);
#line 2782
		if(lstatus != ENOERR)
#line 2782
			status = lstatus;
#line 2782
	}
#line 2782

#line 2782
	if(rndup != 0)
#line 2782
	{
#line 2782
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2782
		xp += X_SIZEOF_SHORT;	
#line 2782
	}
#line 2782
		
#line 2782
	*xpp = (void *)xp;
#line 2782
	return status;
#line 2782
}
#line 2782

int
#line 2783
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp)
#line 2783
{
#line 2783
	const size_t rndup = nelems % 2;
#line 2783

#line 2783
	char *xp = (char *) *xpp;
#line 2783
	int status = ENOERR;
#line 2783

#line 2783
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2783
	{
#line 2783
		int lstatus = ncx_put_short_double(xp, tp);
#line 2783
		if(lstatus != ENOERR)
#line 2783
			status = lstatus;
#line 2783
	}
#line 2783

#line 2783
	if(rndup != 0)
#line 2783
	{
#line 2783
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2783
		xp += X_SIZEOF_SHORT;	
#line 2783
	}
#line 2783
		
#line 2783
	*xpp = (void *)xp;
#line 2783
	return status;
#line 2783
}
#line 2783

int
#line 2784
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp)
#line 2784
{
#line 2784
	const size_t rndup = nelems % 2;
#line 2784

#line 2784
	char *xp = (char *) *xpp;
#line 2784
	int status = ENOERR;
#line 2784

#line 2784
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2784
	{
#line 2784
		int lstatus = ncx_put_short_uint(xp, tp);
#line 2784
		if(lstatus != ENOERR)
#line 2784
			status = lstatus;
#line 2784
	}
#line 2784

#line 2784
	if(rndup != 0)
#line 2784
	{
#line 2784
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2784
		xp += X_SIZEOF_SHORT;	
#line 2784
	}
#line 2784
		
#line 2784
	*xpp = (void *)xp;
#line 2784
	return status;
#line 2784
}
#line 2784

int
#line 2785
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2785
{
#line 2785
	const size_t rndup = nelems % 2;
#line 2785

#line 2785
	char *xp = (char *) *xpp;
#line 2785
	int status = ENOERR;
#line 2785

#line 2785
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2785
	{
#line 2785
		int lstatus = ncx_put_short_longlong(xp, tp);
#line 2785
		if(lstatus != ENOERR)
#line 2785
			status = lstatus;
#line 2785
	}
#line 2785

#line 2785
	if(rndup != 0)
#line 2785
	{
#line 2785
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2785
		xp += X_SIZEOF_SHORT;	
#line 2785
	}
#line 2785
		
#line 2785
	*xpp = (void *)xp;
#line 2785
	return status;
#line 2785
}
#line 2785

int
#line 2786
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2786
{
#line 2786
	const size_t rndup = nelems % 2;
#line 2786

#line 2786
	char *xp = (char *) *xpp;
#line 2786
	int status = ENOERR;
#line 2786

#line 2786
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2786
	{
#line 2786
		int lstatus = ncx_put_short_ulonglong(xp, tp);
#line 2786
		if(lstatus != ENOERR)
#line 2786
			status = lstatus;
#line 2786
	}
#line 2786

#line 2786
	if(rndup != 0)
#line 2786
	{
#line 2786
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2786
		xp += X_SIZEOF_SHORT;	
#line 2786
	}
#line 2786
		
#line 2786
	*xpp = (void *)xp;
#line 2786
	return status;
#line 2786
}
#line 2786



/* int */

int
#line 2791
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
#line 2791
{
#line 2791
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2791

#line 2791
 /* basic algorithm is:
#line 2791
  *   - ensure sane alignment of input data
#line 2791
  *   - copy (conversion happens automatically) input data
#line 2791
  *     to output
#line 2791
  *   - update xpp to point at next unconverted input, and tp to point
#line 2791
  *     at next location for converted output
#line 2791
  */
#line 2791
  long i, j, ni;
#line 2791
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2791
  int *xp;
#line 2791
  int nrange = 0;         /* number of range errors */
#line 2791
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2791
  long cxp = (long) *((char**)xpp);
#line 2791

#line 2791
  realign = (cxp & 7) % SIZEOF_INT;
#line 2791
  /* sjl: manually stripmine so we can limit amount of
#line 2791
   * vector work space reserved to LOOPCNT elements. Also
#line 2791
   * makes vectorisation easy */
#line 2791
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2791
    ni=Min(nelems-j,LOOPCNT);
#line 2791
    if (realign) {
#line 2791
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2791
      xp = tmp;
#line 2791
    } else {
#line 2791
      xp = (int *) *xpp;
#line 2791
    }
#line 2791
   /* copy the next block */
#line 2791
#pragma cdir loopcnt=LOOPCNT
#line 2791
#pragma cdir shortloop
#line 2791
    for (i=0; i<ni; i++) {
#line 2791
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2791
     /* test for range errors (not always needed but do it anyway) */
#line 2791
      nrange += xp[i] < SCHAR_MIN || xp[i] > SCHAR_MAX;
#line 2791
    }
#line 2791
   /* update xpp and tp */
#line 2791
    if (realign) xp = (int *) *xpp;
#line 2791
    xp += ni;
#line 2791
    tp += ni;
#line 2791
    *xpp = (void*)xp;
#line 2791
  }
#line 2791
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2791

#line 2791
#else   /* not SX */
#line 2791
	const char *xp = (const char *) *xpp;
#line 2791
	int status = ENOERR;
#line 2791

#line 2791
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2791
	{
#line 2791
		const int lstatus = ncx_get_int_schar(xp, tp);
#line 2791
		if(lstatus != ENOERR)
#line 2791
			status = lstatus;
#line 2791
	}
#line 2791

#line 2791
	*xpp = (const void *)xp;
#line 2791
	return status;
#line 2791
#  endif
#line 2791
}
#line 2791

int
#line 2792
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2792
{
#line 2792
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2792

#line 2792
 /* basic algorithm is:
#line 2792
  *   - ensure sane alignment of input data
#line 2792
  *   - copy (conversion happens automatically) input data
#line 2792
  *     to output
#line 2792
  *   - update xpp to point at next unconverted input, and tp to point
#line 2792
  *     at next location for converted output
#line 2792
  */
#line 2792
  long i, j, ni;
#line 2792
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2792
  int *xp;
#line 2792
  int nrange = 0;         /* number of range errors */
#line 2792
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2792
  long cxp = (long) *((char**)xpp);
#line 2792

#line 2792
  realign = (cxp & 7) % SIZEOF_INT;
#line 2792
  /* sjl: manually stripmine so we can limit amount of
#line 2792
   * vector work space reserved to LOOPCNT elements. Also
#line 2792
   * makes vectorisation easy */
#line 2792
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2792
    ni=Min(nelems-j,LOOPCNT);
#line 2792
    if (realign) {
#line 2792
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2792
      xp = tmp;
#line 2792
    } else {
#line 2792
      xp = (int *) *xpp;
#line 2792
    }
#line 2792
   /* copy the next block */
#line 2792
#pragma cdir loopcnt=LOOPCNT
#line 2792
#pragma cdir shortloop
#line 2792
    for (i=0; i<ni; i++) {
#line 2792
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2792
     /* test for range errors (not always needed but do it anyway) */
#line 2792
      nrange += xp[i] < UCHAR_MIN || xp[i] > UCHAR_MAX;
#line 2792
    }
#line 2792
   /* update xpp and tp */
#line 2792
    if (realign) xp = (int *) *xpp;
#line 2792
    xp += ni;
#line 2792
    tp += ni;
#line 2792
    *xpp = (void*)xp;
#line 2792
  }
#line 2792
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2792

#line 2792
#else   /* not SX */
#line 2792
	const char *xp = (const char *) *xpp;
#line 2792
	int status = ENOERR;
#line 2792

#line 2792
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2792
	{
#line 2792
		const int lstatus = ncx_get_int_uchar(xp, tp);
#line 2792
		if(lstatus != ENOERR)
#line 2792
			status = lstatus;
#line 2792
	}
#line 2792

#line 2792
	*xpp = (const void *)xp;
#line 2792
	return status;
#line 2792
#  endif
#line 2792
}
#line 2792

int
#line 2793
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
#line 2793
{
#line 2793
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2793

#line 2793
 /* basic algorithm is:
#line 2793
  *   - ensure sane alignment of input data
#line 2793
  *   - copy (conversion happens automatically) input data
#line 2793
  *     to output
#line 2793
  *   - update xpp to point at next unconverted input, and tp to point
#line 2793
  *     at next location for converted output
#line 2793
  */
#line 2793
  long i, j, ni;
#line 2793
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2793
  int *xp;
#line 2793
  int nrange = 0;         /* number of range errors */
#line 2793
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2793
  long cxp = (long) *((char**)xpp);
#line 2793

#line 2793
  realign = (cxp & 7) % SIZEOF_INT;
#line 2793
  /* sjl: manually stripmine so we can limit amount of
#line 2793
   * vector work space reserved to LOOPCNT elements. Also
#line 2793
   * makes vectorisation easy */
#line 2793
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2793
    ni=Min(nelems-j,LOOPCNT);
#line 2793
    if (realign) {
#line 2793
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2793
      xp = tmp;
#line 2793
    } else {
#line 2793
      xp = (int *) *xpp;
#line 2793
    }
#line 2793
   /* copy the next block */
#line 2793
#pragma cdir loopcnt=LOOPCNT
#line 2793
#pragma cdir shortloop
#line 2793
    for (i=0; i<ni; i++) {
#line 2793
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2793
     /* test for range errors (not always needed but do it anyway) */
#line 2793
      nrange += xp[i] < SHORT_MIN || xp[i] > SHORT_MAX;
#line 2793
    }
#line 2793
   /* update xpp and tp */
#line 2793
    if (realign) xp = (int *) *xpp;
#line 2793
    xp += ni;
#line 2793
    tp += ni;
#line 2793
    *xpp = (void*)xp;
#line 2793
  }
#line 2793
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2793

#line 2793
#else   /* not SX */
#line 2793
	const char *xp = (const char *) *xpp;
#line 2793
	int status = ENOERR;
#line 2793

#line 2793
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2793
	{
#line 2793
		const int lstatus = ncx_get_int_short(xp, tp);
#line 2793
		if(lstatus != ENOERR)
#line 2793
			status = lstatus;
#line 2793
	}
#line 2793

#line 2793
	*xpp = (const void *)xp;
#line 2793
	return status;
#line 2793
#  endif
#line 2793
}
#line 2793

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(int));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return ENOERR;
}
int
ncx_getn_int_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(int));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return ENOERR;
}
#else
int
#line 2819
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
#line 2819
{
#line 2819
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2819

#line 2819
 /* basic algorithm is:
#line 2819
  *   - ensure sane alignment of input data
#line 2819
  *   - copy (conversion happens automatically) input data
#line 2819
  *     to output
#line 2819
  *   - update xpp to point at next unconverted input, and tp to point
#line 2819
  *     at next location for converted output
#line 2819
  */
#line 2819
  long i, j, ni;
#line 2819
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2819
  int *xp;
#line 2819
  int nrange = 0;         /* number of range errors */
#line 2819
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2819
  long cxp = (long) *((char**)xpp);
#line 2819

#line 2819
  realign = (cxp & 7) % SIZEOF_INT;
#line 2819
  /* sjl: manually stripmine so we can limit amount of
#line 2819
   * vector work space reserved to LOOPCNT elements. Also
#line 2819
   * makes vectorisation easy */
#line 2819
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2819
    ni=Min(nelems-j,LOOPCNT);
#line 2819
    if (realign) {
#line 2819
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2819
      xp = tmp;
#line 2819
    } else {
#line 2819
      xp = (int *) *xpp;
#line 2819
    }
#line 2819
   /* copy the next block */
#line 2819
#pragma cdir loopcnt=LOOPCNT
#line 2819
#pragma cdir shortloop
#line 2819
    for (i=0; i<ni; i++) {
#line 2819
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2819
     /* test for range errors (not always needed but do it anyway) */
#line 2819
      nrange += xp[i] < INT_MIN || xp[i] > INT_MAX;
#line 2819
    }
#line 2819
   /* update xpp and tp */
#line 2819
    if (realign) xp = (int *) *xpp;
#line 2819
    xp += ni;
#line 2819
    tp += ni;
#line 2819
    *xpp = (void*)xp;
#line 2819
  }
#line 2819
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2819

#line 2819
#else   /* not SX */
#line 2819
	const char *xp = (const char *) *xpp;
#line 2819
	int status = ENOERR;
#line 2819

#line 2819
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2819
	{
#line 2819
		const int lstatus = ncx_get_int_int(xp, tp);
#line 2819
		if(lstatus != ENOERR)
#line 2819
			status = lstatus;
#line 2819
	}
#line 2819

#line 2819
	*xpp = (const void *)xp;
#line 2819
	return status;
#line 2819
#  endif
#line 2819
}
#line 2819

int
#line 2820
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
#line 2820
{
#line 2820
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2820

#line 2820
 /* basic algorithm is:
#line 2820
  *   - ensure sane alignment of input data
#line 2820
  *   - copy (conversion happens automatically) input data
#line 2820
  *     to output
#line 2820
  *   - update xpp to point at next unconverted input, and tp to point
#line 2820
  *     at next location for converted output
#line 2820
  */
#line 2820
  long i, j, ni;
#line 2820
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2820
  int *xp;
#line 2820
  int nrange = 0;         /* number of range errors */
#line 2820
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2820
  long cxp = (long) *((char**)xpp);
#line 2820

#line 2820
  realign = (cxp & 7) % SIZEOF_INT;
#line 2820
  /* sjl: manually stripmine so we can limit amount of
#line 2820
   * vector work space reserved to LOOPCNT elements. Also
#line 2820
   * makes vectorisation easy */
#line 2820
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2820
    ni=Min(nelems-j,LOOPCNT);
#line 2820
    if (realign) {
#line 2820
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2820
      xp = tmp;
#line 2820
    } else {
#line 2820
      xp = (int *) *xpp;
#line 2820
    }
#line 2820
   /* copy the next block */
#line 2820
#pragma cdir loopcnt=LOOPCNT
#line 2820
#pragma cdir shortloop
#line 2820
    for (i=0; i<ni; i++) {
#line 2820
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2820
     /* test for range errors (not always needed but do it anyway) */
#line 2820
      nrange += xp[i] < UINT_MIN || xp[i] > UINT_MAX;
#line 2820
    }
#line 2820
   /* update xpp and tp */
#line 2820
    if (realign) xp = (int *) *xpp;
#line 2820
    xp += ni;
#line 2820
    tp += ni;
#line 2820
    *xpp = (void*)xp;
#line 2820
  }
#line 2820
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2820

#line 2820
#else   /* not SX */
#line 2820
	const char *xp = (const char *) *xpp;
#line 2820
	int status = ENOERR;
#line 2820

#line 2820
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2820
	{
#line 2820
		const int lstatus = ncx_get_int_uint(xp, tp);
#line 2820
		if(lstatus != ENOERR)
#line 2820
			status = lstatus;
#line 2820
	}
#line 2820

#line 2820
	*xpp = (const void *)xp;
#line 2820
	return status;
#line 2820
#  endif
#line 2820
}
#line 2820

#endif

int
#line 2823
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2823
{
#line 2823
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2823

#line 2823
 /* basic algorithm is:
#line 2823
  *   - ensure sane alignment of input data
#line 2823
  *   - copy (conversion happens automatically) input data
#line 2823
  *     to output
#line 2823
  *   - update xpp to point at next unconverted input, and tp to point
#line 2823
  *     at next location for converted output
#line 2823
  */
#line 2823
  long i, j, ni;
#line 2823
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2823
  int *xp;
#line 2823
  int nrange = 0;         /* number of range errors */
#line 2823
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2823
  long cxp = (long) *((char**)xpp);
#line 2823

#line 2823
  realign = (cxp & 7) % SIZEOF_INT;
#line 2823
  /* sjl: manually stripmine so we can limit amount of
#line 2823
   * vector work space reserved to LOOPCNT elements. Also
#line 2823
   * makes vectorisation easy */
#line 2823
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2823
    ni=Min(nelems-j,LOOPCNT);
#line 2823
    if (realign) {
#line 2823
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2823
      xp = tmp;
#line 2823
    } else {
#line 2823
      xp = (int *) *xpp;
#line 2823
    }
#line 2823
   /* copy the next block */
#line 2823
#pragma cdir loopcnt=LOOPCNT
#line 2823
#pragma cdir shortloop
#line 2823
    for (i=0; i<ni; i++) {
#line 2823
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2823
     /* test for range errors (not always needed but do it anyway) */
#line 2823
      nrange += xp[i] < LONGLONG_MIN || xp[i] > LONGLONG_MAX;
#line 2823
    }
#line 2823
   /* update xpp and tp */
#line 2823
    if (realign) xp = (int *) *xpp;
#line 2823
    xp += ni;
#line 2823
    tp += ni;
#line 2823
    *xpp = (void*)xp;
#line 2823
  }
#line 2823
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2823

#line 2823
#else   /* not SX */
#line 2823
	const char *xp = (const char *) *xpp;
#line 2823
	int status = ENOERR;
#line 2823

#line 2823
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2823
	{
#line 2823
		const int lstatus = ncx_get_int_longlong(xp, tp);
#line 2823
		if(lstatus != ENOERR)
#line 2823
			status = lstatus;
#line 2823
	}
#line 2823

#line 2823
	*xpp = (const void *)xp;
#line 2823
	return status;
#line 2823
#  endif
#line 2823
}
#line 2823

int
#line 2824
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2824
{
#line 2824
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2824

#line 2824
 /* basic algorithm is:
#line 2824
  *   - ensure sane alignment of input data
#line 2824
  *   - copy (conversion happens automatically) input data
#line 2824
  *     to output
#line 2824
  *   - update xpp to point at next unconverted input, and tp to point
#line 2824
  *     at next location for converted output
#line 2824
  */
#line 2824
  long i, j, ni;
#line 2824
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2824
  int *xp;
#line 2824
  int nrange = 0;         /* number of range errors */
#line 2824
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2824
  long cxp = (long) *((char**)xpp);
#line 2824

#line 2824
  realign = (cxp & 7) % SIZEOF_INT;
#line 2824
  /* sjl: manually stripmine so we can limit amount of
#line 2824
   * vector work space reserved to LOOPCNT elements. Also
#line 2824
   * makes vectorisation easy */
#line 2824
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2824
    ni=Min(nelems-j,LOOPCNT);
#line 2824
    if (realign) {
#line 2824
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2824
      xp = tmp;
#line 2824
    } else {
#line 2824
      xp = (int *) *xpp;
#line 2824
    }
#line 2824
   /* copy the next block */
#line 2824
#pragma cdir loopcnt=LOOPCNT
#line 2824
#pragma cdir shortloop
#line 2824
    for (i=0; i<ni; i++) {
#line 2824
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2824
     /* test for range errors (not always needed but do it anyway) */
#line 2824
      nrange += xp[i] < ULONGLONG_MIN || xp[i] > ULONGLONG_MAX;
#line 2824
    }
#line 2824
   /* update xpp and tp */
#line 2824
    if (realign) xp = (int *) *xpp;
#line 2824
    xp += ni;
#line 2824
    tp += ni;
#line 2824
    *xpp = (void*)xp;
#line 2824
  }
#line 2824
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2824

#line 2824
#else   /* not SX */
#line 2824
	const char *xp = (const char *) *xpp;
#line 2824
	int status = ENOERR;
#line 2824

#line 2824
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2824
	{
#line 2824
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
#line 2824
		if(lstatus != ENOERR)
#line 2824
			status = lstatus;
#line 2824
	}
#line 2824

#line 2824
	*xpp = (const void *)xp;
#line 2824
	return status;
#line 2824
#  endif
#line 2824
}
#line 2824


int
#line 2826
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
#line 2826
{
#line 2826
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2826

#line 2826
 /* basic algorithm is:
#line 2826
  *   - ensure sane alignment of input data
#line 2826
  *   - copy (conversion happens automatically) input data
#line 2826
  *     to output
#line 2826
  *   - update xpp to point at next unconverted input, and tp to point
#line 2826
  *     at next location for converted output
#line 2826
  */
#line 2826
  long i, j, ni;
#line 2826
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2826
  int *xp;
#line 2826
  int nrange = 0;         /* number of range errors */
#line 2826
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2826
  long cxp = (long) *((char**)xpp);
#line 2826

#line 2826
  realign = (cxp & 7) % SIZEOF_INT;
#line 2826
  /* sjl: manually stripmine so we can limit amount of
#line 2826
   * vector work space reserved to LOOPCNT elements. Also
#line 2826
   * makes vectorisation easy */
#line 2826
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2826
    ni=Min(nelems-j,LOOPCNT);
#line 2826
    if (realign) {
#line 2826
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2826
      xp = tmp;
#line 2826
    } else {
#line 2826
      xp = (int *) *xpp;
#line 2826
    }
#line 2826
   /* copy the next block */
#line 2826
#pragma cdir loopcnt=LOOPCNT
#line 2826
#pragma cdir shortloop
#line 2826
    for (i=0; i<ni; i++) {
#line 2826
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2826
     /* test for range errors (not always needed but do it anyway) */
#line 2826
      nrange += xp[i] < FLOAT_MIN || xp[i] > FLOAT_MAX;
#line 2826
    }
#line 2826
   /* update xpp and tp */
#line 2826
    if (realign) xp = (int *) *xpp;
#line 2826
    xp += ni;
#line 2826
    tp += ni;
#line 2826
    *xpp = (void*)xp;
#line 2826
  }
#line 2826
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2826

#line 2826
#else   /* not SX */
#line 2826
	const char *xp = (const char *) *xpp;
#line 2826
	int status = ENOERR;
#line 2826

#line 2826
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2826
	{
#line 2826
		const int lstatus = ncx_get_int_float(xp, tp);
#line 2826
		if(lstatus != ENOERR)
#line 2826
			status = lstatus;
#line 2826
	}
#line 2826

#line 2826
	*xpp = (const void *)xp;
#line 2826
	return status;
#line 2826
#  endif
#line 2826
}
#line 2826

int
#line 2827
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
#line 2827
{
#line 2827
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2827

#line 2827
 /* basic algorithm is:
#line 2827
  *   - ensure sane alignment of input data
#line 2827
  *   - copy (conversion happens automatically) input data
#line 2827
  *     to output
#line 2827
  *   - update xpp to point at next unconverted input, and tp to point
#line 2827
  *     at next location for converted output
#line 2827
  */
#line 2827
  long i, j, ni;
#line 2827
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2827
  int *xp;
#line 2827
  int nrange = 0;         /* number of range errors */
#line 2827
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2827
  long cxp = (long) *((char**)xpp);
#line 2827

#line 2827
  realign = (cxp & 7) % SIZEOF_INT;
#line 2827
  /* sjl: manually stripmine so we can limit amount of
#line 2827
   * vector work space reserved to LOOPCNT elements. Also
#line 2827
   * makes vectorisation easy */
#line 2827
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2827
    ni=Min(nelems-j,LOOPCNT);
#line 2827
    if (realign) {
#line 2827
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2827
      xp = tmp;
#line 2827
    } else {
#line 2827
      xp = (int *) *xpp;
#line 2827
    }
#line 2827
   /* copy the next block */
#line 2827
#pragma cdir loopcnt=LOOPCNT
#line 2827
#pragma cdir shortloop
#line 2827
    for (i=0; i<ni; i++) {
#line 2827
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2827
     /* test for range errors (not always needed but do it anyway) */
#line 2827
      nrange += xp[i] < DOUBLE_MIN || xp[i] > DOUBLE_MAX;
#line 2827
    }
#line 2827
   /* update xpp and tp */
#line 2827
    if (realign) xp = (int *) *xpp;
#line 2827
    xp += ni;
#line 2827
    tp += ni;
#line 2827
    *xpp = (void*)xp;
#line 2827
  }
#line 2827
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2827

#line 2827
#else   /* not SX */
#line 2827
	const char *xp = (const char *) *xpp;
#line 2827
	int status = ENOERR;
#line 2827

#line 2827
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2827
	{
#line 2827
		const int lstatus = ncx_get_int_double(xp, tp);
#line 2827
		if(lstatus != ENOERR)
#line 2827
			status = lstatus;
#line 2827
	}
#line 2827

#line 2827
	*xpp = (const void *)xp;
#line 2827
	return status;
#line 2827
#  endif
#line 2827
}
#line 2827


int
#line 2829
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp)
#line 2829
{
#line 2829
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2829

#line 2829
 /* basic algorithm is:
#line 2829
  *   - ensure sane alignment of output data
#line 2829
  *   - copy (conversion happens automatically) input data
#line 2829
  *     to output
#line 2829
  *   - update tp to point at next unconverted input, and xpp to point
#line 2829
  *     at next location for converted output
#line 2829
  */
#line 2829
  long i, j, ni;
#line 2829
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2829
  int *xp;
#line 2829
  int nrange = 0;         /* number of range errors */
#line 2829
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2829
  long cxp = (long) *((char**)xpp);
#line 2829

#line 2829
  realign = (cxp & 7) % SIZEOF_INT;
#line 2829
  /* sjl: manually stripmine so we can limit amount of
#line 2829
   * vector work space reserved to LOOPCNT elements. Also
#line 2829
   * makes vectorisation easy */
#line 2829
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2829
    ni=Min(nelems-j,LOOPCNT);
#line 2829
    if (realign) {
#line 2829
      xp = tmp;
#line 2829
    } else {
#line 2829
      xp = (int *) *xpp;
#line 2829
    }
#line 2829
   /* copy the next block */
#line 2829
#pragma cdir loopcnt=LOOPCNT
#line 2829
#pragma cdir shortloop
#line 2829
    for (i=0; i<ni; i++) {
#line 2829
      /* the normal case: */
#line 2829
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2829
     /* test for range errors (not always needed but do it anyway) */
#line 2829
      nrange += tp[i] < X_INT_MIN || tp[i] > X_INT_MAX;
#line 2829
    }
#line 2829
   /* copy workspace back if necessary */ 
#line 2829
    if (realign) {
#line 2829
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2829
      xp = (int *) *xpp;
#line 2829
    }
#line 2829
   /* update xpp and tp */
#line 2829
    xp += ni;
#line 2829
    tp += ni;
#line 2829
    *xpp = (void*)xp;
#line 2829
  }
#line 2829
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2829

#line 2829
#else   /* not SX */
#line 2829

#line 2829
	char *xp = (char *) *xpp;
#line 2829
	int status = ENOERR;
#line 2829

#line 2829
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2829
	{
#line 2829
		int lstatus = ncx_put_int_schar(xp, tp);
#line 2829
		if(lstatus != ENOERR)
#line 2829
			status = lstatus;
#line 2829
	}
#line 2829

#line 2829
	*xpp = (void *)xp;
#line 2829
	return status;
#line 2829
#endif
#line 2829
}
#line 2829

int
#line 2830
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2830
{
#line 2830
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2830

#line 2830
 /* basic algorithm is:
#line 2830
  *   - ensure sane alignment of output data
#line 2830
  *   - copy (conversion happens automatically) input data
#line 2830
  *     to output
#line 2830
  *   - update tp to point at next unconverted input, and xpp to point
#line 2830
  *     at next location for converted output
#line 2830
  */
#line 2830
  long i, j, ni;
#line 2830
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2830
  int *xp;
#line 2830
  int nrange = 0;         /* number of range errors */
#line 2830
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2830
  long cxp = (long) *((char**)xpp);
#line 2830

#line 2830
  realign = (cxp & 7) % SIZEOF_INT;
#line 2830
  /* sjl: manually stripmine so we can limit amount of
#line 2830
   * vector work space reserved to LOOPCNT elements. Also
#line 2830
   * makes vectorisation easy */
#line 2830
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2830
    ni=Min(nelems-j,LOOPCNT);
#line 2830
    if (realign) {
#line 2830
      xp = tmp;
#line 2830
    } else {
#line 2830
      xp = (int *) *xpp;
#line 2830
    }
#line 2830
   /* copy the next block */
#line 2830
#pragma cdir loopcnt=LOOPCNT
#line 2830
#pragma cdir shortloop
#line 2830
    for (i=0; i<ni; i++) {
#line 2830
      /* the normal case: */
#line 2830
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2830
     /* test for range errors (not always needed but do it anyway) */
#line 2830
      nrange += tp[i] < X_INT_MIN || tp[i] > X_INT_MAX;
#line 2830
    }
#line 2830
   /* copy workspace back if necessary */ 
#line 2830
    if (realign) {
#line 2830
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2830
      xp = (int *) *xpp;
#line 2830
    }
#line 2830
   /* update xpp and tp */
#line 2830
    xp += ni;
#line 2830
    tp += ni;
#line 2830
    *xpp = (void*)xp;
#line 2830
  }
#line 2830
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2830

#line 2830
#else   /* not SX */
#line 2830

#line 2830
	char *xp = (char *) *xpp;
#line 2830
	int status = ENOERR;
#line 2830

#line 2830
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2830
	{
#line 2830
		int lstatus = ncx_put_int_uchar(xp, tp);
#line 2830
		if(lstatus != ENOERR)
#line 2830
			status = lstatus;
#line 2830
	}
#line 2830

#line 2830
	*xpp = (void *)xp;
#line 2830
	return status;
#line 2830
#endif
#line 2830
}
#line 2830

int
#line 2831
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp)
#line 2831
{
#line 2831
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2831

#line 2831
 /* basic algorithm is:
#line 2831
  *   - ensure sane alignment of output data
#line 2831
  *   - copy (conversion happens automatically) input data
#line 2831
  *     to output
#line 2831
  *   - update tp to point at next unconverted input, and xpp to point
#line 2831
  *     at next location for converted output
#line 2831
  */
#line 2831
  long i, j, ni;
#line 2831
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2831
  int *xp;
#line 2831
  int nrange = 0;         /* number of range errors */
#line 2831
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2831
  long cxp = (long) *((char**)xpp);
#line 2831

#line 2831
  realign = (cxp & 7) % SIZEOF_INT;
#line 2831
  /* sjl: manually stripmine so we can limit amount of
#line 2831
   * vector work space reserved to LOOPCNT elements. Also
#line 2831
   * makes vectorisation easy */
#line 2831
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2831
    ni=Min(nelems-j,LOOPCNT);
#line 2831
    if (realign) {
#line 2831
      xp = tmp;
#line 2831
    } else {
#line 2831
      xp = (int *) *xpp;
#line 2831
    }
#line 2831
   /* copy the next block */
#line 2831
#pragma cdir loopcnt=LOOPCNT
#line 2831
#pragma cdir shortloop
#line 2831
    for (i=0; i<ni; i++) {
#line 2831
      /* the normal case: */
#line 2831
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2831
     /* test for range errors (not always needed but do it anyway) */
#line 2831
      nrange += tp[i] < X_INT_MIN || tp[i] > X_INT_MAX;
#line 2831
    }
#line 2831
   /* copy workspace back if necessary */ 
#line 2831
    if (realign) {
#line 2831
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2831
      xp = (int *) *xpp;
#line 2831
    }
#line 2831
   /* update xpp and tp */
#line 2831
    xp += ni;
#line 2831
    tp += ni;
#line 2831
    *xpp = (void*)xp;
#line 2831
  }
#line 2831
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2831

#line 2831
#else   /* not SX */
#line 2831

#line 2831
	char *xp = (char *) *xpp;
#line 2831
	int status = ENOERR;
#line 2831

#line 2831
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2831
	{
#line 2831
		int lstatus = ncx_put_int_short(xp, tp);
#line 2831
		if(lstatus != ENOERR)
#line 2831
			status = lstatus;
#line 2831
	}
#line 2831

#line 2831
	*xpp = (void *)xp;
#line 2831
	return status;
#line 2831
#endif
#line 2831
}
#line 2831

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return ENOERR;
}
int
ncx_putn_int_uint(void **xpp, size_t nelems, const unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return ENOERR;
}
#else
int
#line 2857
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp)
#line 2857
{
#line 2857
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2857

#line 2857
 /* basic algorithm is:
#line 2857
  *   - ensure sane alignment of output data
#line 2857
  *   - copy (conversion happens automatically) input data
#line 2857
  *     to output
#line 2857
  *   - update tp to point at next unconverted input, and xpp to point
#line 2857
  *     at next location for converted output
#line 2857
  */
#line 2857
  long i, j, ni;
#line 2857
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2857
  int *xp;
#line 2857
  int nrange = 0;         /* number of range errors */
#line 2857
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2857
  long cxp = (long) *((char**)xpp);
#line 2857

#line 2857
  realign = (cxp & 7) % SIZEOF_INT;
#line 2857
  /* sjl: manually stripmine so we can limit amount of
#line 2857
   * vector work space reserved to LOOPCNT elements. Also
#line 2857
   * makes vectorisation easy */
#line 2857
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2857
    ni=Min(nelems-j,LOOPCNT);
#line 2857
    if (realign) {
#line 2857
      xp = tmp;
#line 2857
    } else {
#line 2857
      xp = (int *) *xpp;
#line 2857
    }
#line 2857
   /* copy the next block */
#line 2857
#pragma cdir loopcnt=LOOPCNT
#line 2857
#pragma cdir shortloop
#line 2857
    for (i=0; i<ni; i++) {
#line 2857
      /* the normal case: */
#line 2857
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2857
     /* test for range errors (not always needed but do it anyway) */
#line 2857
      nrange += tp[i] < X_INT_MIN || tp[i] > X_INT_MAX;
#line 2857
    }
#line 2857
   /* copy workspace back if necessary */ 
#line 2857
    if (realign) {
#line 2857
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2857
      xp = (int *) *xpp;
#line 2857
    }
#line 2857
   /* update xpp and tp */
#line 2857
    xp += ni;
#line 2857
    tp += ni;
#line 2857
    *xpp = (void*)xp;
#line 2857
  }
#line 2857
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2857

#line 2857
#else   /* not SX */
#line 2857

#line 2857
	char *xp = (char *) *xpp;
#line 2857
	int status = ENOERR;
#line 2857

#line 2857
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2857
	{
#line 2857
		int lstatus = ncx_put_int_int(xp, tp);
#line 2857
		if(lstatus != ENOERR)
#line 2857
			status = lstatus;
#line 2857
	}
#line 2857

#line 2857
	*xpp = (void *)xp;
#line 2857
	return status;
#line 2857
#endif
#line 2857
}
#line 2857

int
#line 2858
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp)
#line 2858
{
#line 2858
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2858

#line 2858
 /* basic algorithm is:
#line 2858
  *   - ensure sane alignment of output data
#line 2858
  *   - copy (conversion happens automatically) input data
#line 2858
  *     to output
#line 2858
  *   - update tp to point at next unconverted input, and xpp to point
#line 2858
  *     at next location for converted output
#line 2858
  */
#line 2858
  long i, j, ni;
#line 2858
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2858
  int *xp;
#line 2858
  int nrange = 0;         /* number of range errors */
#line 2858
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2858
  long cxp = (long) *((char**)xpp);
#line 2858

#line 2858
  realign = (cxp & 7) % SIZEOF_INT;
#line 2858
  /* sjl: manually stripmine so we can limit amount of
#line 2858
   * vector work space reserved to LOOPCNT elements. Also
#line 2858
   * makes vectorisation easy */
#line 2858
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2858
    ni=Min(nelems-j,LOOPCNT);
#line 2858
    if (realign) {
#line 2858
      xp = tmp;
#line 2858
    } else {
#line 2858
      xp = (int *) *xpp;
#line 2858
    }
#line 2858
   /* copy the next block */
#line 2858
#pragma cdir loopcnt=LOOPCNT
#line 2858
#pragma cdir shortloop
#line 2858
    for (i=0; i<ni; i++) {
#line 2858
      /* the normal case: */
#line 2858
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2858
     /* test for range errors (not always needed but do it anyway) */
#line 2858
      nrange += tp[i] < X_INT_MIN || tp[i] > X_INT_MAX;
#line 2858
    }
#line 2858
   /* copy workspace back if necessary */ 
#line 2858
    if (realign) {
#line 2858
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2858
      xp = (int *) *xpp;
#line 2858
    }
#line 2858
   /* update xpp and tp */
#line 2858
    xp += ni;
#line 2858
    tp += ni;
#line 2858
    *xpp = (void*)xp;
#line 2858
  }
#line 2858
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2858

#line 2858
#else   /* not SX */
#line 2858

#line 2858
	char *xp = (char *) *xpp;
#line 2858
	int status = ENOERR;
#line 2858

#line 2858
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2858
	{
#line 2858
		int lstatus = ncx_put_int_uint(xp, tp);
#line 2858
		if(lstatus != ENOERR)
#line 2858
			status = lstatus;
#line 2858
	}
#line 2858

#line 2858
	*xpp = (void *)xp;
#line 2858
	return status;
#line 2858
#endif
#line 2858
}
#line 2858

#endif

int
#line 2861
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2861
{
#line 2861
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2861

#line 2861
 /* basic algorithm is:
#line 2861
  *   - ensure sane alignment of output data
#line 2861
  *   - copy (conversion happens automatically) input data
#line 2861
  *     to output
#line 2861
  *   - update tp to point at next unconverted input, and xpp to point
#line 2861
  *     at next location for converted output
#line 2861
  */
#line 2861
  long i, j, ni;
#line 2861
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2861
  int *xp;
#line 2861
  int nrange = 0;         /* number of range errors */
#line 2861
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2861
  long cxp = (long) *((char**)xpp);
#line 2861

#line 2861
  realign = (cxp & 7) % SIZEOF_INT;
#line 2861
  /* sjl: manually stripmine so we can limit amount of
#line 2861
   * vector work space reserved to LOOPCNT elements. Also
#line 2861
   * makes vectorisation easy */
#line 2861
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2861
    ni=Min(nelems-j,LOOPCNT);
#line 2861
    if (realign) {
#line 2861
      xp = tmp;
#line 2861
    } else {
#line 2861
      xp = (int *) *xpp;
#line 2861
    }
#line 2861
   /* copy the next block */
#line 2861
#pragma cdir loopcnt=LOOPCNT
#line 2861
#pragma cdir shortloop
#line 2861
    for (i=0; i<ni; i++) {
#line 2861
      /* the normal case: */
#line 2861
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2861
     /* test for range errors (not always needed but do it anyway) */
#line 2861
      nrange += tp[i] < X_INT_MIN || tp[i] > X_INT_MAX;
#line 2861
    }
#line 2861
   /* copy workspace back if necessary */ 
#line 2861
    if (realign) {
#line 2861
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2861
      xp = (int *) *xpp;
#line 2861
    }
#line 2861
   /* update xpp and tp */
#line 2861
    xp += ni;
#line 2861
    tp += ni;
#line 2861
    *xpp = (void*)xp;
#line 2861
  }
#line 2861
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2861

#line 2861
#else   /* not SX */
#line 2861

#line 2861
	char *xp = (char *) *xpp;
#line 2861
	int status = ENOERR;
#line 2861

#line 2861
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2861
	{
#line 2861
		int lstatus = ncx_put_int_longlong(xp, tp);
#line 2861
		if(lstatus != ENOERR)
#line 2861
			status = lstatus;
#line 2861
	}
#line 2861

#line 2861
	*xpp = (void *)xp;
#line 2861
	return status;
#line 2861
#endif
#line 2861
}
#line 2861

int
#line 2862
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2862
{
#line 2862
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2862

#line 2862
 /* basic algorithm is:
#line 2862
  *   - ensure sane alignment of output data
#line 2862
  *   - copy (conversion happens automatically) input data
#line 2862
  *     to output
#line 2862
  *   - update tp to point at next unconverted input, and xpp to point
#line 2862
  *     at next location for converted output
#line 2862
  */
#line 2862
  long i, j, ni;
#line 2862
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2862
  int *xp;
#line 2862
  int nrange = 0;         /* number of range errors */
#line 2862
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2862
  long cxp = (long) *((char**)xpp);
#line 2862

#line 2862
  realign = (cxp & 7) % SIZEOF_INT;
#line 2862
  /* sjl: manually stripmine so we can limit amount of
#line 2862
   * vector work space reserved to LOOPCNT elements. Also
#line 2862
   * makes vectorisation easy */
#line 2862
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2862
    ni=Min(nelems-j,LOOPCNT);
#line 2862
    if (realign) {
#line 2862
      xp = tmp;
#line 2862
    } else {
#line 2862
      xp = (int *) *xpp;
#line 2862
    }
#line 2862
   /* copy the next block */
#line 2862
#pragma cdir loopcnt=LOOPCNT
#line 2862
#pragma cdir shortloop
#line 2862
    for (i=0; i<ni; i++) {
#line 2862
      /* the normal case: */
#line 2862
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2862
     /* test for range errors (not always needed but do it anyway) */
#line 2862
      nrange += tp[i] < X_INT_MIN || tp[i] > X_INT_MAX;
#line 2862
    }
#line 2862
   /* copy workspace back if necessary */ 
#line 2862
    if (realign) {
#line 2862
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2862
      xp = (int *) *xpp;
#line 2862
    }
#line 2862
   /* update xpp and tp */
#line 2862
    xp += ni;
#line 2862
    tp += ni;
#line 2862
    *xpp = (void*)xp;
#line 2862
  }
#line 2862
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2862

#line 2862
#else   /* not SX */
#line 2862

#line 2862
	char *xp = (char *) *xpp;
#line 2862
	int status = ENOERR;
#line 2862

#line 2862
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2862
	{
#line 2862
		int lstatus = ncx_put_int_ulonglong(xp, tp);
#line 2862
		if(lstatus != ENOERR)
#line 2862
			status = lstatus;
#line 2862
	}
#line 2862

#line 2862
	*xpp = (void *)xp;
#line 2862
	return status;
#line 2862
#endif
#line 2862
}
#line 2862

int
#line 2863
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp)
#line 2863
{
#line 2863
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2863

#line 2863
 /* basic algorithm is:
#line 2863
  *   - ensure sane alignment of output data
#line 2863
  *   - copy (conversion happens automatically) input data
#line 2863
  *     to output
#line 2863
  *   - update tp to point at next unconverted input, and xpp to point
#line 2863
  *     at next location for converted output
#line 2863
  */
#line 2863
  long i, j, ni;
#line 2863
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2863
  int *xp;
#line 2863
  double d;               /* special case for ncx_putn_int_float */
#line 2863
  int nrange = 0;         /* number of range errors */
#line 2863
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2863
  long cxp = (long) *((char**)xpp);
#line 2863

#line 2863
  realign = (cxp & 7) % SIZEOF_INT;
#line 2863
  /* sjl: manually stripmine so we can limit amount of
#line 2863
   * vector work space reserved to LOOPCNT elements. Also
#line 2863
   * makes vectorisation easy */
#line 2863
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2863
    ni=Min(nelems-j,LOOPCNT);
#line 2863
    if (realign) {
#line 2863
      xp = tmp;
#line 2863
    } else {
#line 2863
      xp = (int *) *xpp;
#line 2863
    }
#line 2863
   /* copy the next block */
#line 2863
#pragma cdir loopcnt=LOOPCNT
#line 2863
#pragma cdir shortloop
#line 2863
    for (i=0; i<ni; i++) {
#line 2863
      /* for some reason int to float, for putn, requires a special case */ 
#line 2863
      d = tp[i];
#line 2863
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
#line 2863
      nrange += d < X_INT_MIN || d > X_INT_MAX;
#line 2863
    }
#line 2863
   /* copy workspace back if necessary */ 
#line 2863
    if (realign) {
#line 2863
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2863
      xp = (int *) *xpp;
#line 2863
    }
#line 2863
   /* update xpp and tp */
#line 2863
    xp += ni;
#line 2863
    tp += ni;
#line 2863
    *xpp = (void*)xp;
#line 2863
  }
#line 2863
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2863

#line 2863
#else   /* not SX */
#line 2863

#line 2863
	char *xp = (char *) *xpp;
#line 2863
	int status = ENOERR;
#line 2863

#line 2863
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2863
	{
#line 2863
		int lstatus = ncx_put_int_float(xp, tp);
#line 2863
		if(lstatus != ENOERR)
#line 2863
			status = lstatus;
#line 2863
	}
#line 2863

#line 2863
	*xpp = (void *)xp;
#line 2863
	return status;
#line 2863
#endif
#line 2863
}
#line 2863

int
#line 2864
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp)
#line 2864
{
#line 2864
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2864

#line 2864
 /* basic algorithm is:
#line 2864
  *   - ensure sane alignment of output data
#line 2864
  *   - copy (conversion happens automatically) input data
#line 2864
  *     to output
#line 2864
  *   - update tp to point at next unconverted input, and xpp to point
#line 2864
  *     at next location for converted output
#line 2864
  */
#line 2864
  long i, j, ni;
#line 2864
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2864
  int *xp;
#line 2864
  int nrange = 0;         /* number of range errors */
#line 2864
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2864
  long cxp = (long) *((char**)xpp);
#line 2864

#line 2864
  realign = (cxp & 7) % SIZEOF_INT;
#line 2864
  /* sjl: manually stripmine so we can limit amount of
#line 2864
   * vector work space reserved to LOOPCNT elements. Also
#line 2864
   * makes vectorisation easy */
#line 2864
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2864
    ni=Min(nelems-j,LOOPCNT);
#line 2864
    if (realign) {
#line 2864
      xp = tmp;
#line 2864
    } else {
#line 2864
      xp = (int *) *xpp;
#line 2864
    }
#line 2864
   /* copy the next block */
#line 2864
#pragma cdir loopcnt=LOOPCNT
#line 2864
#pragma cdir shortloop
#line 2864
    for (i=0; i<ni; i++) {
#line 2864
      /* the normal case: */
#line 2864
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2864
     /* test for range errors (not always needed but do it anyway) */
#line 2864
      nrange += tp[i] < X_INT_MIN || tp[i] > X_INT_MAX;
#line 2864
    }
#line 2864
   /* copy workspace back if necessary */ 
#line 2864
    if (realign) {
#line 2864
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2864
      xp = (int *) *xpp;
#line 2864
    }
#line 2864
   /* update xpp and tp */
#line 2864
    xp += ni;
#line 2864
    tp += ni;
#line 2864
    *xpp = (void*)xp;
#line 2864
  }
#line 2864
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2864

#line 2864
#else   /* not SX */
#line 2864

#line 2864
	char *xp = (char *) *xpp;
#line 2864
	int status = ENOERR;
#line 2864

#line 2864
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2864
	{
#line 2864
		int lstatus = ncx_put_int_double(xp, tp);
#line 2864
		if(lstatus != ENOERR)
#line 2864
			status = lstatus;
#line 2864
	}
#line 2864

#line 2864
	*xpp = (void *)xp;
#line 2864
	return status;
#line 2864
#endif
#line 2864
}
#line 2864



/* float */

int
#line 2869
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
#line 2869
{
#line 2869
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2869

#line 2869
 /* basic algorithm is:
#line 2869
  *   - ensure sane alignment of input data
#line 2869
  *   - copy (conversion happens automatically) input data
#line 2869
  *     to output
#line 2869
  *   - update xpp to point at next unconverted input, and tp to point
#line 2869
  *     at next location for converted output
#line 2869
  */
#line 2869
  long i, j, ni;
#line 2869
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2869
  float *xp;
#line 2869
  int nrange = 0;         /* number of range errors */
#line 2869
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2869
  long cxp = (long) *((char**)xpp);
#line 2869

#line 2869
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2869
  /* sjl: manually stripmine so we can limit amount of
#line 2869
   * vector work space reserved to LOOPCNT elements. Also
#line 2869
   * makes vectorisation easy */
#line 2869
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2869
    ni=Min(nelems-j,LOOPCNT);
#line 2869
    if (realign) {
#line 2869
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 2869
      xp = tmp;
#line 2869
    } else {
#line 2869
      xp = (float *) *xpp;
#line 2869
    }
#line 2869
   /* copy the next block */
#line 2869
#pragma cdir loopcnt=LOOPCNT
#line 2869
#pragma cdir shortloop
#line 2869
    for (i=0; i<ni; i++) {
#line 2869
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2869
     /* test for range errors (not always needed but do it anyway) */
#line 2869
      nrange += xp[i] < SCHAR_MIN || xp[i] > SCHAR_MAX;
#line 2869
    }
#line 2869
   /* update xpp and tp */
#line 2869
    if (realign) xp = (float *) *xpp;
#line 2869
    xp += ni;
#line 2869
    tp += ni;
#line 2869
    *xpp = (void*)xp;
#line 2869
  }
#line 2869
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2869

#line 2869
#else   /* not SX */
#line 2869
	const char *xp = (const char *) *xpp;
#line 2869
	int status = ENOERR;
#line 2869

#line 2869
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2869
	{
#line 2869
		const int lstatus = ncx_get_float_schar(xp, tp);
#line 2869
		if(lstatus != ENOERR)
#line 2869
			status = lstatus;
#line 2869
	}
#line 2869

#line 2869
	*xpp = (const void *)xp;
#line 2869
	return status;
#line 2869
#  endif
#line 2869
}
#line 2869

int
#line 2870
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2870
{
#line 2870
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2870

#line 2870
 /* basic algorithm is:
#line 2870
  *   - ensure sane alignment of input data
#line 2870
  *   - copy (conversion happens automatically) input data
#line 2870
  *     to output
#line 2870
  *   - update xpp to point at next unconverted input, and tp to point
#line 2870
  *     at next location for converted output
#line 2870
  */
#line 2870
  long i, j, ni;
#line 2870
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2870
  float *xp;
#line 2870
  int nrange = 0;         /* number of range errors */
#line 2870
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2870
  long cxp = (long) *((char**)xpp);
#line 2870

#line 2870
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2870
  /* sjl: manually stripmine so we can limit amount of
#line 2870
   * vector work space reserved to LOOPCNT elements. Also
#line 2870
   * makes vectorisation easy */
#line 2870
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2870
    ni=Min(nelems-j,LOOPCNT);
#line 2870
    if (realign) {
#line 2870
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 2870
      xp = tmp;
#line 2870
    } else {
#line 2870
      xp = (float *) *xpp;
#line 2870
    }
#line 2870
   /* copy the next block */
#line 2870
#pragma cdir loopcnt=LOOPCNT
#line 2870
#pragma cdir shortloop
#line 2870
    for (i=0; i<ni; i++) {
#line 2870
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2870
     /* test for range errors (not always needed but do it anyway) */
#line 2870
      nrange += xp[i] < UCHAR_MIN || xp[i] > UCHAR_MAX;
#line 2870
    }
#line 2870
   /* update xpp and tp */
#line 2870
    if (realign) xp = (float *) *xpp;
#line 2870
    xp += ni;
#line 2870
    tp += ni;
#line 2870
    *xpp = (void*)xp;
#line 2870
  }
#line 2870
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2870

#line 2870
#else   /* not SX */
#line 2870
	const char *xp = (const char *) *xpp;
#line 2870
	int status = ENOERR;
#line 2870

#line 2870
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2870
	{
#line 2870
		const int lstatus = ncx_get_float_uchar(xp, tp);
#line 2870
		if(lstatus != ENOERR)
#line 2870
			status = lstatus;
#line 2870
	}
#line 2870

#line 2870
	*xpp = (const void *)xp;
#line 2870
	return status;
#line 2870
#  endif
#line 2870
}
#line 2870

int
#line 2871
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
#line 2871
{
#line 2871
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2871

#line 2871
 /* basic algorithm is:
#line 2871
  *   - ensure sane alignment of input data
#line 2871
  *   - copy (conversion happens automatically) input data
#line 2871
  *     to output
#line 2871
  *   - update xpp to point at next unconverted input, and tp to point
#line 2871
  *     at next location for converted output
#line 2871
  */
#line 2871
  long i, j, ni;
#line 2871
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2871
  float *xp;
#line 2871
  int nrange = 0;         /* number of range errors */
#line 2871
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2871
  long cxp = (long) *((char**)xpp);
#line 2871

#line 2871
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2871
  /* sjl: manually stripmine so we can limit amount of
#line 2871
   * vector work space reserved to LOOPCNT elements. Also
#line 2871
   * makes vectorisation easy */
#line 2871
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2871
    ni=Min(nelems-j,LOOPCNT);
#line 2871
    if (realign) {
#line 2871
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 2871
      xp = tmp;
#line 2871
    } else {
#line 2871
      xp = (float *) *xpp;
#line 2871
    }
#line 2871
   /* copy the next block */
#line 2871
#pragma cdir loopcnt=LOOPCNT
#line 2871
#pragma cdir shortloop
#line 2871
    for (i=0; i<ni; i++) {
#line 2871
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2871
     /* test for range errors (not always needed but do it anyway) */
#line 2871
      nrange += xp[i] < SHORT_MIN || xp[i] > SHORT_MAX;
#line 2871
    }
#line 2871
   /* update xpp and tp */
#line 2871
    if (realign) xp = (float *) *xpp;
#line 2871
    xp += ni;
#line 2871
    tp += ni;
#line 2871
    *xpp = (void*)xp;
#line 2871
  }
#line 2871
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2871

#line 2871
#else   /* not SX */
#line 2871
	const char *xp = (const char *) *xpp;
#line 2871
	int status = ENOERR;
#line 2871

#line 2871
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2871
	{
#line 2871
		const int lstatus = ncx_get_float_short(xp, tp);
#line 2871
		if(lstatus != ENOERR)
#line 2871
			status = lstatus;
#line 2871
	}
#line 2871

#line 2871
	*xpp = (const void *)xp;
#line 2871
	return status;
#line 2871
#  endif
#line 2871
}
#line 2871

int
#line 2872
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
#line 2872
{
#line 2872
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2872

#line 2872
 /* basic algorithm is:
#line 2872
  *   - ensure sane alignment of input data
#line 2872
  *   - copy (conversion happens automatically) input data
#line 2872
  *     to output
#line 2872
  *   - update xpp to point at next unconverted input, and tp to point
#line 2872
  *     at next location for converted output
#line 2872
  */
#line 2872
  long i, j, ni;
#line 2872
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2872
  float *xp;
#line 2872
  int nrange = 0;         /* number of range errors */
#line 2872
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2872
  long cxp = (long) *((char**)xpp);
#line 2872

#line 2872
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2872
  /* sjl: manually stripmine so we can limit amount of
#line 2872
   * vector work space reserved to LOOPCNT elements. Also
#line 2872
   * makes vectorisation easy */
#line 2872
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2872
    ni=Min(nelems-j,LOOPCNT);
#line 2872
    if (realign) {
#line 2872
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 2872
      xp = tmp;
#line 2872
    } else {
#line 2872
      xp = (float *) *xpp;
#line 2872
    }
#line 2872
   /* copy the next block */
#line 2872
#pragma cdir loopcnt=LOOPCNT
#line 2872
#pragma cdir shortloop
#line 2872
    for (i=0; i<ni; i++) {
#line 2872
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2872
     /* test for range errors (not always needed but do it anyway) */
#line 2872
      nrange += xp[i] < INT_MIN || xp[i] > INT_MAX;
#line 2872
    }
#line 2872
   /* update xpp and tp */
#line 2872
    if (realign) xp = (float *) *xpp;
#line 2872
    xp += ni;
#line 2872
    tp += ni;
#line 2872
    *xpp = (void*)xp;
#line 2872
  }
#line 2872
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2872

#line 2872
#else   /* not SX */
#line 2872
	const char *xp = (const char *) *xpp;
#line 2872
	int status = ENOERR;
#line 2872

#line 2872
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2872
	{
#line 2872
		const int lstatus = ncx_get_float_int(xp, tp);
#line 2872
		if(lstatus != ENOERR)
#line 2872
			status = lstatus;
#line 2872
	}
#line 2872

#line 2872
	*xpp = (const void *)xp;
#line 2872
	return status;
#line 2872
#  endif
#line 2872
}
#line 2872

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(float));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return ENOERR;
}
#elif vax
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while(ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 2894
		const struct ieee_single *const isp =
#line 2894
			 (const struct ieee_single *) (*xpp);
#line 2894
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 2894

#line 2894
		switch(exp) {
#line 2894
		case 0 :
#line 2894
			/* ieee subnormal */
#line 2894
			if(isp->mant_hi == min.ieee.mant_hi
#line 2894
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 2894
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 2894
			{
#line 2894
				*vsp = min.s;
#line 2894
			}
#line 2894
			else
#line 2894
			{
#line 2894
				unsigned mantissa = (isp->mant_hi << 16)
#line 2894
					 | isp->mant_lo_hi << 8
#line 2894
					 | isp->mant_lo_lo;
#line 2894
				unsigned tmp = mantissa >> 20;
#line 2894
				if(tmp >= 4) {
#line 2894
					vsp->exp = 2;
#line 2894
				} else if (tmp >= 2) {
#line 2894
					vsp->exp = 1;
#line 2894
				} else {
#line 2894
					*vsp = min.s;
#line 2894
					break;
#line 2894
				} /* else */
#line 2894
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 2894
				tmp <<= 3 - vsp->exp;
#line 2894
				vsp->mantissa2 = tmp;
#line 2894
				vsp->mantissa1 = (tmp >> 16);
#line 2894
			}
#line 2894
			break;
#line 2894
		case 0xfe :
#line 2894
		case 0xff :
#line 2894
			*vsp = max.s;
#line 2894
			break;
#line 2894
		default :
#line 2894
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 2894
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 2894
			vsp->mantissa1 = isp->mant_hi;
#line 2894
		}
#line 2894

#line 2894
		vsp->sign = isp->sign;
#line 2894


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return ENOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
#line 2920
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
#line 2920
{
#line 2920
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2920

#line 2920
 /* basic algorithm is:
#line 2920
  *   - ensure sane alignment of input data
#line 2920
  *   - copy (conversion happens automatically) input data
#line 2920
  *     to output
#line 2920
  *   - update xpp to point at next unconverted input, and tp to point
#line 2920
  *     at next location for converted output
#line 2920
  */
#line 2920
  long i, j, ni;
#line 2920
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2920
  float *xp;
#line 2920
  int nrange = 0;         /* number of range errors */
#line 2920
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2920
  long cxp = (long) *((char**)xpp);
#line 2920

#line 2920
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2920
  /* sjl: manually stripmine so we can limit amount of
#line 2920
   * vector work space reserved to LOOPCNT elements. Also
#line 2920
   * makes vectorisation easy */
#line 2920
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2920
    ni=Min(nelems-j,LOOPCNT);
#line 2920
    if (realign) {
#line 2920
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 2920
      xp = tmp;
#line 2920
    } else {
#line 2920
      xp = (float *) *xpp;
#line 2920
    }
#line 2920
   /* copy the next block */
#line 2920
#pragma cdir loopcnt=LOOPCNT
#line 2920
#pragma cdir shortloop
#line 2920
    for (i=0; i<ni; i++) {
#line 2920
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2920
     /* test for range errors (not always needed but do it anyway) */
#line 2920
      nrange += xp[i] < DOUBLE_MIN || xp[i] > DOUBLE_MAX;
#line 2920
    }
#line 2920
   /* update xpp and tp */
#line 2920
    if (realign) xp = (float *) *xpp;
#line 2920
    xp += ni;
#line 2920
    tp += ni;
#line 2920
    *xpp = (void*)xp;
#line 2920
  }
#line 2920
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2920

#line 2920
#else   /* not SX */
#line 2920
	const char *xp = (const char *) *xpp;
#line 2920
	int status = ENOERR;
#line 2920

#line 2920
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2920
	{
#line 2920
		const int lstatus = ncx_get_float_double(xp, tp);
#line 2920
		if(lstatus != ENOERR)
#line 2920
			status = lstatus;
#line 2920
	}
#line 2920

#line 2920
	*xpp = (const void *)xp;
#line 2920
	return status;
#line 2920
#  endif
#line 2920
}
#line 2920

int
#line 2921
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
#line 2921
{
#line 2921
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2921

#line 2921
 /* basic algorithm is:
#line 2921
  *   - ensure sane alignment of input data
#line 2921
  *   - copy (conversion happens automatically) input data
#line 2921
  *     to output
#line 2921
  *   - update xpp to point at next unconverted input, and tp to point
#line 2921
  *     at next location for converted output
#line 2921
  */
#line 2921
  long i, j, ni;
#line 2921
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2921
  float *xp;
#line 2921
  int nrange = 0;         /* number of range errors */
#line 2921
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2921
  long cxp = (long) *((char**)xpp);
#line 2921

#line 2921
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2921
  /* sjl: manually stripmine so we can limit amount of
#line 2921
   * vector work space reserved to LOOPCNT elements. Also
#line 2921
   * makes vectorisation easy */
#line 2921
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2921
    ni=Min(nelems-j,LOOPCNT);
#line 2921
    if (realign) {
#line 2921
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 2921
      xp = tmp;
#line 2921
    } else {
#line 2921
      xp = (float *) *xpp;
#line 2921
    }
#line 2921
   /* copy the next block */
#line 2921
#pragma cdir loopcnt=LOOPCNT
#line 2921
#pragma cdir shortloop
#line 2921
    for (i=0; i<ni; i++) {
#line 2921
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2921
     /* test for range errors (not always needed but do it anyway) */
#line 2921
      nrange += xp[i] < UINT_MIN || xp[i] > UINT_MAX;
#line 2921
    }
#line 2921
   /* update xpp and tp */
#line 2921
    if (realign) xp = (float *) *xpp;
#line 2921
    xp += ni;
#line 2921
    tp += ni;
#line 2921
    *xpp = (void*)xp;
#line 2921
  }
#line 2921
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2921

#line 2921
#else   /* not SX */
#line 2921
	const char *xp = (const char *) *xpp;
#line 2921
	int status = ENOERR;
#line 2921

#line 2921
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2921
	{
#line 2921
		const int lstatus = ncx_get_float_uint(xp, tp);
#line 2921
		if(lstatus != ENOERR)
#line 2921
			status = lstatus;
#line 2921
	}
#line 2921

#line 2921
	*xpp = (const void *)xp;
#line 2921
	return status;
#line 2921
#  endif
#line 2921
}
#line 2921

int
#line 2922
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2922
{
#line 2922
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2922

#line 2922
 /* basic algorithm is:
#line 2922
  *   - ensure sane alignment of input data
#line 2922
  *   - copy (conversion happens automatically) input data
#line 2922
  *     to output
#line 2922
  *   - update xpp to point at next unconverted input, and tp to point
#line 2922
  *     at next location for converted output
#line 2922
  */
#line 2922
  long i, j, ni;
#line 2922
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2922
  float *xp;
#line 2922
  int nrange = 0;         /* number of range errors */
#line 2922
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2922
  long cxp = (long) *((char**)xpp);
#line 2922

#line 2922
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2922
  /* sjl: manually stripmine so we can limit amount of
#line 2922
   * vector work space reserved to LOOPCNT elements. Also
#line 2922
   * makes vectorisation easy */
#line 2922
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2922
    ni=Min(nelems-j,LOOPCNT);
#line 2922
    if (realign) {
#line 2922
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 2922
      xp = tmp;
#line 2922
    } else {
#line 2922
      xp = (float *) *xpp;
#line 2922
    }
#line 2922
   /* copy the next block */
#line 2922
#pragma cdir loopcnt=LOOPCNT
#line 2922
#pragma cdir shortloop
#line 2922
    for (i=0; i<ni; i++) {
#line 2922
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2922
     /* test for range errors (not always needed but do it anyway) */
#line 2922
      nrange += xp[i] < LONGLONG_MIN || xp[i] > LONGLONG_MAX;
#line 2922
    }
#line 2922
   /* update xpp and tp */
#line 2922
    if (realign) xp = (float *) *xpp;
#line 2922
    xp += ni;
#line 2922
    tp += ni;
#line 2922
    *xpp = (void*)xp;
#line 2922
  }
#line 2922
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2922

#line 2922
#else   /* not SX */
#line 2922
	const char *xp = (const char *) *xpp;
#line 2922
	int status = ENOERR;
#line 2922

#line 2922
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2922
	{
#line 2922
		const int lstatus = ncx_get_float_longlong(xp, tp);
#line 2922
		if(lstatus != ENOERR)
#line 2922
			status = lstatus;
#line 2922
	}
#line 2922

#line 2922
	*xpp = (const void *)xp;
#line 2922
	return status;
#line 2922
#  endif
#line 2922
}
#line 2922

int
#line 2923
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2923
{
#line 2923
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2923

#line 2923
 /* basic algorithm is:
#line 2923
  *   - ensure sane alignment of input data
#line 2923
  *   - copy (conversion happens automatically) input data
#line 2923
  *     to output
#line 2923
  *   - update xpp to point at next unconverted input, and tp to point
#line 2923
  *     at next location for converted output
#line 2923
  */
#line 2923
  long i, j, ni;
#line 2923
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2923
  float *xp;
#line 2923
  int nrange = 0;         /* number of range errors */
#line 2923
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2923
  long cxp = (long) *((char**)xpp);
#line 2923

#line 2923
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2923
  /* sjl: manually stripmine so we can limit amount of
#line 2923
   * vector work space reserved to LOOPCNT elements. Also
#line 2923
   * makes vectorisation easy */
#line 2923
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2923
    ni=Min(nelems-j,LOOPCNT);
#line 2923
    if (realign) {
#line 2923
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 2923
      xp = tmp;
#line 2923
    } else {
#line 2923
      xp = (float *) *xpp;
#line 2923
    }
#line 2923
   /* copy the next block */
#line 2923
#pragma cdir loopcnt=LOOPCNT
#line 2923
#pragma cdir shortloop
#line 2923
    for (i=0; i<ni; i++) {
#line 2923
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2923
     /* test for range errors (not always needed but do it anyway) */
#line 2923
      nrange += xp[i] < ULONGLONG_MIN || xp[i] > ULONGLONG_MAX;
#line 2923
    }
#line 2923
   /* update xpp and tp */
#line 2923
    if (realign) xp = (float *) *xpp;
#line 2923
    xp += ni;
#line 2923
    tp += ni;
#line 2923
    *xpp = (void*)xp;
#line 2923
  }
#line 2923
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2923

#line 2923
#else   /* not SX */
#line 2923
	const char *xp = (const char *) *xpp;
#line 2923
	int status = ENOERR;
#line 2923

#line 2923
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2923
	{
#line 2923
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
#line 2923
		if(lstatus != ENOERR)
#line 2923
			status = lstatus;
#line 2923
	}
#line 2923

#line 2923
	*xpp = (const void *)xp;
#line 2923
	return status;
#line 2923
#  endif
#line 2923
}
#line 2923


int
#line 2925
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp)
#line 2925
{
#line 2925
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2925

#line 2925
 /* basic algorithm is:
#line 2925
  *   - ensure sane alignment of output data
#line 2925
  *   - copy (conversion happens automatically) input data
#line 2925
  *     to output
#line 2925
  *   - update tp to point at next unconverted input, and xpp to point
#line 2925
  *     at next location for converted output
#line 2925
  */
#line 2925
  long i, j, ni;
#line 2925
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2925
  float *xp;
#line 2925
  int nrange = 0;         /* number of range errors */
#line 2925
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2925
  long cxp = (long) *((char**)xpp);
#line 2925

#line 2925
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2925
  /* sjl: manually stripmine so we can limit amount of
#line 2925
   * vector work space reserved to LOOPCNT elements. Also
#line 2925
   * makes vectorisation easy */
#line 2925
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2925
    ni=Min(nelems-j,LOOPCNT);
#line 2925
    if (realign) {
#line 2925
      xp = tmp;
#line 2925
    } else {
#line 2925
      xp = (float *) *xpp;
#line 2925
    }
#line 2925
   /* copy the next block */
#line 2925
#pragma cdir loopcnt=LOOPCNT
#line 2925
#pragma cdir shortloop
#line 2925
    for (i=0; i<ni; i++) {
#line 2925
      /* the normal case: */
#line 2925
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 2925
     /* test for range errors (not always needed but do it anyway) */
#line 2925
      nrange += tp[i] < X_FLOAT_MIN || tp[i] > X_FLOAT_MAX;
#line 2925
    }
#line 2925
   /* copy workspace back if necessary */ 
#line 2925
    if (realign) {
#line 2925
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 2925
      xp = (float *) *xpp;
#line 2925
    }
#line 2925
   /* update xpp and tp */
#line 2925
    xp += ni;
#line 2925
    tp += ni;
#line 2925
    *xpp = (void*)xp;
#line 2925
  }
#line 2925
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2925

#line 2925
#else   /* not SX */
#line 2925

#line 2925
	char *xp = (char *) *xpp;
#line 2925
	int status = ENOERR;
#line 2925

#line 2925
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2925
	{
#line 2925
		int lstatus = ncx_put_float_schar(xp, tp);
#line 2925
		if(lstatus != ENOERR)
#line 2925
			status = lstatus;
#line 2925
	}
#line 2925

#line 2925
	*xpp = (void *)xp;
#line 2925
	return status;
#line 2925
#endif
#line 2925
}
#line 2925

int
#line 2926
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2926
{
#line 2926
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2926

#line 2926
 /* basic algorithm is:
#line 2926
  *   - ensure sane alignment of output data
#line 2926
  *   - copy (conversion happens automatically) input data
#line 2926
  *     to output
#line 2926
  *   - update tp to point at next unconverted input, and xpp to point
#line 2926
  *     at next location for converted output
#line 2926
  */
#line 2926
  long i, j, ni;
#line 2926
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2926
  float *xp;
#line 2926
  int nrange = 0;         /* number of range errors */
#line 2926
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2926
  long cxp = (long) *((char**)xpp);
#line 2926

#line 2926
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2926
  /* sjl: manually stripmine so we can limit amount of
#line 2926
   * vector work space reserved to LOOPCNT elements. Also
#line 2926
   * makes vectorisation easy */
#line 2926
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2926
    ni=Min(nelems-j,LOOPCNT);
#line 2926
    if (realign) {
#line 2926
      xp = tmp;
#line 2926
    } else {
#line 2926
      xp = (float *) *xpp;
#line 2926
    }
#line 2926
   /* copy the next block */
#line 2926
#pragma cdir loopcnt=LOOPCNT
#line 2926
#pragma cdir shortloop
#line 2926
    for (i=0; i<ni; i++) {
#line 2926
      /* the normal case: */
#line 2926
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 2926
     /* test for range errors (not always needed but do it anyway) */
#line 2926
      nrange += tp[i] < X_FLOAT_MIN || tp[i] > X_FLOAT_MAX;
#line 2926
    }
#line 2926
   /* copy workspace back if necessary */ 
#line 2926
    if (realign) {
#line 2926
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 2926
      xp = (float *) *xpp;
#line 2926
    }
#line 2926
   /* update xpp and tp */
#line 2926
    xp += ni;
#line 2926
    tp += ni;
#line 2926
    *xpp = (void*)xp;
#line 2926
  }
#line 2926
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2926

#line 2926
#else   /* not SX */
#line 2926

#line 2926
	char *xp = (char *) *xpp;
#line 2926
	int status = ENOERR;
#line 2926

#line 2926
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2926
	{
#line 2926
		int lstatus = ncx_put_float_uchar(xp, tp);
#line 2926
		if(lstatus != ENOERR)
#line 2926
			status = lstatus;
#line 2926
	}
#line 2926

#line 2926
	*xpp = (void *)xp;
#line 2926
	return status;
#line 2926
#endif
#line 2926
}
#line 2926

int
#line 2927
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp)
#line 2927
{
#line 2927
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2927

#line 2927
 /* basic algorithm is:
#line 2927
  *   - ensure sane alignment of output data
#line 2927
  *   - copy (conversion happens automatically) input data
#line 2927
  *     to output
#line 2927
  *   - update tp to point at next unconverted input, and xpp to point
#line 2927
  *     at next location for converted output
#line 2927
  */
#line 2927
  long i, j, ni;
#line 2927
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2927
  float *xp;
#line 2927
  int nrange = 0;         /* number of range errors */
#line 2927
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2927
  long cxp = (long) *((char**)xpp);
#line 2927

#line 2927
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2927
  /* sjl: manually stripmine so we can limit amount of
#line 2927
   * vector work space reserved to LOOPCNT elements. Also
#line 2927
   * makes vectorisation easy */
#line 2927
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2927
    ni=Min(nelems-j,LOOPCNT);
#line 2927
    if (realign) {
#line 2927
      xp = tmp;
#line 2927
    } else {
#line 2927
      xp = (float *) *xpp;
#line 2927
    }
#line 2927
   /* copy the next block */
#line 2927
#pragma cdir loopcnt=LOOPCNT
#line 2927
#pragma cdir shortloop
#line 2927
    for (i=0; i<ni; i++) {
#line 2927
      /* the normal case: */
#line 2927
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 2927
     /* test for range errors (not always needed but do it anyway) */
#line 2927
      nrange += tp[i] < X_FLOAT_MIN || tp[i] > X_FLOAT_MAX;
#line 2927
    }
#line 2927
   /* copy workspace back if necessary */ 
#line 2927
    if (realign) {
#line 2927
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 2927
      xp = (float *) *xpp;
#line 2927
    }
#line 2927
   /* update xpp and tp */
#line 2927
    xp += ni;
#line 2927
    tp += ni;
#line 2927
    *xpp = (void*)xp;
#line 2927
  }
#line 2927
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2927

#line 2927
#else   /* not SX */
#line 2927

#line 2927
	char *xp = (char *) *xpp;
#line 2927
	int status = ENOERR;
#line 2927

#line 2927
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2927
	{
#line 2927
		int lstatus = ncx_put_float_short(xp, tp);
#line 2927
		if(lstatus != ENOERR)
#line 2927
			status = lstatus;
#line 2927
	}
#line 2927

#line 2927
	*xpp = (void *)xp;
#line 2927
	return status;
#line 2927
#endif
#line 2927
}
#line 2927

int
#line 2928
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp)
#line 2928
{
#line 2928
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2928

#line 2928
 /* basic algorithm is:
#line 2928
  *   - ensure sane alignment of output data
#line 2928
  *   - copy (conversion happens automatically) input data
#line 2928
  *     to output
#line 2928
  *   - update tp to point at next unconverted input, and xpp to point
#line 2928
  *     at next location for converted output
#line 2928
  */
#line 2928
  long i, j, ni;
#line 2928
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2928
  float *xp;
#line 2928
  int nrange = 0;         /* number of range errors */
#line 2928
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2928
  long cxp = (long) *((char**)xpp);
#line 2928

#line 2928
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2928
  /* sjl: manually stripmine so we can limit amount of
#line 2928
   * vector work space reserved to LOOPCNT elements. Also
#line 2928
   * makes vectorisation easy */
#line 2928
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2928
    ni=Min(nelems-j,LOOPCNT);
#line 2928
    if (realign) {
#line 2928
      xp = tmp;
#line 2928
    } else {
#line 2928
      xp = (float *) *xpp;
#line 2928
    }
#line 2928
   /* copy the next block */
#line 2928
#pragma cdir loopcnt=LOOPCNT
#line 2928
#pragma cdir shortloop
#line 2928
    for (i=0; i<ni; i++) {
#line 2928
      /* the normal case: */
#line 2928
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 2928
     /* test for range errors (not always needed but do it anyway) */
#line 2928
      nrange += tp[i] < X_FLOAT_MIN || tp[i] > X_FLOAT_MAX;
#line 2928
    }
#line 2928
   /* copy workspace back if necessary */ 
#line 2928
    if (realign) {
#line 2928
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 2928
      xp = (float *) *xpp;
#line 2928
    }
#line 2928
   /* update xpp and tp */
#line 2928
    xp += ni;
#line 2928
    tp += ni;
#line 2928
    *xpp = (void*)xp;
#line 2928
  }
#line 2928
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2928

#line 2928
#else   /* not SX */
#line 2928

#line 2928
	char *xp = (char *) *xpp;
#line 2928
	int status = ENOERR;
#line 2928

#line 2928
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2928
	{
#line 2928
		int lstatus = ncx_put_float_int(xp, tp);
#line 2928
		if(lstatus != ENOERR)
#line 2928
			status = lstatus;
#line 2928
	}
#line 2928

#line 2928
	*xpp = (void *)xp;
#line 2928
	return status;
#line 2928
#endif
#line 2928
}
#line 2928

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return ENOERR;
}
#elif vax
int
ncx_putn_float_float(void **xpp, size_t nfloats, const float *ip)
{
	const float *const end = ip + nfloats;

	while(ip < end)
	{
		const struct vax_single *const vsp =
#line 2950
			 (const struct vax_single *)ip;
#line 2950
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);
#line 2950

#line 2950
		switch(vsp->exp){
#line 2950
		case 0 :
#line 2950
			/* all vax float with zero exponent map to zero */
#line 2950
			*isp = min.ieee;
#line 2950
			break;
#line 2950
		case 2 :
#line 2950
		case 1 :
#line 2950
		{
#line 2950
			/* These will map to subnormals */
#line 2950
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 2950
					 | vsp->mantissa2;
#line 2950
			mantissa >>= 3 - vsp->exp;
#line 2950
			mantissa += (1 << (20 + vsp->exp));
#line 2950
			isp->mant_lo_lo = mantissa;
#line 2950
			isp->mant_lo_hi = mantissa >> 8;
#line 2950
			isp->mant_hi = mantissa >> 16;
#line 2950
			isp->exp_lo = 0;
#line 2950
			isp->exp_hi = 0;
#line 2950
		}
#line 2950
			break;
#line 2950
		case 0xff : /* max.s.exp */
#line 2950
			if( vsp->mantissa2 == max.s.mantissa2
#line 2950
				&& vsp->mantissa1 == max.s.mantissa1)
#line 2950
			{
#line 2950
				/* map largest vax float to ieee infinity */
#line 2950
				*isp = max.ieee;
#line 2950
				break;
#line 2950
			} /* else, fall thru */
#line 2950
		default :
#line 2950
		{
#line 2950
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 2950
			isp->exp_hi = exp >> 1;
#line 2950
			isp->exp_lo = exp;
#line 2950
			isp->mant_lo_lo = vsp->mantissa2;
#line 2950
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 2950
			isp->mant_hi = vsp->mantissa1;
#line 2950
		}
#line 2950
		}
#line 2950

#line 2950
		isp->sign = vsp->sign;
#line 2950

	
		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return ENOERR;
}
#else
int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp)
{
	char *xp = *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}

#endif
int
#line 2976
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp)
#line 2976
{
#line 2976
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2976

#line 2976
 /* basic algorithm is:
#line 2976
  *   - ensure sane alignment of output data
#line 2976
  *   - copy (conversion happens automatically) input data
#line 2976
  *     to output
#line 2976
  *   - update tp to point at next unconverted input, and xpp to point
#line 2976
  *     at next location for converted output
#line 2976
  */
#line 2976
  long i, j, ni;
#line 2976
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2976
  float *xp;
#line 2976
  int nrange = 0;         /* number of range errors */
#line 2976
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2976
  long cxp = (long) *((char**)xpp);
#line 2976

#line 2976
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2976
  /* sjl: manually stripmine so we can limit amount of
#line 2976
   * vector work space reserved to LOOPCNT elements. Also
#line 2976
   * makes vectorisation easy */
#line 2976
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2976
    ni=Min(nelems-j,LOOPCNT);
#line 2976
    if (realign) {
#line 2976
      xp = tmp;
#line 2976
    } else {
#line 2976
      xp = (float *) *xpp;
#line 2976
    }
#line 2976
   /* copy the next block */
#line 2976
#pragma cdir loopcnt=LOOPCNT
#line 2976
#pragma cdir shortloop
#line 2976
    for (i=0; i<ni; i++) {
#line 2976
      /* the normal case: */
#line 2976
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 2976
     /* test for range errors (not always needed but do it anyway) */
#line 2976
      nrange += tp[i] < X_FLOAT_MIN || tp[i] > X_FLOAT_MAX;
#line 2976
    }
#line 2976
   /* copy workspace back if necessary */ 
#line 2976
    if (realign) {
#line 2976
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 2976
      xp = (float *) *xpp;
#line 2976
    }
#line 2976
   /* update xpp and tp */
#line 2976
    xp += ni;
#line 2976
    tp += ni;
#line 2976
    *xpp = (void*)xp;
#line 2976
  }
#line 2976
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2976

#line 2976
#else   /* not SX */
#line 2976

#line 2976
	char *xp = (char *) *xpp;
#line 2976
	int status = ENOERR;
#line 2976

#line 2976
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2976
	{
#line 2976
		int lstatus = ncx_put_float_double(xp, tp);
#line 2976
		if(lstatus != ENOERR)
#line 2976
			status = lstatus;
#line 2976
	}
#line 2976

#line 2976
	*xpp = (void *)xp;
#line 2976
	return status;
#line 2976
#endif
#line 2976
}
#line 2976

int
#line 2977
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp)
#line 2977
{
#line 2977
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2977

#line 2977
 /* basic algorithm is:
#line 2977
  *   - ensure sane alignment of output data
#line 2977
  *   - copy (conversion happens automatically) input data
#line 2977
  *     to output
#line 2977
  *   - update tp to point at next unconverted input, and xpp to point
#line 2977
  *     at next location for converted output
#line 2977
  */
#line 2977
  long i, j, ni;
#line 2977
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2977
  float *xp;
#line 2977
  int nrange = 0;         /* number of range errors */
#line 2977
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2977
  long cxp = (long) *((char**)xpp);
#line 2977

#line 2977
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2977
  /* sjl: manually stripmine so we can limit amount of
#line 2977
   * vector work space reserved to LOOPCNT elements. Also
#line 2977
   * makes vectorisation easy */
#line 2977
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2977
    ni=Min(nelems-j,LOOPCNT);
#line 2977
    if (realign) {
#line 2977
      xp = tmp;
#line 2977
    } else {
#line 2977
      xp = (float *) *xpp;
#line 2977
    }
#line 2977
   /* copy the next block */
#line 2977
#pragma cdir loopcnt=LOOPCNT
#line 2977
#pragma cdir shortloop
#line 2977
    for (i=0; i<ni; i++) {
#line 2977
      /* the normal case: */
#line 2977
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 2977
     /* test for range errors (not always needed but do it anyway) */
#line 2977
      nrange += tp[i] < X_FLOAT_MIN || tp[i] > X_FLOAT_MAX;
#line 2977
    }
#line 2977
   /* copy workspace back if necessary */ 
#line 2977
    if (realign) {
#line 2977
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 2977
      xp = (float *) *xpp;
#line 2977
    }
#line 2977
   /* update xpp and tp */
#line 2977
    xp += ni;
#line 2977
    tp += ni;
#line 2977
    *xpp = (void*)xp;
#line 2977
  }
#line 2977
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2977

#line 2977
#else   /* not SX */
#line 2977

#line 2977
	char *xp = (char *) *xpp;
#line 2977
	int status = ENOERR;
#line 2977

#line 2977
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2977
	{
#line 2977
		int lstatus = ncx_put_float_uint(xp, tp);
#line 2977
		if(lstatus != ENOERR)
#line 2977
			status = lstatus;
#line 2977
	}
#line 2977

#line 2977
	*xpp = (void *)xp;
#line 2977
	return status;
#line 2977
#endif
#line 2977
}
#line 2977

int
#line 2978
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2978
{
#line 2978
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2978

#line 2978
 /* basic algorithm is:
#line 2978
  *   - ensure sane alignment of output data
#line 2978
  *   - copy (conversion happens automatically) input data
#line 2978
  *     to output
#line 2978
  *   - update tp to point at next unconverted input, and xpp to point
#line 2978
  *     at next location for converted output
#line 2978
  */
#line 2978
  long i, j, ni;
#line 2978
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2978
  float *xp;
#line 2978
  int nrange = 0;         /* number of range errors */
#line 2978
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2978
  long cxp = (long) *((char**)xpp);
#line 2978

#line 2978
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2978
  /* sjl: manually stripmine so we can limit amount of
#line 2978
   * vector work space reserved to LOOPCNT elements. Also
#line 2978
   * makes vectorisation easy */
#line 2978
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2978
    ni=Min(nelems-j,LOOPCNT);
#line 2978
    if (realign) {
#line 2978
      xp = tmp;
#line 2978
    } else {
#line 2978
      xp = (float *) *xpp;
#line 2978
    }
#line 2978
   /* copy the next block */
#line 2978
#pragma cdir loopcnt=LOOPCNT
#line 2978
#pragma cdir shortloop
#line 2978
    for (i=0; i<ni; i++) {
#line 2978
      /* the normal case: */
#line 2978
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 2978
     /* test for range errors (not always needed but do it anyway) */
#line 2978
      nrange += tp[i] < X_FLOAT_MIN || tp[i] > X_FLOAT_MAX;
#line 2978
    }
#line 2978
   /* copy workspace back if necessary */ 
#line 2978
    if (realign) {
#line 2978
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 2978
      xp = (float *) *xpp;
#line 2978
    }
#line 2978
   /* update xpp and tp */
#line 2978
    xp += ni;
#line 2978
    tp += ni;
#line 2978
    *xpp = (void*)xp;
#line 2978
  }
#line 2978
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2978

#line 2978
#else   /* not SX */
#line 2978

#line 2978
	char *xp = (char *) *xpp;
#line 2978
	int status = ENOERR;
#line 2978

#line 2978
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2978
	{
#line 2978
		int lstatus = ncx_put_float_longlong(xp, tp);
#line 2978
		if(lstatus != ENOERR)
#line 2978
			status = lstatus;
#line 2978
	}
#line 2978

#line 2978
	*xpp = (void *)xp;
#line 2978
	return status;
#line 2978
#endif
#line 2978
}
#line 2978

int
#line 2979
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2979
{
#line 2979
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 2979

#line 2979
 /* basic algorithm is:
#line 2979
  *   - ensure sane alignment of output data
#line 2979
  *   - copy (conversion happens automatically) input data
#line 2979
  *     to output
#line 2979
  *   - update tp to point at next unconverted input, and xpp to point
#line 2979
  *     at next location for converted output
#line 2979
  */
#line 2979
  long i, j, ni;
#line 2979
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 2979
  float *xp;
#line 2979
  int nrange = 0;         /* number of range errors */
#line 2979
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2979
  long cxp = (long) *((char**)xpp);
#line 2979

#line 2979
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 2979
  /* sjl: manually stripmine so we can limit amount of
#line 2979
   * vector work space reserved to LOOPCNT elements. Also
#line 2979
   * makes vectorisation easy */
#line 2979
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2979
    ni=Min(nelems-j,LOOPCNT);
#line 2979
    if (realign) {
#line 2979
      xp = tmp;
#line 2979
    } else {
#line 2979
      xp = (float *) *xpp;
#line 2979
    }
#line 2979
   /* copy the next block */
#line 2979
#pragma cdir loopcnt=LOOPCNT
#line 2979
#pragma cdir shortloop
#line 2979
    for (i=0; i<ni; i++) {
#line 2979
      /* the normal case: */
#line 2979
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 2979
     /* test for range errors (not always needed but do it anyway) */
#line 2979
      nrange += tp[i] < X_FLOAT_MIN || tp[i] > X_FLOAT_MAX;
#line 2979
    }
#line 2979
   /* copy workspace back if necessary */ 
#line 2979
    if (realign) {
#line 2979
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 2979
      xp = (float *) *xpp;
#line 2979
    }
#line 2979
   /* update xpp and tp */
#line 2979
    xp += ni;
#line 2979
    tp += ni;
#line 2979
    *xpp = (void*)xp;
#line 2979
  }
#line 2979
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2979

#line 2979
#else   /* not SX */
#line 2979

#line 2979
	char *xp = (char *) *xpp;
#line 2979
	int status = ENOERR;
#line 2979

#line 2979
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 2979
	{
#line 2979
		int lstatus = ncx_put_float_ulonglong(xp, tp);
#line 2979
		if(lstatus != ENOERR)
#line 2979
			status = lstatus;
#line 2979
	}
#line 2979

#line 2979
	*xpp = (void *)xp;
#line 2979
	return status;
#line 2979
#endif
#line 2979
}
#line 2979


/* double */

int
#line 2983
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
#line 2983
{
#line 2983
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 2983

#line 2983
 /* basic algorithm is:
#line 2983
  *   - ensure sane alignment of input data
#line 2983
  *   - copy (conversion happens automatically) input data
#line 2983
  *     to output
#line 2983
  *   - update xpp to point at next unconverted input, and tp to point
#line 2983
  *     at next location for converted output
#line 2983
  */
#line 2983
  long i, j, ni;
#line 2983
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 2983
  double *xp;
#line 2983
  int nrange = 0;         /* number of range errors */
#line 2983
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2983
  long cxp = (long) *((char**)xpp);
#line 2983

#line 2983
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 2983
  /* sjl: manually stripmine so we can limit amount of
#line 2983
   * vector work space reserved to LOOPCNT elements. Also
#line 2983
   * makes vectorisation easy */
#line 2983
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2983
    ni=Min(nelems-j,LOOPCNT);
#line 2983
    if (realign) {
#line 2983
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 2983
      xp = tmp;
#line 2983
    } else {
#line 2983
      xp = (double *) *xpp;
#line 2983
    }
#line 2983
   /* copy the next block */
#line 2983
#pragma cdir loopcnt=LOOPCNT
#line 2983
#pragma cdir shortloop
#line 2983
    for (i=0; i<ni; i++) {
#line 2983
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2983
     /* test for range errors (not always needed but do it anyway) */
#line 2983
      nrange += xp[i] < SCHAR_MIN || xp[i] > SCHAR_MAX;
#line 2983
    }
#line 2983
   /* update xpp and tp */
#line 2983
    if (realign) xp = (double *) *xpp;
#line 2983
    xp += ni;
#line 2983
    tp += ni;
#line 2983
    *xpp = (void*)xp;
#line 2983
  }
#line 2983
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2983

#line 2983
#else   /* not SX */
#line 2983
	const char *xp = (const char *) *xpp;
#line 2983
	int status = ENOERR;
#line 2983

#line 2983
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 2983
	{
#line 2983
		const int lstatus = ncx_get_double_schar(xp, tp);
#line 2983
		if(lstatus != ENOERR)
#line 2983
			status = lstatus;
#line 2983
	}
#line 2983

#line 2983
	*xpp = (const void *)xp;
#line 2983
	return status;
#line 2983
#  endif
#line 2983
}
#line 2983

int
#line 2984
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2984
{
#line 2984
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 2984

#line 2984
 /* basic algorithm is:
#line 2984
  *   - ensure sane alignment of input data
#line 2984
  *   - copy (conversion happens automatically) input data
#line 2984
  *     to output
#line 2984
  *   - update xpp to point at next unconverted input, and tp to point
#line 2984
  *     at next location for converted output
#line 2984
  */
#line 2984
  long i, j, ni;
#line 2984
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 2984
  double *xp;
#line 2984
  int nrange = 0;         /* number of range errors */
#line 2984
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2984
  long cxp = (long) *((char**)xpp);
#line 2984

#line 2984
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 2984
  /* sjl: manually stripmine so we can limit amount of
#line 2984
   * vector work space reserved to LOOPCNT elements. Also
#line 2984
   * makes vectorisation easy */
#line 2984
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2984
    ni=Min(nelems-j,LOOPCNT);
#line 2984
    if (realign) {
#line 2984
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 2984
      xp = tmp;
#line 2984
    } else {
#line 2984
      xp = (double *) *xpp;
#line 2984
    }
#line 2984
   /* copy the next block */
#line 2984
#pragma cdir loopcnt=LOOPCNT
#line 2984
#pragma cdir shortloop
#line 2984
    for (i=0; i<ni; i++) {
#line 2984
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2984
     /* test for range errors (not always needed but do it anyway) */
#line 2984
      nrange += xp[i] < UCHAR_MIN || xp[i] > UCHAR_MAX;
#line 2984
    }
#line 2984
   /* update xpp and tp */
#line 2984
    if (realign) xp = (double *) *xpp;
#line 2984
    xp += ni;
#line 2984
    tp += ni;
#line 2984
    *xpp = (void*)xp;
#line 2984
  }
#line 2984
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2984

#line 2984
#else   /* not SX */
#line 2984
	const char *xp = (const char *) *xpp;
#line 2984
	int status = ENOERR;
#line 2984

#line 2984
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 2984
	{
#line 2984
		const int lstatus = ncx_get_double_uchar(xp, tp);
#line 2984
		if(lstatus != ENOERR)
#line 2984
			status = lstatus;
#line 2984
	}
#line 2984

#line 2984
	*xpp = (const void *)xp;
#line 2984
	return status;
#line 2984
#  endif
#line 2984
}
#line 2984

int
#line 2985
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
#line 2985
{
#line 2985
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 2985

#line 2985
 /* basic algorithm is:
#line 2985
  *   - ensure sane alignment of input data
#line 2985
  *   - copy (conversion happens automatically) input data
#line 2985
  *     to output
#line 2985
  *   - update xpp to point at next unconverted input, and tp to point
#line 2985
  *     at next location for converted output
#line 2985
  */
#line 2985
  long i, j, ni;
#line 2985
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 2985
  double *xp;
#line 2985
  int nrange = 0;         /* number of range errors */
#line 2985
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2985
  long cxp = (long) *((char**)xpp);
#line 2985

#line 2985
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 2985
  /* sjl: manually stripmine so we can limit amount of
#line 2985
   * vector work space reserved to LOOPCNT elements. Also
#line 2985
   * makes vectorisation easy */
#line 2985
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2985
    ni=Min(nelems-j,LOOPCNT);
#line 2985
    if (realign) {
#line 2985
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 2985
      xp = tmp;
#line 2985
    } else {
#line 2985
      xp = (double *) *xpp;
#line 2985
    }
#line 2985
   /* copy the next block */
#line 2985
#pragma cdir loopcnt=LOOPCNT
#line 2985
#pragma cdir shortloop
#line 2985
    for (i=0; i<ni; i++) {
#line 2985
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2985
     /* test for range errors (not always needed but do it anyway) */
#line 2985
      nrange += xp[i] < SHORT_MIN || xp[i] > SHORT_MAX;
#line 2985
    }
#line 2985
   /* update xpp and tp */
#line 2985
    if (realign) xp = (double *) *xpp;
#line 2985
    xp += ni;
#line 2985
    tp += ni;
#line 2985
    *xpp = (void*)xp;
#line 2985
  }
#line 2985
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2985

#line 2985
#else   /* not SX */
#line 2985
	const char *xp = (const char *) *xpp;
#line 2985
	int status = ENOERR;
#line 2985

#line 2985
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 2985
	{
#line 2985
		const int lstatus = ncx_get_double_short(xp, tp);
#line 2985
		if(lstatus != ENOERR)
#line 2985
			status = lstatus;
#line 2985
	}
#line 2985

#line 2985
	*xpp = (const void *)xp;
#line 2985
	return status;
#line 2985
#  endif
#line 2985
}
#line 2985

int
#line 2986
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
#line 2986
{
#line 2986
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 2986

#line 2986
 /* basic algorithm is:
#line 2986
  *   - ensure sane alignment of input data
#line 2986
  *   - copy (conversion happens automatically) input data
#line 2986
  *     to output
#line 2986
  *   - update xpp to point at next unconverted input, and tp to point
#line 2986
  *     at next location for converted output
#line 2986
  */
#line 2986
  long i, j, ni;
#line 2986
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 2986
  double *xp;
#line 2986
  int nrange = 0;         /* number of range errors */
#line 2986
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2986
  long cxp = (long) *((char**)xpp);
#line 2986

#line 2986
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 2986
  /* sjl: manually stripmine so we can limit amount of
#line 2986
   * vector work space reserved to LOOPCNT elements. Also
#line 2986
   * makes vectorisation easy */
#line 2986
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2986
    ni=Min(nelems-j,LOOPCNT);
#line 2986
    if (realign) {
#line 2986
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 2986
      xp = tmp;
#line 2986
    } else {
#line 2986
      xp = (double *) *xpp;
#line 2986
    }
#line 2986
   /* copy the next block */
#line 2986
#pragma cdir loopcnt=LOOPCNT
#line 2986
#pragma cdir shortloop
#line 2986
    for (i=0; i<ni; i++) {
#line 2986
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2986
     /* test for range errors (not always needed but do it anyway) */
#line 2986
      nrange += xp[i] < INT_MIN || xp[i] > INT_MAX;
#line 2986
    }
#line 2986
   /* update xpp and tp */
#line 2986
    if (realign) xp = (double *) *xpp;
#line 2986
    xp += ni;
#line 2986
    tp += ni;
#line 2986
    *xpp = (void*)xp;
#line 2986
  }
#line 2986
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2986

#line 2986
#else   /* not SX */
#line 2986
	const char *xp = (const char *) *xpp;
#line 2986
	int status = ENOERR;
#line 2986

#line 2986
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 2986
	{
#line 2986
		const int lstatus = ncx_get_double_int(xp, tp);
#line 2986
		if(lstatus != ENOERR)
#line 2986
			status = lstatus;
#line 2986
	}
#line 2986

#line 2986
	*xpp = (const void *)xp;
#line 2986
	return status;
#line 2986
#  endif
#line 2986
}
#line 2986

int
#line 2987
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
#line 2987
{
#line 2987
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 2987

#line 2987
 /* basic algorithm is:
#line 2987
  *   - ensure sane alignment of input data
#line 2987
  *   - copy (conversion happens automatically) input data
#line 2987
  *     to output
#line 2987
  *   - update xpp to point at next unconverted input, and tp to point
#line 2987
  *     at next location for converted output
#line 2987
  */
#line 2987
  long i, j, ni;
#line 2987
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 2987
  double *xp;
#line 2987
  int nrange = 0;         /* number of range errors */
#line 2987
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2987
  long cxp = (long) *((char**)xpp);
#line 2987

#line 2987
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 2987
  /* sjl: manually stripmine so we can limit amount of
#line 2987
   * vector work space reserved to LOOPCNT elements. Also
#line 2987
   * makes vectorisation easy */
#line 2987
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2987
    ni=Min(nelems-j,LOOPCNT);
#line 2987
    if (realign) {
#line 2987
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 2987
      xp = tmp;
#line 2987
    } else {
#line 2987
      xp = (double *) *xpp;
#line 2987
    }
#line 2987
   /* copy the next block */
#line 2987
#pragma cdir loopcnt=LOOPCNT
#line 2987
#pragma cdir shortloop
#line 2987
    for (i=0; i<ni; i++) {
#line 2987
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2987
     /* test for range errors (not always needed but do it anyway) */
#line 2987
      nrange += xp[i] < FLOAT_MIN || xp[i] > FLOAT_MAX;
#line 2987
    }
#line 2987
   /* update xpp and tp */
#line 2987
    if (realign) xp = (double *) *xpp;
#line 2987
    xp += ni;
#line 2987
    tp += ni;
#line 2987
    *xpp = (void*)xp;
#line 2987
  }
#line 2987
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2987

#line 2987
#else   /* not SX */
#line 2987
	const char *xp = (const char *) *xpp;
#line 2987
	int status = ENOERR;
#line 2987

#line 2987
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 2987
	{
#line 2987
		const int lstatus = ncx_get_double_float(xp, tp);
#line 2987
		if(lstatus != ENOERR)
#line 2987
			status = lstatus;
#line 2987
	}
#line 2987

#line 2987
	*xpp = (const void *)xp;
#line 2987
	return status;
#line 2987
#  endif
#line 2987
}
#line 2987

#line 2989
int
#line 2989
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
#line 2989
{
#line 2989
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 2989

#line 2989
 /* basic algorithm is:
#line 2989
  *   - ensure sane alignment of input data
#line 2989
  *   - copy (conversion happens automatically) input data
#line 2989
  *     to output
#line 2989
  *   - update xpp to point at next unconverted input, and tp to point
#line 2989
  *     at next location for converted output
#line 2989
  */
#line 2989
  long i, j, ni;
#line 2989
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 2989
  double *xp;
#line 2989
  int nrange = 0;         /* number of range errors */
#line 2989
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2989
  long cxp = (long) *((char**)xpp);
#line 2989

#line 2989
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 2989
  /* sjl: manually stripmine so we can limit amount of
#line 2989
   * vector work space reserved to LOOPCNT elements. Also
#line 2989
   * makes vectorisation easy */
#line 2989
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2989
    ni=Min(nelems-j,LOOPCNT);
#line 2989
    if (realign) {
#line 2989
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 2989
      xp = tmp;
#line 2989
    } else {
#line 2989
      xp = (double *) *xpp;
#line 2989
    }
#line 2989
   /* copy the next block */
#line 2989
#pragma cdir loopcnt=LOOPCNT
#line 2989
#pragma cdir shortloop
#line 2989
    for (i=0; i<ni; i++) {
#line 2989
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2989
     /* test for range errors (not always needed but do it anyway) */
#line 2989
      nrange += xp[i] < UINT_MIN || xp[i] > UINT_MAX;
#line 2989
    }
#line 2989
   /* update xpp and tp */
#line 2989
    if (realign) xp = (double *) *xpp;
#line 2989
    xp += ni;
#line 2989
    tp += ni;
#line 2989
    *xpp = (void*)xp;
#line 2989
  }
#line 2989
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2989

#line 2989
#else   /* not SX */
#line 2989
	const char *xp = (const char *) *xpp;
#line 2989
	int status = ENOERR;
#line 2989

#line 2989
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 2989
	{
#line 2989
		const int lstatus = ncx_get_double_uint(xp, tp);
#line 2989
		if(lstatus != ENOERR)
#line 2989
			status = lstatus;
#line 2989
	}
#line 2989

#line 2989
	*xpp = (const void *)xp;
#line 2989
	return status;
#line 2989
#  endif
#line 2989
}
#line 2989

int
#line 2990
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2990
{
#line 2990
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 2990

#line 2990
 /* basic algorithm is:
#line 2990
  *   - ensure sane alignment of input data
#line 2990
  *   - copy (conversion happens automatically) input data
#line 2990
  *     to output
#line 2990
  *   - update xpp to point at next unconverted input, and tp to point
#line 2990
  *     at next location for converted output
#line 2990
  */
#line 2990
  long i, j, ni;
#line 2990
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 2990
  double *xp;
#line 2990
  int nrange = 0;         /* number of range errors */
#line 2990
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2990
  long cxp = (long) *((char**)xpp);
#line 2990

#line 2990
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 2990
  /* sjl: manually stripmine so we can limit amount of
#line 2990
   * vector work space reserved to LOOPCNT elements. Also
#line 2990
   * makes vectorisation easy */
#line 2990
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2990
    ni=Min(nelems-j,LOOPCNT);
#line 2990
    if (realign) {
#line 2990
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 2990
      xp = tmp;
#line 2990
    } else {
#line 2990
      xp = (double *) *xpp;
#line 2990
    }
#line 2990
   /* copy the next block */
#line 2990
#pragma cdir loopcnt=LOOPCNT
#line 2990
#pragma cdir shortloop
#line 2990
    for (i=0; i<ni; i++) {
#line 2990
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2990
     /* test for range errors (not always needed but do it anyway) */
#line 2990
      nrange += xp[i] < LONGLONG_MIN || xp[i] > LONGLONG_MAX;
#line 2990
    }
#line 2990
   /* update xpp and tp */
#line 2990
    if (realign) xp = (double *) *xpp;
#line 2990
    xp += ni;
#line 2990
    tp += ni;
#line 2990
    *xpp = (void*)xp;
#line 2990
  }
#line 2990
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2990

#line 2990
#else   /* not SX */
#line 2990
	const char *xp = (const char *) *xpp;
#line 2990
	int status = ENOERR;
#line 2990

#line 2990
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 2990
	{
#line 2990
		const int lstatus = ncx_get_double_longlong(xp, tp);
#line 2990
		if(lstatus != ENOERR)
#line 2990
			status = lstatus;
#line 2990
	}
#line 2990

#line 2990
	*xpp = (const void *)xp;
#line 2990
	return status;
#line 2990
#  endif
#line 2990
}
#line 2990

int
#line 2991
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2991
{
#line 2991
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 2991

#line 2991
 /* basic algorithm is:
#line 2991
  *   - ensure sane alignment of input data
#line 2991
  *   - copy (conversion happens automatically) input data
#line 2991
  *     to output
#line 2991
  *   - update xpp to point at next unconverted input, and tp to point
#line 2991
  *     at next location for converted output
#line 2991
  */
#line 2991
  long i, j, ni;
#line 2991
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 2991
  double *xp;
#line 2991
  int nrange = 0;         /* number of range errors */
#line 2991
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2991
  long cxp = (long) *((char**)xpp);
#line 2991

#line 2991
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 2991
  /* sjl: manually stripmine so we can limit amount of
#line 2991
   * vector work space reserved to LOOPCNT elements. Also
#line 2991
   * makes vectorisation easy */
#line 2991
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2991
    ni=Min(nelems-j,LOOPCNT);
#line 2991
    if (realign) {
#line 2991
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 2991
      xp = tmp;
#line 2991
    } else {
#line 2991
      xp = (double *) *xpp;
#line 2991
    }
#line 2991
   /* copy the next block */
#line 2991
#pragma cdir loopcnt=LOOPCNT
#line 2991
#pragma cdir shortloop
#line 2991
    for (i=0; i<ni; i++) {
#line 2991
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2991
     /* test for range errors (not always needed but do it anyway) */
#line 2991
      nrange += xp[i] < ULONGLONG_MIN || xp[i] > ULONGLONG_MAX;
#line 2991
    }
#line 2991
   /* update xpp and tp */
#line 2991
    if (realign) xp = (double *) *xpp;
#line 2991
    xp += ni;
#line 2991
    tp += ni;
#line 2991
    *xpp = (void*)xp;
#line 2991
  }
#line 2991
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 2991

#line 2991
#else   /* not SX */
#line 2991
	const char *xp = (const char *) *xpp;
#line 2991
	int status = ENOERR;
#line 2991

#line 2991
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 2991
	{
#line 2991
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
#line 2991
		if(lstatus != ENOERR)
#line 2991
			status = lstatus;
#line 2991
	}
#line 2991

#line 2991
	*xpp = (const void *)xp;
#line 2991
	return status;
#line 2991
#  endif
#line 2991
}
#line 2991

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(double));
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return ENOERR;
}
#elif vax
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while(ip < end)
	{
	struct vax_double *const vdp =
#line 3013
			 (struct vax_double *)ip;
#line 3013
	const struct ieee_double *const idp =
#line 3013
			 (const struct ieee_double *) (*xpp);
#line 3013
	{
#line 3013
		const struct dbl_limits *lim;
#line 3013
		int ii;
#line 3013
		for (ii = 0, lim = dbl_limits;
#line 3013
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 3013
			ii++, lim++)
#line 3013
		{
#line 3013
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 3013
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 3013
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 3013
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 3013
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 3013
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 3013
				)
#line 3013
			{
#line 3013
				*vdp = lim->d;
#line 3013
				goto doneit;
#line 3013
			}
#line 3013
		}
#line 3013
	}
#line 3013
	{
#line 3013
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 3013
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 3013
	}
#line 3013
	{
#line 3013
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 3013
				 | (idp->mant_5 << 8)
#line 3013
				 | idp->mant_4);
#line 3013
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 3013
		vdp->mantissa1 = (mant_hi >> 13);
#line 3013
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 3013
				| (mant_lo >> 29);
#line 3013
		vdp->mantissa3 = (mant_lo >> 13);
#line 3013
		vdp->mantissa4 = (mant_lo << 3);
#line 3013
	}
#line 3013
	doneit:
#line 3013
		vdp->sign = idp->sign;
#line 3013

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return ENOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif

int
#line 3040
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp)
#line 3040
{
#line 3040
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3040

#line 3040
 /* basic algorithm is:
#line 3040
  *   - ensure sane alignment of output data
#line 3040
  *   - copy (conversion happens automatically) input data
#line 3040
  *     to output
#line 3040
  *   - update tp to point at next unconverted input, and xpp to point
#line 3040
  *     at next location for converted output
#line 3040
  */
#line 3040
  long i, j, ni;
#line 3040
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3040
  double *xp;
#line 3040
  int nrange = 0;         /* number of range errors */
#line 3040
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3040
  long cxp = (long) *((char**)xpp);
#line 3040

#line 3040
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3040
  /* sjl: manually stripmine so we can limit amount of
#line 3040
   * vector work space reserved to LOOPCNT elements. Also
#line 3040
   * makes vectorisation easy */
#line 3040
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3040
    ni=Min(nelems-j,LOOPCNT);
#line 3040
    if (realign) {
#line 3040
      xp = tmp;
#line 3040
    } else {
#line 3040
      xp = (double *) *xpp;
#line 3040
    }
#line 3040
   /* copy the next block */
#line 3040
#pragma cdir loopcnt=LOOPCNT
#line 3040
#pragma cdir shortloop
#line 3040
    for (i=0; i<ni; i++) {
#line 3040
      /* the normal case: */
#line 3040
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3040
     /* test for range errors (not always needed but do it anyway) */
#line 3040
      nrange += tp[i] < X_DOUBLE_MIN || tp[i] > X_DOUBLE_MAX;
#line 3040
    }
#line 3040
   /* copy workspace back if necessary */ 
#line 3040
    if (realign) {
#line 3040
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3040
      xp = (double *) *xpp;
#line 3040
    }
#line 3040
   /* update xpp and tp */
#line 3040
    xp += ni;
#line 3040
    tp += ni;
#line 3040
    *xpp = (void*)xp;
#line 3040
  }
#line 3040
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 3040

#line 3040
#else   /* not SX */
#line 3040

#line 3040
	char *xp = (char *) *xpp;
#line 3040
	int status = ENOERR;
#line 3040

#line 3040
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3040
	{
#line 3040
		int lstatus = ncx_put_double_schar(xp, tp);
#line 3040
		if(lstatus != ENOERR)
#line 3040
			status = lstatus;
#line 3040
	}
#line 3040

#line 3040
	*xpp = (void *)xp;
#line 3040
	return status;
#line 3040
#endif
#line 3040
}
#line 3040

int
#line 3041
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 3041
{
#line 3041
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3041

#line 3041
 /* basic algorithm is:
#line 3041
  *   - ensure sane alignment of output data
#line 3041
  *   - copy (conversion happens automatically) input data
#line 3041
  *     to output
#line 3041
  *   - update tp to point at next unconverted input, and xpp to point
#line 3041
  *     at next location for converted output
#line 3041
  */
#line 3041
  long i, j, ni;
#line 3041
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3041
  double *xp;
#line 3041
  int nrange = 0;         /* number of range errors */
#line 3041
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3041
  long cxp = (long) *((char**)xpp);
#line 3041

#line 3041
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3041
  /* sjl: manually stripmine so we can limit amount of
#line 3041
   * vector work space reserved to LOOPCNT elements. Also
#line 3041
   * makes vectorisation easy */
#line 3041
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3041
    ni=Min(nelems-j,LOOPCNT);
#line 3041
    if (realign) {
#line 3041
      xp = tmp;
#line 3041
    } else {
#line 3041
      xp = (double *) *xpp;
#line 3041
    }
#line 3041
   /* copy the next block */
#line 3041
#pragma cdir loopcnt=LOOPCNT
#line 3041
#pragma cdir shortloop
#line 3041
    for (i=0; i<ni; i++) {
#line 3041
      /* the normal case: */
#line 3041
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3041
     /* test for range errors (not always needed but do it anyway) */
#line 3041
      nrange += tp[i] < X_DOUBLE_MIN || tp[i] > X_DOUBLE_MAX;
#line 3041
    }
#line 3041
   /* copy workspace back if necessary */ 
#line 3041
    if (realign) {
#line 3041
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3041
      xp = (double *) *xpp;
#line 3041
    }
#line 3041
   /* update xpp and tp */
#line 3041
    xp += ni;
#line 3041
    tp += ni;
#line 3041
    *xpp = (void*)xp;
#line 3041
  }
#line 3041
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 3041

#line 3041
#else   /* not SX */
#line 3041

#line 3041
	char *xp = (char *) *xpp;
#line 3041
	int status = ENOERR;
#line 3041

#line 3041
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3041
	{
#line 3041
		int lstatus = ncx_put_double_uchar(xp, tp);
#line 3041
		if(lstatus != ENOERR)
#line 3041
			status = lstatus;
#line 3041
	}
#line 3041

#line 3041
	*xpp = (void *)xp;
#line 3041
	return status;
#line 3041
#endif
#line 3041
}
#line 3041

int
#line 3042
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp)
#line 3042
{
#line 3042
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3042

#line 3042
 /* basic algorithm is:
#line 3042
  *   - ensure sane alignment of output data
#line 3042
  *   - copy (conversion happens automatically) input data
#line 3042
  *     to output
#line 3042
  *   - update tp to point at next unconverted input, and xpp to point
#line 3042
  *     at next location for converted output
#line 3042
  */
#line 3042
  long i, j, ni;
#line 3042
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3042
  double *xp;
#line 3042
  int nrange = 0;         /* number of range errors */
#line 3042
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3042
  long cxp = (long) *((char**)xpp);
#line 3042

#line 3042
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3042
  /* sjl: manually stripmine so we can limit amount of
#line 3042
   * vector work space reserved to LOOPCNT elements. Also
#line 3042
   * makes vectorisation easy */
#line 3042
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3042
    ni=Min(nelems-j,LOOPCNT);
#line 3042
    if (realign) {
#line 3042
      xp = tmp;
#line 3042
    } else {
#line 3042
      xp = (double *) *xpp;
#line 3042
    }
#line 3042
   /* copy the next block */
#line 3042
#pragma cdir loopcnt=LOOPCNT
#line 3042
#pragma cdir shortloop
#line 3042
    for (i=0; i<ni; i++) {
#line 3042
      /* the normal case: */
#line 3042
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3042
     /* test for range errors (not always needed but do it anyway) */
#line 3042
      nrange += tp[i] < X_DOUBLE_MIN || tp[i] > X_DOUBLE_MAX;
#line 3042
    }
#line 3042
   /* copy workspace back if necessary */ 
#line 3042
    if (realign) {
#line 3042
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3042
      xp = (double *) *xpp;
#line 3042
    }
#line 3042
   /* update xpp and tp */
#line 3042
    xp += ni;
#line 3042
    tp += ni;
#line 3042
    *xpp = (void*)xp;
#line 3042
  }
#line 3042
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 3042

#line 3042
#else   /* not SX */
#line 3042

#line 3042
	char *xp = (char *) *xpp;
#line 3042
	int status = ENOERR;
#line 3042

#line 3042
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3042
	{
#line 3042
		int lstatus = ncx_put_double_short(xp, tp);
#line 3042
		if(lstatus != ENOERR)
#line 3042
			status = lstatus;
#line 3042
	}
#line 3042

#line 3042
	*xpp = (void *)xp;
#line 3042
	return status;
#line 3042
#endif
#line 3042
}
#line 3042

int
#line 3043
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp)
#line 3043
{
#line 3043
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3043

#line 3043
 /* basic algorithm is:
#line 3043
  *   - ensure sane alignment of output data
#line 3043
  *   - copy (conversion happens automatically) input data
#line 3043
  *     to output
#line 3043
  *   - update tp to point at next unconverted input, and xpp to point
#line 3043
  *     at next location for converted output
#line 3043
  */
#line 3043
  long i, j, ni;
#line 3043
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3043
  double *xp;
#line 3043
  int nrange = 0;         /* number of range errors */
#line 3043
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3043
  long cxp = (long) *((char**)xpp);
#line 3043

#line 3043
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3043
  /* sjl: manually stripmine so we can limit amount of
#line 3043
   * vector work space reserved to LOOPCNT elements. Also
#line 3043
   * makes vectorisation easy */
#line 3043
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3043
    ni=Min(nelems-j,LOOPCNT);
#line 3043
    if (realign) {
#line 3043
      xp = tmp;
#line 3043
    } else {
#line 3043
      xp = (double *) *xpp;
#line 3043
    }
#line 3043
   /* copy the next block */
#line 3043
#pragma cdir loopcnt=LOOPCNT
#line 3043
#pragma cdir shortloop
#line 3043
    for (i=0; i<ni; i++) {
#line 3043
      /* the normal case: */
#line 3043
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3043
     /* test for range errors (not always needed but do it anyway) */
#line 3043
      nrange += tp[i] < X_DOUBLE_MIN || tp[i] > X_DOUBLE_MAX;
#line 3043
    }
#line 3043
   /* copy workspace back if necessary */ 
#line 3043
    if (realign) {
#line 3043
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3043
      xp = (double *) *xpp;
#line 3043
    }
#line 3043
   /* update xpp and tp */
#line 3043
    xp += ni;
#line 3043
    tp += ni;
#line 3043
    *xpp = (void*)xp;
#line 3043
  }
#line 3043
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 3043

#line 3043
#else   /* not SX */
#line 3043

#line 3043
	char *xp = (char *) *xpp;
#line 3043
	int status = ENOERR;
#line 3043

#line 3043
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3043
	{
#line 3043
		int lstatus = ncx_put_double_int(xp, tp);
#line 3043
		if(lstatus != ENOERR)
#line 3043
			status = lstatus;
#line 3043
	}
#line 3043

#line 3043
	*xpp = (void *)xp;
#line 3043
	return status;
#line 3043
#endif
#line 3043
}
#line 3043

int
#line 3044
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp)
#line 3044
{
#line 3044
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3044

#line 3044
 /* basic algorithm is:
#line 3044
  *   - ensure sane alignment of output data
#line 3044
  *   - copy (conversion happens automatically) input data
#line 3044
  *     to output
#line 3044
  *   - update tp to point at next unconverted input, and xpp to point
#line 3044
  *     at next location for converted output
#line 3044
  */
#line 3044
  long i, j, ni;
#line 3044
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3044
  double *xp;
#line 3044
  int nrange = 0;         /* number of range errors */
#line 3044
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3044
  long cxp = (long) *((char**)xpp);
#line 3044

#line 3044
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3044
  /* sjl: manually stripmine so we can limit amount of
#line 3044
   * vector work space reserved to LOOPCNT elements. Also
#line 3044
   * makes vectorisation easy */
#line 3044
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3044
    ni=Min(nelems-j,LOOPCNT);
#line 3044
    if (realign) {
#line 3044
      xp = tmp;
#line 3044
    } else {
#line 3044
      xp = (double *) *xpp;
#line 3044
    }
#line 3044
   /* copy the next block */
#line 3044
#pragma cdir loopcnt=LOOPCNT
#line 3044
#pragma cdir shortloop
#line 3044
    for (i=0; i<ni; i++) {
#line 3044
      /* the normal case: */
#line 3044
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3044
     /* test for range errors (not always needed but do it anyway) */
#line 3044
      nrange += tp[i] < X_DOUBLE_MIN || tp[i] > X_DOUBLE_MAX;
#line 3044
    }
#line 3044
   /* copy workspace back if necessary */ 
#line 3044
    if (realign) {
#line 3044
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3044
      xp = (double *) *xpp;
#line 3044
    }
#line 3044
   /* update xpp and tp */
#line 3044
    xp += ni;
#line 3044
    tp += ni;
#line 3044
    *xpp = (void*)xp;
#line 3044
  }
#line 3044
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 3044

#line 3044
#else   /* not SX */
#line 3044

#line 3044
	char *xp = (char *) *xpp;
#line 3044
	int status = ENOERR;
#line 3044

#line 3044
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3044
	{
#line 3044
		int lstatus = ncx_put_double_float(xp, tp);
#line 3044
		if(lstatus != ENOERR)
#line 3044
			status = lstatus;
#line 3044
	}
#line 3044

#line 3044
	*xpp = (void *)xp;
#line 3044
	return status;
#line 3044
#endif
#line 3044
}
#line 3044

#line 3046
int
#line 3046
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp)
#line 3046
{
#line 3046
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3046

#line 3046
 /* basic algorithm is:
#line 3046
  *   - ensure sane alignment of output data
#line 3046
  *   - copy (conversion happens automatically) input data
#line 3046
  *     to output
#line 3046
  *   - update tp to point at next unconverted input, and xpp to point
#line 3046
  *     at next location for converted output
#line 3046
  */
#line 3046
  long i, j, ni;
#line 3046
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3046
  double *xp;
#line 3046
  int nrange = 0;         /* number of range errors */
#line 3046
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3046
  long cxp = (long) *((char**)xpp);
#line 3046

#line 3046
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3046
  /* sjl: manually stripmine so we can limit amount of
#line 3046
   * vector work space reserved to LOOPCNT elements. Also
#line 3046
   * makes vectorisation easy */
#line 3046
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3046
    ni=Min(nelems-j,LOOPCNT);
#line 3046
    if (realign) {
#line 3046
      xp = tmp;
#line 3046
    } else {
#line 3046
      xp = (double *) *xpp;
#line 3046
    }
#line 3046
   /* copy the next block */
#line 3046
#pragma cdir loopcnt=LOOPCNT
#line 3046
#pragma cdir shortloop
#line 3046
    for (i=0; i<ni; i++) {
#line 3046
      /* the normal case: */
#line 3046
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3046
     /* test for range errors (not always needed but do it anyway) */
#line 3046
      nrange += tp[i] < X_DOUBLE_MIN || tp[i] > X_DOUBLE_MAX;
#line 3046
    }
#line 3046
   /* copy workspace back if necessary */ 
#line 3046
    if (realign) {
#line 3046
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3046
      xp = (double *) *xpp;
#line 3046
    }
#line 3046
   /* update xpp and tp */
#line 3046
    xp += ni;
#line 3046
    tp += ni;
#line 3046
    *xpp = (void*)xp;
#line 3046
  }
#line 3046
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 3046

#line 3046
#else   /* not SX */
#line 3046

#line 3046
	char *xp = (char *) *xpp;
#line 3046
	int status = ENOERR;
#line 3046

#line 3046
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3046
	{
#line 3046
		int lstatus = ncx_put_double_uint(xp, tp);
#line 3046
		if(lstatus != ENOERR)
#line 3046
			status = lstatus;
#line 3046
	}
#line 3046

#line 3046
	*xpp = (void *)xp;
#line 3046
	return status;
#line 3046
#endif
#line 3046
}
#line 3046

int
#line 3047
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 3047
{
#line 3047
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3047

#line 3047
 /* basic algorithm is:
#line 3047
  *   - ensure sane alignment of output data
#line 3047
  *   - copy (conversion happens automatically) input data
#line 3047
  *     to output
#line 3047
  *   - update tp to point at next unconverted input, and xpp to point
#line 3047
  *     at next location for converted output
#line 3047
  */
#line 3047
  long i, j, ni;
#line 3047
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3047
  double *xp;
#line 3047
  int nrange = 0;         /* number of range errors */
#line 3047
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3047
  long cxp = (long) *((char**)xpp);
#line 3047

#line 3047
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3047
  /* sjl: manually stripmine so we can limit amount of
#line 3047
   * vector work space reserved to LOOPCNT elements. Also
#line 3047
   * makes vectorisation easy */
#line 3047
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3047
    ni=Min(nelems-j,LOOPCNT);
#line 3047
    if (realign) {
#line 3047
      xp = tmp;
#line 3047
    } else {
#line 3047
      xp = (double *) *xpp;
#line 3047
    }
#line 3047
   /* copy the next block */
#line 3047
#pragma cdir loopcnt=LOOPCNT
#line 3047
#pragma cdir shortloop
#line 3047
    for (i=0; i<ni; i++) {
#line 3047
      /* the normal case: */
#line 3047
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3047
     /* test for range errors (not always needed but do it anyway) */
#line 3047
      nrange += tp[i] < X_DOUBLE_MIN || tp[i] > X_DOUBLE_MAX;
#line 3047
    }
#line 3047
   /* copy workspace back if necessary */ 
#line 3047
    if (realign) {
#line 3047
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3047
      xp = (double *) *xpp;
#line 3047
    }
#line 3047
   /* update xpp and tp */
#line 3047
    xp += ni;
#line 3047
    tp += ni;
#line 3047
    *xpp = (void*)xp;
#line 3047
  }
#line 3047
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 3047

#line 3047
#else   /* not SX */
#line 3047

#line 3047
	char *xp = (char *) *xpp;
#line 3047
	int status = ENOERR;
#line 3047

#line 3047
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3047
	{
#line 3047
		int lstatus = ncx_put_double_longlong(xp, tp);
#line 3047
		if(lstatus != ENOERR)
#line 3047
			status = lstatus;
#line 3047
	}
#line 3047

#line 3047
	*xpp = (void *)xp;
#line 3047
	return status;
#line 3047
#endif
#line 3047
}
#line 3047

int
#line 3048
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 3048
{
#line 3048
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3048

#line 3048
 /* basic algorithm is:
#line 3048
  *   - ensure sane alignment of output data
#line 3048
  *   - copy (conversion happens automatically) input data
#line 3048
  *     to output
#line 3048
  *   - update tp to point at next unconverted input, and xpp to point
#line 3048
  *     at next location for converted output
#line 3048
  */
#line 3048
  long i, j, ni;
#line 3048
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3048
  double *xp;
#line 3048
  int nrange = 0;         /* number of range errors */
#line 3048
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3048
  long cxp = (long) *((char**)xpp);
#line 3048

#line 3048
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3048
  /* sjl: manually stripmine so we can limit amount of
#line 3048
   * vector work space reserved to LOOPCNT elements. Also
#line 3048
   * makes vectorisation easy */
#line 3048
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3048
    ni=Min(nelems-j,LOOPCNT);
#line 3048
    if (realign) {
#line 3048
      xp = tmp;
#line 3048
    } else {
#line 3048
      xp = (double *) *xpp;
#line 3048
    }
#line 3048
   /* copy the next block */
#line 3048
#pragma cdir loopcnt=LOOPCNT
#line 3048
#pragma cdir shortloop
#line 3048
    for (i=0; i<ni; i++) {
#line 3048
      /* the normal case: */
#line 3048
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3048
     /* test for range errors (not always needed but do it anyway) */
#line 3048
      nrange += tp[i] < X_DOUBLE_MIN || tp[i] > X_DOUBLE_MAX;
#line 3048
    }
#line 3048
   /* copy workspace back if necessary */ 
#line 3048
    if (realign) {
#line 3048
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3048
      xp = (double *) *xpp;
#line 3048
    }
#line 3048
   /* update xpp and tp */
#line 3048
    xp += ni;
#line 3048
    tp += ni;
#line 3048
    *xpp = (void*)xp;
#line 3048
  }
#line 3048
  return nrange == 0 ? ENOERR : NC_ERANGE;
#line 3048

#line 3048
#else   /* not SX */
#line 3048

#line 3048
	char *xp = (char *) *xpp;
#line 3048
	int status = ENOERR;
#line 3048

#line 3048
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3048
	{
#line 3048
		int lstatus = ncx_put_double_ulonglong(xp, tp);
#line 3048
		if(lstatus != ENOERR)
#line 3048
			status = lstatus;
#line 3048
	}
#line 3048

#line 3048
	*xpp = (void *)xp;
#line 3048
	return status;
#line 3048
#endif
#line 3048
}
#line 3048

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return ENOERR;
}
#elif vax
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip)
{
	const double *const end = ip + ndoubles;

	while(ip < end)
	{
	const struct vax_double *const vdp = 
#line 3070
			(const struct vax_double *)ip;
#line 3070
	struct ieee_double *const idp =
#line 3070
			 (struct ieee_double *) (*xpp);
#line 3070

#line 3070
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 3070
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 3070
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 3070
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 3070
		(vdp->exp == dbl_limits[0].d.exp))
#line 3070
	{
#line 3070
		*idp = dbl_limits[0].ieee;
#line 3070
		goto shipit;
#line 3070
	}
#line 3070
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 3070
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 3070
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 3070
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 3070
		(vdp->exp == dbl_limits[1].d.exp))
#line 3070
	{
#line 3070
		*idp = dbl_limits[1].ieee;
#line 3070
		goto shipit;
#line 3070
	}
#line 3070

#line 3070
	{
#line 3070
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 3070

#line 3070
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 3070
			(vdp->mantissa3 << 13) |
#line 3070
			((vdp->mantissa4 >> 3) & MASK(13));
#line 3070

#line 3070
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 3070
				 | (vdp->mantissa2 >> 3);
#line 3070

#line 3070
		if((vdp->mantissa4 & 7) > 4)
#line 3070
		{
#line 3070
			/* round up */
#line 3070
			mant_lo++;
#line 3070
			if(mant_lo == 0)
#line 3070
			{
#line 3070
				mant_hi++;
#line 3070
				if(mant_hi > 0xffffff)
#line 3070
				{
#line 3070
					mant_hi = 0;
#line 3070
					exp++;
#line 3070
				}
#line 3070
			}
#line 3070
		}
#line 3070

#line 3070
		idp->mant_lo = SWAP4(mant_lo);
#line 3070
		idp->mant_6 = mant_hi >> 16;
#line 3070
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 3070
		idp->mant_4 = mant_hi;
#line 3070
		idp->exp_hi = exp >> 4;
#line 3070
		idp->exp_lo = exp;
#line 3070
	}
#line 3070
		
#line 3070
	shipit:
#line 3070
		idp->sign = vdp->sign;
#line 3070

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return ENOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp)
{
	char *xp = *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}

#endif


/*
 * Other aggregate conversion functions.
 */

/* text */

int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
{
	(void) memcpy(tp, *xpp, nelems);
#line 3107
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3107
	return ENOERR;
#line 3107

}

int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3113

#line 3113
	if(rndup)
#line 3113
		rndup = X_ALIGN - rndup;
#line 3113

#line 3113
	(void) memcpy(tp, *xpp, nelems);
#line 3113
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3113

#line 3113
	return ENOERR;
#line 3113

}

int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
{
	(void) memcpy(*xpp, tp, nelems);
#line 3119
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3119

#line 3119
	return ENOERR;
#line 3119

}

int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3125

#line 3125
	if(rndup)
#line 3125
		rndup = X_ALIGN - rndup;
#line 3125

#line 3125
	(void) memcpy(*xpp, tp, nelems);
#line 3125
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3125

#line 3125
	if(rndup)
#line 3125
	{
#line 3125
		(void) memcpy(*xpp, nada, rndup);
#line 3125
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3125
	}
#line 3125
	
#line 3125
	return ENOERR;
#line 3125

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, nelems);
#line 3134
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3134
	return ENOERR;
#line 3134

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3140

#line 3140
	if(rndup)
#line 3140
		rndup = X_ALIGN - rndup;
#line 3140

#line 3140
	(void) memcpy(tp, *xpp, nelems);
#line 3140
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3140

#line 3140
	return ENOERR;
#line 3140

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, nelems);
#line 3146
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3146

#line 3146
	return ENOERR;
#line 3146

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3152

#line 3152
	if(rndup)
#line 3152
		rndup = X_ALIGN - rndup;
#line 3152

#line 3152
	(void) memcpy(*xpp, tp, nelems);
#line 3152
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3152

#line 3152
	if(rndup)
#line 3152
	{
#line 3152
		(void) memcpy(*xpp, nada, rndup);
#line 3152
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3152
	}
#line 3152
	
#line 3152
	return ENOERR;
#line 3152

}
