
/** @file transc_fct_A.h
 *
 * Interface to transcendental_fct_type_A
 *
 */

/*
 *  Copyright (C) 2001 Stefan Weinzierl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __NESTEDSUMS_TRANSC_FCT_A_H__
#define __NESTEDSUMS_TRANSC_FCT_A_H__

#include "ginac/ginac.h"

namespace nestedsums {

  /// The class transcendental_fct_type_A provides an interface
  /// to the class transcendental_sum_type_A.
  /**
   *
   *  The definition is 
   *  \f[
   *     \frac{\Gamma(d_1) ... \Gamma(d_n)}{\Gamma(d_1') ... \Gamma(d_{n'}')} 
   *      \sum\limits_{i=0}^\infty \frac{\Gamma(i+a_1) ... \Gamma(i+a_k)}{\Gamma(i+a_1') ... \Gamma(i+a_{k-1}')} \frac{x^i}{i!}
   *  \f]
   *
   */
  class transcendental_fct_type_A : public GiNaC::basic
    {
      GINAC_DECLARE_REGISTERED_CLASS(transcendental_fct_type_A, GiNaC::basic)

	// ctors
    public:
      transcendental_fct_type_A(const GiNaC::ex & xx, const GiNaC::ex & ii_num, const GiNaC::ex & ii_denom, const GiNaC::ex & pp_num, const GiNaC::ex & pp_denom);
      transcendental_fct_type_A(const GiNaC::ex & xx, const GiNaC::ex & ii_num, const GiNaC::ex & ii_denom, const GiNaC::ex & pp_num, const GiNaC::ex & pp_denom, const GiNaC::ex & eps, int o, int f);

	// functions overriding virtual functions from base classes
    public:
      void archive(GiNaC::archive_node &node) const;
      void read_archive(const GiNaC::archive_node &node, GiNaC::lst &sym_lst);

      unsigned return_type(void) const { return GiNaC::return_types::noncommutative; }

      void print(const GiNaC::print_context & c, unsigned level = 0) const;
      unsigned precedence(void) const {return 40;}
      GiNaC::ex eval(int level = 0) const;
      GiNaC::ex subs(const GiNaC::exmap & m, unsigned options = 0) const;

    protected:
      GiNaC::ex eval_ncmul(const GiNaC::exvector & v) const;
      GiNaC::ex derivative(const GiNaC::symbol & s) const;
      unsigned calchash(void) const;

	// non-virtual functions 
    public:
      GiNaC::ex set_expansion(const GiNaC::ex & eps, int o) const;

	// member variables :

    protected:

      GiNaC::ex x;
      GiNaC::ex i_num;
      GiNaC::ex i_denom;
      GiNaC::ex pre_num;
      GiNaC::ex pre_denom;

      GiNaC::ex expansion_parameter;

      int order;

      mutable int flag_expand_status;
    };

GINAC_DECLARE_UNARCHIVER(transcendental_fct_type_A);

  /**
   *
   * Named ctor on the heap.
   *
   */
inline GiNaC::ex create_transcendental_fct_type_A(const GiNaC::ex & xx, const GiNaC::ex & ii_num, const GiNaC::ex & ii_denom, const GiNaC::ex & pp_num, const GiNaC::ex & pp_denom)
  {
    return (new transcendental_fct_type_A(xx,ii_num,ii_denom,pp_num,pp_denom))->setflag(GiNaC::status_flags::dynallocated);
  }

  /**
   *
   * Named ctor on the heap.
   *
   */
inline GiNaC::ex create_transcendental_fct_type_A(const GiNaC::ex & xx, const GiNaC::ex & ii_num, const GiNaC::ex & ii_denom, const GiNaC::ex & pp_num, const GiNaC::ex & pp_denom, const GiNaC::ex & eps, int o, int f)
  {
    return (new transcendental_fct_type_A(xx,ii_num,ii_denom,pp_num,pp_denom,eps,o,f))->setflag(GiNaC::status_flags::dynallocated);
  }

} // namespace nestedsums

#endif // ndef __NESTEDSUMS_TRANSC_FCT_A_H__
