set(LUV_INCLUDE_FLAGS
  "-I${DEPS_INSTALL_DIR}/include -I${DEPS_INSTALL_DIR}/include/luajit-2.1")

set(LUV_CMAKE_ARGS
  -DCMAKE_GENERATOR=${CMAKE_GENERATOR}
  -DCMAKE_C_COMPILER=${CMAKE_C_COMPILER}
  -DCMAKE_GENERATOR_PLATFORM=${CMAKE_GENERATOR_PLATFORM}
  ${BUILD_TYPE_STRING}
  -DCMAKE_INSTALL_PREFIX=${DEPS_INSTALL_DIR}
  -DLUA_BUILD_TYPE=System
  -DLUA_COMPAT53_DIR=${DEPS_BUILD_DIR}/src/lua-compat-5.3
  -DWITH_SHARED_LIBUV=ON
  -DBUILD_SHARED_LIBS=OFF
  -DBUILD_STATIC_LIBS=ON
  -DBUILD_MODULE=OFF
  -DCMAKE_POSITION_INDEPENDENT_CODE=ON)

if(USE_BUNDLED_LUAJIT)
  list(APPEND LUV_CMAKE_ARGS -DWITH_LUA_ENGINE=LuaJit)
elseif(USE_BUNDLED_LUA)
  list(APPEND LUV_CMAKE_ARGS -DWITH_LUA_ENGINE=Lua)
else()
  find_package(LuaJit)
  if(LUAJIT_FOUND)
    list(APPEND LUV_CMAKE_ARGS -DWITH_LUA_ENGINE=LuaJit)
  else()
    list(APPEND LUV_CMAKE_ARGS -DWITH_LUA_ENGINE=Lua)
  endif()
endif()

if(USE_BUNDLED_LIBUV)
  list(APPEND LUV_CMAKE_ARGS
    -DCMAKE_PREFIX_PATH=${DEPS_INSTALL_DIR}
    -DLIBUV_LIBRARIES=uv_a)
endif()

list(APPEND LUV_CMAKE_ARGS
  "-DCMAKE_C_FLAGS:STRING=${LUV_INCLUDE_FLAGS}")
if(CMAKE_GENERATOR MATCHES "Unix Makefiles" AND
    (CMAKE_SYSTEM_NAME MATCHES ".*BSD" OR CMAKE_SYSTEM_NAME MATCHES "DragonFly"))
    list(APPEND LUV_CMAKE_ARGS -DCMAKE_MAKE_PROGRAM=gmake)
endif()

if(USE_EXISTING_SRC_DIR)
  unset(LUA_COMPAT53_URL)
endif()
ExternalProject_Add(lua-compat-5.3
  URL ${LUA_COMPAT53_URL}
  URL_HASH SHA256=${LUA_COMPAT53_SHA256}
  DOWNLOAD_NO_PROGRESS TRUE
  DOWNLOAD_DIR ${DEPS_DOWNLOAD_DIR}/lua-compat-5.3
  CONFIGURE_COMMAND ""
  BUILD_COMMAND ""
  INSTALL_COMMAND "")

if(USE_EXISTING_SRC_DIR)
  unset(LUV_URL)
endif()
ExternalProject_Add(luv-static
  DEPENDS lua-compat-5.3
  URL ${LUV_URL}
  URL_HASH SHA256=${LUV_SHA256}
  DOWNLOAD_NO_PROGRESS TRUE
  DOWNLOAD_DIR ${DEPS_DOWNLOAD_DIR}/luv
  SOURCE_DIR ${DEPS_BUILD_DIR}/src/luv
  CMAKE_ARGS ${LUV_CMAKE_ARGS}
  CMAKE_CACHE_ARGS
    -DCMAKE_OSX_ARCHITECTURES:STRING=${CMAKE_OSX_ARCHITECTURES})

list(APPEND THIRD_PARTY_DEPS luv-static)
if(USE_BUNDLED_LUAJIT)
  add_dependencies(luv-static luajit)
elseif(USE_BUNDLED_LUA)
  add_dependencies(luv-static lua)
endif()
if(USE_BUNDLED_LIBUV)
  add_dependencies(luv-static libuv)
endif()
