///////////////////////////////////////////////////////////////////////////////
//
// File: NodalTetSPIData.h
//
// For more information, please see: http://www.nektar.info
//
// The MIT License
//
// Copyright (c) 2006 Division of Applied Mathematics, Brown University (USA),
// Department of Aeronautics, Imperial College London (UK), and Scientific
// Computing and Imaging Institute, University of Utah (USA).
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
// Description: Nodal tetrahedron SPI points data
//
///////////////////////////////////////////////////////////////////////////////

#ifndef NODALTETSPIDATA_H
#define NODALTETSPIDATA_H

namespace Nektar
{
namespace LibUtilities
{
const size_t NodalTetSPIAvailable                         = 10;
static const size_t NodalTetSPINPTS[NodalTetSPIAvailable] = {
    1, 4, 8, 14, 14, 28, 36, 81, 121, 180};
static const NekDouble NodalTetSPIData[][4] = {
    // %%% x y w
    // 1 1 %%% Order / Number of Points
    {-0.5, -0.5, -0.5, 1.3333333333333333333333333333333333333},
    // 2 4 %%% Order / Number of Points
    {-0.72360679774997896964091736687312762354,
     -0.72360679774997896964091736687312762354,
     0.17082039324993690892275210061938287063,
     0.33333333333333333333333333333333333333},
    {-0.72360679774997896964091736687312762354,
     0.17082039324993690892275210061938287063,
     -0.72360679774997896964091736687312762354,
     0.33333333333333333333333333333333333333},
    {0.17082039324993690892275210061938287063,
     -0.72360679774997896964091736687312762354,
     -0.72360679774997896964091736687312762354,
     0.33333333333333333333333333333333333333},
    {-0.72360679774997896964091736687312762354,
     -0.72360679774997896964091736687312762354,
     -0.72360679774997896964091736687312762354,
     0.33333333333333333333333333333333333333},
    // 3 8 %%% Order / Number of Points
    {-0.34367339496723662642072827083693243093,
     -0.34367339496723662642072827083693243093,
     -0.9689798150982901207378151874892027072,
     0.18162379004944980942342872025562069427},
    {-0.34367339496723662642072827083693243093,
     -0.9689798150982901207378151874892027072,
     -0.34367339496723662642072827083693243093,
     0.18162379004944980942342872025562069427},
    {-0.9689798150982901207378151874892027072,
     -0.34367339496723662642072827083693243093,
     -0.34367339496723662642072827083693243093,
     0.18162379004944980942342872025562069427},
    {-0.34367339496723662642072827083693243093,
     -0.34367339496723662642072827083693243093,
     -0.34367339496723662642072827083693243093,
     0.18162379004944980942342872025562069427},
    {-0.78390550020314279176487322158837338344,
     -0.78390550020314279176487322158837338344,
     0.35171650060942837529461966476512015033,
     0.15170954328388352390990461307771263906},
    {-0.78390550020314279176487322158837338344,
     0.35171650060942837529461966476512015033,
     -0.78390550020314279176487322158837338344,
     0.15170954328388352390990461307771263906},
    {0.35171650060942837529461966476512015033,
     -0.78390550020314279176487322158837338344,
     -0.78390550020314279176487322158837338344,
     0.15170954328388352390990461307771263906},
    {-0.78390550020314279176487322158837338344,
     -0.78390550020314279176487322158837338344,
     -0.78390550020314279176487322158837338344,
     0.15170954328388352390990461307771263906},
    // 4 14 %%% Order / Number of Points
    {-0.37822816147339878040530853247308433401,
     -0.37822816147339878040530853247308433401,
     -0.86531551557980365878407440258074699796,
     0.15025056762402113439891420311104844508},
    {-0.37822816147339878040530853247308433401,
     -0.86531551557980365878407440258074699796,
     -0.37822816147339878040530853247308433401,
     0.15025056762402113439891420311104844508},
    {-0.86531551557980365878407440258074699796,
     -0.37822816147339878040530853247308433401,
     -0.37822816147339878040530853247308433401,
     0.15025056762402113439891420311104844508},
    {-0.37822816147339878040530853247308433401,
     -0.37822816147339878040530853247308433401,
     -0.37822816147339878040530853247308433401,
     0.15025056762402113439891420311104844508},
    {-0.81452949937821754719535217252593878951,
     -0.81452949937821754719535217252593878951,
     0.44358849813465264158605651757781636853,
     0.097990724155149266058280273981770004697},
    {-0.81452949937821754719535217252593878951,
     0.44358849813465264158605651757781636853,
     -0.81452949937821754719535217252593878951,
     0.097990724155149266058280273981770004697},
    {0.44358849813465264158605651757781636853,
     -0.81452949937821754719535217252593878951,
     -0.81452949937821754719535217252593878951,
     0.097990724155149266058280273981770004697},
    {-0.81452949937821754719535217252593878951,
     -0.81452949937821754719535217252593878951,
     -0.81452949937821754719535217252593878951,
     0.097990724155149266058280273981770004697},
    {-0.90899259174870070101623894744132112187,
     -0.091007408251299298983761052558678878131,
     -0.091007408251299298983761052558678878131,
     0.05672802770277528858409257082700992237},
    {-0.091007408251299298983761052558678878131,
     -0.90899259174870070101623894744132112187,
     -0.091007408251299298983761052558678878131,
     0.05672802770277528858409257082700992237},
    {-0.90899259174870070101623894744132112187,
     -0.90899259174870070101623894744132112187,
     -0.091007408251299298983761052558678878131,
     0.05672802770277528858409257082700992237},
    {-0.90899259174870070101623894744132112187,
     -0.091007408251299298983761052558678878131,
     -0.90899259174870070101623894744132112187,
     0.05672802770277528858409257082700992237},
    {-0.091007408251299298983761052558678878131,
     -0.90899259174870070101623894744132112187,
     -0.90899259174870070101623894744132112187,
     0.05672802770277528858409257082700992237},
    {-0.091007408251299298983761052558678878131,
     -0.091007408251299298983761052558678878131,
     -0.90899259174870070101623894744132112187,
     0.05672802770277528858409257082700992237},
    // 5 14 %%% Order / Number of Points
    {-0.37822816147339878040530853247308433401,
     -0.37822816147339878040530853247308433401,
     -0.86531551557980365878407440258074699796,
     0.15025056762402113439891420311104844508},
    {-0.37822816147339878040530853247308433401,
     -0.86531551557980365878407440258074699796,
     -0.37822816147339878040530853247308433401,
     0.15025056762402113439891420311104844508},
    {-0.86531551557980365878407440258074699796,
     -0.37822816147339878040530853247308433401,
     -0.37822816147339878040530853247308433401,
     0.15025056762402113439891420311104844508},
    {-0.37822816147339878040530853247308433401,
     -0.37822816147339878040530853247308433401,
     -0.37822816147339878040530853247308433401,
     0.15025056762402113439891420311104844508},
    {-0.81452949937821754719535217252593878951,
     -0.81452949937821754719535217252593878951,
     0.44358849813465264158605651757781636853,
     0.097990724155149266058280273981770004697},
    {-0.81452949937821754719535217252593878951,
     0.44358849813465264158605651757781636853,
     -0.81452949937821754719535217252593878951,
     0.097990724155149266058280273981770004697},
    {0.44358849813465264158605651757781636853,
     -0.81452949937821754719535217252593878951,
     -0.81452949937821754719535217252593878951,
     0.097990724155149266058280273981770004697},
    {-0.81452949937821754719535217252593878951,
     -0.81452949937821754719535217252593878951,
     -0.81452949937821754719535217252593878951,
     0.097990724155149266058280273981770004697},
    {-0.90899259174870070101623894744132112187,
     -0.091007408251299298983761052558678878131,
     -0.091007408251299298983761052558678878131,
     0.05672802770277528858409257082700992237},
    {-0.091007408251299298983761052558678878131,
     -0.90899259174870070101623894744132112187,
     -0.091007408251299298983761052558678878131,
     0.05672802770277528858409257082700992237},
    {-0.90899259174870070101623894744132112187,
     -0.90899259174870070101623894744132112187,
     -0.091007408251299298983761052558678878131,
     0.05672802770277528858409257082700992237},
    {-0.90899259174870070101623894744132112187,
     -0.091007408251299298983761052558678878131,
     -0.90899259174870070101623894744132112187,
     0.05672802770277528858409257082700992237},
    {-0.091007408251299298983761052558678878131,
     -0.90899259174870070101623894744132112187,
     -0.90899259174870070101623894744132112187,
     0.05672802770277528858409257082700992237},
    {-0.091007408251299298983761052558678878131,
     -0.091007408251299298983761052558678878131,
     -0.90899259174870070101623894744132112187,
     0.05672802770277528858409257082700992237},
    // 6 28 %%% Order / Number of Points
    {-0.9014645530926346, -0.9014645530926346, 0.7043936592779039,
     0.01365860487109721},
    {-0.9014645530926346, 0.7043936592779039, -0.9014645530926346,
     0.01365860487109721},
    {0.7043936592779039, -0.9014645530926346, -0.9014645530926346,
     0.01365860487109721},
    {-0.9014645530926346, -0.9014645530926346, -0.9014645530926346,
     0.01365860487109721},
    {-0.4047494477945448, -0.4047494477945448, -0.7857516566163656,
     0.09244348954359109},
    {-0.4047494477945448, -0.7857516566163656, -0.4047494477945448,
     0.09244348954359109},
    {-0.7857516566163656, -0.4047494477945448, -0.4047494477945448,
     0.09244348954359109},
    {-0.4047494477945448, -0.4047494477945448, -0.4047494477945448,
     0.09244348954359109},
    {-0.337313642192765, -0.337313642192765, -0.988059073421705,
     0.03340433184715504},
    {-0.337313642192765, -0.988059073421705, -0.337313642192765,
     0.03340433184715504},
    {-0.988059073421705, -0.337313642192765, -0.337313642192765,
     0.03340433184715504},
    {-0.3373136421927651, -0.3373136421927651, -0.3373136421927651,
     0.03340433184715504},
    {-1, -1, 1, 0.0009697642143471041},
    {-1, 1, -1, 0.0009697642143471041},
    {1, -1, -1, 0.0009697642143471041},
    {-1, -1, -1, 0.0009697642143471041},
    {0.2060113295832984, -0.872677996249965, -0.4606553370833684,
     0.06428571428571428},
    {0.2060113295832983, -0.872677996249965, -0.872677996249965,
     0.06428571428571428},
    {-0.872677996249965, -0.872677996249965, 0.2060113295832983,
     0.06428571428571428},
    {-0.4606553370833684, 0.2060113295832984, -0.872677996249965,
     0.06428571428571428},
    {-0.872677996249965, -0.4606553370833684, 0.2060113295832984,
     0.06428571428571428},
    {-0.872677996249965, 0.2060113295832983, -0.872677996249965,
     0.06428571428571428},
    {-0.4606553370833684, -0.872677996249965, 0.2060113295832984,
     0.06428571428571428},
    {-0.872677996249965, -0.4606553370833684, -0.872677996249965,
     0.06428571428571428},
    {-0.872677996249965, -0.872677996249965, -0.4606553370833684,
     0.06428571428571428},
    {-0.872677996249965, 0.2060113295832984, -0.4606553370833684,
     0.06428571428571428},
    {-0.4606553370833684, -0.872677996249965, -0.872677996249965,
     0.06428571428571428},
    {0.2060113295832984, -0.4606553370833684, -0.872677996249965,
     0.06428571428571428},
    // 7 36 %%% Order / Number of Points
    {-0.6449900404266333, -0.6449900404266333, -0.06502987872010024,
     0.1096217661304426},
    {-0.6449900404266333, -0.06502987872010024, -0.6449900404266333,
     0.1096217661304426},
    {-0.06502987872010024, -0.6449900404266333, -0.6449900404266333,
     0.1096217661304426},
    {-0.6449900404266332, -0.6449900404266332, -0.6449900404266332,
     0.1096217661304426},
    {-1, -1, 1, 0.001090957174923385},
    {-1, 1, -1, 0.001090957174923385},
    {1, -1, -1, 0.001090957174923385},
    {-1, -1, -1, 0.001090957174923385},
    {-0.348005765750029, -0.348005765750029, -0.955982702749913,
     0.05789330026637356},
    {-0.348005765750029, -0.955982702749913, -0.348005765750029,
     0.05789330026637356},
    {-0.955982702749913, -0.348005765750029, -0.348005765750029,
     0.05789330026637356},
    {-0.348005765750029, -0.348005765750029, -0.348005765750029,
     0.05789330026637356},
    {0.5000366416183115, -0.7552140017616452, -0.9896086380950211,
     0.01943251856980146},
    {0.5000366416183115, -0.7552140017616452, -0.7552140017616452,
     0.01943251856980146},
    {-0.7552140017616452, -0.7552140017616452, 0.5000366416183115,
     0.01943251856980146},
    {-0.9896086380950211, 0.5000366416183115, -0.7552140017616452,
     0.01943251856980146},
    {-0.7552140017616452, -0.9896086380950211, 0.5000366416183115,
     0.01943251856980146},
    {-0.7552140017616452, 0.5000366416183115, -0.7552140017616452,
     0.01943251856980146},
    {-0.9896086380950211, -0.7552140017616452, 0.5000366416183115,
     0.01943251856980146},
    {-0.7552140017616452, -0.9896086380950211, -0.7552140017616452,
     0.01943251856980146},
    {-0.7552140017616452, -0.7552140017616452, -0.9896086380950211,
     0.01943251856980146},
    {-0.7552140017616452, 0.5000366416183115, -0.9896086380950211,
     0.01943251856980146},
    {-0.9896086380950211, -0.7552140017616452, -0.7552140017616452,
     0.01943251856980146},
    {0.5000366416183115, -0.9896086380950211, -0.7552140017616452,
     0.01943251856980146},
    {0.09573294252861952, -0.8874940323823619, -0.3207448777638958,
     0.03547658468406294},
    {0.09573294252861959, -0.8874940323823619, -0.8874940323823619,
     0.03547658468406294},
    {-0.8874940323823619, -0.8874940323823619, 0.09573294252861959,
     0.03547658468406294},
    {-0.3207448777638958, 0.09573294252861952, -0.8874940323823619,
     0.03547658468406294},
    {-0.8874940323823619, -0.3207448777638958, 0.09573294252861952,
     0.03547658468406294},
    {-0.8874940323823619, 0.09573294252861954, -0.8874940323823619,
     0.03547658468406294},
    {-0.3207448777638958, -0.8874940323823619, 0.09573294252861952,
     0.03547658468406294},
    {-0.8874940323823619, -0.3207448777638959, -0.8874940323823619,
     0.03547658468406294},
    {-0.8874940323823619, -0.8874940323823619, -0.3207448777638959,
     0.03547658468406294},
    {-0.8874940323823619, 0.09573294252861952, -0.3207448777638958,
     0.03547658468406294},
    {-0.3207448777638959, -0.8874940323823619, -0.8874940323823619,
     0.03547658468406294},
    {0.09573294252861952, -0.3207448777638958, -0.8874940323823619,
     0.03547658468406294},
    // 8 81 %%% Order / Number of Points
    {-0.5, -0.5, -0.5, 0.01170682265486141},
    {-0.6197291093042194, -0.6197291093042194, -0.1408126720873417,
     0.06755985258831025},
    {-0.6197291093042194, -0.1408126720873417, -0.6197291093042194,
     0.06755985258831025},
    {-0.1408126720873417, -0.6197291093042194, -0.6197291093042194,
     0.06755985258831025},
    {-0.6197291093042194, -0.6197291093042194, -0.6197291093042194,
     0.06755985258831025},
    {-1, -1, 1, 0.000958814999880356},
    {-1, 1, -1, 0.000958814999880356},
    {1, -1, -1, 0.000958814999880356},
    {-1, -1, -1, 0.000958814999880356},
    {-0.913388728258469, -0.2185594374902644, -0.6494923967610022,
     0.01872960947715247},
    {-0.913388728258469, -0.2185594374902644, -0.2185594374902644,
     0.01872960947715247},
    {-0.2185594374902644, -0.2185594374902644, -0.913388728258469,
     0.01872960947715247},
    {-0.6494923967610022, -0.913388728258469, -0.2185594374902644,
     0.01872960947715247},
    {-0.2185594374902644, -0.6494923967610022, -0.913388728258469,
     0.01872960947715247},
    {-0.2185594374902644, -0.913388728258469, -0.2185594374902644,
     0.01872960947715247},
    {-0.6494923967610022, -0.2185594374902644, -0.913388728258469,
     0.01872960947715247},
    {-0.2185594374902644, -0.6494923967610022, -0.2185594374902644,
     0.01872960947715247},
    {-0.2185594374902644, -0.2185594374902644, -0.6494923967610022,
     0.01872960947715247},
    {-0.2185594374902644, -0.913388728258469, -0.6494923967610022,
     0.01872960947715247},
    {-0.6494923967610022, -0.2185594374902644, -0.2185594374902644,
     0.01872960947715247},
    {-0.913388728258469, -0.6494923967610022, -0.2185594374902644,
     0.01872960947715247},
    {0.05193233845028339, -0.5622201657453156, -0.9274920069596522,
     0.03364659206479605},
    {0.05193233845028339, -0.5622201657453156, -0.5622201657453156,
     0.03364659206479605},
    {-0.5622201657453156, -0.5622201657453156, 0.05193233845028339,
     0.03364659206479605},
    {-0.9274920069596522, 0.05193233845028339, -0.5622201657453156,
     0.03364659206479605},
    {-0.5622201657453156, -0.9274920069596522, 0.05193233845028339,
     0.03364659206479605},
    {-0.5622201657453156, 0.05193233845028339, -0.5622201657453156,
     0.03364659206479605},
    {-0.9274920069596522, -0.5622201657453156, 0.05193233845028339,
     0.03364659206479605},
    {-0.5622201657453156, -0.9274920069596522, -0.5622201657453156,
     0.03364659206479605},
    {-0.5622201657453156, -0.5622201657453156, -0.9274920069596522,
     0.03364659206479605},
    {-0.5622201657453156, 0.05193233845028339, -0.9274920069596522,
     0.03364659206479605},
    {-0.9274920069596522, -0.5622201657453156, -0.5622201657453156,
     0.03364659206479605},
    {0.05193233845028339, -0.9274920069596522, -0.5622201657453156,
     0.03364659206479605},
    {0.06884971315898696, -0.2335649243675956, -0.9129098734135397,
     0.007658847884053573},
    {-0.2335649243675956, -0.9129098734135397, 0.06884971315898696,
     0.007658847884053573},
    {-0.2335649243675956, 0.06884971315898696, -0.9129098734135397,
     0.007658847884053573},
    {-0.9129098734135397, 0.06884971315898691, -0.9223749153778515,
     0.007658847884053573},
    {-0.9129098734135397, 0.06884971315898696, -0.2335649243675956,
     0.007658847884053573},
    {-0.9223749153778515, 0.06884971315898691, -0.9129098734135397,
     0.007658847884053573},
    {-0.9129098734135397, -0.2335649243675956, -0.9223749153778515,
     0.007658847884053573},
    {-0.9129098734135397, -0.9223749153778515, 0.06884971315898691,
     0.007658847884053573},
    {-0.9223749153778515, -0.2335649243675956, -0.9129098734135397,
     0.007658847884053573},
    {0.06884971315898691, -0.2335649243675956, -0.9223749153778515,
     0.007658847884053573},
    {-0.9223749153778515, 0.06884971315898691, -0.2335649243675956,
     0.007658847884053573},
    {-0.9129098734135397, -0.2335649243675956, 0.06884971315898696,
     0.007658847884053573},
    {-0.9223749153778515, -0.2335649243675956, 0.06884971315898691,
     0.007658847884053573},
    {0.06884971315898691, -0.9223749153778515, -0.9129098734135397,
     0.007658847884053573},
    {-0.9129098734135397, -0.9223749153778515, -0.2335649243675956,
     0.007658847884053573},
    {-0.2335649243675956, -0.9223749153778515, -0.9129098734135397,
     0.007658847884053573},
    {0.06884971315898691, -0.9223749153778515, -0.2335649243675956,
     0.007658847884053573},
    {-0.2335649243675956, -0.9223749153778515, 0.06884971315898691,
     0.007658847884053573},
    {-0.2335649243675956, 0.06884971315898691, -0.9223749153778515,
     0.007658847884053573},
    {-0.9223749153778515, -0.9129098734135397, 0.06884971315898691,
     0.007658847884053573},
    {0.06884971315898691, -0.9129098734135397, -0.9223749153778515,
     0.007658847884053573},
    {0.06884971315898696, -0.9129098734135397, -0.2335649243675956,
     0.007658847884053573},
    {-0.2335649243675956, -0.9129098734135397, -0.9223749153778515,
     0.007658847884053573},
    {-0.9223749153778515, -0.9129098734135397, -0.2335649243675956,
     0.007658847884053573},
    {0.5055118734531724, -0.6728086418734043, -0.9164256718485133,
     0.00980104469187673},
    {-0.6728086418734043, -0.9164256718485133, 0.5055118734531724,
     0.00980104469187673},
    {-0.6728086418734043, 0.5055118734531724, -0.9164256718485133,
     0.00980104469187673},
    {-0.9164256718485133, 0.5055118734531724, -0.9162775597312547,
     0.00980104469187673},
    {-0.9164256718485133, 0.5055118734531724, -0.6728086418734043,
     0.00980104469187673},
    {-0.9162775597312547, 0.5055118734531724, -0.9164256718485133,
     0.00980104469187673},
    {-0.9164256718485133, -0.6728086418734043, -0.9162775597312547,
     0.00980104469187673},
    {-0.9164256718485133, -0.9162775597312547, 0.5055118734531724,
     0.00980104469187673},
    {-0.9162775597312548, -0.6728086418734043, -0.9164256718485133,
     0.00980104469187673},
    {0.5055118734531724, -0.6728086418734043, -0.9162775597312547,
     0.00980104469187673},
    {-0.9162775597312547, 0.5055118734531724, -0.6728086418734043,
     0.00980104469187673},
    {-0.9164256718485133, -0.6728086418734043, 0.5055118734531724,
     0.00980104469187673},
    {-0.9162775597312547, -0.6728086418734043, 0.5055118734531724,
     0.00980104469187673},
    {0.5055118734531724, -0.9162775597312547, -0.9164256718485133,
     0.00980104469187673},
    {-0.9164256718485133, -0.9162775597312547, -0.6728086418734043,
     0.00980104469187673},
    {-0.6728086418734043, -0.9162775597312547, -0.9164256718485133,
     0.00980104469187673},
    {0.5055118734531724, -0.9162775597312547, -0.6728086418734043,
     0.00980104469187673},
    {-0.6728086418734043, -0.9162775597312547, 0.5055118734531724,
     0.00980104469187673},
    {-0.6728086418734043, 0.5055118734531724, -0.9162775597312547,
     0.00980104469187673},
    {-0.9162775597312547, -0.9164256718485133, 0.5055118734531724,
     0.00980104469187673},
    {0.5055118734531724, -0.9164256718485133, -0.9162775597312547,
     0.00980104469187673},
    {0.5055118734531724, -0.9164256718485133, -0.6728086418734043,
     0.00980104469187673},
    {-0.6728086418734043, -0.9164256718485133, -0.9162775597312547,
     0.00980104469187673},
    {-0.9162775597312548, -0.9164256718485133, -0.6728086418734043,
     0.00980104469187673},
    // 9 121 %%% Order / Number of Points
    {-0.5, -0.5, -0.5, 0.03202136775896759},
    {0.9967597185230161, -1, -0.9967597185230161, 7.073923221950578e-05},
    {0.9967597185230161, -1, -1, 7.073923221950578e-05},
    {-1, -1, 0.9967597185230161, 7.073923221950578e-05},
    {-0.9967597185230161, 0.9967597185230161, -1, 7.073923221950578e-05},
    {-1, -0.9967597185230161, 0.9967597185230161, 7.073923221950578e-05},
    {-1, 0.9967597185230161, -1, 7.073923221950578e-05},
    {-0.9967597185230161, -1, 0.9967597185230161, 7.073923221950578e-05},
    {-1, -0.9967597185230161, -1, 7.073923221950578e-05},
    {-1, -1, -0.9967597185230161, 7.073923221950578e-05},
    {-1, 0.9967597185230161, -0.9967597185230161, 7.073923221950578e-05},
    {-0.9967597185230161, -1, -1, 7.073923221950578e-05},
    {0.9967597185230161, -0.9967597185230161, -1, 7.073923221950578e-05},
    {-0.129171718440708, -0.5247600510045458, -0.8213081795502003,
     0.04344104601107267},
    {-0.1291717184407081, -0.5247600510045458, -0.5247600510045458,
     0.04344104601107267},
    {-0.5247600510045458, -0.5247600510045458, -0.1291717184407081,
     0.04344104601107267},
    {-0.8213081795502003, -0.129171718440708, -0.5247600510045458,
     0.04344104601107267},
    {-0.5247600510045458, -0.8213081795502003, -0.129171718440708,
     0.04344104601107267},
    {-0.5247600510045458, -0.1291717184407081, -0.5247600510045458,
     0.04344104601107267},
    {-0.8213081795502003, -0.5247600510045458, -0.129171718440708,
     0.04344104601107267},
    {-0.5247600510045458, -0.8213081795502003, -0.5247600510045458,
     0.04344104601107267},
    {-0.5247600510045458, -0.5247600510045458, -0.8213081795502003,
     0.04344104601107267},
    {-0.5247600510045458, -0.129171718440708, -0.8213081795502003,
     0.04344104601107267},
    {-0.8213081795502003, -0.5247600510045458, -0.5247600510045458,
     0.04344104601107267},
    {-0.129171718440708, -0.8213081795502003, -0.5247600510045458,
     0.04344104601107267},
    {0.6885536236892698, -0.8442768118924425, -0.9999999999043847,
     0.005240066080456541},
    {0.6885536236892699, -0.8442768118924425, -0.8442768118924425,
     0.005240066080456541},
    {-0.8442768118924425, -0.8442768118924425, 0.6885536236892699,
     0.005240066080456541},
    {-0.9999999999043847, 0.6885536236892698, -0.8442768118924425,
     0.005240066080456541},
    {-0.8442768118924425, -0.9999999999043847, 0.6885536236892698,
     0.005240066080456541},
    {-0.8442768118924425, 0.6885536236892698, -0.8442768118924425,
     0.005240066080456541},
    {-0.9999999999043847, -0.8442768118924425, 0.6885536236892698,
     0.005240066080456541},
    {-0.8442768118924425, -0.9999999999043848, -0.8442768118924425,
     0.005240066080456541},
    {-0.8442768118924425, -0.8442768118924425, -0.9999999999043848,
     0.005240066080456541},
    {-0.8442768118924425, 0.6885536236892698, -0.9999999999043847,
     0.005240066080456541},
    {-0.9999999999043848, -0.8442768118924425, -0.8442768118924425,
     0.005240066080456541},
    {0.6885536236892698, -0.9999999999043847, -0.8442768118924425,
     0.005240066080456541},
    {-0.8966223694069491, -0.1243772215675464, -0.8546231874579582,
     0.01510414917185648},
    {-0.8966223694069491, -0.1243772215675464, -0.1243772215675464,
     0.01510414917185648},
    {-0.1243772215675464, -0.1243772215675464, -0.8966223694069491,
     0.01510414917185648},
    {-0.8546231874579582, -0.8966223694069491, -0.1243772215675464,
     0.01510414917185648},
    {-0.1243772215675464, -0.8546231874579582, -0.8966223694069491,
     0.01510414917185648},
    {-0.1243772215675464, -0.8966223694069491, -0.1243772215675464,
     0.01510414917185648},
    {-0.8546231874579582, -0.1243772215675464, -0.8966223694069491,
     0.01510414917185648},
    {-0.1243772215675464, -0.8546231874579582, -0.1243772215675464,
     0.01510414917185648},
    {-0.1243772215675464, -0.1243772215675464, -0.8546231874579582,
     0.01510414917185648},
    {-0.1243772215675464, -0.8966223694069491, -0.8546231874579582,
     0.01510414917185648},
    {-0.8546231874579582, -0.1243772215675464, -0.1243772215675464,
     0.01510414917185648},
    {-0.8966223694069491, -0.8546231874579582, -0.1243772215675464,
     0.01510414917185648},
    {0.3235024007804261, -0.5941077548192197, -0.8343915402517981,
     0.0133109638664204},
    {-0.5941077548192197, -0.8343915402517981, 0.3235024007804261,
     0.0133109638664204},
    {-0.5941077548192197, 0.3235024007804261, -0.8343915402517981,
     0.0133109638664204},
    {-0.8343915402517981, 0.3235024007804261, -0.8950031057094083,
     0.0133109638664204},
    {-0.8343915402517981, 0.3235024007804261, -0.5941077548192197,
     0.0133109638664204},
    {-0.8950031057094083, 0.3235024007804261, -0.8343915402517981,
     0.0133109638664204},
    {-0.8343915402517981, -0.5941077548192197, -0.8950031057094083,
     0.0133109638664204},
    {-0.8343915402517981, -0.8950031057094083, 0.3235024007804261,
     0.0133109638664204},
    {-0.8950031057094083, -0.5941077548192197, -0.8343915402517981,
     0.0133109638664204},
    {0.3235024007804261, -0.5941077548192197, -0.8950031057094083,
     0.0133109638664204},
    {-0.8950031057094083, 0.3235024007804261, -0.5941077548192197,
     0.0133109638664204},
    {-0.8343915402517981, -0.5941077548192197, 0.3235024007804261,
     0.0133109638664204},
    {-0.8950031057094083, -0.5941077548192197, 0.3235024007804261,
     0.0133109638664204},
    {0.3235024007804261, -0.8950031057094083, -0.8343915402517981,
     0.0133109638664204},
    {-0.8343915402517981, -0.8950031057094083, -0.5941077548192197,
     0.0133109638664204},
    {-0.5941077548192197, -0.8950031057094083, -0.8343915402517981,
     0.0133109638664204},
    {0.3235024007804261, -0.8950031057094083, -0.5941077548192197,
     0.0133109638664204},
    {-0.5941077548192197, -0.8950031057094083, 0.3235024007804261,
     0.0133109638664204},
    {-0.5941077548192197, 0.3235024007804261, -0.8950031057094083,
     0.0133109638664204},
    {-0.8950031057094083, -0.8343915402517981, 0.3235024007804261,
     0.0133109638664204},
    {0.3235024007804261, -0.8343915402517981, -0.8950031057094083,
     0.0133109638664204},
    {0.3235024007804261, -0.8343915402517981, -0.5941077548192197,
     0.0133109638664204},
    {-0.5941077548192197, -0.8343915402517981, -0.8950031057094083,
     0.0133109638664204},
    {-0.8950031057094083, -0.8343915402517981, -0.5941077548192197,
     0.0133109638664204},
    {0.01794896851631952, -0.6389318930235002, -0.3790175741074058,
     0.007299535203779416},
    {-0.6389318930235002, -0.3790175741074058, 0.01794896851631952,
     0.007299535203779416},
    {-0.6389318930235002, 0.01794896851631952, -0.3790175741074058,
     0.007299535203779416},
    {-0.3790175741074058, 0.0179489685163195, -0.9999995013854135,
     0.007299535203779416},
    {-0.3790175741074058, 0.01794896851631952, -0.6389318930235002,
     0.007299535203779416},
    {-0.9999995013854135, 0.0179489685163195, -0.3790175741074058,
     0.007299535203779416},
    {-0.3790175741074058, -0.6389318930235002, -0.9999995013854135,
     0.007299535203779416},
    {-0.3790175741074058, -0.9999995013854135, 0.0179489685163195,
     0.007299535203779416},
    {-0.9999995013854136, -0.6389318930235002, -0.3790175741074058,
     0.007299535203779416},
    {0.0179489685163195, -0.6389318930235002, -0.9999995013854135,
     0.007299535203779416},
    {-0.9999995013854135, 0.0179489685163195, -0.6389318930235002,
     0.007299535203779416},
    {-0.3790175741074058, -0.6389318930235002, 0.01794896851631952,
     0.007299535203779416},
    {-0.9999995013854135, -0.6389318930235002, 0.0179489685163195,
     0.007299535203779416},
    {0.0179489685163195, -0.9999995013854135, -0.3790175741074058,
     0.007299535203779416},
    {-0.3790175741074058, -0.9999995013854135, -0.6389318930235002,
     0.007299535203779416},
    {-0.6389318930235002, -0.9999995013854135, -0.3790175741074058,
     0.007299535203779416},
    {0.0179489685163195, -0.9999995013854135, -0.6389318930235002,
     0.007299535203779416},
    {-0.6389318930235002, -0.9999995013854135, 0.0179489685163195,
     0.007299535203779416},
    {-0.6389318930235002, 0.0179489685163195, -0.9999995013854135,
     0.007299535203779416},
    {-0.9999995013854135, -0.3790175741074058, 0.0179489685163195,
     0.007299535203779416},
    {0.0179489685163195, -0.3790175741074058, -0.9999995013854135,
     0.007299535203779416},
    {0.01794896851631952, -0.3790175741074058, -0.6389318930235002,
     0.007299535203779416},
    {-0.6389318930235002, -0.3790175741074058, -0.9999995013854135,
     0.007299535203779416},
    {-0.9999995013854136, -0.3790175741074058, -0.6389318930235002,
     0.007299535203779416},
    {0.327178328531087, -0.3539519401197535, -0.9975602320289694,
     0.00168283258092949},
    {-0.3539519401197535, -0.9975602320289694, 0.327178328531087,
     0.00168283258092949},
    {-0.3539519401197535, 0.327178328531087, -0.9975602320289694,
     0.00168283258092949},
    {-0.9975602320289694, 0.3271783285310871, -0.9756661563823644,
     0.00168283258092949},
    {-0.9975602320289694, 0.327178328531087, -0.3539519401197535,
     0.00168283258092949},
    {-0.9756661563823644, 0.3271783285310871, -0.9975602320289694,
     0.00168283258092949},
    {-0.9975602320289694, -0.3539519401197535, -0.9756661563823643,
     0.00168283258092949},
    {-0.9975602320289694, -0.9756661563823644, 0.3271783285310871,
     0.00168283258092949},
    {-0.9756661563823643, -0.3539519401197535, -0.9975602320289694,
     0.00168283258092949},
    {0.3271783285310871, -0.3539519401197535, -0.9756661563823644,
     0.00168283258092949},
    {-0.9756661563823644, 0.3271783285310871, -0.3539519401197535,
     0.00168283258092949},
    {-0.9975602320289694, -0.3539519401197535, 0.327178328531087,
     0.00168283258092949},
    {-0.9756661563823644, -0.3539519401197535, 0.3271783285310871,
     0.00168283258092949},
    {0.3271783285310871, -0.9756661563823644, -0.9975602320289694,
     0.00168283258092949},
    {-0.9975602320289694, -0.9756661563823643, -0.3539519401197535,
     0.00168283258092949},
    {-0.3539519401197535, -0.9756661563823643, -0.9975602320289694,
     0.00168283258092949},
    {0.3271783285310871, -0.9756661563823644, -0.3539519401197535,
     0.00168283258092949},
    {-0.3539519401197535, -0.9756661563823644, 0.3271783285310871,
     0.00168283258092949},
    {-0.3539519401197535, 0.3271783285310871, -0.9756661563823644,
     0.00168283258092949},
    {-0.9756661563823644, -0.9975602320289694, 0.3271783285310871,
     0.00168283258092949},
    {0.3271783285310871, -0.9975602320289694, -0.9756661563823644,
     0.00168283258092949},
    {0.327178328531087, -0.9975602320289694, -0.3539519401197535,
     0.00168283258092949},
    {-0.3539519401197535, -0.9975602320289694, -0.9756661563823643,
     0.00168283258092949},
    {-0.9756661563823643, -0.9975602320289694, -0.3539519401197535,
     0.00168283258092949},
    // 10 180 %%% Order / Number of Points
    {-0.3095923101946758, -0.6904076898053242, -0.6904076898053242,
     0.05046999312456235},
    {-0.6904076898053242, -0.3095923101946758, -0.6904076898053242,
     0.05046999312456235},
    {-0.3095923101946758, -0.3095923101946758, -0.6904076898053242,
     0.05046999312456235},
    {-0.3095923101946758, -0.6904076898053242, -0.3095923101946758,
     0.05046999312456235},
    {-0.6904076898053242, -0.3095923101946758, -0.3095923101946758,
     0.05046999312456235},
    {-0.6904076898053242, -0.6904076898053242, -0.3095923101946758,
     0.05046999312456235},
    {-0.06442564837992282, -0.9355743516200772, -0.9355743516200772,
     0.01339481762537702},
    {-0.9355743516200772, -0.06442564837992282, -0.9355743516200772,
     0.01339481762537702},
    {-0.06442564837992282, -0.06442564837992282, -0.9355743516200772,
     0.01339481762537702},
    {-0.06442564837992282, -0.9355743516200772, -0.06442564837992282,
     0.01339481762537702},
    {-0.9355743516200772, -0.06442564837992282, -0.06442564837992282,
     0.01339481762537702},
    {-0.9355743516200772, -0.9355743516200772, -0.06442564837992282,
     0.01339481762537702},
    {0.5567862715023449, -0.9960890896646959, -0.5648851820149239,
     0.0008631453560709901},
    {-0.9960890896646959, -0.5648851820149239, 0.5567862715023449,
     0.0008631453560709901},
    {-0.9960890896646959, 0.5567862715023449, -0.5648851820149239,
     0.0008631453560709901},
    {-0.5648851820149239, 0.5567862715023449, -0.9958119998227251,
     0.0008631453560709901},
    {-0.5648851820149239, 0.5567862715023449, -0.9960890896646959,
     0.0008631453560709901},
    {-0.9958119998227251, 0.5567862715023449, -0.5648851820149239,
     0.0008631453560709901},
    {-0.5648851820149239, -0.9960890896646959, -0.9958119998227251,
     0.0008631453560709901},
    {-0.5648851820149239, -0.9958119998227251, 0.5567862715023449,
     0.0008631453560709901},
    {-0.9958119998227252, -0.9960890896646959, -0.5648851820149239,
     0.0008631453560709901},
    {0.5567862715023449, -0.9960890896646959, -0.9958119998227251,
     0.0008631453560709901},
    {-0.9958119998227251, 0.5567862715023449, -0.9960890896646959,
     0.0008631453560709901},
    {-0.5648851820149239, -0.9960890896646959, 0.5567862715023449,
     0.0008631453560709901},
    {-0.9958119998227251, -0.9960890896646959, 0.5567862715023449,
     0.0008631453560709901},
    {0.5567862715023449, -0.9958119998227251, -0.5648851820149239,
     0.0008631453560709901},
    {-0.5648851820149239, -0.9958119998227251, -0.9960890896646959,
     0.0008631453560709901},
    {-0.9960890896646959, -0.9958119998227251, -0.5648851820149239,
     0.0008631453560709901},
    {0.5567862715023449, -0.9958119998227251, -0.9960890896646959,
     0.0008631453560709901},
    {-0.9960890896646959, -0.9958119998227251, 0.5567862715023449,
     0.0008631453560709901},
    {-0.9960890896646959, 0.5567862715023449, -0.9958119998227251,
     0.0008631453560709901},
    {-0.9958119998227251, -0.5648851820149239, 0.5567862715023449,
     0.0008631453560709901},
    {0.5567862715023449, -0.5648851820149239, -0.9958119998227251,
     0.0008631453560709901},
    {0.5567862715023449, -0.5648851820149239, -0.9960890896646959,
     0.0008631453560709901},
    {-0.9960890896646959, -0.5648851820149239, -0.9958119998227251,
     0.0008631453560709901},
    {-0.9958119998227252, -0.5648851820149239, -0.9960890896646959,
     0.0008631453560709901},
    {0.6299745502008329, -0.9621456332644982, -0.8332313341177493,
     0.003677302609422897},
    {-0.9621456332644982, -0.8332313341177493, 0.6299745502008329,
     0.003677302609422897},
    {-0.9621456332644982, 0.6299745502008329, -0.8332313341177493,
     0.003677302609422897},
    {-0.8332313341177493, 0.6299745502008329, -0.8345975828185854,
     0.003677302609422897},
    {-0.8332313341177493, 0.6299745502008329, -0.9621456332644982,
     0.003677302609422897},
    {-0.8345975828185854, 0.6299745502008329, -0.8332313341177493,
     0.003677302609422897},
    {-0.8332313341177493, -0.9621456332644982, -0.8345975828185854,
     0.003677302609422897},
    {-0.8332313341177493, -0.8345975828185854, 0.6299745502008329,
     0.003677302609422897},
    {-0.8345975828185854, -0.9621456332644982, -0.8332313341177493,
     0.003677302609422897},
    {0.6299745502008329, -0.9621456332644982, -0.8345975828185854,
     0.003677302609422897},
    {-0.8345975828185854, 0.6299745502008329, -0.9621456332644982,
     0.003677302609422897},
    {-0.8332313341177493, -0.9621456332644982, 0.6299745502008329,
     0.003677302609422897},
    {-0.8345975828185854, -0.9621456332644982, 0.6299745502008329,
     0.003677302609422897},
    {0.6299745502008329, -0.8345975828185854, -0.8332313341177493,
     0.003677302609422897},
    {-0.8332313341177493, -0.8345975828185854, -0.9621456332644982,
     0.003677302609422897},
    {-0.9621456332644982, -0.8345975828185854, -0.8332313341177493,
     0.003677302609422897},
    {0.6299745502008329, -0.8345975828185854, -0.9621456332644982,
     0.003677302609422897},
    {-0.9621456332644982, -0.8345975828185854, 0.6299745502008329,
     0.003677302609422897},
    {-0.9621456332644982, 0.6299745502008329, -0.8345975828185854,
     0.003677302609422897},
    {-0.8345975828185854, -0.8332313341177493, 0.6299745502008329,
     0.003677302609422897},
    {0.6299745502008329, -0.8332313341177493, -0.8345975828185854,
     0.003677302609422897},
    {0.6299745502008329, -0.8332313341177493, -0.9621456332644982,
     0.003677302609422897},
    {-0.9621456332644982, -0.8332313341177493, -0.8345975828185854,
     0.003677302609422897},
    {-0.8345975828185854, -0.8332313341177493, -0.9621456332644982,
     0.003677302609422897},
    {0.1492501104790812, -0.723131441160876, -0.7126149756991516,
     0.006142746466577816},
    {-0.723131441160876, -0.7126149756991516, 0.1492501104790812,
     0.006142746466577816},
    {-0.723131441160876, 0.1492501104790812, -0.7126149756991516,
     0.006142746466577816},
    {-0.7126149756991516, 0.1492501104790811, -0.7135036936190535,
     0.006142746466577816},
    {-0.7126149756991516, 0.1492501104790812, -0.723131441160876,
     0.006142746466577816},
    {-0.7135036936190535, 0.1492501104790811, -0.7126149756991516,
     0.006142746466577816},
    {-0.7126149756991516, -0.723131441160876, -0.7135036936190535,
     0.006142746466577816},
    {-0.7126149756991516, -0.7135036936190535, 0.1492501104790811,
     0.006142746466577816},
    {-0.7135036936190535, -0.723131441160876, -0.7126149756991516,
     0.006142746466577816},
    {0.1492501104790811, -0.723131441160876, -0.7135036936190535,
     0.006142746466577816},
    {-0.7135036936190535, 0.1492501104790811, -0.723131441160876,
     0.006142746466577816},
    {-0.7126149756991516, -0.723131441160876, 0.1492501104790812,
     0.006142746466577816},
    {-0.7135036936190535, -0.723131441160876, 0.1492501104790811,
     0.006142746466577816},
    {0.1492501104790811, -0.7135036936190535, -0.7126149756991516,
     0.006142746466577816},
    {-0.7126149756991516, -0.7135036936190535, -0.723131441160876,
     0.006142746466577816},
    {-0.723131441160876, -0.7135036936190535, -0.7126149756991516,
     0.006142746466577816},
    {0.1492501104790811, -0.7135036936190535, -0.723131441160876,
     0.006142746466577816},
    {-0.723131441160876, -0.7135036936190535, 0.1492501104790811,
     0.006142746466577816},
    {-0.723131441160876, 0.1492501104790811, -0.7135036936190535,
     0.006142746466577816},
    {-0.7135036936190535, -0.7126149756991516, 0.1492501104790811,
     0.006142746466577816},
    {0.1492501104790811, -0.7126149756991516, -0.7135036936190535,
     0.006142746466577816},
    {0.1492501104790812, -0.7126149756991516, -0.723131441160876,
     0.006142746466577816},
    {-0.723131441160876, -0.7126149756991516, -0.7135036936190535,
     0.006142746466577816},
    {-0.7135036936190535, -0.7126149756991516, -0.723131441160876,
     0.006142746466577816},
    {-0.1241675146707287, -0.6054535405859228, -0.3329231118523948,
     0.01402179825894019},
    {-0.6054535405859228, -0.3329231118523948, -0.1241675146707287,
     0.01402179825894019},
    {-0.6054535405859228, -0.1241675146707287, -0.3329231118523948,
     0.01402179825894019},
    {-0.3329231118523948, -0.1241675146707286, -0.9374558328909539,
     0.01402179825894019},
    {-0.3329231118523948, -0.1241675146707287, -0.6054535405859228,
     0.01402179825894019},
    {-0.9374558328909539, -0.1241675146707286, -0.3329231118523948,
     0.01402179825894019},
    {-0.3329231118523948, -0.6054535405859228, -0.9374558328909539,
     0.01402179825894019},
    {-0.3329231118523948, -0.9374558328909539, -0.1241675146707286,
     0.01402179825894019},
    {-0.9374558328909538, -0.6054535405859228, -0.3329231118523948,
     0.01402179825894019},
    {-0.1241675146707286, -0.6054535405859228, -0.9374558328909539,
     0.01402179825894019},
    {-0.9374558328909539, -0.1241675146707286, -0.6054535405859228,
     0.01402179825894019},
    {-0.3329231118523948, -0.6054535405859228, -0.1241675146707287,
     0.01402179825894019},
    {-0.9374558328909539, -0.6054535405859228, -0.1241675146707286,
     0.01402179825894019},
    {-0.1241675146707286, -0.9374558328909539, -0.3329231118523948,
     0.01402179825894019},
    {-0.3329231118523948, -0.9374558328909539, -0.6054535405859228,
     0.01402179825894019},
    {-0.6054535405859228, -0.9374558328909539, -0.3329231118523948,
     0.01402179825894019},
    {-0.1241675146707286, -0.9374558328909539, -0.6054535405859228,
     0.01402179825894019},
    {-0.6054535405859228, -0.9374558328909539, -0.1241675146707286,
     0.01402179825894019},
    {-0.6054535405859228, -0.1241675146707286, -0.9374558328909539,
     0.01402179825894019},
    {-0.9374558328909539, -0.3329231118523948, -0.1241675146707286,
     0.01402179825894019},
    {-0.1241675146707286, -0.3329231118523948, -0.9374558328909539,
     0.01402179825894019},
    {-0.1241675146707287, -0.3329231118523948, -0.6054535405859228,
     0.01402179825894019},
    {-0.6054535405859228, -0.3329231118523948, -0.9374558328909539,
     0.01402179825894019},
    {-0.9374558328909538, -0.3329231118523948, -0.6054535405859228,
     0.01402179825894019},
    {0.9652386304244538, -0.9999951199335048, -0.9970342333619722,
     9.028919405473338e-05},
    {-0.9999951199335048, -0.9970342333619722, 0.9652386304244538,
     9.028919405473338e-05},
    {-0.9999951199335048, 0.9652386304244538, -0.9970342333619722,
     9.028919405473338e-05},
    {-0.9970342333619722, 0.9652386304244539, -0.968209277128977,
     9.028919405473338e-05},
    {-0.9970342333619722, 0.9652386304244538, -0.9999951199335048,
     9.028919405473338e-05},
    {-0.968209277128977, 0.9652386304244539, -0.9970342333619722,
     9.028919405473338e-05},
    {-0.9970342333619722, -0.9999951199335048, -0.968209277128977,
     9.028919405473338e-05},
    {-0.9970342333619722, -0.968209277128977, 0.9652386304244539,
     9.028919405473338e-05},
    {-0.968209277128977, -0.9999951199335048, -0.9970342333619722,
     9.028919405473338e-05},
    {0.9652386304244539, -0.9999951199335048, -0.968209277128977,
     9.028919405473338e-05},
    {-0.968209277128977, 0.9652386304244539, -0.9999951199335048,
     9.028919405473338e-05},
    {-0.9970342333619722, -0.9999951199335048, 0.9652386304244538,
     9.028919405473338e-05},
    {-0.968209277128977, -0.9999951199335048, 0.9652386304244539,
     9.028919405473338e-05},
    {0.9652386304244539, -0.968209277128977, -0.9970342333619722,
     9.028919405473338e-05},
    {-0.9970342333619722, -0.968209277128977, -0.9999951199335048,
     9.028919405473338e-05},
    {-0.9999951199335048, -0.968209277128977, -0.9970342333619722,
     9.028919405473338e-05},
    {0.9652386304244539, -0.968209277128977, -0.9999951199335048,
     9.028919405473338e-05},
    {-0.9999951199335048, -0.968209277128977, 0.9652386304244539,
     9.028919405473338e-05},
    {-0.9999951199335048, 0.9652386304244539, -0.968209277128977,
     9.028919405473338e-05},
    {-0.968209277128977, -0.9970342333619722, 0.9652386304244539,
     9.028919405473338e-05},
    {0.9652386304244539, -0.9970342333619722, -0.968209277128977,
     9.028919405473338e-05},
    {0.9652386304244538, -0.9970342333619722, -0.9999951199335048,
     9.028919405473338e-05},
    {-0.9999951199335048, -0.9970342333619722, -0.968209277128977,
     9.028919405473338e-05},
    {-0.968209277128977, -0.9970342333619722, -0.9999951199335048,
     9.028919405473338e-05},
    {0.2539126552819768, -0.8687694159568213, -0.3896633224279717,
     9.016459548804612e-05},
    {-0.8687694159568213, -0.3896633224279717, 0.2539126552819768,
     9.016459548804612e-05},
    {-0.8687694159568213, 0.2539126552819768, -0.3896633224279717,
     9.016459548804612e-05},
    {-0.3896633224279717, 0.2539126552819768, -0.9954799168971837,
     9.016459548804612e-05},
    {-0.3896633224279717, 0.2539126552819768, -0.8687694159568213,
     9.016459548804612e-05},
    {-0.9954799168971837, 0.2539126552819768, -0.3896633224279717,
     9.016459548804612e-05},
    {-0.3896633224279717, -0.8687694159568213, -0.9954799168971837,
     9.016459548804612e-05},
    {-0.3896633224279717, -0.9954799168971837, 0.2539126552819768,
     9.016459548804612e-05},
    {-0.9954799168971837, -0.8687694159568213, -0.3896633224279717,
     9.016459548804612e-05},
    {0.2539126552819768, -0.8687694159568213, -0.9954799168971837,
     9.016459548804612e-05},
    {-0.9954799168971837, 0.2539126552819768, -0.8687694159568213,
     9.016459548804612e-05},
    {-0.3896633224279717, -0.8687694159568213, 0.2539126552819768,
     9.016459548804612e-05},
    {-0.9954799168971837, -0.8687694159568213, 0.2539126552819768,
     9.016459548804612e-05},
    {0.2539126552819768, -0.9954799168971837, -0.3896633224279717,
     9.016459548804612e-05},
    {-0.3896633224279717, -0.9954799168971837, -0.8687694159568213,
     9.016459548804612e-05},
    {-0.8687694159568213, -0.9954799168971837, -0.3896633224279717,
     9.016459548804612e-05},
    {0.2539126552819768, -0.9954799168971837, -0.8687694159568213,
     9.016459548804612e-05},
    {-0.8687694159568213, -0.9954799168971837, 0.2539126552819768,
     9.016459548804612e-05},
    {-0.8687694159568213, 0.2539126552819768, -0.9954799168971837,
     9.016459548804612e-05},
    {-0.9954799168971837, -0.3896633224279717, 0.2539126552819768,
     9.016459548804612e-05},
    {0.2539126552819768, -0.3896633224279717, -0.9954799168971837,
     9.016459548804612e-05},
    {0.2539126552819768, -0.3896633224279717, -0.8687694159568213,
     9.016459548804612e-05},
    {-0.8687694159568213, -0.3896633224279717, -0.9954799168971837,
     9.016459548804612e-05},
    {-0.9954799168971837, -0.3896633224279717, -0.8687694159568213,
     9.016459548804612e-05},
    {0.2391412181901834, -0.7971636934427455, -0.9462404191356018,
     0.01470390638751603},
    {-0.7971636934427455, -0.9462404191356018, 0.2391412181901834,
     0.01470390638751603},
    {-0.7971636934427455, 0.2391412181901834, -0.9462404191356018,
     0.01470390638751603},
    {-0.9462404191356018, 0.2391412181901834, -0.495737105611836,
     0.01470390638751603},
    {-0.9462404191356018, 0.2391412181901834, -0.7971636934427455,
     0.01470390638751603},
    {-0.495737105611836, 0.2391412181901834, -0.9462404191356018,
     0.01470390638751603},
    {-0.9462404191356018, -0.7971636934427455, -0.4957371056118361,
     0.01470390638751603},
    {-0.9462404191356018, -0.495737105611836, 0.2391412181901834,
     0.01470390638751603},
    {-0.4957371056118361, -0.7971636934427455, -0.9462404191356018,
     0.01470390638751603},
    {0.2391412181901834, -0.7971636934427455, -0.495737105611836,
     0.01470390638751603},
    {-0.495737105611836, 0.2391412181901834, -0.7971636934427455,
     0.01470390638751603},
    {-0.9462404191356018, -0.7971636934427455, 0.2391412181901834,
     0.01470390638751603},
    {-0.495737105611836, -0.7971636934427455, 0.2391412181901834,
     0.01470390638751603},
    {0.2391412181901834, -0.495737105611836, -0.9462404191356018,
     0.01470390638751603},
    {-0.9462404191356018, -0.4957371056118361, -0.7971636934427455,
     0.01470390638751603},
    {-0.7971636934427455, -0.4957371056118361, -0.9462404191356018,
     0.01470390638751603},
    {0.2391412181901834, -0.495737105611836, -0.7971636934427455,
     0.01470390638751603},
    {-0.7971636934427455, -0.495737105611836, 0.2391412181901834,
     0.01470390638751603},
    {-0.7971636934427455, 0.2391412181901834, -0.495737105611836,
     0.01470390638751603},
    {-0.495737105611836, -0.9462404191356018, 0.2391412181901834,
     0.01470390638751603},
    {0.2391412181901834, -0.9462404191356018, -0.495737105611836,
     0.01470390638751603},
    {0.2391412181901834, -0.9462404191356018, -0.7971636934427455,
     0.01470390638751603},
    {-0.7971636934427455, -0.9462404191356018, -0.4957371056118361,
     0.01470390638751603},
    {-0.4957371056118361, -0.9462404191356018, -0.7971636934427455,
     0.01470390638751603}};

} // namespace LibUtilities
} // namespace Nektar

#endif
