/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

/**********          shenv.c          **********/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>

#include "shenv.h"


    struct shenv *
shenv( void )
{
    struct shenv		*sh;

    if (( sh = (struct shenv*)malloc( sizeof( struct shenv ))) == NULL ) {
	perror( "malloc" );
	return( NULL );
    }

    if (( sh->sh_machine = getenv( "NEFU_MACHINE" )) == NULL ) {
	fprintf( stderr, "getenv: NEFU_MACHINE not set\n" );
	return( NULL );
    }

    if (( sh->sh_addr = getenv( "NEFU_ADDR" )) == NULL ) {
	fprintf( stderr, "getenv: NEFU_ADDR not set\n" );
	return( NULL );
    }

    return( sh );
}
