#include <sys/time.h>
#include <netinet/in.h>

#include <stdlib.h>
#include <stdio.h>
#include <lber.h>
#include <ldap.h>

#include "shenv.h"

#define	DEFAULT_TIMEOUT		10

char	*attrs[] = { "objectClass", 0 };

    int
main( int argc, char **argv ) 
{
    extern char		*optarg;
    extern int		optind;
    int			c;
    int			errs = 0;
    int			port = 0;
    struct timeval	tv = { DEFAULT_TIMEOUT, 0 };
    struct shenv	*sh;
    LDAP		*ld;
    LDAPMessage		*res;
    int			rc;

    while (( c = getopt( argc, argv, "t:p:" )) != EOF ) {
	switch ( c ) {
	case 't' :
	    /* timeout */
	    if (( tv.tv_sec = atoi( optarg )) < 0 ) {
		fprintf( stderr, "negative time value not allowed: %s\n",
			optarg );
		errs++;
	    }
	    tv.tv_usec = 0;
	    break;
	
	case 'p' :
	    /* port */
	    port = atoi( optarg );
	    break;

	default:
	    errs++;
	    break;
	}
    }

    if (( argc - optind != 0 ) || ( errs != 0 )) {
	fprintf( stderr, "usage: %s [-p <port>] [-t <seconds>]\n", argv[ 0 ] );
	exit( T_MAYBE_DOWN );
    }

    if (( sh = shenv()) == NULL ) {
	exit( T_MAYBE_DOWN );
    }

    if (( ld = ldap_init( sh->sh_addr, port )) == NULL ) {
	ldap_perror( ld, "ldap_init" );
	exit( T_MAYBE_DOWN );
    }

    if ( ldap_simple_bind( ld, NULL, NULL ) == -1 ) {
	ldap_perror( ld, "ldap_simple_bind_s" );
	exit( T_MAYBE_DOWN );
    }

    if ( ldap_result( ld, LDAP_RES_ANY, 0, &tv, &res ) != LDAP_RES_BIND ) {
	ldap_perror( ld, "ldap_simple_bind result" );
	exit( T_MAYBE_DOWN );
    }

    if (( rc = ldap_search_st( ld, "cn=monitor", LDAP_SCOPE_BASE,
	    "objectclass=*", attrs, 0, &tv, &res )) != 0 ) {
	ldap_perror( ld, "ldap_search_s" );
	exit( T_MAYBE_DOWN );
    }

    exit( T_UP );
}
