/*	dns.c	--	evan.cordes@umich.edu */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <sys/time.h>
#include <syslog.h>
#include <resolv.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>

#include "nefu.h"

#define DNS_MAXWAIT 	16
#define MAXTRIES	4

char			*nefu_master_dns_domain = NULL;


    char *
init_dns( struct test *t )
{
    if ( t->t_argc > 1 ) {
	return( "useage: dns [ domain ]" );
    }

    return( NULL );
}


    int
test_dns( struct test *t, struct report *r )
{
    int			i, rc, s, buflen, fromlen;
    int			maxwait = DNS_MAXWAIT;
    char		*dname = ".";
    u_char		buf[ 1024 ], answer[ 1024 ];
    HEADER		*qp, *rp;
    fd_set		fdset;
    struct sockaddr_in	from;
    struct timeval	tv, tv_elapse, tv_select;

    if (( nefu_test_maxwait >= 0 ) && ( nefu_test_maxwait < maxwait )) {
	maxwait = nefu_test_maxwait;
    }

    if ( t->t_argv[ 0 ] != NULL ) {
	dname = t->t_argv[ 0 ];
    } else if ( nefu_master_dns_domain != NULL ) {
	dname = nefu_master_dns_domain;
    }

    if (( buflen = res_mkquery( QUERY, dname, C_IN, T_SOA, NULL, 
	    0, NULL, buf, sizeof( buf ) )) < 0 ) {
	syslog( LOG_ERR, "test_dns res_mkquery failed" );
	return( T_MAYBE_DOWN );
    } 
    qp = (HEADER *)buf;

    if (( s = socket( AF_INET, SOCK_DGRAM, 0 )) < 0 ) {
	report_printf( r, "test_dns socket: %m" );
	return( T_MAYBE_DOWN );
    }

    for ( i = 0; i < MAXTRIES; i++ ) {
	if ( time_start( &tv_elapse ) < 0 ) {
	    report_printf( r, "time_start: %m" );
	    close( s );
	    return( T_MAYBE_DOWN );
	}

	if (( sendto( s, buf, buflen, 0, (struct sockaddr *)&t->t_sin,
		sizeof( struct sockaddr_in ))) < 0 ) {
	    report_printf( r, "test_dns sendto: %m" );
	    close( s );
	    return( T_MAYBE_DOWN );
	}

	tv.tv_sec = ( 4 << i ); 
	if ( tv.tv_sec > maxwait ) {
	    tv.tv_sec = maxwait; 
	}
	tv.tv_usec = 0;

	while ( 1 ) {
	    if ( time_start( &tv_select ) < 0 ) {
		report_printf( r, "time_start: %m" );
		close( s );
		return( T_MAYBE_DOWN );
	    }

	    FD_ZERO( &fdset );
	    FD_SET( s, &fdset );

	    if (( rc = select( s + 1, &fdset, NULL, NULL, &tv )) < 0 ) {
		report_printf( r, "test_dns select: %m" );
		close( s );
		return( T_MAYBE_DOWN );
	    }

	    if ( rc == 0 ) {
		break;
	    } else {
		if ( time_end ( &tv_select ) < 0 ) {
		    report_printf( r, "time_end: %m" );
		    close( s );
		    return( T_MAYBE_DOWN );
		}

		memset( &from, 0, sizeof( struct sockaddr_in ));
		fromlen = ( sizeof( struct sockaddr_in ));
		if (( rc = recvfrom( s, answer, sizeof( answer ), 0, 
			(struct sockaddr *)&from, &fromlen )) < 0 ) {
		    report_printf( r, "test_dns recvfrom: %m" );
		    close( s );
		    return( T_MAYBE_DOWN );
		}
		rp = (HEADER *)answer;

		/*
		 * If we get a response from an unknown address, or if
		 * we get a response with the wrong ID, just keep going.
		 */
		if ( t->t_sin.sin_addr.s_addr == from.sin_addr.s_addr &&
			qp->id == rp->id ) {
		    if ( rp->qr == 0 || rp->rcode != 0 ) {
			report_printf( r, "Bad response %d %d",
				rp->qr, rp->rcode );
			close( s );
			return( T_DOWN );
		    } else {
			if ( time_end ( &tv_elapse ) < 0 ) {
			    report_printf( r, "time_end: %m" );
			    close( s );
			    return( T_MAYBE_DOWN );
			}
			syslog( LOG_INFO, "%s %s %s %d %ld.%.6ld", t->t_rlist,
				t->t_machine->m_name, t->t_name,
				i + 1, tv_elapse.tv_sec, tv_elapse.tv_usec );
			close( s );
			return( T_UP );		/* good response */
		    }
		}

		tv.tv_sec -= tv_select.tv_sec; 
		tv.tv_usec -= tv_select.tv_usec;
		if ( tv.tv_usec < 0 ) {
		    tv.tv_sec -= 1;
		    tv.tv_usec += 1000000;
		}
		if ( tv.tv_sec < 0 ) {
		    break;
		}
	    }
	}
    }

    report_printf( r, "Timeout" );
    close( s );
    return( T_MAYBE_DOWN );
}
