#! /bin/sh
#------------------------------------------------------------------------
# This wrapper script allows automake based testing to have custom
#   options based on the test being executed.
# This allows for compatibility of tests between automake and CMake
#------------------------------------------------------------------------
args=""
status = 1
while [ $# -gt 1 ]
do
    echo Parsing $1
    case "$1" in
    --nds-tester)
      #------------------------------------------------------------------
      # Store location of the generic test script
      #------------------------------------------------------------------
      shift
      nds_tester="${1}"
      shift
      ;;
    *)
      #------------------------------------------------------------------
      # Pass on all unkown arguments
      #------------------------------------------------------------------
      args="$args $1"
      shift
      ;;
    esac
done
echo Testing: `basename "$1"`
case `basename "$1"` in
test_mockup_*.*|\
test_mockup.*)
    ${nds_tester} ${args} --nds1-mock-server $1
    status=$?
    ;;
test_fetch.*)
    ${nds_tester} ${args} --replay-server --replay-json-filename lho-prod.json $1
    status=$?
    ;;
test_nds_version.*)
    status=0
    ;;
test_nds1_timeout.*)
    ${nds_tester} ${args} --replay-server --replay-json-filename nds1-timeout.json $1
    status=$?
    ;;
test_nds2_availability.*)
    ${nds_tester} ${args} --replay-server --replay-json-filename nds2-availability.json $1
    status=$?
    ;;
test_nds2_find_channels_synthetic.*)
    ${nds_tester} ${args} --replay-server --replay-json-filename nds2-find-channels-synthetic.json $1
    status=$?
    ;;
test_nds2_find_channels_synthetic_old.*)
    ${nds_tester} ${args} --replay-server --replay-json-filename nds2-find-channels-synthetic-old.json $1
    status=$?
    ;;
*)
    #--------------------------------------------------------------------
    # Flag tests not handled by script as SKIPPED
    #--------------------------------------------------------------------
    echo "Skipping: $1"
    status=77
    ;;
esac
exit ${status}
