/* -*- mode: C++ ; c-basic-offset: 2; indent-tabs-mode: nil -*- */
/*
 * This file allows for SWIG specialization for Python
 */
#if defined(SWIGPYTHON)

%{

#include <sstream>

%}

%feature("autodoc","1");

#-------

%define %nds_type_gps_seconds() "long"
%enddef

%define %nds_type_sample_rate() "float"
%enddef

%define %nds_doc_param(CALL,TYPE,DESC)
%typemap("doc") CALL "$1_name -- " TYPE " -- " DESC;
%enddef

%define %nds_doc_brief(TEXT)
TEXT "
"
%enddef

%define %nds_doc_details(TEXT)
TEXT %nds_doc_nl
%enddef

%define %nds_doc_remark(TEXT)
"REMARK: " TEXT "
"
%enddef
%define %nds_doc_returns(TEXT)
"Returns " TEXT "

"
%enddef

%define %nds_doc_class_seperator()
%feature("autodoc") "";
%feature("docstring") "";
%enddef

#-------

%exception connection::next {
  try
  {
    $action
  }
  catch( const std::out_of_range& E )
  {
    PyErr_SetString(PyExc_StopIteration, "End of iterator");
    return NULL;
  }
  catch( std::bad_alloc& e )
  {
    SWIG_exception( SWIG_MemoryError, const_cast<char*>(e.what( ) ) );
    return NULL;
  }
  catch( std::invalid_argument& e )
  {
    SWIG_exception( SWIG_TypeError, const_cast<char*>(e.what( ) ) );
    return NULL;
  }
  catch( std::overflow_error& e )
  {
    SWIG_exception( SWIG_OverflowError, const_cast<char*>(e.what( ) ) );
    return NULL;
  }
  catch( std::ios_base::failure& e )
  {
    SWIG_exception( SWIG_IOError, const_cast<char*>(e.what( ) ) );
    return NULL;
  }
#if HAVE_STD_SYSTEM_ERROR
  catch( std::system_error& e )
  {
    SWIG_exception( SWIG_SystemError, const_cast<char*>(e.what( ) ) );
    return NULL;
  }
#endif /* HAVE_STD_SYSTEM_ERROR */
  catch( std::exception& e )
  {
    SWIG_exception( SWIG_RuntimeError, const_cast<char*>(e.what( ) ) );
    return NULL;
  }
  catch( ... )
  {
    SWIG_exception( SWIG_RuntimeError, const_cast<char*>( "Unknown exception thrown" ) );
    return NULL;
  }
}

%pythonprepend connection::connection %{
args = _hack_for_python2_strings(args)
%}

%pythonprepend connection::count_channels %{
args = _hack_for_python2_strings(args)
%}

%pythonprepend connection::find_channels %{
args = _hack_for_python2_strings(args)
%}

%pythonprepend connection::set_epoch %{
args = _hack_for_python2_strings(args)
%}

%pythonprepend connection::check %{
if 'args' in dir():
    args = _hack_for_python2_strings(args)
else:
    channel_names = _hack_for_python2_strings(channel_names)
%}

%pythonprepend connection::fetch %{
if 'args' in dir():
    args = _hack_for_python2_strings(args)
else:
    channel_names = _hack_for_python2_strings(channel_names)
%}

%pythonprepend connection::set_parameter %{
if 'args' in dir():
    args = _hack_for_python2_strings(args)
else:
    parameter, value = _hack_for_python2_strings((parameter, value))
%}

%pythonprepend connection::get_parameter %{
if 'args' in dir():
    args = _hack_for_python2_strings(args)
else:
    parameter = _hack_for_python2_strings((parameter,))[0]
%}

%pythonprepend connection::iterate %{
args = _hack_for_python2_strings(args)
%}

%pythonprepend connection::get_availability %{
if 'args' in dir():
    args = _hack_for_python2_strings(args)
else:
    channel_names = _hack_for_python2_strings(channel_names)
%}

%include "nds.i"


%pythoncode %{
import types
import sys

def _unicode_to_str(arg):
    arg_type = type(arg)
    if arg_type == types.UnicodeType:
        return str(arg)
    elif arg_type == types.ListType:
        return [x if type(x) != types.UnicodeType else str(x) for x in arg]
    elif arg_type == types.TupleType:
        return tuple([x if type(x) != types.UnicodeType else str(x) for x in arg])
    return arg

def _hack_for_python2_strings(args):
    """SWIG < 3.0  with Python 2 does not convert Python unicode strings
    to std::string or char *.  So force unicode strings to be byte strings"""
    if sys.version_info.major < 3 and len(args) > 0:
        args = tuple(map(_unicode_to_str, args))
    return args
%}

%begin %{
extern "C"
{
#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include <Python.h>
#include <numpy/arrayobject.h>

#if NPY_API_VERSION >= 0x00000007
// Do nothing since the macro is already available
#else // NPY_API_VERSION >= 0x00000007
#define PyArray_SetBaseObject(A,B)	PyArray_BASE(A) = B
#endif // NPY_API_VERSION >= 0x00000007

}

#include <string>
#include <sstream>

namespace {
template<typename T>
std::string to_cpp_string(const T* obj)
{
  if (!obj) return std::string("");
  std::ostringstream os;
  os << (*obj);
  return os.str();
}


}

%}

%include "nds_python_buffer.i"

%init %{
  import_array( );
%}


%define NDS_PRINT(type)
  %feature("autodoc") "";
  %feature("docstring") "";
  std::string __str__( )
  {
    return to_cpp_string<type>($self);
  }
  std::string __repr__( )
  {
    return to_cpp_string<type>($self);
  }
%enddef

%extend channel {

  NDS_PRINT(NDS::channel)

  %pythoncode %{
     try:
       __swig_getmethods__
     except NameError:
       __swig_getmethods__ = {}

     __swig_getmethods__['name'] = Name
     __swig_getmethods__['channel_type'] = Type
     __swig_getmethods__['data_type'] = DataType
     __swig_getmethods__['sample_rate'] = SampleRate
     #__swig_getmethods__['gain'] = Gain
     #__swig_getmethods__['slope'] = Slope
     #__swig_getmethods__['offset'] = Offset
     #__swig_getmethods__['units'] = Units
     __swig_getmethods__['signal_gain'] = Gain
     __swig_getmethods__['signal_slope'] = Slope
     __swig_getmethods__['signal_offset'] = Offset
     __swig_getmethods__['signal_units'] = Units

     try:
       object
       name = property(Name)
       channel_type = property(Type)
       data_type = property(DataType)
       sample_rate = property(SampleRate)
       #gain = property(Gain)
       #slope = property(Slope)
       #offset = property(Offset)
       #units = property(Units)
       signal_gain = property(Gain)
       signal_slope = property(Slope)
       signal_offset = property(Offset)
       signal_units = property(Units)
     except AttributeError:
       pass

  %}
}

%extend connection
{
  %insert("python") %{
    def __iter__(self):
      return self

    def __next__(self):
      return self.next()
  %}

  NDS_PRINT(NDS::connection)
}

%extend buffer
{
  NDS_PRINT(NDS::buffer)
}

%extend segment
{
  NDS_PRINT(NDS::segment)
}

%extend simple_segment
{
  NDS_PRINT(NDS::simple_segment)
}

%extend simple_segment_list_type
{
  NDS_PRINT(NDS::simple_segment_list_type)
}

%extend simple_availability_list_type
{
  NDS_PRINT(NDS::simple_availability_list_type)
}

%extend segment_list_type
{
  NDS_PRINT(NDS::segment_list_type)
}

%extend availability
{
  NDS_PRINT(NDS::availability)
}

%extend availability_list_type
{
  NDS_PRINT(NDS::availability_list_type)
}

%extend epoch
{
  NDS_PRINT(NDS::epoch)
}

%extend epochs_type
{
  NDS_PRINT(NDS::epochs_type)
}

typedef const unsigned char* lcl_data_vector_type;

/* don't think this code is used */
%typemap(out) lcl_data_vector_type {
  npy_intp dims[] = {arg1->length};
  int typenum;

  char* buffer = calloc( arg1->Samples( ),
                         arg1->DataTypeSize( ) );
  std::memcpy( buffer, $1, arg1->Samples( ) * arg1->DataTypeSize( ) );

  switch (arg1->channel.data_type)
  {
  case NDS::channel::DATA_TYPE_INT16:
    typenum = NPY_INT16;
    break;
  case NDS::channel::DATA_TYPE_INT32:
    typenum = NPY_INT32;
    break;
  case NDS::channel::DATA_TYPE_INT64:
    typenum = NPY_INT64;
    break;
  case NDS::channel::DATA_TYPE_FLOAT32:
    typenum = NPY_FLOAT32;
    break;
  case NDS::channel::DATA_TYPE_FLOAT64:
    typenum = NPY_FLOAT64;
    break;
  case NDS::channel::DATA_TYPE_COMPLEX32:
    typenum = NPY_COMPLEX64;
    break;
  case NDS::channel::DATA_TYPE_UINT32:
    typenum = NPY_UINT32;
    break;
  default:
    SWIG_exception(SWIG_TypeError, "Unknown NDS data type");
    break;
  }
  
  $result = PyArray_SimpleNewFromData(1, dims, typenum, buffer);
#ifdef HAVE_OLD_NUMPY
  $result->flags |= NPY_OWNDATA | NPY_ALIGNED;
#else
  int flags = PyArray_FLAGS( $result );
  PyArray_ENABLEFLAGS( $result, flags | NPY_ARRAY_OWNDATA | NPY_ARRAY_ALIGNED );
#endif

  if (!$result)
  {
    SWIG_fail;
  }

  Py_INCREF($self);
  PyArray_SetBaseObject($result, $self);
}

#endif /* defined(SWIGPYTHON) */

