/* -*- mode: c++ -*- */
%import "nds_java_buffer.i"

%typemap(javainterfaces) connection_iterator "java.util.Iterator<buffer[]>,java.lang.Iterable<buffer[]>"

%typemap(javacode) connection_iterator %{
  public java.util.Iterator<buffer[]> iterator( )
  {
    return this;
  }

  public void remove() throws UnsupportedOperationException {
    throw new UnsupportedOperationException();
  }

  public buffer[] next() throws java.util.NoSuchElementException {
    if (!hasNext()) {
      throw new java.util.NoSuchElementException();
    }

    buffer[] retval = new buffer[0];

    /* SWIGTYPE_p_std__vectorT_std__shared_ptrT_buffer_t_t nxt = nextImpl( ); */
    /* nxt.length; */
    return nextImpl();
    /* return retval; */
  }
%}

#if 0 || 1
%javamethodmodifiers connection_iterator::nextImpl "private";
#endif /* 0 */
%inline %{
#include "nds_buffer.hh"
#include "nds_connection.hh"


  using NDS::buffers_type;
  using NDS::connection;

  struct connection_iterator
  {
  public:
    typedef connection base_type;
    typedef buffers_type next_type;

    connection_iterator( base_type& Container )
      : base( Container ),
	has_next( true ), initialized(false)
    {
      //setup_next( );
    };

    bool hasNext( ) const
    {
      return( has_next );
    };

    buffers_type nextImpl( )
    {
      buffers_type retval;

      if (!initialized)
        setup_next();
      initialized = true;

      if ( has_next )
      {
	retval = n;
	setup_next( );
      }
      return retval;
    };

  private:
    base_type&	base;
    bool	has_next;
    bool    initialized;
    buffers_type	n;

    inline void
    setup_next( )
    {
      try
      {
	n = base.next( );
      }
      catch( ... )
      {
	has_next = false;
      }
    }
  };
%}
