#include "nds.hh"

#include <memory>
#include <cassert>
#include <iostream>
#include <cstdlib>
#include <sstream>

#include "test_macros.hh"
#include "nds_testing.hh"

int
main(int argc, char *argv[])
{
  using NDS::connection;

  std::vector<std::string> args = convert_args( argc, argv );

  //---------------------------------------------------------------------
  // Obtain the port of the server
  //---------------------------------------------------------------------
  connection::port_type	port = 31200;
  if ( ::getenv("NDS_TEST_PORT") )
  {
    std::istringstream	ps( ::getenv("NDS_TEST_PORT") );

    ps >> port;
  }
  std::string hostname("localhost");
  if ( ::getenv("NDS_TEST_HOST") )
  {
  	hostname = ::getenv( "NDS_TEST_HOST" );
  }

  connection::protocol_type proto = connection::PROTOCOL_TRY;
  if ( find_opt( "-proto-1", args ) )
  {
    proto = connection::PROTOCOL_ONE;
  }
  else if ( find_opt( "-proto-2", args ) )
  {
    proto = connection::PROTOCOL_TWO;
  }
  else if ( ::getenv("NDS_TEST_PROTO") )
  {
  	std::string ps( ::getenv("NDS_TEST_PROTO") );
    std::cerr << "NDS_TEST_PROTO = " << ps << std::endl;
  	if ( ps.compare("1") == 0 ) proto = connection::PROTOCOL_ONE;
  	else if ( ps.compare("2") == 0 ) proto = connection::PROTOCOL_TWO;
  }

  std::cerr << "Connecting to " << hostname << ":" << port << " " << proto << std::endl;
  pointer< connection > conn( new connection( hostname, port, proto ));

  // The test data sets are different from nds1 to nds2, the nds1 test set
  // has the full range of s-trend and m-trend channels included
  // the nds2 set has 1 s-trend & 1 m-trend per channel
  if (conn->get_protocol() == connection::PROTOCOL_ONE) {
      assert ( conn->count_channels("*") == 4*11 );
      assert ( conn->count_channels("*4*") == 11 );
      assert ( conn->count_channels("*4*", NDS::channel::DEFAULT_CHANNEL_MASK, NDS::channel::DEFAULT_DATA_MASK, 0.9, 1.1) == 5 );
      std::cerr << "online = " << conn->count_channels("*", NDS::channel::CHANNEL_TYPE_ONLINE) << std::endl;
      assert ( conn->count_channels("*", NDS::channel::CHANNEL_TYPE_ONLINE) == 4 );
      assert ( conn->count_channels("*", NDS::channel::CHANNEL_TYPE_ONLINE, NDS::channel::DEFAULT_DATA_MASK, 10.0, 300.0) == 4 );
  } else {
      assert ( conn->count_channels("*") == 12 );
      assert ( conn->count_channels("*4*") == 3 );
      assert ( conn->count_channels("*4*", NDS::channel::DEFAULT_CHANNEL_MASK, NDS::channel::DEFAULT_DATA_MASK, 0.9, 1.1) == 1);
      assert ( conn->count_channels("*", NDS::channel::CHANNEL_TYPE_RAW) == 4);
      assert ( conn->count_channels("*", NDS::channel::CHANNEL_TYPE_RAW, NDS::channel::DEFAULT_DATA_MASK, 10.0, 300.0) == 4);
  }

  return 0;
}
