#include <algorithm>
#include <cassert>
#include <cstdlib>
#include <sstream>
#include <string>
#include <utility>
#include <vector>

#include "nds.hh"
#include "test_macros.hh"

int main(int argc, char *argv[]) {
    std::vector<std::string> args = convert_args(argc, argv);

    //---------------------------------------------------------------------
    // Obtain the port of the server
    //---------------------------------------------------------------------
    NDS::connection::port_type port = 31200;
    if (std::getenv("NDS_TEST_PORT")) {
        std::istringstream ps(::getenv("NDS_TEST_PORT"));

        ps >> port;
    }
    std::string hostname("localhost");
    if (std::getenv("NDS_TEST_HOST")) {
        hostname = std::getenv("NDS_TEST_HOST");
    }

    NDS_SHARED_PTR<NDS::connection> conn(new NDS::connection(hostname, port));

    // The failure comes in with an unknown data type, which was triggered by the addition of Virgo data
    // So just finishing is success
    NDS::channels_type chans = conn->find_channels("*", NDS::channel::CHANNEL_TYPE_RDS);
    std::cout << "chans.size == " << chans.size() << std::endl;
    assert( chans.size() == 3 );
    assert( chans[0]->Name() == "X1:PEM-1" );
    assert( chans[0]->DataType() == NDS::channel::DATA_TYPE_UNKNOWN );
    assert( chans[2]->Name() == "X1:PEM-3" );
    assert( chans[2]->DataType() == NDS::channel::DATA_TYPE_FLOAT32 );
    conn->close();
    return 0;
}