/* -*- mode: C++ ; c-basic-offset: 2; indent-tabs-mode: nil -*- */

#ifndef SWIG__COMMON__NDS_HELPER_HH
#define SWIG__COMMON__NDS_HELPER_HH

#include "daqc.h"

#include "nds_memory.hh"

#include "nds_channel.hh"
#include "nds_availability.hh"

namespace NDS
{
  channel create_channel( const chan_req_t& Source );

  NDS_SHARED_PTR< simple_segment_list_type > simplify_availability( NDS_SHARED_PTR< availability > avail);

  NDS_SHARED_PTR< simple_segment_list_type > simplify_availability( const availability& avail);

  simple_availability_list_type simplify_availability_list(const availability_list_type &avails);

  inline NDS_SHARED_PTR< simple_segment_list_type >
  simplify_availability( NDS_SHARED_PTR< availability > avail)
  {
    return simplify_availability( *avail );
  }

  std::string strip_rate_from_channel_name(const std::string& ch);
}

#endif /* SWIG__COMMON__NDS_HELPER_HH */
