#include "daqc.h"
#include "nds_helper.hh"

//#include "debug_stream.hh"

#include <algorithm>
#include <sstream>

namespace
{
  inline NDS_SHARED_PTR< NDS::simple_segment_list_type >
  simplify_availability_shared_ptr( NDS_SHARED_PTR< NDS::availability > avail)
  {
    return NDS::simplify_availability( *avail );
  }
}

namespace NDS
{
  channel
  create_channel( const chan_req_t& Source )
  {
    channel	retval( Source.name,
			channel::convert_daq_chantype( Source.type ),
			channel::convert_daq_datatype( Source.data_type ),
			Source.rate,
			Source.s.signal_gain,
			Source.s.signal_slope,
			Source.s.signal_offset,
			Source.s.signal_units );

    return retval;
  }

  bool availability_comp( segment_list_type::value_type a,
			  segment_list_type::value_type b )
  {
  	if (a->gps_start < b->gps_start) return true;
  	if (a->gps_start == b->gps_start)
  	{
  		return (a->gps_stop > b->gps_stop);
  	}
  	return false;
  }

  NDS_SHARED_PTR< simple_segment_list_type > simplify_availability( const availability& avail )
  {
      availability sortlist( avail );
      std::sort(sortlist.data.begin(), sortlist.data.end(), availability_comp);
      NDS_SHARED_PTR< simple_segment_list_type > retval( new simple_segment_list_type( ) );

      buffer::gps_second_type gps_cur = 0;
      for (segment_list_type::iterator cur = sortlist.data.begin(); cur != sortlist.data.end(); ++cur)
      {
	buffer::gps_second_type start = (*cur)->gps_start, stop = (*cur)->gps_stop;
          //NDS::dout << "ex: cur = " << gps_cur << " " << (*cur)->frame_type << " " << start << " " << stop << std::endl;
          if (gps_cur >= stop) { continue; }

          if (gps_cur > start) { start = gps_cur; }

          if (gps_cur == start && retval->size() > 0) {
              retval->back()->gps_stop = stop;
          } else {
	    retval->push_back( simple_segment_list_type::value_type( new simple_segment( start, stop ) ) );
          }
          gps_cur = stop;
      }
      return retval;
  }

  simple_availability_list_type simplify_availability_list(const availability_list_type &avails)
  {
      simple_availability_list_type results;
      results.resize(avails.size());
      std::transform(avails.begin(), avails.end(), results.begin(), simplify_availability_shared_ptr);
      return results;
  }

  bool is_numeric_substring(const std::string& ch, std::string::size_type start, std::string::size_type end)
  {
      for (;start < end; ++start) {
          char cur = ch[start];
          if (cur < '0' || cur > '9') return false;
      }
      return true;
  }

  std::string strip_rate_from_channel_name(const std::string& ch)
  {
      std::ostringstream dest;
      std::string::size_type prev = 0;
      std::string::size_type cur = 0;
      bool first = true;

      while ((cur = ch.find_first_of("%,", cur)) != std::string::npos) {
          if (!is_numeric_substring(ch, prev, cur)) {
              dest << (first ? "" : ",") << ch.substr(prev, cur - prev);
              first = false;
          }
          ++cur;
          prev = cur;
      }
      if (!is_numeric_substring(ch, prev, ch.size())) {
          dest << (first ? "" : ",") << ch.substr(prev);
      }
      return dest.str();
  }
}
