#ifndef __NDS_COMPOSER_HH__
#define __NDS_COMPOSER_HH__

#include "nds_export.hh"

namespace NDS
{
  class composer {
  
  public:
    DLL_EXPORT
    composer(request_fragment::working_buffers& buffers,
	     const buffer_initializer &initializer,
	     const gap_handler &_gap_handler,
	     bool empty_buffers_are_safe);
    DLL_EXPORT ~composer();

    DLL_EXPORT void add_segment(const buffers_type_intl &cur_bufs);
    DLL_EXPORT void finish();

  private:
    void initialize_buffers(const buffers_type_intl &ref_set);
    void fill_gap(buffer &cur_buffer, buffer::size_type start_sample, buffer::size_type end_sample);

    request_fragment::working_buffers& buffers;
    const buffer_initializer initializer;
    const gap_handler &_gap_handler;
    std::vector<buffer::size_type> cur_progress;
    std::vector<delayed_gap_handler*> delayed_handlers;
    bool empty_is_safe;
    bool initialized;
    bool finished;

    static fixed_point_gap_handler zero_gap_handler;

    void bounds_check(const buffer& cur_buffer, buffer::size_type cur_fill, buffer::size_type offset_start, buffer::size_type offset_end);

    composer();
    composer(const composer& other);
    composer &operator=(const composer& other);
  };

  inline void composer::
  fill_gap(buffer &cur_buffer, buffer::size_type start_sample, buffer::size_type end_sample)
  {
    static const std::string tname(".n,s-trend");
    static const std::string cmp(".n,");

    // .n trends are always filled with 0s.  This is a flag that the data was gap filled
    // look for .n,s-trend or .n,m-trend, can probably optimize this to look for the '.n,'
    const std::string &name = cur_buffer.Name();
    if (name.size() > tname.size() && name.compare(name.size()-tname.size(), cmp.size(), cmp) == 0)
    {
      zero_gap_handler.fill_gap(cur_buffer, start_sample, end_sample);
    }
    else 
    {
      delayed_gap_handler* tmp = _gap_handler.fill_gap(cur_buffer, start_sample, end_sample);
      if (tmp) delayed_handlers.push_back(tmp);
    }
  }

}	// namespace NDS

#endif // __NDS_COMPOSER_H__
