/* -*- mode: C++ ; c-basic-offset: 2; indent-tabs-mode: nil -*- */

#include <sstream>

#include "daq_config.h"
#include "daqc.h"
#include "daqc_response.h"

#include "nds.hh"
#include "bash_pattern.h"

#if 0
		NDS2_SWIG_EXCEPTION_NONNULL_ARRAY
		nds2_channel ** find_channels(
			size_t *count_channels_ptr,
			c_str channel_glob,
			nds2_channel_type channel_type_mask,
			nds2_data_type data_type_mask,
			double min_smaple_rate,
			double max_sample_rate)
		{
			return nds2_find_channels(
				$self,
				count_channels_ptr,
				channel_glob,
				channel_type_mask,
				data_type_mask,
				min_smaple_rate,
				max_sample_rate);
		}

		NDS2_SWIG_EXCEPTION_NONNULL_ARRAY
		nds2_channel ** find_channels(
			size_t *count_channels_ptr,
			c_str channel_glob,
			nds2_channel_type channel_type_mask,
			nds2_data_type data_type_mask)
		{
			return nds2_find_channels(
				$self,
				count_channels_ptr,
				channel_glob,
				channel_type_mask,
				data_type_mask,
				0.f, 1e12f);
		}

		NDS2_SWIG_EXCEPTION_NONNULL_ARRAY
		nds2_channel ** find_channels(
			size_t *count_channels_ptr,
			c_str channel_glob,
			nds2_channel_type channel_type_mask)
		{
			return nds2_find_channels(
				$self,
				count_channels_ptr,
				channel_glob,
				channel_type_mask,
				(nds2_data_type) 0xFF,
				0.f, 1e12f);
		}

		NDS2_SWIG_EXCEPTION_NONNULL_ARRAY
		nds2_channel ** find_channels(
			size_t *count_channels_ptr,
			c_str channel_glob)
		{
			return nds2_find_channels(
				$self,
				count_channels_ptr,
				channel_glob,
				(nds2_channel_type) 0xFF,
				(nds2_data_type) 0xFF,
				0.f, 1e12f);
		}

		NDS2_SWIG_EXCEPTION_NONNULL_ARRAY
		nds2_channel ** find_channels(
			size_t *count_channels_ptr)
		{
			return nds2_find_channels(
				$self,
				count_channels_ptr,
				NULL,
				(nds2_channel_type) 0xFF,
				(nds2_data_type) 0xFF,
				0.f, 1e12f);
		}

		NDS2_SWIG_EXCEPTION_NONNULL_ARRAY
		nds2_buffer ** fetch(
			size_t *count_channels_ptr,
			long gps_start,
			long gps_stop,
			const char **channel_names,
			size_t count_channels)
		{
			nds2_buffer **ret = nds2_fetch(
				$self,
				gps_start,
				gps_stop,
				channel_names,
				count_channels);
			if (ret)
				*count_channels_ptr = count_channels;
			return ret;
		}

		/* The connection.iterate() method actually returns a pointer to the
		 * connection object itself.*/
		%typemap(out, noblock=1) nds2_connection * {
			#if defined(SWIGJAVA)
			$result = 0;
			#elif defined(SWIGPYTHON)
			Py_INCREF($self);
			$result = $self;
			#elif defined(SWIGOCTAVE)
			$result = args(0);
			#endif
		}
		#if defined(SWIGJAVA)
		%typemap(javaout) nds2_connection * {
			$jnicall;
			return this;
		}
		#endif

		NDS2_SWIG_EXCEPTION_NONNULL
		nds2_connection *iterate(
			const char **channel_names,
			size_t count_channels
		)
		{
			int result = nds2_iterate(
				$self,
				0,
				0,
				0,
				channel_names,
				count_channels
			);
			if (result)
				return NULL;
			else
				return $self;
		}

		NDS2_SWIG_EXCEPTION_NONNULL
		nds2_connection *iterate(
			long stride,
			const char **channel_names,
			size_t count_channels
		)
		{
			int result = nds2_iterate(
				$self,
				0,
				0,
				stride,
				channel_names,
				count_channels
			);
			if (result)
				return NULL;
			else
				return $self;
		}

		NDS2_SWIG_EXCEPTION_NONNULL
		nds2_connection *iterate(
			long gps_start,
			long gps_stop,
			const char **channel_names,
			size_t count_channels
		)
		{
			int result = nds2_iterate(
				$self,
				gps_start,
				gps_stop,
				0,
				channel_names,
				count_channels
			);
			if (result)
				return NULL;
			else
				return $self;
		}

		NDS2_SWIG_EXCEPTION_NONNULL
		nds2_connection *iterate(
			long gps_start,
			long gps_stop,
			long stride,
			const char **channel_names,
			size_t count_channels
		)
		{
			int result = nds2_iterate(
				$self,
				gps_start,
				gps_stop,
				stride,
				channel_names,
				count_channels
			);
			if (result)
				return NULL;
			else
				return $self;
		}

		NDS2_SWIG_EXCEPTION_NONNEG
		bool has_next()
		{
			return nds2_has_next($self);
		}

		NDS2_SWIG_EXCEPTION_NONNULL
		c_str __str__()
		{
			char *ret = NULL;
			if ( asprintf(&ret, "<%s:%d (protocol version %d)>",
					nds2_get_host($self),
					nds2_get_port($self),
					nds2_get_protocol($self) ) < 0 )
			{
				ret = NULL;
			}
			return ret;
		}

		NDS2_SWIG_EXCEPTION_NONNULL
		nds2_buffer ** next(
			size_t *count_channels_ptr
		)
		{
			return nds2_next(
				$self,
				count_channels_ptr
			);
		}

		NDS2_SWIG_EXCEPTION_NONNEG
		int clear_cache()
		{
			return nds2_clear_cache($self);
		}
	}
#endif /* 0 */


#if 0
/* Add string conversion routine for nds2_channel. */
%extend nds2_channel {

	NDS2_SWIG_EXCEPTION_NONNULL
	c_str __str__()
	{
		char *ret = NULL;
		const char *channel_type_str;
		const char *data_type_str;
		switch ($self->channel_type)
		{
			case NDS2_CHANNEL_TYPE_ONLINE:
				channel_type_str = "ONLINE";
				break;
			case NDS2_CHANNEL_TYPE_RAW:
				channel_type_str = "RAW";
				break;
			case NDS2_CHANNEL_TYPE_RDS:
				channel_type_str = "RDS";
				break;
			case NDS2_CHANNEL_TYPE_STREND:
				channel_type_str = "STREND";
				break;
			case NDS2_CHANNEL_TYPE_MTREND:
				channel_type_str = "MTREND";
				break;
			case NDS2_CHANNEL_TYPE_TEST_POINT:
				channel_type_str = "TEST_POINT";
				break;
			case NDS2_CHANNEL_TYPE_STATIC:
				channel_type_str = "STATIC";
				break;
			default:
				channel_type_str = NULL;
		}
		switch ($self->data_type)
		{
			case NDS2_DATA_TYPE_INT16:
				data_type_str = "INT16";
				break;
			case NDS2_DATA_TYPE_INT32:
				data_type_str = "INT32";
				break;
			case NDS2_DATA_TYPE_INT64:
				data_type_str = "INT64";
				break;
			case NDS2_DATA_TYPE_FLOAT32:
				data_type_str = "FLOAT32";
				break;
			case NDS2_DATA_TYPE_FLOAT64:
				data_type_str = "FLOAT64";
				break;
			case NDS2_DATA_TYPE_COMPLEX32:
				data_type_str = "COMPLEX32";
				break;
			case NDS2_DATA_TYPE_UINT32:
				data_type_str = "UINT32";
				break;
			default:
				data_type_str = NULL;
		}
		if ( asprintf(&ret, "<%s (%gHz, %s, %s)>",
				$self->name,
				(double)$self->sample_rate,
				channel_type_str,
				data_type_str ) < 0 )
		{
			ret = NULL;
		}
		return ret;
	}

	NDS2_SWIG_EXCEPTION_NOOP
};


/* Add string conversion routine for nds2_buffer. */
%extend nds2_buffer {

	NDS2_SWIG_EXCEPTION_NONNULL
	c_str __str__()
	{
		char *ret = NULL;
		if( asprintf(&ret, "<%s (GPS time %ld.%09ld, %ld samples)>",
				$self->channel.name,
				$self->gps_seconds,
				$self->gps_nanoseconds,
				$self->length ) < 0 )
		{
			ret = NULL;
		}
		return ret;
	}

	NDS2_SWIG_EXCEPTION_NOOP

};


NDS2_SWIG_EXCEPTION_NOOP
#endif /* 0 */
