#========================================================================
# NOTES:
#    The octave default is to check for a system supplied package.
#
# OCTIVE override:
#    You can specify to build without octive support by specifying
#      --without octive
#    when invoking rpmbuild.
#========================================================================
%define name 	nds2-client
%define version 0.15.2
%define release 1
%define _prefix /usr
%define _includedir %{_prefix}/include/%{name}
%define _pkgdocdir  %{_defaultdocdir}/%{name}

%define _use_internal_dependency_generator 0
%define __find_requires %{_builddir}/%{name}-%{version}/config/nds-find-requires

#========================================================================
#
#  Set up octave symbols as appropriate
#
#========================================================================
%if %{?_without_octave:1}%{!?_without_octave:0}
%define octave_installed %(echo 0)
%else
%define octave_installed %(test -e /usr/bin/octave && echo 1 || echo 0)
%endif

%define octave_build_opts %{nil}

%if 1%{octave_installed}
%define _octdatadir %(octave-config --m-site-dir)
%define _octexecdir %(octave-config --oct-site-dir)
%define octave_build_opts -DENABLE_SWIG_OCTAVE=yes -Dpkgoctdatadir=%_octdatadir -DOCTAVE_INSTALL_DIR=%_octexecdir
%endif

#========================================================================
#
#           Set up python symbols as appropriate
#
#========================================================================
%define python_installed %(echo 1)
%define python_build_opts  -DPYTHON_MODULE_INSTALL_DIR=%{python_sitelib} -DPYTHON_EXTMODULE_INSTALL_DIR=%{python_sitearch}

#========================================================================

#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# Sanity checks
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

#========================================================================
# Main spec file
#========================================================================
Name: 		%{name}
Summary: 	NDS2 Client interface
Version: 	%{version}
Release: 	%{release}%{?dist}
License: 	GPL
Group: 		LSC Software/Data Analysis
Source: 	%{name}-%{version}.tar.gz
Packager: 	Edward Maros (ed.maroso@ligo.org)
URL: 		https://www.lsc-group.phys.uwm.edu/daswg/wiki/NetworkDataServer2
BuildRoot:      %{buildroot}
BuildRequires: 	gcc, gcc-c++, glibc
%if 0%{?rhl} <= 7 || 0%{?sl7} <= 7
BuildRequires:  cmake3 >= 3.6
%else
BuildRequires:  cmake >= 3.6
%endif
BuildRequires:  make
BuildRequires:	gawk, pkgconfig
BuildRequires:	sqlite-devel
BuildRequires:  swig >= 3.0.7
BuildRequires:	python-devel, numpy
BuildRequires:	java-1.7.0-openjdk-devel, octave-devel
BuildRequires:	cyrus-sasl-devel, cyrus-sasl-gssapi
BuildRequires:	libcurl-devel
BuildRequires:	fontconfig-devel
BuildRequires:	mesa-libGLU-devel
BuildRequires:	pcre-devel
%if 0%{?rhel} >= 7
BuildRequires:	gl2ps-devel
BuildRequires:	qrupdate-devel
BuildRequires:	arpack-devel
BuildRequires:	suitesparse-devel
%endif
Requires:       cyrus-sasl, cyrus-sasl-gssapi
Provides: 	%name
Obsoletes:	%name < %version
Prefix:		%_prefix

%description
The NDS2 client interface allow the user to down-load LIGO data from V1 and V2 LIGO Network Data Servers.

%package devel
Group: Development/Scientific
Summary: NDS2 development headers and documentation
Requires: %{name}-headers = %{version}, %{name} = %{version}, cyrus-sasl-devel
%description devel
This package supports development using the nds2 client protocol.

%package man
Group: Development/Scientific
Summary: NDS2 client man pages files
Requires: %{name} = %{version}
BuildArch: noarch
%description man
This package contains the man pages for the nds2-client package and its
high-level language extensions.

%package java
Group: Development/Scientific
Summary: Java extensions for NDS2
Requires: %{name} = %{version}
%description java
This provides java wrappers for the nds2 client

%package matlab
Group: Development/Scientific
Summary: MATLAB extensions for NDS2
Requires: %{name} = %{version}, %{name}-java = %{version}
%description matlab
This provides MATLAB wrappers for the nds2 client

%package octave
Group: Development/Scientific
Summary: Octave extensions for NDS2
Requires: %{name} = %{version}
%description octave
This provides extensions to octave to access an NDS2 server

%package python
Group: Development/Scientific
Summary: Python extensions for NDS2
Requires: %{name} = %{version}
%description python
This provides python wrappers for the nds2 client

%package headers
Group: Development/Scientific
Summary: NDS2 headers
BuildArch: noarch
%description headers
This provides a separate package to install the headers shared by the 64 and 32 bit versions.

%package all
Group:     Development/Scientific
Summary:   NDS2 Client interface
BuildArch: noarch
Requires:  %{name} = %{version}
Requires:  %{name}-devel = %{version}
Requires:  %{name}-man = %{version}
Requires:  %{name}-java = %{version}
Requires:  %{name}-matlab = %{version}
Requires:  %{name}-octave = %{version}
Requires:  %{name}-python = %{version}
Requires:  %{name}-headers = %{version}
%description all
 The Network Data Server (NDS) is a TCP/IP protocol for retrieving
 online or archived data from thousands of instrument channels at LIGO
 (Laser Interferometer Gravitational-Wave Observatory) sites and data
 analysis clusters.  Version 2 of the protocol includes communication
 with Kerberos and GSSAPI.
 .
 This package installs all NDS2 client packages, including libraries,
 language bindings, binary interface, and documentation.

#----------------------------------------------
# Get onto the fun of building the NDS software
#----------------------------------------------

%prep
%setup -q

%build
%if %{?cmake3:1}%{!?cmake3:0}
%cmake3 %{octave_build_opts} %{python_build_opts} -DWITH_SASL=yes -DWITH_GSSAPI=no -DCMAKE_BUILD_TYPE=RelWithDebInfo -DCMAKE_EXPORT_COMPILE_COMMANDS=1 .
%define ctest ctest3
%else
%cmake %{octave_build_opts} %{python_build_opts} -DWITH_SASL=yes -DWITH_GSSAPI=no -DCMAKE_BUILD_TYPE=RelWithDebInfo -DCMAKE_EXPORT_COMPILE_COMMANDS=1 .
%define ctest ctest
%endif

%install
make install DESTDIR=%{buildroot}

%check
%ctest -V %{?_smp_mflags}

#----------------------------------------------
# Remove files that will not be packaged based
# on the arch type
#----------------------------------------------

#----------------------------------------------
# Do the noarch files
#----------------------------------------------
%files headers
%{_includedir}/*.h
%{_includedir}/*.hh

%files man
%{_mandir}

#----------------------------------------------
# Handle binary packages
#----------------------------------------------
%define platform_64_bit %(echo %{_libdir} | grep 64 && echo 1 || echo 0)

%files
%defattr(-,root,root)
%_bindir/*
%_libdir/libndsclient*.so.*
%_libdir/libndsxxwrap*.so.*
%_sysconfdir/*-user-env*
%_sysconfdir/%{name}/%{name}.cfg

%files devel
%_libdir/libndsclient*.so
%_libdir/libndsxxwrap*.so
%_libdir/libndsclient*.a
%_libdir/libndsxxwrap*.a
%_libdir/pkgconfig/%{name}.pc

#------------------------------------------------------------------------
# Java
#------------------------------------------------------------------------
%files java
%_libdir/java/nds2
%_libdir/%{name}/java
%_datadir/%{name}/java
%_sysconfdir/%{name}/%{name}-java.cfg

#------------------------------------------------------------------------
# Octave
#------------------------------------------------------------------------
%if %{octave_installed}
%files octave
%{_octexecdir}
%_sysconfdir/%{name}/%{name}-octave.cfg
%endif

#------------------------------------------------------------------------
# Python
#------------------------------------------------------------------------
%if %{python_installed}
%files python
%{python_sitearch}/
%{python_sitelib}/
%_sysconfdir/%{name}/%{name}-py*.cfg
%endif

#------------------------------------------------------------------------
# MATLAB
#------------------------------------------------------------------------
%files matlab
%_datadir/%{name}/matlab
%_sysconfdir/%{name}/%{name}-matlab.cfg

#------------------------------------------------------------------------
# All - metapackage
#------------------------------------------------------------------------
%files all
