#------------------------------------------------------------------------
# -*- mode: cmake -*-
#
# NOTE:
#   Must be called after including CPack
#------------------------------------------------------------------------
include( CMakeParseArguments )

function(ax_packaging_rpm_spec_file)
  set(options)
  set(oneValueArgs INPUT OUTPUT)
  set(multiValueArgs)
  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  if(NOT ARG_INPUT)
    set(ARG_INPUT "${CMAKE_SOURCE_DIR}/cmake/${PROJECT_NAME}.spec.in")
  endif(NOT ARG_INPUT)
  if(NOT ARG_OUTPUT)
    set(ARG_OUTPUT "${CMAKE_BINARY_DIR}/${PROJECT_NAME}.spec")
  endif(NOT ARG_OUTPUT)
  configure_file( ${ARG_INPUT} ${ARG_OUTPUT} @ONLY )
endfunction(ax_packaging_rpm_spec_file)

#------------------------------------------------------------------------

function(ax_packaging_rpm)
  #----------------------------------------------------------------------
  # RPM Spec file
  #----------------------------------------------------------------------
  if ( NOT AX_SOURCE_SPEC_FILENAME )
    set( AX_SOURCE_SPEC_FILENAME ${CMAKE_CURRENT_SOURCE_DIR}/${PROJECT_NAME}.spec.cmake.in )
  endif ( NOT AX_SOURCE_SPEC_FILENAME )
  ax_packaging_rpm_spec_file( INPUT ${AX_SOURCE_SPEC_FILENAME}
    		  	      OUTPUT ${PROJECT_SPEC_FILENAME}
		  	      @ONLY
  )
  find_program(RPMBUILD rpmbuild)
  if (RPMBUILD)
    set(TAR_DIR_NAME "${PROJECT_NAME}-${${PROJECT_NAME}_VERSION}")
    add_custom_target(rpm
		      COMMAND ${CMAKE_COMMAND} -E echo "Building RPM package..."
		      COMMAND ${RPMBUILD} -v -ta --clean "${CMAKE_BINARY_DIR}/${TAR_DIR_NAME}.tar.gz")
    add_dependencies(rpm dist)
  else (RPMBUILD)
    add_custom_target(rpm
    		      COMMAND ${CMAKE_COMMAND} -E echo "This platform does not support building of RPM packages")
  endif(RPMBUILD)
endfunction(ax_packaging_rpm)

#------------------------------------------------------------------------
