#
# Unit tests against mock-up NDS 1 server
#
# Copyright (C) 2014  Leo Singer <leo.singer@ligo.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

import nds2
import os
from binascii import unhexlify

bytepatterns = [
    unhexlify('B000'),
    unhexlify('DEADBEEF'),
    unhexlify('00000000FEEDFACE')]

port = int(os.environ['NDS_TEST_PORT'])

conn = nds2.connection('localhost', port, nds2.connection.PROTOCOL_ONE)
assert conn.get_port() == port
assert conn.get_protocol() == 1

channels = conn.find_channels('X*:{A,B,C}')
assert len(channels) == 3
assert str(channels[0]) == '<X1:A (16Hz, ONLINE, INT16)>'
assert str(channels[1]) == '<X1:B (16Hz, ONLINE, INT32)>'
assert str(channels[2]) == '<X1:C (16Hz, ONLINE, INT64)>'

bufs = conn.fetch(1000000000, 1000000004, ['X1:A', 'X1:B', 'X1:C'])
assert len(bufs) == 3
for buf, bytepattern in zip(bufs, bytepatterns):
    assert buf.gps_seconds == 1000000000
    assert buf.gps_nanoseconds == 0
    assert len(buf.data) == 4 * buf.channel.sample_rate
    assert bytes(buf.data.data) == bytepattern * len(buf.data)

for bufs in conn.iterate(['X1:A', 'X1:B', 'X1:C']):
    break
assert len(bufs) == 3
for buf, bytepattern in zip(bufs, bytepatterns):
    assert buf.gps_seconds == 1000000000
    assert buf.gps_nanoseconds == 0
    assert len(buf.data) == buf.channel.sample_rate
    assert bytes(buf.data.data) == bytepattern * len(buf.data)

# connection automatically closed when garbage collected,
# but test explicit close anyway
conn.close()
