/* Use methods named '__str__' to supply string representations of objects. */
%feature("python:slot", "tp_str", functype="reprfunc") __str__;

/* And have '__repr__' also call '__str__'. */
%{
PyObject *trivial_repr(PyObject *o)
{
    return PyObject_Str(o);
}
%}
%feature("python:tp_repr") _nds2_connection "trivial_repr";
%feature("python:tp_repr") nds2_channel "trivial_repr";
%feature("python:tp_repr") nds2_buffer "trivial_repr";

/* SIGH. Also have tp_print call '__str__'. */
%{
int trivial_print(PyObject *o, FILE *fp, int flags)
{
    int ret = -1;
    PyObject *str = PyObject_Str(o);
    if (str)
    {
        ret = PyObject_Print(str, fp, flags);
        Py_DECREF(str);
    }
    return ret;
}
%}
%feature("python:tp_print") _nds2_connection "trivial_print";
%feature("python:tp_print") nds2_channel "trivial_print";
%feature("python:tp_print") nds2_buffer "trivial_print";

/*
 * Make nds2_connection an actual Python iterator.
 */
%wrapper %{
static PyObject *_nds2_connection_iter(PyObject *o)
{
	Py_INCREF(o);
	return o;
}
static PyObject *_wrap_connection_next(PyObject *, PyObject *);
static PyObject *_nds2_connection_iternext(PyObject *o)
{
	return _wrap_connection_next(o, NULL);
}
%}
%feature("python:tp_iter") _nds2_connection "_nds2_connection_iter";
%feature("python:tp_iternext") _nds2_connection "_nds2_connection_iternext";
%init %{
	((PyTypeObject *) &SwigPyBuiltin___nds2_connection_type)->tp_flags |= Py_TPFLAGS_HAVE_ITER;
%}

/*
 * Support string arrays as char ** input arguments.
 */
%typemap(in, numinputs=1, noblock=1) (const char **channel_names, size_t count_channels) {
	{
		size_t i;
		PyObject *fseq = PySequence_Fast($input, "channel_names must be a sequence (tuple or list)");
		if (!fseq)
			SWIG_fail;

		$2 = PySequence_Fast_GET_SIZE(fseq);
		$1 = calloc($2, sizeof(char *));
		for (i = 0; i < $2; i ++)
		{
			$1[i] = PyString_AsString(PySequence_ITEM(fseq, i));
			if (!$1[i])
			{
				Py_DECREF(fseq);
				SWIG_fail;
			}
		}
		Py_DECREF(fseq);
	}
}

%typemap(freearg, noblock=1) (const char **channel_names, size_t count_channels) {
	free($1);
}

/* Override default type checking behavior for resolving overloaded functions.
 * By default, swig would check for a wrapped const char **, but we want it
 * to check for a sequence object. */
%typemap(typecheck, numinputs=1, noblock=1) (const char **channel_names, size_t count_channels) {
	$1 = PySequence_Check($input);
}

/**
 * Support nds2_channel and nds2_buffer arrays double-pointer return values,
 * with the size stored in the second argument of type size_t *count_channels_ptr.
 */

%typemap(in, numinputs=0, noblock=1) size_t *count_channels_ptr (size_t count_channels = 1) {
	$1 = &count_channels;
}

%typemap(out, noblock=1) SWIGTYPE ** {
	$result = PyTuple_New(*arg2);
	if (!$result)
		SWIG_fail;

	{
		size_t i;
		for (i = 0; i < *arg2; i ++)
			PyTuple_SET_ITEM($result, i, SWIG_NewPointerObj($1[i], $*1_descriptor, 1));
	}
}

%typemap(newfree, noblock=1) SWIGTYPE ** {
	free($1);
}

%apply SWIGTYPE ** {nds2_channel **, nds2_buffer **};

/**
 * Make buffer.getChannel return a copy.
 */

%typemap(out, noblock=1) nds2_channel * (nds2_channel *ptr) {
	ptr = (nds2_channel *) calloc(1, sizeof(nds2_channel));
	memcpy(ptr, $1, sizeof(nds2_channel));
	$result = SWIG_NewPointerObj(ptr, $1_descriptor, 1);
}

/**
 * Support getting numeric arrays from unsigned char[] using polymorphism.
 */

%{
#include <numpy/arrayobject.h>
%}

%init %{
	import_array();
%}

%typemap(out) unsigned char [] {
	npy_intp dims[] = {arg1->length};
	int typenum;

	switch (arg1->channel.data_type)
	{
		case NDS2_DATA_TYPE_INT16:
			typenum = NPY_INT16;
			break;
		case NDS2_DATA_TYPE_INT32:
			typenum = NPY_INT32;
			break;
		case NDS2_DATA_TYPE_INT64:
			typenum = NPY_INT64;
			break;
		case NDS2_DATA_TYPE_FLOAT32:
			typenum = NPY_FLOAT32;
			break;
		case NDS2_DATA_TYPE_FLOAT64:
			typenum = NPY_FLOAT64;
			break;
		case NDS2_DATA_TYPE_COMPLEX32:
			typenum = NPY_COMPLEX64;
			break;
		default:
			SWIG_exception(SWIG_TypeError, "Unknown NDS data type");
			break;
	}

	$result = PyArray_SimpleNewFromData(1, dims, typenum, $1);
	if (!$result)
		SWIG_fail;

	Py_INCREF($self);
	PyArray_BASE($result) = $self;
}

