%
% Unit tests against mock-up NDS 1 server
%
% Copyright (C) 2014  Leo Singer <leo.singer@ligo.org>
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along
% with this program; if not, write to the Free Software Foundation, Inc.,
% 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%

nds2;

bytepatterns = {
    cast([0xB0; 0x00], 'uint8'),
    cast([0xDE; 0xAD; 0xBE; 0xEF], 'uint8'),
    cast([0x00; 0x00; 0x00; 0x00; 0xFE; 0xED; 0xFA; 0xCE], 'uint8')
};

port = str2num(getenv('NDS_TEST_PORT'))

conn = nds2.connection('localhost', port, 1)
assert (conn.get_port(), port)
assert (conn.get_protocol(), 1)

channels = conn.find_channels('X*:{A,B,C}')
assert (length(channels), 3)
assert (sprintf(channels{1}), '<X1:A (16Hz, ONLINE, INT16)>')
assert (sprintf(channels{2}), '<X1:B (16Hz, ONLINE, INT32)>')
assert (sprintf(channels{3}), '<X1:C (16Hz, ONLINE, INT64)>')

bufs = conn.fetch(1000000000, 1000000004, {'X1:A', 'X1:B', 'X1:C'})
assert (length(bufs), 3)
for i = 1:length(bufs)
    buf = bufs{i};
    bytepattern = bytepatterns{i};
    assert (buf.gps_seconds, 1000000000)
    assert (buf.gps_nanoseconds, 0)
    assert (length(buf.data), 4 * buf.channel.sample_rate)
    assert (typecast(buf.data, 'uint8'), repmat(bytepattern, length(buf.data), 1))
end

conn.iterate({'X1:A', 'X1:B', 'X1:C'})
bufs = conn.next()
assert (length(bufs), 3)
for i = 1:length(bufs)
    buf = bufs{i};
    bytepattern = bytepatterns{i};
    assert (buf.gps_seconds, 1000000000)
    assert (buf.gps_nanoseconds, 0)
    assert (length(buf.data), buf.channel.sample_rate)
    assert (typecast(buf.data, 'uint8'), repmat(bytepattern, length(buf.data), 1))
end

% connection automatically closed when garbage collected,
% but test explicit close anyway
conn.close()
