% Import module
nds2;

% Open connection and print some information about the server
conn = nds2.connection('llocds.ligo-la.caltech.edu');
disp('Connection:'); disp(conn);
disp(sprintf('Host: %s', conn.get_host()));
disp(sprintf('Port: %d', conn.get_port()));
disp(sprintf('Protocol: %d', conn.get_protocol()));

% Get list of available channels and print some information about them
channels = conn.find_channels('L1:*PEM-EY*');
disp(sprintf('Number matching of channels: %d', length(channels)));
disp('First channel:'); disp(channels{1});
disp(sprintf('First channel name: %s', channels{1}.name));

% Fetch some data
data = conn.fetch(1038296031, 1038296035, ...
    {'L1:PEM-EY_SEISX_OUT_DQ', 'L1:PEM-EY_SEISY_OUT_DQ', 'L1:PEM-EY_SEISZ_OUT_DQ'});
disp('A buffer:'); disp(data{1});
disp('Its data:'); disp(data{1}.data);
disp('Its channel:'); disp(data{1}.channel);

disp('Now block by block...');
conn.iterate(1038296031, 1038296035, 1, {'L1:PEM-EY_SEISX_OUT_DQ', 'L1:PEM-EY_SEISY_OUT_DQ', 'L1:PEM-EY_SEISZ_OUT_DQ'})
while conn.has_next()
    bufs = conn.next();
    disp(bufs);
end
