function chanlist = NDS_GetChannels(server)
%NDS_GetChannels Get a list of channels available from a LIGO NDS2 server
%
% The primary use of this function is to produce a channel list that can be
% fed to NDS_GetData. This function first attempts to connect to an nds2
% server and if this fails, attempts to connect using the nds1 protocol.
%
% Usage:
%
%   chanlist = NDS_GetChannels(server)
%
% Where:
%
%   server   is a string with the NDS2 server IP address and port 
%            in the form '<ip-addr>:<port>'.
%
%   chanlist is a Matlab cell-array containing channel information
%             name           Channel name
%             group_num      Group number (Channel type in NDS2)
%             rate           Sample rate
%             tpnum          Test-point number (nds1 only)
%             bps            Bytes per sample
%             data_type      Data type
%             signal_gain    Online signal gain
%             signal_offset  Online signal offset
%             signal_slope   Online signal slope
%             signal_units   Online Signal unit string
%
% Note: This function is superceded by NDS2_GetData and NDS2_GetChannels.
%
% See also NDS_GetData, NDS2_GetChannels, NDS2_GetData.
