% -*- mode: octave; -*-
disp('entry demo_setup.m')
%========================================================================
% This helps set up MATLAB and similar environments to run the demo
% scripts.
%========================================================================
if 1
if ispc
  path([getenv('USERPROFILE') '\MATLAB'],path)
else
  path([getenv('HOME') '/.matlab'], path)
end
end % 0
%------------------------------------------------------------------------
% MATLAB vs octave
%------------------------------------------------------------------------
if 1
if [ exist('OCTAVE_VERSION') ]
  ismatlab = 0;
else
  ismatlab = 1;
  ndsmatlab_ver = regexprep([version],'^.*\(R([^)]*)\)$','$1');
end
end % 0
%------------------------------------------------------------------------
% The following command is intended to allow for user's customization
%   for local installations.
% nds_setup needs to define the following variables:
%
%   kerberos_dir      -
%   ndsclient_dir     -
%
%   ndsmatlab_bin_dir -
%   ndsmatlab_m_dir   -
%
%------------------------------------------------------------------------

if 1
if ispc
  path_sep = ';';
  libpath = 'PATH';
else
  if ismac
    libpath = 'DYLD_LIBRARY_PATH';
  else
    libpath = 'LD_LIBRARY_PATH';
  end
  path_sep = ':';
end
end % 0

if 1
nds_setup
end % 0

if 1
if ( [exist('kerberos_dir')] )
  setenv(libpath,[kerberos_dir path_sep getenv(libpath)])
end
if ( [exist('ndsclient_dir')] )
  setenv(libpath,[ndsclient_dir path_sep getenv(libpath)])
end
if ( [exist('ndsmatlab_m_dir')] )
  if ismatlab
    path(ndsmatlab_m_dir, path)
  end
end
if ( [exist('ndsmatlab_bin_dir')] )
  path(ndsmatlab_bin_dir, path)
end
end % 0
disp('exit demo_setup.m')
