#========================================================================
# NOTES:
#    The octave default is to check for a system supplied package.
#    The matlab default is to check /ldcg for directories of the form
#       matlab_r<ver>.
#
# MATLAB override:
#    You can specify to build no matlab packages by specifying
#      --without matlab
#    when invoking rpmbuild.
#    If your matlab packages are rooted in a directory other than /ldcg,
#    then you must specify
#      --with matlab --define '_matlab_base_dir <dir>'
#    when invoking matlab.
#      <dir> is the parent directory of the matlab packages.
#
# OCTIVE override:
#    You can specify to build without octive support by specifying
#      --without octive
#    when invoking rpmbuild.
#========================================================================
%define name 	nds2-client
%define version 0.10.4
%define release 1
%define _prefix /usr
%define _sysconfdir %{_prefix}/etc
%define _includedir %{_prefix}/include/%{name}
%define _pkgdocdir  %{_defaultdocdir}/%{name}

%define _use_internal_dependency_generator 0
%define __find_requires %{_builddir}/%{name}-%{version}/config/nds-find-requires

#========================================================================
#
#   configure no-architecture
%define config_noarch \
  CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS ; \
  CXXFLAGS="${CXXFLAGS:-%optflags}" ; export CXXFLAGS ; \
  FFLAGS="${FFLAGS:-%optflags}" ; export FFLAGS ; \
  %{_configure} \\\
        --program-prefix=%{?_program_prefix} \\\
        --prefix=%{_prefix} \\\
        --exec-prefix=%{_exec_prefix} \\\
        --bindir=%{_bindir} \\\
        --sbindir=%{_sbindir} \\\
        --sysconfdir=%{_sysconfdir} \\\
        --datadir=%{_datadir} \\\
        --includedir=%{_includedir} \\\
        --libdir=%{_libdir} \\\
        --libexecdir=%{_libexecdir} \\\
        --localstatedir=%{_localstatedir} \\\
        --sharedstatedir=%{_sharedstatedir} \\\
        --mandir=%{_mandir} \\\
        --infodir=%{_infodir}
#
#========================================================================

#========================================================================
#
#  Set up octave symbols as appropriate
#
%if %{?_without_octave:1}%{!?_without_octave:0}
%define octave_installed %(echo 0)
%else
%define octave_installed %(test -e /usr/bin/octave && echo 1 || echo 0)
%endif

%define octave_build_opts %{nil}

%if %{octave_installed}
%define _octdatadir %(octave-config --m-site-dir)
%define _octexecdir %(octave-config --oct-site-dir)
%define octave_build_opts pkgoctdatadir=%_octdatadir pkgoctexecdir=%_octexecdir
%endif
#========================================================================

#========================================================================
#
#           Set up python symbols as appropriate
#
%define python_installed %(echo 1)
%define python_build_opts %{nil}
#========================================================================

#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# Sanity checks
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#
# --with-matlab option is no longer used
#
# %if %{?_matlab_base_dir:1}%{!?_matlab_base_dir:0}
# %define _matlab_configure_option --with-matlab=%{_matlab_base_dir}
# %else
# %define _matlab_configure_option 
# %endif
#
%if %{!?_without_matlab:1}%{?_without_matlab:0}
%define _matlab_configure_option %{nil}
%define matlab_installed %(echo 1)
%else
%define _matlab_configure_option %{nil}
%define matlab_installed %(echo 0)
%endif

#========================================================================
# Main spec file
#========================================================================
Name: 		%{name}
Summary: 	NDS2 Client interface
Version: 	%{version}
Release: 	%{release}
License: 	GPL
Group: 		LSC Software/Data Analysis
Source: 	%{name}-%{version}.tar.gz
Packager: 	John Zweizig (john.zweizig@ligo.org)
BuildRoot: 	%{_tmppath}/%{name}-%{version}-root
URL: 		https://www.lsc-group.phys.uwm.edu/daswg/wiki/NetworkDataServer2
BuildRequires: 	gcc, gcc-c++, glibc, automake, autoconf, libtool, m4, make
Summary: 	DMT offline
Provides: 	%name
Obsoletes:	%name < %version
Prefix:		%_prefix

%description
The NDS2 client interface allow the user to down-load LIGO data from the V2 LIGO Network Data Servers.

%package devel
Group: Development/Scientific
Summary: NDS2 development headers and dosumentation
Requires: nds2-client-headers cyrus-sasl-devel
%description devel
This package supports development using the nds2 client protocol.

%package doc
Group: Development/Scientific
Summary: NDS2 client documentation files
Requires: nds2-client
%description doc
This package contains the documentation for the nds2-client package and its
high-level language extensions.

%package man
Group: Development/Scientific
Summary: NDS2 client man pages files
Requires: nds2-client
%description man
This package contains the man pages for the nds2-client package and its
high-level language extensions.

%package java
Group: Development/Scientific
Summary: Java extensions for NDS2
Requires: nds2-client
%description java
This provides java wrappers for the nds2 client

%package octave
Group: Development/Scientific
Summary: Octave extensions for NDS2
Requires: nds2-client
%description octave
This provides extensions to octave to access an NDS2 server

%package python
Group: Development/Scientific
Summary: Python extensions for NDS2
Requires: nds2-client
%description python
This provides python wrappers for the nds2 client

%package matlab
Obsoletes: nds2-client-matlab2006a nds2-client-matlab2006b nds2-client-matlab2007a nds2-client-matlab2007b nds2-client-matlab2008a nds2-client-matlab2008b nds2-client-matlab2009a nds2-client-matlab2009b nds2-client-matlab2010a nds2-client-matlab2010b nds2-client-matlab2011a nds2-client-matlab2011b nds2-client-matlab2012a
Group: Development/Scientific
Summary: MATLAB extensions for NDS2
Requires: nds2-client
%description matlab
This provides extensions to MATLAB to access data from an NDS2 server

%package headers
Group: Development/Scientific
Summary: NDS2 headers
%description headers
This provides a separate package to install the headers shared by the 64 and 32 bit versions.

#----------------------------------------------
# Get onto the fun of building the NDS software
#----------------------------------------------
%prep
%setup

%build
PKG_CONFIG_PATH=/usr/%{_lib}/pkgconfig
export PKG_CONFIG_PATH
%ifnarch noarch
%configure \
	--prefix=%{prefix} \
	%{?_matlab_configure_option}	\
	%{?_without_matlab}		\
	%{?_with_octave}		\
	%{?_without_octave}
%else
%config_noarch \
	--prefix=%{prefix} \
	%{?_matlab_configure_option}	\
	%{?_without_matlab}		\
	%{?_with_octave}		\
	%{?_without_octave}
%endif
make %{octave_build_opts}
make check

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot} %{octave_build_opts}

#----------------------------------------------
# Remove files that will not be packaged based
# on the arch type
#----------------------------------------------
%ifarch noarch
rm -rf %{buildroot}%{_bindir}
rm -rf %{buildroot}%{_libdir}
rm -f %{buildroot}%{_sysconfdir}/${name}*
%if %{octave_installed}
rm -rf %{buildroot}%{_octdatadir} %{buildroot}%{_octexecdir}
%endif
%if %{python_installed}
rm -rf  %{buildroot}%{python_sitearch} %{buildroot}%{python_sitelib}
%endif
%else
rm -rf %{buildroot}%{_includedir}
rm -rf %{buildroot}%{_datadir}/matlab/*
rm -rf %{buildroot}%{_pkgdocdir}
rm -rf %{buildroot}%{_mandir}
%endif

%ifarch noarch
#----------------------------------------------
# Do the noarch files
#----------------------------------------------
%files headers
%{_includedir}/*.h

%files doc
%{_pkgdocdir}

%files man
%{_mandir}

%else

#----------------------------------------------
# Handle binary packages
#----------------------------------------------
%define platform_64_bit %(echo %{_libdir} | grep 64 && echo 1 || echo 0)

%files
%defattr(-,root,root)
%_bindir/*
%_libdir/lib*.so*
%_sysconfdir/*

%files devel
%_libdir/lib*.a
%_libdir/lib*.la
%_libdir/pkgconfig/nds2-client.pc

#------------------------------------------------------------------------
# Java
#------------------------------------------------------------------------
%files java
%{_libdir}/java/nds2

#------------------------------------------------------------------------
# Matlab
#
# Note that a single matlab package is distributed starting with 
# nds2-client-0.10.0-b4 (svn 1004)
#------------------------------------------------------------------------
%if %{matlab_installed}
%files matlab
%{_libdir}/matlab
%endif

#------------------------------------------------------------------------
# Octave
#------------------------------------------------------------------------
%if %{octave_installed}
%files octave
%{_octdatadir}
%{_octexecdir}
%endif

#------------------------------------------------------------------------
# Python
#------------------------------------------------------------------------
%if %{python_installed}
%files python
%{python_sitearch}/
%{python_sitelib}/
%endif

%endif
