#include <stdlib.h>
#include <sys/time.h>

#include "frequencies.h"

/* --------------------------------------------------------------------- */

/* US broadcast */
static struct CHANLIST ntsc_bcast[] = {
    { "2",       55250 },
    { "3",       61250 },
    { "4",       67250 },

    { "5",       77250 },
    { "6",       83250 },

    { "7",      175250 },
    { "8",      181250 },
    { "9",      187250 },
    { "10",     193250 },
    { "11",     199250 },
    { "12",     205250 },
    { "13",     211250 },

    { "14",     471250 },
    { "15",     477250 },
    { "16",     483250 },
    { "17",     489250 },
    { "18",     495250 },
    { "19",     501250 },
    { "20",     507250 },
    { "21",     513250 },
    { "22",     519250 },
    { "23",     525250 },
    { "24",     531250 },
    { "25",     537250 },
    { "26",     543250 },
    { "27",     549250 },
    { "28",     555250 },
    { "29",     561250 },
    { "30",     567250 },
    { "31",     573250 },
    { "32",     579250 },
    { "33",     585250 },
    { "34",     591250 },
    { "35",     597250 },
    { "36",     603250 },
    { "37",     609250 },
    { "38",     615250 },
    { "39",     621250 },
    { "40",     627250 },
    { "41",     633250 },
    { "42",     639250 },
    { "43",     645250 },
    { "44",     651250 },
    { "45",     657250 },
    { "46",     663250 },
    { "47",     669250 },
    { "48",     675250 },
    { "49",     681250 },
    { "50",     687250 },
    { "51",     693250 },
    { "52",     699250 },
    { "53",     705250 },
    { "54",     711250 },
    { "55",     717250 },
    { "56",     723250 },
    { "57",     729250 },
    { "58",     735250 },
    { "59",     741250 },
    { "60",     747250 },
    { "61",     753250 },
    { "62",     759250 },
    { "63",     765250 },
    { "64",     771250 },
    { "65",     777250 },
    { "66",     783250 },
    { "67",     789250 },
    { "68",     795250 },
    { "69",     801250 },
};

/* US cable */
static struct CHANLIST ntsc_cable[] = {
    { "2",       55250 },
    { "3",       61250 },
    { "4",       67250 },
    { "5",       77250 },
    { "6",       83250 },
    { "7",      175250 },
    { "8",      181250 },
    { "9",      187250 },
    { "10",     193250 },
    { "11",     199250 },
    { "12",     205250 },

    { "13",     211250 },
    { "14",     121250 },
    { "15",     127250 },
    { "16",     133250 },
    { "17",     139250 },
    { "18",     145250 },
    { "19",     151250 },
    { "20",     157250 },

    { "21",     163250 },
    { "22",     169250 },
    { "23",     217250 },
    { "24",     223250 },
    { "25",     229250 },
    { "26",     235250 },
    { "27",     241250 },
    { "28",     247250 },
    { "29",     253250 },
    { "30",     259250 },
    { "31",     265250 },
    { "32",     271250 },
    { "33",     277250 },
    { "34",     283250 },
    { "35",     289250 },
    { "36",     295250 },
    { "37",     301250 },
    { "38",     307250 },
    { "39",     313250 },
    { "40",     319250 },
    { "41",     325250 },
    { "42",     331250 },
    { "43",     337250 },
    { "44",     343250 },
    { "45",     349250 },
    { "46",     355250 },
    { "47",     361250 },
    { "48",     367250 },
    { "49",     373250 },
    { "50",     379250 },
    { "51",     385250 },
    { "52",     391250 },
    { "53",     397250 },
    { "54",     403250 },
    { "55",     409250 },
    { "56",     415250 },
    { "57",     421250 },
    { "58",     427250 },
    { "59",     433250 },
    { "60",     439250 },
    { "61",     445250 },
    { "62",     451250 },
    { "63",     457250 },
    { "64",     463250 },
    { "65",     469250 },
    { "66",     475250 },
    { "67",     481250 },
    { "68",     487250 },
    { "69",     493250 },

    { "70",     499250 },
    { "71",     505250 },
    { "72",     511250 },
    { "73",     517250 },
    { "74",     523250 },
    { "75",     529250 },
    { "76",     535250 },
    { "77",     541250 },
    { "78",     547250 },
    { "79",     553250 },
    { "80",     559250 },
    { "81",     565250 },
    { "82",     571250 },
    { "83",     577250 },
    { "84",     583250 },
    { "85",     589250 },
    { "86",     595250 },
    { "87",     601250 },
    { "88",     607250 },
    { "89",     613250 },
    { "90",     619250 },
    { "91",     625250 },
    { "92",     631250 },
    { "93",     637250 },
    { "94",     643250 },
    { "95",      91250 },
    { "96",      97250 },
    { "97",     103250 },
    { "98",     109250 },
    { "99",     115250 },
    { "100",    649250 },
    { "101",    655250 },
    { "102",    661250 },
    { "103",    667250 },
    { "104",    673250 },
    { "105",    679250 },
    { "106",    685250 },
    { "107",    691250 },
    { "108",    697250 },
    { "109",    703250 },
    { "110",    709250 },
    { "111",    715250 },
    { "112",    721250 },
    { "113",    727250 },
    { "114",    733250 },
    { "115",    739250 },
    { "116",    745250 },
    { "117",    751250 },
    { "118",    757250 },
    { "119",    763250 },
    { "120",    769250 },
    { "121",    775250 },
    { "122",    781250 },
    { "123",    787250 },
    { "124",    793250 },
    { "125",    799250 },

    { "T7",       7000 },
    { "T8",      13000 },
    { "T9",      19000 },
    { "T10",     25000 },
    { "T11",     31000 },
    { "T12",     37000 },
    { "T13",     43000 },
    { "T14",     49000 }
};

/* US HRC */
static struct CHANLIST ntsc_hrc[] = {
    { "1",        72004 },

    { "2",        54003 },
    { "3",        60003 },
    { "4",        66003 },

    { "5",        78004 },
    { "6",        84004 },

    { "7",       174009 },
    { "8",       180009 },
    { "9",       186009 },
    { "10",      192010 },
    { "11",      198010 },
    { "12",      204010 },
    { "13",      210011 },
    { "14",      120006 },
    { "15",      126006 },
    { "16",      132007 },
    { "17",      138007 },
    { "18",      144007 },
    { "19",      150008 },
    { "20",      156008 },
    { "21",      162008 },
    { "22",      168008 },
    { "23",      216011 },
    { "24",      222011 },
    { "25",      228011 },
    { "26",      234012 },
    { "27",      240012 },
    { "28",      246012 },
    { "29",      252013 },
    { "30",      258013 },
    { "31",      264013 },
    { "32",      270014 },
    { "33",      276014 },
    { "34",      282014 },
    { "35",      288014 },
    { "36",      294015 },
    { "37",      300015 },
    { "38",      306015 },
    { "39",      312016 },
    { "40",      318016 },
    { "41",      324016 },
    { "42",      330017 },
    { "43",      336017 },
    { "44",      342017 },
    { "45",      348017 },
    { "46",      354018 },
    { "47",      360018 },
    { "48",      366018 },
    { "49",      372019 },
    { "50",      378019 },
    { "51",      384019 },
    { "52",      390020 },
    { "53",      396020 },
    { "54",      402020 },
    { "55",      408020 },
    { "56",      414021 },
    { "57",      420021 },
    { "58",      426021 },
    { "59",      432022 },
    { "60",      438022 },
    { "61",      444022 },
    { "62",      450023 },
    { "63",      456023 },
    { "64",      462023 },
    { "65",      468023 },
    { "66",      474024 },
    { "67",      480024 },
    { "68",      486024 },
    { "69",      492025 },
    { "70",      498025 },
    { "71",      504025 },
    { "72",      510026 },
    { "73",      516026 },
    { "74",      522026 },
    { "75",      528026 },
    { "76",      534027 },
    { "77",      540027 },
    { "78",      546027 },
    { "79",      552028 },
    { "80",      558028 },
    { "81",      564028 },
    { "82",      570029 },
    { "83",      576029 },
    { "84",      582029 },
    { "85",      588029 },
    { "86",      594030 },
    { "87",      600030 },
    { "88",      606030 },
    { "89",      612031 },
    { "90",      618031 },
    { "91",      624031 },
    { "92",      630032 },
    { "93",      636032 },
    { "94",      642032 },

    { "95",       90005 },
    { "96",       96005 },
    { "97",      102005 },
    { "98",      108005 },
    { "99",      114006 },

    { "100",     648032 },
    { "101",     654033 },
    { "102",     660033 },
    { "103",     666033 },
    { "104",     672034 },
    { "105",     678034 },
    { "106",     684034 },
    { "107",     690035 },
    { "108",     696035 },
    { "109",     702035 },
    { "110",     708035 },
    { "111",     714036 },
    { "112",     720036 },
    { "113",     726036 },
    { "114",     732037 },
    { "115",     738037 },
    { "116",     744037 },
    { "117",     750038 },
    { "118",     756038 },
    { "119",     762038 },
    { "120",     768038 },
    { "121",     774039 },
    { "122",     780039 },
    { "123",     786039 },
    { "124",     792040 },
    { "125",     798040 },
};

/** US IRC http://www.jneuhaus.com/fccindex/cablech.html */
static struct CHANLIST ntsc_irc[] = {
    { "1",       73263 },
    { "2",       55263 },
    { "3",       61263 },
    { "4",       67263 },
    { "5",       79263 },
    { "6",       85263 },
    { "7",      175263 },
    { "8",      181263 },
    { "9",      187263 },
    { "10",     193263 },
    { "11",     199263 },
    { "12",     205263 },

    { "13",     211263 },
    { "14",     121263 },
    { "15",     127263 },
    { "16",     133263 },
    { "17",     139263 },
    { "18",     145263 },
    { "19",     151263 },
    { "20",     157263 },

    { "21",     163263 },
    { "22",     169263 },
    { "23",     217263 },
    { "24",     223263 },
    { "25",     229263 },
    { "26",     235263 },
    { "27",     241263 },
    { "28",     247263 },
    { "29",     253263 },
    { "30",     259263 },
    { "31",     265263 },
    { "32",     271263 },
    { "33",     277263 },
    { "34",     283263 },
    { "35",     289263 },
    { "36",     295263 },
    { "37",     301263 },
    { "38",     307263 },
    { "39",     313263 },
    { "40",     319263 },
    { "41",     325263 },
    { "42",     331275 },
    { "43",     337263 },
    { "44",     343263 },
    { "45",     349263 },
    { "46",     355263 },
    { "47",     361263 },
    { "48",     367263 },
    { "49",     373263 },
    { "50",     379263 },
    { "51",     385263 },
    { "52",     391263 },
    { "53",     397263 },
    { "54",     403263 },
    { "55",     409263 },
    { "56",     415263 },
    { "57",     421263 },
    { "58",     427263 },
    { "59",     433263 },
    { "60",     439263 },
    { "61",     445263 },
    { "62",     451263 },
    { "63",     457263 },
    { "64",     463263 },
    { "65",     469263 },
    { "66",     475263 },
    { "67",     481263 },
    { "68",     487263 },
    { "69",     493263 },

    { "70",     499263 },
    { "71",     505263 },
    { "72",     511263 },
    { "73",     517263 },
    { "74",     523263 },
    { "75",     529263 },
    { "76",     535263 },
    { "77",     541263 },
    { "78",     547263 },
    { "79",     553263 },
    { "80",     559263 },
    { "81",     565263 },
    { "82",     571263 },
    { "83",     577263 },
    { "84",     583263 },
    { "85",     589263 },
    { "86",     595263 },
    { "87",     601263 },
    { "88",     607263 },
    { "89",     613263 },
    { "90",     619263 },
    { "91",     625263 },
    { "92",     631263 },
    { "93",     637263 },
    { "94",     643263 },
    { "95",      91263 },
    { "96",      97263 },
    { "97",     103263 },
    { "98",     109275 },
    { "99",     115275 },
    { "100",    649263 },
    { "101",    655263 },
    { "102",    661263 },
    { "103",    667263 },
    { "104",    673263 },
    { "105",    679263 },
    { "106",    685263 },
    { "107",    691263 },
    { "108",    697263 },
    { "109",    703263 },
    { "110",    709263 },
    { "111",    715263 },
    { "112",    721263 },
    { "113",    727263 },
    { "114",    733263 },
    { "115",    739263 },
    { "116",    745263 },
    { "117",    751263 },
    { "118",    757263 },
    { "119",    763263 },
    { "120",    769263 },
    { "121",    775263 },
    { "122",    781263 },
    { "123",    787263 },
    { "124",    793263 },
    { "125",    799263 },
};

/* --------------------------------------------------------------------- */

/* JP broadcast */
static struct CHANLIST ntsc_bcast_jp[] = {
    { "1",   91250 },
    { "2",   97250 },
    { "3",  103250 },
    { "4",  171250 },
    { "5",  177250 },
    { "6",  183250 },
    { "7",  189250 },
    { "8",  193250 },
    { "9",  199250 },
    { "10", 205250 },
    { "11", 211250 },
    { "12", 217250 },

    { "13", 471250 },
    { "14", 477250 },
    { "15", 483250 },
    { "16", 489250 },
    { "17", 495250 },
    { "18", 501250 },
    { "19", 507250 },
    { "20", 513250 },
    { "21", 519250 },
    { "22", 525250 },
    { "23", 531250 },
    { "24", 537250 },
    { "25", 543250 },
    { "26", 549250 },
    { "27", 555250 },
    { "28", 561250 },
    { "29", 567250 },
    { "30", 573250 },
    { "31", 579250 },
    { "32", 585250 },
    { "33", 591250 },
    { "34", 597250 },
    { "35", 603250 },
    { "36", 609250 },
    { "37", 615250 },
    { "38", 621250 },
    { "39", 627250 },
    { "40", 633250 },
    { "41", 639250 },
    { "42", 645250 },
    { "43", 651250 },
    { "44", 657250 },

    { "45", 663250 },
    { "46", 669250 },
    { "47", 675250 },
    { "48", 681250 },
    { "49", 687250 },
    { "50", 693250 },
    { "51", 699250 },
    { "52", 705250 },
    { "53", 711250 },
    { "54", 717250 },
    { "55", 723250 },
    { "56", 729250 },
    { "57", 735250 },
    { "58", 741250 },
    { "59", 747250 },
    { "60", 753250 },
    { "61", 759250 },
    { "62", 765250 },
};

/* JP cable */
static struct CHANLIST ntsc_cable_jp[] = {
    { "13",     109250 },
    { "14",     115250 },
    { "15",     121250 },
    { "16",     127250 },
    { "17",     133250 },
    { "18",     139250 },
    { "19",     145250 },
    { "20",     151250 },

    { "21",     157250 },
    { "22",     165250 },
    { "23",     223250 },
    { "24",     231250 },
    { "25",     237250 },
    { "26",     243250 },
    { "27",     249250 },
    { "28",     253250 },
    { "29",     259250 },
    { "30",     265250 },
    { "31",     271250 },
    { "32",     277250 },
    { "33",     283250 },
    { "34",     289250 },
    { "35",     295250 },
    { "36",     301250 },
    { "37",     307250 },
    { "38",     313250 },
    { "39",     319250 },
    { "40",     325250 },
    { "41",     331250 },
    { "42",     337250 },
    { "43",     343250 },
    { "44",     349250 },
    { "45",     355250 },
    { "46",     361250 },
    { "47",     367250 },
    { "48",     373250 },
    { "49",     379250 },
    { "50",     385250 },
    { "51",     391250 },
    { "52",     397250 },
    { "53",     403250 },
    { "54",     409250 },
    { "55",     415250 },
    { "56",     421250 },
    { "57",     427250 },
    { "58",     433250 },
    { "59",     439250 },
    { "60",     445250 },
    { "61",     451250 },
    { "62",     457250 },
    { "63",     463250 },
};

/* --------------------------------------------------------------------- */

/* australia */
static struct CHANLIST pal_australia[] = {
    { "0",       46250 },
    { "1",       57250 },
    { "2",       64250 },
    { "3",       86250 },
    { "4",       95250 },
    { "5",      102250 },
    { "5A",     138250 },
    { "6",      175250 },
    { "7",      182250 },
    { "8",      189250 },
    { "9",      196250 },
    { "10",     209250 },
    { "11",     216250 },
    { "28",     527250 },
    { "29",     534250 },
    { "30",     541250 },
    { "31",     548250 },
    { "32",     555250 },
    { "33",     562250 },
    { "34",     569250 },
    { "35",     576250 },
    { "36",     591250 },
    { "39",     604250 },
    { "40",     611250 },
    { "41",     618250 },
    { "42",     625250 },
    { "43",     632250 },
    { "44",     639250 },
    { "45",     646250 },
    { "46",     653250 },
    { "47",     660250 },
    { "48",     667250 },
    { "49",     674250 },
    { "50",     681250 },
    { "51",     688250 },
    { "52",     695250 },
    { "53",     702250 },
    { "54",     709250 },
    { "55",     716250 },
    { "56",     723250 },
    { "57",     730250 },
    { "58",     737250 },
    { "59",     744250 },
    { "60",     751250 },
    { "61",     758250 },
    { "62",     765250 },
    { "63",     772250 },
    { "64",     779250 },
    { "65",     786250 },
    { "66",     793250 },
    { "67",     800250 },
    { "68",     807250 },
    { "69",     814250 },
};

static struct CHANLIST pal_australia_optus[] = {
   { "1",  138250 },
   { "2",  147250 },
   { "3",  154250 },
   { "4",  161250 },
   { "5",  168250 },
   { "6",  175250 },
   { "7",  182250 },
   { "8",  189250 },
   { "9",  196250 },
   { "10", 209250 },
   { "11", 216250 },
   { "12", 224250 },
   { "13", 231250 },
   { "14", 238250 },
   { "15", 245250 },
   { "16", 252250 },
   { "17", 259250 },
   { "18", 266250 },
   { "19", 273250 },
   { "20", 280250 },
   { "21", 287250 },
   { "22", 294250 },
   { "23", 303250 },
   { "24", 310250 },
   { "25", 317250 },
   { "26", 324250 },
   { "27", 338250 },
   { "28", 345250 },
   { "29", 352250 },
   { "30", 359250 },
   { "31", 366250 },
   { "32", 373250 },
   { "33", 380250 },
   { "34", 387250 },
   { "35", 394250 },
   { "36", 401250 },
   { "37", 408250 },
   { "38", 415250 },
   { "39", 422250 },
   { "40", 429250 },
   { "41", 436250 },
   { "42", 443250 },
   { "43", 450250 },
   { "44", 457250 },
   { "45", 464250 },
   { "46", 471250 },
   { "47", 478250 },
   { "48", 485250 },
   { "49", 492250 },
   { "50", 499250 },
   { "51", 506250 },
   { "52", 513250 },
   { "53", 520250 },
   { "54", 527250 },
   { "55", 534250 },
};


/* --------------------------------------------------------------------- */
/* europe                                                                */

/* CCIR frequencies */

#define FREQ_CCIR_I_III         \
    { "E2",       48250 },      \
    { "E3",       55250 },      \
    { "E4",       62250 },      \
                                \
    { "S01",      69250 },      \
    { "S02",      76250 },      \
    { "S03",      83250 },      \
                                \
    { "E5",      175250 },      \
    { "E6",      182250 },      \
    { "E7",      189250 },      \
    { "E8",      196250 },      \
    { "E9",      203250 },      \
    { "E10",     210250 },      \
    { "E11",     217250 },      \
    { "E12",     224250 }

#define FREQ_CCIR_SL_SH         \
    { "SE1",     105250 },      \
    { "SE2",     112250 },      \
    { "SE3",     119250 },      \
    { "SE4",     126250 },      \
    { "SE5",     133250 },      \
    { "SE6",     140250 },      \
    { "SE7",     147250 },      \
    { "SE8",     154250 },      \
    { "SE9",     161250 },      \
    { "SE10",    168250 },      \
                                \
    { "SE11",    231250 },      \
    { "SE12",    238250 },      \
    { "SE13",    245250 },      \
    { "SE14",    252250 },      \
    { "SE15",    259250 },      \
    { "SE16",    266250 },      \
    { "SE17",    273250 },      \
    { "SE18",    280250 },      \
    { "SE19",    287250 },      \
    { "SE20",    294250 }

#define FREQ_CCIR_H     \
    { "S21", 303250 },  \
    { "S22", 311250 },  \
    { "S23", 319250 },  \
    { "S24", 327250 },  \
    { "S25", 335250 },  \
    { "S26", 343250 },  \
    { "S27", 351250 },  \
    { "S28", 359250 },  \
    { "S29", 367250 },  \
    { "S30", 375250 },  \
    { "S31", 383250 },  \
    { "S32", 391250 },  \
    { "S33", 399250 },  \
    { "S34", 407250 },  \
    { "S35", 415250 },  \
    { "S36", 423250 },  \
    { "S37", 431250 },  \
    { "S38", 439250 },  \
    { "S39", 447250 },  \
    { "S40", 455250 },  \
    { "S41", 463250 }

#define FREQ_CCIR_H2          \
    { "E21",   471250 },      \
    { "E22",   479250 },      \
    { "E23",   487250 },      \
    { "E24",   495250 },      \
    { "E25",   503250 },      \
    { "E26",   511250 }

/* OIRT frequencies */

#define FREQ_OIRT_I_III         \
    { "R1",       49750 },      \
    { "R2",       59250 },      \
                                \
    { "R3",       77250 },      \
    { "R4",       85250 },      \
    { "R5",       93250 },      \
                                \
    { "R6",      175250 },      \
    { "R7",      183250 },      \
    { "R8",      191250 },      \
    { "R9",      199250 },      \
    { "R10",     207250 },      \
    { "R11",     215250 },      \
    { "R12",     223250 }

#define FREQ_OIRT_SL_SH         \
    { "SR1",     111250 },      \
    { "SR2",     119250 },      \
    { "SR3",     127250 },      \
    { "SR4",     135250 },      \
    { "SR5",     143250 },      \
    { "SR6",     151250 },      \
    { "SR7",     159250 },      \
    { "SR8",     167250 },      \
                                \
    { "SR11",    231250 },      \
    { "SR12",    239250 },      \
    { "SR13",    247250 },      \
    { "SR14",    255250 },      \
    { "SR15",    263250 },      \
    { "SR16",    271250 },      \
    { "SR17",    279250 },      \
    { "SR18",    287250 },      \
    { "SR19",    295250 }

#define FREQ_UHF        \
    { "21",  471250 },  \
    { "22",  479250 },  \
    { "23",  487250 },  \
    { "24",  495250 },  \
    { "25",  503250 },  \
    { "26",  511250 },  \
    { "27",  519250 },  \
    { "28",  527250 },  \
    { "29",  535250 },  \
    { "30",  543250 },  \
    { "31",  551250 },  \
    { "32",  559250 },  \
    { "33",  567250 },  \
    { "34",  575250 },  \
    { "35",  583250 },  \
    { "36",  591250 },  \
    { "37",  599250 },  \
    { "38",  607250 },  \
    { "39",  615250 },  \
    { "40",  623250 },  \
    { "41",  631250 },  \
    { "42",  639250 },  \
    { "43",  647250 },  \
    { "44",  655250 },  \
    { "45",  663250 },  \
    { "46",  671250 },  \
    { "47",  679250 },  \
    { "48",  687250 },  \
    { "49",  695250 },  \
    { "50",  703250 },  \
    { "51",  711250 },  \
    { "52",  719250 },  \
    { "53",  727250 },  \
    { "54",  735250 },  \
    { "55",  743250 },  \
    { "56",  751250 },  \
    { "57",  759250 },  \
    { "58",  767250 },  \
    { "59",  775250 },  \
    { "60",  783250 },  \
    { "61",  791250 },  \
    { "62",  799250 },  \
    { "63",  807250 },  \
    { "64",  815250 },  \
    { "65",  823250 },  \
    { "66",  831250 },  \
    { "67",  839250 },  \
    { "68",  847250 },  \
    { "69",  855250 }

static struct CHANLIST europe_west[] = {
    FREQ_CCIR_I_III,
    FREQ_CCIR_SL_SH,
    FREQ_CCIR_H,
    FREQ_CCIR_H2,
    FREQ_UHF
};

static struct CHANLIST europe_east[] = {
    FREQ_OIRT_I_III,
    FREQ_OIRT_SL_SH,
    FREQ_CCIR_I_III,
    FREQ_CCIR_SL_SH,
    FREQ_CCIR_H,
    FREQ_CCIR_H2,
    FREQ_UHF
};

static struct CHANLIST pal_italy[] = {
    { "A",       53750 },
    { "B",       62250 },
    { "C",       82250 },
    { "D",      175250 },
    { "E",      183750 },
    { "F",      192250 },
    { "G",      201250 },
    { "H",      210250 },
    { "H1",     217250 },
    { "H2",     224250 },
    FREQ_UHF
};

static struct CHANLIST pal_ireland[] = {
    { "A0",    45750 },
    { "A1",    48000 },
    { "A2",    53750 },
    { "A3",    56000 },
    { "A4",    61750 },
    { "A5",    64000 },
    { "A6",   175250 },
    { "A7",   176000 },
    { "A8",   183250 },
    { "A9",   184000 },
    { "A10",   191250 },
    { "A11",   192000 },
    { "A12",   199250 },
    { "A13",   200000 },
    { "A14",   207250 },
    { "A15",   208000 },
    { "A16",   215250 },
    { "A17",   216000 },
    { "A18",   224000 },
    { "A19",   232000 },
    { "A20",   248000 },
    { "A21",   256000 },
    { "A22",   264000 },
    { "A23",   272000 },
    { "A24",   280000 },
    { "A25",   288000 },
    { "A26",   296000 },
    { "A27",   304000 },
    { "A28",   312000 },
    { "A29",   320000 },
    { "A30",   344000 },
    { "A31",   352000 },
    { "A32",   408000 },
    { "A33",   416000 },
    { "A34",   448000 },
    { "A35",   480000 },
    { "A36",   520000 },
    FREQ_UHF,
};

static struct CHANLIST secam_france[] = {
    { "K01",    47750 },
    { "K02",    55750 },
    { "K03",    60500 },
    { "K04",    63750 },
    { "K05",   176000 },
    { "K06",   184000 },
    { "K07",   192000 },
    { "K08",   200000 },
    { "K09",   208000 },
    { "K10",   216000 },
    { "KB",    116750 },
    { "KC",    128750 },
    { "KD",    140750 },
    { "KE",    159750 },
    { "KF",    164750 },
    { "KG",    176750 },
    { "KH",    188750 },
    { "KI",    200750 },
    { "KJ",    212750 },
    { "KK",    224750 },
    { "KL",    236750 },
    { "KM",    248750 },
    { "KN",    260750 },
    { "KO",    272750 },
    { "KP",    284750 },
    { "KQ",    296750 },
    { "H01",   303250 },
    { "H02",   311250 },
    { "H03",   319250 },
    { "H04",   327250 },
    { "H05",   335250 },
    { "H06",   343250 },
    { "H07",   351250 },
    { "H08",   359250 },
    { "H09",   367250 },
    { "H10",   375250 },
    { "H11",   383250 },
    { "H12",   391250 },
    { "H13",   399250 },
    { "H14",   407250 },
    { "H15",   415250 },
    { "H16",   423250 },
    { "H17",   431250 },
    { "H18",   439250 },
    { "H19",   447250 },
    FREQ_UHF,
};

/* --------------------------------------------------------------------- */

static struct CHANLIST pal_newzealand[] = {
    { "1",        45250 },
    { "2",        55250 },
    { "3",        62250 },
    { "4",       175250 },
    { "5",       182250 },
    { "6",       189250 },
    { "7",       196250 },
    { "8",       203250 },
    { "9",       210250 },
    { "10",      217250 },
    { "11",      224250 },
    FREQ_UHF,
};

/* --------------------------------------------------------------------- */

/* China broadcast */
static struct CHANLIST pal_bcast_cn[] = {
    { "1",      49750 },
    { "2",      57750 },
    { "3",      65750 },
    { "4",      77250 },
    { "5",      85250 },
    { "6",      112250 },
    { "7",      120250 },
    { "8",      128250 },
    { "9",      136250 },
    { "10",     144250 },
    { "11",     152250 },
    { "12",     160250 },
    { "13",     168250 },
    { "14",     176250 },
    { "15",     184250 },
    { "16",     192250 },
    { "17",     200250 },
    { "18",     208250 },
    { "19",     216250 },
    { "20",     224250 },
    { "21",     232250 },
    { "22",     240250 },
    { "23",     248250 },
    { "24",     256250 },
    { "25",     264250 },
    { "26",     272250 },
    { "27",     280250 },
    { "28",     288250 },
    { "29",     296250 },
    { "30",     304250 },
    { "31",     312250 },
    { "32",     320250 },
    { "33",     328250 },
    { "34",     336250 },
    { "35",     344250 },
    { "36",     352250 },
    { "37",     360250 },
    { "38",     368250 },
    { "39",     376250 },
    { "40",     384250 },
    { "41",     392250 },
    { "42",     400250 },
    { "43",     408250 },
    { "44",     416250 },
    { "45",     424250 },
    { "46",     432250 },
    { "47",     440250 },
    { "48",     448250 },
    { "49",     456250 },
    { "50",     463250 },
    { "51",     471250 },
    { "52",     479250 },
    { "53",     487250 },
    { "54",     495250 },
    { "55",     503250 },
    { "56",     511250 },
    { "57",     519250 },
    { "58",     527250 },
    { "59",     535250 },
    { "60",     543250 },
    { "61",     551250 },
    { "62",     559250 },
    { "63",     607250 },
    { "64",     615250 },
    { "65",     623250 },
    { "66",     631250 },
    { "67",     639250 },
    { "68",     647250 },
    { "69",     655250 },
    { "70",     663250 },
    { "71",     671250 },
    { "72",     679250 },
    { "73",     687250 },
    { "74",     695250 },
    { "75",     703250 },
    { "76",     711250 },
    { "77",     719250 },
    { "78",     727250 },
    { "79",     735250 },
    { "80",     743250 },
    { "81",     751250 },
    { "82",     759250 },
    { "83",     767250 },
    { "84",     775250 },
    { "85",     783250 },
    { "86",     791250 },
    { "87",     799250 },
    { "88",     807250 },
    { "89",     815250 },
    { "90",     823250 },
    { "91",     831250 },
    { "92",     839250 },
    { "93",     847250 },
    { "94",     855250 },
};

/* --------------------------------------------------------------------- */
/* South Africa Broadcast */

static struct CHANLIST pal_bcast_za[] ={
    { "4", 175250 },
    { "5", 183250 },
    { "6", 191250 },
    { "7", 199250 },
    { "8", 207250 },
    { "9", 215250 },
    { "10", 223250 },
    { "11", 231250 },
    { "12", 239250 },
    { "13", 247250 },
    FREQ_UHF
};

/* --------------------------------------------------------------------- */
/* Singapore broadcast added by Teo En Ming on 16 July 2006 */
static struct CHANLIST pal_bcast_sg[] = {
    { "1", 175250 },
    { "2", 196250 },
    { "3", 224250 },
    { "4", 487250 },
    { "5", 495250 },
    { "6", 543250 },
    { "7", 743250 },
};

/* --------------------------------------------------------------------- */
/* Malaysia broadcast added by Andrew Chuah on 26 Sept 2006 */
static struct CHANLIST pal_bcast_my[] = {
    { "1", 175500 },
    { "2", 217500 },
    { "3", 535000 },
    { "4", 599000 },
    { "5", 654500 },
    { "6", 687300 },
};
/* --------------------------------------------------------------------- */

static struct CHANLIST argentina[] = {
    { "001",   56250 },
    { "002",   62250 },
    { "003",   68250 },
    { "004",   78250 },
    { "005",   84250 },
    { "006",  176250 },
    { "007",  182250 },
    { "008",  188250 },
    { "009",  194250 },
    { "010",  200250 },
    { "011",  206250 },
    { "012",  212250 },
    { "013",  122250 },
    { "014",  128250 },
    { "015",  134250 },
    { "016",  140250 },
    { "017",  146250 },
    { "018",  152250 },
    { "019",  158250 },
    { "020",  164250 },
    { "021",  170250 },
    { "022",  218250 },
    { "023",  224250 },
    { "024",  230250 },
    { "025",  236250 },
    { "026",  242250 },
    { "027",  248250 },
    { "028",  254250 },
    { "029",  260250 },
    { "030",  266250 },
    { "031",  272250 },
    { "032",  278250 },
    { "033",  284250 },
    { "034",  290250 },
    { "035",  296250 },
    { "036",  302250 },
    { "037",  308250 },
    { "038",  314250 },
    { "039",  320250 },
    { "040",  326250 },
    { "041",  332250 },
    { "042",  338250 },
    { "043",  344250 },
    { "044",  350250 },
    { "045",  356250 },
    { "046",  362250 },
    { "047",  368250 },
    { "048",  374250 },
    { "049",  380250 },
    { "050",  386250 },
    { "051",  392250 },
    { "052",  398250 },
    { "053",  404250 },
    { "054",  410250 },
    { "055",  416250 },
    { "056",  422250 },
    { "057",  428250 },
    { "058",  434250 },
    { "059",  440250 },
    { "060",  446250 },
    { "061",  452250 },
    { "062",  458250 },
    { "063",  464250 },
    { "064",  470250 },
    { "065",  476250 },
    { "066",  482250 },
    { "067",  488250 },
    { "068",  494250 },
    { "069",  500250 },
    { "070",  506250 },
    { "071",  512250 },
    { "072",  518250 },
    { "073",  524250 },
    { "074",  530250 },
    { "075",  536250 },
    { "076",  542250 },
    { "077",  548250 },
    { "078",  554250 },
    { "079",  560250 },
    { "080",  566250 },
    { "081",  572250 },
    { "082",  578250 },
    { "083",  584250 },
    { "084",  590250 },
    { "085",  596250 },
    { "086",  602250 },
    { "087",  608250 },
    { "088",  614250 },
    { "089",  620250 },
    { "090",  626250 },
    { "091",  632250 },
    { "092",  638250 },
    { "093",  644250 },
};

static struct CHANLIST try_all [] = {
        { "1" , 44000 } ,
        { "2" , 45000 } ,
        { "3" , 46000 } ,
        { "4" , 47000 } ,
        { "5" , 48000 } ,
        { "6" , 49000 } ,
        { "7" , 50000 } ,
        { "8" , 51000 } ,
        { "9" , 52000 } ,
        { "10" , 53000 } ,
        { "11" , 54000 } ,
        { "12" , 55000 } ,
        { "13" , 56000 } ,
        { "14" , 57000 } ,
        { "15" , 58000 } ,
        { "16" , 59000 } ,
        { "17" , 60000 } ,
        { "18" , 61000 } ,
        { "19" , 62000 } ,
        { "20" , 63000 } ,
        { "21" , 64000 } ,
        { "22" , 65000 } ,
        { "23" , 66000 } ,
        { "24" , 67000 } ,
        { "25" , 68000 } ,
        { "26" , 69000 } ,
        { "27" , 70000 } ,
        { "28" , 71000 } ,
        { "29" , 72000 } ,
        { "30" , 73000 } ,
        { "31" , 74000 } ,
        { "32" , 75000 } ,
        { "33" , 76000 } ,
        { "34" , 77000 } ,
        { "35" , 78000 } ,
        { "36" , 79000 } ,
        { "37" , 80000 } ,
        { "38" , 81000 } ,
        { "39" , 82000 } ,
        { "40" , 83000 } ,
        { "41" , 84000 } ,
        { "42" , 85000 } ,
        { "43" , 86000 } ,
        { "44" , 87000 } ,
        { "45" , 88000 } ,
        { "46" , 89000 } ,
        { "47" , 90000 } ,
        { "48" , 91000 } ,
        { "49" , 92000 } ,
        { "50" , 93000 } ,
        { "51" , 94000 } ,
        { "52" , 95000 } ,
        { "53" , 96000 } ,
        { "54" , 97000 } ,
        { "55" , 98000 } ,
        { "56" , 99000 } ,
        { "57" , 100000 } ,
        { "58" , 101000 } ,
        { "59" , 102000 } ,
        { "60" , 103000 } ,
        { "61" , 104000 } ,
        { "62" , 105000 } ,
        { "63" , 106000 } ,
        { "64" , 107000 } ,
        { "65" , 108000 } ,
        { "66" , 109000 } ,
        { "67" , 110000 } ,
        { "68" , 111000 } ,
        { "69" , 112000 } ,
        { "70" , 113000 } ,
        { "71" , 114000 } ,
        { "72" , 115000 } ,
        { "73" , 116000 } ,
        { "74" , 117000 } ,
        { "75" , 118000 } ,
        { "76" , 119000 } ,
        { "77" , 120000 } ,
        { "78" , 121000 } ,
        { "79" , 122000 } ,
        { "80" , 123000 } ,
        { "81" , 124000 } ,
        { "82" , 125000 } ,
        { "83" , 126000 } ,
        { "84" , 127000 } ,
        { "85" , 128000 } ,
        { "86" , 129000 } ,
        { "87" , 130000 } ,
        { "88" , 131000 } ,
        { "89" , 132000 } ,
        { "90" , 133000 } ,
        { "91" , 134000 } ,
        { "92" , 135000 } ,
        { "93" , 136000 } ,
        { "94" , 137000 } ,
        { "95" , 138000 } ,
        { "96" , 139000 } ,
        { "97" , 140000 } ,
        { "98" , 141000 } ,
        { "99" , 142000 } ,
        { "100" , 143000 } ,
        { "101" , 144000 } ,
        { "102" , 145000 } ,
        { "103" , 146000 } ,
        { "104" , 147000 } ,
        { "105" , 148000 } ,
        { "106" , 149000 } ,
        { "107" , 150000 } ,
        { "108" , 151000 } ,
        { "109" , 152000 } ,
        { "110" , 153000 } ,
        { "111" , 154000 } ,
        { "112" , 155000 } ,
        { "113" , 156000 } ,
        { "114" , 157000 } ,
        { "115" , 158000 } ,
        { "116" , 159000 } ,
        { "117" , 160000 } ,
        { "118" , 161000 } ,
        { "119" , 162000 } ,
        { "120" , 163000 } ,
        { "121" , 164000 } ,
        { "122" , 165000 } ,
        { "123" , 166000 } ,
        { "124" , 167000 } ,
        { "125" , 168000 } ,
        { "126" , 169000 } ,
        { "127" , 170000 } ,
        { "128" , 171000 } ,
        { "129" , 172000 } ,
        { "130" , 173000 } ,
        { "131" , 174000 } ,
        { "132" , 175000 } ,
        { "133" , 176000 } ,
        { "134" , 177000 } ,
        { "135" , 178000 } ,
        { "136" , 179000 } ,
        { "137" , 180000 } ,
        { "138" , 181000 } ,
        { "139" , 182000 } ,
        { "140" , 183000 } ,
        { "141" , 184000 } ,
        { "142" , 185000 } ,
        { "143" , 186000 } ,
        { "144" , 187000 } ,
        { "145" , 188000 } ,
        { "146" , 189000 } ,
        { "147" , 190000 } ,
        { "148" , 191000 } ,
        { "149" , 192000 } ,
        { "150" , 193000 } ,
        { "151" , 194000 } ,
        { "152" , 195000 } ,
        { "153" , 196000 } ,
        { "154" , 197000 } ,
        { "155" , 198000 } ,
        { "156" , 199000 } ,
        { "157" , 200000 } ,
        { "158" , 201000 } ,
        { "159" , 202000 } ,
        { "160" , 203000 } ,
        { "161" , 204000 } ,
        { "162" , 205000 } ,
        { "163" , 206000 } ,
        { "164" , 207000 } ,
        { "165" , 208000 } ,
        { "166" , 209000 } ,
        { "167" , 210000 } ,
        { "168" , 211000 } ,
        { "169" , 212000 } ,
        { "170" , 213000 } ,
        { "171" , 214000 } ,
        { "172" , 215000 } ,
        { "173" , 216000 } ,
        { "174" , 217000 } ,
        { "175" , 218000 } ,
        { "176" , 219000 } ,
        { "177" , 220000 } ,
        { "178" , 221000 } ,
        { "179" , 222000 } ,
        { "180" , 223000 } ,
        { "181" , 224000 } ,
        { "182" , 225000 } ,
        { "183" , 226000 } ,
        { "184" , 227000 } ,
        { "185" , 228000 } ,
        { "186" , 229000 } ,
        { "187" , 230000 } ,
        { "188" , 231000 } ,
        { "189" , 232000 } ,
        { "190" , 233000 } ,
        { "191" , 234000 } ,
        { "192" , 235000 } ,
        { "193" , 236000 } ,
        { "194" , 237000 } ,
        { "195" , 238000 } ,
        { "196" , 239000 } ,
        { "197" , 240000 } ,
        { "198" , 241000 } ,
        { "199" , 242000 } ,
        { "200" , 243000 } ,
        { "201" , 244000 } ,
        { "202" , 245000 } ,
        { "203" , 246000 } ,
        { "204" , 247000 } ,
        { "205" , 248000 } ,
        { "206" , 249000 } ,
        { "207" , 250000 } ,
        { "208" , 251000 } ,
        { "209" , 252000 } ,
        { "210" , 253000 } ,
        { "211" , 254000 } ,
        { "212" , 255000 } ,
        { "213" , 256000 } ,
        { "214" , 257000 } ,
        { "215" , 258000 } ,
        { "216" , 259000 } ,
        { "217" , 260000 } ,
        { "218" , 261000 } ,
        { "219" , 262000 } ,
        { "220" , 263000 } ,
        { "221" , 264000 } ,
        { "222" , 265000 } ,
        { "223" , 266000 } ,
        { "224" , 267000 } ,
        { "225" , 268000 } ,
        { "226" , 269000 } ,
        { "227" , 270000 } ,
        { "228" , 271000 } ,
        { "229" , 272000 } ,
        { "230" , 273000 } ,
        { "231" , 274000 } ,
        { "232" , 275000 } ,
        { "233" , 276000 } ,
        { "234" , 277000 } ,
        { "235" , 278000 } ,
        { "236" , 279000 } ,
        { "237" , 280000 } ,
        { "238" , 281000 } ,
        { "239" , 282000 } ,
        { "240" , 283000 } ,
        { "241" , 284000 } ,
        { "242" , 285000 } ,
        { "243" , 286000 } ,
        { "244" , 287000 } ,
        { "245" , 288000 } ,
        { "246" , 289000 } ,
        { "247" , 290000 } ,
        { "248" , 291000 } ,
        { "249" , 292000 } ,
        { "250" , 293000 } ,
        { "251" , 294000 } ,
        { "252" , 295000 } ,
        { "253" , 296000 } ,
        { "254" , 297000 } ,
        { "255" , 298000 } ,
        { "256" , 299000 } ,
        { "257" , 300000 } ,
        { "258" , 301000 } ,
        { "259" , 302000 } ,
        { "260" , 303000 } ,
        { "261" , 304000 } ,
        { "262" , 305000 } ,
        { "263" , 306000 } ,
        { "264" , 307000 } ,
        { "265" , 308000 } ,
        { "266" , 309000 } ,
        { "267" , 310000 } ,
        { "268" , 311000 } ,
        { "269" , 312000 } ,
        { "270" , 313000 } ,
        { "271" , 314000 } ,
        { "272" , 315000 } ,
        { "273" , 316000 } ,
        { "274" , 317000 } ,
        { "275" , 318000 } ,
        { "276" , 319000 } ,
        { "277" , 320000 } ,
        { "278" , 321000 } ,
        { "279" , 322000 } ,
        { "280" , 323000 } ,
        { "281" , 324000 } ,
        { "282" , 325000 } ,
        { "283" , 326000 } ,
        { "284" , 327000 } ,
        { "285" , 328000 } ,
        { "286" , 329000 } ,
        { "287" , 330000 } ,
        { "288" , 331000 } ,
        { "289" , 332000 } ,
        { "290" , 333000 } ,
        { "291" , 334000 } ,
        { "292" , 335000 } ,
        { "293" , 336000 } ,
        { "294" , 337000 } ,
        { "295" , 338000 } ,
        { "296" , 339000 } ,
        { "297" , 340000 } ,
        { "298" , 341000 } ,
        { "299" , 342000 } ,
        { "300" , 343000 } ,
        { "301" , 344000 } ,
        { "302" , 345000 } ,
        { "303" , 346000 } ,
        { "304" , 347000 } ,
        { "305" , 348000 } ,
        { "306" , 349000 } ,
        { "307" , 350000 } ,
        { "308" , 351000 } ,
        { "309" , 352000 } ,
        { "310" , 353000 } ,
        { "311" , 354000 } ,
        { "312" , 355000 } ,
        { "313" , 356000 } ,
        { "314" , 357000 } ,
        { "315" , 358000 } ,
        { "316" , 359000 } ,
        { "317" , 360000 } ,
        { "318" , 361000 } ,
        { "319" , 362000 } ,
        { "320" , 363000 } ,
        { "321" , 364000 } ,
        { "322" , 365000 } ,
        { "323" , 366000 } ,
        { "324" , 367000 } ,
        { "325" , 368000 } ,
        { "326" , 369000 } ,
        { "327" , 370000 } ,
        { "328" , 371000 } ,
        { "329" , 372000 } ,
        { "330" , 373000 } ,
        { "331" , 374000 } ,
        { "332" , 375000 } ,
        { "333" , 376000 } ,
        { "334" , 377000 } ,
        { "335" , 378000 } ,
        { "336" , 379000 } ,
        { "337" , 380000 } ,
        { "338" , 381000 } ,
        { "339" , 382000 } ,
        { "340" , 383000 } ,
        { "341" , 384000 } ,
        { "342" , 385000 } ,
        { "343" , 386000 } ,
        { "344" , 387000 } ,
        { "345" , 388000 } ,
        { "346" , 389000 } ,
        { "347" , 390000 } ,
        { "348" , 391000 } ,
        { "349" , 392000 } ,
        { "350" , 393000 } ,
        { "351" , 394000 } ,
        { "352" , 395000 } ,
        { "353" , 396000 } ,
        { "354" , 397000 } ,
        { "355" , 398000 } ,
        { "356" , 399000 } ,
        { "357" , 400000 } ,
        { "358" , 401000 } ,
        { "359" , 402000 } ,
        { "360" , 403000 } ,
        { "361" , 404000 } ,
        { "362" , 405000 } ,
        { "363" , 406000 } ,
        { "364" , 407000 } ,
        { "365" , 408000 } ,
        { "366" , 409000 } ,
        { "367" , 410000 } ,
        { "368" , 411000 } ,
        { "369" , 412000 } ,
        { "370" , 413000 } ,
        { "371" , 414000 } ,
        { "372" , 415000 } ,
        { "373" , 416000 } ,
        { "374" , 417000 } ,
        { "375" , 418000 } ,
        { "376" , 419000 } ,
        { "377" , 420000 } ,
        { "378" , 421000 } ,
        { "379" , 422000 } ,
        { "380" , 423000 } ,
        { "381" , 424000 } ,
        { "382" , 425000 } ,
        { "383" , 426000 } ,
        { "384" , 427000 } ,
        { "385" , 428000 } ,
        { "386" , 429000 } ,
        { "387" , 430000 } ,
        { "388" , 431000 } ,
        { "389" , 432000 } ,
        { "390" , 433000 } ,
        { "391" , 434000 } ,
        { "392" , 435000 } ,
        { "393" , 436000 } ,
        { "394" , 437000 } ,
        { "395" , 438000 } ,
        { "396" , 439000 } ,
        { "397" , 440000 } ,
        { "398" , 441000 } ,
        { "399" , 442000 } ,
        { "400" , 443000 } ,
        { "401" , 444000 } ,
        { "402" , 445000 } ,
        { "403" , 446000 } ,
        { "404" , 447000 } ,
        { "405" , 448000 } ,
        { "406" , 449000 } ,
        { "407" , 450000 } ,
        { "408" , 451000 } ,
        { "409" , 452000 } ,
        { "410" , 453000 } ,
        { "411" , 454000 } ,
        { "412" , 455000 } ,
        { "413" , 456000 } ,
        { "414" , 457000 } ,
        { "415" , 458000 } ,
        { "416" , 459000 } ,
        { "417" , 460000 } ,
        { "418" , 461000 } ,
        { "419" , 462000 } ,
        { "420" , 463000 } ,
        { "421" , 464000 } ,
        { "422" , 465000 } ,
        { "423" , 466000 } ,
        { "424" , 467000 } ,
        { "425" , 468000 } ,
        { "426" , 469000 } ,
        { "427" , 470000 } ,
        { "428" , 471000 } ,
        { "429" , 472000 } ,
        { "430" , 473000 } ,
        { "431" , 474000 } ,
        { "432" , 475000 } ,
        { "433" , 476000 } ,
        { "434" , 477000 } ,
        { "435" , 478000 } ,
        { "436" , 479000 } ,
        { "437" , 480000 } ,
        { "438" , 481000 } ,
        { "439" , 482000 } ,
        { "440" , 483000 } ,
        { "441" , 484000 } ,
        { "442" , 485000 } ,
        { "443" , 486000 } ,
        { "444" , 487000 } ,
        { "445" , 488000 } ,
        { "446" , 489000 } ,
        { "447" , 490000 } ,
        { "448" , 491000 } ,
        { "449" , 492000 } ,
        { "450" , 493000 } ,
        { "451" , 494000 } ,
        { "452" , 495000 } ,
        { "453" , 496000 } ,
        { "454" , 497000 } ,
        { "455" , 498000 } ,
        { "456" , 499000 } ,
        { "457" , 500000 } ,
        { "458" , 501000 } ,
        { "459" , 502000 } ,
        { "460" , 503000 } ,
        { "461" , 504000 } ,
        { "462" , 505000 } ,
        { "463" , 506000 } ,
        { "464" , 507000 } ,
        { "465" , 508000 } ,
        { "466" , 509000 } ,
        { "467" , 510000 } ,
        { "468" , 511000 } ,
        { "469" , 512000 } ,
        { "470" , 513000 } ,
        { "471" , 514000 } ,
        { "472" , 515000 } ,
        { "473" , 516000 } ,
        { "474" , 517000 } ,
        { "475" , 518000 } ,
        { "476" , 519000 } ,
        { "477" , 520000 } ,
        { "478" , 521000 } ,
        { "479" , 522000 } ,
        { "480" , 523000 } ,
        { "481" , 524000 } ,
        { "482" , 525000 } ,
        { "483" , 526000 } ,
        { "484" , 527000 } ,
        { "485" , 528000 } ,
        { "486" , 529000 } ,
        { "487" , 530000 } ,
        { "488" , 531000 } ,
        { "489" , 532000 } ,
        { "490" , 533000 } ,
        { "491" , 534000 } ,
        { "492" , 535000 } ,
        { "493" , 536000 } ,
        { "494" , 537000 } ,
        { "495" , 538000 } ,
        { "496" , 539000 } ,
        { "497" , 540000 } ,
        { "498" , 541000 } ,
        { "499" , 542000 } ,
        { "500" , 543000 } ,
        { "501" , 544000 } ,
        { "502" , 545000 } ,
        { "503" , 546000 } ,
        { "504" , 547000 } ,
        { "505" , 548000 } ,
        { "506" , 549000 } ,
        { "507" , 550000 } ,
        { "508" , 551000 } ,
        { "509" , 552000 } ,
        { "510" , 553000 } ,
        { "511" , 554000 } ,
        { "512" , 555000 } ,
        { "513" , 556000 } ,
        { "514" , 557000 } ,
        { "515" , 558000 } ,
        { "516" , 559000 } ,
        { "517" , 560000 } ,
        { "518" , 561000 } ,
        { "519" , 562000 } ,
        { "520" , 563000 } ,
        { "521" , 564000 } ,
        { "522" , 565000 } ,
        { "523" , 566000 } ,
        { "524" , 567000 } ,
        { "525" , 568000 } ,
        { "526" , 569000 } ,
        { "527" , 570000 } ,
        { "528" , 571000 } ,
        { "529" , 572000 } ,
        { "530" , 573000 } ,
        { "531" , 574000 } ,
        { "532" , 575000 } ,
        { "533" , 576000 } ,
        { "534" , 577000 } ,
        { "535" , 578000 } ,
        { "536" , 579000 } ,
        { "537" , 580000 } ,
        { "538" , 581000 } ,
        { "539" , 582000 } ,
        { "540" , 583000 } ,
        { "541" , 584000 } ,
        { "542" , 585000 } ,
        { "543" , 586000 } ,
        { "544" , 587000 } ,
        { "545" , 588000 } ,
        { "546" , 589000 } ,
        { "547" , 590000 } ,
        { "548" , 591000 } ,
        { "549" , 592000 } ,
        { "550" , 593000 } ,
        { "551" , 594000 } ,
        { "552" , 595000 } ,
        { "553" , 596000 } ,
        { "554" , 597000 } ,
        { "555" , 598000 } ,
        { "556" , 599000 } ,
        { "557" , 600000 } ,
        { "558" , 601000 } ,
        { "559" , 602000 } ,
        { "560" , 603000 } ,
        { "561" , 604000 } ,
        { "562" , 605000 } ,
        { "563" , 606000 } ,
        { "564" , 607000 } ,
        { "565" , 608000 } ,
        { "566" , 609000 } ,
        { "567" , 610000 } ,
        { "568" , 611000 } ,
        { "569" , 612000 } ,
        { "570" , 613000 } ,
        { "571" , 614000 } ,
        { "572" , 615000 } ,
        { "573" , 616000 } ,
        { "574" , 617000 } ,
        { "575" , 618000 } ,
        { "576" , 619000 } ,
        { "577" , 620000 } ,
        { "578" , 621000 } ,
        { "579" , 622000 } ,
        { "580" , 623000 } ,
        { "581" , 624000 } ,
        { "582" , 625000 } ,
        { "583" , 626000 } ,
        { "584" , 627000 } ,
        { "585" , 628000 } ,
        { "586" , 629000 } ,
        { "587" , 630000 } ,
        { "588" , 631000 } ,
        { "589" , 632000 } ,
        { "590" , 633000 } ,
        { "591" , 634000 } ,
        { "592" , 635000 } ,
        { "593" , 636000 } ,
        { "594" , 637000 } ,
        { "595" , 638000 } ,
        { "596" , 639000 } ,
        { "597" , 640000 } ,
        { "598" , 641000 } ,
        { "599" , 642000 } ,
        { "600" , 643000 } ,
        { "601" , 644000 } ,
        { "602" , 645000 } ,
        { "603" , 646000 } ,
        { "604" , 647000 } ,
        { "605" , 648000 } ,
        { "606" , 649000 } ,
        { "607" , 650000 } ,
        { "608" , 651000 } ,
        { "609" , 652000 } ,
        { "610" , 653000 } ,
        { "611" , 654000 } ,
        { "612" , 655000 } ,
        { "613" , 656000 } ,
        { "614" , 657000 } ,
        { "615" , 658000 } ,
        { "616" , 659000 } ,
        { "617" , 660000 } ,
        { "618" , 661000 } ,
        { "619" , 662000 } ,
        { "620" , 663000 } ,
        { "621" , 664000 } ,
        { "622" , 665000 } ,
        { "623" , 666000 } ,
        { "624" , 667000 } ,
        { "625" , 668000 } ,
        { "626" , 669000 } ,
        { "627" , 670000 } ,
        { "628" , 671000 } ,
        { "629" , 672000 } ,
        { "630" , 673000 } ,
        { "631" , 674000 } ,
        { "632" , 675000 } ,
        { "633" , 676000 } ,
        { "634" , 677000 } ,
        { "635" , 678000 } ,
        { "636" , 679000 } ,
        { "637" , 680000 } ,
        { "638" , 681000 } ,
        { "639" , 682000 } ,
        { "640" , 683000 } ,
        { "641" , 684000 } ,
        { "642" , 685000 } ,
        { "643" , 686000 } ,
        { "644" , 687000 } ,
        { "645" , 688000 } ,
        { "646" , 689000 } ,
        { "647" , 690000 } ,
        { "648" , 691000 } ,
        { "649" , 692000 } ,
        { "650" , 693000 } ,
        { "651" , 694000 } ,
        { "652" , 695000 } ,
        { "653" , 696000 } ,
        { "654" , 697000 } ,
        { "655" , 698000 } ,
        { "656" , 699000 } ,
        { "657" , 700000 } ,
        { "658" , 701000 } ,
        { "659" , 702000 } ,
        { "660" , 703000 } ,
        { "661" , 704000 } ,
        { "662" , 705000 } ,
        { "663" , 706000 } ,
        { "664" , 707000 } ,
        { "665" , 708000 } ,
        { "666" , 709000 } ,
        { "667" , 710000 } ,
        { "668" , 711000 } ,
        { "669" , 712000 } ,
        { "670" , 713000 } ,
        { "671" , 714000 } ,
        { "672" , 715000 } ,
        { "673" , 716000 } ,
        { "674" , 717000 } ,
        { "675" , 718000 } ,
        { "676" , 719000 } ,
        { "677" , 720000 } ,
        { "678" , 721000 } ,
        { "679" , 722000 } ,
        { "680" , 723000 } ,
        { "681" , 724000 } ,
        { "682" , 725000 } ,
        { "683" , 726000 } ,
        { "684" , 727000 } ,
        { "685" , 728000 } ,
        { "686" , 729000 } ,
        { "687" , 730000 } ,
        { "688" , 731000 } ,
        { "689" , 732000 } ,
        { "690" , 733000 } ,
        { "691" , 734000 } ,
        { "692" , 735000 } ,
        { "693" , 736000 } ,
        { "694" , 737000 } ,
        { "695" , 738000 } ,
        { "696" , 739000 } ,
        { "697" , 740000 } ,
        { "698" , 741000 } ,
        { "699" , 742000 } ,
        { "700" , 743000 } ,
        { "701" , 744000 } ,
        { "702" , 745000 } ,
        { "703" , 746000 } ,
        { "704" , 747000 } ,
        { "705" , 748000 } ,
        { "706" , 749000 } ,
        { "707" , 750000 } ,
        { "708" , 751000 } ,
        { "709" , 752000 } ,
        { "710" , 753000 } ,
        { "711" , 754000 } ,
        { "712" , 755000 } ,
        { "713" , 756000 } ,
        { "714" , 757000 } ,
        { "715" , 758000 } ,
        { "716" , 759000 } ,
        { "717" , 760000 } ,
        { "718" , 761000 } ,
        { "719" , 762000 } ,
        { "720" , 763000 } ,
        { "721" , 764000 } ,
        { "722" , 765000 } ,
        { "723" , 766000 } ,
        { "724" , 767000 } ,
        { "725" , 768000 } ,
        { "726" , 769000 } ,
        { "727" , 770000 } ,
        { "728" , 771000 } ,
        { "729" , 772000 } ,
        { "730" , 773000 } ,
        { "731" , 774000 } ,
        { "732" , 775000 } ,
        { "733" , 776000 } ,
        { "734" , 777000 } ,
        { "735" , 778000 } ,
        { "736" , 779000 } ,
        { "737" , 780000 } ,
        { "738" , 781000 } ,
        { "739" , 782000 } ,
        { "740" , 783000 } ,
        { "741" , 784000 } ,
        { "742" , 785000 } ,
        { "743" , 786000 } ,
        { "744" , 787000 } ,
        { "745" , 788000 } ,
        { "746" , 789000 } ,
        { "747" , 790000 } ,
        { "748" , 791000 } ,
        { "749" , 792000 } ,
        { "750" , 793000 } ,
        { "751" , 794000 } ,
        { "752" , 795000 } ,
        { "753" , 796000 } ,
        { "754" , 797000 } ,
        { "755" , 798000 } ,
        { "756" , 799000 } ,
        { "757" , 800000 } ,
        { "758" , 801000 } ,
        { "759" , 802000 } ,
        { "760" , 803000 } ,
        { "761" , 804000 } ,
        { "762" , 805000 } ,
        { "763" , 806000 } ,
        { "764" , 807000 } ,
        { "765" , 808000 } ,
        { "766" , 809000 } ,
        { "767" , 810000 } ,
        { "768" , 811000 } ,
        { "769" , 812000 } ,
        { "770" , 813000 } ,
        { "771" , 814000 } ,
        { "772" , 815000 } ,
        { "773" , 816000 } ,
        { "774" , 817000 } ,
        { "775" , 818000 } ,
        { "776" , 819000 } ,
        { "777" , 820000 } ,
        { "778" , 821000 } ,
        { "779" , 822000 } ,
        { "780" , 823000 } ,
        { "781" , 824000 } ,
        { "782" , 825000 } ,
        { "783" , 826000 } ,
        { "784" , 827000 } ,
        { "785" , 828000 } ,
        { "786" , 829000 } ,
        { "787" , 830000 } ,
        { "788" , 831000 } ,
        { "789" , 832000 } ,
        { "790" , 833000 } ,
        { "791" , 834000 } ,
        { "792" , 835000 } ,
        { "793" , 836000 } ,
        { "794" , 837000 } ,
        { "795" , 838000 } ,
        { "796" , 839000 } ,
        { "797" , 840000 } ,
        { "798" , 841000 } ,
        { "799" , 842000 } ,
        { "800" , 843000 } ,
        { "801" , 844000 } ,
        { "802" , 845000 } ,
        { "803" , 846000 } ,
        { "804" , 847000 } ,
        { "805" , 848000 } ,
        { "806" , 849000 } ,
        { "807" , 850000 } ,
        { "808" , 851000 } ,
        { "809" , 852000 } ,
        { "810" , 853000 } ,
        { "811" , 854000 } ,
        { "812" , 855000 } ,
        { "813" , 856000 } ,
        { "814" , 857000 } ,
        { "815" , 858000 } ,
        { "816" , 859000 } ,
        { "817" , 860000 } ,
        { "818" , 861000 } ,
        { "819" , 862000 } ,
        { "820" , 863000 } ,
        { "821" , 864000 } ,
        { "822" , 865000 } ,
        { "823" , 866000 } ,
        { "824" , 867000 } ,
        { "825" , 868000 } ,
        { "826" , 869000 } ,
        { "827" , 870000 } ,
        { "828" , 871000 } ,
        { "829" , 872000 } ,
        { "830" , 873000 } ,
        { "831" , 874000 } ,
        { "832" , 875000 } ,
        { "833" , 876000 } ,
        { "834" , 877000 } ,
        { "835" , 878000 } ,
        { "836" , 879000 } ,
        { "837" , 880000 } ,
        { "838" , 881000 } ,
        { "839" , 882000 } ,
        { "840" , 883000 } ,
        { "841" , 884000 } ,
        { "842" , 885000 } ,
        { "843" , 886000 } ,
        { "844" , 887000 } ,
        { "845" , 888000 } ,
        { "846" , 889000 } ,
        { "847" , 890000 } ,
        { "848" , 891000 } ,
        { "849" , 892000 } ,
        { "850" , 893000 } ,
        { "851" , 894000 } ,
        { "852" , 895000 } ,
        { "853" , 896000 } ,
        { "854" , 897000 } ,
        { "855" , 898000 } ,
        { "856" , 899000 } ,
        { "857" , 900000 } ,
        { "858" , 901000 } ,
        { "859" , 902000 } ,
        { "860" , 903000 } ,
        { "861" , 904000 } ,
        { "862" , 905000 } ,
        { "863" , 906000 } ,
        { "864" , 907000 } ,
        { "865" , 908000 } ,
        { "866" , 909000 } ,
        { "867" , 910000 } ,
        { "868" , 911000 } ,
        { "869" , 912000 } ,
        { "870" , 913000 } ,
        { "871" , 914000 } ,
        { "872" , 915000 } ,
        { "873" , 916000 } ,
        { "874" , 917000 } ,
        { "875" , 918000 } ,
        { "876" , 919000 } ,
        { "877" , 920000 } ,
        { "878" , 921000 } ,
        { "879" , 922000 } ,
        { "880" , 923000 } ,
        { "881" , 924000 } ,
        { "882" , 925000 } ,
        { "883" , 926000 } ,
        { "884" , 927000 } ,
        { "885" , 928000 } ,
        { "886" , 929000 } ,
        { "887" , 930000 } ,
        { "888" , 931000 } ,
        { "889" , 932000 } ,
        { "890" , 933000 } ,
        { "891" , 934000 } ,
        { "892" , 935000 } ,
        { "893" , 936000 } ,
        { "894" , 937000 } ,
        { "895" , 938000 } ,
        { "896" , 939000 } ,
        { "897" , 940000 } ,
        { "898" , 941000 } ,
        { "899" , 942000 } ,
        { "900" , 943000 } ,
        { "901" , 944000 } ,
        { "902" , 945000 } ,
        { "903" , 946000 } ,
        { "904" , 947000 } ,
        { "905" , 948000 } ,
        { "906" , 949000 } ,
        { "907" , 950000 } ,
        { "908" , 951000 } ,
        { "909" , 952000 } ,
        { "910" , 953000 } ,
        { "911" , 954000 } ,
        { "912" , 955000 } ,
        { "913" , 956000 } ,
        { "914" , 957000 }
};

/* --------------------------------------------------------------------- */
/* Israel has cable (HOT) and air analog channels. Cable consists of
   three companies that have recently joined to form HOT - matav, tevel, and
   Golden Channels. This is the frequency table used in Matav. */
/* Added by Max Timchenko [www.maxvt.net], 04/04/2007 */
static struct CHANLIST israel_hot_matav[] = {
    {  "1", 184250 },
    {  "2", 192250 },
    {  "3", 200250 },
    {  "4", 208250 },
    {  "5", 216250 },
    {  "6", 224250 },
    {  "7", 232250 },
    {  "8", 248250 },
    {  "9", 256250 },
    { "10", 264250 },
    { "11", 272250 },
    { "12", 280250 },
    { "13", 288250 },
    { "14", 296250 },
    { "15", 304250 },
    { "16", 312250 },
    { "17", 320250 },
    { "18", 328250 },
    { "19", 336250 },
    { "20", 344250 },
    { "21", 352250 },
    { "22", 360250 },
    { "23", 368250 },
    { "24", 376250 },
    { "25", 384250 },
    { "26", 392250 },
    { "27", 400250 },
    { "28", 408250 },
    { "29", 416250 },
    { "30", 424250 },
    { "31", 432250 },
    { "32", 440250 },
    { "33", 472250 },
    { "34", 480250 },
    { "35", 488250 },
    { "36", 496250 },
    { "37", 504250 },
    { "38", 512250 },
    { "39", 520250 },
    { "40", 528250 },
    { "41", 536250 },
    { "42", 544250 },
    { "43", 552250 },
    { "44", 560250 },
    { "45", 584250 },
    { "46", 648250 },
};

/* --------------------------------------------------------------------- */

struct CHANLISTS chanlists[] = {
    { "us-bcast",         ntsc_bcast,        CHAN_COUNT(ntsc_bcast)        },
    { "us-cable",         ntsc_cable,        CHAN_COUNT(ntsc_cable)        },
    { "us-cable-hrc",     ntsc_hrc,          CHAN_COUNT(ntsc_hrc)          },
    { "us-cable-irc",     ntsc_irc,          CHAN_COUNT(ntsc_irc)          },
    { "japan-bcast",      ntsc_bcast_jp,     CHAN_COUNT(ntsc_bcast_jp)     },
    { "japan-cable",      ntsc_cable_jp,     CHAN_COUNT(ntsc_cable_jp)     },
    { "europe-west",      europe_west,       CHAN_COUNT(europe_west)       },
    { "europe-east",      europe_east,       CHAN_COUNT(europe_east)       },
    { "italy",            pal_italy,         CHAN_COUNT(pal_italy)         },
    { "newzealand",       pal_newzealand,    CHAN_COUNT(pal_newzealand)    },
    { "australia",        pal_australia,     CHAN_COUNT(pal_australia)     },
    { "ireland",          pal_ireland,       CHAN_COUNT(pal_ireland)       },
    { "france",           secam_france,      CHAN_COUNT(secam_france)      },
    { "china-bcast",      pal_bcast_cn,      CHAN_COUNT(pal_bcast_cn)      },
    { "southafrica",      pal_bcast_za,      CHAN_COUNT(pal_bcast_za)      },
    { "argentina",        argentina,         CHAN_COUNT(argentina)         },
    { "australia-optus",  pal_australia_optus, CHAN_COUNT(pal_australia_optus) },
    { "singapore",        pal_bcast_sg,      CHAN_COUNT(pal_bcast_sg)      },
    { "malaysia",         pal_bcast_my,      CHAN_COUNT(pal_bcast_my)      },
    { "israel-hot-matav", israel_hot_matav,  CHAN_COUNT(israel_hot_matav)  },
    { "try-all",          try_all,           CHAN_COUNT(try_all)           },
    { NULL, NULL, 0 } /* EOF */
};
