/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dijit/main":function(){define(["dojo/_base/kernel"],function(_1){return _1.dijit;});},"dijit/_base":function(){define("dijit/_base",["./main","./a11y","./WidgetSet","./_base/focus","./_base/manager","./_base/place","./_base/popup","./_base/scroll","./_base/sniff","./_base/typematic","./_base/wai","./_base/window"],function(_2){return _2._base;});},"dijit/a11y":function(){define("dijit/a11y",["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_3,_4,_5,_6,_7,_8,_9){var _a;var _b={_isElementShown:function(_c){var s=_6.get(_c);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_5.get(_c,"type")!="hidden");},hasDefaultTabStop:function(_d){switch(_d.nodeName.toLowerCase()){case "a":return _5.has(_d,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var _e;try{var _f=_d.contentDocument;if("designMode" in _f&&_f.designMode=="on"){return true;}_e=_f.body;}catch(e1){try{_e=_d.contentWindow.document.body;}catch(e2){return false;}}return _e&&(_e.contentEditable=="true"||(_e.firstChild&&_e.firstChild.contentEditable=="true"));default:return _d.contentEditable=="true";}},effectiveTabIndex:function(_10){if(_5.get(_10,"disabled")){return _a;}else{if(_5.has(_10,"tabIndex")){return +_5.get(_10,"tabIndex");}else{return _b.hasDefaultTabStop(_10)?0:_a;}}},isTabNavigable:function(_11){return _b.effectiveTabIndex(_11)>=0;},isFocusable:function(_12){return _b.effectiveTabIndex(_12)>=-1;},_getTabNavigable:function(_13){var _14,_15,_16,_17,_18,_19,_1a={};function _1b(_1c){return _1c&&_1c.tagName.toLowerCase()=="input"&&_1c.type&&_1c.type.toLowerCase()=="radio"&&_1c.name&&_1c.name.toLowerCase();};var _1d=_b._isElementShown,_1e=_b.effectiveTabIndex;var _1f=function(_20){for(var _21=_20.firstChild;_21;_21=_21.nextSibling){if(_21.nodeType!=1||(_8("ie")<=9&&_21.scopeName!=="HTML")||!_1d(_21)){continue;}var _22=_1e(_21);if(_22>=0){if(_22==0){if(!_14){_14=_21;}_15=_21;}else{if(_22>0){if(!_16||_22<_17){_17=_22;_16=_21;}if(!_18||_22>=_19){_19=_22;_18=_21;}}}var rn=_1b(_21);if(_5.get(_21,"checked")&&rn){_1a[rn]=_21;}}if(_21.nodeName.toUpperCase()!="SELECT"){_1f(_21);}}};if(_1d(_13)){_1f(_13);}function rs(_23){return _1a[_1b(_23)]||_23;};return {first:rs(_14),last:rs(_15),lowest:rs(_16),highest:rs(_18)};},getFirstInTabbingOrder:function(_24,doc){var _25=_b._getTabNavigable(_4.byId(_24,doc));return _25.lowest?_25.lowest:_25.first;},getLastInTabbingOrder:function(_26,doc){var _27=_b._getTabNavigable(_4.byId(_26,doc));return _27.last?_27.last:_27.highest;}};1&&_7.mixin(_9,_b);return _b;});},"dijit/WidgetSet":function(){define("dijit/WidgetSet",["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","./registry"],function(_28,_29,_2a,_2b){var _2c=_29("dijit.WidgetSet",null,{constructor:function(){this._hash={};this.length=0;},add:function(_2d){if(this._hash[_2d.id]){throw new Error("Tried to register widget with id=="+_2d.id+" but that id is already registered");}this._hash[_2d.id]=_2d;this.length++;},remove:function(id){if(this._hash[id]){delete this._hash[id];this.length--;}},forEach:function(_2e,_2f){_2f=_2f||_2a.global;var i=0,id;for(id in this._hash){_2e.call(_2f,this._hash[id],i++,this._hash);}return this;},filter:function(_30,_31){_31=_31||_2a.global;var res=new _2c(),i=0,id;for(id in this._hash){var w=this._hash[id];if(_30.call(_31,w,i++,this._hash)){res.add(w);}}return res;},byId:function(id){return this._hash[id];},byClass:function(cls){var res=new _2c(),id,_32;for(id in this._hash){_32=this._hash[id];if(_32.declaredClass==cls){res.add(_32);}}return res;},toArray:function(){var ar=[];for(var id in this._hash){ar.push(this._hash[id]);}return ar;},map:function(_33,_34){return _28.map(this.toArray(),_33,_34);},every:function(_35,_36){_36=_36||_2a.global;var x=0,i;for(i in this._hash){if(!_35.call(_36,this._hash[i],x++,this._hash)){return false;}}return true;},some:function(_37,_38){_38=_38||_2a.global;var x=0,i;for(i in this._hash){if(_37.call(_38,this._hash[i],x++,this._hash)){return true;}}return false;}});_28.forEach(["forEach","filter","byClass","map","every","some"],function(_39){_2b[_39]=_2c.prototype[_39];});return _2c;});},"dijit/registry":function(){define(["dojo/_base/array","dojo/sniff","dojo/_base/unload","dojo/_base/window","./main"],function(_3a,has,_3b,win,_3c){var _3d={},_3e={};var _3f={length:0,add:function(_40){if(_3e[_40.id]){throw new Error("Tried to register widget with id=="+_40.id+" but that id is already registered");}_3e[_40.id]=_40;this.length++;},remove:function(id){if(_3e[id]){delete _3e[id];this.length--;}},byId:function(id){return typeof id=="string"?_3e[id]:id;},byNode:function(_41){return _3e[_41.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in _3e){ar.push(_3e[id]);}return ar;},getUniqueId:function(_42){var id;do{id=_42+"_"+(_42 in _3d?++_3d[_42]:_3d[_42]=0);}while(_3e[id]);return _3c._scopeName=="dijit"?id:_3c._scopeName+"_"+id;},findWidgets:function(_43,_44){var _45=[];function _46(_47){for(var _48=_47.firstChild;_48;_48=_48.nextSibling){if(_48.nodeType==1){var _49=_48.getAttribute("widgetId");if(_49){var _4a=_3e[_49];if(_4a){_45.push(_4a);}}else{if(_48!==_44){_46(_48);}}}}};_46(_43);return _45;},_destroyAll:function(){_3c._curFocus=null;_3c._prevFocus=null;_3c._activeStack=[];_3a.forEach(_3f.findWidgets(win.body()),function(_4b){if(!_4b._destroyed){if(_4b.destroyRecursive){_4b.destroyRecursive();}else{if(_4b.destroy){_4b.destroy();}}}});},getEnclosingWidget:function(_4c){while(_4c){var id=_4c.nodeType==1&&_4c.getAttribute("widgetId");if(id){return _3e[id];}_4c=_4c.parentNode;}return null;},_hash:_3e};_3c.registry=_3f;return _3f;});},"dijit/_base/focus":function(){define(["dojo/_base/array","dojo/dom","dojo/_base/lang","dojo/topic","dojo/_base/window","../focus","../main"],function(_4d,dom,_4e,_4f,win,_50,_51){var _52={_curFocus:null,_prevFocus:null,isCollapsed:function(){return _51.getBookmark().isCollapsed;},getBookmark:function(){var bm,rg,tg,sel=win.doc.selection,cf=_50.curNode;if(win.global.getSelection){sel=win.global.getSelection();if(sel){if(sel.isCollapsed){tg=cf?cf.tagName:"";if(tg){tg=tg.toLowerCase();if(tg=="textarea"||(tg=="input"&&(!cf.type||cf.type.toLowerCase()=="text"))){sel={start:cf.selectionStart,end:cf.selectionEnd,node:cf,pRange:true};return {isCollapsed:(sel.end<=sel.start),mark:sel};}}bm={isCollapsed:true};if(sel.rangeCount){bm.mark=sel.getRangeAt(0).cloneRange();}}else{rg=sel.getRangeAt(0);bm={isCollapsed:false,mark:rg.cloneRange()};}}}else{if(sel){tg=cf?cf.tagName:"";tg=tg.toLowerCase();if(cf&&tg&&(tg=="button"||tg=="textarea"||tg=="input")){if(sel.type&&sel.type.toLowerCase()=="none"){return {isCollapsed:true,mark:null};}else{rg=sel.createRange();return {isCollapsed:rg.text&&rg.text.length?false:true,mark:{range:rg,pRange:true}};}}bm={};try{rg=sel.createRange();bm.isCollapsed=!(sel.type=="Text"?rg.htmlText.length:rg.length);}catch(e){bm.isCollapsed=true;return bm;}if(sel.type.toUpperCase()=="CONTROL"){if(rg.length){bm.mark=[];var i=0,len=rg.length;while(i<len){bm.mark.push(rg.item(i++));}}else{bm.isCollapsed=true;bm.mark=null;}}else{bm.mark=rg.getBookmark();}}else{console.warn("No idea how to store the current selection for this browser!");}}return bm;},moveToBookmark:function(_53){var _54=win.doc,_55=_53.mark;if(_55){if(win.global.getSelection){var sel=win.global.getSelection();if(sel&&sel.removeAllRanges){if(_55.pRange){var n=_55.node;n.selectionStart=_55.start;n.selectionEnd=_55.end;}else{sel.removeAllRanges();sel.addRange(_55);}}else{console.warn("No idea how to restore selection for this browser!");}}else{if(_54.selection&&_55){var rg;if(_55.pRange){rg=_55.range;}else{if(_4e.isArray(_55)){rg=_54.body.createControlRange();_4d.forEach(_55,function(n){rg.addElement(n);});}else{rg=_54.body.createTextRange();rg.moveToBookmark(_55);}}rg.select();}}}},getFocus:function(_56,_57){var _58=!_50.curNode||(_56&&dom.isDescendant(_50.curNode,_56.domNode))?_51._prevFocus:_50.curNode;return {node:_58,bookmark:_58&&(_58==_50.curNode)&&win.withGlobal(_57||win.global,_51.getBookmark),openedForWindow:_57};},_activeStack:[],registerIframe:function(_59){return _50.registerIframe(_59);},unregisterIframe:function(_5a){_5a&&_5a.remove();},registerWin:function(_5b,_5c){return _50.registerWin(_5b,_5c);},unregisterWin:function(_5d){_5d&&_5d.remove();}};_50.focus=function(_5e){if(!_5e){return;}var _5f="node" in _5e?_5e.node:_5e,_60=_5e.bookmark,_61=_5e.openedForWindow,_62=_60?_60.isCollapsed:false;if(_5f){var _63=(_5f.tagName.toLowerCase()=="iframe")?_5f.contentWindow:_5f;if(_63&&_63.focus){try{_63.focus();}catch(e){}}_50._onFocusNode(_5f);}if(_60&&win.withGlobal(_61||win.global,_51.isCollapsed)&&!_62){if(_61){_61.focus();}try{win.withGlobal(_61||win.global,_51.moveToBookmark,null,[_60]);}catch(e2){}}};_50.watch("curNode",function(_64,_65,_66){_51._curFocus=_66;_51._prevFocus=_65;if(_66){_4f.publish("focusNode",_66);}});_50.watch("activeStack",function(_67,_68,_69){_51._activeStack=_69;});_50.on("widget-blur",function(_6a,by){_4f.publish("widgetBlur",_6a,by);});_50.on("widget-focus",function(_6b,by){_4f.publish("widgetFocus",_6b,by);});_4e.mixin(_51,_52);return _51;});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_6c,_6d,dom,_6e,_6f,_70,_71,on,_72,has,_73,_74,win,_75,_76,_77,_78){var _79;var _7a=_6d([_73,_70],{curNode:null,activeStack:[],constructor:function(){var _7b=_71.hitch(this,function(_7c){if(dom.isDescendant(this.curNode,_7c)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,_7c)){this.set("prevNode",null);}});_6c.before(_6f,"empty",_7b);_6c.before(_6f,"destroy",_7b);},registerIframe:function(_7d){return this.registerWin(_7d.contentWindow,_7d);},registerWin:function(_7e,_7f){var _80=this,_81=_7e.document&&_7e.document.body;if(_81){var mdh=on(_81,"mousedown",function(evt){_80._justMouseDowned=true;setTimeout(function(){_80._justMouseDowned=false;},13);if(evt&&evt.target&&evt.target.parentNode==null){return;}_80._onTouchNode(_7f||evt.target,"mouse");});var fih=on(_81,"focusin",function(evt){_79=(new Date()).getTime();if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(_76.isFocusable(evt.target)){_80._onFocusNode(_7f||evt.target);}else{_80._onTouchNode(_7f||evt.target);}});var foh=on(_81,"focusout",function(evt){if((new Date()).getTime()<_79+100){return;}_80._onBlurNode(_7f||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;_81=null;}};}},_onBlurNode:function(_82){if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(_71.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(_71.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(_83,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}var _84=[];try{while(_83){var _85=_6e.get(_83,"dijitPopupParent");if(_85){_83=_77.byId(_85).domNode;}else{if(_83.tagName&&_83.tagName.toLowerCase()=="body"){if(_83===win.body()){break;}_83=_75.get(_83.ownerDocument).frameElement;}else{var id=_83.getAttribute&&_83.getAttribute("widgetId"),_86=id&&_77.byId(id);if(_86&&!(by=="mouse"&&_86.get("disabled"))){_84.unshift(id);}_83=_83.parentNode;}}}}catch(e){}this._setStack(_84,by);},_onFocusNode:function(_87){if(!_87){return;}if(_87.nodeType==9){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(_87);if(_87==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",_87);},_setStack:function(_88,by){var _89=this.activeStack;this.set("activeStack",_88);for(var _8a=0;_8a<Math.min(_89.length,_88.length);_8a++){if(_89[_8a]!=_88[_8a]){break;}}var _8b;for(var i=_89.length-1;i>=_8a;i--){_8b=_77.byId(_89[i]);if(_8b){_8b._hasBeenBlurred=true;_8b.set("focused",false);if(_8b._focusManager==this){_8b._onBlur(by);}this.emit("widget-blur",_8b,by);}}for(i=_8a;i<_88.length;i++){_8b=_77.byId(_88[i]);if(_8b){_8b.set("focused",true);if(_8b._focusManager==this){_8b._onFocus(by);}this.emit("widget-focus",_8b,by);}}},focus:function(_8c){if(_8c){try{_8c.focus();}catch(e){}}}});var _8d=new _7a();_72(function(){var _8e=_8d.registerWin(_75.get(win.doc));if(has("ie")){_74.addOnWindowUnload(function(){if(_8e){_8e.remove();_8e=null;}});}});_78.focus=function(_8f){_8d.focus(_8f);};for(var _90 in _8d){if(!/^_/.test(_90)){_78.focus[_90]=typeof _8d[_90]=="function"?_71.hitch(_8d,_90):_8d[_90];}}_8d.watch(function(_91,_92,_93){_78.focus[_91]=_93;});return _8d;});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_94,_95,_96,_97){return _94("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(_98){var apn=this._attrPairNames;if(apn[_98]){return apn[_98];}return (apn[_98]={s:"_"+_98+"Setter",g:"_"+_98+"Getter"});},postscript:function(_99){if(_99){this.set(_99);}},_get:function(_9a,_9b){return typeof this[_9b.g]==="function"?this[_9b.g]():this[_9a];},get:function(_9c){return this._get(_9c,this._getAttrNames(_9c));},set:function(_9d,_9e){if(typeof _9d==="object"){for(var x in _9d){if(_9d.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,_9d[x]);}}return this;}var _9f=this._getAttrNames(_9d),_a0=this._get(_9d,_9f),_a1=this[_9f.s],_a2;if(typeof _a1==="function"){_a2=_a1.apply(this,Array.prototype.slice.call(arguments,1));}else{this[_9d]=_9e;}if(this._watchCallbacks){var _a3=this;_97(_a2,function(){_a3._watchCallbacks(_9d,_a0,_9e);});}return this;},_changeAttrValue:function(_a4,_a5){var _a6=this.get(_a4);this[_a4]=_a5;if(this._watchCallbacks){this._watchCallbacks(_a4,_a6,_a5);}return this;},watch:function(_a7,_a8){var _a9=this._watchCallbacks;if(!_a9){var _aa=this;_a9=this._watchCallbacks=function(_ab,_ac,_ad,_ae){var _af=function(_b0){if(_b0){_b0=_b0.slice();for(var i=0,l=_b0.length;i<l;i++){_b0[i].call(_aa,_ab,_ac,_ad);}}};_af(_a9["_"+_ab]);if(!_ae){_af(_a9["*"]);}};}if(!_a8&&typeof _a7==="function"){_a8=_a7;_a7="*";}else{_a7="_"+_a7;}var _b1=_a9[_a7];if(typeof _b1!=="object"){_b1=_a9[_a7]=[];}_b1.push(_a8);var _b2={};_b2.unwatch=_b2.remove=function(){var _b3=_96.indexOf(_b1,_a8);if(_b3>-1){_b1.splice(_b3,1);}};return _b2;}});});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(_b4,has,_b5,dom,_b6,_b7,_b8){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var _b9=_b5.body(doc),_ba=_b8.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},_b9,"last"),div=_b8.create("div",{style:{overflow:"hidden",direction:"ltr"}},_ba,"last"),ret=_b6.position(div).x!=0;_ba.removeChild(div);_b9.removeChild(_ba);return ret;});has.add("position-fixed-support",function(win,doc){var _bb=_b5.body(doc),_bc=_b8.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},_bb,"last"),_bd=_b8.create("span",{style:{position:"fixed",left:"0",top:"0"}},_bc,"last"),ret=_b6.position(_bd).x!=_b6.position(_bc).x;_bc.removeChild(_bd);_bb.removeChild(_bc);return ret;});var _be={getBox:function(doc){doc=doc||_b5.doc;var _bf=(doc.compatMode=="BackCompat")?_b5.body(doc):doc.documentElement,_c0=_b6.docScroll(doc),w,h;if(has("touch")){var _c1=_be.get(doc);w=_c1.innerWidth||_bf.clientWidth;h=_c1.innerHeight||_bf.clientHeight;}else{w=_bf.clientWidth;h=_bf.clientHeight;}return {l:_c0.x,t:_c0.y,w:w,h:h};},get:function(doc){if(has("ie")&&_be!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(_c2,pos){try{_c2=dom.byId(_c2);var doc=_c2.ownerDocument||_b5.doc,_c3=_b5.body(doc),_c4=doc.documentElement||_c3.parentNode,_c5=has("ie"),_c6=has("webkit");if(_c2==_c3||_c2==_c4){return;}if(!(has("mozilla")||_c5||_c6||has("opera")||has("trident"))&&("scrollIntoView" in _c2)){_c2.scrollIntoView(false);return;}var _c7=doc.compatMode=="BackCompat",_c8=Math.min(_c3.clientWidth||_c4.clientWidth,_c4.clientWidth||_c3.clientWidth),_c9=Math.min(_c3.clientHeight||_c4.clientHeight,_c4.clientHeight||_c3.clientHeight),_ca=(_c6||_c7)?_c3:_c4,_cb=pos||_b6.position(_c2),el=_c2.parentNode,_cc=function(el){return (_c5<=6||(_c5==7&&_c7))?false:(has("position-fixed-support")&&(_b7.get(el,"position").toLowerCase()=="fixed"));},_cd=this,_ce=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){_cd.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_cc(_c2)){return;}while(el){if(el==_c3){el=_ca;}var _cf=_b6.position(el),_d0=_cc(el),rtl=_b7.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_ca){_cf.w=_c8;_cf.h=_c9;if(_ca==_c4&&(_c5||has("trident"))&&rtl){_cf.x+=_ca.offsetWidth-_cf.w;}_cf.x=0;_cf.y=0;}else{var pb=_b6.getPadBorderExtents(el);_cf.w-=pb.w;_cf.h-=pb.h;_cf.x+=pb.l;_cf.y+=pb.t;var _d1=el.clientWidth,_d2=_cf.w-_d1;if(_d1>0&&_d2>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_cf.x+=_d2;}_cf.w=_d1;}_d1=el.clientHeight;_d2=_cf.h-_d1;if(_d1>0&&_d2>0){_cf.h=_d1;}}if(_d0){if(_cf.y<0){_cf.h+=_cf.y;_cf.y=0;}if(_cf.x<0){_cf.w+=_cf.x;_cf.x=0;}if(_cf.y+_cf.h>_c9){_cf.h=_c9-_cf.y;}if(_cf.x+_cf.w>_c8){_cf.w=_c8-_cf.x;}}var l=_cb.x-_cf.x,t=_cb.y-_cf.y,r=l+_cb.w-_cf.w,bot=t+_cb.h-_cf.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_ca||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((_c5==8&&!_c7)||has("trident")>=5)){s=-s;}old=el.scrollLeft;_ce(el,s,0);s=el.scrollLeft-old;_cb.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_ca||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_ce(el,0,s);s=el.scrollTop-old;_cb.y-=s;}el=(el!=_ca)&&!_d0&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);_c2.scrollIntoView(false);}}};1&&_b4.setObject("dojo.window",_be);return _be;});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_d3,_d4,_d5,_d6,_d7){var _d8={};_d3.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(_d9){_d8[_d9]=_d6[_d9];});_d5.mixin(_d8,{defaultDuration:_d4["defaultDuration"]||200});_d5.mixin(_d7,_d8);return _d7;});},"dijit/_base/place":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/window","../place","../main"],function(_da,_db,_dc,_dd,_de){var _df={};_df.getViewport=function(){return _dc.getBox();};_df.placeOnScreen=_dd.at;_df.placeOnScreenAroundElement=function(_e0,_e1,_e2,_e3){var _e4;if(_db.isArray(_e2)){_e4=_e2;}else{_e4=[];for(var key in _e2){_e4.push({aroundCorner:key,corner:_e2[key]});}}return _dd.around(_e0,_e1,_e4,true,_e3);};_df.placeOnScreenAroundNode=_df.placeOnScreenAroundElement;_df.placeOnScreenAroundRectangle=_df.placeOnScreenAroundElement;_df.getPopupAroundAlignment=function(_e5,_e6){var _e7={};_da.forEach(_e5,function(pos){var ltr=_e6;switch(pos){case "after":_e7[_e6?"BR":"BL"]=_e6?"BL":"BR";break;case "before":_e7[_e6?"BL":"BR"]=_e6?"BR":"BL";break;case "below-alt":ltr=!ltr;case "below":_e7[ltr?"BL":"BR"]=ltr?"TL":"TR";_e7[ltr?"BR":"BL"]=ltr?"TR":"TL";break;case "above-alt":ltr=!ltr;case "above":default:_e7[ltr?"TL":"TR"]=ltr?"BL":"BR";_e7[ltr?"TR":"TL"]=ltr?"BR":"BL";break;}});return _e7;};_db.mixin(_de,_df);return _de;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_e8,_e9,_ea,_eb,win,_ec,_ed){function _ee(_ef,_f0,_f1,_f2){var _f3=_ec.getEffectiveBox(_ef.ownerDocument);if(!_ef.parentNode||String(_ef.parentNode.tagName).toLowerCase()!="body"){win.body(_ef.ownerDocument).appendChild(_ef);}var _f4=null;_e8.some(_f0,function(_f5){var _f6=_f5.corner;var pos=_f5.pos;var _f7=0;var _f8={w:{"L":_f3.l+_f3.w-pos.x,"R":pos.x-_f3.l,"M":_f3.w}[_f6.charAt(1)],h:{"T":_f3.t+_f3.h-pos.y,"B":pos.y-_f3.t,"M":_f3.h}[_f6.charAt(0)]};var s=_ef.style;s.left=s.right="auto";if(_f1){var res=_f1(_ef,_f5.aroundCorner,_f6,_f8,_f2);_f7=typeof res=="undefined"?0:res;}var _f9=_ef.style;var _fa=_f9.display;var _fb=_f9.visibility;if(_f9.display=="none"){_f9.visibility="hidden";_f9.display="";}var bb=_e9.position(_ef);_f9.display=_fa;_f9.visibility=_fb;var _fc={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(_f3.l,Math.min(_f3.l+_f3.w,pos.x+(bb.w>>1))-bb.w)}[_f6.charAt(1)],_fd={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(_f3.t,Math.min(_f3.t+_f3.h,pos.y+(bb.h>>1))-bb.h)}[_f6.charAt(0)],_fe=Math.max(_f3.l,_fc),_ff=Math.max(_f3.t,_fd),endX=Math.min(_f3.l+_f3.w,_fc+bb.w),endY=Math.min(_f3.t+_f3.h,_fd+bb.h),_100=endX-_fe,_101=endY-_ff;_f7+=(bb.w-_100)+(bb.h-_101);if(_f4==null||_f7<_f4.overflow){_f4={corner:_f6,aroundCorner:_f5.aroundCorner,x:_fe,y:_ff,w:_100,h:_101,overflow:_f7,spaceAvailable:_f8};}return !_f7;});if(_f4.overflow&&_f1){_f1(_ef,_f4.aroundCorner,_f4.corner,_f4.spaceAvailable,_f2);}var s=_ef.style;s.top=_f4.y+"px";s.left=_f4.x+"px";s.right="auto";return _f4;};var _102={at:function(node,pos,_103,_104){var _105=_e8.map(_103,function(_106){var c={corner:_106,pos:{x:pos.x,y:pos.y}};if(_104){c.pos.x+=_106.charAt(1)=="L"?_104.x:-_104.x;c.pos.y+=_106.charAt(0)=="T"?_104.y:-_104.y;}return c;});return _ee(node,_105);},around:function(node,_107,_108,_109,_10a){var _10b=(typeof _107=="string"||"offsetWidth" in _107||"ownerSVGElement" in _107)?_e9.position(_107,true):_107;if(_107.parentNode){var _10c=_ea.getComputedStyle(_107).position=="absolute";var _10d=_107.parentNode;while(_10d&&_10d.nodeType==1&&_10d.nodeName!="BODY"){var _10e=_e9.position(_10d,true),pcs=_ea.getComputedStyle(_10d);if(/relative|absolute/.test(pcs.position)){_10c=false;}if(!_10c&&/hidden|auto|scroll/.test(pcs.overflow)){var _10f=Math.min(_10b.y+_10b.h,_10e.y+_10e.h);var _110=Math.min(_10b.x+_10b.w,_10e.x+_10e.w);_10b.x=Math.max(_10b.x,_10e.x);_10b.y=Math.max(_10b.y,_10e.y);_10b.h=_10f-_10b.y;_10b.w=_110-_10b.x;}if(pcs.position=="absolute"){_10c=true;}_10d=_10d.parentNode;}}var x=_10b.x,y=_10b.y,_111="w" in _10b?_10b.w:(_10b.w=_10b.width),_112="h" in _10b?_10b.h:(_eb.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_10b.height+", width:"+_111+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_10b.height+", w:"+_111+" }","","2.0"),_10b.h=_10b.height);var _113=[];function push(_114,_115){_113.push({aroundCorner:_114,corner:_115,pos:{x:{"L":x,"R":x+_111,"M":x+(_111>>1)}[_114.charAt(1)],y:{"T":y,"B":y+_112,"M":y+(_112>>1)}[_114.charAt(0)]}});};_e8.forEach(_108,function(pos){var ltr=_109;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _116=_ee(node,_113,_10a,{w:_111,h:_112});_116.aroundNodePos=_10b;return _116;}};return _ed.place=_102;});},"dijit/Viewport":function(){define("dijit/Viewport",["dojo/Evented","dojo/on","dojo/ready","dojo/sniff","dojo/_base/window","dojo/window"],function(_117,on,_118,has,win,_119){var _11a=new _117();var _11b;_118(200,function(){var _11c=_119.getBox();_11a._rlh=on(win.global,"resize",function(){var _11d=_119.getBox();if(_11c.h==_11d.h&&_11c.w==_11d.w){return;}_11c=_11d;_11a.emit("resize");});if(has("ie")==8){var _11e=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_11e){_11e=screen.deviceXDPI;_11a.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_11b=evt.target;});on(document,"focusout",function(evt){_11b=null;});}});_11a.getEffectiveBox=function(doc){var box=_119.getBox(doc);var tag=_11b&&_11b.tagName&&_11b.tagName.toLowerCase();if(has("ios")&&_11b&&!_11b.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_11b.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_11b.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _11a;});},"dijit/_base/popup":function(){define(["dojo/dom-class","dojo/_base/window","../popup","../BackgroundIframe"],function(_11f,win,_120){var _121=_120._createWrapper;_120._createWrapper=function(_122){if(!_122.declaredClass){_122={_popupWrapper:(_122.parentNode&&_11f.contains(_122.parentNode,"dijitPopup"))?_122.parentNode:null,domNode:_122,destroy:function(){},ownerDocument:_122.ownerDocument,ownerDocumentBody:win.body(_122.ownerDocument)};}return _121.call(this,_122);};var _123=_120.open;_120.open=function(args){if(args.orient&&typeof args.orient!="string"&&!("length" in args.orient)){var ary=[];for(var key in args.orient){ary.push({aroundCorner:key,corner:args.orient[key]});}args.orient=ary;}return _123.call(this,args);};return _120;});},"dijit/popup":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./place","./BackgroundIframe","./main"],function(_124,_125,_126,_127,dom,_128,_129,_12a,_12b,_12c,has,keys,lang,on,_12d,_12e,_12f){function _130(){if(this._popupWrapper){_129.destroy(this._popupWrapper);delete this._popupWrapper;}};var _131=_127(null,{_stack:[],_beginZIndex:1000,_idGen:1,_createWrapper:function(_132){var _133=_132._popupWrapper,node=_132.domNode;if(!_133){_133=_129.create("div",{"class":"dijitPopup",style:{display:"none"},role:"region","aria-label":_132["aria-label"]||_132.label||_132.name||_132.id},_132.ownerDocumentBody);_133.appendChild(node);var s=node.style;s.display="";s.visibility="";s.position="";s.top="0px";_132._popupWrapper=_133;_125.after(_132,"destroy",_130,true);}return _133;},moveOffScreen:function(_134){var _135=this._createWrapper(_134);_12b.set(_135,{visibility:"hidden",top:"-9999px",display:""});},hide:function(_136){var _137=this._createWrapper(_136);_12b.set(_137,"display","none");},getTopPopup:function(){var _138=this._stack;for(var pi=_138.length-1;pi>0&&_138[pi].parent===_138[pi-1].widget;pi--){}return _138[pi];},open:function(args){var _139=this._stack,_13a=args.popup,_13b=args.orient||["below","below-alt","above","above-alt"],ltr=args.parent?args.parent.isLeftToRight():_12a.isBodyLtr(_13a.ownerDocument),_13c=args.around,id=(args.around&&args.around.id)?(args.around.id+"_dropdown"):("popup_"+this._idGen++);while(_139.length&&(!args.parent||!dom.isDescendant(args.parent.domNode,_139[_139.length-1].widget.domNode))){this.close(_139[_139.length-1].widget);}var _13d=this._createWrapper(_13a);_128.set(_13d,{id:id,style:{zIndex:this._beginZIndex+_139.length},"class":"dijitPopup "+(_13a.baseClass||_13a["class"]||"").split(" ")[0]+"Popup",dijitPopupParent:args.parent?args.parent.id:""});if(has("bgIframe")&&!_13a.bgIframe){_13a.bgIframe=new _12e(_13d);}var best=_13c?_12d.around(_13d,_13c,_13b,ltr,_13a.orient?lang.hitch(_13a,"orient"):null):_12d.at(_13d,args,_13b=="R"?["TR","BR","TL","BL"]:["TL","BL","TR","BR"],args.padding);_13d.style.display="";_13d.style.visibility="visible";_13a.domNode.style.visibility="visible";var _13e=[];_13e.push(on(_13d,_126._keypress,lang.hitch(this,function(evt){if(evt.charOrCode==keys.ESCAPE&&args.onCancel){_12c.stop(evt);args.onCancel();}else{if(evt.charOrCode===keys.TAB){_12c.stop(evt);var _13f=this.getTopPopup();if(_13f&&_13f.onCancel){_13f.onCancel();}}}})));if(_13a.onCancel&&args.onCancel){_13e.push(_13a.on("cancel",args.onCancel));}_13e.push(_13a.on(_13a.onExecute?"execute":"change",lang.hitch(this,function(){var _140=this.getTopPopup();if(_140&&_140.onExecute){_140.onExecute();}})));_139.push({widget:_13a,parent:args.parent,onExecute:args.onExecute,onCancel:args.onCancel,onClose:args.onClose,handlers:_13e});if(_13a.onOpen){_13a.onOpen(best);}return best;},close:function(_141){var _142=this._stack;while((_141&&_124.some(_142,function(elem){return elem.widget==_141;}))||(!_141&&_142.length)){var top=_142.pop(),_143=top.widget,_144=top.onClose;if(_143.onClose){_143.onClose();}var h;while(h=top.handlers.pop()){h.remove();}if(_143&&_143.domNode){this.hide(_143);}if(_144){_144();}}}});return (_12f.popup=new _131());});},"dijit/BackgroundIframe":function(){define("dijit/BackgroundIframe",["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window"],function(_145,_146,_147,_148,_149,lang,on,has,win){has.add("bgIframe",has("ie")||has("mozilla"));var _14a=new function(){var _14b=[];this.pop=function(){var _14c;if(_14b.length){_14c=_14b.pop();_14c.style.display="";}else{if(has("ie")<9){var burl=_147["dojoBlankHtmlUrl"]||_145.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_14c=win.doc.createElement(html);}else{_14c=_148.create("iframe");_14c.src="javascript:\"\"";_14c.className="dijitBackgroundIframe";_14c.setAttribute("role","presentation");_149.set(_14c,"opacity",0.1);}_14c.tabIndex=-1;}return _14c;};this.push=function(_14d){_14d.style.display="none";_14b.push(_14d);};}();_146.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("bgIframe")){var _14e=(this.iframe=_14a.pop());node.appendChild(_14e);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,function(){this.resize(node);}));}else{_149.set(_14e,{width:"100%",height:"100%"});}}};lang.extend(_146.BackgroundIframe,{resize:function(node){if(this.iframe){_149.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_14a.push(this.iframe);delete this.iframe;}}});return _146.BackgroundIframe;});},"dijit/_base/scroll":function(){define(["dojo/window","../main"],function(_14f,_150){_150.scrollIntoView=function(node,pos){_14f.scrollIntoView(node,pos);};});},"dijit/_base/sniff":function(){define(["dojo/uacss"],function(){});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./ready","./sniff","./_base/window"],function(_151,lang,_152,has,_153){var html=_153.doc.documentElement,ie=has("ie"),_154=has("trident"),_155=has("opera"),maj=Math.floor,ff=has("ff"),_156=_151.boxModel.replace(/-/,""),_157={"dj_quirks":has("quirks"),"dj_opera":_155,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla")};if(ie){_157["dj_ie"]=true;_157["dj_ie"+maj(ie)]=true;_157["dj_iequirks"]=has("quirks");}if(_154){_157["dj_trident"]=true;_157["dj_trident"+maj(_154)]=true;}if(ff){_157["dj_ff"+maj(ff)]=true;}_157["dj_"+_156]=true;var _158="";for(var clz in _157){if(_157[clz]){_158+=clz+" ";}}html.className=lang.trim(html.className+" "+_158);_152(90,function(){if(!_151.isBodyLtr()){var _159="dj_rtl dijitRtl "+_158.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_159+"dj_rtl dijitRtl "+_158.replace(/ /g,"-rtl "));}});return has;});},"dijit/_base/typematic":function(){define(["../typematic"],function(){});},"dijit/typematic":function(){define(["dojo/_base/array","dojo/_base/connect","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./main"],function(_15a,_15b,_15c,_15d,lang,on,has,_15e){var _15f=(_15e.typematic={_fireEventAndReload:function(){this._timer=null;this._callback(++this._count,this._node,this._evt);this._currentTimeout=Math.max(this._currentTimeout<0?this._initialDelay:(this._subsequentDelay>1?this._subsequentDelay:Math.round(this._currentTimeout*this._subsequentDelay)),this._minDelay);this._timer=setTimeout(lang.hitch(this,"_fireEventAndReload"),this._currentTimeout);},trigger:function(evt,_160,node,_161,obj,_162,_163,_164){if(obj!=this._obj){this.stop();this._initialDelay=_163||500;this._subsequentDelay=_162||0.9;this._minDelay=_164||10;this._obj=obj;this._node=node;this._currentTimeout=-1;this._count=-1;this._callback=lang.hitch(_160,_161);this._evt={faux:true};for(var attr in evt){if(attr!="layerX"&&attr!="layerY"){var v=evt[attr];if(typeof v!="function"&&typeof v!="undefined"){this._evt[attr]=v;}}}this._fireEventAndReload();}},stop:function(){if(this._timer){clearTimeout(this._timer);this._timer=null;}if(this._obj){this._callback(-1,this._node,this._evt);this._obj=null;}},addKeyListener:function(node,_165,_166,_167,_168,_169,_16a){if(_165.keyCode){_165.charOrCode=_165.keyCode;_15d.deprecated("keyCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");}else{if(_165.charCode){_165.charOrCode=String.fromCharCode(_165.charCode);_15d.deprecated("charCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");}}var _16b=[on(node,_15b._keypress,lang.hitch(this,function(evt){if(evt.charOrCode==_165.charOrCode&&(_165.ctrlKey===undefined||_165.ctrlKey==evt.ctrlKey)&&(_165.altKey===undefined||_165.altKey==evt.altKey)&&(_165.metaKey===undefined||_165.metaKey==(evt.metaKey||false))&&(_165.shiftKey===undefined||_165.shiftKey==evt.shiftKey)){_15c.stop(evt);_15f.trigger(evt,_166,node,_167,_165,_168,_169,_16a);}else{if(_15f._obj==_165){_15f.stop();}}})),on(node,"keyup",lang.hitch(this,function(){if(_15f._obj==_165){_15f.stop();}}))];return {remove:function(){_15a.forEach(_16b,function(h){h.remove();});}};},addMouseListener:function(node,_16c,_16d,_16e,_16f,_170){var _171=[on(node,"mousedown",lang.hitch(this,function(evt){evt.preventDefault();_15f.trigger(evt,_16c,node,_16d,node,_16e,_16f,_170);})),on(node,"mouseup",lang.hitch(this,function(evt){if(this._obj){evt.preventDefault();}_15f.stop();})),on(node,"mouseout",lang.hitch(this,function(evt){if(this._obj){evt.preventDefault();}_15f.stop();})),on(node,"dblclick",lang.hitch(this,function(evt){evt.preventDefault();if(has("ie")<9){_15f.trigger(evt,_16c,node,_16d,node,_16e,_16f,_170);setTimeout(lang.hitch(this,_15f.stop),50);}}))];return {remove:function(){_15a.forEach(_171,function(h){h.remove();});}};},addListener:function(_172,_173,_174,_175,_176,_177,_178,_179){var _17a=[this.addKeyListener(_173,_174,_175,_176,_177,_178,_179),this.addMouseListener(_172,_175,_176,_177,_178,_179)];return {remove:function(){_15a.forEach(_17a,function(h){h.remove();});}};}});return _15f;});},"dijit/_base/wai":function(){define(["dojo/dom-attr","dojo/_base/lang","../main","../hccss"],function(_17b,lang,_17c){var _17d={hasWaiRole:function(elem,role){var _17e=this.getWaiRole(elem);return role?(_17e.indexOf(role)>-1):(_17e.length>0);},getWaiRole:function(elem){return lang.trim((_17b.get(elem,"role")||"").replace("wairole:",""));},setWaiRole:function(elem,role){_17b.set(elem,"role",role);},removeWaiRole:function(elem,role){var _17f=_17b.get(elem,"role");if(!_17f){return;}if(role){var t=lang.trim((" "+_17f+" ").replace(" "+role+" "," "));_17b.set(elem,"role",t);}else{elem.removeAttribute("role");}},hasWaiState:function(elem,_180){return elem.hasAttribute?elem.hasAttribute("aria-"+_180):!!elem.getAttribute("aria-"+_180);},getWaiState:function(elem,_181){return elem.getAttribute("aria-"+_181)||"";},setWaiState:function(elem,_182,_183){elem.setAttribute("aria-"+_182,_183);},removeWaiState:function(elem,_184){elem.removeAttribute("aria-"+_184);}};lang.mixin(_17c,_17d);return _17c;});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/ready","dojo/_base/window"],function(_185,has,_186,win){_186(90,function(){if(has("highcontrast")){_185.add(win.body(),"dijit_a11y");}});return has;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./ready","./_base/window"],function(_187,_188,_189,_18a,has,_18b,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_188.blankGif||_187.toUrl("./resources/blank.gif"))+");";win.body().appendChild(div);var cs=_18a.getComputedStyle(div),_18c=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_18c&&(_18c=="none"||_18c=="url(invalid-url:)"));if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}return hc;});_18b(90,function(){if(has("highcontrast")){_189.add(win.body(),"dj_a11y");}});return has;});},"dijit/_base/window":function(){define(["dojo/window","../main"],function(_18d,_18e){_18e.getDocumentWindow=function(doc){return _18d.get(doc);};});},"dojo/parser":function(){define(["require","./_base/kernel","./_base/lang","./_base/array","./_base/config","./_base/html","./_base/window","./_base/url","./_base/json","./aspect","./date/stamp","./Deferred","./has","./query","./on","./ready"],function(_18f,dojo,_190,_191,_192,_193,_194,_195,_196,_197,_198,_199,has,_19a,don,_19b){new Date("X");var _19c=0;_197.after(_190,"extend",function(){_19c++;},true);function _19d(ctor){var map=ctor._nameCaseMap,_19e=ctor.prototype;if(!map||map._extendCnt<_19c){map=ctor._nameCaseMap={};for(var name in _19e){if(name.charAt(0)==="_"){continue;}map[name.toLowerCase()]=name;}map._extendCnt=_19c;}return map;};var _19f={};function _1a0(_1a1){var ts=_1a1.join();if(!_19f[ts]){var _1a2=[];for(var i=0,l=_1a1.length;i<l;i++){var t=_1a1[i];_1a2[_1a2.length]=(_19f[t]=_19f[t]||(_190.getObject(t)||(~t.indexOf("/")&&_18f(t))));}var ctor=_1a2.shift();_19f[ts]=_1a2.length?(ctor.createSubclass?ctor.createSubclass(_1a2):ctor.extend.apply(ctor,_1a2)):ctor;}return _19f[ts];};var _1a3={_clearCache:function(){_19c++;_19f={};},_functionFromScript:function(_1a4,_1a5){var _1a6="",_1a7="",_1a8=(_1a4.getAttribute(_1a5+"args")||_1a4.getAttribute("args")),_1a9=_1a4.getAttribute("with");var _1aa=(_1a8||"").split(/\s*,\s*/);if(_1a9&&_1a9.length){_191.forEach(_1a9.split(/\s*,\s*/),function(part){_1a6+="with("+part+"){";_1a7+="}";});}return new Function(_1aa,_1a6+_1a4.innerHTML+_1a7);},instantiate:function(_1ab,_1ac,_1ad){_1ac=_1ac||{};_1ad=_1ad||{};var _1ae=(_1ad.scope||dojo._scopeName)+"Type",_1af="data-"+(_1ad.scope||dojo._scopeName)+"-",_1b0=_1af+"type",_1b1=_1af+"mixins";var list=[];_191.forEach(_1ab,function(node){var type=_1ae in _1ac?_1ac[_1ae]:node.getAttribute(_1b0)||node.getAttribute(_1ae);if(type){var _1b2=node.getAttribute(_1b1),_1b3=_1b2?[type].concat(_1b2.split(/\s*,\s*/)):[type];list.push({node:node,types:_1b3});}});return this._instantiate(list,_1ac,_1ad);},_instantiate:function(_1b4,_1b5,_1b6){var _1b7=_191.map(_1b4,function(obj){var ctor=obj.ctor||_1a0(obj.types);if(!ctor){throw new Error("Unable to resolve constructor for: '"+obj.types.join()+"'");}return this.construct(ctor,obj.node,_1b5,_1b6,obj.scripts,obj.inherited);},this);if(!_1b5._started&&!_1b6.noStart){_191.forEach(_1b7,function(_1b8){if(typeof _1b8.startup==="function"&&!_1b8._started){_1b8.startup();}});}return _1b7;},construct:function(ctor,node,_1b9,_1ba,_1bb,_1bc){var _1bd=ctor&&ctor.prototype;_1ba=_1ba||{};var _1be={};if(_1ba.defaults){_190.mixin(_1be,_1ba.defaults);}if(_1bc){_190.mixin(_1be,_1bc);}var _1bf;if(has("dom-attributes-explicit")){_1bf=node.attributes;}else{if(has("dom-attributes-specified-flag")){_1bf=_191.filter(node.attributes,function(a){return a.specified;});}else{var _1c0=/^input$|^img$/i.test(node.nodeName)?node:node.cloneNode(false),_1c1=_1c0.outerHTML.replace(/=[^\s"']+|="[^"]*"|='[^']*'/g,"").replace(/^\s*<[a-zA-Z0-9]*\s*/,"").replace(/\s*>.*$/,"");_1bf=_191.map(_1c1.split(/\s+/),function(name){var _1c2=name.toLowerCase();return {name:name,value:(node.nodeName=="LI"&&name=="value")||_1c2=="enctype"?node.getAttribute(_1c2):node.getAttributeNode(_1c2).value};});}}var _1c3=_1ba.scope||dojo._scopeName,_1c4="data-"+_1c3+"-",hash={};if(_1c3!=="dojo"){hash[_1c4+"props"]="data-dojo-props";hash[_1c4+"type"]="data-dojo-type";hash[_1c4+"mixins"]="data-dojo-mixins";hash[_1c3+"type"]="dojoType";hash[_1c4+"id"]="data-dojo-id";}var i=0,item,_1c5=[],_1c6,_1c7;while(item=_1bf[i++]){var name=item.name,_1c8=name.toLowerCase(),_1c9=item.value;switch(hash[_1c8]||_1c8){case "data-dojo-type":case "dojotype":case "data-dojo-mixins":break;case "data-dojo-props":_1c7=_1c9;break;case "data-dojo-id":case "jsid":_1c6=_1c9;break;case "data-dojo-attach-point":case "dojoattachpoint":_1be.dojoAttachPoint=_1c9;break;case "data-dojo-attach-event":case "dojoattachevent":_1be.dojoAttachEvent=_1c9;break;case "class":_1be["class"]=node.className;break;case "style":_1be["style"]=node.style&&node.style.cssText;break;default:if(!(name in _1bd)){var map=_19d(ctor);name=map[_1c8]||name;}if(name in _1bd){switch(typeof _1bd[name]){case "string":_1be[name]=_1c9;break;case "number":_1be[name]=_1c9.length?Number(_1c9):NaN;break;case "boolean":_1be[name]=_1c9.toLowerCase()!="false";break;case "function":if(_1c9===""||_1c9.search(/[^\w\.]+/i)!=-1){_1be[name]=new Function(_1c9);}else{_1be[name]=_190.getObject(_1c9,false)||new Function(_1c9);}_1c5.push(name);break;default:var pVal=_1bd[name];_1be[name]=(pVal&&"length" in pVal)?(_1c9?_1c9.split(/\s*,\s*/):[]):(pVal instanceof Date)?(_1c9==""?new Date(""):_1c9=="now"?new Date():_198.fromISOString(_1c9)):(pVal instanceof _195)?(dojo.baseUrl+_1c9):_196.fromJson(_1c9);}}else{_1be[name]=_1c9;}}}for(var j=0;j<_1c5.length;j++){var _1ca=_1c5[j].toLowerCase();node.removeAttribute(_1ca);node[_1ca]=null;}if(_1c7){try{_1c7=_196.fromJson.call(_1ba.propsThis,"{"+_1c7+"}");_190.mixin(_1be,_1c7);}catch(e){throw new Error(e.toString()+" in data-dojo-props='"+_1c7+"'");}}_190.mixin(_1be,_1b9);if(!_1bb){_1bb=(ctor&&(ctor._noScript||_1bd._noScript)?[]:_19a("> script[type^='dojo/']",node));}var _1cb=[],_1cc=[],_1cd=[],ons=[];if(_1bb){for(i=0;i<_1bb.length;i++){var _1ce=_1bb[i];node.removeChild(_1ce);var _1cf=(_1ce.getAttribute(_1c4+"event")||_1ce.getAttribute("event")),prop=_1ce.getAttribute(_1c4+"prop"),_1d0=_1ce.getAttribute(_1c4+"method"),_1d1=_1ce.getAttribute(_1c4+"advice"),_1d2=_1ce.getAttribute("type"),nf=this._functionFromScript(_1ce,_1c4);if(_1cf){if(_1d2=="dojo/connect"){_1cb.push({method:_1cf,func:nf});}else{if(_1d2=="dojo/on"){ons.push({event:_1cf,func:nf});}else{_1be[_1cf]=nf;}}}else{if(_1d2=="dojo/aspect"){_1cb.push({method:_1d0,advice:_1d1,func:nf});}else{if(_1d2=="dojo/watch"){_1cd.push({prop:prop,func:nf});}else{_1cc.push(nf);}}}}}var _1d3=ctor.markupFactory||_1bd.markupFactory;var _1d4=_1d3?_1d3(_1be,node,ctor):new ctor(_1be,node);if(_1c6){_190.setObject(_1c6,_1d4);}for(i=0;i<_1cb.length;i++){_197[_1cb[i].advice||"after"](_1d4,_1cb[i].method,_190.hitch(_1d4,_1cb[i].func),true);}for(i=0;i<_1cc.length;i++){_1cc[i].call(_1d4);}for(i=0;i<_1cd.length;i++){_1d4.watch(_1cd[i].prop,_1cd[i].func);}for(i=0;i<ons.length;i++){don(_1d4,ons[i].event,ons[i].func);}return _1d4;},scan:function(root,_1d5){var list=[],mids=[],_1d6={};var _1d7=(_1d5.scope||dojo._scopeName)+"Type",_1d8="data-"+(_1d5.scope||dojo._scopeName)+"-",_1d9=_1d8+"type",_1da=_1d8+"textdir",_1db=_1d8+"mixins";var node=root.firstChild;var _1dc=_1d5.inherited;if(!_1dc){function _1dd(node,attr){return (node.getAttribute&&node.getAttribute(attr))||(node.parentNode&&_1dd(node.parentNode,attr));};_1dc={dir:_1dd(root,"dir"),lang:_1dd(root,"lang"),textDir:_1dd(root,_1da)};for(var key in _1dc){if(!_1dc[key]){delete _1dc[key];}}}var _1de={inherited:_1dc};var _1df;var _1e0;function _1e1(_1e2){if(!_1e2.inherited){_1e2.inherited={};var node=_1e2.node,_1e3=_1e1(_1e2.parent);var _1e4={dir:node.getAttribute("dir")||_1e3.dir,lang:node.getAttribute("lang")||_1e3.lang,textDir:node.getAttribute(_1da)||_1e3.textDir};for(var key in _1e4){if(_1e4[key]){_1e2.inherited[key]=_1e4[key];}}}return _1e2.inherited;};while(true){if(!node){if(!_1de||!_1de.node){break;}node=_1de.node.nextSibling;_1e0=false;_1de=_1de.parent;_1df=_1de.scripts;continue;}if(node.nodeType!=1){node=node.nextSibling;continue;}if(_1df&&node.nodeName.toLowerCase()=="script"){type=node.getAttribute("type");if(type&&/^dojo\/\w/i.test(type)){_1df.push(node);}node=node.nextSibling;continue;}if(_1e0){node=node.nextSibling;continue;}var type=node.getAttribute(_1d9)||node.getAttribute(_1d7);var _1e5=node.firstChild;if(!type&&(!_1e5||(_1e5.nodeType==3&&!_1e5.nextSibling))){node=node.nextSibling;continue;}var _1e6;var ctor=null;if(type){var _1e7=node.getAttribute(_1db),_1e8=_1e7?[type].concat(_1e7.split(/\s*,\s*/)):[type];try{ctor=_1a0(_1e8);}catch(e){}if(!ctor){_191.forEach(_1e8,function(t){if(~t.indexOf("/")&&!_1d6[t]){_1d6[t]=true;mids[mids.length]=t;}});}var _1e9=ctor&&!ctor.prototype._noScript?[]:null;_1e6={types:_1e8,ctor:ctor,parent:_1de,node:node,scripts:_1e9};_1e6.inherited=_1e1(_1e6);list.push(_1e6);}else{_1e6={node:node,scripts:_1df,parent:_1de};}node=_1e5;_1df=_1e9;_1e0=ctor&&ctor.prototype.stopParser&&!(_1d5.template);_1de=_1e6;}var d=new _199();if(mids.length){if(has("dojo-debug-messages")){console.warn("WARNING: Modules being Auto-Required: "+mids.join(", "));}_18f(mids,function(){d.resolve(_191.filter(list,function(_1ea){if(!_1ea.ctor){try{_1ea.ctor=_1a0(_1ea.types);}catch(e){}}var _1eb=_1ea.parent;while(_1eb&&!_1eb.types){_1eb=_1eb.parent;}var _1ec=_1ea.ctor&&_1ea.ctor.prototype;_1ea.instantiateChildren=!(_1ec&&_1ec.stopParser&&!(_1d5.template));_1ea.instantiate=!_1eb||(_1eb.instantiate&&_1eb.instantiateChildren);return _1ea.instantiate;}));});}else{d.resolve(list);}return d.promise;},_require:function(_1ed){var hash=_196.fromJson("{"+_1ed.innerHTML+"}"),vars=[],mids=[],d=new _199();for(var name in hash){vars.push(name);mids.push(hash[name]);}_18f(mids,function(){for(var i=0;i<vars.length;i++){_190.setObject(vars[i],arguments[i]);}d.resolve(arguments);});return d.promise;},_scanAmd:function(root){var _1ee=new _199(),_1ef=_1ee.promise;_1ee.resolve(true);var self=this;_19a("script[type='dojo/require']",root).forEach(function(node){_1ef=_1ef.then(function(){return self._require(node);});node.parentNode.removeChild(node);});return _1ef;},parse:function(_1f0,_1f1){if(_1f0&&typeof _1f0!="string"&&!("nodeType" in _1f0)){_1f1=_1f0;_1f0=_1f1.rootNode;}var root=_1f0?_193.byId(_1f0):_194.body();_1f1=_1f1||{};var _1f2=_1f1.template?{template:true}:{},_1f3=[],self=this;var p=this._scanAmd(root,_1f1).then(function(){return self.scan(root,_1f1);}).then(function(_1f4){return _1f3=_1f3.concat(self._instantiate(_1f4,_1f2,_1f1));}).otherwise(function(e){console.error("dojo/parser::parse() error",e);throw e;});_190.mixin(_1f3,p);return _1f3;}};if(1){dojo.parser=_1a3;}if(_192.parseOnLoad){_19b(100,_1a3,"parse");}return _1a3;});},"dojo/_base/url":function(){define(["./kernel"],function(dojo){var ore=new RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),ire=new RegExp("^((([^\\[:]+):)?([^@]+)@)?(\\[([^\\]]+)\\]|([^\\[:]*))(:([0-9]+))?$"),_1f5=function(){var n=null,_1f6=arguments,uri=[_1f6[0]];for(var i=1;i<_1f6.length;i++){if(!_1f6[i]){continue;}var _1f7=new _1f5(_1f6[i]+""),_1f8=new _1f5(uri[0]+"");if(_1f7.path==""&&!_1f7.scheme&&!_1f7.authority&&!_1f7.query){if(_1f7.fragment!=n){_1f8.fragment=_1f7.fragment;}_1f7=_1f8;}else{if(!_1f7.scheme){_1f7.scheme=_1f8.scheme;if(!_1f7.authority){_1f7.authority=_1f8.authority;if(_1f7.path.charAt(0)!="/"){var path=_1f8.path.substring(0,_1f8.path.lastIndexOf("/")+1)+_1f7.path;var segs=path.split("/");for(var j=0;j<segs.length;j++){if(segs[j]=="."){if(j==segs.length-1){segs[j]="";}else{segs.splice(j,1);j--;}}else{if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){if(j==(segs.length-1)){segs.splice(j,1);segs[j-1]="";}else{segs.splice(j-1,2);j-=2;}}}}_1f7.path=segs.join("/");}}}}uri=[];if(_1f7.scheme){uri.push(_1f7.scheme,":");}if(_1f7.authority){uri.push("//",_1f7.authority);}uri.push(_1f7.path);if(_1f7.query){uri.push("?",_1f7.query);}if(_1f7.fragment){uri.push("#",_1f7.fragment);}}this.uri=uri.join("");var r=this.uri.match(ore);this.scheme=r[2]||(r[1]?"":n);this.authority=r[4]||(r[3]?"":n);this.path=r[5];this.query=r[7]||(r[6]?"":n);this.fragment=r[9]||(r[8]?"":n);if(this.authority!=n){r=this.authority.match(ire);this.user=r[3]||n;this.password=r[4]||n;this.host=r[6]||r[7];this.port=r[9]||n;}};_1f5.prototype.toString=function(){return this.uri;};return dojo._Url=_1f5;});},"dojo/date/stamp":function(){define(["../_base/lang","../_base/array"],function(lang,_1f9){var _1fa={};lang.setObject("dojo.date.stamp",_1fa);_1fa.fromISOString=function(_1fb,_1fc){if(!_1fa._isoRegExp){_1fa._isoRegExp=/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;}var _1fd=_1fa._isoRegExp.exec(_1fb),_1fe=null;if(_1fd){_1fd.shift();if(_1fd[1]){_1fd[1]--;}if(_1fd[6]){_1fd[6]*=1000;}if(_1fc){_1fc=new Date(_1fc);_1f9.forEach(_1f9.map(["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],function(prop){return _1fc["get"+prop]();}),function(_1ff,_200){_1fd[_200]=_1fd[_200]||_1ff;});}_1fe=new Date(_1fd[0]||1970,_1fd[1]||0,_1fd[2]||1,_1fd[3]||0,_1fd[4]||0,_1fd[5]||0,_1fd[6]||0);if(_1fd[0]<100){_1fe.setFullYear(_1fd[0]||1970);}var _201=0,_202=_1fd[7]&&_1fd[7].charAt(0);if(_202!="Z"){_201=((_1fd[8]||0)*60)+(Number(_1fd[9])||0);if(_202!="-"){_201*=-1;}}if(_202){_201-=_1fe.getTimezoneOffset();}if(_201){_1fe.setTime(_1fe.getTime()+_201*60000);}}return _1fe;};_1fa.toISOString=function(_203,_204){var _205=function(n){return (n<10)?"0"+n:n;};_204=_204||{};var _206=[],_207=_204.zulu?"getUTC":"get",date="";if(_204.selector!="time"){var year=_203[_207+"FullYear"]();date=["0000".substr((year+"").length)+year,_205(_203[_207+"Month"]()+1),_205(_203[_207+"Date"]())].join("-");}_206.push(date);if(_204.selector!="date"){var time=[_205(_203[_207+"Hours"]()),_205(_203[_207+"Minutes"]()),_205(_203[_207+"Seconds"]())].join(":");var _208=_203[_207+"Milliseconds"]();if(_204.milliseconds){time+="."+(_208<100?"0":"")+_205(_208);}if(_204.zulu){time+="Z";}else{if(_204.selector!="time"){var _209=_203.getTimezoneOffset();var _20a=Math.abs(_209);time+=(_209>0?"-":"+")+_205(Math.floor(_20a/60))+":"+_205(_20a%60);}}_206.push(time);}return _206.join("T");};return _1fa;});},"dijit/_Widget":function(){define("dijit/_Widget",["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_20b,_20c,_20d,_20e,has,_20f,lang,_210,_211,_212,_213,_214,_215){function _216(){};function _217(_218){return function(obj,_219,_21a,_21b){if(obj&&typeof _219=="string"&&obj[_219]==_216){return obj.on(_219.substring(2).toLowerCase(),lang.hitch(_21a,_21b));}return _218.apply(_20d,arguments);};};_20b.around(_20d,"connect",_217);if(_20f.connect){_20b.around(_20f,"connect",_217);}var _21c=_20e("dijit._Widget",[_213,_214,_215],{onClick:_216,onDblClick:_216,onKeyDown:_216,onKeyPress:_216,onKeyUp:_216,onMouseDown:_216,onMouseMove:_216,onMouseOut:_216,onMouseOver:_216,onMouseLeave:_216,onMouseEnter:_216,onMouseUp:_216,constructor:function(_21d){this._toConnect={};for(var name in _21d){if(this[name]===_216){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_21d[name];delete _21d[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_216){return _20d.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_21e){_20f.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_21e);},attr:function(name,_21f){if(_20c.isDebug){var _220=arguments.callee._ach||(arguments.callee._ach={}),_221=(arguments.callee.caller||"unknown caller").toString();if(!_220[_221]){_20f.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_221,"","2.0");_220[_221]=true;}}var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_20f.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_210("[widgetId]",this.containerNode).map(_212.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_211(0,function(){var _222=["dijit/_base"];require(_222);});}return _21c;});},"dijit/_WidgetBase":function(){define("dijit/_WidgetBase",["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","./registry"],function(_223,_224,_225,_226,_227,_228,dom,_229,_22a,_22b,_22c,_22d,has,_22e,lang,on,_22f,_230,_231,win,_232,_233){has.add("dijit-legacy-requires",!_22e.isAsync);if(has("dijit-legacy-requires")){_22f(0,function(){var _234=["dijit/_base/manager"];_223(_234);});}var _235={};function _236(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _237(attr){return function(val){_229[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _238(a,b){return a===b||(a!==a&&b!==b);};return _228("dijit._WidgetBase",[_230,_232],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_237("lang"),dir:"",_setDirAttr:_237("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_226.blankGif||_223.toUrl("dojo/resources/blank.gif"),postscript:function(_239,_23a){this.create(_239,_23a);},create:function(_23b,_23c){this.srcNodeRef=dom.byId(_23c);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_23b){this.params=_23b;lang.mixin(this,_23b);}this.postMixInProperties();if(!this.id){this.id=_233.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:win.doc);this.ownerDocumentBody=win.body(this.ownerDocument);_233.add(this);this.buildRendering();var _23d;if(this.domNode){this._applyAttributes();var _23e=this.srcNodeRef;if(_23e&&_23e.parentNode&&this.domNode!==_23e){_23e.parentNode.replaceChild(this.domNode,_23e);_23d=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_23d){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var ctor=this.constructor,list=ctor._setterAttrs;if(!list){list=(ctor._setterAttrs=[]);for(var attr in this.attributeMap){list.push(attr);}var _23f=ctor.prototype;for(var _240 in _23f){if(_240 in this.attributeMap){continue;}var _241="_set"+_240.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();})+"Attr";if(_241 in _23f){list.push(_240);}}}var _242={};for(var key in this.params||{}){_242[key]=this[key];}_224.forEach(list,function(attr){if(attr in _242){}else{if(this[attr]){this.set(attr,this[attr]);}}},this);for(key in _242){this.set(key,_242[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _243=this.baseClass.split(" ");if(!this.isLeftToRight()){_243=_243.concat(_224.map(_243,function(name){return name+"Rtl";}));}_22a.add(this.domNode,_243);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_224.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_244){this._beingDestroyed=true;this.destroyDescendants(_244);this.destroy(_244);},destroy:function(_245){this._beingDestroyed=true;this.uninitialize();function _246(w){if(w.destroyRecursive){w.destroyRecursive(_245);}else{if(w.destroy){w.destroy(_245);}}};_224.forEach(this._connects,lang.hitch(this,"disconnect"));_224.forEach(this._supportingWidgets,_246);if(this.domNode){_224.forEach(_233.findWidgets(this.domNode,this.containerNode),_246);}this.destroyRendering(_245);_233.remove(this.id);this._destroyed=true;},destroyRendering:function(_247){if(this.bgIframe){this.bgIframe.destroy(_247);delete this.bgIframe;}if(this.domNode){if(_247){_229.remove(this.domNode,"widgetId");}else{_22b.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_247){_22b.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_248){_224.forEach(this.getChildren(),function(_249){if(_249.destroyRecursive){_249.destroyRecursive(_248);}});},uninitialize:function(){return false;},_setStyleAttr:function(_24a){var _24b=this.domNode;if(lang.isObject(_24a)){_22d.set(_24b,_24a);}else{if(_24b.style.cssText){_24b.style.cssText+="; "+_24a;}else{_24b.style.cssText=_24a;}}this._set("style",_24a);},_attrToDom:function(attr,_24c,_24d){_24d=arguments.length>=3?_24d:this.attributeMap[attr];_224.forEach(lang.isArray(_24d)?_24d:[_24d],function(_24e){var _24f=this[_24e.node||_24e||"domNode"];var type=_24e.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_24c)){_24c=lang.hitch(this,_24c);}var _250=_24e.attribute?_24e.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_24f.tagName){_229.set(_24f,_250,_24c);}else{_24f.set(_250,_24c);}break;case "innerText":_24f.innerHTML="";_24f.appendChild(this.ownerDocument.createTextNode(_24c));break;case "innerHTML":_24f.innerHTML=_24c;break;case "class":_22a.replace(_24f,_24c,this[attr]);break;}},this);},get:function(name){var _251=this._getAttrNames(name);return this[_251.g]?this[_251.g]():this[name];},set:function(name,_252){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _253=this._getAttrNames(name),_254=this[_253.s];if(lang.isFunction(_254)){var _255=_254.apply(this,Array.prototype.slice.call(arguments,1));}else{var _256=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_256].tagName,_257=_235[tag]||(_235[tag]=_236(this[_256])),map=name in this.attributeMap?this.attributeMap[name]:_253.s in this?this[_253.s]:((_253.l in _257&&typeof _252!="function")||/^aria-|^data-|^role$/.test(name))?_256:null;if(map!=null){this._attrToDom(name,_252,map);}this._set(name,_252);}return _255||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_258){var _259=this[name];this[name]=_258;if(this._created&&!_238(_258,_259)){if(this._watchCallbacks){this._watchCallbacks(name,_259,_258);}this.emit("attrmodified-"+name,{detail:{prevValue:_259,newValue:_258}});}},emit:function(type,_25a,_25b){_25a=_25a||{};if(_25a.bubbles===undefined){_25a.bubbles=true;}if(_25a.cancelable===undefined){_25a.cancelable=true;}if(!_25a.detail){_25a.detail={};}_25a.detail.widget=this;var ret,_25c=this["on"+type];if(_25c){ret=_25c.apply(this,_25b?_25b:[_25a]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_25a);}return ret;},on:function(type,func){var _25d=this._onMap(type);if(_25d){return _225.after(this,_25d,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_233.findWidgets(this.containerNode):[];},getParent:function(){return _233.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_25e,_25f){return this.own(_227.connect(obj,_25e,this,_25f))[0];},disconnect:function(_260){_260.remove();},subscribe:function(t,_261){return this.own(_231.subscribe(t,lang.hitch(this,_261)))[0];},unsubscribe:function(_262){_262.remove();},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_22c.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_22d.get(this.domNode,"display")!="none");},placeAt:function(_263,_264){var _265=!_263.tagName&&_233.byId(_263);if(_265&&_265.addChild&&(!_264||typeof _264==="number")){_265.addChild(this,_264);}else{var ref=_265?(_265.containerNode&&!/after|before|replace/.test(_264||"")?_265.containerNode:_265.domNode):dom.byId(_263,this.ownerDocument);_22b.place(this.domNode,ref,_264);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},getTextDir:function(text,_266){return _266;},applyTextDir:function(){},defer:function(fcn,_267){var _268=setTimeout(lang.hitch(this,function(){if(!_268){return;}_268=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_267||0);return {remove:function(){if(_268){clearTimeout(_268);_268=null;}return null;}};}});});},"dijit/Destroyable":function(){define("dijit/Destroyable",["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_269,_26a,_26b){return _26b("dijit.Destroyable",null,{destroy:function(_26c){this._destroyed=true;},own:function(){_269.forEach(arguments,function(_26d){var _26e="destroyRecursive" in _26d?"destroyRecursive":"destroy" in _26d?"destroy":"remove";var odh=_26a.before(this,"destroy",function(_26f){_26d[_26e](_26f);});var hdh=_26a.after(_26d,_26e,function(){odh.remove();hdh.remove();},true);},this);return arguments;}});});},"dijit/_OnDijitClickMixin":function(){define("dijit/_OnDijitClickMixin",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window","./a11yclick"],function(on,_270,keys,_271,has,_272,win,_273){var ret=_271("dijit._OnDijitClickMixin",null,{connect:function(obj,_274,_275){return this.inherited(arguments,[obj,_274=="ondijitclick"?_273:_274,_275]);}});ret.a11yclick=_273;return ret;});},"dijit/a11yclick":function(){define("dijit/a11yclick",["dojo/_base/array","dojo/_base/declare","dojo/has","dojo/keys","dojo/on"],function(_276,_277,has,keys,on){function _278(node){do{if(node.dojoClick){return true;}}while(node=node.parentNode);};function _279(e){return (e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey&&!/input|button/i.test(e.target.nodeName)&&_278(e.target);};var _27a;on(document,"keydown",function(e){if(_279(e)){_27a=e.target;e.preventDefault();}});on(document,"keyup",function(e){if(_279(e)&&e.target==_27a){_27a=null;on.emit(e.target,"click",{cancelable:true,bubbles:true});}});if(has("touch")){var _27b;on(document,"touchend",function(e){var _27c=e.target;if(_278(_27c)){var _27d=on.once(_27c,"click",function(e){if(_27b){clearTimeout(_27b);_27b=null;}});if(_27b){clearTimeout(_27b);}_27b=setTimeout(function(){_27b=null;_27d.remove();on.emit(_27c,"click",{cancelable:true,bubbles:true});},600);}});}return function(node,_27e){node.dojoClick=true;return on(node,"click",_27e);};});},"dijit/_FocusMixin":function(){define("dijit/_FocusMixin",["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_27f,_280,_281,lang){lang.extend(_280,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _281("dijit._FocusMixin",null,{_focusManager:_27f});});},"dijit/_TemplatedMixin":function(){define("dijit/_TemplatedMixin",["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/sniff","dojo/_base/unload"],function(lang,_282,_283,_284,_285,_286,_287,_288,has,_289){var _28a=_287("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){this._attachPoints=[];this._attachEvents=[];},_stringRepl:function(tmpl){var _28b=this.declaredClass,_28c=this;return _284.substitute(tmpl,this,function(_28d,key){if(key.charAt(0)=="!"){_28d=lang.getObject(key.substr(1),false,_28c);}if(typeof _28d=="undefined"){throw new Error(_28b+" template:"+key);}if(_28d==null){return "";}return key.charAt(0)=="!"?_28d:_28d.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this.templateString){this.templateString=_285(this.templatePath,{sanitize:true});}var _28e=_28a.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_28e)){node=_288.toDom(this._stringRepl(_28e),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_28e);}}else{node=_28e.cloneNode(true);}this.domNode=node;this.inherited(arguments);this._attachTemplateNodes(node,function(n,p){return n.getAttribute(p);});this._beforeFillContent();this._fillContent(this.srcNodeRef);},_beforeFillContent:function(){},_fillContent:function(_28f){var dest=this.containerNode;if(_28f&&dest){while(_28f.hasChildNodes()){dest.appendChild(_28f.firstChild);}}},_attachTemplateNodes:function(_290,_291){var _292=lang.isArray(_290)?_290:(_290.all||_290.getElementsByTagName("*"));var x=lang.isArray(_290)?0:-1;for(;x<0||_292[x];x++){var _293=(x==-1)?_290:_292[x];if(this.widgetsInTemplate&&(_291(_293,"dojoType")||_291(_293,"data-dojo-type"))){continue;}var _294=_291(_293,"dojoAttachPoint")||_291(_293,"data-dojo-attach-point");if(_294){var _295,_296=_294.split(/\s*,\s*/);while((_295=_296.shift())){if(lang.isArray(this[_295])){this[_295].push(_293);}else{this[_295]=_293;}this._attachPoints.push(_295);}}var _297=_291(_293,"dojoAttachEvent")||_291(_293,"data-dojo-attach-event");if(_297){var _298,_299=_297.split(/\s*,\s*/);var trim=lang.trim;while((_298=_299.shift())){if(_298){var _29a=null;if(_298.indexOf(":")!=-1){var _29b=_298.split(":");_298=trim(_29b[0]);_29a=trim(_29b[1]);}else{_298=trim(_298);}if(!_29a){_29a=_298;}this._attachEvents.push(this.connect(_293,_282[_298]||_298,_29a));}}}}},destroyRendering:function(){_286.forEach(this._attachPoints,function(_29c){delete this[_29c];},this);this._attachPoints=[];_286.forEach(this._attachEvents,this.disconnect,this);this._attachEvents=[];this.inherited(arguments);}});_28a._templateCache={};_28a.getCachedTemplate=function(_29d,_29e,doc){var _29f=_28a._templateCache;var key=_29d;var _2a0=_29f[key];if(_2a0){try{if(!_2a0.ownerDocument||_2a0.ownerDocument==(doc||document)){return _2a0;}}catch(e){}_288.destroy(_2a0);}_29d=_284.trim(_29d);if(_29e||_29d.match(/\$\{([^\}]+)\}/g)){return (_29f[key]=_29d);}else{var node=_288.toDom(_29d,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_29d);}return (_29f[key]=node);}};if(has("ie")){_289.addOnWindowUnload(function(){var _2a1=_28a._templateCache;for(var key in _2a1){var _2a2=_2a1[key];if(typeof _2a2=="object"){_288.destroy(_2a2);}delete _2a1[key];}});}lang.extend(_283,{dojoAttachEvent:"",dojoAttachPoint:""});return _28a;});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_2a3,dom,on,has,_2a4,_2a5,win){var _2a6=has("touch");var ios4=false;if(has("ios")){var ua=navigator.userAgent;var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));ios4=os<5;}var _2a7;function _2a8(_2a9,_2aa){if(_2a6){return function(node,_2ab){var _2ac=on(node,_2aa,_2ab),_2ad=on(node,_2a9,function(evt){if(!_2a7||(new Date()).getTime()>_2a7+1000){_2ab.call(this,evt);}});return {remove:function(){_2ac.remove();_2ad.remove();}};};}else{return function(node,_2ae){return on(node,_2a9,_2ae);};}};var _2af,_2b0;if(_2a6){_2a5(function(){_2b0=win.body();win.doc.addEventListener("touchstart",function(evt){_2a7=(new Date()).getTime();var _2b1=_2b0;_2b0=evt.target;on.emit(_2b1,"dojotouchout",{target:_2b1,relatedTarget:_2b0,bubbles:true});on.emit(_2b0,"dojotouchover",{target:_2b0,relatedTarget:_2b1,bubbles:true});},true);on(win.doc,"touchmove",function(evt){_2a7=(new Date()).getTime();var _2b2=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_2b2&&_2b0!==_2b2){on.emit(_2b0,"dojotouchout",{target:_2b0,relatedTarget:_2b2,bubbles:true});on.emit(_2b2,"dojotouchover",{target:_2b2,relatedTarget:_2b0,bubbles:true});_2b0=_2b2;}});});_2af=function(node,_2b3){return on(win.doc,"touchmove",function(evt){if(node===win.doc||dom.isDescendant(_2b0,node)){evt.target=_2b0;_2b3.call(this,evt);}});};}var _2b4={press:_2a8("mousedown","touchstart"),move:_2a8("mousemove",_2af),release:_2a8("mouseup","touchend"),cancel:_2a8(_2a4.leave,"touchcancel"),over:_2a8("mouseover","dojotouchover"),out:_2a8("mouseout","dojotouchout"),enter:_2a4._eventHandler(_2a8("mouseover","dojotouchover")),leave:_2a4._eventHandler(_2a8("mouseout","dojotouchout"))};1&&(dojo.touch=_2b4);return _2b4;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_2b5,lang){var _2b6={};lang.setObject("dojo.string",_2b6);_2b6.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_2b6.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_2b6.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_2b6.substitute=function(_2b7,map,_2b8,_2b9){_2b9=_2b9||_2b5.global;_2b8=_2b8?lang.hitch(_2b9,_2b8):function(v){return v;};return _2b7.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_2ba,key,_2bb){var _2bc=lang.getObject(key,false,map);if(_2bb){_2bc=lang.getObject(_2bb,false,_2b9).call(_2b9,_2bc,key);}return _2b8(_2bc,key).toString();});};_2b6.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _2b6;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dijit/_Container":function(){define("dijit/_Container",["dojo/_base/array","dojo/_base/declare","dojo/dom-construct"],function(_2bd,_2be,_2bf){return _2be("dijit._Container",null,{buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}},addChild:function(_2c0,_2c1){var _2c2=this.containerNode;if(_2c1&&typeof _2c1=="number"){var _2c3=this.getChildren();if(_2c3&&_2c3.length>=_2c1){_2c2=_2c3[_2c1-1].domNode;_2c1="after";}}_2bf.place(_2c0.domNode,_2c2,_2c1);if(this._started&&!_2c0._started){_2c0.startup();}},removeChild:function(_2c4){if(typeof _2c4=="number"){_2c4=this.getChildren()[_2c4];}if(_2c4){var node=_2c4.domNode;if(node&&node.parentNode){node.parentNode.removeChild(node);}}},hasChildren:function(){return this.getChildren().length>0;},_getSiblingOfChild:function(_2c5,dir){var _2c6=this.getChildren(),idx=_2bd.indexOf(this.getChildren(),_2c5);return _2c6[idx+dir];},getIndexOfChild:function(_2c7){return _2bd.indexOf(this.getChildren(),_2c7);}});});},"dijit/layout/_LayoutWidget":function(){define(["dojo/_base/lang","../_Widget","../_Container","../_Contained","../Viewport","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(lang,_2c8,_2c9,_2ca,_2cb,_2cc,_2cd,_2ce,_2cf){return _2cc("dijit.layout._LayoutWidget",[_2c8,_2c9,_2ca],{baseClass:"dijitLayoutContainer",isLayoutContainer:true,buildRendering:function(){this.inherited(arguments);_2cd.add(this.domNode,"dijitContainer");},startup:function(){if(this._started){return;}this.inherited(arguments);var _2d0=this.getParent&&this.getParent();if(!(_2d0&&_2d0.isLayoutContainer)){this.resize();this.own(_2cb.on("resize",lang.hitch(this,"resize")));}},resize:function(_2d1,_2d2){var node=this.domNode;if(_2d1){_2ce.setMarginBox(node,_2d1);}var mb=_2d2||{};lang.mixin(mb,_2d1||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_2ce.getMarginBox(node),mb);}var cs=_2cf.getComputedStyle(node);var me=_2ce.getMarginExtents(node,cs);var be=_2ce.getBorderExtents(node,cs);var bb=(this._borderBox={w:mb.w-(me.w+be.w),h:mb.h-(me.h+be.h)});var pe=_2ce.getPadExtents(node,cs);this._contentBox={l:_2cf.toPixelValue(node,cs.paddingLeft),t:_2cf.toPixelValue(node,cs.paddingTop),w:bb.w-pe.w,h:bb.h-pe.h};this.layout();},layout:function(){},_setupChild:function(_2d3){var cls=this.baseClass+"-child "+(_2d3.baseClass?this.baseClass+"-"+_2d3.baseClass:"");_2cd.add(_2d3.domNode,cls);},addChild:function(_2d4,_2d5){this.inherited(arguments);if(this._started){this._setupChild(_2d4);}},removeChild:function(_2d6){var cls=this.baseClass+"-child"+(_2d6.baseClass?" "+this.baseClass+"-"+_2d6.baseClass:"");_2cd.remove(_2d6.domNode,cls);this.inherited(arguments);}});});},"dijit/_Contained":function(){define("dijit/_Contained",["dojo/_base/declare","./registry"],function(_2d7,_2d8){return _2d7("dijit._Contained",null,{_getSibling:function(_2d9){var node=this.domNode;do{node=node[_2d9+"Sibling"];}while(node&&node.nodeType!=1);return node&&_2d8.byNode(node);},getPreviousSibling:function(){return this._getSibling("previous");},getNextSibling:function(){return this._getSibling("next");},getIndexInParent:function(){var p=this.getParent();if(!p||!p.getIndexOfChild){return -1;}return p.getIndexOfChild(this);}});});},"dijit/form/_FormWidget":function(){define(["dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/ready","../_Widget","../_CssStateMixin","../_TemplatedMixin","./_FormWidgetMixin"],function(_2da,has,_2db,_2dc,_2dd,_2de,_2df,_2e0){if(has("dijit-legacy-requires")){_2dc(0,function(){var _2e1=["dijit/form/_FormValueWidget"];require(_2e1);});}return _2da("dijit.form._FormWidget",[_2dd,_2df,_2de,_2e0],{setDisabled:function(_2e2){_2db.deprecated("setDisabled("+_2e2+") is deprecated. Use set('disabled',"+_2e2+") instead.","","2.0");this.set("disabled",_2e2);},setValue:function(_2e3){_2db.deprecated("dijit.form._FormWidget:setValue("+_2e3+") is deprecated.  Use set('value',"+_2e3+") instead.","","2.0");this.set("value",_2e3);},getValue:function(){_2db.deprecated(this.declaredClass+"::getValue() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},postMixInProperties:function(){this.nameAttrSetting=this.name?("name=\""+this.name.replace(/"/g,"&quot;")+"\""):"";this.inherited(arguments);},_setTypeAttr:null});});},"dijit/_CssStateMixin":function(){define("dijit/_CssStateMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/window","./registry"],function(_2e4,_2e5,dom,_2e6,has,lang,on,_2e7,win,_2e8){var _2e9=_2e5("dijit._CssStateMixin",[],{cssStateNodes:{},hovering:false,active:false,_applyAttributes:function(){this.inherited(arguments);_2e4.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){this.watch(attr,lang.hitch(this,"_setStateClass"));},this);for(var ap in this.cssStateNodes){this._trackMouseState(this[ap],this.cssStateNodes[ap]);}this._trackMouseState(this.domNode,this.baseClass);this._setStateClass();},_cssMouseEvent:function(_2ea){if(!this.disabled){switch(_2ea.type){case "mouseover":this._set("hovering",true);this._set("active",this._mouseDown);break;case "mouseout":this._set("hovering",false);this._set("active",false);break;case "mousedown":case "touchstart":this._set("active",true);break;case "mouseup":case "touchend":this._set("active",false);break;}}},_setStateClass:function(){var _2eb=this.baseClass.split(" ");function _2ec(_2ed){_2eb=_2eb.concat(_2e4.map(_2eb,function(c){return c+_2ed;}),"dijit"+_2ed);};if(!this.isLeftToRight()){_2ec("Rtl");}var _2ee=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");if(this.checked){_2ec(_2ee);}if(this.state){_2ec(this.state);}if(this.selected){_2ec("Selected");}if(this._opened){_2ec("Opened");}if(this.disabled){_2ec("Disabled");}else{if(this.readOnly){_2ec("ReadOnly");}else{if(this.active){_2ec("Active");}else{if(this.hovering){_2ec("Hover");}}}}if(this.focused){_2ec("Focused");}var tn=this.stateNode||this.domNode,_2ef={};_2e4.forEach(tn.className.split(" "),function(c){_2ef[c]=true;});if("_stateClasses" in this){_2e4.forEach(this._stateClasses,function(c){delete _2ef[c];});}_2e4.forEach(_2eb,function(c){_2ef[c]=true;});var _2f0=[];for(var c in _2ef){_2f0.push(c);}tn.className=_2f0.join(" ");this._stateClasses=_2eb;},_subnodeCssMouseEvent:function(node,_2f1,evt){if(this.disabled||this.readOnly){return;}function _2f2(_2f3){_2e6.toggle(node,_2f1+"Hover",_2f3);};function _2f4(_2f5){_2e6.toggle(node,_2f1+"Active",_2f5);};function _2f6(_2f7){_2e6.toggle(node,_2f1+"Focused",_2f7);};switch(evt.type){case "mouseover":_2f2(true);break;case "mouseout":_2f2(false);_2f4(false);break;case "mousedown":case "touchstart":_2f4(true);break;case "mouseup":case "touchend":_2f4(false);break;case "focus":case "focusin":_2f6(true);break;case "blur":case "focusout":_2f6(false);break;}},_trackMouseState:function(node,_2f8){node._cssState=_2f8;}});_2e7(function(){function _2f9(evt){if(!dom.isDescendant(evt.relatedTarget,evt.target)){for(var node=evt.target;node&&node!=evt.relatedTarget;node=node.parentNode){if(node._cssState){var _2fa=_2e8.getEnclosingWidget(node);if(_2fa){if(node==_2fa.domNode){_2fa._cssMouseEvent(evt);}else{_2fa._subnodeCssMouseEvent(node,node._cssState,evt);}}}}}};function _2fb(evt){evt.target=evt.srcElement;_2f9(evt);};var body=win.body(),_2fc=(has("touch")?[]:["mouseover","mouseout"]).concat(["mousedown","touchstart","mouseup","touchend"]);_2e4.forEach(_2fc,function(type){if(body.addEventListener){body.addEventListener(type,_2f9,true);}else{body.attachEvent("on"+type,_2fb);}});on(body,"focusin, focusout",function(evt){var node=evt.target;if(node._cssState&&!node.getAttribute("widgetId")){var _2fd=_2e8.getEnclosingWidget(node);_2fd._subnodeCssMouseEvent(node,node._cssState,evt);}});});return _2e9;});},"dijit/form/_FormWidgetMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/sniff","dojo/window","../a11y"],function(_2fe,_2ff,_300,_301,lang,_302,has,_303,a11y){return _2ff("dijit.form._FormWidgetMixin",null,{name:"",alt:"",value:"",type:"text","aria-label":"focusNode",tabIndex:"0",_setTabIndexAttr:"focusNode",disabled:false,intermediateChanges:false,scrollOnFocus:true,_setIdAttr:"focusNode",_setDisabledAttr:function(_304){this._set("disabled",_304);_300.set(this.focusNode,"disabled",_304);if(this.valueNode){_300.set(this.valueNode,"disabled",_304);}this.focusNode.setAttribute("aria-disabled",_304?"true":"false");if(_304){this._set("hovering",false);this._set("active",false);var _305="tabIndex" in this.attributeMap?this.attributeMap.tabIndex:("_setTabIndexAttr" in this)?this._setTabIndexAttr:"focusNode";_2fe.forEach(lang.isArray(_305)?_305:[_305],function(_306){var node=this[_306];if(has("webkit")||a11y.hasDefaultTabStop(node)){node.setAttribute("tabIndex","-1");}else{node.removeAttribute("tabIndex");}},this);}else{if(this.tabIndex!=""){this.set("tabIndex",this.tabIndex);}}},_onFocus:function(by){if(by=="mouse"&&this.isFocusable()){var _307=this.connect(this.focusNode,"onfocus",function(){this.disconnect(_308);this.disconnect(_307);});var _308=this.connect(this.ownerDocumentBody,"onmouseup",function(){this.disconnect(_308);this.disconnect(_307);if(this.focused){this.focus();}});}if(this.scrollOnFocus){this.defer(function(){_303.scrollIntoView(this.domNode);});}this.inherited(arguments);},isFocusable:function(){return !this.disabled&&this.focusNode&&(_301.get(this.domNode,"display")!="none");},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},compare:function(val1,val2){if(typeof val1=="number"&&typeof val2=="number"){return (isNaN(val1)&&isNaN(val2))?0:val1-val2;}else{if(val1>val2){return 1;}else{if(val1<val2){return -1;}else{return 0;}}}},onChange:function(){},_onChangeActive:false,_handleOnChange:function(_309,_30a){if(this._lastValueReported==undefined&&(_30a===null||!this._onChangeActive)){this._resetValue=this._lastValueReported=_309;}this._pendingOnChange=this._pendingOnChange||(typeof _309!=typeof this._lastValueReported)||(this.compare(_309,this._lastValueReported)!=0);if((this.intermediateChanges||_30a||_30a===undefined)&&this._pendingOnChange){this._lastValueReported=_309;this._pendingOnChange=false;if(this._onChangeActive){if(this._onChangeHandle){this._onChangeHandle.remove();}this._onChangeHandle=this.defer(function(){this._onChangeHandle=null;this.onChange(_309);});}}},create:function(){this.inherited(arguments);this._onChangeActive=true;},destroy:function(){if(this._onChangeHandle){this._onChangeHandle.remove();this.onChange(this._lastValueReported);}this.inherited(arguments);}});});},"dijit/form/_FormValueWidget":function(){define(["dojo/_base/declare","dojo/sniff","./_FormWidget","./_FormValueMixin"],function(_30b,has,_30c,_30d){return _30b("dijit.form._FormValueWidget",[_30c,_30d],{_layoutHackIE7:function(){if(has("ie")==7){var _30e=this.domNode;var _30f=_30e.parentNode;var _310=_30e.firstChild||_30e;var _311=_310.style.filter;var _312=this;while(_30f&&_30f.clientHeight==0){(function ping(){var _313=_312.connect(_30f,"onscroll",function(){_312.disconnect(_313);_310.style.filter=(new Date()).getMilliseconds();_312.defer(function(){_310.style.filter=_311;});});})();_30f=_30f.parentNode;}}}});});},"dijit/form/_FormValueMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/sniff","./_FormWidgetMixin"],function(_314,_315,keys,has,_316){return _314("dijit.form._FormValueMixin",_316,{readOnly:false,_setReadOnlyAttr:function(_317){_315.set(this.focusNode,"readOnly",_317);this._set("readOnly",_317);},postCreate:function(){this.inherited(arguments);if(has("ie")){this.connect(this.focusNode||this.domNode,"onkeydown",this._onKeyDown);}if(this._resetValue===undefined){this._lastValueReported=this._resetValue=this.value;}},_setValueAttr:function(_318,_319){this._handleOnChange(_318,_319);},_handleOnChange:function(_31a,_31b){this._set("value",_31a);this.inherited(arguments);},undo:function(){this._setValueAttr(this._lastValueReported,false);},reset:function(){this._hasBeenBlurred=false;this._setValueAttr(this._resetValue,true);},_onKeyDown:function(e){if(e.keyCode==keys.ESCAPE&&!(e.ctrlKey||e.altKey||e.metaKey)){if(has("ie")<9||(has("ie")&&has("quirks"))){e.preventDefault();var node=e.srcElement,te=node.ownerDocument.createEventObject();te.keyCode=keys.ESCAPE;te.shiftKey=e.shiftKey;node.fireEvent("onkeypress",te);}}}});});}}});define("dijit/dijit",["./main","./_base","dojo/parser","./_Widget","./_TemplatedMixin","./_Container","./layout/_LayoutWidget","./form/_FormWidget","./form/_FormValueWidget"],function(_31c){return _31c;});