# WL#7796 - WAIT_FOR_EXECUTED_GTID_SET
#
# This test waits for a transaction that has not been committed, sleeps
# for a second and verifies that the wait function is still waiting. Then
# executes a statement which fulfils the waiting condition. That would
# verify that the wait function does not return immediately.
#
# To run this test you need to define:
#  $gtid_not_committed_wait_set           The set used to check the functions
#                                         wait for transaction not committed
#
#  $gtid_committed_and_not_committed_set  The set used to verify the function
#                                         waits for a set of committed and not
#                                         committed transactions

if ($gtid_not_committed_wait_set == '')
{
  --die ERROR IN TEST: the "gtid_not_committed_wait_set" variable must be set
}

if ($gtid_committed_and_not_committed_set == '')
{
  --die ERROR IN TEST: the "gtid_committed_and_not_committed_set" variable must be set
}

--source include/have_log_bin.inc
--source include/have_gtid.inc
--source include/master-slave.inc

--connection slave
--let $master_uuid= query_get_value(select SOURCE_UUID from performance_schema.replication_connection_status WHERE service_state = 'ON', SOURCE_UUID, 1)

--let $gtid_not_committed_wait_set= $master_uuid:$gtid_not_committed_wait_set
--let $gtid_committed_and_not_committed_set= $master_uuid:$gtid_committed_and_not_committed_set

--connection master

CREATE TABLE t1 (c1 INT NOT NULL PRIMARY KEY) ENGINE=InnoDB;
INSERT INTO t1 VALUES (1);

--connection master1

--let $connection_id= `SELECT CONNECTION_ID()`
--send
--replace_result $master_uuid MASTER_UUID
--eval SELECT WAIT_FOR_EXECUTED_GTID_SET('$gtid_not_committed_wait_set', 10000)
sleep 2;

--connection default
# Now executing the next transaction.
INSERT INTO t1 VALUES (2);
# Checking the waiting thread condition.
--echo The connection master1 should be waiting for the WAIT_FOR_EXECUTED_GTID_SET here
--let $wait_condition=SELECT COUNT(*)=1 FROM INFORMATION_SCHEMA.PROCESSLIST WHERE Id='$connection_id' AND Info Like 'SELECT WAIT_FOR_EXECUTED_GTID_SET%'
--source include/wait_condition.inc

INSERT INTO t1 VALUES (3);

--connection master1
--replace_result $master_uuid MASTER_UUID
--reap

# This part of the test checks for the validity of the
# wait_for_executed_gtid_set function which has a set of GTID which is
# committed as well as uncommitted. It should wait for the entire set to be
# executed.

--connection master1

--send
--replace_result $master_uuid MASTER_UUID
--eval SELECT WAIT_FOR_EXECUTED_GTID_SET('$gtid_committed_and_not_committed_set', 10000)

--connection default
--echo The connection master1 should be waiting for the WAIT_FOR_EXECUTED_GTID_SET here
--let $wait_condition=SELECT COUNT(*)=1 FROM INFORMATION_SCHEMA.PROCESSLIST WHERE Id='$connection_id' AND Info Like 'SELECT WAIT_FOR_EXECUTED_GTID_SET%'
--source include/wait_condition.inc

INSERT INTO t1 VALUES (4);
DROP TABLE t1;

--connection master1
--replace_result $master_uuid MASTER_UUID
--reap

--let $wait_for_gtid_executed_set=1
--source include/sync_slave_sql_with_master.inc

--connection master
--source include/rpl_end.inc
