/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.InterpolatorException;

@Named
@Singleton
public class DefaultInterpolator
implements Interpolator {
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private static final String MARKER = "$__";

    public void interpolate(Map<String, String> map, Function<String, String> callback, BiFunction<String, String, String> postprocessor, boolean defaultsToEmpty) {
        HashMap<String, String> org = new HashMap<String, String>(map);
        for (String name : map.keySet()) {
            map.compute(name, (k, value) -> this.interpolate((String)value, name, null, v -> {
                String r = (String)org.get(v);
                if (r == null && callback != null) {
                    r = (String)callback.apply((String)v);
                }
                return r;
            }, postprocessor, defaultsToEmpty));
        }
    }

    public String interpolate(String val, Function<String, String> callback, BiFunction<String, String, String> postprocessor, boolean defaultsToEmpty) {
        return this.interpolate(val, null, null, callback, postprocessor, defaultsToEmpty);
    }

    @Nullable
    public String interpolate(@Nullable String val, @Nullable String currentKey, @Nullable Set<String> cycleMap, @Nullable Function<String, String> callback, @Nullable BiFunction<String, String, String> postprocessor, boolean defaultsToEmpty) {
        return DefaultInterpolator.substVars(val, currentKey, cycleMap, null, callback, postprocessor, defaultsToEmpty);
    }

    public void performSubstitution(Map<String, String> properties, Function<String, String> callback) {
        this.performSubstitution(properties, callback, true);
    }

    public void performSubstitution(Map<String, String> properties, Function<String, String> callback, boolean defaultsToEmptyString) {
        HashMap<String, String> org = new HashMap<String, String>(properties);
        for (String name : properties.keySet()) {
            properties.compute(name, (k, value) -> DefaultInterpolator.substVars(value, name, null, org, callback, null, defaultsToEmptyString));
        }
    }

    public String substVars(String val, String currentKey, Set<String> cycleMap, Map<String, String> configProps) {
        return this.substVars(val, currentKey, cycleMap, configProps, null);
    }

    public String substVars(String val, String currentKey, Set<String> cycleMap, Map<String, String> configProps, Function<String, String> callback) {
        return DefaultInterpolator.substVars(val, currentKey, cycleMap, configProps, callback, null, false);
    }

    public static String substVars(String val, String currentKey, Set<String> cycleMap, Map<String, String> configProps, Function<String, String> callback, BiFunction<String, String, String> postprocessor, boolean defaultsToEmptyString) {
        return DefaultInterpolator.unescape(DefaultInterpolator.doSubstVars(val, currentKey, cycleMap, configProps, callback, postprocessor, defaultsToEmptyString));
    }

    private static String doSubstVars(String val, String currentKey, Set<String> cycleMap, Map<String, String> configProps, Function<String, String> callback, BiFunction<String, String, String> postprocessor, boolean defaultsToEmptyString) {
        String variable;
        int startDelim;
        if (val == null || ((String)val).isEmpty()) {
            return val;
        }
        if (cycleMap == null) {
            cycleMap = new HashSet<String>();
        }
        if (currentKey != null) {
            cycleMap.add(currentKey);
        }
        int stopDelim = -1;
        do {
            int idx;
            stopDelim = ((String)val).indexOf(DELIM_STOP, stopDelim + 1);
            while (stopDelim > 0 && ((String)val).charAt(stopDelim - 1) == '\\') {
                stopDelim = ((String)val).indexOf(DELIM_STOP, stopDelim + 1);
            }
            startDelim = ((String)val).indexOf(DELIM_START);
            while (stopDelim >= 0 && (idx = ((String)val).indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim >= 0 && stopDelim >= 0 && stopDelim < startDelim + DELIM_START.length());
        if (startDelim < 0 || stopDelim < 0) {
            cycleMap.remove(currentKey);
            return val;
        }
        String org = variable = ((String)val).substring(startDelim + DELIM_START.length(), stopDelim);
        String substValue = DefaultInterpolator.processSubstitution(variable, org, cycleMap, configProps, callback, postprocessor, defaultsToEmptyString);
        val = ((String)val).substring(0, startDelim) + substValue + ((String)val).substring(stopDelim + DELIM_STOP.length());
        val = DefaultInterpolator.doSubstVars((String)val, currentKey, cycleMap, configProps, callback, postprocessor, defaultsToEmptyString);
        cycleMap.remove(currentKey);
        return val;
    }

    private static String processSubstitution(String variable, String org, Set<String> cycleMap, Map<String, String> configProps, Function<String, String> callback, BiFunction<String, String, String> postprocessor, boolean defaultsToEmptyString) {
        int startIdx = 0;
        String currentVar = variable;
        Object substValue = null;
        while (startIdx < variable.length()) {
            int idx;
            int idx1 = variable.indexOf(":-", startIdx);
            int idx2 = variable.indexOf(":+", startIdx);
            int n = idx1 >= 0 ? (idx2 >= 0 ? Math.min(idx1, idx2) : idx1) : (idx = idx2);
            if (idx < 0) {
                if (substValue != null) break;
                currentVar = variable.substring(startIdx);
                substValue = DefaultInterpolator.resolveVariable(currentVar, cycleMap, configProps, callback, postprocessor, defaultsToEmptyString);
                break;
            }
            String varPart = variable.substring(startIdx, idx);
            if (substValue == null) {
                substValue = DefaultInterpolator.resolveVariable(varPart, cycleMap, configProps, callback, postprocessor, defaultsToEmptyString);
            }
            int nextIdx1 = variable.indexOf(":-", idx + 2);
            int nextIdx2 = variable.indexOf(":+", idx + 2);
            int nextIdx = nextIdx1 >= 0 ? (nextIdx2 >= 0 ? Math.min(nextIdx1, nextIdx2) : nextIdx1) : nextIdx2;
            String op = variable.substring(idx, idx + 2);
            String opValue = variable.substring(idx + 2, nextIdx >= 0 ? nextIdx : variable.length());
            String processedOpValue = DefaultInterpolator.doSubstVars(opValue, org, cycleMap, configProps, callback, postprocessor, defaultsToEmptyString);
            if (":+".equals(op)) {
                if (substValue != null && !((String)substValue).isEmpty()) {
                    substValue = processedOpValue;
                }
            } else if (":-".equals(op)) {
                if (substValue == null || ((String)substValue).isEmpty()) {
                    substValue = processedOpValue;
                }
            } else {
                throw new InterpolatorException("Bad substitution operator in: ${" + org + DELIM_STOP);
            }
            startIdx = nextIdx >= 0 ? nextIdx : variable.length();
        }
        if (substValue == null) {
            substValue = defaultsToEmptyString ? "" : "$__{" + variable + DELIM_STOP;
        }
        return substValue;
    }

    private static String resolveVariable(String variable, Set<String> cycleMap, Map<String, String> configProps, Function<String, String> callback, BiFunction<String, String, String> postprocessor, boolean defaultsToEmptyString) {
        if (!cycleMap.add(variable)) {
            throw new InterpolatorException("recursive variable reference: " + variable);
        }
        String substValue = null;
        if (configProps != null) {
            substValue = configProps.get(variable);
        }
        if (substValue == null && !variable.isEmpty() && callback != null) {
            String s1 = callback.apply(variable);
            String s2 = DefaultInterpolator.doSubstVars(s1, variable, cycleMap, configProps, callback, postprocessor, defaultsToEmptyString);
            substValue = postprocessor != null ? postprocessor.apply(variable, s2) : s2;
        }
        cycleMap.remove(variable);
        return substValue;
    }

    @Nullable
    public static String escape(@Nullable String val) {
        if (val == null || val.isEmpty()) {
            return val;
        }
        return val.replace("$", MARKER);
    }

    @Nullable
    public static String unescape(@Nullable String val) {
        if (val == null || ((String)val).isEmpty()) {
            return val;
        }
        val = ((String)val).replace(MARKER, "$");
        int escape = ((String)val).indexOf(92);
        while (escape >= 0 && escape < ((String)val).length() - 1) {
            char c = ((String)val).charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val = ((String)val).substring(0, escape) + ((String)val).substring(escape + 1);
            }
            escape = ((String)val).indexOf(92, escape + 1);
        }
        return val;
    }
}

