/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.ToolchainsBuilder;
import org.apache.maven.api.services.ToolchainsBuilderException;
import org.apache.maven.api.services.ToolchainsBuilderRequest;
import org.apache.maven.api.services.ToolchainsBuilderResult;
import org.apache.maven.api.services.xml.ToolchainsXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.internal.impl.DefaultBuilderProblem;
import org.apache.maven.internal.impl.DefaultToolchainsXmlFactory;
import org.apache.maven.internal.impl.model.DefaultInterpolator;
import org.apache.maven.toolchain.v4.MavenToolchainsMerger;
import org.apache.maven.toolchain.v4.MavenToolchainsTransformer;

@Named
public class DefaultToolchainsBuilder
implements ToolchainsBuilder {
    private final MavenToolchainsMerger toolchainsMerger = new MavenToolchainsMerger();
    private final Interpolator interpolator;
    private final ToolchainsXmlFactory toolchainsXmlFactory;

    public DefaultToolchainsBuilder() {
        this(new DefaultInterpolator(), new DefaultToolchainsXmlFactory());
    }

    @Inject
    public DefaultToolchainsBuilder(Interpolator interpolator, ToolchainsXmlFactory toolchainsXmlFactory) {
        this.interpolator = interpolator;
        this.toolchainsXmlFactory = toolchainsXmlFactory;
    }

    public ToolchainsBuilderResult build(ToolchainsBuilderRequest request) throws ToolchainsBuilderException {
        ArrayList<BuilderProblem> problems = new ArrayList<BuilderProblem>();
        Source installationSource = request.getInstallationToolchainsSource().orElse(null);
        PersistedToolchains installation = this.readToolchains(installationSource, request, problems);
        Source userSource = request.getUserToolchainsSource().orElse(null);
        PersistedToolchains user = this.readToolchains(userSource, request, problems);
        PersistedToolchains effective = this.toolchainsMerger.merge(user, installation, false, null);
        if (this.hasErrors(problems)) {
            throw new ToolchainsBuilderException("Error building toolchains", problems);
        }
        return new DefaultToolchainsBuilderResult(effective, problems);
    }

    private boolean hasErrors(List<BuilderProblem> problems) {
        if (problems != null) {
            for (BuilderProblem problem : problems) {
                if (BuilderProblem.Severity.ERROR.compareTo((Enum)problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private PersistedToolchains readToolchains(Source toolchainsSource, ToolchainsBuilderRequest request, List<BuilderProblem> problems) {
        PersistedToolchains toolchains;
        if (toolchainsSource == null) {
            return PersistedToolchains.newInstance();
        }
        try {
            try {
                InputStream is = toolchainsSource.openStream();
                if (is == null) {
                    return PersistedToolchains.newInstance();
                }
                toolchains = (PersistedToolchains)this.toolchainsXmlFactory.read(XmlReaderRequest.builder().inputStream(is).location(toolchainsSource.getLocation()).strict(true).build());
            }
            catch (XmlReaderException e) {
                Location location;
                InputStream is = toolchainsSource.openStream();
                if (is == null) {
                    return PersistedToolchains.newInstance();
                }
                toolchains = (PersistedToolchains)this.toolchainsXmlFactory.read(XmlReaderRequest.builder().inputStream(is).location(toolchainsSource.getLocation()).strict(false).build());
                Throwable throwable = e.getCause();
                if (throwable instanceof XMLStreamException) {
                    XMLStreamException xe = (XMLStreamException)throwable;
                    location = xe.getLocation();
                } else {
                    location = null;
                }
                Location loc = location;
                problems.add(new DefaultBuilderProblem(toolchainsSource.getLocation(), loc != null ? loc.getLineNumber() : -1, loc != null ? loc.getColumnNumber() : -1, (Exception)((Object)e), e.getMessage(), BuilderProblem.Severity.WARNING));
            }
        }
        catch (XmlReaderException e) {
            Location location;
            Throwable throwable = e.getCause();
            if (throwable instanceof XMLStreamException) {
                XMLStreamException xe = (XMLStreamException)throwable;
                location = xe.getLocation();
            } else {
                location = null;
            }
            Location loc = location;
            problems.add(new DefaultBuilderProblem(toolchainsSource.getLocation(), loc != null ? loc.getLineNumber() : -1, loc != null ? loc.getColumnNumber() : -1, (Exception)((Object)e), "Non-parseable toolchains " + toolchainsSource.getLocation() + ": " + e.getMessage(), BuilderProblem.Severity.FATAL));
            return PersistedToolchains.newInstance();
        }
        catch (IOException e) {
            problems.add(new DefaultBuilderProblem(toolchainsSource.getLocation(), -1, -1, e, "Non-readable toolchains " + toolchainsSource.getLocation() + ": " + e.getMessage(), BuilderProblem.Severity.FATAL));
            return PersistedToolchains.newInstance();
        }
        toolchains = this.interpolate(toolchains, request, problems);
        return toolchains;
    }

    private PersistedToolchains interpolate(PersistedToolchains toolchains, ToolchainsBuilderRequest request, List<BuilderProblem> problems) {
        Map userProperties = request.getSession().getUserProperties();
        Map systemProperties = request.getSession().getSystemProperties();
        Function[] functionArray = new Function[2];
        functionArray[0] = userProperties::get;
        functionArray[1] = systemProperties::get;
        Function src = Interpolator.chain((Function[])functionArray);
        return new MavenToolchainsTransformer(value -> value != null ? this.interpolator.interpolate(value, src) : null).visit(toolchains);
    }

    static class DefaultToolchainsBuilderResult
    implements ToolchainsBuilderResult {
        private final PersistedToolchains effectiveToolchains;
        private final List<BuilderProblem> problems;

        DefaultToolchainsBuilderResult(PersistedToolchains effectiveToolchains, List<BuilderProblem> problems) {
            this.effectiveToolchains = effectiveToolchains;
            this.problems = problems != null ? problems : new ArrayList();
        }

        public PersistedToolchains getEffectiveToolchains() {
            return this.effectiveToolchains;
        }

        public List<BuilderProblem> getProblems() {
            return this.problems;
        }
    }
}

