/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Objects;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.Logger;

public class MojoLogWrapper
implements Log {
    private final Logger logger;

    public MojoLogWrapper(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    public void debug(CharSequence content) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.toString(content));
        }
    }

    private String toString(CharSequence content) {
        if (content == null) {
            return "";
        }
        return content.toString();
    }

    public void debug(CharSequence content, Throwable error) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.toString(content), error);
        }
    }

    public void debug(Throwable error) {
        this.logger.debug("", error);
    }

    public void info(CharSequence content) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.toString(content));
        }
    }

    public void info(CharSequence content, Throwable error) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.toString(content), error);
        }
    }

    public void info(Throwable error) {
        this.logger.info("", error);
    }

    public void warn(CharSequence content) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.toString(content));
        }
    }

    public void warn(CharSequence content, Throwable error) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.toString(content), error);
        }
    }

    public void warn(Throwable error) {
        this.logger.warn("", error);
    }

    public void error(CharSequence content) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.toString(content));
        }
    }

    public void error(CharSequence content, Throwable error) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.toString(content), error);
        }
    }

    public void error(Throwable error) {
        this.logger.error("", error);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }
}

