/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.execution.ActivationSettings;

public class ProfileActivation {
    private final Map<String, ActivationSettings> activations = new HashMap<String, ActivationSettings>();

    @Deprecated
    public List<String> getActiveProfiles() {
        return Collections.unmodifiableList(new ArrayList<String>(this.getProfileIds(pa -> pa.active)));
    }

    @Deprecated
    public List<String> getInactiveProfiles() {
        return Collections.unmodifiableList(new ArrayList<String>(this.getProfileIds(pa -> !pa.active)));
    }

    @Deprecated
    public void overwriteActiveProfiles(List<String> activeProfileIds) {
        this.getActiveProfiles().forEach(this.activations::remove);
        activeProfileIds.forEach(this::activateOptionalProfile);
    }

    @Deprecated
    public void overwriteInactiveProfiles(List<String> inactiveProfileIds) {
        this.getInactiveProfiles().forEach(this.activations::remove);
        inactiveProfileIds.forEach(this::deactivateOptionalProfile);
    }

    public void activateRequiredProfile(String id) {
        this.activations.put(id, ActivationSettings.ACTIVATION_REQUIRED);
    }

    public void activateOptionalProfile(String id) {
        this.activations.put(id, ActivationSettings.ACTIVATION_OPTIONAL);
    }

    public void deactivateRequiredProfile(String id) {
        this.activations.put(id, ActivationSettings.DEACTIVATION_REQUIRED);
    }

    public void deactivateOptionalProfile(String id) {
        this.activations.put(id, ActivationSettings.DEACTIVATION_OPTIONAL);
    }

    public void addProfileActivation(String id, boolean active, boolean optional) {
        ActivationSettings settings = ActivationSettings.of(active, optional);
        this.activations.put(id, settings);
    }

    private Set<String> getProfileIds(Predicate<ActivationSettings> predicate) {
        return this.activations.entrySet().stream().filter(e -> predicate.test((ActivationSettings)((Object)((Object)e.getValue())))).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getRequiredActiveProfileIds() {
        return this.getProfileIds(pa -> !pa.optional && pa.active);
    }

    public Set<String> getOptionalActiveProfileIds() {
        return this.getProfileIds(pa -> pa.optional && pa.active);
    }

    public Set<String> getRequiredInactiveProfileIds() {
        return this.getProfileIds(pa -> !pa.optional && !pa.active);
    }

    public Set<String> getOptionalInactiveProfileIds() {
        return this.getProfileIds(pa -> pa.optional && !pa.active);
    }
}

