/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn.resident;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.cling.invoker.ProtoLookup;
import org.apache.maven.cling.invoker.mvn.MavenInvoker;
import org.apache.maven.cling.invoker.mvn.resident.ResidentMavenContext;

public class ResidentMavenInvoker
extends MavenInvoker<ResidentMavenContext> {
    private final ConcurrentHashMap<String, ResidentMavenContext> residentContext = new ConcurrentHashMap();

    public ResidentMavenInvoker(ProtoLookup protoLookup) {
        super(protoLookup);
    }

    public void close() throws InvokerException {
        ArrayList<InvokerException> exceptions = new ArrayList<InvokerException>();
        for (ResidentMavenContext context : this.residentContext.values()) {
            try {
                context.shutDown();
            }
            catch (InvokerException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            InvokerException exception = new InvokerException("Could not cleanly shut down context pool");
            exceptions.forEach(exception::addSuppressed);
            throw exception;
        }
    }

    @Override
    protected ResidentMavenContext createContext(InvokerRequest invokerRequest) {
        return this.residentContext.computeIfAbsent(this.getContextId(invokerRequest), k -> new ResidentMavenContext(invokerRequest)).copy(invokerRequest);
    }

    protected String getContextId(InvokerRequest invokerRequest) {
        return "resident";
    }

    @Override
    protected void container(ResidentMavenContext context) throws Exception {
        if (context.containerCapsule == null) {
            super.container(context);
        } else {
            context.containerCapsule.updateLogging(context);
        }
    }

    @Override
    protected void lookup(ResidentMavenContext context) throws Exception {
        if (context.maven == null) {
            super.lookup(context);
        }
    }
}

