/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn.forked;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.cli.Invoker;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.internal.impl.model.profile.Os;

public class ForkedMavenInvoker
implements Invoker {
    public int invoke(InvokerRequest invokerRequest) throws InvokerException {
        Objects.requireNonNull(invokerRequest);
        this.validate(invokerRequest);
        ArrayList<String> cmdAndArguments = new ArrayList<String>();
        cmdAndArguments.add(invokerRequest.installationDirectory().resolve("bin").resolve((String)(Os.IS_WINDOWS ? invokerRequest.parserRequest().command() + ".cmd" : invokerRequest.parserRequest().command())).toString());
        MavenOptions mavenOptions = (MavenOptions)invokerRequest.options();
        if (mavenOptions.userProperties().isPresent()) {
            for (Map.Entry entry : ((Map)mavenOptions.userProperties().get()).entrySet()) {
                cmdAndArguments.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        if (mavenOptions.showVersionAndExit().orElse(false).booleanValue()) {
            cmdAndArguments.add("--version");
        }
        if (mavenOptions.showVersion().orElse(false).booleanValue()) {
            cmdAndArguments.add("--show-version");
        }
        if (mavenOptions.quiet().orElse(false).booleanValue()) {
            cmdAndArguments.add("--quiet");
        }
        if (mavenOptions.verbose().orElse(false).booleanValue()) {
            cmdAndArguments.add("--verbose");
        }
        if (mavenOptions.showErrors().orElse(false).booleanValue()) {
            cmdAndArguments.add("--errors");
        }
        if (mavenOptions.failOnSeverity().isPresent()) {
            cmdAndArguments.add("--fail-on-severity");
            cmdAndArguments.add((String)mavenOptions.failOnSeverity().get());
        }
        if (mavenOptions.nonInteractive().orElse(false).booleanValue()) {
            cmdAndArguments.add("--non-interactive");
        }
        if (mavenOptions.forceInteractive().orElse(false).booleanValue()) {
            cmdAndArguments.add("--force-interactive");
        }
        if (mavenOptions.altUserSettings().isPresent()) {
            cmdAndArguments.add("--settings");
            cmdAndArguments.add((String)mavenOptions.altUserSettings().get());
        }
        if (mavenOptions.altProjectSettings().isPresent()) {
            cmdAndArguments.add("--project-settings");
            cmdAndArguments.add((String)mavenOptions.altProjectSettings().get());
        }
        if (mavenOptions.altInstallationSettings().isPresent()) {
            cmdAndArguments.add("--install-settings");
            cmdAndArguments.add((String)mavenOptions.altInstallationSettings().get());
        }
        if (mavenOptions.altUserToolchains().isPresent()) {
            cmdAndArguments.add("--toolchains");
            cmdAndArguments.add((String)mavenOptions.altUserToolchains().get());
        }
        if (mavenOptions.altInstallationToolchains().isPresent()) {
            cmdAndArguments.add("--install-toolchains");
            cmdAndArguments.add((String)mavenOptions.altInstallationToolchains().get());
        }
        if (mavenOptions.logFile().isPresent()) {
            cmdAndArguments.add("--log-file");
            cmdAndArguments.add((String)mavenOptions.logFile().get());
        }
        if (mavenOptions.color().isPresent()) {
            cmdAndArguments.add("--color");
            cmdAndArguments.add((String)mavenOptions.color().get());
        }
        if (mavenOptions.help().orElse(false).booleanValue()) {
            cmdAndArguments.add("--help");
        }
        if (mavenOptions.alternatePomFile().isPresent()) {
            cmdAndArguments.add("--file");
            cmdAndArguments.add((String)mavenOptions.alternatePomFile().get());
        }
        if (mavenOptions.offline().orElse(false).booleanValue()) {
            cmdAndArguments.add("--offline");
        }
        if (mavenOptions.nonRecursive().orElse(false).booleanValue()) {
            cmdAndArguments.add("--non-recursive");
        }
        if (mavenOptions.updateSnapshots().orElse(false).booleanValue()) {
            cmdAndArguments.add("--update-snapshots");
        }
        if (mavenOptions.activatedProfiles().isPresent()) {
            cmdAndArguments.add("--activate-profiles");
            cmdAndArguments.add(String.join((CharSequence)",", (Iterable)mavenOptions.activatedProfiles().get()));
        }
        if (mavenOptions.suppressSnapshotUpdates().orElse(false).booleanValue()) {
            cmdAndArguments.add("--no-snapshot-updates");
        }
        if (mavenOptions.strictChecksums().orElse(false).booleanValue()) {
            cmdAndArguments.add("--strict-checksums");
        }
        if (mavenOptions.relaxedChecksums().orElse(false).booleanValue()) {
            cmdAndArguments.add("--lax-checksums");
        }
        if (mavenOptions.failFast().orElse(false).booleanValue()) {
            cmdAndArguments.add("--fail-fast");
        }
        if (mavenOptions.failAtEnd().orElse(false).booleanValue()) {
            cmdAndArguments.add("--fail-at-end");
        }
        if (mavenOptions.failNever().orElse(false).booleanValue()) {
            cmdAndArguments.add("--fail-never");
        }
        if (mavenOptions.resume().orElse(false).booleanValue()) {
            cmdAndArguments.add("--resume");
        }
        if (mavenOptions.resumeFrom().isPresent()) {
            cmdAndArguments.add("--resume-from");
            cmdAndArguments.add((String)mavenOptions.resumeFrom().get());
        }
        if (mavenOptions.projects().isPresent()) {
            cmdAndArguments.add("--projects");
            cmdAndArguments.add(String.join((CharSequence)",", (Iterable)mavenOptions.projects().get()));
        }
        if (mavenOptions.alsoMake().orElse(false).booleanValue()) {
            cmdAndArguments.add("--also-make");
        }
        if (mavenOptions.alsoMakeDependents().orElse(false).booleanValue()) {
            cmdAndArguments.add("--also-make-dependents");
        }
        if (mavenOptions.threads().isPresent()) {
            cmdAndArguments.add("--threads");
            cmdAndArguments.add((String)mavenOptions.threads().get());
        }
        if (mavenOptions.builder().isPresent()) {
            cmdAndArguments.add("--builder");
            cmdAndArguments.add((String)mavenOptions.builder().get());
        }
        if (mavenOptions.noTransferProgress().orElse(false).booleanValue()) {
            cmdAndArguments.add("--no-transfer-progress");
        }
        if (mavenOptions.cacheArtifactNotFound().isPresent()) {
            cmdAndArguments.add("--cache-artifact-not-found");
            cmdAndArguments.add(((Boolean)mavenOptions.cacheArtifactNotFound().get()).toString());
        }
        if (mavenOptions.strictArtifactDescriptorPolicy().isPresent()) {
            cmdAndArguments.add("--strict-artifact-descriptor-policy");
            cmdAndArguments.add(((Boolean)mavenOptions.strictArtifactDescriptorPolicy().get()).toString());
        }
        if (mavenOptions.ignoreTransitiveRepositories().isPresent()) {
            cmdAndArguments.add("--ignore-transitive-repositories");
        }
        cmdAndArguments.addAll(mavenOptions.goals().orElse(Collections.emptyList()));
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]).directory(invokerRequest.cwd().toFile()).command(cmdAndArguments);
            if (invokerRequest.jvmArguments().isPresent()) {
                pb.environment().put("MAVEN_OPTS", String.join((CharSequence)" ", (Iterable)invokerRequest.jvmArguments().get()));
            }
            return pb.start().waitFor();
        }
        catch (IOException e) {
            invokerRequest.logger().error("IO problem while executing command: " + String.valueOf(cmdAndArguments), (Throwable)e);
            return 127;
        }
        catch (InterruptedException e) {
            invokerRequest.logger().error("Interrupted while executing command: " + String.valueOf(cmdAndArguments), (Throwable)e);
            return 127;
        }
    }

    protected void validate(InvokerRequest invokerRequest) throws InvokerException {
    }
}

