/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.sync;

import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.mvndaemon.mvnd.sync.IpcClient;

class IpcSyncContext
implements SyncContext {
    final IpcClient client;
    final boolean shared;
    final String contextId;
    final AtomicBoolean closed = new AtomicBoolean();

    IpcSyncContext(IpcClient client, boolean shared) {
        this.client = client;
        this.shared = shared;
        this.contextId = Objects.requireNonNull(client.newContext(shared));
    }

    public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        if (this.closed.get()) {
            throw new IllegalStateException("Already closed");
        }
        TreeSet<String> keys = new TreeSet<String>();
        this.stream(artifacts).map(this::getKey).forEach(keys::add);
        this.stream(metadatas).map(this::getKey).forEach(keys::add);
        if (keys.isEmpty()) {
            return;
        }
        this.client.lock(this.contextId, keys);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.client.unlock(this.contextId);
        }
    }

    public String toString() {
        return "IpcSyncContext{client=" + this.client + ", shared=" + this.shared + ", contextId='" + this.contextId + '\'' + '}';
    }

    private <T> Stream<T> stream(Collection<T> col) {
        return col != null ? col.stream() : Stream.empty();
    }

    private String getKey(Artifact a) {
        return "artifact:" + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getBaseVersion();
    }

    private String getKey(Metadata m) {
        StringBuilder key = new StringBuilder("metadata:");
        if (!m.getGroupId().isEmpty()) {
            key.append(m.getGroupId());
            if (!m.getArtifactId().isEmpty()) {
                key.append(':').append(m.getArtifactId());
                if (!m.getVersion().isEmpty()) {
                    key.append(':').append(m.getVersion());
                }
            }
        }
        return key.toString();
    }
}

