/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Locale;
import org.mvndaemon.mvnd.common.SocketHelper;

public enum SocketFamily {
    inet,
    unix;


    public SocketChannel openSocket() throws IOException {
        switch (this) {
            case inet: {
                return SocketChannel.open();
            }
            case unix: {
                return SocketHelper.openUnixSocket();
            }
        }
        throw new IllegalStateException();
    }

    public ServerSocketChannel openServerSocket() throws IOException {
        switch (this) {
            case inet: {
                return ServerSocketChannel.open().bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), 0);
            }
            case unix: {
                return SocketHelper.openUnixServerSocket();
            }
        }
        throw new IllegalStateException();
    }

    private StandardProtocolFamily getStandardProtocolFamily() {
        return StandardProtocolFamily.valueOf(this.name().toUpperCase(Locale.ROOT));
    }

    private SocketAddress getLoopbackAddress() {
        if (this == inet) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return null;
    }

    public static SocketAddress fromString(String str) {
        if (str.startsWith("inet:")) {
            InetAddress addr;
            String s = str.substring("inet:".length());
            int ic = s.lastIndexOf(58);
            String ia = s.substring(0, ic);
            int is = ia.indexOf(47);
            String h = ia.substring(0, is);
            String a = ia.substring(is + 1);
            String p = s.substring(ic + 1);
            if ("<unresolved>".equals(a)) {
                return InetSocketAddress.createUnresolved(h, Integer.parseInt(p));
            }
            if (a.indexOf(46) > 0) {
                String[] as = a.split("\\.");
                if (as.length != 4) {
                    throw new IllegalArgumentException("Unsupported socket address: '" + str + "'");
                }
                byte[] ab = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    ab[i] = (byte)Integer.parseInt(as[i]);
                }
                try {
                    addr = InetAddress.getByAddress(h.isEmpty() ? null : h, ab);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Unsupported address: " + str, e);
                }
            } else {
                throw new IllegalArgumentException("Unsupported address: " + str);
            }
            return new InetSocketAddress(addr, Integer.parseInt(p));
        }
        if (str.startsWith("unix:")) {
            return SocketHelper.unixSocketAddressOf(str.substring("unix:".length()));
        }
        throw new IllegalArgumentException("Unsupported socket address: '" + str + "'");
    }

    public static String toString(SocketAddress address) {
        switch (SocketFamily.familyOf(address)) {
            case inet: {
                String formatted;
                InetSocketAddress isa = (InetSocketAddress)address;
                String host = isa.getHostString();
                InetAddress addr = isa.getAddress();
                int port = isa.getPort();
                if (addr == null) {
                    formatted = host + "/<unresolved>";
                } else {
                    formatted = addr.toString();
                    if (addr instanceof Inet6Address) {
                        int i = formatted.lastIndexOf("/");
                        formatted = formatted.substring(0, i + 1) + "[" + formatted.substring(i + 1) + "]";
                    }
                }
                return "inet:" + formatted + ":" + port;
            }
            case unix: {
                return "unix:" + address;
            }
        }
        throw new IllegalArgumentException("Unsupported socket address: '" + address + "'");
    }

    public static SocketFamily familyOf(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return inet;
        }
        if ("java.net.UnixDomainSocketAddress".equals(address.getClass().getName())) {
            return unix;
        }
        throw new IllegalArgumentException("Unsupported socket address '" + address + "'");
    }
}

