/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.sync;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.common.Environment;

@Singleton
@Named
@Priority(value=20)
public class MvndSyncContextFactory
implements SyncContextFactory {
    public static final String FACTORY_NOOP = "noop";
    public static final String FACTORY_IPC = "ipc";
    public static final String IPC_SYNC_CONTEXT_FACTORY = "org.mvndaemon.mvnd.sync.IpcSyncContextFactory";
    private final Map<String, SyncContextFactory> factories;

    public MvndSyncContextFactory() {
        try {
            HashMap<String, SyncContextFactory> map = new HashMap<String, SyncContextFactory>();
            map.put(FACTORY_NOOP, new NoopSyncContextFactory());
            Class<?> factoryClass = this.getClass().getClassLoader().loadClass(IPC_SYNC_CONTEXT_FACTORY);
            map.put(FACTORY_IPC, (SyncContextFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            this.factories = Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create IpcSyncContextFactory instance", e);
        }
    }

    public SyncContext newInstance(RepositorySystemSession repositorySystemSession, boolean shared) {
        String name = Environment.MVND_SYNC_CONTEXT_FACTORY.asOptional().orElseGet(() -> ((Environment)Environment.MVND_SYNC_CONTEXT_FACTORY).getDefault());
        SyncContextFactory factory = this.factories.get(name);
        if (factory == null) {
            throw new RuntimeException("Unable to find SyncContextFactory named '" + name + "'");
        }
        return factory.newInstance(repositorySystemSession, shared);
    }

    private static class NoopSyncContextFactory
    implements SyncContextFactory {
        private NoopSyncContextFactory() {
        }

        public SyncContext newInstance(RepositorySystemSession repositorySystemSession, boolean shared) {
            return new SyncContext(){

                public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
                }

                public void close() {
                }
            };
        }
    }
}

