/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.invalidating;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.DefaultProjectArtifactsCache;
import org.apache.maven.project.artifact.ProjectArtifactsCache;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.cache.Cache;
import org.mvndaemon.mvnd.cache.CacheFactory;
import org.mvndaemon.mvnd.cache.CacheRecord;

@Singleton
@Named
@Priority(value=10)
public class InvalidatingProjectArtifactsCache
extends DefaultProjectArtifactsCache {
    final Cache<ProjectArtifactsCache.Key, Record> cache;

    @Inject
    public InvalidatingProjectArtifactsCache(CacheFactory cacheFactory) {
        this.cache = cacheFactory.newCache();
    }

    public ProjectArtifactsCache.CacheRecord get(ProjectArtifactsCache.Key key) throws LifecycleExecutionException {
        Record r = this.cache.get(key);
        if (r != null) {
            if (r.record.getException() != null) {
                throw r.record.getException();
            }
            return r.record;
        }
        return null;
    }

    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, Set<Artifact> pluginArtifacts) {
        ProjectArtifactsCache.CacheRecord record = super.put(key, pluginArtifacts);
        ((DefaultProjectArtifactsCache)this).cache.remove(key);
        this.cache.put(key, new Record(record));
        return record;
    }

    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, LifecycleExecutionException e) {
        ProjectArtifactsCache.CacheRecord record = super.put(key, e);
        ((DefaultProjectArtifactsCache)this).cache.remove(key);
        this.cache.put(key, new Record(record));
        return record;
    }

    public void flush() {
        this.cache.clear();
    }

    public void register(MavenProject project, ProjectArtifactsCache.Key cacheKey, ProjectArtifactsCache.CacheRecord record) {
    }

    static class Record
    implements CacheRecord {
        private final ProjectArtifactsCache.CacheRecord record;

        public Record(ProjectArtifactsCache.CacheRecord record) {
            this.record = record;
        }

        @Override
        public Stream<Path> getDependencyPaths() {
            if (this.record.getException() != null) {
                return Stream.empty();
            }
            return this.record.getArtifacts().stream().map(Artifact::getFile).filter(Objects::nonNull).map(File::toPath);
        }

        @Override
        public void invalidate() {
        }
    }
}

