/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.mvndaemon.mvnd.client.DaemonParameters;

public class Completion {
    public static String getCompletion(String shell, DaemonParameters daemonParameters) {
        if (!"bash".equals(shell)) {
            throw new IllegalArgumentException("Unexpected --completion value: '" + shell + "'; expected: 'bash'");
        }
        Path bashCompletionPath = daemonParameters.mvndHome().resolve("bin/mvnd-bash-completion.bash");
        if (!Files.isRegularFile(bashCompletionPath, new LinkOption[0])) {
            throw new IllegalStateException("Bash completion file does not exist: " + bashCompletionPath);
        }
        try {
            return new String(Files.readAllBytes(bashCompletionPath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read " + bashCompletionPath, e);
        }
    }
}

