/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mvndaemon.mvnd.common.OptionType;
import org.mvndaemon.mvnd.common.Os;
import org.mvndaemon.mvnd.common.TimeUtils;

public enum Environment {
    COMPLETION(null, null, null, OptionType.STRING, 4, "mvnd:--completion"),
    PURGE(null, null, null, OptionType.VOID, 4, "mvnd:--purge"),
    STATUS(null, null, null, OptionType.VOID, 4, "mvnd:--status"),
    STOP(null, null, null, OptionType.VOID, 4, "mvnd:--stop"),
    SERIAL("mvnd.serial", null, Boolean.FALSE, OptionType.VOID, 4, "mvnd:-1", "mvnd:--serial"),
    MVND_LOGBACK("mvnd.logback", null, null, OptionType.PATH, 0, new String[0]),
    LOGBACK_CONFIGURATION_FILE("logback.configurationFile", null, null, OptionType.PATH, 2, new String[0]),
    JAVA_HOME("java.home", "JAVA_HOME", null, OptionType.PATH, 0, new String[0]),
    MVND_HOME("mvnd.home", "MVND_HOME", null, OptionType.PATH, 1, new String[0]),
    USER_HOME("user.home", null, null, OptionType.PATH, 0, new String[0]),
    USER_DIR("user.dir", null, null, OptionType.PATH, 0, new String[0]),
    JDK_JAVA_OPTIONS("jdk.java.options", "JDK_JAVA_OPTIONS", "", OptionType.STRING, 1, new String[0]),
    MAVEN_REPO_LOCAL("maven.repo.local", null, null, OptionType.PATH, 0, new String[0]),
    MAVEN_SETTINGS("maven.settings", null, null, OptionType.PATH, 0, "mvn:-s", "mvn:--settings"),
    MAVEN_FILE(null, null, null, OptionType.PATH, 0, "mvn:-f", "mvn:--file"),
    MAVEN_MULTIMODULE_PROJECT_DIRECTORY("maven.multiModuleProjectDirectory", null, null, OptionType.PATH, 0, new String[0]),
    MAVEN_LOG_FILE(null, null, null, OptionType.PATH, 2, "mvn:-l", "mvn:--log-file"),
    MAVEN_BATCH_MODE(null, null, null, OptionType.BOOLEAN, 2, "mvn:-B", "mvn:--batch-mode"),
    MAVEN_DEBUG(null, null, null, OptionType.BOOLEAN, 2, "mvn:-X", "mvn:--debug"),
    MAVEN_VERSION(null, null, null, OptionType.BOOLEAN, 2, "mvn:-v", "mvn:-version", "mvn:--version"),
    MAVEN_SHOW_VERSION(null, null, null, OptionType.BOOLEAN, 2, "mvn:-V", "mvn:--show-version"),
    MAVEN_DEFINE(null, null, null, OptionType.STRING, 2, "mvn:-D", "mvn:--define"),
    MAVEN_COLOR("style.color", null, "auto", OptionType.STRING, 4, "mvnd:--color"),
    MVND_PROPERTIES_PATH("mvnd.propertiesPath", "MVND_PROPERTIES_PATH", null, OptionType.PATH, 0, new String[0]),
    MVND_DAEMON_STORAGE("mvnd.daemonStorage", "MVND_DAEMON_STORAGE", null, OptionType.PATH, 0, new String[0]),
    MVND_REGISTRY("mvnd.registry", null, null, OptionType.PATH, 0, new String[0]),
    MVND_NO_BUFERING("mvnd.noBuffering", null, Boolean.FALSE, OptionType.BOOLEAN, 0, new String[0]),
    MVND_ROLLING_WINDOW_SIZE("mvnd.rollingWindowSize", null, "0", OptionType.INTEGER, 0, new String[0]),
    MVND_LOG_PURGE_PERIOD("mvnd.logPurgePeriod", null, "7 days", OptionType.DURATION, 0, new String[0]),
    MVND_NO_DAEMON("mvnd.noDaemon", "MVND_NO_DAEMON", Boolean.FALSE, OptionType.BOOLEAN, 1, new String[0]),
    MVND_DEBUG("mvnd.debug", null, Boolean.FALSE, OptionType.BOOLEAN, 1, new String[0]),
    MVND_IDLE_TIMEOUT("mvnd.idleTimeout", null, "3 hours", OptionType.DURATION, 1, new String[0]),
    MVND_KEEP_ALIVE("mvnd.keepAlive", null, "100 ms", OptionType.DURATION, 1, new String[0]),
    MVND_MAX_LOST_KEEP_ALIVE("mvnd.maxLostKeepAlive", null, 30, OptionType.INTEGER, 0, new String[0]),
    MVND_MIN_THREADS("mvnd.minThreads", null, 1, OptionType.INTEGER, 0, new String[0]),
    MVND_THREADS("mvnd.threads", null, null, OptionType.STRING, 0, "mvn:-T", "mvn:--threads"),
    MVND_BUILDER("mvnd.builder", null, "smart", OptionType.STRING, 0, "mvn:-b", "mvn:--builder"),
    MVND_ID("mvnd.id", null, null, OptionType.STRING, 2, new String[0]),
    MVND_EXT_CLASSPATH("mvnd.extClasspath", null, null, OptionType.STRING, 3, new String[0]),
    MVND_CORE_EXTENSIONS("mvnd.coreExtensions", null, null, OptionType.STRING, 3, new String[0]),
    MVND_MIN_HEAP_SIZE("mvnd.minHeapSize", null, null, OptionType.MEMORY_SIZE, 5, new String[0]),
    MVND_MAX_HEAP_SIZE("mvnd.maxHeapSize", null, null, OptionType.MEMORY_SIZE, 5, new String[0]),
    MVND_THREAD_STACK_SIZE("mvnd.threadStackSize", null, null, OptionType.MEMORY_SIZE, 5, new String[0]),
    MVND_JVM_ARGS("mvnd.jvmArgs", null, null, OptionType.STRING, 5, new String[0]),
    MVND_ENABLE_ASSERTIONS("mvnd.enableAssertions", null, Boolean.FALSE, OptionType.BOOLEAN, 1, new String[0]),
    MVND_EXPIRATION_CHECK_DELAY("mvnd.expirationCheckDelay", null, "10 seconds", OptionType.DURATION, 1, new String[0]),
    MVND_DUPLICATE_DAEMON_GRACE_PERIOD("mvnd.duplicateDaemonGracePeriod", null, "10 seconds", OptionType.DURATION, 1, new String[0]),
    MVND_TERMINAL_WIDTH("mvnd.terminalWidth", null, 0, OptionType.INTEGER, 2, new String[0]),
    MVND_JAVA_HOME("mvnd.java.home", null, null, OptionType.PATH, 2, new String[0]),
    MVND_BUILD_TIME("mvnd.buildTime", null, null, OptionType.BOOLEAN, 0, new String[0]),
    MVND_SOCKET_FAMILY("mvnd.socketFamily", null, "inet", OptionType.STRING, 1, new String[0]),
    MVND_PLUGIN_REALM_EVICT_PATTERN("mvnd.pluginRealmEvictPattern", null, "", OptionType.STRING, 4, new String[0]);

    static Properties properties;
    private final String property;
    private final String environmentVariable;
    private final String default_;
    private final int flags;
    private final OptionType type;
    private final Map<String, OptionOrigin> options;

    public static void setProperties(Properties properties) {
        Environment.properties = properties;
    }

    public static String getProperty(String property) {
        Properties props = properties;
        if (props == null) {
            props = System.getProperties();
        }
        return props.getProperty(property);
    }

    private Environment(String property, String environmentVariable, Object default_, OptionType type, int flags, String ... options) {
        if (property == null && options.length == 0) {
            throw new IllegalArgumentException("An " + Environment.class.getSimpleName() + " entry must have property or options set");
        }
        this.property = property;
        this.environmentVariable = environmentVariable;
        this.default_ = default_ != null ? default_.toString() : null;
        this.flags = flags;
        this.type = type;
        if (options.length == 0) {
            this.options = Collections.emptyMap();
        } else {
            LinkedHashMap<String, OptionOrigin> optMap = new LinkedHashMap<String, OptionOrigin>();
            for (String opt : options) {
                OptionOrigin oo22;
                block6: {
                    for (OptionOrigin oo22 : OptionOrigin.values()) {
                        if (!opt.startsWith(oo22.prefix)) {
                            continue;
                        }
                        break block6;
                    }
                    throw new IllegalArgumentException("Unexpected option prefix: '" + opt + "'; Options should start with any of " + Stream.of(OptionOrigin.values()).map(oo -> ((OptionOrigin)oo).prefix).collect(Collectors.joining(",")));
                }
                optMap.put(opt.substring(oo22.prefix.length()), oo22);
            }
            this.options = Collections.unmodifiableMap(optMap);
        }
    }

    public String getProperty() {
        return this.property;
    }

    public String getEnvironmentVariable() {
        return this.environmentVariable;
    }

    public String getDefault() {
        return this.default_;
    }

    public Set<String> getOptions() {
        return this.options.keySet();
    }

    public Map<String, OptionOrigin> getOptionMap() {
        return this.options;
    }

    public OptionType getType() {
        return this.type;
    }

    public boolean isDiscriminating() {
        return (this.flags & 1) != 0;
    }

    public boolean isInternal() {
        return (this.flags & 2) != 0;
    }

    public boolean isOptional() {
        return (this.flags & 4) != 0;
    }

    public String asString() {
        String val = Environment.getProperty(this.property);
        if (val == null) {
            throw new IllegalStateException("The system property " + this.property + " is missing");
        }
        return val;
    }

    public Optional<String> asOptional() {
        String val = Environment.getProperty(this.property);
        if (val != null) {
            return Optional.of(val);
        }
        if (this.isOptional()) {
            return Optional.empty();
        }
        throw new IllegalStateException("The system property " + this.property + " is missing");
    }

    public int asInt() {
        return Integer.parseInt(this.asString());
    }

    public boolean asBoolean() {
        return Boolean.parseBoolean(this.asString());
    }

    public Path asPath() {
        String result = this.asString();
        if (Os.current().isCygwin()) {
            result = Environment.cygpath(result);
        }
        return Paths.get(result, new String[0]);
    }

    public Duration asDuration() {
        return TimeUtils.toDuration(this.asString());
    }

    public String asDaemonOpt(String value) {
        return this.property + "=" + this.type.normalize(value);
    }

    public void addCommandLineOption(Collection<String> args, String value) {
        if (!this.options.isEmpty()) {
            args.add(this.options.keySet().iterator().next());
            args.add(this.type.normalize(value));
        } else {
            args.add("-D" + this.property + "=" + this.type.normalize(value));
        }
    }

    public boolean hasCommandLineOption(Collection<String> args) {
        String[] prefixes = this.getPrefixes();
        return args.stream().anyMatch(arg -> Stream.of(prefixes).anyMatch(arg::startsWith));
    }

    public String getCommandLineOption(Collection<String> args) {
        return this.getCommandLineOption(args, false);
    }

    public String removeCommandLineOption(Collection<String> args) {
        return this.getCommandLineOption(args, true);
    }

    String getCommandLineOption(Collection<String> args, boolean remove) {
        String[] prefixes = this.getPrefixes();
        String value = null;
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String arg = it.next();
            if (!Stream.of(prefixes).anyMatch(arg::startsWith)) continue;
            if (remove) {
                it.remove();
            }
            if (this.type == OptionType.VOID) {
                value = "";
                continue;
            }
            String opt = Stream.of(prefixes).filter(arg::startsWith).max(Comparator.comparing(String::length)).get();
            value = arg.substring(opt.length());
            if (value.isEmpty()) {
                if (!it.hasNext()) continue;
                value = it.next();
                if (!remove) continue;
                it.remove();
                continue;
            }
            if (value.charAt(0) != '=') continue;
            value = value.substring(1);
        }
        return value;
    }

    private String[] getPrefixes() {
        String[] prefixes;
        if (this.options.isEmpty()) {
            prefixes = new String[]{"-D" + this.property + "="};
        } else if (this.property != null) {
            prefixes = new String[this.options.size() + 1];
            this.options.keySet().toArray(prefixes);
            prefixes[this.options.size()] = "-D" + this.property + "=";
        } else {
            prefixes = this.options.keySet().toArray(new String[0]);
        }
        return prefixes;
    }

    public static String cygpath(String result) {
        String path = result.replace('/', '\\');
        if (path.matches("\\\\cygdrive\\\\[a-z]\\\\.*")) {
            String s = path.substring("\\cygdrive\\".length());
            result = s.substring(0, 1).toUpperCase(Locale.ENGLISH) + ":" + s.substring(1);
        }
        return result;
    }

    public static boolean isNative() {
        return "executable".equals(System.getProperty("org.graalvm.nativeimage.kind"));
    }

    public static Stream<DocumentedEnumEntry<Environment>> documentedEntries() {
        Properties props = new Properties();
        Environment[] values = Environment.values();
        String cliOptionsPath = ((Object)((Object)values[0])).getClass().getSimpleName() + ".javadoc.properties";
        try (InputStream in = Environment.class.getResourceAsStream(cliOptionsPath);){
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read " + cliOptionsPath, e);
        }
        return Stream.of(values).filter(env -> !env.isInternal()).sorted(Comparator.comparing(env -> env.property != null ? env.property : "").thenComparing(env -> !env.options.isEmpty() ? env.options.keySet().iterator().next() : "")).map(env -> new DocumentedEnumEntry<Environment>((Environment)((Object)env), props.getProperty(env.name())));
    }

    static class Flags {
        private static final int NONE = 0;
        private static final int DISCRIMINATING = 1;
        private static final int INTERNAL = 2;
        private static final int OPTIONAL = 4;

        Flags() {
        }
    }

    public static enum OptionOrigin {
        mvn,
        mvnd;

        private final String prefix = this.name() + ":";
    }

    public static class DocumentedEnumEntry<E> {
        private final E entry;
        private final String javaDoc;

        public DocumentedEnumEntry(E entry, String javaDoc) {
            this.entry = entry;
            this.javaDoc = javaDoc;
        }

        public E getEntry() {
            return this.entry;
        }

        public String getJavaDoc() {
            return this.javaDoc;
        }
    }

    public static enum Color {
        always,
        never,
        auto;


        public static Optional<Color> of(String color) {
            return color == null ? Optional.empty() : Optional.of(Color.valueOf(color));
        }
    }
}

