//////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2007-2019 musikcube team
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice,
//      this list of conditions and the following disclaimer.
//
//    * Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
//
//    * Neither the name of the author nor the names of other contributors may
//      be used to endorse or promote products derived from this software
//      without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include <musikcore/support/Preferences.h>
#include <musikcore/sdk/ISchema.h>

namespace cursespp {
    class SchemaOverlay {
        public:
            using Prefs = musik::core::Preferences;
            using ISchema = musik::core::sdk::ISchema;
            using SchemaPtr = std::shared_ptr<ISchema>;
            using PrefsPtr = std::shared_ptr<Prefs>;

            static void Show(
                const std::string& title,
                PrefsPtr prefs,
                SchemaPtr schema,
                std::function<void(bool)> callback);

            static void ShowListOverlay(
                const std::string& title,
                std::vector<std::string>& items,
                const std::string defaultValue,
                std::function<void(std::string)> cb);

            static void ShowBoolOverlay(
                const ISchema::BoolEntry* entry,
                PrefsPtr prefs,
                std::function<void(std::string)> callback);

            static void ShowIntOverlay(
                const ISchema::IntEntry* entry,
                PrefsPtr prefs,
                std::function<void(std::string)> callback);

            static void ShowDoubleOverlay(
                const ISchema::DoubleEntry* entry,
                PrefsPtr prefs,
                std::function<void(std::string)> callback);

            static void ShowStringOverlay(
                const ISchema::StringEntry* entry,
                PrefsPtr prefs,
                std::function<void(std::string)> callback);

            static void ShowEnumOverlay(
                const ISchema::EnumEntry* entry,
                PrefsPtr prefs,
                std::function<void(std::string)> callback);

        private:
            SchemaOverlay();
    };
}
