//////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004-2021 musikcube team
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice,
//      this list of conditions and the following disclaimer.
//
//    * Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
//
//    * Neither the name of the author nor the names of other contributors may
//      be used to endorse or promote products derived from this software
//      without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////

#include <stdafx.h>
#include "PreferenceKeys.h"

namespace musik { namespace cube { namespace prefs {

    const std::string keys::DisableCustomColors = "DisableCustomColors";
    const std::string keys::UsePaletteColors = "UsePaletteColors";
    const std::string keys::FirstRunSettingsDisplayed = "FirstRunSettingsDisplayed";
    const std::string keys::ColorTheme = "ColorTheme";
    const std::string keys::InheritBackgroundColor = "InheritBackgroundColor";
    const std::string keys::MinimizeToTray = "MinimizeToTray";
    const std::string keys::StartMinimized = "StartMinimized";
    const std::string keys::AutoUpdateCheck = "AutoUpdateCheck";
    const std::string keys::LastAcknowledgedUpdateVersion = "LastAcknowledgedUpdateVersion";
    const std::string keys::LastLibraryView = "LastLibraryView";
    const std::string keys::LastBrowseCategoryType = "LastBrowseCategoryType";
    const std::string keys::LastBrowseCategoryId = "LastBrowseCategoryId";
    const std::string keys::LastBrowseDirectoryRoot = "LastBrowseDirectoryRoot";
    const std::string keys::LastCategoryFilter = "LastCategoryFilter";
    const std::string keys::LastCategoryFilterMatchType = "LastCategoryFilterMatchType";
    const std::string keys::LastTrackFilter = "LastTrackFilter";
    const std::string keys::LastTrackFilterMatchType = "LastTrackFilterMatchType";
    const std::string keys::TrackSearchSortOrder = "TrackSearchSortOrder";
    const std::string keys::CategoryTrackListSortOrder = "CategoryTrackListSortOrder";
    const std::string keys::RatingPositiveChar = "RatingPositiveChar";
    const std::string keys::RatingNegativeChar = "RatingNegativeChar";
    const std::string keys::AutoHideCommandBar = "AutoHideCommandBar";
    const std::string keys::DisableRatingColumn = "DisableRatingColumn";
    const std::string keys::DisableWindowTitleUpdates = "DisableWindowTitleUpdates";
    const std::string keys::AppQuitKey = "AppQuitKey";

    #ifdef WIN32
    const bool defaults::DisableWindowTitleUpdates = false;
    #else
    const bool defaults::DisableWindowTitleUpdates = true;
    #endif

} } }

