function(ensure_library_exists libname)
    unset(__TEMP_ENSURE_LIBRARY CACHE)
    find_library(__TEMP_ENSURE_LIBRARY ${libname})
    if(NOT __TEMP_ENSURE_LIBRARY)
        message(FATAL_ERROR "\n\n[check-dependencies] ${libname} not found\n\n")
    else()
        message(STATUS "[check-dependencies] ${libname} found at ${__TEMP_ENSURE_LIBRARY}")
    endif()
    unset(__TEMP_ENSURE_LIBRARY CACHE)
endfunction(ensure_library_exists)
