	"Align FASTA input, write aligned FASTA (AFA) output:\n"
	"    muscle -align input.fa -output aln.afa\n"
	"\n"
	"Align large input using Super5 algorithm if -align is too expensive,\n"
	"typically needed with more than a few hundred sequences:\n"
	"    muscle -super5 input.fa -output aln.afa\n"
	"\n"
	"Single replicate alignment:\n"
	"    muscle -align input.fa -perm PERM -perturb SEED -output aln.afa\n"
	"    muscle -super5 input.fa -perm PERM -perturb SEED -output aln.afa\n"
	"        PERM is guide tree permutation none, abc, acb, bca (default none).\n"
	"        SEED is perturbation seed 0, 1, 2... (default 0 = don't perturb).\n"
	"\n"
	"Ensemble of replicate alignments, output in Ensemble FASTA (EFA) format,\n"
	"EFA has one aligned FASTA for each replicate with header line \"<PERM.SEED\":\n"
	"Note -super5 does not support .efa output, to get an ensemble you can\n"
	"  (1) run several times with different -perm and -perturb options, or\n"
	"  (2) use -perm all, then four output files will be generated, one for\n"
	"        each guide tree permutation (use @ in the output filename).\n"
	"    muscle -align input.fa -stratified -output stratified_ensemble.efa\n"
	"    muscle -align input.fa -diversified -output diversified_ensemble.afa\n"
	"\n"
	"    -replicates N\n"
	"        Number of replicates, defaults 4, 100, 100 for stratified,\n"
	"          diversified, resampled. With -stratified there is one\n"
	"          replicate per guide tree permutation, total is 4 x N.\n"
	"\n"
	"Generate resampled ensemble from existing ensemble by sampling columns\n"
	"with replacement:\n"
	"    muscle -resample ensemble.efa -output resampled.efa\n"
	"\n"
	"    -maxgapfract F\n"
	"       Maximum fraction of gaps in a column (F=0..1, default 0.5).\n"
	"\n"
	"    -minconf CC\n"
	"       Minimum column confidence (CC=0..1, default 0.5).\n"
	"\n"
	"If ensemble output filename has @, then one FASTA file is generated\n"
	"for each replicate where @ is replaced by perm.s, otherwise all replicates\n"
	"are written to one EFA file.\n"
	"\n"
	"Calculate disperson of an ensemble:\n"
	"    muscle -disperse ensemble.efa\n"
	"\n"
	"Extract replicate with highest total CC (diversified input recommended):\n"
	"    muscle -maxcc ensemble.efa -output maxcc.afa\n"
	"\n"
	"Extract aligned FASTA files from EFA file:\n"
	"    muscle -efa_explode ensemble.efa\n"
	"\n"
	"Convert FASTA to EFA, input has one filename per line:\n"
	"    muscle -fa2efa filenames.txt -output ensemble.efa\n"
	"\n"
	"Update ensemble by adding two sequences of digits to each replicate, digits\n"
	"are column confidence (CC) values, e.g. \"73\" means CC=0.73, \"++\" is CC=1.0:\n"
	"    muscle -addconfseq ensemble.efa -output ensemble_cc.efa\n"
	"\n"
	"Calculate letter confidence (LC) values, -ref specifies the alignment to\n"
	"compare against the ensemble (e.g. from -maxcc), output is in aligned\n"
	"FASTA format with LC values 0, 1 ... 9 instead of letters:\n"
	"    muscle -letterconf ensemble.efa -ref aln.afa -output letterconf.afa\n"
	"\n"
	"    -html aln.html\n"
	"        Alignment colored by LC in HTML format.\n"
	"\n"
	"    -jalview aln.features\n"
	"        Jalview feature file with LC values and colors.\n"
	"\n"
	"More documentation at:\n"
	"    https://drive5.com/muscle\n"
