// Software License for MTL
// 
// Copyright (c) 2007 The Trustees of Indiana University.
//               2008 Dresden University of Technology and the Trustees of Indiana University.
//               2010 SimuNova UG (haftungsbeschränkt), www.simunova.com.
// All rights reserved.
// Authors: Peter Gottschling and Andrew Lumsdaine
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.

#ifndef MTL_FILL_INCLUDE
#define MTL_FILL_INCLUDE

#include <algorithm>
#include <boost/numeric/mtl/interface/vpt.hpp>

namespace mtl {

// Sets all values of a matrix
template <class Matrix>
void fill(Matrix& ma, typename Matrix::value_type value)
{
    vampir_trace<3009> tracer;
    std::fill(ma.elements(), ma.elements()+ma.num_elements(), value);
}

// Temporary solution
// will be replaced by sequences and cursors generated by begin<all>(ma) and end<all>(ma)
// Using segmented cursors, matrices with non-contigous element storing can be handled

} // namespace mtl

#endif // MTL_FILL_INCLUDE
