#!/bin/sh
#
# Copyright (c) 2011, Peter A. Bigot, licensed under New BSD (see COPYING)
# This file is part of msp430mcu (http://sourceforge.net/projects/mspgcc/)

PREFIX=${1:-/msp430/install/dev}
DESTDIR=${DESTDIR:-}
MSP430MCU_ROOT=${MSP430MCU_ROOT:-${MSP430_ROOT:-/msp430}/msp430mcu}
UPSTREAM=${MSP430MCU_ROOT}/upstream
ANALYSIS=${MSP430MCU_ROOT}/analysis
SCRIPTS=${MSP430MCU_ROOT}/scripts
VERSION=`cat ${MSP430MCU_ROOT}/.version`
UPSTREAM_VERSION=`cat ${MSP430MCU_ROOT}/upstream/.version`

BINPATH=${PREFIX}/bin
INCPATH=${PREFIX}/msp430/include
LIBPATH=${PREFIX}/msp430/lib

mkdir -p ${DESTDIR}${INCPATH} ${DESTDIR}${LIBPATH} ${DESTDIR}${BINPATH}

# Upstream headers
install -p -m 0644 ${UPSTREAM}/*.h ${DESTDIR}${INCPATH}

# Local override headers
install -p -m 0644 ${MSP430MCU_ROOT}/include/*.h ${DESTDIR}${INCPATH}

# Override msp430.h to accommodate legacy MSPGCC MCU identifiers
install -p -m 0644 ${ANALYSIS}/msp430.h ${DESTDIR}${INCPATH}

# MCU-specific data for GCC driver program
install -p -m 0644 ${ANALYSIS}/msp430mcu.spec ${DESTDIR}${LIBPATH}

# Install MCU-specific memory and periph maps
cp -pr ${ANALYSIS}/ldscripts ${DESTDIR}${LIBPATH}
chmod -R og+rX ${DESTDIR}${LIBPATH}/ldscripts

# Install utility that tells where everything got installed
cat bin/msp430mcu-config.in \
| sed \
    -e 's!@PREFIX@!'"${PREFIX}"'!g' \
    -e 's!@SCRIPTPATH@!'"${LIBPATH}/ldscripts"'!g' \
    -e 's!@INCPATH@!'"${INCPATH}"'!g' \
    -e 's!@VERSION@!'"${VERSION}"'!g' \
    -e 's!@UPSTREAM_VERSION@!'"${UPSTREAM_VERSION}"'!g' \
> ${DESTDIR}${BINPATH}/msp430mcu-config \
&& chmod 0755 ${DESTDIR}${BINPATH}/msp430mcu-config
