# Concepts
 * [https://msdn.microsoft.com/en-us/library/dd637714.aspx](https://msdn.microsoft.com/en-us/library/dd637714.aspx)
 * [MSBuild Reserved and Well-Known Properties](https://msdn.microsoft.com/en-us/library/ms164309.aspx)
 * [Target Maps](Target-Maps)

# MSBuild Source Code
 * [https://github.com/Microsoft/MSBuild](https://github.com/Microsoft/MSBuild)
 * [https://source.dot.net](https://source.dot.net)
 * Use [http://referencesource.microsoft.com](http://referencesource.microsoft.com) or [http://source.roslyn.io](http://source.roslyn.io) to browse Microsoft MSBuild targets. Examples:
   * search for "[_FindDependencies MSBuildProperty](http://referencesource.microsoft.com/#q=_FindDependencies%20MSBuildProperty)"
   * find targets [http://referencesource.microsoft.com/#MSBuildTarget=ResolveAssemblyReferences](http://referencesource.microsoft.com/#MSBuildTarget=ResolveAssemblyReferences)

# Tips & Tricks
 * [MSBuild Tips & Tricks](MSBuild-Tips-&-Tricks)

# Tools
 * MSBuildStructuredLog
   * [https://github.com/KirillOsenkov/MSBuildStructuredLog](https://github.com/KirillOsenkov/MSBuildStructuredLog)
 * MSBuildExtensionPack
   * [http://www.msbuildextensionpack.com](http://www.msbuildextensionpack.com)
   * [https://github.com/mikefourie/MSBuildExtensionPack](https://github.com/mikefourie/MSBuildExtensionPack)
 * MSBuilder
   * [https://github.com/MobileEssentials/MSBuilder](https://github.com/MobileEssentials/MSBuilder) - reusable blocks of MSBuild helpers
 * MSBuildExplorer
   * [http://msbuildexplorer.com](http://msbuildexplorer.com)
   * [https://github.com/mikefourie/MSBuildExplorer](https://github.com/mikefourie/MSBuildExplorer)
 * MSBuild Sidekick
   * [http://attrice.info/msbuild](http://attrice.info/msbuild)
 * MSBuildDumper
   * [https://github.com/KirillOsenkov/MSBuildTools](https://github.com/KirillOsenkov/MSBuildTools) - install from Chocolatey `cinst MSBuildDumper` - very quick tool to dump properties and items of a project
 * MSBuild Profiler
   * [https://msbuildprofiler.codeplex.com/](https://msbuildprofiler.codeplex.com/)
 * MSBuild Shell Extension
   * [https://msbuildshellex.codeplex.com/](https://msbuildshellex.codeplex.com/)
 * MsBuildPipeLogger
   * [https://msbuildpipelogger.netlify.com/](https://msbuildpipelogger.netlify.com/)
   * [https://github.com/daveaglick/MsBuildPipeLogger](https://github.com/daveaglick/MsBuildPipeLogger)

# Books
 * [Inside the Microsoft Build Engine: Using MSBuild and Team Foundation Build (2nd Edition) by Sayed Hashimi, William Bartholomew](http://www.amazon.com/Inside-Microsoft-Build-Engine-Foundation/dp/0735645248)
 * [MSBuild Trickery: 99 Ways to Bend the Build Engine to Your Will, by Brian Kretzler](http://www.amazon.com/MSBuild-Trickery-Ways-Build-Engine/dp/061550907X)

# Blogs
 * [https://blogs.msdn.microsoft.com/msbuild](https://blogs.msdn.microsoft.com/msbuild)
 * [Sayed Hashimi's blog http://sedodream.com](http://sedodream.com)
 * [Mike Fourie's blog https://mikefourie.wordpress.com](https://mikefourie.wordpress.com)

![MSBuild Assemblies](https://raw.githubusercontent.com/KirillOsenkov/MSBuildStructuredLog/master/docs/MSBuildAssemblies.png)
