# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: sequencer.tcl,v 1.6 2006/01/28 19:16:59 jfontain Exp $


class sequencer {

    proc sequencer {this milliSeconds keyword list script} {
        set ($this,period) $milliSeconds
        set ($this,keyword) $keyword                                                                       ;# such as %e for example
        set ($this,list) $list
        set ($this,script) $script
        set ($this,length) [llength $list]
    }

    proc ~sequencer {this} {
        stop $this
    }

    proc start {this} {
        set ($this,index) 0
        set ($this,repeater) [new repeater $($this,period) "sequencer::next $this"]
        repeater::start $($this,repeater)
    }

    proc stop {this} {
        if {[info exists ($this,repeater)]} {
            delete $($this,repeater)
            unset ($this,repeater)
        }
    }

    proc next {this} {
        regsub -all $($this,keyword) $($this,script) [lindex $($this,list) $($this,index)] command
        uplevel #0 $command
        if {[incr ($this,index)] >= $($this,length)} {
            set ($this,index) 0
        }
    }

}
